/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.csv;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.csv.CsvFileExtensions;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.file.support.FileRepositoryCollection;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class CsvRepositoryCollection
extends FileRepositoryCollection {
    public static final String NAME = "CSV";
    static final String MAC_ZIP = "__MACOSX";
    private final File file;
    private EntityTypeFactory entityTypeFactory;
    private AttributeFactory attrMetaFactory;
    private List<String> entityTypeIds;
    private List<String> entityTypeIdsLowerCase;

    public CsvRepositoryCollection(File file) {
        this(file, null);
    }

    public CsvRepositoryCollection(File file, CellProcessor ... cellProcessors) {
        super(CsvFileExtensions.getCSV(), cellProcessors);
        this.file = file;
        this.loadEntityNames();
    }

    public void init() {
    }

    public Iterable<String> getEntityTypeIds() {
        return this.entityTypeIds;
    }

    public Repository<Entity> getRepository(String id) {
        if (!this.entityTypeIdsLowerCase.contains(id.toLowerCase())) {
            return null;
        }
        return new CsvRepository(this.file, this.entityTypeFactory, this.attrMetaFactory, id, this.cellProcessors);
    }

    private void loadEntityNames() {
        block9: {
            String extension = StringUtils.getFilenameExtension((String)this.file.getName());
            this.entityTypeIds = Lists.newArrayList();
            this.entityTypeIdsLowerCase = Lists.newArrayList();
            if (extension.equalsIgnoreCase("zip")) {
                try (ZipFile zipFile = new ZipFile(this.file);){
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (entry.getName().contains(MAC_ZIP) || entry.isDirectory()) continue;
                        String name = CsvRepositoryCollection.getRepositoryName(entry.getName());
                        this.entityTypeIds.add(name);
                        this.entityTypeIdsLowerCase.add(name.toLowerCase());
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new MolgenisDataException((Throwable)e);
                }
            }
            String name = CsvRepositoryCollection.getRepositoryName(this.file.getName());
            this.entityTypeIds.add(name);
            this.entityTypeIdsLowerCase.add(name.toLowerCase());
        }
    }

    private static String getRepositoryName(String fileName) {
        return StringUtils.stripFilenameExtension((String)StringUtils.getFilename((String)fileName));
    }

    public String getName() {
        return NAME;
    }

    public Iterator<Repository<Entity>> iterator() {
        return new Iterator<Repository<Entity>>(){
            Iterator<String> it;
            {
                this.it = CsvRepositoryCollection.this.getEntityTypeIds().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Repository<Entity> next() {
                return CsvRepositoryCollection.this.getRepository(this.it.next());
            }
        };
    }

    public boolean hasRepository(String name) {
        return this.entityTypeIds.contains(name);
    }

    public boolean hasRepository(EntityType entityType) {
        return this.hasRepository(entityType.getId());
    }

    @Autowired
    public void setEntityTypeFactory(EntityTypeFactory entityTypeFactory) {
        this.entityTypeFactory = entityTypeFactory;
    }

    @Autowired
    public void setAttributeFactory(AttributeFactory attrMetaFactory) {
        this.attrMetaFactory = attrMetaFactory;
    }
}

