/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.excel.ExcelEntity;
import org.molgenis.data.excel.ExcelUtils;
import org.molgenis.data.file.processor.AbstractCellProcessor;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;

public class ExcelRepository
extends AbstractRepository {
    private final Sheet sheet;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    private List<CellProcessor> cellProcessors;
    private Map<String, Integer> colNamesMap;
    private EntityType entityType;

    public ExcelRepository(String fileName, Sheet sheet, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this(fileName, sheet, entityTypeFactory, attrMetaFactory, null);
    }

    public ExcelRepository(String fileName, Sheet sheet, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, List<CellProcessor> cellProcessors) {
        this.sheet = Objects.requireNonNull(sheet);
        if (sheet.getNumMergedRegions() > 0) {
            throw new MolgenisDataException(String.format("Sheet [%s] contains merged regions which is not supported", sheet.getSheetName()));
        }
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.cellProcessors = cellProcessors;
    }

    public int getNrRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    public Iterator<Entity> iterator() {
        final Iterator it = this.sheet.iterator();
        if (!it.hasNext()) {
            return Collections.emptyList().iterator();
        }
        Row headerRow = (Row)it.next();
        if (this.colNamesMap == null) {
            this.colNamesMap = this.toColNamesMap(headerRow);
        }
        if (!it.hasNext()) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<Entity>(){
            ExcelEntity next = null;

            @Override
            public boolean hasNext() {
                this.getAndUpdateNext();
                return this.next != null;
            }

            @Override
            public ExcelEntity next() {
                boolean hasNext = this.hasNext();
                if (!hasNext) {
                    throw new NoSuchElementException();
                }
                ExcelEntity result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void getAndUpdateNext() {
                if (it.hasNext() && this.next == null) {
                    ExcelEntity entity = new ExcelEntity((Row)it.next(), ExcelRepository.this.colNamesMap, ExcelRepository.this.cellProcessors, ExcelRepository.this.getEntityType());
                    for (String name : entity.getAttributeNames()) {
                        if (!StringUtils.isNotEmpty((CharSequence)entity.getString(name))) continue;
                        this.next = entity;
                        break;
                    }
                    if (this.next == null) {
                        this.getAndUpdateNext();
                    }
                }
            }
        };
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            Iterator it;
            String sheetName = this.sheet.getSheetName();
            EntityType entityType = ((EntityType)this.entityTypeFactory.create((Object)sheetName)).setLabel(sheetName);
            if (this.colNamesMap == null && (it = this.sheet.iterator()).hasNext()) {
                this.colNamesMap = this.toColNamesMap((Row)it.next());
            }
            if (this.colNamesMap != null) {
                for (String colName : this.colNamesMap.keySet()) {
                    entityType.addAttribute(this.attrMetaFactory.create().setName(colName).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
                }
            }
            this.entityType = entityType;
        }
        return this.entityType;
    }

    private Map<String, Integer> toColNamesMap(Row headerRow) {
        if (headerRow == null) {
            return null;
        }
        LinkedHashMap<String, Integer> columnIdx = new LinkedHashMap<String, Integer>();
        int i = 0;
        Iterator it = headerRow.cellIterator();
        while (it.hasNext()) {
            try {
                String header = AbstractCellProcessor.processCell((String)ExcelUtils.toValue((Cell)it.next()), (boolean)true, this.cellProcessors);
                if (header == null) continue;
                if (columnIdx.containsKey(header)) {
                    throw new MolgenisDataException(String.format("Duplicate column header '%s' in sheet '%s' not allowed", header, headerRow.getSheet().getSheetName()));
                }
                columnIdx.put(header, i++);
            }
            catch (IllegalStateException ex) {
                int row = headerRow.getRowNum();
                String column = CellReference.convertNumToColString((int)i);
                throw new IllegalStateException("Invalid value at [" + this.sheet.getSheetName() + "] " + column + row + 1, ex);
            }
        }
        return columnIdx;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }
}

