/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Repository;
import org.molgenis.data.excel.ExcelFileExtensions;
import org.molgenis.data.excel.ExcelRepository;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.file.processor.TrimProcessor;
import org.molgenis.data.file.support.FileRepositoryCollection;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractWritable;
import org.springframework.beans.factory.annotation.Autowired;

public class ExcelRepositoryCollection
extends FileRepositoryCollection {
    private static final String REPOSITORY_COLLECTION_NAME = "EXCEL";
    private final String fileName;
    private final Workbook workbook;
    private EntityTypeFactory entityTypeFactory;
    private AttributeFactory attributeFactory;

    public ExcelRepositoryCollection(File file) throws IOException, MolgenisInvalidFormatException {
        this(file, new CellProcessor[]{new TrimProcessor()});
    }

    public ExcelRepositoryCollection(File file, CellProcessor ... cellProcessors) throws IOException, MolgenisInvalidFormatException {
        this(file.getName(), new FileInputStream(file), cellProcessors);
    }

    public ExcelRepositoryCollection(String name, InputStream in, CellProcessor ... cellProcessors) throws IOException, MolgenisInvalidFormatException {
        super(ExcelFileExtensions.getExcel(), cellProcessors);
        this.fileName = name;
        try {
            this.workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (InvalidFormatException e) {
            throw new MolgenisInvalidFormatException(e.getMessage());
        }
    }

    public void init() throws IOException {
    }

    public Iterable<String> getEntityTypeIds() {
        int count = this.getNumberOfSheets();
        ArrayList sheetNames = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            sheetNames.add(this.getSheetName(i));
        }
        return sheetNames;
    }

    public Repository<Entity> getRepository(String name) {
        Sheet poiSheet = this.workbook.getSheet(name);
        if (poiSheet == null) {
            return null;
        }
        return new ExcelRepository(name, poiSheet, this.entityTypeFactory, this.attributeFactory, this.cellProcessors);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public String getSheetName(int i) {
        return this.workbook.getSheetName(i);
    }

    public ExcelRepository getSheet(int i) {
        Sheet poiSheet = this.workbook.getSheetAt(i);
        if (poiSheet == null) {
            return null;
        }
        return new ExcelRepository(this.fileName, poiSheet, this.entityTypeFactory, this.attributeFactory, this.cellProcessors);
    }

    public ExcelSheetWriter createWritable(String entityTypeId, List<Attribute> attributes, AbstractWritable.AttributeWriteMode attributeWriteMode) {
        Sheet sheet = this.workbook.createSheet(entityTypeId);
        return new ExcelSheetWriter(sheet, attributes, attributeWriteMode, this.cellProcessors);
    }

    public ExcelSheetWriter createWritable(String entityTypeId, List<String> attributeNames) {
        List attributes = attributeNames != null ? attributeNames.stream().map(attrName -> this.attributeFactory.create().setName(attrName)).collect(Collectors.toList()) : null;
        return this.createWritable(entityTypeId, attributes, AbstractWritable.AttributeWriteMode.ATTRIBUTE_NAMES);
    }

    public void save(OutputStream out) throws IOException {
        this.workbook.write(out);
    }

    public String getName() {
        return REPOSITORY_COLLECTION_NAME;
    }

    public Iterator<Repository<Entity>> iterator() {
        return new Iterator<Repository<Entity>>(){
            Iterator<String> it;
            {
                this.it = ExcelRepositoryCollection.this.getEntityTypeIds().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Repository<Entity> next() {
                return ExcelRepositoryCollection.this.getRepository(this.it.next());
            }
        };
    }

    public boolean hasRepository(String name) {
        if (null == name) {
            return false;
        }
        for (String s : this.getEntityTypeIds()) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRepository(EntityType entityType) {
        return this.hasRepository(entityType.getId());
    }

    @Autowired
    public void setEntityTypeFactory(EntityTypeFactory entityTypeFactory) {
        this.entityTypeFactory = entityTypeFactory;
    }

    @Autowired
    public void setAttributeFactory(AttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }
}

