/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.LocaleUtil;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.excel.ExcelEntity;
import org.molgenis.data.excel.ExcelFileExtensions;
import org.molgenis.data.file.processor.AbstractCellProcessor;
import org.molgenis.data.file.processor.CellProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelEntity.class);

    private ExcelUtils() {
    }

    static String toValue(Cell cell) {
        return ExcelUtils.toValue(cell, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String toValue(Cell cell, List<CellProcessor> cellProcessors) {
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                String value = null;
                return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
            }
            case STRING: {
                String value = cell.getStringCellValue();
                return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
            }
            case NUMERIC: {
                String value;
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    try {
                        LocaleUtil.setUserTimeZone((TimeZone)LocaleUtil.TIMEZONE_UTC);
                        Date dateCellValue = cell.getDateCellValue();
                        value = ExcelUtils.formatUTCDateAsLocalDateTime(dateCellValue);
                        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                    }
                    finally {
                        LocaleUtil.resetUserTimeZone();
                    }
                }
                double x = cell.getNumericCellValue();
                if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                    value = String.valueOf((long)x);
                    return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                }
                value = String.valueOf(x);
                return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
            }
            case BOOLEAN: {
                String value = String.valueOf(cell.getBooleanCellValue());
                return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
            }
            case FORMULA: {
                CellValue cellValue;
                String value;
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                try {
                    cellValue = evaluator.evaluate(cell);
                }
                catch (StackOverflowError e) {
                    LOG.error("StackOverflowError evaluating formula", (Throwable)e);
                    throw new RuntimeException("Error evaluating formula, possibly due to deep formula nesting.");
                }
                switch (cellValue.getCellTypeEnum()) {
                    case BOOLEAN: {
                        value = String.valueOf(cellValue.getBooleanValue());
                        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            try {
                                LocaleUtil.setUserTimeZone((TimeZone)LocaleUtil.TIMEZONE_UTC);
                                Date javaDate = DateUtil.getJavaDate((double)cellValue.getNumberValue(), (boolean)false);
                                value = ExcelUtils.formatUTCDateAsLocalDateTime(javaDate);
                                return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                            }
                            finally {
                                LocaleUtil.resetUserTimeZone();
                            }
                        }
                        double x = cellValue.getNumberValue();
                        if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                            value = String.valueOf((long)x);
                            return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                        }
                        value = String.valueOf(x);
                        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                    }
                    case STRING: {
                        value = cellValue.getStringValue();
                        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                    }
                    case BLANK: {
                        value = null;
                        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
                    }
                }
                throw new MolgenisDataException("unsupported cell type: " + cellValue.getCellTypeEnum());
            }
        }
        throw new MolgenisDataException("unsupported cell type: " + cell.getCellTypeEnum());
    }

    public static void renameSheet(String newSheetname, File file, int index) {
        try (FileInputStream fis = new FileInputStream(file);
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            workbook.setSheetName(index, newSheetname);
            workbook.write((OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static int getNumberOfSheets(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isExcelFile(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return ExcelFileExtensions.getExcel().contains(extension);
    }

    private static String formatUTCDateAsLocalDateTime(Date javaDate) {
        LocalDateTime localDateTime = javaDate.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
        return localDateTime.toString();
    }
}

