/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.WritableFactory;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.support.AbstractWritable;

public class ExcelWriter
implements WritableFactory {
    private final Workbook workbook;
    private final OutputStream os;
    private final AttributeFactory attrMetaFactory;
    private List<CellProcessor> cellProcessors;

    public ExcelWriter(OutputStream os, AttributeFactory attrMetaFactory) {
        this(os, attrMetaFactory, FileFormat.XLS);
    }

    public ExcelWriter(OutputStream os, AttributeFactory attrMetaFactory, FileFormat format) {
        this.os = Objects.requireNonNull(os);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.workbook = Objects.requireNonNull(format) == FileFormat.XLS ? new HSSFWorkbook() : new XSSFWorkbook();
    }

    public ExcelWriter(File file, AttributeFactory attrMetaFactory) throws FileNotFoundException {
        this(new FileOutputStream(file), attrMetaFactory, FileFormat.XLS);
    }

    public ExcelWriter(File file, AttributeFactory attrMetaFactory, FileFormat format) throws FileNotFoundException {
        this(new FileOutputStream(file), attrMetaFactory, format);
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    public ExcelSheetWriter createWritable(String entityTypeId, Iterable<Attribute> attributes, AbstractWritable.AttributeWriteMode attributeWriteMode) {
        Sheet poiSheet = this.workbook.createSheet(entityTypeId);
        return new ExcelSheetWriter(poiSheet, attributes, attributeWriteMode, this.cellProcessors);
    }

    public void close() throws IOException {
        try {
            this.workbook.write(this.os);
        }
        catch (IOException e) {
            throw new MolgenisDataException("Exception writing to excel file", (Throwable)e);
        }
        this.os.close();
    }

    public ExcelSheetWriter createWritable(String entityTypeId, List<String> attributeNames) {
        List attributes = attributeNames != null ? attributeNames.stream().map(attrName -> this.attrMetaFactory.create().setName(attrName)).collect(Collectors.toList()) : null;
        return this.createWritable(entityTypeId, attributes, AbstractWritable.AttributeWriteMode.ATTRIBUTE_NAMES);
    }

    public static enum FileFormat {
        XLS,
        XLSX;

    }
}

