/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel.xlsx;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import jdk.nashorn.internal.runtime.JSType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.molgenis.data.DataConverter;
import org.molgenis.data.excel.xlsx.exception.MaximumSheetNameLengthExceededException;
import org.molgenis.data.excel.xlsx.exception.UnsupportedValueException;
import org.molgenis.data.excel.xlsx.exception.XlsxWriterException;

public class XlsxWriter
implements AutoCloseable {
    private static final int MAXIMUM_SHEET_LENGTH = 31;
    private final Path target;
    private final Workbook workbook;
    private final TimeZone timeZone;
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat simpleDateTimeFormat;

    XlsxWriter(Path target, Workbook workbook, TimeZone timeZone) {
        this.target = Objects.requireNonNull(target);
        this.workbook = Objects.requireNonNull(workbook);
        this.timeZone = Objects.requireNonNull(timeZone);
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.simpleDateFormat.setTimeZone(timeZone);
        this.simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ");
        this.simpleDateTimeFormat.setTimeZone(timeZone);
    }

    public boolean hasSheet(String name) {
        try {
            return this.workbook.getSheet(name) != null;
        }
        catch (RuntimeException e) {
            throw new XlsxWriterException(e);
        }
    }

    public void createSheet(String name, List<Object> headers) {
        block5: {
            try {
                if (name.length() <= 31) {
                    Sheet sheet = this.workbook.getSheet(name);
                    if (sheet == null) {
                        sheet = this.workbook.createSheet(name);
                        this.writeRow(headers, sheet, 0);
                    }
                    break block5;
                }
                throw new MaximumSheetNameLengthExceededException(name);
            }
            catch (MaximumSheetNameLengthExceededException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new XlsxWriterException(e);
            }
        }
    }

    public void writeRows(Stream<List<Object>> rows, String sheetName) {
        try {
            Sheet sheet = this.workbook.getSheet(sheetName);
            rows.forEach(row -> this.writeRow((List<Object>)row, sheet, sheet.getLastRowNum() + 1));
        }
        catch (RuntimeException e) {
            throw new XlsxWriterException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.workbook.write(Files.newOutputStream(this.target, new OpenOption[0]));
        }
        catch (RuntimeException e) {
            throw new XlsxWriterException(e);
        }
        finally {
            this.workbook.close();
        }
    }

    private void writeRow(List<Object> values, Sheet sheet, int rowNr) {
        Row row = sheet.createRow(rowNr);
        AtomicInteger counter = new AtomicInteger(0);
        values.forEach(record -> {
            int index = counter.getAndIncrement();
            if (record != null) {
                Cell cell = row.createCell(index);
                this.setCellValue(cell, record);
            }
        });
    }

    void setCellValue(Cell cell, Object value) {
        if (value instanceof Boolean) {
            cell.setCellValue(DataConverter.toBoolean((Object)value).booleanValue());
        } else if (value instanceof LocalDate) {
            Instant instant = DataConverter.toLocalDate((Object)value).atStartOfDay(this.timeZone.toZoneId()).toInstant();
            cell.setCellValue(this.simpleDateFormat.format(Date.from(instant)));
        } else if (value instanceof Instant) {
            cell.setCellValue(this.simpleDateTimeFormat.format(Date.from((Instant)value)));
        } else if (value instanceof Double) {
            cell.setCellValue(DataConverter.toDouble((Object)value).doubleValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)DataConverter.toInt((Object)value).intValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)JSType.toLong((Object)value));
        } else if (value instanceof String) {
            cell.setCellValue(value.toString());
        } else {
            throw new UnsupportedValueException(value);
        }
    }
}

