/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.migrate.bootstrap;

import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.data.migrate.framework.MolgenisUpgradeService;
import org.molgenis.data.migrate.version.Step33UpdateForeignKeyDeferred;
import org.molgenis.data.migrate.version.Step34AddRoleMetrics;
import org.molgenis.data.migrate.version.Step35UpdateAclSystemSid;
import org.molgenis.data.migrate.version.Step36EnableDataRowEdit;
import org.molgenis.data.migrate.version.Step37AddSettingsPluginToMenu;
import org.molgenis.data.migrate.version.Step38AddAnonymouseRoleToDb;
import org.molgenis.data.migrate.version.Step39CreateRootPackageGroups;
import org.molgenis.data.migrate.version.Step40AddRoleSystem;
import org.springframework.stereotype.Component;

@Component
public class MolgenisUpgradeBootstrapper {
    private final MolgenisUpgradeService upgradeService;
    private final DataSource dataSource;

    public MolgenisUpgradeBootstrapper(MolgenisUpgradeService upgradeService, DataSource dataSource) {
        this.upgradeService = Objects.requireNonNull(upgradeService);
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    public void bootstrap() {
        this.upgradeService.addUpgrade(new Step33UpdateForeignKeyDeferred(this.dataSource));
        this.upgradeService.addUpgrade(new Step34AddRoleMetrics(this.dataSource));
        this.upgradeService.addUpgrade(new Step35UpdateAclSystemSid(this.dataSource));
        this.upgradeService.addUpgrade(new Step36EnableDataRowEdit(this.dataSource));
        this.upgradeService.addUpgrade(new Step37AddSettingsPluginToMenu(this.dataSource));
        this.upgradeService.addUpgrade(new Step38AddAnonymouseRoleToDb(this.dataSource));
        this.upgradeService.addUpgrade(new Step39CreateRootPackageGroups(this.dataSource));
        this.upgradeService.addUpgrade(new Step40AddRoleSystem(this.dataSource));
        this.upgradeService.upgrade();
    }
}

