/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.migrate.version;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.migrate.framework.MolgenisUpgrade;
import org.molgenis.data.migrate.framework.MolgenisUpgradeService;
import org.molgenis.data.migrate.version.MolgenisVersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MolgenisUpgradeServiceImpl
implements MolgenisUpgradeService {
    private static final Logger LOG = LoggerFactory.getLogger(MolgenisUpgradeServiceImpl.class);
    private final MolgenisVersionService versionService;
    private final List<MolgenisUpgrade> upgrades = new ArrayList<MolgenisUpgrade>();

    public MolgenisUpgradeServiceImpl(MolgenisVersionService versionService) {
        this.versionService = Objects.requireNonNull(versionService);
    }

    @Override
    public void addUpgrade(MolgenisUpgrade upgrade) {
        this.upgrades.add(upgrade);
    }

    @Override
    public boolean upgrade() {
        int schemaVersion = this.versionService.getSchemaVersion();
        if (schemaVersion < 31) {
            throw new UnsupportedOperationException("Upgrading from schema version below 31 is not supported");
        }
        if (schemaVersion < this.versionService.getAppVersion()) {
            LOG.info("Metadata version:{}, current version:{} upgrade needed", (Object)schemaVersion, (Object)this.versionService.getAppVersion());
            this.upgrades.stream().filter(upgrade -> upgrade.getFromVersion() >= schemaVersion).forEach(this::runUpgrade);
            this.versionService.setSchemaVersion(this.versionService.getAppVersion());
            LOG.info("Metadata upgrade done.");
            return true;
        }
        LOG.debug("Metadata version:{}, current version:{} upgrade not needed", (Object)schemaVersion, (Object)this.versionService.getAppVersion());
        return false;
    }

    private void runUpgrade(MolgenisUpgrade upgrade) {
        LOG.info("Upgrading from {} to {}...", (Object)upgrade.getFromVersion(), (Object)upgrade.getToVersion());
        upgrade.upgrade();
        LOG.debug("Upgraded from {} to {}.", (Object)upgrade.getFromVersion(), (Object)upgrade.getToVersion());
        this.versionService.setSchemaVersion(upgrade.getToVersion());
    }
}

