/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.migrate.version;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.molgenis.util.UncheckedSqlException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class MolgenisVersionService {
    static final int VERSION = 40;
    private final DataSource dataSource;

    MolgenisVersionService(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    @PostConstruct
    public void init() {
        if (!this.versionTableExist()) {
            try (Connection connection = this.dataSource.getConnection();){
                this.createVersionTable(connection);
                this.createVersionTableRow(connection);
            }
            catch (SQLException e) {
                throw new UncheckedSqlException(e);
            }
        }
    }

    private boolean versionTableExist() {
        try {
            return (Boolean)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, dbmd -> {
                ResultSet tables = dbmd.getTables(null, null, "Version", new String[]{"TABLE"});
                return tables.first();
            });
        }
        catch (MetaDataAccessException e) {
            return false;
        }
    }

    private void createVersionTable(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String createVersionTableSql = "CREATE TABLE \"Version\" (\"id\" integer PRIMARY KEY)";
            statement.execute(createVersionTableSql);
        }
    }

    private void createVersionTableRow(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String insertVersionRow = "INSERT INTO \"Version\" (\"id\") VALUES(40)";
            statement.execute(insertVersionRow);
        }
    }

    int getAppVersion() {
        return 40;
    }

    int getSchemaVersion() {
        int version;
        block21: {
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                String selectVersionSql = "SELECT \"id\" FROM \"Version\"";
                try (ResultSet resultSet = statement.executeQuery(selectVersionSql);){
                    if (resultSet.next()) {
                        version = resultSet.getInt("id");
                        break block21;
                    }
                    throw new SQLException("Expected non-empty result set");
                }
            }
            catch (SQLException e) {
                throw new UncheckedSqlException(e);
            }
        }
        return version;
    }

    void setSchemaVersion(int version) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE \"Version\" SET \"id\"=?");){
            statement.setInt(1, version);
            statement.execute();
        }
        catch (SQLException e) {
            throw new UncheckedSqlException(e);
        }
    }
}

