/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.migrate.version;

import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.data.migrate.framework.MolgenisUpgrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class Step37AddSettingsPluginToMenu
extends MolgenisUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(Step37AddSettingsPluginToMenu.class);
    private final DataSource dataSource;

    public Step37AddSettingsPluginToMenu(DataSource dataSource) {
        super(36, 37);
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    @Override
    public void upgrade() {
        LOG.debug("Adding the settings plugin to the menu ...");
        this.addSettingsPluginToMenu();
    }

    private void addSettingsPluginToMenu() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String menuString = this.getMenuString(jdbcTemplate);
        if (Step37AddSettingsPluginToMenu.hasSettingsPlugin(menuString)) {
            LOG.info("Settings plugin already in the menu. No further action required.");
        } else {
            String newMenu = Step37AddSettingsPluginToMenu.replaceOldPlugin(menuString);
            Step37AddSettingsPluginToMenu.updateMenuInDatabase(jdbcTemplate, newMenu);
            LOG.info("Added settings plugin to the menu.");
        }
    }

    private static boolean hasSettingsPlugin(String menuString) {
        return menuString.contains("\"type\":\"plugin\",\"id\":\"settings\"");
    }

    private static String replaceOldPlugin(String menuString) {
        return menuString.replace("\"type\":\"plugin\",\"id\":\"settingsmanager\"", "\"type\":\"plugin\",\"id\":\"settings\"");
    }

    private String getMenuString(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.queryForObject("SELECT molgenis_menu FROM public.\"sys_set_app#4f91996f\"", String.class);
    }

    private static void updateMenuInDatabase(JdbcTemplate jdbcTemplate, String menuString) {
        jdbcTemplate.update("UPDATE public.\"sys_set_app#4f91996f\" SET \"molgenis_menu\" = ?", new Object[]{menuString});
    }
}

