/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.migrate.version;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.data.migrate.framework.MolgenisUpgrade;
import org.molgenis.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class Step39CreateRootPackageGroups
extends MolgenisUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(Step39CreateRootPackageGroups.class);
    private final DataSource dataSource;

    public Step39CreateRootPackageGroups(DataSource dataSource) {
        super(38, 39);
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    @Override
    public void upgrade() {
        LOG.debug("Creating groups for root packages without associated group ...");
        try {
            this.createRootPackageGroups();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LOG.info("Created groups for root packages without associated group");
    }

    private void createRootPackageGroups() throws IOException {
        String sql = ResourceUtils.getString((String)"step39-createRootPackageGroups.sql");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.execute(sql);
    }
}

