"use strict";
/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 4.3.0
 * @date    2018-05-21
 *
 * @license
 * Copyright (C) 2013-2018 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 4.3.0
 * @date    2018-05-21
 *
 * @license
 * Copyright (C) 2013-2018 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.math=t():e.math=t()}(this,function(){return function(r){var n={};function i(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return r[e].call(t.exports,t,t.exports,i),t.l=!0,t.exports}return i.m=r,i.c=n,i.d=function(e,t,r){i.o(e,t)||Object.defineProperty(e,t,{configurable:!1,enumerable:!0,get:r})},i.r=function(e){Object.defineProperty(e,"__esModule",{value:!0})},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=560)}([function(e,t,r){e.exports=function t(e,r,n){return e&&"function"==typeof e.map?e.map(function(e){return t(e,r,n)}):r(e)}},function(e,t,r){t.name="matrix",t.factory=function(n,e,t,r){var i=r("matrix",{"":function(){return a([])},string:function(e){return a([],e)},"string, string":function(e,t){return a([],e,t)},Array:function(e){return a(e)},Matrix:function(e){return a(e,e.storage())},"Array | Matrix, string":a,"Array | Matrix, string, string":a});return i.toTex={0:"\\begin{bmatrix}\\end{bmatrix}",1:"\\left(${args[0]}\\right)",2:"\\left(${args[0]}\\right)"},i;function a(e,t,r){return new(n.Matrix.storage(t||"default"))(e,r)}}},function(e,o,t){var n=t(3),i=t(9),u=t(11),r=t(61);o.size=function(e){for(var t=[];Array.isArray(e);)t.push(e.length),e=e[0];return t},o.validate=function(e,t){if(0==t.length){if(Array.isArray(e))throw new u(e.length,0)}else!function e(t,r,n){var i,a=t.length;if(a!=r[n])throw new u(a,r[n]);if(n<r.length-1){var o=n+1;for(i=0;i<a;i++){var s=t[i];if(!Array.isArray(s))throw new u(r.length-1,r.length,"<");e(t[i],r,o)}}else for(i=0;i<a;i++)if(Array.isArray(t[i]))throw new u(r.length+1,r.length,">")}(e,t,0)},o.validateIndex=function(e,t){if(!n.isNumber(e)||!n.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(e<0||"number"==typeof t&&t<=e)throw new r(e,t)},o.resize=function(e,t,r){if(!Array.isArray(e)||!Array.isArray(t))throw new TypeError("Array expected");if(0===t.length)throw new Error("Resizing to scalar is not supported");return t.forEach(function(e){if(!n.isNumber(e)||!n.isInteger(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+i.format(t)+")")}),function e(t,r,n,i){var a;var o;var s=t.length;var u=r[n];var c=Math.min(s,u);t.length=u;if(n<r.length-1){var f=n+1;for(a=0;a<c;a++)o=t[a],Array.isArray(o)||(o=[o],t[a]=o),e(o,r,f,i);for(a=c;a<u;a++)o=[],t[a]=o,e(o,r,f,i)}else{for(a=0;a<c;a++)for(;Array.isArray(t[a]);)t[a]=t[a][0];for(a=c;a<u;a++)t[a]=i}}(e,t,0,void 0!==r?r:0),e},o.reshape=function(t,r){var e,n=o.flatten(t),i=function(e){return e.reduce(function(e,t){return e*t})};if(!Array.isArray(t)||!Array.isArray(r))throw new TypeError("Array expected");if(0===r.length)throw new u(0,i(o.size(t)),"!=");try{e=function e(t,r){var n=[];var i;if(0===r.length){if(0===t.length)throw new u(null,null,"!=");return t.shift()}for(i=0;i<r[0];i+=1)n.push(e(t,r.slice(1)));return n}(n,r)}catch(e){if(e instanceof u)throw new u(i(r),i(o.size(t)),"!=");throw e}if(0<n.length)throw new u(i(r),i(o.size(t)),"!=");return e},o.squeeze=function(e,t){for(var r=t||o.size(e);Array.isArray(e)&&1===e.length;)e=e[0],r.shift();for(var n=r.length;1===r[n-1];)n--;return n<r.length&&(e=function e(t,r,n){var i,a;if(n<r){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(;Array.isArray(t);)t=t[0];return t}(e,n,0),r.length=n),e},o.unsqueeze=function(e,t,r,n){var i=n||o.size(e);if(r)for(var a=0;a<r;a++)e=[e],i.unshift(1);for(e=function e(t,r,n){var i,a;if(Array.isArray(t)){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(var s=n;s<r;s++)t=[t];return t}(e,t,0);i.length<t;)i.push(1);return e},o.flatten=function(e){if(!Array.isArray(e))return e;var r=[];return e.forEach(function e(t){Array.isArray(t)?t.forEach(e):r.push(t)}),r},o.map=function(e,t){return Array.prototype.map.call(e,t)},o.forEach=function(e,t){Array.prototype.forEach.call(e,t)},o.filter=function(e,t){if(1!==o.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,t)},o.filterRegExp=function(e,t){if(1!==o.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,function(e){return t.test(e)})},o.join=function(e,t){return Array.prototype.join.call(e,t)},o.identify=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;var t=[],r=0;t[0]={value:e[0],identifier:0};for(var n=1;n<e.length;n++)e[n]===e[n-1]?r++:r=0,t.push({value:e[n],identifier:r});return t},o.generalize=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;for(var t=[],r=0;r<e.length;r++)t.push(e[r].value);return t},o.isArray=Array.isArray},function(e,p,t){function m(e){for(var t=[],r=0;r<e;r++)t.push(0);return t}p.isNumber=function(e){return"number"==typeof e},p.isInteger=function(e){return!!isFinite(e)&&e==Math.round(e)},p.sign=Math.sign||function(e){return 0<e?1:e<0?-1:0},p.format=function(e,t){if("function"==typeof t)return t(e);if(e===1/0)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var r="auto",n=void 0;switch(t&&(t.notation&&(r=t.notation),p.isNumber(t)?n=t:t.precision&&(n=t.precision)),r){case"fixed":return p.toFixed(e,n);case"exponential":return p.toExponential(e,n);case"engineering":return p.toEngineering(e,n);case"auto":if(t&&t.exponential&&(void 0!==t.exponential.lower||void 0!==t.exponential.upper)){var i=Object.assign({},t);return(i.exponential=void 0)!==t.exponential.lower&&(i.lowerExp=Math.round(Math.log(t.exponential.lower)/Math.LN10)),void 0!==t.exponential.upper&&(i.upperExp=Math.round(Math.log(t.exponential.upper)/Math.LN10)),console.warn("Deprecation warning: Formatting options exponential.lower and exponential.upper (minimum and maximum value) are replaced with exponential.lowerExp and exponential.upperExp (minimum and maximum exponent) since version 4.0.0. Replace "+JSON.stringify(t)+" with "+JSON.stringify(i)),p.toPrecision(e,n,i)}return p.toPrecision(e,n,t&&t).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+r+'". Choose "auto", "exponential", or "fixed".')}},p.splitNumber=function(e){var t=String(e).toLowerCase().match(/^0*?(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);if(!t)throw new SyntaxError("Invalid number "+e);var r=t[1],n=t[2],i=parseFloat(t[4]||"0"),a=n.indexOf(".");i+=-1!==a?a-1:n.length-1;var o=n.replace(".","").replace(/^0*/,function(e){return i-=e.length,""}).replace(/0*$/,"").split("").map(function(e){return parseInt(e)});return 0===o.length&&(o.push(0),i++),{sign:r,coefficients:o,exponent:i}},p.toEngineering=function(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=p.roundDigits(p.splitNumber(e),t),n=r.exponent,i=r.coefficients,a=n%3==0?n:n<0?n-3-n%3:n-n%3,o=0<=n?n:Math.abs(a);i.length-1<o&&(i=i.concat(m(o-(i.length-1))));for(var s=Math.abs(n-a),u=1;0<=--s;)u++;var c=i.slice(u).join(""),f=c.match(/[1-9]/)?"."+c:"",l=i.slice(0,u).join("")+f+"e"+(0<=n?"+":"")+a.toString();return r.sign+l},p.toFixed=function(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=p.splitNumber(e),n="number"==typeof t?p.roundDigits(r,r.exponent+1+t):r,i=n.coefficients,a=n.exponent+1,o=a+(t||0);return i.length<o&&(i=i.concat(m(o-i.length))),a<0&&(i=m(1-a).concat(i),a=1),a<i.length&&i.splice(a,0,0===a?"0.":"."),n.sign+i.join("")},p.toExponential=function(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=p.splitNumber(e),n=t?p.roundDigits(r,t):r,i=n.coefficients,a=n.exponent;i.length<t&&(i=i.concat(m(t-i.length)));var o=i.shift();return n.sign+o+(0<i.length?"."+i.join(""):"")+"e"+(0<=a?"+":"")+a},p.toPrecision=function(e,t,r){if(isNaN(e)||!isFinite(e))return String(e);var n=r&&void 0!==r.lowerExp?r.lowerExp:-3,i=r&&void 0!==r.upperExp?r.upperExp:5,a=p.splitNumber(e);if(a.exponent<n||a.exponent>=i)return p.toExponential(e,t);var o=t?p.roundDigits(a,t):a,s=o.coefficients,u=o.exponent;s.length<t&&(s=s.concat(m(t-s.length))),s=s.concat(m(u-s.length+1+(s.length<t?t-s.length:0)));var c=0<u?u:0;return c<(s=m(-u).concat(s)).length-1&&s.splice(c+1,0,"."),o.sign+s.join("")},p.roundDigits=function(e,t){for(var r={sign:e.sign,coefficients:e.coefficients,exponent:e.exponent},n=r.coefficients;t<=0;)n.unshift(0),r.exponent++,t++;if(n.length>t&&5<=n.splice(t,n.length-t)[0]){var i=t-1;for(n[i]++;10===n[i];)n.pop(),0===i&&(n.unshift(0),r.exponent++,i++),n[--i]++}return r},p.digits=function(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length},p.DBL_EPSILON=Number.EPSILON||2220446049250313e-31,p.nearlyEqual=function(e,t,r){if(null==r)return e==t;if(e==t)return!0;if(isNaN(e)||isNaN(t))return!1;if(isFinite(e)&&isFinite(t)){var n=Math.abs(e-t);return n<p.DBL_EPSILON||n<=Math.max(Math.abs(e),Math.abs(t))*r}return!1}},function(e,r,t){var n=t(538);r.symbols={Alpha:"A",alpha:"\\alpha",Beta:"B",beta:"\\beta",Gamma:"\\Gamma",gamma:"\\gamma",Delta:"\\Delta",delta:"\\delta",Epsilon:"E",epsilon:"\\epsilon",varepsilon:"\\varepsilon",Zeta:"Z",zeta:"\\zeta",Eta:"H",eta:"\\eta",Theta:"\\Theta",theta:"\\theta",vartheta:"\\vartheta",Iota:"I",iota:"\\iota",Kappa:"K",kappa:"\\kappa",varkappa:"\\varkappa",Lambda:"\\Lambda",lambda:"\\lambda",Mu:"M",mu:"\\mu",Nu:"N",nu:"\\nu",Xi:"\\Xi",xi:"\\xi",Omicron:"O",omicron:"o",Pi:"\\Pi",pi:"\\pi",varpi:"\\varpi",Rho:"P",rho:"\\rho",varrho:"\\varrho",Sigma:"\\Sigma",sigma:"\\sigma",varsigma:"\\varsigma",Tau:"T",tau:"\\tau",Upsilon:"\\Upsilon",upsilon:"\\upsilon",Phi:"\\Phi",phi:"\\phi",varphi:"\\varphi",Chi:"X",chi:"\\chi",Psi:"\\Psi",psi:"\\psi",Omega:"\\Omega",omega:"\\omega",true:"\\mathrm{True}",false:"\\mathrm{False}",i:"i",inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:"\\lim",undefined:"\\mathbf{?}"},r.operators={transpose:"^\\top",factorial:"!",pow:"^",dotPow:".^\\wedge",unaryPlus:"+",unaryMinus:"-",bitNot:"~",not:"\\neg",multiply:"\\cdot",divide:"\\frac",dotMultiply:".\\cdot",dotDivide:".:",mod:"\\mod",add:"+",subtract:"-",to:"\\rightarrow",leftShift:"<<",rightArithShift:">>",rightLogShift:">>>",equal:"=",unequal:"\\neq",smaller:"<",larger:">",smallerEq:"\\leq",largerEq:"\\geq",bitAnd:"\\&",bitXor:"\\underline{|}",bitOr:"|",and:"\\wedge",xor:"\\veebar",or:"\\vee"},r.defaultTemplate="\\mathrm{${name}}\\left(${args}\\right)";var i={deg:"^\\circ"};r.escape=function(e){return n(e,{preserveFormatting:!0})},r.toSymbol=function(e,t){return(t=void 0!==t&&t)?i.hasOwnProperty(e)?i[e]:"\\mathrm{"+r.escape(e)+"}":r.symbols.hasOwnProperty(e)?r.symbols[e]:r.escape(e)}},function(e,a,t){var n=t(90);a.clone=function t(e){var r=typeof e;if("number"===r||"string"===r||"boolean"===r||null==e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(function(e){return t(e)});if(e instanceof Number)return new Number(e.valueOf());if(e instanceof String)return new String(e.valueOf());if(e instanceof Boolean)return new Boolean(e.valueOf());if(e instanceof Date)return new Date(e.valueOf());if(n(e))return e;if(e instanceof RegExp)throw new TypeError("Cannot clone "+e);return a.map(e,t)},a.map=function(e,t){var r={};for(var n in e)a.hasOwnProperty(e,n)&&(r[n]=t(e[n]));return r},a.extend=function(e,t){for(var r in t)a.hasOwnProperty(t,r)&&(e[r]=t[r]);return e},a.deepExtend=function e(t,r){if(Array.isArray(r))throw new TypeError("Arrays are not supported by deepExtend");for(var n in r)if(a.hasOwnProperty(r,n))if(r[n]&&r[n].constructor===Object)void 0===t[n]&&(t[n]={}),t[n].constructor===Object?e(t[n],r[n]):t[n]=r[n];else{if(Array.isArray(r[n]))throw new TypeError("Arrays are not supported by deepExtend");t[n]=r[n]}return t},a.deepEqual=function(e,t){var r,n,i;if(Array.isArray(e)){if(!Array.isArray(t))return!1;if(e.length!=t.length)return!1;for(n=0,i=e.length;n<i;n++)if(!a.deepEqual(e[n],t[n]))return!1;return!0}if(e instanceof Object){if(Array.isArray(t)||!(t instanceof Object))return!1;for(r in e)if(!a.deepEqual(e[r],t[r]))return!1;for(r in t)if(!a.deepEqual(e[r],t[r]))return!1;return!0}return typeof e==typeof t&&e==t},a.canDefineProperty=function(){try{if(Object.defineProperty)return Object.defineProperty({},"x",{get:function(){}}),!0}catch(e){}return!1},a.lazy=function(e,t,r){if(a.canDefineProperty()){var n,i=!0;Object.defineProperty(e,t,{get:function(){return i&&(n=r(),i=!1),n},set:function(e){n=e,i=!1},configurable:!0,enumerable:!0})}else e[t]=r()},a.traverse=function(e,t){var r=e;if(t)for(var n=t.split("."),i=0;i<n.length;i++){var a=n[i];a in r||(r[a]={}),r=r[a]}return r},a.hasOwnProperty=function(e,t){return e&&Object.hasOwnProperty.call(e,t)},a.isFactory=function(e){return e&&"function"==typeof e.factory}},function(e,t,r){var m=r(5).clone;t.name="algorithm14",t.factory=function(e,t,r,f){var l=e.DenseMatrix,p=function(e,t,r,n,i,a,o){var s=[];if(t===r.length-1)for(var u=0;u<n;u++)s[u]=o?e(a,i[u]):e(i[u],a);else for(var c=0;c<n;c++)s[c]=p(e,t+1,r,r[t+1],i[c],a,o);return s};return function(e,t,r,n){var i,a=e._data,o=e._size,s=e._datatype,u=r;"string"==typeof s&&(i=s,t=f.convert(t,i),u=f.find(r,[i,i]));var c=0<o.length?p(u,0,o,o[0],a,t,n):[];return new l({data:c,size:m(o),datatype:i})}}},function(e,t,r){var n=r(29),v=r(11);n.string.isString;t.name="algorithm13",t.factory=function(e,t,r,h){var d=e.DenseMatrix,g=function(e,t,r,n,i,a){var o=[];if(t===r.length-1)for(var s=0;s<n;s++)o[s]=e(i[s],a[s]);else for(var u=0;u<n;u++)o[u]=g(e,t+1,r,r[t+1],i[u],a[u]);return o};return function(e,t,r){var n,i=e._data,a=e._size,o=e._datatype,s=t._data,u=t._size,c=t._datatype,f=[];if(a.length!==u.length)throw new v(a.length,u.length);for(var l=0;l<a.length;l++){if(a[l]!==u[l])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+u+")");f[l]=a[l]}var p=r;"string"==typeof o&&o===c&&(n=o,t=h.convert(t,n),p=h.find(r,[n,n]));var m=0<f.length?g(p,0,f,f[0],i,s):[];return new d({data:m,size:f,datatype:n})}}},function(e,t,h){var d=h(5).extend,g=h(2);t.name="multiply",t.factory=function(n,e,t,U){var r=h(4),i=t(h(1)),k=t(h(20)),q=t(h(21)),P=t(h(10)),a=t(h(17)),o=t(h(6)),w=n.DenseMatrix,D=n.SparseMatrix,s=U("multiply",d({"Array, Array":function(e,t){u(g.size(e),g.size(t));var r=s(i(e),i(t));return n.isMatrix(r)?r.valueOf():r},"Matrix, Matrix":function(e,t){var r=e.size(),n=t.size();return u(r,n),1===r.length?1===n.length?c(e,t,r[0]):f(e,t):1===n.length?p(e,t):m(e,t)},"Matrix, Array":function(e,t){return s(e,i(t))},"Array, Matrix":function(e,t){return s(i(e,t.storage()),t)},"SparseMatrix, any":function(e,t){return a(e,t,q,!1)},"DenseMatrix, any":function(e,t){return o(e,t,q,!1)},"any, SparseMatrix":function(e,t){return a(t,e,q,!0)},"any, DenseMatrix":function(e,t){return o(t,e,q,!0)},"Array, any":function(e,t){return o(i(e),t,q,!1).valueOf()},"any, Array":function(e,t){return o(i(t),e,q,!0).valueOf()},"any, any":q,"any, any, ...any":function(e,t,r){for(var n=s(e,t),i=0;i<r.length;i++)n=s(n,r[i]);return n}},q.signatures)),u=function(e,t){switch(e.length){case 1:switch(t.length){case 1:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vectors must have the same length");break;case 2:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vector length ("+e[0]+") must match Matrix rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;case 2:switch(t.length){case 1:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix columns ("+e[1]+") must match Vector length ("+t[0]+")");break;case 2:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix A columns ("+e[1]+") must match Matrix B rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix A has "+e.length+" dimensions)")}},c=function(e,t,r){if(0===r)throw new Error("Cannot multiply two empty vectors");var n,i=e._data,a=e._datatype,o=t._data,s=t._datatype,u=k,c=q;a&&s&&a===s&&"string"==typeof a&&(n=a,u=U.find(k,[n,n]),c=U.find(q,[n,n]));for(var f=c(i[0],o[0]),l=1;l<r;l++)f=u(f,c(i[l],o[l]));return f},f=function(e,t){if("dense"!==t.storage())throw new Error("Support for SparseMatrix not implemented");return l(e,t)},l=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._size,u=t._datatype,c=i[0],f=s[1],l=k,p=q;a&&u&&a===u&&"string"==typeof a&&(r=a,l=U.find(k,[r,r]),p=U.find(q,[r,r]));for(var m=[],h=0;h<f;h++){for(var d=p(n[0],o[0][h]),g=1;g<c;g++)d=l(d,p(n[g],o[g][h]));m[h]=d}return new w({data:m,size:[f],datatype:r})},p=U("_multiplyMatrixVector",{"DenseMatrix, any":function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._datatype,u=i[0],c=i[1],f=k,l=q;a&&s&&a===s&&"string"==typeof a&&(r=a,f=U.find(k,[r,r]),l=U.find(q,[r,r]));for(var p=[],m=0;m<u;m++){for(var h=n[m],d=l(h[0],o[0]),g=1;g<c;g++)d=f(d,l(h[g],o[g]));p[m]=d}return new w({data:p,size:[u],datatype:r})},"SparseMatrix, any":function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var o,s=t._data,u=t._datatype,c=e._size[0],f=t._size[0],l=[],p=[],m=[],h=k,d=q,g=P,v=0;a&&u&&a===u&&"string"==typeof a&&(o=a,h=U.find(k,[o,o]),d=U.find(q,[o,o]),g=U.find(P,[o,o]),v=U.convert(0,o));for(var y=[],x=[],w=m[0]=0;w<f;w++){var b=s[w];if(!g(b,v))for(var N=i[w],M=i[w+1],E=N;E<M;E++){var A=n[E];x[A]?y[A]=h(y[A],d(b,r[E])):(x[A]=!0,p.push(A),y[A]=d(b,r[E]))}}for(var O=p.length,S=0;S<O;S++){var _=p[S];l[S]=y[_]}return m[1]=p.length,new D({values:l,index:p,ptr:m,size:[c,1],datatype:o})}}),m=U("_multiplyMatrixMatrix",{"DenseMatrix, DenseMatrix":function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._size,u=t._datatype,c=i[0],f=i[1],l=s[1],p=k,m=q;a&&u&&a===u&&"string"==typeof a&&(r=a,p=U.find(k,[r,r]),m=U.find(q,[r,r]));for(var h=[],d=0;d<c;d++){var g=n[d];h[d]=[];for(var v=0;v<l;v++){for(var y=m(g[0],o[0][v]),x=1;x<f;x++)y=p(y,m(g[x],o[x][v]));h[d][v]=y}}return new w({data:h,size:[c,l],datatype:r})},"DenseMatrix, SparseMatrix":function(e,t){var r=e._data,n=e._size,i=e._datatype,a=t._values,o=t._index,s=t._ptr,u=t._size,c=t._datatype;if(!a)throw new Error("Cannot multiply Dense Matrix times Pattern only Matrix");var f,l=n[0],p=u[1],m=k,h=q,d=P,g=0;i&&c&&i===c&&"string"==typeof i&&(f=i,m=U.find(k,[f,f]),h=U.find(q,[f,f]),d=U.find(P,[f,f]),g=U.convert(0,f));for(var v=[],y=[],x=[],w=new D({values:v,index:y,ptr:x,size:[l,p],datatype:f}),b=0;b<p;b++){x[b]=y.length;var N=s[b],M=s[b+1];if(N<M)for(var E=0,A=0;A<l;A++){for(var O,S=A+1,_=N;_<M;_++){var T=o[_];E!==S?(O=h(r[A][T],a[_]),E=S):O=m(O,h(r[A][T],a[_]))}E!==S||d(O,g)||(y.push(A),v.push(O))}}return x[p]=y.length,w},"SparseMatrix, DenseMatrix":function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var o,s=t._data,u=t._datatype,c=e._size[0],f=t._size[0],l=t._size[1],p=k,m=q,h=P,d=0;a&&u&&a===u&&"string"==typeof a&&(o=a,p=U.find(k,[o,o]),m=U.find(q,[o,o]),h=U.find(P,[o,o]),d=U.convert(0,o));for(var g=[],v=[],y=[],x=new D({values:g,index:v,ptr:y,size:[c,l],datatype:o}),w=[],b=[],N=0;N<l;N++){y[N]=v.length;for(var M=N+1,E=0;E<f;E++){var A=s[E][N];if(!h(A,d))for(var O=i[E],S=i[E+1],_=O;_<S;_++){var T=n[_];b[T]!==M?(b[T]=M,v.push(T),w[T]=m(A,r[_])):w[T]=p(w[T],m(A,r[_]))}}for(var C=y[N],z=v.length,B=C;B<z;B++){var I=v[B];g[B]=w[I]}}return y[l]=v.length,x},"SparseMatrix, SparseMatrix":function(e,t){var r,n=e._values,i=e._index,a=e._ptr,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._datatype,l=e._size[0],p=t._size[1],m=n&&s,h=k,d=q;o&&f&&o===f&&"string"==typeof o&&(r=o,h=U.find(k,[r,r]),d=U.find(q,[r,r]));for(var g,v,y,x,w,b,N,M,E=m?[]:void 0,A=[],O=[],S=new D({values:E,index:A,ptr:O,size:[l,p],datatype:r}),_=m?[]:void 0,T=[],C=0;C<p;C++){O[C]=A.length;var z=C+1;for(w=c[C],b=c[C+1],x=w;x<b;x++)if(M=u[x],m)for(v=a[M],y=a[M+1],g=v;g<y;g++)N=i[g],T[N]!==z?(T[N]=z,A.push(N),_[N]=d(s[x],n[g])):_[N]=h(_[N],d(s[x],n[g]));else for(v=a[M],y=a[M+1],g=v;g<y;g++)N=i[g],T[N]!==z&&(T[N]=z,A.push(N));if(m)for(var B=O[C],I=A.length,P=B;P<I;P++){var R=A[P];E[P]=_[R]}}return O[p]=A.length,S}});return s.toTex={2:"\\left(${args[0]}"+r.operators.multiply+"${args[1]}\\right)"},s}},function(e,o,t){var a=t(3).format,s=t(543).format,u=t(90);o.isString=function(e){return"string"==typeof e},o.endsWith=function(e,t){var r=e.length-t.length,n=e.length;return e.substring(r,n)===t},o.format=function(e,t){if("number"==typeof e)return a(e,t);if(u(e))return s(e,t);if((r=e)&&"object"==typeof r&&"number"==typeof r.s&&"number"==typeof r.n&&"number"==typeof r.d)return t&&"decimal"===t.fraction?e.toString():e.s*e.n+"/"+e.d;var r;if(Array.isArray(e))return function e(t,r){{if(Array.isArray(t)){for(var n="[",i=t.length,a=0;a<i;a++)0!=a&&(n+=", "),n+=e(t[a],r);return n+="]"}return o.format(t,r)}}(e,t);if(o.isString(e))return'"'+e+'"';if("function"==typeof e)return e.syntax?String(e.syntax):"function";if(e&&"object"==typeof e){if("function"==typeof e.format)return e.format(t);if(e&&e.toString()!=={}.toString())return e.toString();var n=[];for(var i in e)e.hasOwnProperty(i)&&n.push('"'+i+'": '+o.format(e[i],t));return"{"+n.join(", ")+"}"}return String(e)},o.stringify=function(e){for(var t=String(e),r="",n=0;n<t.length;){var i=t.charAt(n);"\\"===i?(r+=i,n++,""!==(i=t.charAt(n))&&-1!=='"\\/bfnrtu'.indexOf(i)||(r+="\\"),r+=i):r+='"'===i?'\\"':i,n++}return'"'+r+'"'},o.escape=function(e){var t=String(e);return t=t.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}},function(e,t,r){var a=r(3).nearlyEqual,o=r(44);t.factory=function(e,r,t,n){var i=n("equalScalar",{"boolean, boolean":function(e,t){return e===t},"number, number":function(e,t){return e===t||a(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.eq(t)||o(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return e.equals(t)},"Complex, Complex":function(e,t){return e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return i(e.value,t.value)}});return i}},function(e,t,r){function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=t,this.relation=r,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(t)?"["+t.join(", ")+"]":t)+")",this.stack=(new Error).stack}(n.prototype=new RangeError).constructor=RangeError,n.prototype.name="DimensionError",n.prototype.isDimensionError=!0,e.exports=n},function(e,t,o){t.factory=function(e,t,r,n){var i=r(o(21)),a=n("divide",{"number, number":function(e,t){return e/t},"Complex, Complex":function(e,t){return e.div(t)},"BigNumber, BigNumber":function(e,t){return e.div(t)},"Fraction, Fraction":function(e,t){return e.div(t)},"Unit, number | Fraction | BigNumber":function(e,t){var r=e.clone();return r.value=a(null===r.value?r._normalize(1):r.value,t),r},"number | Fraction | BigNumber, Unit":function(e,t){var r=t.pow(-1);return r.value=i(null===r.value?r._normalize(1):r.value,e),r},"Unit, Unit":function(e,t){return e.divide(t)}});return a}},function(e,t,m){var h=m(5).extend;t.name="add",t.factory=function(e,t,r,n){var i=r(m(1)),a=r(m(20)),o=m(4),s=r(m(34)),u=r(m(88)),c=r(m(43)),f=r(m(7)),l=r(m(6)),p=n("add",h({"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,a)},"DenseMatrix, SparseMatrix":function(e,t){return s(e,t,a,!1)},"SparseMatrix, DenseMatrix":function(e,t){return s(t,e,a,!0)},"SparseMatrix, SparseMatrix":function(e,t){return u(e,t,a)},"Array, Array":function(e,t){return p(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return p(i(e),t)},"Matrix, Array":function(e,t){return p(e,i(t))},"DenseMatrix, any":function(e,t){return l(e,t,a,!1)},"SparseMatrix, any":function(e,t){return c(e,t,a,!1)},"any, DenseMatrix":function(e,t){return l(t,e,a,!0)},"any, SparseMatrix":function(e,t){return c(t,e,a,!0)},"Array, any":function(e,t){return l(i(e),t,a,!1).valueOf()},"any, Array":function(e,t){return l(i(t),e,a,!0).valueOf()},"any, any":a,"any, any, ...any":function(e,t,r){for(var n=p(e,t),i=0;i<r.length;i++)n=p(n,r[i]);return n}},a.signatures));return p.toTex={2:"\\left(${args[0]}"+o.operators.add+"${args[1]}\\right)"},p}},function(e,t,r){var o=r(134),s=r(5).deepEqual,u=r(5).hasOwnProperty;t.name="Node",t.path="expression.node",t.math=!0,t.factory=function(t,e,r,n,i){function a(){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator")}return a.prototype.eval=function(e){return this.compile().eval(e)},a.prototype.type="Node",a.prototype.isNode=!0,a.prototype.comment="",a.prototype.compile=function(){var r=this._compile(i.expression.mathWithTransform,{}),n={};return{eval:function(e){var t=e||{};return function(e){for(var t in e)if(u(e,t)&&t in o)throw new Error('Scope contains an illegal symbol, "'+t+'" is a reserved keyword')}(t),r(t,n,null)}}},a.prototype._compile=function(e,t){throw new Error("Method _compile should be implemented by type "+this.type)},a.prototype.forEach=function(e){throw new Error("Cannot run forEach on a Node interface")},a.prototype.map=function(e){throw new Error("Cannot run map on a Node interface")},a.prototype._ifNode=function(e){if(!t.isNode(e))throw new TypeError("Callback function must return a Node");return e},a.prototype.traverse=function(e){e(this,null,null),function n(e,i){e.forEach(function(e,t,r){i(e,t,r),n(e,i)})}(this,e)},a.prototype.transform=function(e){return function n(e,i){return e.map(function(e,t,r){return n(i(e,t,r),i)})}(e(this,null,null),e)},a.prototype.filter=function(n){var i=[];return this.traverse(function(e,t,r){n(e,t,r)&&i.push(e)}),i},a.prototype.find=function(){throw new Error("Function Node.find is deprecated. Use Node.filter instead.")},a.prototype.match=function(){throw new Error("Function Node.match is deprecated. See functions Node.filter, Node.transform, Node.traverse.")},a.prototype.clone=function(){throw new Error("Cannot clone a Node interface")},a.prototype.cloneDeep=function(){return this.map(function(e){return e.cloneDeep()})},a.prototype.equals=function(e){return!!e&&s(this,e)},a.prototype.toString=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toString(e)},a.prototype.toJSON=function(){throw new Error("Cannot serialize object: toJSON not implemented by "+this.type)},a.prototype.toHTML=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this.toHTML(e)},a.prototype._toString=function(){throw new Error("_toString not implemented for "+this.type)},a.prototype.toTex=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toTex(e)},a.prototype._toTex=function(e){throw new Error("_toTex not implemented for "+this.type)},a.prototype.getIdentifier=function(){return this.type},a.prototype.getContent=function(){return this},a}},function(e,t,r){var n=r(5).hasOwnProperty;function i(e,t){return!(!e||"object"!=typeof e)&&(!!n(s,t)||!(t in Object.prototype)&&!(t in Function.prototype))}function a(e,t){return!(!e||"function"!=typeof e[t])&&(!(n(e,t)&&e.__proto__&&t in e.__proto__)&&(!!n(u,t)||!(t in Object.prototype)&&!(t in Function.prototype)))}function o(e){return"object"==typeof e&&e&&e.constructor===Object}var s={length:!0,name:!0},u={toString:!0,valueOf:!0,toLocaleString:!0};t.getSafeProperty=function(e,t){if(o(e)&&i(e,t))return e[t];if("function"==typeof e[t]&&a(e,t))throw new Error('Cannot access method "'+t+'" as a property');throw new Error('No access to property "'+t+'"')},t.setSafeProperty=function(e,t,r){if(o(e)&&i(e,t))return e[t]=r;throw new Error('No access to property "'+t+'"')},t.isSafeProperty=i,t.validateSafeMethod=function(e,t){if(!a(e,t))throw new Error('No access to method "'+t+'"')},t.isSafeMethod=a,t.isPlainObject=o},function(e,t,d){var i=d(11);function g(e,t){var r=e.size(),n=t.size();if(r.length!==n.length)throw new i(r.length,n.length)}t.name="subtract",t.factory=function(e,t,r,n){var i=d(4),a=r(d(1)),o=r(d(20)),s=r(d(32)),u=r(d(34)),c=r(d(19)),f=r(d(71)),l=r(d(43)),p=r(d(7)),m=r(d(6)),h=n("subtract",{"number, number":function(e,t){return e-t},"Complex, Complex":function(e,t){return e.sub(t)},"BigNumber, BigNumber":function(e,t){return e.minus(t)},"Fraction, Fraction":function(e,t){return e.sub(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=h(r.value,t.value),r.fixPrefix=!1,r},"SparseMatrix, SparseMatrix":function(e,t){return g(e,t),f(e,t,h)},"SparseMatrix, DenseMatrix":function(e,t){return g(e,t),c(t,e,h,!0)},"DenseMatrix, SparseMatrix":function(e,t){return g(e,t),u(e,t,h,!1)},"DenseMatrix, DenseMatrix":function(e,t){return g(e,t),p(e,t,h)},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"SparseMatrix, any":function(e,t){return l(e,s(t),o)},"DenseMatrix, any":function(e,t){return m(e,t,h)},"any, SparseMatrix":function(e,t){return l(t,e,h,!0)},"any, DenseMatrix":function(e,t){return m(t,e,h,!0)},"Array, any":function(e,t){return m(a(e),t,h,!1).valueOf()},"any, Array":function(e,t){return m(a(t),e,h,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+i.operators.subtract+"${args[1]}\\right)"},h}},function(e,t,n){t.name="algorithm11",t.factory=function(e,t,r,A){var O=r(n(10)),S=e.SparseMatrix;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var c,f=s[0],l=s[1],p=O,m=0,h=r;"string"==typeof u&&(c=u,p=A.find(O,[c,c]),m=A.convert(0,c),t=A.convert(t,c),h=A.find(r,[c,c]));for(var d=[],g=[],v=[],y=new S({values:d,index:g,ptr:v,size:[f,l],datatype:c}),x=0;x<l;x++){v[x]=g.length;for(var w=o[x],b=o[x+1],N=w;N<b;N++){var M=a[N],E=n?h(t,i[N]):h(i[N],t);p(E,m)||(g.push(M),d.push(E))}}return v[l]=g.length,y}}},function(e,t,r){t.name="algorithm12",t.factory=function(e,t,r,E){var A=e.DenseMatrix;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var c,f=s[0],l=s[1],p=r;"string"==typeof u&&(c=u,t=E.convert(t,c),p=E.find(r,[c,c]));for(var m=[],h=new A({data:m,size:[f,l],datatype:c}),d=[],g=[],v=0;v<l;v++){for(var y=v+1,x=o[v],w=o[v+1],b=x;b<w;b++){var N=a[b];d[N]=i[b],g[N]=y}for(var M=0;M<f;M++)0===v&&(m[M]=[]),g[M]===y?m[M][v]=n?p(t,d[M]):p(d[M],t):m[M][v]=n?p(t,0):p(0,t)}return h}}},function(e,t,r){var C=r(11);t.name="algorithm03",t.factory=function(e,t,r,_){var T=e.DenseMatrix;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,l=t._datatype;if(a.length!==f.length)throw new C(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var p,m=a[0],h=a[1],d=0,g=r;"string"==typeof o&&o===l&&(p=o,d=_.convert(0,p),g=_.find(r,[p,p]));for(var v=[],y=0;y<m;y++)v[y]=[];for(var x=[],w=[],b=0;b<h;b++){for(var N=b+1,M=c[b],E=c[b+1],A=M;A<E;A++){var O=u[A];x[O]=n?g(s[A],i[O][b]):g(i[O][b],s[A]),w[O]=N}for(var S=0;S<m;S++)w[S]===N?v[S][b]=x[S]:v[S][b]=n?g(d,i[S][b]):g(i[S][b],d)}return new T({data:v,size:[m,h],datatype:p})}}},function(e,t,r){t.factory=function(e,t,r,n){var i=n("add",{"number, number":function(e,t){return e+t},"Complex, Complex":function(e,t){return e.add(t)},"BigNumber, BigNumber":function(e,t){return e.plus(t)},"Fraction, Fraction":function(e,t){return e.add(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=i(r.value,t.value),r.fixPrefix=!1,r}});return i}},function(e,t,r){t.factory=function(e,t,r,n){var i=n("multiplyScalar",{"number, number":function(e,t){return e*t},"Complex, Complex":function(e,t){return e.mul(t)},"BigNumber, BigNumber":function(e,t){return e.times(t)},"Fraction, Fraction":function(e,t){return e.mul(t)},"number | Fraction | BigNumber | Complex, Unit":function(e,t){var r=t.clone();return r.value=null===r.value?r._normalize(e):i(r.value,e),r},"Unit, number | Fraction | BigNumber | Complex":function(e,t){var r=e.clone();return r.value=null===r.value?r._normalize(t):i(r.value,t),r},"Unit, Unit":function(e,t){return e.multiply(t)}});return i}},function(e,t,s){var u=s(5).clone,c=s(2).validateIndex,n=s(15).getSafeProperty,a=s(15).setSafeProperty,f=s(11);function l(e,t){if(1!==t.size().length)throw new f(t.size(),1);var r=t.dimension(0);if("string"!=typeof r)throw new TypeError("String expected as index to retrieve an object property");return n(e,r)}function p(e,t,r){if(1!==t.size().length)throw new f(t.size(),1);var n=t.dimension(0);if("string"!=typeof n)throw new TypeError("String expected as index to retrieve an object property");var i=u(e);return a(i,n,r),i}t.name="subset",t.factory=function(a,e,t,r){var i=t(s(1)),n=r("subset",{"Array, Index":function(e,t){var r=i(e).subset(t);return t.isScalar()?r:r.valueOf()},"Matrix, Index":function(e,t){return e.subset(t)},"Object, Index":l,"string, Index":function(t,e){if(!a.isIndex(e))throw new TypeError("Index expected");if(1!=e.size().length)throw new f(e.size().length,1);var r=t.length;c(e.min()[0],r),c(e.max()[0],r);var n=e.dimension(0),i="";return n.forEach(function(e){i+=t.charAt(e)}),i},"Array, Index, any":function(e,t,r){return i(u(e)).subset(t,r,void 0).valueOf()},"Array, Index, any, any":function(e,t,r,n){return i(u(e)).subset(t,r,n).valueOf()},"Matrix, Index, any":function(e,t,r){return e.clone().subset(t,r)},"Matrix, Index, any, any":function(e,t,r,n){return e.clone().subset(t,r,n)},"string, Index, string":o,"string, Index, string, string":o,"Object, Index, any":p});return n.toTex=void 0,n;function o(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Index expected");if(1!=t.size().length)throw new f(t.size().length,1);if(void 0!==n){if("string"!=typeof n||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";var i=t.dimension(0),a=i.size()[0];if(a!=r.length)throw new f(i.size()[0],r.length);var o=e.length;c(t.min()[0]),c(t.max()[0]);for(var s=[],u=0;u<o;u++)s[u]=e.charAt(u);if(i.forEach(function(e,t){s[e]=r.charAt(t[0])}),s.length>o)for(u=o-1,a=s.length;u<a;u++)s[u]||(s[u]=n);return s.join("")}}},function(e,t,r){var a=r(0);t.name="abs",t.factory=function(e,t,r,n){var i=n("abs",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},Fraction:function(e){return e.abs()},"Array | Matrix":function(e){return a(e,i,!0)},Unit:function(e){return e.abs()}});return i.toTex={1:"\\left|${args[0]}\\right|"},i}},function(e,t,o){var s=o(2);t.name="size",t.factory=function(e,t,r,n){var i=r(o(1)),a=n("size",{Matrix:function(e){return i(e.size())},Array:s.size,string:function(e){return"Array"===t.matrix?[e.length]:i([e.length])},"number | Complex | BigNumber | Unit | boolean | null":function(e){return"Array"===t.matrix?[]:i([])}});return a.toTex=void 0,a}},function(e,t,n){var C=n(11);t.name="algorithm02",t.factory=function(e,t,r,S){var _=r(n(10)),T=e.SparseMatrix;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,l=t._datatype;if(a.length!==f.length)throw new C(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var p,m=a[0],h=a[1],d=_,g=0,v=r;"string"==typeof o&&o===l&&(p=o,d=S.find(_,[p,p]),g=S.convert(0,p),v=S.find(r,[p,p]));for(var y=[],x=[],w=[],b=0;b<h;b++){w[b]=x.length;for(var N=c[b],M=c[b+1],E=N;E<M;E++){var A=u[E],O=n?v(s[E],i[A][b]):v(i[A][b],s[E]);d(O,g)||(x.push(A),y.push(O))}}return w[h]=x.length,new T({values:y,index:x,ptr:w,size:[m,h],datatype:p})}}},function(e,t,n){var m=n(215);t.name="compareNatural",t.factory=function(s,e,t,r){var u=t(n(49)),c=t(n(45)),f=c.signatures["boolean,boolean"],l=r("compareNatural",{"any, any":function(e,t){var r,n,i,a=u(e),o=u(t);if(!("number"!==a&&"BigNumber"!==a&&"Fraction"!==a||"number"!==o&&"BigNumber"!==o&&"Fraction"!==o))return"0"!==(r=c(e,t)).toString()?0<r?1:-1:m(a,o);if("Array"===a||"Matrix"===a||"Array"===o||"Matrix"===o)return 0!==(r=function e(t,r){return s.isSparseMatrix(t)&&s.isSparseMatrix(r)?p(t.toJSON().values,r.toJSON().values):s.isSparseMatrix(t)?e(t.toArray(),r):s.isSparseMatrix(r)?e(t,r.toArray()):s.isDenseMatrix(t)?e(t.toJSON().data,r):s.isDenseMatrix(r)?e(t,r.toJSON().data):Array.isArray(t)?Array.isArray(r)?p(t,r):e(t,[r]):e([t],r)}(e,t))?r:m(a,o);if(a!==o)return m(a,o);if("Complex"===a)return i=t,(n=e).re>i.re?1:n.re<i.re?-1:n.im>i.im?1:n.im<i.im?-1:0;if("Unit"===a)return e.equalBase(t)?l(e.value,t.value):p(e.formatUnits(),t.formatUnits());if("boolean"===a)return f(e,t);if("string"===a)return m(e,t);if("Object"===a)return function(e,t){var r=Object.keys(e),n=Object.keys(t);r.sort(m),n.sort(m);var i=p(r,n);if(0!==i)return i;for(var a=0;a<r.length;a++){var o=l(e[r[a]],t[n[a]]);if(0!==o)return o}return 0}(e,t);if("null"===a)return 0;if("undefined"===a)return 0;throw new TypeError('Unsupported type of value "'+a+'"')}});function p(e,t){for(var r=0,n=Math.min(e.length,t.length);r<n;r++){var i=l(e[r],t[r]);if(0!==i)return i}return e.length>t.length?1:e.length<t.length?-1:0}return l.toTex=void 0,l}},function(e,t,r){var n=r(5).clone,i=r(3).isInteger;t.name="Index",t.path="type",t.factory=function(o){function s(e){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");this._dimensions=[],this._isScalar=!0;for(var t=0,r=arguments.length;t<r;t++){var n=arguments[t];if(o.isRange(n))this._dimensions.push(n),this._isScalar=!1;else if(Array.isArray(n)||o.isMatrix(n)){var i=u(n.valueOf());this._dimensions.push(i);var a=i.size();1===a.length&&1===a[0]||(this._isScalar=!1)}else if("number"==typeof n)this._dimensions.push(u([n]));else{if("string"!=typeof n)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");this._dimensions.push(n)}}}function u(e){for(var t=0,r=e.length;t<r;t++)if("number"!=typeof e[t]||!i(e[t]))throw new TypeError("Index parameters must be positive integer numbers");return new o.ImmutableDenseMatrix(e)}return s.prototype.type="Index",s.prototype.isIndex=!0,s.prototype.clone=function(){var e=new s;return e._dimensions=n(this._dimensions),e._isScalar=this._isScalar,e},s.create=function(e){var t=new s;return s.apply(t,e),t},s.prototype.size=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?1:n.size()[0]}return e},s.prototype.max=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.max()}return e},s.prototype.min=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.min()}return e},s.prototype.forEach=function(e){for(var t=0,r=this._dimensions.length;t<r;t++)e(this._dimensions[t],t,this)},s.prototype.dimension=function(e){return this._dimensions[e]||null},s.prototype.isObjectProperty=function(){return 1===this._dimensions.length&&"string"==typeof this._dimensions[0]},s.prototype.getObjectProperty=function(){return this.isObjectProperty()?this._dimensions[0]:null},s.prototype.isScalar=function(){return this._isScalar},s.prototype.valueOf=s.prototype.toArray=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e.push("string"==typeof n?n:n.toArray())}return e},s.prototype.toString=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];"string"==typeof n?e.push(JSON.stringify(n)):e.push(n.toString())}return"["+e.join(", ")+"]"},s.prototype.toJSON=function(){return{mathjs:"Index",dimensions:this._dimensions}},s.fromJSON=function(e){return s.create(e.dimensions)},s}},function(e,t,r){var O=r(11);t.name="algorithm07",t.factory=function(e,t,r,M){var E=e.DenseMatrix,A=function(e,t,r,n,i){for(var a=e._values,o=e._index,s=e._ptr,u=s[t],c=s[t+1];u<c;u++){var f=o[u];r[f]=i,n[f]=a[u]}};return function(e,t,r){var n=e._size,i=e._datatype,a=t._size,o=t._datatype;if(n.length!==a.length)throw new O(n.length,a.length);if(n[0]!==a[0]||n[1]!==a[1])throw new RangeError("Dimension mismatch. Matrix A ("+n+") must match Matrix B ("+a+")");var s,u,c,f=n[0],l=n[1],p=0,m=r;"string"==typeof i&&i===o&&(s=i,p=M.convert(0,s),m=M.find(r,[s,s]));var h=[];for(u=0;u<f;u++)h[u]=[];var d=new E({data:h,size:[f,l],datatype:s}),g=[],v=[],y=[],x=[];for(c=0;c<l;c++){var w=c+1;for(A(e,c,y,g,w),A(t,c,x,v,w),u=0;u<f;u++){var b=y[u]===w?g[u]:p,N=x[u]===w?v[u]:p;h[u][c]=m(b,N)}}return d}}},function(e,t,r){t.array=r(2),t.boolean=r(533),t.function=r(35),t.number=r(3),t.object=r(5),t.string=r(9),t.emitter=r(148)},function(e,t,l){var p=l(5).extend;t.name="divide",t.factory=function(e,t,r,n){var i=r(l(12)),a=r(l(8)),o=r(l(66)),s=r(l(1)),u=r(l(17)),c=r(l(6)),f=n("divide",p({"Array | Matrix, Array | Matrix":function(e,t){return a(e,o(t))},"DenseMatrix, any":function(e,t){return c(e,t,i,!1)},"SparseMatrix, any":function(e,t){return u(e,t,i,!1)},"Array, any":function(e,t){return c(s(e),t,i,!1).valueOf()},"any, Array | Matrix":function(e,t){return a(e,o(t))}},i.signatures));return f.toTex={2:"\\frac{${args[0]}}{${args[1]}}"},f}},function(e,t,a){t.factory=function(e,t,r,n){var i=r(a(49));return function(e,t,r){var n;return-1!==String(e).indexOf("Unexpected type")?(n=2<arguments.length?" (type: "+i(r)+", value: "+JSON.stringify(r)+")":" (type: "+e.data.actual+")",new TypeError("Cannot calculate "+t+", unexpected type of argument"+n)):-1!==String(e).indexOf("complex numbers")?(n=2<arguments.length?" (type: "+i(r)+", value: "+JSON.stringify(r)+")":"",new TypeError("Cannot calculate "+t+", no ordering relation is defined for complex numbers"+n)):e}}},function(e,t,o){var s=o(0);t.name="unaryMinus",t.factory=function(e,t,r,n){var i=o(4),a=n("unaryMinus",{number:function(e){return-e},Complex:function(e){return e.neg()},BigNumber:function(e){return e.neg()},Fraction:function(e){return e.neg()},Unit:function(e){var t=e.clone();return t.value=a(e.value),t},"Array | Matrix":function(e){return s(e,a,!0)}});return a.toTex={1:i.operators.unaryMinus+"\\left(${args[0]}\\right)"},a}},function(e,t,p){var m=p(3).nearlyEqual,h=p(44);t.name="larger",t.factory=function(e,r,t,n){var i=t(p(1)),a=t(p(19)),o=t(p(28)),s=t(p(18)),u=t(p(7)),c=t(p(6)),f=p(4),l=n("larger",{"boolean, boolean":function(e,t){return t<e},"number, number":function(e,t){return t<e&&!m(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.gt(t)&&!h(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return 1===e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return l(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,l)},"Array, Array":function(e,t){return l(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return l(i(e),t)},"Matrix, Array":function(e,t){return l(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,l,!1)},"DenseMatrix, any":function(e,t){return c(e,t,l,!1)},"any, SparseMatrix":function(e,t){return s(t,e,l,!0)},"any, DenseMatrix":function(e,t){return c(t,e,l,!0)},"Array, any":function(e,t){return c(i(e),t,l,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+f.operators.larger+"${args[1]}\\right)"},l}},function(e,t,r){var S=r(11);t.name="algorithm01",t.factory=function(e,t,r,A){var O=e.DenseMatrix;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,l=t._datatype;if(a.length!==f.length)throw new S(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var p,m,h=a[0],d=a[1],g="string"==typeof o&&o===l?o:void 0,v=g?A.find(r,[g,g]):r,y=[];for(p=0;p<h;p++)y[p]=[];var x=[],w=[];for(m=0;m<d;m++){for(var b=m+1,N=c[m],M=c[m+1],E=N;E<M;E++)x[p=u[E]]=n?v(s[E],i[p][m]):v(i[p][m],s[E]),w[p]=b;for(p=0;p<h;p++)w[p]===b?y[p][m]=x[p]:y[p][m]=i[p][m]}return new O({data:y,size:[h,d],datatype:g})}}},function(e,t,r){t.memoize=function(i,a){return function e(){"object"!=typeof e.cache&&(e.cache={});for(var t=[],r=0;r<arguments.length;r++)t[r]=arguments[r];var n=a?a(t):JSON.stringify(t);return n in e.cache?e.cache[n]:e.cache[n]=i.apply(i,t)}},t.maxArgumentCount=function(e){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)},t.callWithRightArgumentCount=function(e,t,r){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)}},function(e,t,r){var o=r(0);t.name="sqrt",t.factory=function(t,r,e,n){var i=n("sqrt",{number:a,Complex:function(e){return e.sqrt()},BigNumber:function(e){return!e.isNegative()||r.predictable?e.sqrt():a(e.toNumber())},"Array | Matrix":function(e){return o(e,i,!0)},Unit:function(e){return e.pow(.5)}});function a(e){return 0<=e||r.predictable?Math.sqrt(e):new t.Complex(e,0).sqrt()}return i.toTex={1:"\\sqrt{${args[0]}}"},i}},function(e,t,r){var o=r(72);e.exports=function e(t,r){o(t)&&(t=t.valueOf());for(var n=0,i=t.length;n<i;n++){var a=t[n];Array.isArray(a)?e(a,r):r(a)}}},function(e,t,r){var n=r(61);t.transform=function(e){return e&&e.isIndexError?new n(e.index+1,e.min+1,void 0!==e.max?e.max+1:void 0):e}},function(e,t,pe){var me=pe(53),he=pe(0);t.name="parse",t.path="expression",t.factory=function(a,u,e,t){var c=e(pe(136)),n=e(pe(135)),f=e(pe(132)),o=e(pe(131)),i=e(pe(130)),s=e(pe(129)),l=e(pe(58)),p=e(pe(128)),m=e(pe(86)),h=e(pe(127)),d=e(pe(57)),g=e(pe(70)),v=e(pe(69)),r=e(pe(126)),y=e(pe(48));function x(e,t){if(1!==arguments.length&&2!==arguments.length)throw new me("parse",arguments.length,1,2);if(A=t&&t.nodes?t.nodes:{},"string"==typeof e)return O=e,H();if(Array.isArray(e)||e instanceof a.Matrix)return he(e,function(e){if("string"!=typeof e)throw new TypeError("String expected");return O=e,H()});throw new TypeError("String or matrix expected")}var w={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},b={",":!0,"(":!0,")":!0,"[":!0,"]":!0,"{":!0,"}":!0,'"':!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"~":!0,"!":!0,"&":!0,"|":!0,"^|":!0,"'":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0,"<<":!0,">>":!0,">>>":!0},N={mod:!0,to:!0,in:!0,and:!0,xor:!0,or:!0,not:!0},M={true:!0,false:!1,null:null,undefined:void 0},E=["NaN","Infinity"],A={},O="",S="",_=0,T="",C="",z=w.NULL,B=0,I=null,P=[];function R(){_++,T=O.charAt(_)}function U(){return O.charAt(_-1)}function k(){return O.charAt(_+1)}function q(){P.push({token_type:z,token:C,comment:S,index:_,c:T})}function D(){var e=P.pop();z=e.token_type,C=e.token,S=e.comment,_=e.index,T=e.c}function L(){for(z=w.NULL,S=C="";x.isWhitespace(T,B);)R();if("#"===T)for(;"\n"!==T&&""!==T;)S+=T,R();if(""!==T){if("\n"===T&&!B)return z=w.DELIMITER,C=T,void R();var e=T+k(),t=e+O.charAt(_+2);if(3===t.length&&b[t])return z=w.DELIMITER,C=t,R(),R(),void R();if(2===e.length&&b[e])return z=w.DELIMITER,C=e,R(),void R();if(b[T])return z=w.DELIMITER,C=T,void R();if(x.isDigitDot(T)){if(z=w.NUMBER,"."===T)C+=T,R(),x.isDigit(T)||(z=w.DELIMITER);else{for(;x.isDigit(T);)C+=T,R();x.isDecimalMark(T,k())&&(C+=T,R())}for(;x.isDigit(T);)C+=T,R();if(e=k(),"E"===T||"e"===T)if(x.isDigit(e)||"-"===e||"+"===e){if(C+=T,R(),"+"!==T&&"-"!==T||(C+=T,R()),!x.isDigit(T))throw fe('Digit expected, got "'+T+'"');for(;x.isDigit(T);)C+=T,R();if(x.isDecimalMark(T,k()))throw fe('Digit expected, got "'+T+'"')}else if("."===e)throw R(),fe('Digit expected, got "'+T+'"')}else{if(!x.isAlpha(T,U(),k())){for(z=w.UNKNOWN;""!==T;)C+=T,R();throw fe('Syntax error in part "'+C+'"')}for(;x.isAlpha(T,U(),k())||x.isDigit(T);)C+=T,R();z=N.hasOwnProperty(C)?w.DELIMITER:w.SYMBOL}}else z=w.DELIMITER}function F(){for(;L(),"\n"===C;);}function j(){B++}function $(){B--}function H(){_=0,T=O.charAt(0),B=0,I=null,L();var e=function(){var e,t,r=[];for(""!==C&&"\n"!==C&&";"!==C&&((e=G()).comment=S);"\n"===C||";"===C;)0===r.length&&e&&(t=";"!==C,r.push({node:e,visible:t})),L(),"\n"!==C&&";"!==C&&""!==C&&((e=G()).comment=S,t=";"!==C,r.push({node:e,visible:t}));return 0<r.length?new i(r):(e||((e=new l(void 0)).comment=S),e)}();if(""!==C)throw z===w.DELIMITER?le("Unexpected operator "+C):fe('Unexpected part "'+C+'"');return e}function G(){var e,r,t,n,i=function(){for(var e=function(){for(var e=Z();"or"===C;)F(),e=new d("or","or",[e,Z()]);return e}();"?"===C;){var t=I;I=B,F();var r=e,n=G();if(":"!==C)throw fe("False part of conditional expression expected");I=null,F();var i=G();e=new s(r,n,i),I=t}return e}();if("="===C){if(a.isSymbolNode(i))return e=i.name,F(),t=G(),new o(new y(e),t);if(a.isAccessorNode(i))return F(),t=G(),new o(i.object,i.index,t);if(a.isFunctionNode(i)&&a.isSymbolNode(i.fn)&&(n=!0,r=[],e=i.name,i.args.forEach(function(e,t){a.isSymbolNode(e)?r[t]=e.name:n=!1}),n))return F(),t=G(),new p(e,r,t);throw fe("Invalid left hand side of assignment operator =")}return i}function Z(){for(var e=V();"xor"===C;)F(),e=new d("xor","xor",[e,V()]);return e}function V(){for(var e=W();"and"===C;)F(),e=new d("and","and",[e,W()]);return e}function W(){for(var e=J();"|"===C;)F(),e=new d("|","bitOr",[e,J()]);return e}function J(){for(var e=Y();"^|"===C;)F(),e=new d("^|","bitXor",[e,Y()]);return e}function Y(){for(var e=X();"&"===C;)F(),e=new d("&","bitAnd",[e,X()]);return e}function X(){var e,t,r,n,i;for(e=Q(),t={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallerEq",">=":"largerEq"};t.hasOwnProperty(C);)n=t[r=C],F(),i=[e,Q()],e=new d(r,n,i);return e}function Q(){var e,t,r,n,i;for(e=K(),t={"<<":"leftShift",">>":"rightArithShift",">>>":"rightLogShift"};t.hasOwnProperty(C);)n=t[r=C],F(),i=[e,K()],e=new d(r,n,i);return e}function K(){var e,t,r,n,i;for(e=ee(),t={to:"to",in:"to"};t.hasOwnProperty(C);)n=t[r=C],F(),"in"===r&&""===C?e=new d("*","multiply",[e,new y("in")],!0):(i=[e,ee()],e=new d(r,n,i));return e}function ee(){var e,t=[];if(e=":"===C?new l(1):te(),":"===C&&I!==B){for(t.push(e);":"===C&&t.length<3;)F(),")"===C||"]"===C||","===C||""===C?t.push(new y("end")):t.push(te());e=3===t.length?new r(t[0],t[2],t[1]):new r(t[0],t[1])}return e}function te(){var e,t,r,n,i;for(e=re(),t={"+":"add","-":"subtract"};t.hasOwnProperty(C);)n=t[r=C],F(),i=[e,re()],e=new d(r,n,i);return e}function re(){var e,t,r,n,i;for(t=e=ne(),r={"*":"multiply",".*":"dotMultiply","/":"divide","./":"dotDivide","%":"mod",mod:"mod"};r.hasOwnProperty(C);)i=r[n=C],F(),t=ne(),e=new d(n,i,[e,t]);return e}function ne(){var e,t;for(t=e=ie();z===w.SYMBOL||"in"===C&&a.isConstantNode(e)||!(z!==w.NUMBER||a.isConstantNode(t)||a.isOperatorNode(t)&&"!"!==t.op)||"("===C;)t=ie(),e=new d("*","multiply",[e,t],!0);return e}function ie(){var e,t;for(t=e=ae();"/"===C&&a.isConstantNode(t);){if(q(),F(),z!==w.NUMBER){D();break}if(q(),F(),z!==w.SYMBOL&&"("!==C){D(),D();break}D(),P.pop(),t=ae(),e=new d("/","divide",[e,t])}return e}function ae(){var e,t,r,n,i,a,o,s={"-":"unaryMinus","+":"unaryPlus","~":"bitNot",not:"not"};return s.hasOwnProperty(C)?(r=s[C],e=C,F(),t=[ae()],new d(e,r,t)):(n=function(){var e,t,r,n;for(e=function(){var e,t,r=[];if(z===w.SYMBOL&&A.hasOwnProperty(C)){var n=A[C];if(L(),"("===C){if(r=[],j(),L(),")"!==C)for(r.push(G());","===C;)L(),r.push(G());if(")"!==C)throw fe("Parenthesis ) expected");$(),L()}return new n(r)}return z===w.SYMBOL||z===w.DELIMITER&&C in N?(e=C,L(),oe(M.hasOwnProperty(e)?new l(M[e]):-1!==E.indexOf(e)?new l(c(e)):new y(e))):'"'===C?(t=se(),oe(new l(t))):function(){var e,t,r,n;if("["===C){if(j(),L(),"]"!==C){var i=ue();if(";"===C){for(r=1,t=[i];";"===C;)L(),t[r]=ue(),r++;if("]"!==C)throw fe("End of matrix ] expected");$(),L(),n=t[0].items.length;for(var a=1;a<r;a++)if(t[a].items.length!==n)throw le("Column dimensions mismatch ("+t[a].items.length+" !== "+n+")");e=new f(t)}else{if("]"!==C)throw fe("End of matrix ] expected");$(),L(),e=i}}else $(),L(),e=new f([]);return oe(e)}return function(){if("{"===C){var e,t={};do{if(L(),"}"!==C){if('"'===C)e=se();else{if(z!==w.SYMBOL)throw fe("Symbol or string expected as object key");e=C,L()}if(":"!==C)throw fe("Colon : expected after object key");L(),t[e]=G()}}while(","===C);if("}"!==C)throw fe("Comma , or bracket } expected after object value");L();var r=new h(t);return r=oe(r)}return z===w.NUMBER?(n=C,L(),new l(c(n,u.number))):function(){var e;if("("===C){if(j(),L(),e=G(),")"!==C)throw fe("Parenthesis ) expected");return $(),L(),e=oe(e=new g(e))}return function(){throw fe(""===C?"Unexpected end of expression":"'"===C?"Value expected. Note: strings must be enclosed by double quotes":"Value expected")}()}();var n}()}()}(),t={"!":"factorial","'":"transpose"};t.hasOwnProperty(C);)n=t[r=C],L(),e=oe(e=new d(r,n,[e]));return e}(),("^"===C||".^"===C)&&(a="^"===(i=C)?"pow":"dotPow",F(),o=[n,ae()],n=new d(i,a,o)),n)}function oe(e,t){for(var r;!("("!==C&&"["!==C&&"."!==C||t&&-1===t.indexOf(C));)if(r=[],"("===C){if(!a.isSymbolNode(e)&&!a.isAccessorNode(e))return e;if(j(),L(),")"!==C)for(r.push(G());","===C;)L(),r.push(G());if(")"!==C)throw fe("Parenthesis ) expected");$(),L(),e=new v(e,r)}else if("["===C){if(j(),L(),"]"!==C)for(r.push(G());","===C;)L(),r.push(G());if("]"!==C)throw fe("Parenthesis ] expected");$(),L(),e=new n(e,new m(r))}else{if(L(),z!==w.SYMBOL)throw fe("Property name expected after dot");r.push(new l(C)),L(),e=new n(e,new m(r,!0))}return e}function se(){for(var e="";""!==T&&'"'!==T;)"\\"===T&&(e+=T,R()),e+=T,R();if(L(),'"'!==C)throw fe('End of string " expected');return L(),JSON.parse('"'+e+'"')}function ue(){for(var e=[G()],t=1;","===C;)L(),e[t]=G(),t++;return new f(e)}function ce(){return _-C.length+1}function fe(e){var t=ce(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}function le(e){var t=ce(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}return x.isAlpha=function(e,t,r){return x.isValidLatinOrGreek(e)||x.isValidMathSymbol(e,r)||x.isValidMathSymbol(t,e)},x.isValidLatinOrGreek=function(e){return/^[a-zA-Z_$\u00C0-\u02AF\u0370-\u03FF\u2100-\u214F]$/.test(e)},x.isValidMathSymbol=function(e,t){return/^[\uD835]$/.test(e)&&/^[\uDC00-\uDFFF]$/.test(t)&&/^[^\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]$/.test(t)},x.isWhitespace=function(e,t){return" "===e||"\t"===e||"\n"===e&&0<t},x.isDecimalMark=function(e,t){return"."===e&&"/"!==t&&"*"!==t&&"^"!==t},x.isDigitDot=function(e){return"0"<=e&&e<="9"||"."===e},x.isDigit=function(e){return"0"<=e&&e<="9"},x}},function(e,t,a){var u=a(3).isInteger,c=a(2).resize;t.name="zeros",t.factory=function(o,t,e,r){var s=e(a(1)),n=r("zeros",{"":function(){return"Array"===t.matrix?i([]):i([],"default")},"...number | BigNumber | string":function(e){return"string"==typeof e[e.length-1]?i(e,e.pop()):"Array"===t.matrix?i(e):i(e,"default")},Array:i,Matrix:function(e){var t=e.storage();return i(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return i(e.valueOf(),t)}});return n.toTex=void 0,n;function i(e,t){var n,r=(n=!1,e.forEach(function(e,t,r){o.isBigNumber(e)&&(n=!0,r[t]=e.toNumber())}),n?new o.BigNumber(0):0);if(e.forEach(function(e){if("number"!=typeof e||!u(e)||e<0)throw new Error("Parameters in function zeros must be positive integers")}),t){var i=s(t);return 0<e.length?i.resize(e,r):i}var a=[];return 0<e.length?c(a,e,r):a}}},function(e,t,h){var d=h(3).isInteger,g=h(2).size;t.name="pow",t.factory=function(i,a,e,t){var r=h(4),o=e(h(51)),s=e(h(8)),n=e(h(1)),u=e(h(146)),c=e(h(87)),f=t("pow",{"number, number":l,"Complex, Complex":function(e,t){return e.pow(t)},"BigNumber, BigNumber":function(e,t){return t.isInteger()||0<=e||a.predictable?e.pow(t):new i.Complex(e.toNumber(),0).pow(t.toNumber(),0)},"Fraction, Fraction":function(e,t){if(1!==t.d){if(a.predictable)throw new Error("Function pow does not support non-integer exponents for fractions.");return l(e.valueOf(),t.valueOf())}return e.pow(t)},"Array, number":p,"Array, BigNumber":function(e,t){return p(e,t.toNumber())},"Matrix, number":m,"Matrix, BigNumber":function(e,t){return m(e,t.toNumber())},"Unit, number":function(e,t){return e.pow(t)}});function l(e,t){if(a.predictable&&!d(t)&&e<0)try{var r=u(t),n=c(r);if((t===n||Math.abs((t-n)/t)<1e-14)&&r.d%2==1)return(r.n%2==0?1:-1)*Math.pow(-e,t)}catch(e){}return e*e<1&&t===1/0||1<e*e&&t===-1/0?0:a.predictable&&(e<-1&&t===1/0||-1<e&&e<0&&t===-1/0)?NaN:d(t)||0<=e||a.predictable?Math.pow(e,t):new i.Complex(e,0).pow(t,0)}function p(e,t){if(!d(t)||t<0)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var r=g(e);if(2!=r.length)throw new Error("For A^b, A must be 2 dimensional (A has "+r.length+" dimensions)");if(r[0]!=r[1])throw new Error("For A^b, A must be square (size is "+r[0]+"x"+r[1]+")");for(var n=o(r[0]).valueOf(),i=e;1<=t;)1==(1&t)&&(n=s(i,n)),t>>=1,i=s(i,i);return n}function m(e,t){return n(p(e.valueOf(),t))}return f.toTex={2:"\\left(${args[0]}\\right)"+r.operators.pow+"{${args[1]}}"},f}},function(e,t,p){var m=p(3).nearlyEqual,h=p(44);t.name="smaller",t.factory=function(e,r,t,n){var i=t(p(1)),a=t(p(19)),o=t(p(28)),s=t(p(18)),u=t(p(7)),c=t(p(6)),f=p(4),l=n("smaller",{"boolean, boolean":function(e,t){return e<t},"number, number":function(e,t){return e<t&&!m(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.lt(t)&&!h(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return-1===e.compare(t)},"Complex, Complex":function(e,t){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return l(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,l)},"Array, Array":function(e,t){return l(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return l(i(e),t)},"Matrix, Array":function(e,t){return l(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,l,!1)},"DenseMatrix, any":function(e,t){return c(e,t,l,!1)},"any, SparseMatrix":function(e,t){return s(t,e,l,!0)},"any, DenseMatrix":function(e,t){return c(t,e,l,!0)},"Array, any":function(e,t){return c(i(e),t,l,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+f.operators.smaller+"${args[1]}\\right)"},l}},function(e,t,r){t.name="algorithm10",t.factory=function(e,t,r,E){var A=e.DenseMatrix;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var c,f=s[0],l=s[1],p=r;"string"==typeof u&&(c=u,t=E.convert(t,c),p=E.find(r,[c,c]));for(var m=[],h=new A({data:m,size:[f,l],datatype:c}),d=[],g=[],v=0;v<l;v++){for(var y=v+1,x=o[v],w=o[v+1],b=x;b<w;b++){var N=a[b];d[N]=i[b],g[N]=y}for(var M=0;M<f;M++)0===v&&(m[M]=[]),g[M]===y?m[M][v]=n?p(t,d[M]):p(d[M],t):m[M][v]=t}return h}}},function(e,t,r){e.exports=function(e,t,r){if(null==r)return e.eq(t);if(e.eq(t))return!0;if(e.isNaN()||t.isNaN())return!1;if(e.isFinite()&&t.isFinite()){var n=e.minus(t).abs();if(n.isZero())return!0;var i=e.constructor.max(e.abs(),t.abs());return n.lte(i.times(r))}return!1}},function(e,t,l){var p=l(3).nearlyEqual,m=l(44);t.name="compare",t.factory=function(r,n,e,t){var i=e(l(1)),a=e(l(19)),o=e(l(71)),s=e(l(18)),u=e(l(7)),c=e(l(6)),f=t("compare",{"boolean, boolean":function(e,t){return e===t?0:t<e?1:-1},"number, number":function(e,t){return e===t||p(e,t,n.epsilon)?0:t<e?1:-1},"BigNumber, BigNumber":function(e,t){return e.eq(t)||m(e,t,n.epsilon)?new r.BigNumber(0):new r.BigNumber(e.cmp(t))},"Fraction, Fraction":function(e,t){return new r.Fraction(e.compare(t))},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return f(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,f)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,f,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,f,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,f)},"Array, Array":function(e,t){return f(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return f(i(e),t)},"Matrix, Array":function(e,t){return f(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,f,!1)},"DenseMatrix, any":function(e,t){return c(e,t,f,!1)},"any, SparseMatrix":function(e,t){return s(t,e,f,!0)},"any, DenseMatrix":function(e,t){return c(t,e,f,!0)},"Array, any":function(e,t){return c(i(e),t,f,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,f,!0).valueOf()}});return f.toTex=void 0,f}},function(e,t,r){var a=r(0),o=r(3);t.name="isInteger",t.factory=function(e,t,r,n){var i=n("isInteger",{number:o.isInteger,BigNumber:function(e){return e.isInt()},Fraction:function(e){return 1===e.d&&isFinite(e.n)},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){var n=r(72);e.exports=function(e){return Array.isArray(e)||n(e)}},function(e,t,u){var c=u(4),f=u(9).escape,l=u(5).hasOwnProperty,p=u(15).getSafeProperty;t.name="SymbolNode",t.path="expression.node",t.math=!0,t.factory=function(o,e,t,r,n){var i=t(u(14));function s(e){return!!o.Unit&&o.Unit.isValuelessUnit(e)}function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');this.name=e}return(a.prototype=new i).type="SymbolNode",a.prototype.isSymbolNode=!0,a.prototype._compile=function(n,e){var i=this.name;if(l(e,i))return function(e,t,r){return t[i]};if(i in n)return function(e,t,r){return p(i in e?e:n,i)};var a=s(i);return function(e,t,r){return i in e?p(e,i):a?new o.Unit(null,i):function(e){throw new Error("Undefined symbol "+e)}(i)}},a.prototype.forEach=function(e){},a.prototype.map=function(e){return this.clone()},a.prototype.clone=function(){return new a(this.name)},a.prototype._toString=function(e){return this.name},a.prototype.toHTML=function(e){var t=f(this.name);return"true"==t||"false"==t?'<span class="math-symbol math-boolean">'+t+"</span>":"i"==t?'<span class="math-symbol math-imaginary-symbol">'+t+"</span>":"Infinity"==t?'<span class="math-symbol math-infinity-symbol">'+t+"</span>":"NaN"==t?'<span class="math-symbol math-nan-symbol">'+t+"</span>":"null"==t?'<span class="math-symbol math-null-symbol">'+t+"</span>":"undefined"==t?'<span class="math-symbol math-undefined-symbol">'+t+"</span>":'<span class="math-symbol">'+t+"</span>"},a.prototype.toJSON=function(){return{mathjs:"SymbolNode",name:this.name}},a.fromJSON=function(e){return new a(e.name)},a.prototype._toTex=function(e){var t=!1;void 0===n[this.name]&&s(this.name)&&(t=!0);var r=c.toSymbol(this.name,t);return"\\"===r[0]?r:" "+r},a}},function(e,t,r){t.name="typeof",t.factory=function(r,e,t,n){var i=n("_typeof",{any:function(e){var t=typeof e;return"object"===t?null===e?"null":Array.isArray(e)?"Array":e instanceof Date?"Date":e instanceof RegExp?"RegExp":e instanceof Boolean?"boolean":e instanceof Number?"number":e instanceof String?"string":r.isBigNumber(e)?"BigNumber":r.isComplex(e)?"Complex":r.isFraction(e)?"Fraction":r.isMatrix(e)?"Matrix":r.isUnit(e)?"Unit":r.isIndex(e)?"Index":r.isRange(e)?"Range":r.isResultSet(e)?"ResultSet":r.isNode(e)?e.type:r.isChain(e)?"Chain":r.isHelp(e)?"Help":"Object":"function"===t?"Function":t}});return i.toTex=void 0,i}},function(e,t,m){t.name="equal",t.factory=function(e,t,r,n){var i=r(m(1)),a=r(m(10)),o=r(m(19)),s=r(m(28)),u=r(m(18)),c=r(m(7)),f=r(m(6)),l=m(4),p=n("equal",{"any, any":function(e,t){return null===e?null===t:null===t?null===e:void 0===e?void 0===t:void 0===t?void 0===e:a(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,a)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,a,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,a,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,a)},"Array, Array":function(e,t){return p(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return p(i(e),t)},"Matrix, Array":function(e,t){return p(e,i(t))},"SparseMatrix, any":function(e,t){return u(e,t,a,!1)},"DenseMatrix, any":function(e,t){return f(e,t,a,!1)},"any, SparseMatrix":function(e,t){return u(t,e,a,!0)},"any, DenseMatrix":function(e,t){return f(t,e,a,!0)},"Array, any":function(e,t){return f(i(e),t,a,!1).valueOf()},"any, Array":function(e,t){return f(i(t),e,a,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+l.operators.equal+"${args[1]}\\right)"},p}},function(e,t,s){var l=s(2),p=s(3).isInteger;t.name="eye",t.factory=function(f,r,e,t){var n=e(s(1)),i=t("eye",{"":function(){return"Matrix"===r.matrix?n([]):[]},string:function(e){return n(e)},"number | BigNumber":function(e){return o(e,e,"Matrix"===r.matrix?"default":void 0)},"number | BigNumber, string":function(e,t){return o(e,e,t)},"number | BigNumber, number | BigNumber":function(e,t){return o(e,t,"Matrix"===r.matrix?"default":void 0)},"number | BigNumber, number | BigNumber, string":function(e,t,r){return o(e,t,r)},Array:function(e){return a(e)},"Array, string":function(e,t){return a(e,t)},Matrix:function(e){return a(e.valueOf(),e.storage())},"Matrix, string":function(e,t){return a(e.valueOf(),t)}});return i.toTex=void 0,i;function a(e,t){switch(e.length){case 0:return t?n(t):[];case 1:return o(e[0],e[0],t);case 2:return o(e[0],e[1],t);default:throw new Error("Vector containing two values expected")}}function o(e,t,r){var n=f.isBigNumber(e)||f.isBigNumber(t)?f.BigNumber:null;if(f.isBigNumber(e)&&(e=e.toNumber()),f.isBigNumber(t)&&(t=t.toNumber()),!p(e)||e<1)throw new Error("Parameters in function eye must be positive integers");if(!p(t)||t<1)throw new Error("Parameters in function eye must be positive integers");var i=n?new f.BigNumber(1):1,a=n?new n(0):0,o=[e,t];if(r)return f.Matrix.storage(r).diagonal(o,i,0,a);for(var s=l.resize([],o,a),u=e<t?e:t,c=0;c<u;c++)s[c][c]=i;return s}}},function(e,t,n){var i=n(29),p=n(11),a=i.string,v=i.array,m=i.object,r=i.number,y=Array.isArray,x=r.isNumber,w=r.isInteger,b=a.isString,N=v.validateIndex;t.name="DenseMatrix",t.path="type",t.factory=function(h,e,t,d){var r=t(n(89));function g(e,t){if(!(this instanceof g))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!b(t))throw new Error("Invalid datatype: "+t);if(h.isMatrix(e))"DenseMatrix"===e.type?(this._data=m.clone(e._data),this._size=m.clone(e._size)):(this._data=e.toArray(),this._size=e.size()),this._datatype=t||e._datatype;else if(e&&y(e.data)&&y(e.size))this._data=e.data,this._size=e.size,this._datatype=t||e.datatype;else if(y(e))this._data=function e(t){for(var r=0,n=t.length;r<n;r++){var i=t[r];y(i)?t[r]=e(i):i&&!0===i.isMatrix&&(t[r]=e(i.valueOf()))}return t}(e),this._size=v.size(this._data),v.validate(this._data,this._size),this._datatype=t;else{if(e)throw new TypeError("Unsupported type of data ("+i.types.type(e)+")");this._data=[],this._size=[0],this._datatype=t}}(g.prototype=new r).type="DenseMatrix",g.prototype.isDenseMatrix=!0,g.prototype.storage=function(){return"dense"},g.prototype.datatype=function(){return this._datatype},g.prototype.create=function(e,t){return new g(e,t)},g.prototype.subset=function(e,t,r){switch(arguments.length){case 1:return function(e,t){if(!h.isIndex(t))throw new TypeError("Invalid index");if(t.isScalar())return e.get(t.min());var r=t.size();if(r.length!=e._size.length)throw new p(r.length,e._size.length);for(var n=t.min(),i=t.max(),a=0,o=e._size.length;a<o;a++)N(n[a],e._size[a]),N(i[a],e._size[a]);return new g(function r(n,i,a,o){var e=o===a-1,t=i.dimension(o);return e?t.map(function(e){return N(e,n.length),n[e]}).valueOf():t.map(function(e){N(e,n.length);var t=n[e];return r(t,i,a,o+1)}).valueOf()}(e._data,t,r.length,0),e._datatype)}(this,e);case 2:case 3:return function(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Invalid index");var i,a=t.size(),o=t.isScalar();if(h.isMatrix(r)?(i=r.size(),r=r.valueOf()):i=v.size(r),o){if(0!==i.length)throw new TypeError("Scalar expected");e.set(t.min(),r,n)}else{if(a.length<e._size.length)throw new p(a.length,e._size.length,"<");if(i.length<a.length){for(var s=0,u=0;1===a[s]&&1===i[s];)s++;for(;1===a[s];)u++,s++;r=v.unsqueeze(r,a.length,u,i)}if(!m.deepEqual(a,i))throw new p(a,i,">");var c=t.max().map(function(e){return e+1});l(e,c,n);var f=a.length;!function r(n,i,a,o,s){var e=s===o-1,t=i.dimension(s);e?t.forEach(function(e,t){N(e),n[e]=a[t[0]]}):t.forEach(function(e,t){N(e),r(n[e],i,a[t[0]],o,s+1)})}(e._data,t,r,f,0)}return e}(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}},g.prototype.get=function(e){if(!y(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new p(e.length,this._size.length);for(var t=0;t<e.length;t++)N(e[t],this._size[t]);for(var r=this._data,n=0,i=e.length;n<i;n++){var a=e[n];N(a,r.length),r=r[a]}return r},g.prototype.set=function(e,t,r){if(!y(e))throw new TypeError("Array expected");if(e.length<this._size.length)throw new p(e.length,this._size.length,"<");var n,i,a;l(this,e.map(function(e){return e+1}),r);var o=this._data;for(n=0,i=e.length-1;n<i;n++)a=e[n],N(a,o.length),o=o[a];return a=e[e.length-1],N(a,o.length),o[a]=t,this},g.prototype.resize=function(e,t,r){if(!y(e))throw new TypeError("Array expected");var n=r?this.clone():this;return s(n,e,t)};var s=function(e,t,r){if(0===t.length){for(var n=e._data;y(n);)n=n[0];return n}return e._size=t.slice(0),e._data=v.resize(e._data,e._size,r),e};function l(e,t,r){for(var n=e._size.slice(0),i=!1;n.length<t.length;)n.push(0),i=!0;for(var a=0,o=t.length;a<o;a++)t[a]>n[a]&&(n[a]=t[a],i=!0);i&&s(e,n,r)}return g.prototype.reshape=function(e,t){var r=t?this.clone():this;return r._data=v.reshape(r._data,e),r._size=e.slice(0),r},g.prototype.clone=function(){return new g({data:m.clone(this._data),size:m.clone(this._size),datatype:this._datatype})},g.prototype.size=function(){return this._size.slice(0)},g.prototype.map=function(t){var n=this,i=function(e,r){return y(e)?e.map(function(e,t){return i(e,r.concat(t))}):t(e,r,n)};return new g({data:i(this._data,[]),size:m.clone(this._size),datatype:this._datatype})},g.prototype.forEach=function(t){var n=this,i=function(e,r){y(e)?e.forEach(function(e,t){i(e,r.concat(t))}):t(e,r,n)};i(this._data,[])},g.prototype.toArray=function(){return m.clone(this._data)},g.prototype.valueOf=function(){return this._data},g.prototype.format=function(e){return a.format(this._data,e)},g.prototype.toString=function(){return a.format(this._data)},g.prototype.toJSON=function(){return{mathjs:"DenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},g.prototype.diagonal=function(e){if(e){if(h.isBigNumber(e)&&(e=e.toNumber()),!x(e)||!w(e))throw new TypeError("The parameter k must be an integer number")}else e=0;for(var t=0<e?e:0,r=e<0?-e:0,n=this._size[0],i=this._size[1],a=Math.min(n-r,i-t),o=[],s=0;s<a;s++)o[s]=this._data[s+r][s+t];return new g({data:o,size:[a],datatype:this._datatype})},g.diagonal=function(e,t,r,n,i){if(!y(e))throw new TypeError("Array expected, size parameter");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");if(e=e.map(function(e){if(h.isBigNumber(e)&&(e=e.toNumber()),!x(e)||!w(e)||e<1)throw new Error("Size values must be positive integers");return e}),r){if(h.isBigNumber(r)&&(r=r.toNumber()),!x(r)||!w(r))throw new TypeError("The parameter k must be an integer number")}else r=0;n&&b(i)&&(n=d.convert(n,i));var a,o=0<r?r:0,s=r<0?-r:0,u=e[0],c=e[1],f=Math.min(u-s,c-o);if(y(t)){if(t.length!==f)throw new Error("Invalid value array length");a=function(e){return t[e]}}else if(h.isMatrix(t)){var l=t.size();if(1!==l.length||l[0]!==f)throw new Error("Invalid matrix length");a=function(e){return t.get([e])}}else a=function(){return t};n||(n=h.isBigNumber(a(0))?new h.BigNumber(0):0);var p=[];if(0<e.length){p=v.resize(p,e,n);for(var m=0;m<f;m++)p[m+s][m+o]=a(m)}return new g({data:p,size:[u,c]})},g.fromJSON=function(e){return new g(e)},g.prototype.swapRows=function(e,t){if(!(x(e)&&w(e)&&x(t)&&w(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return N(e,this._size[0]),N(t,this._size[0]),g._swapRows(e,t,this._data),this},g._swapRows=function(e,t,r){var n=r[e];r[e]=r[t],r[t]=n},h.Matrix._storage.dense=g,h.Matrix._storage.default=g},t.lazy=!1},function(e,t,r){function i(e,t,r,n){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=t,this.min=r,this.max=n,this.message="Wrong number of arguments in function "+e+" ("+t+" provided, "+r+(null!=n?"-"+n:"")+" expected)",this.stack=(new Error).stack}(i.prototype=new Error).constructor=Error,i.prototype.name="ArgumentsError",i.prototype.isArgumentsError=!0,e.exports=i},function(e,t,r){var a=r(0);r(3);t.name="isNegative",t.factory=function(e,t,r,n){var i=n("isNegative",{number:function(e){return e<0},BigNumber:function(e){return e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s<0},Unit:function(e){return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){var a=r(0);r(3);t.name="isPositive",t.factory=function(e,t,r,n){var i=n("isPositive",{number:function(e){return 0<e},BigNumber:function(e){return!e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return 0<e.s&&0<e.n},Unit:function(e){return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){var a=r(0);r(3);t.name="isZero",t.factory=function(e,t,r,n){var i=n("isZero",{number:function(e){return 0===e},BigNumber:function(e){return e.isZero()},Complex:function(e){return 0===e.re&&0===e.im},Fraction:function(e){return 1===e.d&&0===e.n},Unit:function(e){return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,o){var h=o(4),s=o(2).map,f=o(9).escape,u=o(15).isSafeMethod,c=o(15).getSafeProperty,x=o(59);t.name="OperatorNode",t.path="expression.node",t.factory=function(i,e,t,r){var n=t(o(14));function a(e,t,r,n){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('string expected for parameter "op"');if("string"!=typeof t)throw new TypeError('string expected for parameter "fn"');if(!Array.isArray(r)||!r.every(i.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.implicit=!0===n,this.op=e,this.fn=t,this.args=r||[]}function m(i,a,e,t,r){var o=x.getPrecedence(i,a),s=x.getAssociativity(i,a);if("all"===a||2<t.length&&"OperatorNode:add"!==i.getIdentifier()&&"OperatorNode:multiply"!==i.getIdentifier())return t.map(function(e){switch(e.getContent().type){case"ArrayNode":case"ConstantNode":case"SymbolNode":case"ParenthesisNode":return!1;default:return!0}});var n=void 0;switch(t.length){case 0:n=[];break;case 1:var u=x.getPrecedence(t[0],a);if(r&&null!==u){var c;if("keep"===a?(c=t[0].getIdentifier(),h=i.getIdentifier()):(c=t[0].getContent().getIdentifier(),h=i.getContent().getIdentifier()),!1===x.properties[o][h].latexLeftParens){n=[!1];break}if(!1===x.properties[u][c].latexParens){n=[!1];break}}if(null===u){n=[!1];break}if(u<=o){n=[!0];break}n=[!1];break;case 2:var f,l,p=x.getPrecedence(t[0],a),m=x.isAssociativeWith(i,t[0],a);f=null!==p&&(p===o&&"right"===s&&!m||p<o);var h,d,g,v=x.getPrecedence(t[1],a),y=x.isAssociativeWith(i,t[1],a);l=null!==v&&(v===o&&"left"===s&&!y||v<o),r&&("keep"===a?(h=i.getIdentifier(),d=i.args[0].getIdentifier(),g=i.args[1].getIdentifier()):(h=i.getContent().getIdentifier(),d=i.args[0].getContent().getIdentifier(),g=i.args[1].getContent().getIdentifier()),null!==p&&(!1===x.properties[o][h].latexLeftParens&&(f=!1),!1===x.properties[p][d].latexParens&&(f=!1)),null!==v&&(!1===x.properties[o][h].latexRightParens&&(l=!1),!1===x.properties[v][g].latexParens&&(l=!1))),n=[f,l];break;default:"OperatorNode:add"!==i.getIdentifier()&&"OperatorNode:multiply"!==i.getIdentifier()||(n=t.map(function(e){var t=x.getPrecedence(e,a),r=x.isAssociativeWith(i,e,a),n=x.getAssociativity(e,a);return null!==t&&(o===t&&s===n&&!r||t<o)}))}return 2<=t.length&&"OperatorNode:multiply"===i.getIdentifier()&&i.implicit&&"auto"===a&&"hide"===e&&(n=t.map(function(e,t){var r="ParenthesisNode"===e.getIdentifier();return!(!n[t]&&!r)})),n}return(a.prototype=new n).type="OperatorNode",a.prototype.isOperatorNode=!0,a.prototype._compile=function(t,r){if("string"!=typeof this.fn||!u(t,this.fn))throw t[this.fn]?new Error('No access to function "'+this.fn+'"'):new Error("Function "+this.fn+' missing in provided namespace "math"');var i=c(t,this.fn),e=s(this.args,function(e){return e._compile(t,r)});if(1===e.length){var n=e[0];return function(e,t,r){return i(n(e,t,r))}}if(2===e.length){n=e[0];var a=e[1];return function(e,t,r){return i(n(e,t,r),a(e,t,r))}}return function(t,r,n){return i.apply(null,s(e,function(e){return e(t,r,n)}))}},a.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},a.prototype.map=function(e){for(var t=[],r=0;r<this.args.length;r++)t[r]=this._ifNode(e(this.args[r],"args["+r+"]",this));return new a(this.op,this.fn,t,this.implicit)},a.prototype.clone=function(){return new a(this.op,this.fn,this.args.slice(0),this.implicit)},a.prototype.isUnary=function(){return 1===this.args.length},a.prototype.isBinary=function(){return 2===this.args.length},a.prototype._toString=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=m(this,e,t,n,!1);if(1===n.length){var a=x.getAssociativity(this,e),o=n[0].toString(r);return i[0]&&(o="("+o+")"),"right"===a?this.op+o:o+this.op}if(2==n.length){var s=n[0].toString(r),u=n[1].toString(r);return i[0]&&(s="("+s+")"),i[1]&&(u="("+u+")"),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==t?s+" "+u:s+" "+this.op+" "+u}if(2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var c=n.map(function(e,t){return e=e.toString(r),i[t]&&(e="("+e+")"),e});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?c.join(" "):c.join(" "+this.op+" ")}return this.fn+"("+this.args.join(", ")+")"},a.prototype.toJSON=function(){return{mathjs:"OperatorNode",op:this.op,fn:this.fn,args:this.args,implicit:this.implicit}},a.fromJSON=function(e){return new a(e.op,e.fn,e.args,e.implicit)},a.prototype.toHTML=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=m(this,e,t,n,!1);if(1===n.length){var a=x.getAssociativity(this,e),o=n[0].toHTML(r);return i[0]&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>'),"right"===a?'<span class="math-operator math-unary-operator math-lefthand-unary-operator">'+f(this.op)+"</span>"+o:'<span class="math-operator math-unary-operator math-righthand-unary-operator">'+f(this.op)+"</span>"+o}if(2==n.length){var s=n[0].toHTML(r),u=n[1].toHTML(r);return i[0]&&(s='<span class="math-parenthesis math-round-parenthesis">(</span>'+s+'<span class="math-parenthesis math-round-parenthesis">)</span>'),i[1]&&(u='<span class="math-parenthesis math-round-parenthesis">(</span>'+u+'<span class="math-parenthesis math-round-parenthesis">)</span>'),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==t?s+'<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'+u:s+'<span class="math-operator math-binary-operator math-explicit-binary-operator">'+f(this.op)+"</span>"+u}if(2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var c=n.map(function(e,t){return e=e.toHTML(r),i[t]&&(e='<span class="math-parenthesis math-round-parenthesis">(</span>'+e+'<span class="math-parenthesis math-round-parenthesis">)</span>'),e});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?c.join('<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'):c.join('<span class="math-operator math-binary-operator math-explicit-binary-operator">'+f(this.op)+"</span>")}return'<span class="math-function">'+f(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+c.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'},a.prototype._toTex=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=m(this,e,t,n,!0),a=h.operators[this.fn];if(a=void 0===a?this.op:a,1===n.length){var o=x.getAssociativity(this,e),s=n[0].toTex(r);return i[0]&&(s="\\left("+s+"\\right)"),"right"===o?a+s:s+a}if(2===n.length){var u=n[0],c=u.toTex(r);i[0]&&(c="\\left("+c+"\\right)");var f,l=n[1].toTex(r);switch(i[1]&&(l="\\left("+l+"\\right)"),f="keep"===e?u.getIdentifier():u.getContent().getIdentifier(),this.getIdentifier()){case"OperatorNode:divide":return a+"{"+c+"}{"+l+"}";case"OperatorNode:pow":switch(c="{"+c+"}",l="{"+l+"}",f){case"ConditionalNode":case"OperatorNode:divide":c="\\left("+c+"\\right)"}case"OperatorNode:multiply":if(this.implicit&&"hide"===t)return c+"~"+l}return c+a+l}if(2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var p=n.map(function(e,t){return e=e.toTex(r),i[t]&&(e="\\left("+e+"\\right)"),e});return"OperatorNode:multiply"===this.getIdentifier()&&this.implicit?p.join("~"):p.join(a)}return"\\mathrm{"+this.fn+"}\\left("+n.map(function(e){return e.toTex(r)}).join(",")+"\\right)"},a.prototype.getIdentifier=function(){return this.type+":"+this.fn},a}},function(e,t,s){var u=s(9).format,c=s(4).escape;t.name="ConstantNode",t.path="expression.node",t.factory=function(e,t,r,n){var i=r(s(14)),a=r(s(49));function o(e){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");if(2===arguments.length)throw new SyntaxError("new ConstantNode(valueStr, valueType) is not supported anymore since math v4.0.0. Use new ConstantNode(value) instead, where value is a non-stringified value.");this.value=e}return(o.prototype=new i).type="ConstantNode",o.prototype.isConstantNode=!0,o.prototype._compile=function(e,t){var r=this.value;return function(){return r}},o.prototype.forEach=function(e){},o.prototype.map=function(e){return this.clone()},o.prototype.clone=function(){return new o(this.value)},o.prototype._toString=function(e){return u(this.value,e)},o.prototype.toHTML=function(e){var t=this._toString(e);switch(a(this.value)){case"number":case"BigNumber":case"Fraction":return'<span class="math-number">'+t+"</span>";case"string":return'<span class="math-string">'+t+"</span>";case"boolean":return'<span class="math-boolean">'+t+"</span>";case"null":return'<span class="math-null-symbol">'+t+"</span>";case"undefined":return'<span class="math-undefined">'+t+"</span>";default:return'<span class="math-symbol">'+t+"</span>"}},o.prototype.toJSON=function(){return{mathjs:"ConstantNode",value:this.value}},o.fromJSON=function(e){return new o(e.value)},o.prototype._toTex=function(e){var t=this._toString(e);switch(a(this.value)){case"string":return"\\mathtt{"+c(t)+"}";case"number":case"BigNumber":var r=t.toLowerCase().indexOf("e");return-1!==r?t.substring(0,r)+"\\cdot10^{"+t.substring(r+1)+"}":t;case"Fraction":return this.value.toLatex();default:return t}},o}},function(e,t,r){var f=[{AssignmentNode:{},FunctionAssignmentNode:{}},{ConditionalNode:{latexLeftParens:!1,latexRightParens:!1,latexParens:!1}},{"OperatorNode:or":{associativity:"left",associativeWith:[]}},{"OperatorNode:xor":{associativity:"left",associativeWith:[]}},{"OperatorNode:and":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitOr":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitXor":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitAnd":{associativity:"left",associativeWith:[]}},{"OperatorNode:equal":{associativity:"left",associativeWith:[]},"OperatorNode:unequal":{associativity:"left",associativeWith:[]},"OperatorNode:smaller":{associativity:"left",associativeWith:[]},"OperatorNode:larger":{associativity:"left",associativeWith:[]},"OperatorNode:smallerEq":{associativity:"left",associativeWith:[]},"OperatorNode:largerEq":{associativity:"left",associativeWith:[]}},{"OperatorNode:leftShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightArithShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightLogShift":{associativity:"left",associativeWith:[]}},{"OperatorNode:to":{associativity:"left",associativeWith:[]}},{RangeNode:{}},{"OperatorNode:add":{associativity:"left",associativeWith:["OperatorNode:add","OperatorNode:subtract"]},"OperatorNode:subtract":{associativity:"left",associativeWith:[]}},{"OperatorNode:multiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","Operator:dotMultiply","Operator:dotDivide"]},"OperatorNode:divide":{associativity:"left",associativeWith:[],latexLeftParens:!1,latexRightParens:!1,latexParens:!1},"OperatorNode:dotMultiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","OperatorNode:dotMultiply","OperatorNode:doDivide"]},"OperatorNode:dotDivide":{associativity:"left",associativeWith:[]},"OperatorNode:mod":{associativity:"left",associativeWith:[]}},{"OperatorNode:unaryPlus":{associativity:"right"},"OperatorNode:unaryMinus":{associativity:"right"},"OperatorNode:bitNot":{associativity:"right"},"OperatorNode:not":{associativity:"right"}},{"OperatorNode:pow":{associativity:"right",associativeWith:[],latexRightParens:!1},"OperatorNode:dotPow":{associativity:"right",associativeWith:[]}},{"OperatorNode:factorial":{associativity:"left"}},{"OperatorNode:transpose":{associativity:"left"}}];function l(e,t){var r=e;"keep"!==t&&(r=e.getContent());for(var n=r.getIdentifier(),i=0;i<f.length;i++)if(n in f[i])return i;return null}e.exports.properties=f,e.exports.getPrecedence=l,e.exports.getAssociativity=function(e,t){var r=e;"keep"!==t&&(r=e.getContent());var n=r.getIdentifier(),i=l(r,t);if(null===i)return null;var a=f[i][n];if(a.hasOwnProperty("associativity")){if("left"===a.associativity)return"left";if("right"===a.associativity)return"right";throw Error("'"+n+"' has the invalid associativity '"+a.associativity+"'.")}return null},e.exports.isAssociativeWith=function(e,t,r){var n=e,i=t;"keep"!==r&&(n=e.getContent(),i=t.getContent());var a=n.getIdentifier(),o=i.getIdentifier(),s=l(n,r);if(null===s)return null;var u=f[s][a];if(u.hasOwnProperty("associativeWith")&&u.associativeWith instanceof Array){for(var c=0;c<u.associativeWith.length;c++)if(u.associativeWith[c]===o)return!0;return!1}return null}},function(e,t,r){var a=r(0);r(3);t.name="isNumeric",t.factory=function(e,t,r,n){var i=n("isNumeric",{"number | BigNumber | Fraction | boolean":function(){return!0},"Complex | Unit | string":function(){return!1},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=t):(this.min=t,this.max=r),void 0!==this.min&&this.index<this.min?this.message="Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?this.message="Index out of range ("+this.index+" > "+(this.max-1)+")":this.message="Index out of range ("+this.index+")",this.stack=(new Error).stack}(n.prototype=new RangeError).constructor=RangeError,n.prototype.name="IndexError",n.prototype.isIndexError=!0,e.exports=n},function(e,t,r){var a=r(3).isInteger;function u(e){return e.isInteger()&&e.gte(0)}t.name="combinations",t.factory=function(s,e,t,r){var n=r("combinations",{"number, number":function(e,t){var r,n,i;if(!a(e)||e<0)throw new TypeError("Positive integer value expected in function combinations");if(!a(t)||t<0)throw new TypeError("Positive integer value expected in function combinations");if(e<t)throw new TypeError("k must be less than or equal to n");for(r=Math.max(t,e-t),i=n=1;i<=e-r;i++)n=n*(r+i)/i;return n},"BigNumber, BigNumber":function(e,t){var r,n,i,a,o=new s.BigNumber(1);if(!u(e)||!u(t))throw new TypeError("Positive integer value expected in function combinations");if(t.gt(e))throw new TypeError("k must be less than n in function combinations");for(r=e.minus(t),t.lt(r)&&(r=t),i=n=o,a=e.minus(r);i.lte(a);i=i.plus(1))n=n.times(r.plus(i)).dividedBy(i);return n}});return n.toTex={2:"\\binom{${args[0]}}{${args[1]}}"},n}},function(e,t,s){var u=s(0);t.name="factorial",t.factory=function(e,t,r,n){var i=r(s(100)),a=s(4),o=n("factorial",{number:function(e){if(e<0)throw new Error("Value must be non-negative");return i(e+1)},BigNumber:function(e){if(e.isNegative())throw new Error("Value must be non-negative");return i(e.plus(1))},"Array | Matrix":function(e){return u(e,o)}});return o.toTex={1:"\\left(${args[0]}\\right)"+a.operators.factorial},o}},function(e,t,n){var z=n(266),B=n(11);t.name="algorithm06",t.factory=function(e,t,r,_){var T=r(n(10)),C=e.SparseMatrix;return function(e,t,r){var n=e._values,i=e._size,a=e._datatype,o=t._values,s=t._size,u=t._datatype;if(i.length!==s.length)throw new B(i.length,s.length);if(i[0]!==s[0]||i[1]!==s[1])throw new RangeError("Dimension mismatch. Matrix A ("+i+") must match Matrix B ("+s+")");var c,f=i[0],l=i[1],p=T,m=0,h=r;"string"==typeof a&&a===u&&(c=a,p=_.find(T,[c,c]),m=_.convert(0,c),h=_.find(r,[c,c]));for(var d=n&&o?[]:void 0,g=[],v=[],y=new C({values:d,index:g,ptr:v,size:[f,l],datatype:c}),x=d?[]:void 0,w=[],b=[],N=0;N<l;N++){v[N]=g.length;var M=N+1;if(z(e,N,w,x,b,M,y,h),z(t,N,w,x,b,M,y,h),x)for(var E=v[N];E<g.length;){var A=g[E];if(b[A]===M){var O=x[A];p(O,m)?g.splice(E,1):(d.push(O),E++)}else g.splice(E,1)}else for(var S=v[N];S<g.length;)b[g[S]]!==M?g.splice(S,1):S++}return v[l]=g.length,y}}},function(e,t,f){var b=f(5).clone,l=f(9).format;t.name="transpose",t.factory=function(e,t,r,n){var i=f(4),a=r(f(1)),u=e.DenseMatrix,w=e.SparseMatrix,o=n("transpose",{Array:function(e){return o(a(e)).valueOf()},Matrix:function(e){var t,r=e.size();switch(r.length){case 1:t=e.clone();break;case 2:var n=r[0],i=r[1];if(0===i)throw new RangeError("Cannot transpose a 2D matrix with no columns (size: "+l(r)+")");switch(e.storage()){case"dense":t=s(e,n,i);break;case"sparse":t=c(e,n,i)}break;default:throw new RangeError("Matrix must be a vector or two dimensional (size: "+l(this._size)+")")}return t},any:function(e){return b(e)}}),s=function(e,t,r){for(var n,i=e._data,a=[],o=0;o<r;o++){n=a[o]=[];for(var s=0;s<t;s++)n[s]=b(i[s][o])}return new u({data:a,size:[r,t],datatype:e._datatype})},c=function(e,t,r){for(var n,i,a,o=e._values,s=e._index,u=e._ptr,c=o?[]:void 0,f=[],l=[],p=[],m=0;m<t;m++)p[m]=0;for(n=0,i=s.length;n<i;n++)p[s[n]]++;for(var h=0,d=0;d<t;d++)l.push(h),h+=p[d],p[d]=l[d];for(l.push(h),a=0;a<r;a++)for(var g=u[a],v=u[a+1],y=g;y<v;y++){var x=p[s[y]]++;f[x]=a,o&&(c[x]=b(o[y]))}return new w({values:c,index:f,ptr:l,size:[r,t],datatype:e._datatype})};return o.toTex={1:"\\left(${args[0]}\\right)"+i.operators.transpose},o}},function(e,t,s){var u=s(29);t.name="inv",t.factory=function(i,e,t,r){var a=t(s(1)),g=t(s(12)),v=t(s(20)),y=t(s(8)),x=t(s(32)),w=t(s(121)),b=t(s(51)),n=r("inv",{"Array | Matrix":function(e){var t=i.isMatrix(e)?e.size():u.array.size(e);switch(t.length){case 1:if(1==t[0])return i.isMatrix(e)?a([g(1,e.valueOf()[0])]):[g(1,e[0])];throw new RangeError("Matrix must be square (size: "+u.string.format(t)+")");case 2:var r=t[0],n=t[1];if(r==n)return i.isMatrix(e)?a(o(e.valueOf(),r,n),e.storage()):o(e,r,n);throw new RangeError("Matrix must be square (size: "+u.string.format(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+u.string.format(t)+")")}},any:function(e){return g(1,e)}});function o(e,t,r){var n,i,a,o,s;if(1==t){if(0==(o=e[0][0]))throw Error("Cannot calculate inverse, determinant is zero");return[[g(1,o)]]}if(2==t){var u=w(e);if(0==u)throw Error("Cannot calculate inverse, determinant is zero");return[[g(e[1][1],u),g(x(e[0][1]),u)],[g(x(e[1][0]),u),g(e[0][0],u)]]}var c=e.concat();for(n=0;n<t;n++)c[n]=c[n].concat();for(var f=b(t).valueOf(),l=0;l<r;l++){for(n=l;n<t&&0==c[n][l];)n++;if(n==t||0==c[n][l])throw Error("Cannot calculate inverse, determinant is zero");n!=l&&(s=c[l],c[l]=c[n],c[n]=s,s=f[l],f[l]=f[n],f[n]=s);var p=c[l],m=f[l];for(n=0;n<t;n++){var h=c[n],d=f[n];if(n!=l){if(0!=h[l]){for(a=g(x(h[l]),p[l]),i=l;i<r;i++)h[i]=v(h[i],y(a,p[i]));for(i=0;i<r;i++)d[i]=v(d[i],y(a,m[i]))}}else{for(a=p[l],i=l;i<r;i++)h[i]=g(h[i],a);for(i=0;i<r;i++)d[i]=g(d[i],a)}}}return f}return n.toTex={1:"\\left(${args[0]}\\right)^{-1}"},n}},function(e,t,r){var n=r(47);e.exports=function(e){for(var t=0;t<e.length;t++)if(n(e[t]))return!0;return!1}},function(e,t,i){var m=i(5).clone,h=i(3).isInteger,d=i(2),g=i(61),v=i(11);function y(e,t,r,n){if(n<r){if(e.length!=t.length)throw new v(e.length,t.length);for(var i=[],a=0;a<e.length;a++)i[a]=y(e[a],t[a],r,n+1);return i}return e.concat(t)}t.name="concat",t.factory=function(l,e,t,r){var p=t(i(1)),n=r("concat",{"...Array | Matrix | number | BigNumber":function(e){var t,r,n=e.length,i=-1,a=!1,o=[];for(t=0;t<n;t++){var s=e[t];if(l.isMatrix(s)&&(a=!0),l.isNumber(s)||l.isBigNumber(s)){if(t!==n-1)throw new Error("Dimension must be specified as last argument");if(r=i,i=s.valueOf(),!h(i))throw new TypeError("Integer number expected for dimension");if(i<0||0<t&&r<i)throw new g(i,r+1)}else{var u=m(s).valueOf(),c=d.size(u);if(o[t]=u,r=i,i=c.length-1,0<t&&i!=r)throw new v(r+1,i+1)}}if(0==o.length)throw new SyntaxError("At least one matrix expected");for(var f=o.shift();o.length;)f=y(f,o.shift(),i,0);return a?p(f):f},"...string":function(e){return e.join("")}});return n.toTex=void 0,n}},function(e,t,c){var f=c(4),l=c(9).escape,p=c(5).hasOwnProperty,d=c(2).map,g=c(15).validateSafeMethod,v=c(15).getSafeProperty;t.name="FunctionNode",t.path="expression.node",t.math=!0,t.factory=function(m,e,t,r,i){var n=t(c(14)),a=t(c(48));function h(e,t){if(!(this instanceof h))throw new SyntaxError("Constructor must be called with the new operator");if("string"==typeof e&&(e=new a(e)),!m.isNode(e))throw new TypeError('Node expected as parameter "fn"');if(!Array.isArray(t)||!t.every(m.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.fn=e,this.args=t||[],Object.defineProperty(this,"name",{get:function(){return this.fn.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}});var r=function(){throw new Error("Property `FunctionNode.object` is deprecated, use `FunctionNode.fn` instead")};Object.defineProperty(this,"object",{get:r,set:r})}(h.prototype=new n).type="FunctionNode",h.prototype.isFunctionNode=!0,h.prototype._compile=function(i,t){if(!(this instanceof h))throw new TypeError("No valid FunctionNode");var a=d(this.args,function(e){return e._compile(i,t)});if(m.isSymbolNode(this.fn)){var o=this.fn.name,s=o in i?v(i,o):void 0;if("function"==typeof s&&1==s.rawArgs){var u=this.args;return function(e,t,r){return(o in e?v(e,o):s)(u,i,e)}}if(1===a.length){var n=a[0];return function(e,t,r){return(o in e?v(e,o):s)(n(e,t,r))}}if(2===a.length){n=a[0];var c=a[1];return function(e,t,r){return(o in e?v(e,o):s)(n(e,t,r),c(e,t,r))}}return function(t,r,n){return(o in t?v(t,o):s).apply(null,d(a,function(e){return e(t,r,n)}))}}if(m.isAccessorNode(this.fn)&&m.isIndexNode(this.fn.index)&&this.fn.index.isObjectProperty()){var f=this.fn.object._compile(i,t),l=this.fn.index.getObjectProperty();return u=this.args,function(t,r,n){var e=f(t,r,n);return g(e,l),e[l]&&e[l].rawArgs?e[l](u,i,t):e[l].apply(e,d(a,function(e){return e(t,r,n)}))}}var p=this.fn._compile(i,t);return function(t,r,n){var e=p(t,r,n);return e&&e.rawArgs?e(u,i,t):e.apply(e,d(a,function(e){return e(t,r,n)}))}},h.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},h.prototype.map=function(e){for(var t=this.fn.map(e),r=[],n=0;n<this.args.length;n++)r[n]=this._ifNode(e(this.args[n],"args["+n+"]",this));return new h(t,r)},h.prototype.clone=function(){return new h(this.fn,this.args.slice(0))};var o=h.prototype.toString;function s(e,t,r){for(var n,i="",a=new RegExp("\\$(?:\\{([a-z_][a-z_0-9]*)(?:\\[([0-9]+)\\])?\\}|\\$)","ig"),o=0;null!==(n=a.exec(e));)if(i+=e.substring(o,n.index),o=n.index,"$$"===n[0])i+="$",o++;else{o+=n[0].length;var s=t[n[1]];if(!s)throw new ReferenceError("Template: Property "+n[1]+" does not exist.");if(void 0===n[2])switch(typeof s){case"string":i+=s;break;case"object":if(m.isNode(s))i+=s.toTex(r);else{if(!Array.isArray(s))throw new TypeError("Template: "+n[1]+" has to be a Node, String or array of Nodes");i+=s.map(function(e,t){if(m.isNode(e))return e.toTex(r);throw new TypeError("Template: "+n[1]+"["+t+"] is not a Node.")}).join(",")}break;default:throw new TypeError("Template: "+n[1]+" has to be a Node, String or array of Nodes")}else{if(!m.isNode(s[n[2]]&&s[n[2]]))throw new TypeError("Template: "+n[1]+"["+n[2]+"] is not a Node.");i+=s[n[2]].toTex(r)}}return i+=e.slice(o)}h.prototype.toString=function(e){var t,r=this.fn.toString(e);return e&&"object"==typeof e.handler&&p(e.handler,r)&&(t=e.handler[r](this,e)),void 0!==t?t:o.call(this,e)},h.prototype._toString=function(t){var e=this.args.map(function(e){return e.toString(t)});return(m.isFunctionAssignmentNode(this.fn)?"("+this.fn.toString(t)+")":this.fn.toString(t))+"("+e.join(", ")+")"},h.prototype.toJSON=function(){return{mathjs:"FunctionNode",fn:this.fn,args:this.args}},h.fromJSON=function(e){return new h(e.fn,e.args)},h.prototype.toHTML=function(t){var e=this.args.map(function(e){return e.toHTML(t)});return'<span class="math-function">'+l(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+e.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'};var u=h.prototype.toTex;return h.prototype.toTex=function(e){var t;return e&&"object"==typeof e.handler&&p(e.handler,this.name)&&(t=e.handler[this.name](this,e)),void 0!==t?t:u.call(this,e)},h.prototype._toTex=function(t){var e,r,n=this.args.map(function(e){return e.toTex(t)});switch(!i[this.name]||"function"!=typeof i[this.name].toTex&&"object"!=typeof i[this.name].toTex&&"string"!=typeof i[this.name].toTex||(e=i[this.name].toTex),typeof e){case"function":r=e(this,t);break;case"string":r=s(e,this,t);break;case"object":switch(typeof e[n.length]){case"function":r=e[n.length](this,t);break;case"string":r=s(e[n.length],this,t)}}return void 0!==r?r:s(f.defaultTemplate,this,t)},h.prototype.getIdentifier=function(){return this.type+":"+this.name},h}},function(e,t,o){t.name="ParenthesisNode",t.path="expression.node",t.factory=function(t,e,r,n){var i=r(o(14));function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!t.isNode(e))throw new TypeError('Node expected for parameter "content"');this.content=e}return(a.prototype=new i).type="ParenthesisNode",a.prototype.isParenthesisNode=!0,a.prototype._compile=function(e,t){return this.content._compile(e,t)},a.prototype.getContent=function(){return this.content.getContent()},a.prototype.forEach=function(e){e(this.content,"content",this)},a.prototype.map=function(e){return new a(e(this.content,"content",this))},a.prototype.clone=function(){return new a(this.content)},a.prototype._toString=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"("+this.content.toString(e)+")":this.content.toString(e)},a.prototype.toJSON=function(){return{mathjs:"ParenthesisNode",content:this.content}},a.fromJSON=function(e){return new a(e.content)},a.prototype.toHTML=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?'<span class="math-parenthesis math-round-parenthesis">(</span>'+this.content.toHTML(e)+'<span class="math-parenthesis math-round-parenthesis">)</span>':this.content.toHTML(e)},a.prototype._toTex=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"\\left("+this.content.toTex(e)+"\\right)":this.content.toTex(e)},a}},function(e,t,n){var q=n(11);t.name="algorithm05",t.factory=function(e,t,r,R){var U=r(n(10)),k=e.SparseMatrix;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,p=t._datatype;if(o.length!==l.length)throw new q(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var m,h=o[0],d=o[1],g=U,v=0,y=r;"string"==typeof s&&s===p&&(m=s,g=R.find(U,[m,m]),v=R.convert(0,m),y=R.find(r,[m,m]));var x,w,b,N,M=n&&u?[]:void 0,E=[],A=[],O=new k({values:M,index:E,ptr:A,size:[h,d],datatype:m}),S=M?[]:void 0,_=M?[]:void 0,T=[],C=[];for(w=0;w<d;w++){A[w]=E.length;var z=w+1;for(b=a[w],N=a[w+1];b<N;b++)x=i[b],E.push(x),T[x]=z,S&&(S[x]=n[b]);for(b=f[w],N=f[w+1];b<N;b++)T[x=c[b]]!==z&&E.push(x),C[x]=z,_&&(_[x]=u[b]);if(M)for(b=A[w];b<E.length;){var B=T[x=E[b]],I=C[x];if(B===z||I===z){var P=y(B===z?S[x]:v,I===z?_[x]:v);g(P,v)?E.splice(b,1):(M.push(P),b++)}}}return A[d]=E.length,O}}},function(e,t,r){e.exports=function(e){return e&&e.constructor.prototype.isMatrix||!1}},function(e,t,i){var d=i(53),g=i(47),v=i(3).isNumber;t.name="distribution",t.factory=function(l,e,t,c,r){var f=t(i(1)),p=i(2),m=t(i(207));function n(e){if(!h.hasOwnProperty(e))throw new Error("Unknown distribution "+e);var r,t,a,s,o,u,n=Array.prototype.slice.call(arguments,1),i=h[e].apply(this,n);return r=i,t={random:function(e,t,r){var n,i,a;if(3<arguments.length)throw new d("random",arguments.length,0,3);if(1===arguments.length?g(e)?n=e:a=e:2===arguments.length?(g(e)?n=e:i=e,a=t):(n=e,i=t,a=r),void 0!==i&&!v(i)||void 0!==a&&!v(a))throw new TypeError("Invalid argument in function random");if(void 0===a&&(a=1),void 0===i&&(i=0),void 0!==n){var o=u(n.valueOf(),i,a,s);return l.isMatrix(n)?f(o):o}return s(i,a)},randomInt:c({"number | Array":function(e){if(g(e)){var t=e,r=1,n=u(t.valueOf(),0,r,o);return l.isMatrix(t)?f(n):n}return o(0,r=e)},"number | Array, number":function(e,t){if(g(e)){var r=e,n=t,i=0,a=u(r.valueOf(),i,n,o);return l.isMatrix(r)?f(a):a}return o(i=e,n=t)},"Array, number, number":function(e,t,r){var n=u(e.valueOf(),t,r,o);return e&&!0===e.isMatrix?f(n):n}}),pickRandom:c({Array:function(e){return a(e)},"Array, number | Array":function(e,t){var r,n;if(Array.isArray(t))n=t;else{if(!v(t))throw new TypeError("Invalid argument in function pickRandom");r=t}return a(e,r,n)},"Array, number | Array, Array | number":function(e,t,r){var n,i;if(Array.isArray(t)?(i=t,n=r):(i=r,n=t),!Array.isArray(i)||!v(n))throw new TypeError("Invalid argument in function pickRandom");return a(e,n,i)}})},a=function(e,t,r){var n=void 0===t;if(n&&(t=1),l.isMatrix(e))e=e.valueOf();else if(!Array.isArray(e))throw new TypeError("Unsupported type of value in function pickRandom");if(1<p.size(e).length)throw new Error("Only one dimensional vectors supported");if(void 0!==r){if(r.length!=e.length)throw new Error("Weights must have the same length as possibles");for(var i=0,a=0,o=r.length;a<o;a++){if(!v(r[a])||r[a]<0)throw new Error("Weights must be an array of positive numbers");i+=r[a]}}var s=e.length;if(0==s)return[];if(s<=t)return 1<t?e:e[0];for(var u,c=[];c.length<t;){if(void 0===r)u=e[Math.floor(m()*s)];else{var f=m()*i;for(a=0,o=e.length;a<o;a++)if((f-=r[a])<0){u=e[a];break}}-1==c.indexOf(u)&&c.push(u)}return n?c[0]:c},s=function(e,t){return e+r()*(t-e)},o=function(e,t){return Math.floor(e+r()*(t-e))},u=function(e,t,r,n){var i=[];if(1<(e=e.slice(0)).length)for(var a=0,o=e.shift();a<o;a++)i.push(u(e,t,r,n));else for(a=0,o=e.shift();a<o;a++)i.push(n(t,r));return i},t}var h={uniform:function(){return m},normal:function(){return function(){for(var e,t,r=-1;r<0||1<r;)e=m(),t=m(),r=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*t)+.5;return r}}};return n.toTex=void 0,n}},function(e,t,u){var c=u(3).isInteger;t.name="partitionSelect",t.factory=function(n,e,t,r){var i=t(u(45));function a(e,t){return-i(e,t)}return r("partitionSelect",{"Array | Matrix, number":function(e,t){return o(e,t,i)},"Array | Matrix, number, string":function(e,t,r){if("asc"===r)return o(e,t,i);if("desc"===r)return o(e,t,a);throw new Error('Compare string must be "asc" or "desc"')},"Array | Matrix, number, function":o});function o(e,t,r){if(!c(t)||t<0)throw new Error("k must be a non-negative integer");if(n.isMatrix(e)){if(1<e.size().length)throw new Error("Only one dimensional matrices supported");return s(e.valueOf(),t,r)}if(Array.isArray(e))return s(e,t,r)}function s(e,t,r){if(t>=e.length)throw new Error("k out of bounds");for(var n=0,i=e.length-1;n<i;){for(var a=n,o=i,s=e[Math.floor(Math.random()*(i-n+1))+n];a<o;)if(0<=r(e[a],s)){var u=e[o];e[o]=e[a],e[a]=u,--o}else++a;0<r(e[a],s)&&--a,t<=a?i=a:n=a+1}return e[t]}}},function(e,t,n){var R=n(11);t.name="algorithm08",t.factory=function(e,t,r,B){var I=r(n(10)),P=e.SparseMatrix;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,p=t._datatype;if(o.length!==l.length)throw new R(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");if(!n||!u)throw new Error("Cannot perform operation on Pattern Sparse Matrices");var m,h=o[0],d=o[1],g=I,v=0,y=r;"string"==typeof s&&s===p&&(m=s,g=B.find(I,[m,m]),v=B.convert(0,m),y=B.find(r,[m,m]));for(var x,w,b,N,M=[],E=[],A=[],O=new P({values:M,index:E,ptr:A,size:[h,d],datatype:m}),S=[],_=[],T=0;T<d;T++){A[T]=E.length;var C=T+1;for(w=a[T],b=a[T+1],x=w;x<b;x++)_[N=i[x]]=C,S[N]=n[x],E.push(N);for(w=f[T],b=f[T+1],x=w;x<b;x++)_[N=c[x]]===C&&(S[N]=y(S[N],u[x]));for(x=A[T];x<E.length;){var z=S[N=E[x]];g(z,v)?E.splice(x,1):(M.push(z),x++)}}return A[d]=E.length,O}}},function(e,t,r){e.exports=function(e){if(e.isFinite()&&!e.isInteger())throw new Error("Integer expected in function bitNot");var t=e.constructor,r=t.precision;return t.config({precision:1e9}),(e=e.plus(new t(1))).s=-e.s||null,t.config({precision:r}),e}},function(e,t,r){var x=r(76);function w(e){for(var t=e.d,r=t[0]+"",n=1;n<t.length;++n){for(var i=t[n]+"",a=7-i.length;a--;)i="0"+i;r+=i}for(l=r.length-1;"0"==r.charAt(l);--l);var o=e.e,s=r.slice(0,l+1||1),u=s.length;if(0<o)if(++o>u)for(o-=u;o--;s+="0");else o<u&&(s=s.slice(0,o)+"."+s.slice(o));var c=[0];for(n=0;n<s.length;){for(var f=c.length;f--;c[f]*=10);c[0]+=s.charAt(n++)<<0;for(var l=0;l<c.length;++l)1<c[l]&&(null==c[l+1]&&(c[l+1]=0),c[l+1]+=c[l]>>1,c[l]&=1)}return c.reverse()}e.exports=function(e,t,r){var n,i,a,o,s,u=e.constructor,c=+(e.s<0),f=+(t.s<0);if(c){n=w(x(e));for(var l=0;l<n.length;++l)n[l]^=1}else n=w(e);if(f){i=w(x(t));for(l=0;l<i.length;++l)i[l]^=1}else i=w(t);n.length<=i.length?(a=n,o=i,s=c):(a=i,o=n,s=f);var p=a.length,m=o.length,h=1^r(c,f),d=new u(1^h),g=new u(1),v=new u(2),y=u.precision;for(u.config({precision:1e9});0<p;)r(a[--p],o[--m])==h&&(d=d.plus(g)),g=g.times(v);for(;0<m;)r(s,o[--m])==h&&(d=d.plus(g)),g=g.times(v);return u.config({precision:y}),0==h&&(d.s=-d.s),d}},function(e,t,o){var s=o(0);t.name="log",t.factory=function(t,r,e,n){var i=e(o(12)),a=n("log",{number:function(e){return 0<=e||r.predictable?Math.log(e):new t.Complex(e,0).log()},Complex:function(e){return e.log()},BigNumber:function(e){return!e.isNegative()||r.predictable?e.ln():new t.Complex(e.toNumber(),0).log()},"Array | Matrix":function(e){return s(e,a)},"any, any":function(e,t){return i(a(e),a(t))}});return a.toTex={1:"\\ln\\left(${args[0]}\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}\\right)"},a}},function(e,t,r){var n=r(29),v=n.string,y=n.array,x=Array.isArray;t.factory=function(d){var g=d.DenseMatrix;return function(e,t,r){var n=e.size();if(2!==n.length)throw new RangeError("Matrix must be two dimensional (size: "+v.format(n)+")");var i,a,o,s=n[0];if(s!==n[1])throw new RangeError("Matrix must be square (size: "+v.format(n)+")");if(d.isMatrix(t)){var u=t.size();if(1===u.length){if(u[0]!==s)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(i=[],o=t._data,a=0;a<s;a++)i[a]=[o[a]];return new g({data:i,size:[s,1],datatype:t._datatype})}if(2===u.length){if(u[0]!==s||1!==u[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");if(d.isDenseMatrix(t)){if(r){for(i=[],o=t._data,a=0;a<s;a++)i[a]=[o[a][0]];return new g({data:i,size:[s,1],datatype:t._datatype})}return t}for(i=[],a=0;a<s;a++)i[a]=[0];for(var c=t._values,f=t._index,l=t._ptr,p=l[1],m=l[0];m<p;m++)i[a=f[m]][0]=c[m];return new g({data:i,size:[s,1],datatype:t._datatype})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}if(x(t)){var h=y.size(t);if(1===h.length){if(h[0]!==s)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(i=[],a=0;a<s;a++)i[a]=[t[a]];return new g({data:i,size:[s,1]})}if(2===h.length){if(h[0]!==s||1!==h[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(i=[],a=0;a<s;a++)i[a]=[t[a][0]];return new g({data:i,size:[s,1]})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}}}},function(e,t,r){t.name="cs_flip",t.path="sparse",t.factory=function(){return function(e){return-e-2}}},function(e,t,r){var a=r(0);t.name="conj",t.factory=function(e,t,r,n){var i=n("conj",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.conjugate()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\left(${args[0]}\\right)^*"},i}},function(e,t,z){t.math=!0,t.name="simplify",t.factory=function(f,e,t,r,l){var c=t(z(39)),p=t(z(50)),m=t(z(58)),h=t(z(69)),d=t(z(57)),s=t(z(70)),g=t(z(48)),n=(t(z(14)),t(z(118))),i=t(z(116)),u=t(z(296)),a=t(z(117)),v=a.isCommutative,y=a.isAssociative,x=a.flatten,w=a.unflattenr,b=a.unflattenl,N=a.createMakeNodeFunction,o=r("simplify",{string:function(e){return o(c(e),o.rules,{})},"string, Object":function(e,t){return o(c(e),o.rules,t)},"string, Array":function(e,t){return o(c(e),t,{})},"string, Array, Object":function(e,t,r){return o(c(e),t,r)},"Node, Object":function(e,t){return o(e,o.rules,t)},Node:function(e){return o(e,o.rules,{})},"Node, Array":function(e,t){return o(e,t,{})},"Node, Array, Object":function(e,t,r){t=function(e){for(var t=[],r=0;r<e.length;r++){var n,i=e[r],a=typeof i;switch(a){case"string":var o=i.split("->");if(2!==o.length)throw SyntaxError("Could not parse rule: "+i);i={l:o[0],r:o[1]};case"object":if(n={l:M(c(i.l)),r:M(c(i.r))},i.context&&(n.evaluate=i.context),i.evaluate&&(n.evaluate=c(i.evaluate)),y(n.l)){var s=N(n.l),u=new g("_p"+A++);n.expanded={},n.expanded.l=s([n.l.clone(),u]),x(n.expanded.l),w(n.expanded.l),n.expanded.r=s([n.r,u])}break;case"function":n=i;break;default:throw TypeError("Unsupported type of rule: "+a)}t.push(n)}return t}(t);for(var n,i={},a=(n=M(n=u(e,r))).toString({parenthesis:"all"});!i[a];){i[a]=!0;for(var o=A=0;o<t.length;o++)"function"==typeof t[o]?n=t[o](n):(x(n),n=O(n,t[o])),b(n);a=n.toString({parenthesis:"all"})}return n}});function M(e){return e.transform(function(e,t,r){return f.isParenthesisNode(e)?e.content:e})}o.simplifyCore=i,o.resolve=u;var E={true:!0,false:!0,e:!0,i:!0,Infinity:!0,LN2:!0,LN10:!0,LOG2E:!0,LOG10E:!0,NaN:!0,phi:!0,pi:!0,SQRT1_2:!0,SQRT2:!0,tau:!0};o.rules=[i,{l:"log(e)",r:"1"},{l:"n-n1",r:"n+-n1"},{l:"-(c*v)",r:"(-c) * v"},{l:"-v",r:"(-1) * v"},{l:"n/n1^n2",r:"n*n1^-n2"},{l:"n/n1",r:"n*n1^-1"},{l:"(n ^ n1) ^ n2",r:"n ^ (n1 * n2)"},{l:"n*n",r:"n^2"},{l:"n * n^n1",r:"n^(n1+1)"},{l:"n^n1 * n^n2",r:"n^(n1+n2)"},{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},{l:"n1*n2 + n2",r:"(n1+1)*n2"},{l:"n1*n3 + n2*n3",r:"(n1+n2)*n3"},{l:"n1 + -1 * (n2 + n3)",r:"n1 + -1 * n2 + -1 * n3"},n,{l:"(-n)*n1",r:"-(n*n1)"},{l:"c+v",r:"v+c",context:{add:{commutative:!1}}},{l:"v*c",r:"c*v",context:{multiply:{commutative:!1}}},{l:"n+-n1",r:"n-n1"},{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"n-(n1+n2)",r:"n-n1-n2"},{l:"1*n",r:"n"}];var A=0,O=r("applyRule",{"Node, Object":function(e,t){var r=e;if(r instanceof d||r instanceof h){if(r.args)for(var n=0;n<r.args.length;n++)r.args[n]=O(r.args[n],t)}else r instanceof s&&r.content&&(r.content=O(r.content,t));var i=t.r,a=T(t.l,r)[0];if(!a&&t.expanded&&(i=t.expanded.r,a=T(t.expanded.l,r)[0]),a){r=i.clone();var o=function(e){return e.isSymbolNode&&a.placeholders.hasOwnProperty(e.name)?a.placeholders[e.name].clone():e.map(o)};r=o(r)}return r}});function S(e,t){var r={placeholders:{}};if(!e.placeholders&&!t.placeholders)return r;if(!e.placeholders)return t;if(!t.placeholders)return e;for(var n in e.placeholders)if(r.placeholders[n]=e.placeholders[n],t.placeholders.hasOwnProperty(n)&&!C(e.placeholders[n],t.placeholders[n]))return null;for(var n in t.placeholders)r.placeholders[n]=t.placeholders[n];return r}function _(e,t){var r,n=[];if(0===e.length||0===t.length)return n;for(var i=0;i<e.length;i++)for(var a=0;a<t.length;a++)(r=S(e[i],t[a]))&&n.push(r);return n}function T(e,t,r){var n=[{placeholders:{}}];if(e instanceof d&&t instanceof d||e instanceof h&&t instanceof h){if(e instanceof d){if(e.op!==t.op||e.fn!==t.fn)return[]}else if(e instanceof h&&e.name!==t.name)return[];if((1!==t.args.length||1!==e.args.length)&&y(t)&&!r){if(2<=t.args.length&&2===e.args.length){var i=function(e,t){var r,n,i=[],a=N(e);if(v(e,t))for(var o=0;o<e.args.length;o++)(n=e.args.slice(0)).splice(o,1),r=1===n.length?n[0]:a(n),i.push(a([e.args[o],r]));else r=1===(n=e.args.slice(1)).length?n[0]:a(n),i.push(a([e.args[0],r]));return i}(t,e.context),a=[];for(u=0;u<i.length;u++){var o=T(e,i[u],!0);a=a.concat(o)}return a}if(2<e.args.length)throw Error("Unexpected non-binary associative function: "+e.toString());return[]}for(var s=[],u=0;u<e.args.length;u++){var c=T(e.args[u],t.args[u]);if(0===c.length)return[];s.push(c)}n=function(e){if(0===e.length)return e;for(var t=e.reduce(_),r=[],n={},i=0;i<t.length;i++){var a=JSON.stringify(t[i]);n[a]||(n[a]=!0,r.push(t[i]))}return r}(s)}else if(e instanceof g){if(0===e.name.length)throw new Error("Symbol in rule has 0 length...!?");if(l.hasOwnProperty(e.name)){if(!E[e.name])throw new Error("Built in constant: "+e.name+" is not supported by simplify.");if(e.name!==t.name)return[]}else if("n"===e.name[0]||"_p"===e.name.substring(0,2))n[0].placeholders[e.name]=t;else if("v"===e.name[0]){if(f.isConstantNode(t))return[];n[0].placeholders[e.name]=t}else{if("c"!==e.name[0])throw new Error("Invalid symbol in rule: "+e.name);if(!(t instanceof m))return[];n[0].placeholders[e.name]=t}}else{if(!(e instanceof m))return[];if(!p(e.value,t.value))return[]}return n}function C(e,t){if(e instanceof m&&t instanceof m){if(!p(e.value,t.value))return!1}else if(e instanceof g&&t instanceof g){if(e.name!==t.name)return!1}else{if(!(e instanceof d&&t instanceof d||e instanceof h&&t instanceof h))return!1;if(e instanceof d){if(e.op!==t.op||e.fn!==t.fn)return!1}else if(e instanceof h&&e.name!==t.name)return!1;if(e.args.length!==t.args.length)return!1;for(var r=0;r<e.args.length;r++)if(!C(e.args[r],t.args[r]))return!1}return!0}return o}},function(e,t,r){var i=r(2).size,a=r(72),o=r(61);function s(e,t,r){var n,i,a,o;if(t<=0){if(Array.isArray(e[0])){for(o=function(e){var t,r,n=e.length,i=e[0].length,a=[];for(r=0;r<i;r++){var o=[];for(t=0;t<n;t++)o.push(e[t][r]);a.push(o)}return a}(e),i=[],n=0;n<o.length;n++)i[n]=s(o[n],t-1,r);return i}for(a=e[0],n=1;n<e.length;n++)a=r(a,e[n]);return a}for(i=[],n=0;n<e.length;n++)i[n]=s(e[n],t-1,r);return i}e.exports=function(e,t,r){var n=Array.isArray(e)?i(e):e.size();if(t<0||t>=n.length)throw new o(t,n.length);return a(e)?e.create(s(e.valueOf(),t,r)):s(e,t,r)}},function(e,t,c){var f=c(37),l=c(83),p=c(67);t.name="max",t.factory=function(e,t,r,n){var i=r(c(33)),a=r(c(31)),o=n("max",{"Array | Matrix":u,"Array | Matrix, number | BigNumber":function(e,t){return l(e,t.valueOf(),s)},"...":function(e){if(p(e))throw new TypeError("Scalar values expected in function max");return u(e)}});return o.toTex="\\max\\left(${args}\\right)",o;function s(e,t){try{return i(e,t)?e:t}catch(e){throw a(e,"max",t)}}function u(e){var r=void 0;if(f(e,function(t){try{(void 0===r||i(t,r))&&(r=t)}catch(e){throw a(e,"max",t)}}),void 0===r)throw new Error("Cannot calculate max of an empty array");return r}}},function(e,t,r){t.factory=function(s,e,t,r){return function(e,t,r){var n=e.filter(function(e){return s.isSymbolNode(e)&&!(e.name in t)&&!(e.name in r)})[0];if(!n)throw new Error('No undefined variable found in inline expression "'+e+'"');var i=n.name,a=Object.create(r),o=e.compile();return function(e){return a[i]=e,o.eval(a)}}}},function(e,t,u){var c=u(2).map,f=u(9).escape;t.name="IndexNode",t.path="expression.node",t.factory=function(n,e,t,r){var i=t(u(14)),a=t(u(145)),o=Array.isArray;function s(e,t){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");if(this.dimensions=e,this.dotNotation=t||!1,!o(e)||!e.every(n.isNode))throw new TypeError('Array containing Nodes expected for parameter "dimensions"');if(this.dotNotation&&!this.isObjectProperty())throw new Error("dotNotation only applicable for object properties");var r=function(){throw new Error("Property `IndexNode.object` is deprecated, use `IndexNode.fn` instead")};Object.defineProperty(this,"object",{get:r,set:r})}function l(e,t,r){return new a(n.isBigNumber(e)?e.toNumber():e,n.isBigNumber(t)?t.toNumber():t,n.isBigNumber(r)?r.toNumber():r)}return(s.prototype=new i).type="IndexNode",s.prototype.isIndexNode=!0,s.prototype._compile=function(f,r){var i=c(this.dimensions,function(e,a){if(n.isRangeNode(e)){if(e.needsEnd()){(t=Object.create(r)).end=!0;var o=e.start._compile(f,t),s=e.end._compile(f,t),u=e.step?e.step._compile(f,t):function(){return 1};return function(e,t,r){var n=f.size(r).valueOf(),i=Object.create(t);return i.end=n[a],l(o(e,i,r),s(e,i,r),u(e,i,r))}}return o=e.start._compile(f,r),s=e.end._compile(f,r),u=e.step?e.step._compile(f,r):function(){return 1},function(e,t,r){return l(o(e,t,r),s(e,t,r),u(e,t,r))}}if(n.isSymbolNode(e)&&"end"===e.name){var t;(t=Object.create(r)).end=!0;var c=e._compile(f,t);return function(e,t,r){var n=f.size(r).valueOf(),i=Object.create(t);return i.end=n[a],c(e,i,r)}}return c=e._compile(f,r),function(e,t,r){return c(e,t,r)}});return function(t,r,n){var e=c(i,function(e){return e(t,r,n)});return f.index.apply(f,e)}},s.prototype.forEach=function(e){for(var t=0;t<this.dimensions.length;t++)e(this.dimensions[t],"dimensions["+t+"]",this)},s.prototype.map=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this._ifNode(e(this.dimensions[r],"dimensions["+r+"]",this));return new s(t)},s.prototype.clone=function(){return new s(this.dimensions.slice(0))},s.prototype.isObjectProperty=function(){return 1===this.dimensions.length&&n.isConstantNode(this.dimensions[0])&&"string"==typeof this.dimensions[0].value},s.prototype.getObjectProperty=function(){return this.isObjectProperty()?this.dimensions[0].value:null},s.prototype._toString=function(e){return this.dotNotation?"."+this.getObjectProperty():"["+this.dimensions.join(", ")+"]"},s.prototype.toJSON=function(){return{mathjs:"IndexNode",dimensions:this.dimensions,dotNotation:this.dotNotation}},s.fromJSON=function(e){return new s(e.dimensions,e.dotNotation)},s.prototype.toHTML=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this.dimensions[r].toHTML();return this.dotNotation?'<span class="math-operator math-accessor-operator">.</span><span class="math-symbol math-property">'+f(this.getObjectProperty())+"</span>":'<span class="math-parenthesis math-square-parenthesis">[</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},s.prototype._toTex=function(t){var e=this.dimensions.map(function(e){return e.toTex(t)});return this.dotNotation?"."+this.getObjectProperty():"_{"+e.join(",")+"}"},s}},function(e,t,r){var a=r(0);t.name="number",t.factory=function(e,t,r,n){var i=n("number",{"":function(){return 0},number:function(e){return e},string:function(e){var t=Number(e);if(isNaN(t))throw new SyntaxError('String "'+e+'" is no valid number');return t},BigNumber:function(e){return e.toNumber()},Fraction:function(e){return e.valueOf()},Unit:function(e){throw new Error("Second argument with valueless unit expected")},null:function(e){return 0},"Unit, string | Unit":function(e,t){return e.toNumber(t)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},i}},function(e,t,n){var k=n(11);t.name="algorithm04",t.factory=function(e,t,r,P){var R=r(n(10)),U=e.SparseMatrix;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,p=t._datatype;if(o.length!==l.length)throw new k(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var m,h=o[0],d=o[1],g=R,v=0,y=r;"string"==typeof s&&s===p&&(m=s,g=P.find(R,[m,m]),v=P.convert(0,m),y=P.find(r,[m,m]));var x,w,b,N,M,E=n&&u?[]:void 0,A=[],O=[],S=new U({values:E,index:A,ptr:O,size:[h,d],datatype:m}),_=n&&u?[]:void 0,T=n&&u?[]:void 0,C=[],z=[];for(w=0;w<d;w++){O[w]=A.length;var B=w+1;for(N=a[w],M=a[w+1],b=N;b<M;b++)x=i[b],A.push(x),C[x]=B,_&&(_[x]=n[b]);for(N=f[w],M=f[w+1],b=N;b<M;b++)if(C[x=c[b]]===B){if(_){var I=y(_[x],u[b]);g(I,v)?C[x]=null:_[x]=I}}else A.push(x),z[x]=B,T&&(T[x]=u[b]);if(_&&T)for(b=O[w];b<A.length;)C[x=A[b]]===B?(E[b]=_[x],b++):z[x]===B?(E[b]=T[x],b++):A.splice(b,1)}return O[d]=A.length,S}}},function(e,t,r){var a=r(29).string.isString;t.name="Matrix",t.path="type",t.factory=function(e,t,r,n){function i(){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator")}return i.prototype.type="Matrix",i.prototype.isMatrix=!0,i.storage=function(e){if(!a(e))throw new TypeError("format must be a string value");var t=i._storage[e];if(!t)throw new SyntaxError("Unsupported matrix storage format: "+e);return t},i._storage={},i.prototype.storage=function(){throw new Error("Cannot invoke storage on a Matrix interface")},i.prototype.datatype=function(){throw new Error("Cannot invoke datatype on a Matrix interface")},i.prototype.create=function(e,t){throw new Error("Cannot invoke create on a Matrix interface")},i.prototype.subset=function(e,t,r){throw new Error("Cannot invoke subset on a Matrix interface")},i.prototype.get=function(e){throw new Error("Cannot invoke get on a Matrix interface")},i.prototype.set=function(e,t,r){throw new Error("Cannot invoke set on a Matrix interface")},i.prototype.resize=function(e,t){throw new Error("Cannot invoke resize on a Matrix interface")},i.prototype.reshape=function(e,t){throw new Error("Cannot invoke reshape on a Matrix interface")},i.prototype.clone=function(){throw new Error("Cannot invoke clone on a Matrix interface")},i.prototype.size=function(){throw new Error("Cannot invoke size on a Matrix interface")},i.prototype.map=function(e,t){throw new Error("Cannot invoke map on a Matrix interface")},i.prototype.forEach=function(e){throw new Error("Cannot invoke forEach on a Matrix interface")},i.prototype.toArray=function(){throw new Error("Cannot invoke toArray on a Matrix interface")},i.prototype.valueOf=function(){throw new Error("Cannot invoke valueOf on a Matrix interface")},i.prototype.format=function(e){throw new Error("Cannot invoke format on a Matrix interface")},i.prototype.toString=function(){throw new Error("Cannot invoke toString on a Matrix interface")},i}},function(e,t,r){e.exports=function(e){return e&&e.constructor.prototype.isBigNumber||!1}},function(e,t,r){var a=r(0);var o=Math.acosh||function(e){return Math.log(Math.sqrt(e*e-1)+e)};t.name="acosh",t.factory=function(t,r,e,n){var i=n("acosh",{number:function(e){return 1<=e||r.predictable?o(e):e<=-1?new t.Complex(Math.log(Math.sqrt(e*e-1)-e),Math.PI):new t.Complex(e,0).acosh()},Complex:function(e){return e.acosh()},BigNumber:function(e){return e.acosh()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cosh^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,a){var p=a(37);t.name="var",t.factory=function(o,e,t,r){var s=t(a(20)),u=t(a(16)),c=t(a(21)),f=t(a(12)),l=t(a(31)),n=r("variance",{"Array | Matrix":function(e){return i(e,"unbiased")},"Array | Matrix, string":i,"...":function(e){return i(e,"unbiased")}});return n.toTex="\\mathrm{Var}\\left(${args}\\right)",n;function i(e,t){var r=0,n=0;if(0==e.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(p(e,function(t){try{r=s(r,t),n++}catch(e){throw l(e,"var",t)}}),0===n)throw new Error("Cannot calculate var of an empty array");var i=f(r,n);switch(r=0,p(e,function(e){var t=u(e,i);r=s(r,c(t,t))}),t){case"uncorrected":return f(r,n);case"biased":return f(r,n+1);case"unbiased":var a=o.isBigNumber(r)?new o.BigNumber(0):0;return 1==n?a:f(r,n-1);default:throw new Error('Unknown normalization "'+t+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}}},function(e,t,m){var h=m(2).flatten,d=m(67);t.name="median",t.factory=function(e,t,r,n){var i=r(m(20)),a=r(m(12)),s=r(m(45)),u=r(m(74)),c=r(m(31)),o=n("median",{"Array | Matrix":f,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("median(A, dim) is not yet supported")},"...":function(e){if(d(e))throw new TypeError("Scalar values expected in function median");return f(e)}});function f(e){try{var t=(e=h(e.valueOf())).length;if(0==t)throw new Error("Cannot calculate median of an empty array");if(t%2==0){for(var r=t/2-1,n=u(e,r+1),i=e[r],a=0;a<r;++a)0<s(e[a],i)&&(i=e[a]);return p(i,n)}var o=u(e,(t-1)/2);return l(o)}catch(e){throw c(e,"median")}}var l=n({"number | BigNumber | Complex | Unit":function(e){return e}}),p=n({"number | BigNumber | Complex | Unit, number | BigNumber | Complex | Unit":function(e,t){return a(i(e,t),2)}});return o.toTex=void 0,o}},function(e,t,c){var f=c(2).flatten;t.name="setSymDifference",t.factory=function(e,t,r,n){var i=r(c(27)),a=r(c(68)),o=r(c(24)),s=r(c(22)),u=r(c(96));return n("setSymDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===s(o(e),new i(0)))return f(t);if(0===s(o(t),new i(0)))return f(e);var r=f(e),n=f(t);return a(u(r,n),u(n,r))}})}},function(e,t,i){var p=i(2).flatten,m=i(2).identify,h=i(2).generalize;t.name="setIntersect",t.factory=function(e,t,r,n){var s=r(i(27)),u=r(i(52)),c=r(i(24)),f=r(i(22)),l=r(i(26));return n("setIntersect",{"Array | Matrix, Array | Matrix":function(e,t){if(0===f(c(e),new s(0))||0===f(c(t),new s(0)))var r=[];else for(var n=m(p(Array.isArray(e)?e:e.toArray()).sort(l)),i=m(p(Array.isArray(t)?t:t.toArray()).sort(l)),a=(r=[],0);a<n.length;a++)for(var o=0;o<i.length;o++)if(0===l(n[a].value,i[o].value)&&n[a].identifier===i[o].identifier){r.push(n[a]);break}return Array.isArray(e)&&Array.isArray(t)?h(r):new u(h(r))}})}},function(e,t,i){var m=i(2).flatten,h=i(2).identify,d=i(2).generalize;t.name="setDifference",t.factory=function(e,t,r,n){var u=r(i(27)),c=r(i(52)),f=r(i(24)),l=r(i(22)),p=r(i(26));return n("setDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===l(f(e),new u(0)))var r=[];else{if(0===l(f(t),new u(0)))return m(e.toArray());for(var n,i=h(m(Array.isArray(e)?e:e.toArray()).sort(p)),a=h(m(Array.isArray(t)?t:t.toArray()).sort(p)),o=(r=[],0);o<i.length;o++){n=!1;for(var s=0;s<a.length;s++)if(0===p(i[o].value,a[s].value)&&i[o].identifier===a[s].identifier){n=!0;break}n||r.push(i[o])}}return Array.isArray(e)&&Array.isArray(t)?d(r):new c(d(r))}})}},function(e,t,u){var c=u(37);t.name="sum",t.factory=function(t,n,e,r){var i=e(u(20)),a=e(u(31)),o=r("sum",{"Array | Matrix":function(e){return s(e)},"Array | Matrix, number | BigNumber":function(){throw new Error("sum(A, dim) is not yet supported")},"...":function(e){return s(e)}});return o.toTex=void 0,o;function s(e){var r=void 0;if(c(e,function(t){try{r=void 0===r?t:i(r,t)}catch(e){throw a(e,"sum",t)}}),void 0===r)switch(n.number){case"number":return 0;case"BigNumber":return new t.BigNumber(0);case"Fraction":return new t.Fraction(0);default:return 0}return r}}},function(e,t,r){var o=r(35).maxArgumentCount;function a(t,n){var i=o(n),a=function(e,r){return Array.isArray(e)?e.map(function(e,t){return a(e,r.concat(t))}):1===i?n(e):2===i?n(e,r):n(e,r,t)};return a(t,[])}t.name="map",t.factory=function(e,t,r,n){var i=n("map",{"Array, function":a,"Matrix, function":function(e,t){return e.map(t)}});return i.toTex=void 0,i}},function(e,t,o){var s=o(0);t.name="not",t.factory=function(e,t,r,n){var i=o(4),a=n("not",{number:function(e){return!e},Complex:function(e){return 0===e.re&&0===e.im},BigNumber:function(e){return e.isZero()||e.isNaN()},Unit:function(e){return null===e.value||a(e.value)},"Array | Matrix":function(e){return s(e,a)}});return a.toTex={1:i.operators.not+"\\left(${args[0]}\\right)"},a}},function(e,t,r){var n=r(0),m=r(3).isInteger;var h=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22];t.name="gamma",t.factory=function(c,i,e,t){var f=e(r(8)),l=e(r(41)),p=t("gamma",{number:function(e){var t,r;if(m(e)){if(e<=0)return isFinite(e)?1/0:NaN;if(171<e)return 1/0;for(var n=e-2,i=e-1;1<n;)i*=n,n--;return 0==i&&(i=1),i}if(e<.5)return Math.PI/(Math.sin(Math.PI*e)*p(1-e));if(171.35<=e)return 1/0;if(85<e){var a=e*e,o=a*e,s=o*e,u=s*e;return Math.sqrt(2*Math.PI/e)*Math.pow(e/Math.E,e)*(1+1/(12*e)+1/(288*a)-139/(51840*o)-571/(2488320*s)+163879/(209018880*u)+5246819/(75246796800*u*e))}--e,r=h[0];for(var c=1;c<h.length;++c)r+=h[c]/(e+c);return t=e+4.7421875+.5,Math.sqrt(2*Math.PI)*Math.pow(t,e+.5)*Math.exp(-t)*r},Complex:function(e){var t,r;if(0==e.im)return p(e.re);e=new c.Complex(e.re-1,e.im),r=new c.Complex(h[0],0);for(var n=1;n<h.length;++n){var i=e.re+n,a=i*i+e.im*e.im;0!=a?(r.re+=h[n]*i/a,r.im+=-h[n]*e.im/a):r.re=h[n]<0?-1/0:1/0}t=new c.Complex(e.re+4.7421875+.5,e.im);var o=Math.sqrt(2*Math.PI);e.re+=.5;var s=l(t,e);0==s.im?s.re*=o:(0==s.re||(s.re*=o),s.im*=o);var u=Math.exp(-t.re);return t.re=u*Math.cos(-t.im),t.im=u*Math.sin(-t.im),f(f(s,t),r)},BigNumber:function(e){if(e.isInteger())return e.isNegative()||e.isZero()?new c.BigNumber(1/0):function(e){if(e.isZero())return new c.BigNumber(1);for(var t=i.precision+(0|Math.log(e.toNumber())),r=new(c.BigNumber.clone({precision:t}))(e),n=e.toNumber()-1;1<n;)r=r.times(n),n--;return new c.BigNumber(r.toPrecision(c.BigNumber.precision))}(e.minus(1));if(!e.isFinite())return new c.BigNumber(e.isNegative()?NaN:1/0);throw new Error("Integer BigNumber expected")},"Array | Matrix":function(e){return n(e,p)}});return p.toTex={1:"\\Gamma\\left(${args[0]}\\right)"},p}},function(e,t,a){t.name="stirlingS2",t.factory=function(e,t,r,n){var u=r(a(13)),c=r(a(16)),f=r(a(8)),l=r(a(30)),p=r(a(41)),m=r(a(63)),h=r(a(62)),d=r(a(54)),g=r(a(46)),v=r(a(33)),i=n("stirlingS2",{"number | BigNumber, number | BigNumber":function(e,t){if(!g(e)||d(e)||!g(t)||d(t))throw new TypeError("Non-negative integer value expected in function stirlingS2");if(v(t,e))throw new TypeError("k must be less than or equal to n in function stirlingS2");for(var r=m(t),n=0,i=0;i<=t;i++){var a=p(-1,c(t,i)),o=h(t,i),s=p(i,e);n=u(n,f(f(o,s),a))}return l(n,r)}});return i.toTex={2:"\\mathrm{S}\\left(${args}\\right)"},i}},function(e,t,s){var u=s(5).clone,h=s(9).format;t.name="trace",t.factory=function(e,t,r,n){var i=r(s(1)),m=r(s(13)),a=n("trace",{Array:function(e){return o(i(e))},SparseMatrix:function(e){var t=e._values,r=e._index,n=e._ptr,i=e._size,a=i[0],o=i[1];if(a===o){var s=0;if(0<t.length)for(var u=0;u<o;u++)for(var c=n[u],f=n[u+1],l=c;l<f;l++){var p=r[l];if(p===u){s=m(s,t[l]);break}if(u<p)break}return s}throw new RangeError("Matrix must be square (size: "+h(i)+")")},DenseMatrix:o,any:u});function o(e){var t=e._size,r=e._data;switch(t.length){case 1:if(1===t[0])return u(r[0]);throw new RangeError("Matrix must be square (size: "+h(t)+")");case 2:var n=t[0];if(n===t[1]){for(var i=0,a=0;a<n;a++)i=m(i,r[a][a]);return i}throw new RangeError("Matrix must be square (size: "+h(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+h(t)+")")}}return a.toTex={1:"\\mathrm{tr}\\left(${args[0]}\\right)"},a}},function(e,t,n){var U=n(11);t.name="algorithm09",t.factory=function(e,t,r,I){var P=r(n(10)),R=e.SparseMatrix;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,p=t._datatype;if(o.length!==l.length)throw new U(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var m,h=o[0],d=o[1],g=P,v=0,y=r;"string"==typeof s&&s===p&&(m=s,g=I.find(P,[m,m]),v=I.convert(0,m),y=I.find(r,[m,m]));var x,w,b,N,M,E=n&&u?[]:void 0,A=[],O=[],S=new R({values:E,index:A,ptr:O,size:[h,d],datatype:m}),_=E?[]:void 0,T=[];for(w=0;w<d;w++){O[w]=A.length;var C=w+1;if(_)for(N=f[w],M=f[w+1],b=N;b<M;b++)T[x=c[b]]=C,_[x]=u[b];for(N=a[w],M=a[w+1],b=N;b<M;b++)if(x=i[b],_){var z=T[x]===C?_[x]:v,B=y(n[b],z);g(B,v)||(A.push(x),E.push(B))}else A.push(x)}return O[d]=A.length,S}}},function(e,t,d){t.name="dotDivide",t.factory=function(e,t,r,n){var i=r(d(1)),a=r(d(12)),o=d(4),s=r(d(25)),u=r(d(19)),c=r(d(28)),f=r(d(17)),l=r(d(18)),p=r(d(7)),m=r(d(6)),h=n("dotDivide",{"any, any":a,"SparseMatrix, SparseMatrix":function(e,t){return c(e,t,a,!1)},"SparseMatrix, DenseMatrix":function(e,t){return s(t,e,a,!0)},"DenseMatrix, SparseMatrix":function(e,t){return u(e,t,a,!1)},"DenseMatrix, DenseMatrix":function(e,t){return p(e,t,a)},"Array, Array":function(e,t){return h(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return h(i(e),t)},"Matrix, Array":function(e,t){return h(e,i(t))},"SparseMatrix, any":function(e,t){return f(e,t,a,!1)},"DenseMatrix, any":function(e,t){return m(e,t,a,!1)},"any, SparseMatrix":function(e,t){return l(t,e,a,!0)},"any, DenseMatrix":function(e,t){return m(t,e,a,!0)},"Array, any":function(e,t){return m(i(e),t,a,!1).valueOf()},"any, Array":function(e,t){return m(i(t),e,a,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+o.operators.dotDivide+"${args[1]}\\right)"},h}},function(e,t,u){t.name="usolve",t.factory=function(e,t,r,n){var i=r(u(1)),x=r(u(12)),w=r(u(21)),b=r(u(16)),N=r(u(10)),M=r(u(79)),E=e.DenseMatrix,a=n("usolve",{"SparseMatrix, Array | Matrix":function(e,t){return s(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return o(e,t)},"Array, Array | Matrix":function(e,t){var r=i(e);return o(r,t).valueOf()}}),o=function(e,t){for(var r=(t=M(e,t,!0))._data,n=e._size[0],i=e._size[1],a=[],o=e._data,s=i-1;0<=s;s--){var u,c=r[s][0]||0;if(N(c,0))u=0;else{var f=o[s][s];if(N(f,0))throw new Error("Linear system cannot be solved since matrix is singular");u=x(c,f);for(var l=s-1;0<=l;l--)r[l]=[b(r[l][0]||0,w(u,o[l][s]))]}a[s]=[u]}return new E({data:a,size:[n,1]})},s=function(e,t){for(var r,n,i=(t=M(e,t,!0))._data,a=e._size[0],o=e._size[1],s=e._values,u=e._index,c=e._ptr,f=[],l=o-1;0<=l;l--){var p=i[l][0]||0;if(N(p,0))f[l]=[0];else{var m=0,h=[],d=[],g=c[l],v=c[l+1];for(n=v-1;g<=n;n--)(r=u[n])===l?m=s[n]:r<l&&(h.push(s[n]),d.push(r));if(N(m,0))throw new Error("Linear system cannot be solved since matrix is singular");var y=x(p,m);for(n=0,v=d.length;n<v;n++)i[r=d[n]]=[b(i[r][0],w(y,h[n]))];f[l]=[y]}}return new E({data:f,size:[a,1]})};return a}},function(e,t,u){t.name="lsolve",t.factory=function(e,t,r,n){var i=r(u(1)),y=r(u(12)),x=r(u(21)),w=r(u(16)),b=r(u(10)),N=r(u(79)),M=e.DenseMatrix,a=n("lsolve",{"SparseMatrix, Array | Matrix":function(e,t){return s(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return o(e,t)},"Array, Array | Matrix":function(e,t){var r=i(e);return o(r,t).valueOf()}}),o=function(e,t){for(var r=(t=N(e,t,!0))._data,n=e._size[0],i=e._size[1],a=[],o=e._data,s=0;s<i;s++){var u,c=r[s][0]||0;if(b(c,0))u=0;else{var f=o[s][s];if(b(f,0))throw new Error("Linear system cannot be solved since matrix is singular");u=y(c,f);for(var l=s+1;l<n;l++)r[l]=[w(r[l][0]||0,x(u,o[l][s]))]}a[s]=[u]}return new M({data:a,size:[n,1]})},s=function(e,t){for(var r,n,i=(t=N(e,t,!0))._data,a=e._size[0],o=e._size[1],s=e._values,u=e._index,c=e._ptr,f=[],l=0;l<o;l++){var p=i[l][0]||0;if(b(p,0))f[l]=[0];else{var m=0,h=[],d=[],g=c[l+1];for(n=c[l];n<g;n++)(r=u[n])===l?m=s[n]:l<r&&(h.push(s[n]),d.push(r));if(b(m,0))throw new Error("Linear system cannot be solved since matrix is singular");var v=y(p,m);for(n=0,g=d.length;n<g;n++)i[r=d[n]]=[w(i[r][0]||0,x(v,h[n]))];f[l]=[v]}}return new M({data:f,size:[a,1]})};return a}},function(e,t,i){t.name="cs_mark",t.path="sparse",t.factory=function(e,t,r){var n=r(i(80));return function(e,t){e[t]=n(e[t])}}},function(e,t,r){t.name="cs_marked",t.path="sparse",t.factory=function(){return function(e,t){return e[t]<0}}},function(e,t,p){var m=p(3).nearlyEqual,h=p(44);t.name="largerEq",t.factory=function(e,r,t,n){var i=t(p(1)),a=t(p(19)),o=t(p(28)),s=t(p(18)),u=t(p(7)),c=t(p(6)),f=p(4),l=n("largerEq",{"boolean, boolean":function(e,t){return t<=e},"number, number":function(e,t){return t<=e||m(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.gte(t)||h(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return-1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return l(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,l)},"Array, Array":function(e,t){return l(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return l(i(e),t)},"Matrix, Array":function(e,t){return l(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,l,!1)},"DenseMatrix, any":function(e,t){return c(e,t,l,!1)},"any, SparseMatrix":function(e,t){return s(t,e,l,!0)},"any, DenseMatrix":function(e,t){return c(t,e,l,!0)},"Array, any":function(e,t){return c(i(e),t,l,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+f.operators.largerEq+"${args[1]}\\right)"},l}},function(e,t,r){t.name="cs_tdfs",t.path="sparse",t.factory=function(){return function(e,t,r,n,i,a,o){var s=0;for(r[o]=e;0<=s;){var u=r[o+s],c=r[n+u];-1==c?(s--,a[t++]=u):(r[n+u]=r[i+c],r[o+ ++s]=c)}return t}}},function(e,t,i){var s=i(29).number.isInteger;t.name="slu",t.factory=function(e,t,r,n){var a=r(i(293)),o=r(i(285));return n("slu",{"SparseMatrix, number, number":function(e,t,r){if(!s(t)||t<0||3<t)throw new Error("Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]");if(r<0||1<r)throw new Error("Partial pivoting threshold must be a number from 0 to 1");var n=a(t,e,!1),i=o(e,n,r);return{L:i.L,U:i.U,p:i.pinv,q:n.q,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\np: "+this.p.toString()+(this.q?"\nq: "+this.q.toString():"")+"\n"}}}})}},function(e,t,u){var S=u(29).object;t.name="lup",t.factory=function(e,t,r,n){var i=r(u(1)),C=r(u(23)),E=r(u(20)),z=r(u(12)),B=r(u(21)),A=r(u(16)),I=r(u(33)),P=r(u(10)),R=r(u(32)),U=e.SparseMatrix,O=e.DenseMatrix,k=e.Spa,a=n("lup",{DenseMatrix:function(e){return o(e)},SparseMatrix:function(e){return s(e)},Array:function(e){var t=i(e),r=o(t);return{L:r.L.valueOf(),U:r.U.valueOf(),p:r.p}}}),o=function(e){var t,r,n,i=e._size[0],a=e._size[1],o=Math.min(i,a),s=S.clone(e._data),u=[],c=[i,o],f=[],l=[o,a],p=[];for(t=0;t<i;t++)p[t]=t;for(r=0;r<a;r++){if(0<r)for(t=0;t<i;t++){var m=Math.min(t,r),h=0;for(n=0;n<m;n++)h=E(h,B(s[t][n],s[n][r]));s[t][r]=A(s[t][r],h)}var d=r,g=0,v=0;for(t=r;t<i;t++){var y=s[t][r],x=C(y);I(x,g)&&(d=t,g=x,v=y)}if(r!==d&&(p[r]=[p[d],p[d]=p[r]][0],O._swapRows(r,d,s)),r<i)for(t=r+1;t<i;t++){var w=s[t][r];P(w,0)||(s[t][r]=z(s[t][r],v))}}for(r=0;r<a;r++)for(t=0;t<i;t++)0===r&&(t<a&&(f[t]=[]),u[t]=[]),t<r?(t<a&&(f[t][r]=s[t][r]),r<i&&(u[t][r]=0)):t!==r?(t<a&&(f[t][r]=0),r<i&&(u[t][r]=s[t][r])):(t<a&&(f[t][r]=s[t][r]),r<i&&(u[t][r]=1));var b=new O({data:u,size:c}),N=new O({data:f,size:l}),M=[];for(t=0,o=p.length;t<o;t++)M[p[t]]=t;return{L:b,U:N,p:M,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}},s=function(e){var t,r,n,i,a,o,s,u=e._size[0],c=e._size[1],f=Math.min(u,c),l=e._values,p=e._index,m=e._ptr,h=[],d=[],g=[],v=[u,f],y=[],x=[],w=[],b=[f,c],N=[],M=[];for(t=0;t<u;t++)N[t]=t,M[t]=t;for(r=0;r<c;r++){var E=new k;r<u&&(g.push(h.length),h.push(1),d.push(r)),w.push(y.length);var A=m[r],O=m[r+1];for(n=A;n<O;n++)t=p[n],E.set(N[t],l[n]);0<r&&E.forEach(0,r-1,function(r,n){U._forEachRow(r,h,d,g,function(e,t){r<e&&E.accumulate(e,R(B(t,n)))})});var S=r,_=E.get(r),T=C(_);E.forEach(r+1,u-1,function(e,t){var r=C(t);I(r,T)&&(S=e,T=r,_=t)}),r!==S&&(U._swapRows(r,S,v[1],h,d,g),U._swapRows(r,S,b[1],y,x,w),E.swap(r,S),a=S,o=M[i=r],s=M[a],N[o]=a,N[s]=i,M[i]=s,M[a]=o),E.forEach(0,u-1,function(e,t){e<=r?(y.push(t),x.push(e)):(t=z(t,_),P(t,0)||(h.push(t),d.push(e)))})}return w.push(y.length),g.push(h.length),{L:new U({values:h,index:d,ptr:g,size:v}),U:new U({values:y,index:x,ptr:w,size:b}),p:N,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}};return a}},function(e,t,r){var a=r(3),o=r(0);t.name="sign",t.factory=function(t,e,r,n){var i=n("sign",{number:a.sign,Complex:function(e){return e.sign()},BigNumber:function(e){return new t.BigNumber(e.cmp(0))},Fraction:function(e){return new t.Fraction(e.s,1)},"Array | Matrix":function(e){return o(e,i,!0)},Unit:function(e){return i(e.value)}});return i.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},i}},function(e,t,m){var h=m(3).nearlyEqual,d=m(44);t.name="unequal",t.factory=function(e,r,t,n){var i=t(m(1)),a=t(m(19)),o=t(m(28)),s=t(m(18)),u=t(m(7)),c=t(m(6)),f=m(4),l=n("unequal",{"any, any":function(e,t){return null===e?null!==t:null===t?null!==e:void 0===e?void 0!==t:void 0===t?void 0!==e:p(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,p)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,p,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,p,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,p)},"Array, Array":function(e,t){return l(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return l(i(e),t)},"Matrix, Array":function(e,t){return l(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,p,!1)},"DenseMatrix, any":function(e,t){return c(e,t,p,!1)},"any, SparseMatrix":function(e,t){return s(t,e,p,!0)},"any, DenseMatrix":function(e,t){return c(t,e,p,!0)},"Array, any":function(e,t){return c(i(e),t,p,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,p,!0).valueOf()}}),p=n("_unequal",{"boolean, boolean":function(e,t){return e!==t},"number, number":function(e,t){return!h(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return!d(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return!e.equals(t)},"Complex, Complex":function(e,t){return!e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return l(e.value,t.value)}});return l.toTex={2:"\\left(${args[0]}"+f.operators.unequal+"${args[1]}\\right)"},l}},function(e,t,r){var a=r(5);t.name="clone",t.factory=function(e,t,r,n){var i=n("clone",{any:a.clone});return i.toTex=void 0,i}},function(e,t,i){t.math=!0,t.name="simplifyCore",t.path="algebra.simplify",t.factory=function(c,e,t,r,n){var f=t(i(50)),l=t(i(56)),p=(t(i(60)),t(i(13))),m=t(i(16)),h=t(i(8)),d=t(i(30)),g=t(i(41)),v=n.expression.node.ConstantNode,y=n.expression.node.OperatorNode,x=n.expression.node.FunctionNode,w=n.expression.node.ParenthesisNode,b=new v(0),N=new v(1);return function e(t){if(c.isOperatorNode(t)&&t.isUnary()){var r=e(t.args[0]);if("+"===t.op)return r;if("-"===t.op){if(c.isOperatorNode(r)){if(r.isUnary()&&"-"===r.op)return r.args[0];if(r.isBinary()&&"subtract"===r.fn)return new y("-","subtract",[r.args[1],r.args[0]])}return new y(t.op,t.fn,[r])}}else if(c.isOperatorNode(t)&&t.isBinary()){r=e(t.args[0]);var n=e(t.args[1]);if("+"===t.op){if(c.isConstantNode(r)){if(l(r.value))return n;if(c.isConstantNode(n))return new v(p(r.value,n.value))}return c.isConstantNode(n)&&l(n.value)?r:c.isOperatorNode(n)&&n.isUnary()&&"-"===n.op?new y("-","subtract",[r,n.args[0]]):new y(t.op,t.fn,n?[r,n]:[r])}if("-"===t.op){if(c.isConstantNode(r)&&n){if(c.isConstantNode(n))return new v(m(r.value,n.value));if(l(r.value))return new y("-","unaryMinus",[n])}if("subtract"===t.fn)return c.isConstantNode(n)&&l(n.value)?r:c.isOperatorNode(n)&&n.isUnary()&&"-"===n.op?e(new y("+","add",[r,n.args[0]])):new y(t.op,t.fn,[r,n])}else{if("*"===t.op){if(c.isConstantNode(r)){if(l(r.value))return b;if(f(r.value,1))return n;if(c.isConstantNode(n))return new v(h(r.value,n.value))}if(c.isConstantNode(n)){if(l(n.value))return b;if(f(n.value,1))return r;if(c.isOperatorNode(r)&&r.isBinary()&&r.op===t.op){var i=r.args[0];if(c.isConstantNode(i)){var a=new v(h(i.value,n.value));return new y(t.op,t.fn,[a,r.args[1]])}}return new y(t.op,t.fn,[n,r])}return new y(t.op,t.fn,[r,n])}if("/"===t.op){if(c.isConstantNode(r)){if(l(r.value))return b;if(c.isConstantNode(n)&&(f(n.value,1)||f(n.value,2)||f(n.value,4)))return new v(d(r.value,n.value))}return new y(t.op,t.fn,[r,n])}if("^"===t.op){if(c.isConstantNode(n)){if(l(n.value))return N;if(f(n.value,1))return r;if(c.isConstantNode(r))return new v(g(r.value,n.value));if(c.isOperatorNode(r)&&r.isBinary()&&"^"===r.op){var o=r.args[1];if(c.isConstantNode(o))return new y(t.op,t.fn,[r.args[0],new v(h(o.value,n.value))])}}return new y(t.op,t.fn,[r,n])}}}else{if(c.isParenthesisNode(t)){var s=e(t.content);return c.isParenthesisNode(s)||c.isSymbolNode(s)||c.isConstantNode(s)?s:new w(s)}if(c.isFunctionNode(t)){var u=t.args.map(e).map(function(e){return c.isParenthesisNode(e)?e.content:e});return new x(e(t.fn),u)}}return t}}},function(e,t,r){t.factory=function(o,e,t,r,n){var i=n.expression.node.FunctionNode,a=n.expression.node.OperatorNode,s=n.expression.node.SymbolNode,u={add:!0,multiply:!0},c={add:!0,multiply:!0};function f(e,t){if(!o.isOperatorNode(e))return!1;var r=e.fn.toString();return t&&t.hasOwnProperty(r)&&t[r].hasOwnProperty("associative")?t[r].associative:c[r]||!1}function l(e){var n,i=[],a=function(e){for(var t=0;t<e.args.length;t++){var r=e.args[t];o.isOperatorNode(r)&&n===r.op?a(r):i.push(r)}};return f(e)?(n=e.op,a(e),i):e.args}function p(t){return o.isOperatorNode(t)?function(e){try{return new a(t.op,t.fn,e)}catch(e){return console.error(e),[]}}:function(e){return new i(new s(t.name),e)}}return{createMakeNodeFunction:p,isCommutative:function(e,t){if(!o.isOperatorNode(e))return!0;var r=e.fn.toString();return t&&t.hasOwnProperty(r)&&t[r].hasOwnProperty("commutative")?t[r].commutative:u[r]||!1},isAssociative:f,flatten:function e(t){if(!t.args||0===t.args.length)return t;t.args=l(t);for(var r=0;r<t.args.length;r++)e(t.args[r])},allChildren:l,unflattenr:function e(t){if(t.args&&0!==t.args.length){for(var r=p(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(2<n&&f(t)){for(var a=t.args.pop();0<t.args.length;)a=r([t.args.pop(),a]);t.args=a.args}}},unflattenl:function e(t){if(t.args&&0!==t.args.length){for(var r=p(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(2<n&&f(t)){for(var a=t.args.shift();0<t.args.length;)a=r([a,t.args.shift()]);t.args=a.args}}}}},t.math=!0},function(e,t,w){w(3).digits;t.math=!0,t.name="simplifyConstant",t.path="algebra.simplify",t.factory=function(u,t,e,r,c){var n=e(w(117)),f=(e(w(60)),n.isCommutative),l=n.isAssociative,p=n.allChildren,m=n.createMakeNodeFunction,i=c.expression.node.ConstantNode,a=c.expression.node.OperatorNode,h=c.expression.node.FunctionNode;function d(t,r){try{return v(c[t].apply(null,r))}catch(e){return r=r.map(function(e){return u.isFraction(e)?e.valueOf():e}),v(c[t].apply(null,r))}}var g=r({Fraction:function(e){var t,r=e.s*e.n;return t=r<0?new a("-","unaryMinus",[new i(-r)]):new i(r),1===e.d?t:new a("/","divide",[t,new i(e.d)])},number:function(e){return e<0?s(new i(-e)):new i(e)},BigNumber:function(e){return e<0?s(new i(e.negated().toString(),"number")):new i(e.toString(),"number")},Complex:function(e){throw"Cannot convert Complex number to Node"}});function o(e){if(isFinite(e)){var t=c.fraction(e);if(t.valueOf()===e)return t}return e}var v=r({string:function(e){return"BigNumber"===t.number?c.bignumber(e):"Fraction"===t.number?c.fraction(e):o(parseFloat(e))},Fraction:function(e){return e},BigNumber:function(e){return e},number:function(e){return o(e)},Complex:function(e){return 0!==e.im?e:o(e.re)}});function s(e){return new a("-","unaryMinus",[e])}function y(r,e,n){return e.reduce(function(e,t){if(u.isNode(e)||u.isNode(t))u.isNode(e)?u.isNode(t)||(t=g(t)):e=g(e);else{try{return d(r,[e,t])}catch(e){}e=g(e),t=g(t)}return n([e,t])})}function x(e){switch(e.type){case"SymbolNode":return e;case"ConstantNode":return"number"==typeof e.value?v(e.value):e;case"FunctionNode":if(c[e.name]&&c[e.name].rawArgs)return e;if(-1===["add","multiply"].indexOf(e.name)){if(!(t=e.args.map(x)).some(u.isNode))try{return d(e.name,t)}catch(e){}return t=t.map(function(e){return u.isNode(e)?e:g(e)}),new h(e.name,t)}case"OperatorNode":var t,r,n=e.fn.toString(),i=m(e);if(e.isUnary())t=[x(e.args[0])],r=u.isNode(t[0])?i(t):d(n,t);else if(l(e))if(t=(t=p(e)).map(x),f(n)){for(var a=[],o=[],s=0;s<t.length;s++)u.isNode(t[s])?o.push(t[s]):a.push(t[s]);1<a.length?(r=y(n,a,i),o.unshift(r),r=y(n,o,i)):r=y(n,t,i)}else r=y(n,t,i);else r=y(n,t=e.args.map(x),i);return r;case"ParenthesisNode":return x(e.content);case"AccessorNode":case"ArrayNode":case"AssignmentNode":case"BlockNode":case"FunctionAssignmentNode":case"IndexNode":case"ObjectNode":case"RangeNode":case"UpdateNode":case"ConditionalNode":default:throw"Unimplemented node type in simplifyConstant: "+e.type}}return function(e){var t=x(e);return u.isNode(t)?t:g(t)}}},function(e,t,h){t.name="range",t.factory=function(n,i,e,t){var r=e(h(1)),a=new n.BigNumber(0),o=new n.BigNumber(1),s=t("range",{string:c,"string, boolean":c,"number, number":function(e,t){return u(f(e,t,1))},"number, number, number":function(e,t,r){return u(f(e,t,r))},"number, number, boolean":function(e,t,r){return u(r?l(e,t,1):f(e,t,1))},"number, number, number, boolean":function(e,t,r,n){return u(n?l(e,t,r):f(e,t,r))},"BigNumber, BigNumber":function(e,t){return u(p(e,t,o))},"BigNumber, BigNumber, BigNumber":function(e,t,r){return u(p(e,t,r))},"BigNumber, BigNumber, boolean":function(e,t,r){return u(r?m(e,t,o):p(e,t,o))},"BigNumber, BigNumber, BigNumber, boolean":function(e,t,r,n){return u(n?m(e,t,r):p(e,t,r))}});return s.toTex=void 0,s;function u(e){return"Array"===i.matrix?e:r(e)}function c(e,t){var r=function(e){var t=e.split(":").map(function(e){return Number(e)});if(t.some(function(e){return isNaN(e)}))return null;switch(t.length){case 2:return{start:t[0],end:t[1],step:1};case 3:return{start:t[0],end:t[2],step:t[1]};default:return null}}(e);if(!r)throw new SyntaxError('String "'+e+'" is no valid range');return"BigNumber"===i.number?u((t?m:p)(new n.BigNumber(r.start),new n.BigNumber(r.end),new n.BigNumber(r.step))):u((t?l:f)(r.start,r.end,r.step))}function f(e,t,r){var n=[],i=e;if(0<r)for(;i<t;)n.push(i),i+=r;else if(r<0)for(;t<i;)n.push(i),i+=r;return n}function l(e,t,r){var n=[],i=e;if(0<r)for(;i<=t;)n.push(i),i+=r;else if(r<0)for(;t<=i;)n.push(i),i+=r;return n}function p(e,t,r){var n=[],i=e;if(r.gt(a))for(;i.lt(t);)n.push(i),i=i.plus(r);else if(r.lt(a))for(;i.gt(t);)n.push(i),i=i.plus(r);return n}function m(e,t,r){var n=[],i=e;if(r.gt(a))for(;i.lte(t);)n.push(i),i=i.plus(r);else if(r.lt(a))for(;i.gte(t);)n.push(i),i=i.plus(r);return n}}},function(e,t,c){var f=c(37),l=c(83),p=c(67);t.name="min",t.factory=function(e,t,r,n){var i=r(c(42)),a=r(c(31)),o=n("min",{"Array | Matrix":u,"Array | Matrix, number | BigNumber":function(e,t){return l(e,t.valueOf(),s)},"...":function(e){if(p(e))throw new TypeError("Scalar values expected in function min");return u(e)}});return o.toTex="\\min\\left(${args}\\right)",o;function s(e,t){try{return i(e,t)?e:t}catch(e){throw a(e,"min",t)}}function u(e){var r=void 0;if(f(e,function(t){try{(void 0===r||i(t,r))&&(r=t)}catch(e){throw a(e,"min",t)}}),void 0===r)throw new Error("Cannot calculate min of an empty array");return r}}},function(e,t,f){var r=f(29),l=r.object,p=r.string;t.name="det",t.factory=function(i,e,t,r){var a=t(f(1)),o=t(f(13)),s=t(f(16)),u=t(f(8)),c=t(f(32)),n=r("det",{any:function(e){return l.clone(e)},"Array | Matrix":function(e){var t;switch((t=i.isMatrix(e)?e.size():Array.isArray(e)?(e=a(e)).size():[]).length){case 0:return l.clone(e);case 1:if(1==t[0])return l.clone(e.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+p.format(t)+")");case 2:var r=t[0],n=t[1];if(r==n)return function(e,t,r){if(1==t)return l.clone(e[0][0]);if(2==t)return s(u(e[0][0],e[1][1]),u(e[1][0],e[0][1]));for(var n=function(e){var t,r,n=new Array(e.length),i=0;for(t=1;t<e.length;t++)i=o(i,e[t][t]);for(t=0;t<e.length;t++){for(n[t]=new Array(e.length),n[t][t]=c(i),r=0;r<t;r++)n[t][r]=0;for(r=t+1;r<e.length;r++)n[t][r]=e[t][r];t+1<e.length&&(i=s(i,e[t+1][t+1]))}return n},i=e,a=0;a<t-1;a++)i=u(n(i),e);return t%2==0?c(i[0][0]):i[0][0]}(e.clone().valueOf(),r);throw new RangeError("Matrix must be square (size: "+p.format(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+p.format(t)+")")}}});return n.toTex={1:"\\det\\left(${args[0]}\\right)"},n}},function(e,t,c){var f=c(2).size,l=c(37),p=c(83),m=c(67);t.name="mean",t.factory=function(e,t,r,n){var i=r(c(13)),a=r(c(30)),o=r(c(31)),s=n("mean",{"Array | Matrix":u,"Array | Matrix, number | BigNumber":function(e,t){try{var r=p(e,t,i),n=Array.isArray(e)?f(e):e.size();return a(r,n[t])}catch(e){throw o(e,"mean")}},"...":function(e){if(m(e))throw new TypeError("Scalar values expected in function mean");return u(e)}});return s.toTex=void 0,s;function u(e){var r=0,n=0;if(l(e,function(t){try{r=i(r,t),n++}catch(e){throw o(e,"mean",t)}}),0===n)throw new Error("Cannot calculate mean of an empty array");return a(r,n)}}},function(e,t,s){var u=s(5).extend,c=s(15);t.name="Parser",t.path="expression",t.factory=function(e,t,r,n,i){var a=r(s(39));function o(){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");this.scope={}}return o.prototype.type="Parser",o.prototype.isParser=!0,o.prototype.parse=function(e){throw new Error("Parser.parse is deprecated. Use math.parse instead.")},o.prototype.compile=function(e){throw new Error("Parser.compile is deprecated. Use math.compile instead.")},o.prototype.eval=function(e){return a(e).compile().eval(this.scope)},o.prototype.get=function(e){return e in this.scope?c.getSafeProperty(this.scope,e):void 0},o.prototype.getAll=function(){return u({},this.scope)},o.prototype.set=function(e,t){return c.setSafeProperty(this.scope,e,t)},o.prototype.remove=function(e){delete this.scope[e]},o.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},o},t.math=!0},function(e,t,o){t.name="parser",t.factory=function(e,t,r,n,i){var a=r(o(123));return n("parser",{"":function(){return new a(i)}})},t.math=!0},function(e,t,a){t.name="parse",t.factory=function(e,t,r,n){var i=r(a(39));return n("parse",{"string | Array | Matrix":i,"string | Array | Matrix, Object":i})}},function(e,t,s){var u=s(59);t.name="RangeNode",t.path="expression.node",t.factory=function(n,e,t,r){var i=t(s(14));function a(e,t,r){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!n.isNode(e))throw new TypeError("Node expected");if(!n.isNode(t))throw new TypeError("Node expected");if(r&&!n.isNode(r))throw new TypeError("Node expected");if(3<arguments.length)throw new Error("Too many arguments");this.start=e,this.end=t,this.step=r||null}function o(e,t){var r=u.getPrecedence(e,t),n={},i=u.getPrecedence(e.start,t);if(n.start=null!==i&&i<=r||"all"===t,e.step){var a=u.getPrecedence(e.step,t);n.step=null!==a&&a<=r||"all"===t}var o=u.getPrecedence(e.end,t);return n.end=null!==o&&o<=r||"all"===t,n}return(a.prototype=new i).type="RangeNode",a.prototype.isRangeNode=!0,a.prototype.needsEnd=function(){return 0<this.filter(function(e){return n.isSymbolNode(e)&&"end"===e.name}).length},a.prototype._compile=function(e,t){var n=e.range,i=this.start._compile(e,t),a=this.end._compile(e,t);if(this.step){var o=this.step._compile(e,t);return function(e,t,r){return n(i(e,t,r),a(e,t,r),o(e,t,r))}}return function(e,t,r){return n(i(e,t,r),a(e,t,r))}},a.prototype.forEach=function(e){e(this.start,"start",this),e(this.end,"end",this),this.step&&e(this.step,"step",this)},a.prototype.map=function(e){return new a(this._ifNode(e(this.start,"start",this)),this._ifNode(e(this.end,"end",this)),this.step&&this._ifNode(e(this.step,"step",this)))},a.prototype.clone=function(){return new a(this.start,this.end,this.step&&this.step)},a.prototype._toString=function(e){var t,r=o(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toString(e);if(r.start&&(n="("+n+")"),t=n,this.step){var i=this.step.toString(e);r.step&&(i="("+i+")"),t+=":"+i}var a=this.end.toString(e);return r.end&&(a="("+a+")"),t+=":"+a},a.prototype.toJSON=function(){return{mathjs:"RangeNode",start:this.start,end:this.end,step:this.step}},a.fromJSON=function(e){return new a(e.start,e.end,e.step)},a.prototype.toHTML=function(e){var t,r=o(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toHTML(e);if(r.start&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t=n,this.step){var i=this.step.toHTML(e);r.step&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+i}var a=this.end.toHTML(e);return r.end&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+a},a.prototype._toTex=function(e){var t=o(this,e&&e.parenthesis?e.parenthesis:"keep"),r=this.start.toTex(e);if(t.start&&(r="\\left("+r+"\\right)"),this.step){var n=this.step.toTex(e);t.step&&(n="\\left("+n+"\\right)"),r+=":"+n}var i=this.end.toTex(e);return t.end&&(i="\\left("+i+"\\right)"),r+=":"+i},a}},function(e,t,o){var s=o(9).stringify,u=o(9).escape,c=o(15).isSafeProperty,f=o(5).hasOwnProperty;t.name="ObjectNode",t.path="expression.node",t.factory=function(r,e,t,n){var i=t(o(14));function a(t){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(this.properties=t||{},t&&("object"!=typeof t||!Object.keys(t).every(function(e){return r.isNode(t[e])})))throw new TypeError("Object containing Nodes expected")}return(a.prototype=new i).type="ObjectNode",a.prototype.isObjectNode=!0,a.prototype._compile=function(e,t){var a={};for(var r in this.properties)if(f(this.properties,r)){var n=s(r),i=JSON.parse(n);if(!c(this.properties,i))throw new Error('No access to property "'+i+'"');a[i]=this.properties[r]._compile(e,t)}return function(e,t,r){var n={};for(var i in a)f(a,i)&&(n[i]=a[i](e,t,r));return n}},a.prototype.forEach=function(e){for(var t in this.properties)this.properties.hasOwnProperty(t)&&e(this.properties[t],"properties["+s(t)+"]",this)},a.prototype.map=function(e){var t={};for(var r in this.properties)this.properties.hasOwnProperty(r)&&(t[r]=this._ifNode(e(this.properties[r],"properties["+s(r)+"]",this)));return new a(t)},a.prototype.clone=function(){var e={};for(var t in this.properties)this.properties.hasOwnProperty(t)&&(e[t]=this.properties[t]);return new a(e)},a.prototype._toString=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push(s(r)+": "+this.properties[r].toString(e));return"{"+t.join(", ")+"}"},a.prototype.toJSON=function(){return{mathjs:"ObjectNode",properties:this.properties}},a.fromJSON=function(e){return new a(e.properties)},a.prototype.toHTML=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push('<span class="math-symbol math-property">'+u(r)+'</span><span class="math-operator math-assignment-operator math-property-assignment-operator math-binary-operator">:</span>'+this.properties[r].toHTML(e));return'<span class="math-parenthesis math-curly-parenthesis">{</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-curly-parenthesis">}</span>'},a.prototype._toTex=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push("\\mathbf{"+r+":} & "+this.properties[r].toTex(e)+"\\\\");return"\\left\\{\\begin{array}{ll}"+t.join("\n")+"\\end{array}\\right\\}"},a}},function(e,t,o){var s=o(134),u=o(9).escape,l=o(2).forEach,p=o(2).join,c=o(4),m=o(59),h=o(15).setSafeProperty;t.name="FunctionAssignmentNode",t.path="expression.node",t.factory=function(n,e,t,f){var r=t(o(14));function i(e,t,r){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');if(!Array.isArray(t))throw new TypeError('Array containing strings or objects expected for parameter "params"');if(!n.isNode(r))throw new TypeError('Node expected for parameter "expr"');if(e in s)throw new Error('Illegal function name, "'+e+'" is a reserved keyword');this.name=e,this.params=t.map(function(e){return e&&e.name||e}),this.types=t.map(function(e){return e&&e.type||"any"}),this.expr=r}function a(e,t){var r=m.getPrecedence(e,t),n=m.getPrecedence(e.expr,t);return"all"===t||null!==n&&n<=r}return(i.prototype=new r).type="FunctionAssignmentNode",i.prototype.isFunctionAssignmentNode=!0,i.prototype._compile=function(e,t){var r=Object.create(t);l(this.params,function(e){r[e]=!0});var a=this.expr._compile(e,r),o=this.name,s=this.params,u=p(this.types,","),c=o+"("+p(this.params,", ")+")";return function(r,n,i){var e={};e[u]=function(){for(var e=Object.create(n),t=0;t<s.length;t++)e[s[t]]=arguments[t];return a(r,e,i)};var t=f(o,e);return t.syntax=c,h(r,o,t),t}},i.prototype.forEach=function(e){e(this.expr,"expr",this)},i.prototype.map=function(e){var t=this._ifNode(e(this.expr,"expr",this));return new i(this.name,this.params.slice(0),t)},i.prototype.clone=function(){return new i(this.name,this.params.slice(0),this.expr)},i.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toString(e);return a(this,t)&&(r="("+r+")"),this.name+"("+this.params.join(", ")+") = "+r},i.prototype.toJSON=function(){var r=this.types;return{mathjs:"FunctionAssignmentNode",name:this.name,params:this.params.map(function(e,t){return{name:e,type:r[t]}}),expr:this.expr}},i.fromJSON=function(e){return new i(e.name,e.params,e.expr)},i.prototype.toHTML=function(e){for(var t=e&&e.parenthesis?e.parenthesis:"keep",r=[],n=0;n<this.params.length;n++)r.push('<span class="math-symbol math-parameter">'+u(this.params[n])+"</span>");var i=this.expr.toHTML(e);return a(this,t)&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),'<span class="math-function">'+u(this.name)+'</span><span class="math-parenthesis math-round-parenthesis">(</span>'+r.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-round-parenthesis">)</span><span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+i},i.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toTex(e);return a(this,t)&&(r="\\left("+r+"\\right)"),"\\mathrm{"+this.name+"}\\left("+this.params.map(c.toSymbol).join(",")+"\\right):="+r},i}},function(e,t,a){var c=a(59);t.name="ConditionalNode",t.path="expression.node",t.factory=function(o,e,t,r){var n=t(a(14)),s=t(a(49));function i(e,t,r){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if(!o.isNode(e))throw new TypeError("Parameter condition must be a Node");if(!o.isNode(t))throw new TypeError("Parameter trueExpr must be a Node");if(!o.isNode(r))throw new TypeError("Parameter falseExpr must be a Node");this.condition=e,this.trueExpr=t,this.falseExpr=r}return(i.prototype=new n).type="ConditionalNode",i.prototype.isConditionalNode=!0,i.prototype._compile=function(e,t){var n=this.condition._compile(e,t),i=this.trueExpr._compile(e,t),a=this.falseExpr._compile(e,t);return function(e,t,r){return function(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e)return!!e;if(e){if(o.isBigNumber(e))return!e.isZero();if(o.isComplex(e))return!(!e.re&&!e.im);if(o.isUnit(e))return!!e.value}if(null==e)return!1;throw new TypeError('Unsupported type of condition "'+s(e)+'"')}(n(e,t,r))?i(e,t,r):a(e,t,r)}},i.prototype.forEach=function(e){e(this.condition,"condition",this),e(this.trueExpr,"trueExpr",this),e(this.falseExpr,"falseExpr",this)},i.prototype.map=function(e){return new i(this._ifNode(e(this.condition,"condition",this)),this._ifNode(e(this.trueExpr,"trueExpr",this)),this._ifNode(e(this.falseExpr,"falseExpr",this)))},i.prototype.clone=function(){return new i(this.condition,this.trueExpr,this.falseExpr)},i.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=c.getPrecedence(this,t),n=this.condition.toString(e),i=c.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==i&&i<=r)&&(n="("+n+")");var a=this.trueExpr.toString(e),o=c.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==o&&o<=r)&&(a="("+a+")");var s=this.falseExpr.toString(e),u=c.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==u&&u<=r)&&(s="("+s+")"),n+" ? "+a+" : "+s},i.prototype.toJSON=function(){return{mathjs:"ConditionalNode",condition:this.condition,trueExpr:this.trueExpr,falseExpr:this.falseExpr}},i.fromJSON=function(e){return new i(e.condition,e.trueExpr,e.falseExpr)},i.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=c.getPrecedence(this,t),n=this.condition.toHTML(e),i=c.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==i&&i<=r)&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>');var a=this.trueExpr.toHTML(e),o=c.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==o&&o<=r)&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>');var s=this.falseExpr.toHTML(e),u=c.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==u&&u<=r)&&(s='<span class="math-parenthesis math-round-parenthesis">(</span>'+s+'<span class="math-parenthesis math-round-parenthesis">)</span>'),n+'<span class="math-operator math-conditional-operator">?</span>'+a+'<span class="math-operator math-conditional-operator">:</span>'+s},i.prototype._toTex=function(e){return"\\begin{cases} {"+this.trueExpr.toTex(e)+"}, &\\quad{\\text{if }\\;"+this.condition.toTex(e)+"}\\\\{"+this.falseExpr.toTex(e)+"}, &\\quad{\\text{otherwise}}\\end{cases}"},i}},function(e,t,s){var u=s(2).forEach,c=s(2).map;t.name="BlockNode",t.path="expression.node",t.factory=function(n,e,t,r){var i=t(s(14)),o=t(s(144));function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(e))throw new Error("Array expected");this.blocks=e.map(function(e){var t=e&&e.node,r=!e||void 0===e.visible||e.visible;if(!n.isNode(t))throw new TypeError('Property "node" must be a Node');if("boolean"!=typeof r)throw new TypeError('Property "visible" must be a boolean');return{node:t,visible:r}})}return(a.prototype=new i).type="BlockNode",a.prototype.isBlockNode=!0,a.prototype._compile=function(t,r){var e=c(this.blocks,function(e){return{eval:e.node._compile(t,r),visible:e.visible}});return function(r,n,i){var a=[];return u(e,function(e){var t=e.eval(r,n,i);e.visible&&a.push(t)}),new o(a)}},a.prototype.forEach=function(e){for(var t=0;t<this.blocks.length;t++)e(this.blocks[t].node,"blocks["+t+"].node",this)},a.prototype.map=function(e){for(var t=[],r=0;r<this.blocks.length;r++){var n=this.blocks[r],i=this._ifNode(e(n.node,"blocks["+r+"].node",this));t[r]={node:i,visible:n.visible}}return new a(t)},a.prototype.clone=function(){return new a(this.blocks.map(function(e){return{node:e.node,visible:e.visible}}))},a.prototype._toString=function(t){return this.blocks.map(function(e){return e.node.toString(t)+(e.visible?"":";")}).join("\n")},a.prototype.toJSON=function(){return{mathjs:"BlockNode",blocks:this.blocks}},a.fromJSON=function(e){return new a(e.blocks)},a.prototype.toHTML=function(t){return this.blocks.map(function(e){return e.node.toHTML(t)+(e.visible?"":'<span class="math-separator">;</span>')}).join('<span class="math-separator"><br /></span>')},a.prototype._toTex=function(t){return this.blocks.map(function(e){return e.node.toTex(t)+(e.visible?"":";")}).join("\\;\\;\n")},a}},function(e,t,u){var d=u(15).getSafeProperty,g=u(15).setSafeProperty;t.name="AssignmentNode",t.path="expression.node",t.factory=function(n,e,t,r){var i=t(u(14)),m=t(u(316)),h=t(u(133)),a=u(59);function o(e,t,r){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");if(this.object=e,this.index=r?t:null,this.value=r||t,!n.isSymbolNode(e)&&!n.isAccessorNode(e))throw new TypeError('SymbolNode or AccessorNode expected as "object"');if(n.isSymbolNode(e)&&"end"===e.name)throw new Error('Cannot assign to symbol "end"');if(this.index&&!n.isIndexNode(this.index))throw new TypeError('IndexNode expected as "index"');if(!n.isNode(this.value))throw new TypeError('Node expected as "value"');Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function s(e,t){t||(t="keep");var r=a.getPrecedence(e,t),n=a.getPrecedence(e.value,t);return"all"===t||null!==n&&n<=r}return(o.prototype=new i).type="AssignmentNode",o.prototype.isAssignmentNode=!0,o.prototype._compile=function(e,t){var o=this.object._compile(e,t),u=this.index?this.index._compile(e,t):null,c=this.value._compile(e,t),s=this.object.name;if(this.index){if(this.index.isObjectProperty()){var a=this.index.getObjectProperty();return function(e,t,r){var n=o(e,t,r),i=c(e,t,r);return g(n,a,i)}}if(n.isSymbolNode(this.object))return function(e,t,r){var n=o(e,t,r),i=c(e,t,r),a=u(e,t,n);return g(e,s,m(n,a,i)),i};var f=this.object.object._compile(e,t);if(this.object.index.isObjectProperty()){var l=this.object.index.getObjectProperty();return function(e,t,r){var n=f(e,t,r),i=d(n,l),a=u(e,t,i),o=c(e,t,r);return g(n,l,m(i,a,o)),o}}var p=this.object.index._compile(e,t);return function(e,t,r){var n=f(e,t,r),i=p(e,t,n),a=h(n,i),o=u(e,t,a),s=c(e,t,r);return m(n,i,m(a,o,s)),s}}if(!n.isSymbolNode(this.object))throw new TypeError("SymbolNode expected as object");return function(e,t,r){return g(e,s,c(e,t,r))}},o.prototype.forEach=function(e){e(this.object,"object",this),this.index&&e(this.index,"index",this),e(this.value,"value",this)},o.prototype.map=function(e){return new o(this._ifNode(e(this.object,"object",this)),this.index?this._ifNode(e(this.index,"index",this)):null,this._ifNode(e(this.value,"value",this)))},o.prototype.clone=function(){return new o(this.object,this.index,this.value)},o.prototype._toString=function(e){var t=this.object.toString(e),r=this.index?this.index.toString(e):"",n=this.value.toString(e);return s(this,e&&e.parenthesis)&&(n="("+n+")"),t+r+" = "+n},o.prototype.toJSON=function(){return{mathjs:"AssignmentNode",object:this.object,index:this.index,value:this.value}},o.fromJSON=function(e){return new o(e.object,e.index,e.value)},o.prototype.toHTML=function(e){var t=this.object.toHTML(e),r=this.index?this.index.toHTML(e):"",n=this.value.toHTML(e);return s(this,e&&e.parenthesis)&&(n='<span class="math-paranthesis math-round-parenthesis">(</span>'+n+'<span class="math-paranthesis math-round-parenthesis">)</span>'),t+r+'<span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+n},o.prototype._toTex=function(e){var t=this.object.toTex(e),r=this.index?this.index.toTex(e):"",n=this.value.toTex(e);return s(this,e&&e.parenthesis)&&(n="\\left("+n+"\\right)"),t+r+":="+n},o}},function(e,t,o){var s=o(2).map;t.name="ArrayNode",t.path="expression.node",t.factory=function(r,e,t,n){var i=t(o(14));function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(this.items=e||[],!Array.isArray(this.items)||!this.items.every(r.isNode))throw new TypeError("Array containing Nodes expected");var t=function(){throw new Error("Property `ArrayNode.nodes` is deprecated, use `ArrayNode.items` instead")};Object.defineProperty(this,"nodes",{get:t,set:t})}return(a.prototype=new i).type="ArrayNode",a.prototype.isArrayNode=!0,a.prototype._compile=function(t,r){var e=s(this.items,function(e){return e._compile(t,r)});if("Array"!==t.config().matrix){var i=t.matrix;return function(t,r,n){return i(s(e,function(e){return e(t,r,n)}))}}return function(t,r,n){return s(e,function(e){return e(t,r,n)})}},a.prototype.forEach=function(e){for(var t=0;t<this.items.length;t++)e(this.items[t],"items["+t+"]",this)},a.prototype.map=function(e){for(var t=[],r=0;r<this.items.length;r++)t[r]=this._ifNode(e(this.items[r],"items["+r+"]",this));return new a(t)},a.prototype.clone=function(){return new a(this.items.slice(0))},a.prototype._toString=function(t){return"["+this.items.map(function(e){return e.toString(t)}).join(", ")+"]"},a.prototype.toJSON=function(){return{mathjs:"ArrayNode",items:this.items}},a.fromJSON=function(e){return new a(e.items)},a.prototype.toHTML=function(t){return'<span class="math-parenthesis math-square-parenthesis">[</span>'+this.items.map(function(e){return e.toHTML(t)}).join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},a.prototype._toTex=function(t){var r="\\begin{bmatrix}";return this.items.forEach(function(e){e.items?r+=e.items.map(function(e){return e.toTex(t)}).join("&"):r+=e.toTex(t),r+="\\\\"}),r+="\\end{bmatrix}"},a}},function(e,t,a){var o=a(38).transform,s=a(15).getSafeProperty;t.factory=function(e,t,r,n){var i=r(a(22));return function(e,t){try{if(Array.isArray(e))return i(e,t);if(e&&"function"==typeof e.subset)return e.subset(t);if("string"==typeof e)return i(e,t);if("object"==typeof e){if(!t.isObjectProperty())throw new TypeError("Cannot apply a numeric index as object property");return s(e,t.getObjectProperty())}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw o(e)}}}},function(e,t,r){e.exports={end:!0}},function(e,t,u){var c=u(15).getSafeProperty;t.name="AccessorNode",t.path="expression.node",t.factory=function(r,e,t,n){var i=t(u(14)),s=(t(u(86)),t(u(133)));function a(e,t){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!r.isNode(e))throw new TypeError('Node expected for parameter "object"');if(!r.isIndexNode(t))throw new TypeError('IndexNode expected for parameter "index"');this.object=e||null,this.index=t,Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function o(e){return!(r.isAccessorNode(e)||r.isArrayNode(e)||r.isConstantNode(e)||r.isFunctionNode(e)||r.isObjectNode(e)||r.isParenthesisNode(e)||r.isSymbolNode(e))}return(a.prototype=new i).type="AccessorNode",a.prototype.isAccessorNode=!0,a.prototype._compile=function(e,t){var a=this.object._compile(e,t),o=this.index._compile(e,t);if(this.index.isObjectProperty()){var n=this.index.getObjectProperty();return function(e,t,r){return c(a(e,t,r),n)}}return function(e,t,r){var n=a(e,t,r),i=o(e,t,n);return s(n,i)}},a.prototype.forEach=function(e){e(this.object,"object",this),e(this.index,"index",this)},a.prototype.map=function(e){return new a(this._ifNode(e(this.object,"object",this)),this._ifNode(e(this.index,"index",this)))},a.prototype.clone=function(){return new a(this.object,this.index)},a.prototype._toString=function(e){var t=this.object.toString(e);return o(this.object)&&(t="("+t+")"),t+this.index.toString(e)},a.prototype.toHTML=function(e){var t=this.object.toHTML(e);return o(this.object)&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+this.index.toHTML(e)},a.prototype._toTex=function(e){var t=this.object.toTex(e);return o(this.object)&&(t="\\left("+t+"\\right)"),t+this.index.toTex(e)},a.prototype.toJSON=function(){return{mathjs:"AccessorNode",object:this.object,index:this.index}},a.fromJSON=function(e){return new a(e.object,e.index)},a}},function(e,t,r){t.factory=function(r,e,t,n){return function(e,t){if("BigNumber"===t)return new r.BigNumber(e);if("Fraction"===t)return new r.Fraction(e);if("number"==typeof e)return e;if("Infinity"===e)return 1/0;if("NaN"===e)return NaN;if(!/^[\-+]?((\d+\.?\d*)|(\d*\.?\d+))([eE][+\-]?\d+)?$/.test(e))throw new Error('Invalid numeric value "'+e+'"');return parseFloat(e.replace(/^(0*)[0-9]/,function(e,t){return e.substring(t.length)}))}}},function(e,t){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e,t){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e,t,a){t.name="docs",t.path="expression",t.factory=function(e,t,r,n){var i={};return i.bignumber=a(515),i.boolean=a(514),i.complex=a(513),i.createUnit=a(512),i.fraction=a(511),i.index=a(510),i.matrix=a(509),i.number=a(508),i.sparse=a(507),i.splitUnit=a(506),i.string=a(505),i.unit=a(504),i.e=a(138),i.E=a(138),i.false=a(503),i.i=a(502),i[1/0]=a(501),i.LN2=a(500),i.LN10=a(499),i.LOG2E=a(498),i.LOG10E=a(497),i.NaN=a(496),i.null=a(495),i.pi=a(137),i.PI=a(137),i.phi=a(494),i.SQRT1_2=a(493),i.SQRT2=a(492),i.tau=a(491),i.true=a(490),i.version=a(489),i.speedOfLight={description:"Speed of light in vacuum",examples:["speedOfLight"]},i.gravitationConstant={description:"Newtonian constant of gravitation",examples:["gravitationConstant"]},i.planckConstant={description:"Planck constant",examples:["planckConstant"]},i.reducedPlanckConstant={description:"Reduced Planck constant",examples:["reducedPlanckConstant"]},i.magneticConstant={description:"Magnetic constant (vacuum permeability)",examples:["magneticConstant"]},i.electricConstant={description:"Electric constant (vacuum permeability)",examples:["electricConstant"]},i.vacuumImpedance={description:"Characteristic impedance of vacuum",examples:["vacuumImpedance"]},i.coulomb={description:"Coulomb's constant",examples:["coulomb"]},i.elementaryCharge={description:"Elementary charge",examples:["elementaryCharge"]},i.bohrMagneton={description:"Borh magneton",examples:["bohrMagneton"]},i.conductanceQuantum={description:"Conductance quantum",examples:["conductanceQuantum"]},i.inverseConductanceQuantum={description:"Inverse conductance quantum",examples:["inverseConductanceQuantum"]},i.magneticFluxQuantum={description:"Magnetic flux quantum",examples:["magneticFluxQuantum"]},i.nuclearMagneton={description:"Nuclear magneton",examples:["nuclearMagneton"]},i.klitzing={description:"Von Klitzing constant",examples:["klitzing"]},i.bohrRadius={description:"Borh radius",examples:["bohrRadius"]},i.classicalElectronRadius={description:"Classical electron radius",examples:["classicalElectronRadius"]},i.electronMass={description:"Electron mass",examples:["electronMass"]},i.fermiCoupling={description:"Fermi coupling constant",examples:["fermiCoupling"]},i.fineStructure={description:"Fine-structure constant",examples:["fineStructure"]},i.hartreeEnergy={description:"Hartree energy",examples:["hartreeEnergy"]},i.protonMass={description:"Proton mass",examples:["protonMass"]},i.deuteronMass={description:"Deuteron Mass",examples:["deuteronMass"]},i.neutronMass={description:"Neutron mass",examples:["neutronMass"]},i.quantumOfCirculation={description:"Quantum of circulation",examples:["quantumOfCirculation"]},i.rydberg={description:"Rydberg constant",examples:["rydberg"]},i.thomsonCrossSection={description:"Thomson cross section",examples:["thomsonCrossSection"]},i.weakMixingAngle={description:"Weak mixing angle",examples:["weakMixingAngle"]},i.efimovFactor={description:"Efimov factor",examples:["efimovFactor"]},i.atomicMass={description:"Atomic mass constant",examples:["atomicMass"]},i.avogadro={description:"Avogadro's number",examples:["avogadro"]},i.boltzmann={description:"Boltzmann constant",examples:["boltzmann"]},i.faraday={description:"Faraday constant",examples:["faraday"]},i.firstRadiation={description:"First radiation constant",examples:["firstRadiation"]},i.loschmidt={description:"Loschmidt constant at T=273.15 K and p=101.325 kPa",examples:["loschmidt"]},i.gasConstant={description:"Gas constant",examples:["gasConstant"]},i.molarPlanckConstant={description:"Molar Planck constant",examples:["molarPlanckConstant"]},i.molarVolume={description:"Molar volume of an ideal gas at T=273.15 K and p=101.325 kPa",examples:["molarVolume"]},i.sackurTetrode={description:"Sackur-Tetrode constant at T=1 K and p=101.325 kPa",examples:["sackurTetrode"]},i.secondRadiation={description:"Second radiation constant",examples:["secondRadiation"]},i.stefanBoltzmann={description:"Stefan-Boltzmann constant",examples:["stefanBoltzmann"]},i.wienDisplacement={description:"Wien displacement law constant",examples:["wienDisplacement"]},i.molarMass={description:"Molar mass constant",examples:["molarMass"]},i.molarMassC12={description:"Molar mass constant of carbon-12",examples:["molarMassC12"]},i.gravity={description:"Standard acceleration of gravity (standard acceleration of free-fall on Earth)",examples:["gravity"]},i.planckLength={description:"Planck length",examples:["planckLength"]},i.planckMass={description:"Planck mass",examples:["planckMass"]},i.planckTime={description:"Planck time",examples:["planckTime"]},i.planckCharge={description:"Planck charge",examples:["planckCharge"]},i.planckTemperature={description:"Planck temperature",examples:["planckTemperature"]},i.derivative=a(488),i.lsolve=a(487),i.lup=a(486),i.lusolve=a(485),i.simplify=a(484),i.rationalize=a(483),i.slu=a(482),i.usolve=a(481),i.qr=a(480),i.abs=a(479),i.add=a(478),i.cbrt=a(477),i.ceil=a(476),i.cube=a(475),i.divide=a(474),i.dotDivide=a(473),i.dotMultiply=a(472),i.dotPow=a(471),i.exp=a(470),i.expm=a(469),i.expm1=a(468),i.fix=a(467),i.floor=a(466),i.gcd=a(465),i.hypot=a(464),i.lcm=a(463),i.log=a(462),i.log2=a(461),i.log1p=a(460),i.log10=a(459),i.mod=a(458),i.multiply=a(457),i.norm=a(456),i.nthRoot=a(455),i.pow=a(454),i.round=a(453),i.sign=a(452),i.sqrt=a(451),i.sqrtm=a(450),i.square=a(449),i.subtract=a(448),i.unaryMinus=a(447),i.unaryPlus=a(446),i.xgcd=a(445),i.bitAnd=a(444),i.bitNot=a(443),i.bitOr=a(442),i.bitXor=a(441),i.leftShift=a(440),i.rightArithShift=a(439),i.rightLogShift=a(438),i.bellNumbers=a(437),i.catalan=a(436),i.composition=a(435),i.stirlingS2=a(434),i.config=a(433),i.import=a(432),i.typed=a(431),i.arg=a(430),i.conj=a(429),i.re=a(428),i.im=a(427),i.eval=a(426),i.help=a(425),i.distance=a(424),i.intersect=a(423),i.and=a(422),i.not=a(421),i.or=a(420),i.xor=a(419),i.concat=a(418),i.cross=a(417),i.det=a(416),i.diag=a(415),i.dot=a(414),i.eye=a(413),i.filter=a(412),i.flatten=a(411),i.forEach=a(410),i.inv=a(409),i.kron=a(408),i.map=a(407),i.ones=a(406),i.partitionSelect=a(405),i.range=a(404),i.resize=a(403),i.reshape=a(402),i.size=a(401),i.sort=a(400),i.squeeze=a(399),i.subset=a(398),i.trace=a(397),i.transpose=a(396),i.zeros=a(395),i.combinations=a(394),i.factorial=a(393),i.gamma=a(392),i.kldivergence=a(391),i.multinomial=a(390),i.permutations=a(389),i.pickRandom=a(388),i.random=a(387),i.randomInt=a(386),i.compare=a(385),i.compareNatural=a(384),i.deepEqual=a(383),i.equal=a(382),i.larger=a(381),i.largerEq=a(380),i.smaller=a(379),i.smallerEq=a(378),i.unequal=a(377),i.setCartesian=a(376),i.setDifference=a(375),i.setDistinct=a(374),i.setIntersect=a(373),i.setIsSubset=a(372),i.setMultiplicity=a(371),i.setPowerset=a(370),i.setSize=a(369),i.setSymDifference=a(368),i.setUnion=a(367),i.erf=a(366),i.mad=a(365),i.max=a(364),i.mean=a(363),i.median=a(362),i.min=a(361),i.mode=a(360),i.prod=a(359),i.quantileSeq=a(358),i.std=a(357),i.sum=a(356),i.var=a(355),i.acos=a(354),i.acosh=a(353),i.acot=a(352),i.acoth=a(351),i.acsc=a(350),i.acsch=a(349),i.asec=a(348),i.asech=a(347),i.asin=a(346),i.asinh=a(345),i.atan=a(344),i.atanh=a(343),i.atan2=a(342),i.cos=a(341),i.cosh=a(340),i.cot=a(339),i.coth=a(338),i.csc=a(337),i.csch=a(336),i.sec=a(335),i.sech=a(334),i.sin=a(333),i.sinh=a(332),i.tan=a(331),i.tanh=a(330),i.to=a(329),i.clone=a(328),i.format=a(327),i.isNaN=a(326),i.isInteger=a(325),i.isNegative=a(324),i.isNumeric=a(323),i.isPositive=a(322),i.isPrime=a(321),i.isZero=a(320),i.typeof=a(319),i}},function(e,t,r){var a=r(9);t.name="format",t.factory=function(e,t,r,n){var i=n("format",{any:a.format,"any, Object | function | number":a.format});return i.toTex=void 0,i}},function(e,t,l){var p=l(3).isInteger,m=l(3).toFixed,h=l(0),d="Number of decimals in function round must be an integer";t.name="round",t.factory=function(r,e,t,n){var i=t(l(1)),a=t(l(10)),o=t(l(40)),s=t(l(17)),u=t(l(18)),c=t(l(6)),f=n("round",{number:Math.round,"number, number":function(e,t){if(!p(t))throw new TypeError(d);if(t<0||15<t)throw new Error("Number of decimals in function round must be in te range of 0-15");return parseFloat(m(e,t))},Complex:function(e){return e.round()},"Complex, number":function(e,t){if(t%1)throw new TypeError(d);return e.round(t)},"Complex, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(d);var r=t.toNumber();return e.round(r)},"number, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(d);return new r.BigNumber(e).toDecimalPlaces(t.toNumber())},BigNumber:function(e){return e.toDecimalPlaces(0)},"BigNumber, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(d);return e.toDecimalPlaces(t.toNumber())},Fraction:function(e){return e.round()},"Fraction, number":function(e,t){if(t%1)throw new TypeError(d);return e.round(t)},"Array | Matrix":function(e){return h(e,f,!0)},"SparseMatrix, number | BigNumber":function(e,t){return s(e,t,f,!1)},"DenseMatrix, number | BigNumber":function(e,t){return c(e,t,f,!1)},"number | Complex | BigNumber, SparseMatrix":function(e,t){return a(e,0)?o(t.size(),t.storage()):u(t,e,f,!0)},"number | Complex | BigNumber, DenseMatrix":function(e,t){return a(e,0)?o(t.size(),t.storage()):c(t,e,f,!0)},"Array, number | BigNumber":function(e,t){return c(i(e),t,f,!1).valueOf()},"number | Complex | BigNumber, Array":function(e,t){return c(i(t),e,f,!0).valueOf()}});return f.toTex={1:"\\left\\lfloor${args[0]}\\right\\rceil",2:void 0},f}},function(e,t,r){var a=r(0);t.name="fix",t.factory=function(t,e,r,n){var i=n("fix",{number:function(e){return 0<e?Math.floor(e):Math.ceil(e)},Complex:function(e){return new t.Complex(0<e.re?Math.floor(e.re):Math.ceil(e.re),0<e.im?Math.floor(e.im):Math.ceil(e.im))},BigNumber:function(e){return e.isNegative()?e.ceil():e.floor()},Fraction:function(e){return e.s<0?e.ceil():e.floor()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},i}},function(e,t,r){var n=r(35).memoize;function i(e){return e[0].precision}t.e=n(function(e){return new e(1).exp()},i),t.phi=n(function(e){return new e(1).plus(new e(5).sqrt()).div(2)},i),t.pi=n(function(e){return e.acos(-1)},i),t.tau=n(function(e){return t.pi(e).times(2)},i)},function(e,t,r){t.name="ResultSet",t.path="type",t.factory=function(e,t,r,n){function i(e){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.entries=e||[]}return i.prototype.type="ResultSet",i.prototype.isResultSet=!0,i.prototype.valueOf=function(){return this.entries},i.prototype.toString=function(){return"["+this.entries.join(", ")+"]"},i.prototype.toJSON=function(){return{mathjs:"ResultSet",entries:this.entries}},i.fromJSON=function(e){return new i(e.entries)},i}},function(e,t,r){var a=r(3);t.name="Range",t.path="type",t.factory=function(n,e,t,r){function i(e,t,r){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if(null!=e)if(n.isBigNumber(e))e=e.toNumber();else if("number"!=typeof e)throw new TypeError("Parameter start must be a number");if(null!=t)if(n.isBigNumber(t))t=t.toNumber();else if("number"!=typeof t)throw new TypeError("Parameter end must be a number");if(null!=r)if(n.isBigNumber(r))r=r.toNumber();else if("number"!=typeof r)throw new TypeError("Parameter step must be a number");this.start=null!=e?parseFloat(e):0,this.end=null!=t?parseFloat(t):0,this.step=null!=r?parseFloat(r):1}return i.prototype.type="Range",i.prototype.isRange=!0,i.parse=function(e){if("string"!=typeof e)return null;var t=e.split(":").map(function(e){return parseFloat(e)});if(t.some(function(e){return isNaN(e)}))return null;switch(t.length){case 2:return new i(t[0],t[1]);case 3:return new i(t[0],t[2],t[1]);default:return null}},i.prototype.clone=function(){return new i(this.start,this.end,this.step)},i.prototype.size=function(){var e=0,t=this.start,r=this.step,n=this.end-t;return a.sign(r)==a.sign(n)?e=Math.ceil(n/r):0==n&&(e=0),isNaN(e)&&(e=0),[e]},i.prototype.min=function(){var e=this.size()[0];return 0<e?0<this.step?this.start:this.start+(e-1)*this.step:void 0},i.prototype.max=function(){var e=this.size()[0];return 0<e?0<this.step?this.start+(e-1)*this.step:this.start:void 0},i.prototype.forEach=function(e){var t=this.start,r=this.step,n=this.end,i=0;if(0<r)for(;t<n;)e(t,[i],this),t+=r,i++;else if(r<0)for(;n<t;)e(t,[i],this),t+=r,i++},i.prototype.map=function(n){var i=[];return this.forEach(function(e,t,r){i[t[0]]=n(e,t,r)}),i},i.prototype.toArray=function(){var r=[];return this.forEach(function(e,t){r[t[0]]=e}),r},i.prototype.valueOf=function(){return this.toArray()},i.prototype.format=function(e){var t=a.format(this.start,e);return 1!=this.step&&(t+=":"+a.format(this.step,e)),t+=":"+a.format(this.end,e)},i.prototype.toString=function(){return this.format()},i.prototype.toJSON=function(){return{mathjs:"Range",start:this.start,end:this.end,step:this.step}},i.fromJSON=function(e){return new i(e.start,e.end,e.step)},i}},function(e,t,r){var a=r(0);t.name="fraction",t.factory=function(r,e,t,n){var i=n("fraction",{number:function(e){if(!isFinite(e)||isNaN(e))throw new Error(e+" cannot be represented as a fraction");return new r.Fraction(e)},string:function(e){return new r.Fraction(e)},"number, number":function(e,t){return new r.Fraction(e,t)},null:function(e){return new r.Fraction(0)},BigNumber:function(e){return new r.Fraction(e.toString())},Fraction:function(e){return e},Object:function(e){return new r.Fraction(e)},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){var a=r(540),s=r(3).format,u=r(3).isNumber;t.name="Complex",t.path="type",t.factory=function(n,e,t,r,i){return a.prototype.type="Complex",a.prototype.isComplex=!0,a.prototype.toJSON=function(){return{mathjs:"Complex",re:this.re,im:this.im}},a.prototype.toPolar=function(){return{r:this.abs(),phi:this.arg()}},a.prototype.format=function(e){var t=this.im,r=this.re,n=s(this.re,e),i=s(this.im,e),a=u(e)?e:e?e.precision:null;if(null!==a){var o=Math.pow(10,-a);Math.abs(r/t)<o&&(r=0),Math.abs(t/r)<o&&(t=0)}return 0==t?n:0==r?1==t?"i":-1==t?"-i":i+"i":t<0?-1==t?n+" - i":n+" - "+i.substring(1)+"i":1==t?n+" + i":n+" + "+i+"i"},a.fromPolar=function(e){switch(arguments.length){case 1:if("object"==typeof e)return a(e);throw new TypeError("Input has to be an object with r and phi keys.");case 2:var t=e,r=arguments[1];if(u(t)){if(n.isUnit(r)&&r.hasBase("ANGLE")&&(r=r.toNumber("rad")),u(r))return new a({r:t,phi:r});throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},a.prototype.valueOf=a.prototype.toString,a.fromJSON=function(e){return new a(e)},a.EPSILON=e.epsilon,i.on("config",function(e,t){e.epsilon!==t.epsilon&&(a.EPSILON=e.epsilon)}),a.compare=function(e,t){return e.re>t.re?1:e.re<t.re?-1:e.im>t.im?1:e.im<t.im?-1:0},a},t.math=!0},function(e,t,r){var n=r(555);t.mixin=function(e){var t=new n;return e.on=t.on.bind(t),e.off=t.off.bind(t),e.once=t.once.bind(t),e.emit=t.emit.bind(t),e}},function(e,t,r){var n=r(53),i=r(11),a=r(61);e.exports=[{name:"ArgumentsError",path:"error",factory:function(){return n}},{name:"DimensionError",path:"error",factory:function(){return i}},{name:"IndexError",path:"error",factory:function(){return a}}]},function(e,t,r){t.name="reviver",t.path="json",t.factory=function(n,e,t,r,i){return function(e,t){var r=n[t&&t.mathjs]||i.expression&&i.expression.node[t&&t.mathjs];return r&&"function"==typeof r.fromJSON?r.fromJSON(t):t}},t.math=!0},function(e,t,r){e.exports=[r(150)]},function(e,t,r){var i=r(0);r(3);t.name="isNaN",t.factory=function(e,t,r,n){return n("isNaN",{number:function(e){return Number.isNaN(e)},BigNumber:function(e){return e.isNaN()},Fraction:function(e){return!1},Complex:function(e){return e.isNaN()},Unit:function(e){return Number.isNaN(e.value)},"Array | Matrix":function(e){return i(e,Number.isNaN)}})}},function(e,t,r){var a=r(0);t.name="isPrime",t.factory=function(r,e,t,n){var i=n("isPrime",{number:function(e){if(e<2)return!1;if(2==e)return!0;if(e%2==0)return!1;for(var t=3;t*t<=e;t+=2)if(e%t==0)return!1;return!0},BigNumber:function(e){if(e.lt(2))return!1;if(e.equals(2))return!0;if(e.mod(2).isZero())return!1;for(var t=r.BigNumber(3);t.times(t).lte(e);t=t.plus(1))if(e.mod(t).isZero())return!1;return!0},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){e.exports=[r(115),r(46),r(54),r(60),r(55),r(153),r(56),r(152),r(49)]},function(e,t,c){t.name="to",t.factory=function(e,t,r,n){var i=c(4),a=r(c(1)),o=r(c(7)),s=r(c(6)),u=n("to",{"Unit, Unit | string":function(e,t){return e.to(t)},"Matrix, Matrix":function(e,t){return o(e,t,u)},"Array, Array":function(e,t){return u(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return u(a(e),t)},"Matrix, Array":function(e,t){return u(e,a(t))},"Matrix, any":function(e,t){return s(e,t,u,!1)},"any, Matrix":function(e,t){return s(t,e,u,!0)},"Array, any":function(e,t){return s(a(e),t,u,!1).valueOf()},"any, Array":function(e,t){return s(a(t),e,u,!0).valueOf()}});return u.toTex={2:"\\left(${args[0]}"+i.operators.to+"${args[1]}\\right)"},u}},function(e,t,r){e.exports=[r(155)]},function(e,t,r){var a=r(0);var o=Math.tanh||function(e){var t=Math.exp(2*e);return(t-1)/(t+1)};t.name="tanh",t.factory=function(t,e,r,n){var i=n("tanh",{number:o,Complex:function(e){return e.tanh()},BigNumber:function(e){return e.tanh()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\tanh\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="tan",t.factory=function(t,e,r,n){var i=n("tan",{number:Math.tan,Complex:function(e){return e.tan()},BigNumber:function(e){return e.tan()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\tan\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);var o=Math.sinh||function(e){return(Math.exp(e)-Math.exp(-e))/2};t.name="sinh",t.factory=function(t,e,r,n){var i=n("sinh",{number:o,Complex:function(e){return e.sinh()},BigNumber:function(e){return e.sinh()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\sinh\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="sin",t.factory=function(t,e,r,n){var i=n("sin",{number:Math.sin,Complex:function(e){return e.sin()},BigNumber:function(e){return e.sin()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\sin\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);function o(e){return 2/(Math.exp(e)+Math.exp(-e))}t.name="sech",t.factory=function(t,e,r,n){var i=n("sech",{number:o,Complex:function(e){return e.sech()},BigNumber:function(e){return new t.BigNumber(1).div(e.cosh())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\mathrm{sech}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="sec",t.factory=function(t,e,r,n){var i=n("sec",{number:function(e){return 1/Math.cos(e)},Complex:function(e){return e.sec()},BigNumber:function(e){return new t.BigNumber(1).div(e.cos())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\sec\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0),n=r(3).sign;function o(e){return 0==e?Number.POSITIVE_INFINITY:Math.abs(2/(Math.exp(e)-Math.exp(-e)))*n(e)}t.name="csch",t.factory=function(t,e,r,n){var i=n("csch",{number:o,Complex:function(e){return e.csch()},BigNumber:function(e){return new t.BigNumber(1).div(e.sinh())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\mathrm{csch}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="csc",t.factory=function(t,e,r,n){var i=n("csc",{number:function(e){return 1/Math.sin(e)},Complex:function(e){return e.csc()},BigNumber:function(e){return new t.BigNumber(1).div(e.sin())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\csc\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);function o(e){var t=Math.exp(2*e);return(t+1)/(t-1)}t.name="coth",t.factory=function(t,e,r,n){var i=n("coth",{number:o,Complex:function(e){return e.coth()},BigNumber:function(e){return new t.BigNumber(1).div(e.tanh())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\coth\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="cot",t.factory=function(t,e,r,n){var i=n("cot",{number:function(e){return 1/Math.tan(e)},Complex:function(e){return e.cot()},BigNumber:function(e){return new t.BigNumber(1).div(e.tan())},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cot\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);var o=Math.cosh||function(e){return(Math.exp(e)+Math.exp(-e))/2};t.name="cosh",t.factory=function(t,e,r,n){var i=n("cosh",{number:o,Complex:function(e){return e.cosh()},BigNumber:function(e){return e.cosh()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cosh\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="cos",t.factory=function(t,e,r,n){var i=n("cos",{number:Math.cos,Complex:function(e){return e.cos()},BigNumber:function(e){return e.cos()},Unit:function(e){if(!e.hasBase(t.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return i(e.value)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cos\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);var o=Math.atanh||function(e){return Math.log((1+e)/(1-e))/2};t.name="atanh",t.factory=function(t,r,e,n){var i=n("atanh",{number:function(e){return e<=1&&-1<=e||r.predictable?o(e):new t.Complex(e,0).atanh()},Complex:function(e){return e.atanh()},BigNumber:function(e){return e.atanh()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\tanh^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,m){t.name="atan2",t.factory=function(r,e,t,n){var i=t(m(1)),a=t(m(25)),o=t(m(19)),s=t(m(103)),u=t(m(17)),c=t(m(18)),f=t(m(7)),l=t(m(6)),p=n("atan2",{"number, number":Math.atan2,"BigNumber, BigNumber":function(e,t){return r.BigNumber.atan2(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,p,!1)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,p,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,p,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,p)},"Array, Array":function(e,t){return p(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return p(i(e),t)},"Matrix, Array":function(e,t){return p(e,i(t))},"SparseMatrix, number | BigNumber":function(e,t){return u(e,t,p,!1)},"DenseMatrix, number | BigNumber":function(e,t){return l(e,t,p,!1)},"number | BigNumber, SparseMatrix":function(e,t){return c(t,e,p,!0)},"number | BigNumber, DenseMatrix":function(e,t){return l(t,e,p,!0)},"Array, number | BigNumber":function(e,t){return l(i(e),t,p,!1).valueOf()},"number | BigNumber, Array":function(e,t){return l(i(t),e,p,!0).valueOf()}});return p.toTex={2:"\\mathrm{atan2}\\left(${args}\\right)"},p}},function(e,t,r){var a=r(0);t.name="atan",t.factory=function(e,t,r,n){var i=n("atan",{number:function(e){return Math.atan(e)},Complex:function(e){return e.atan()},BigNumber:function(e){return e.atan()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\tan^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="asinh",t.factory=function(e,t,r,n){var i=n("asinh",{number:Math.asinh||function(e){return Math.log(Math.sqrt(e*e+1)+e)},Complex:function(e){return e.asinh()},BigNumber:function(e){return e.asinh()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\sinh^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="asin",t.factory=function(t,r,e,n){var i=n("asin",{number:function(e){return-1<=e&&e<=1||r.predictable?Math.asin(e):new t.Complex(e,0).asin()},Complex:function(e){return e.asin()},BigNumber:function(e){return e.asin()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\sin^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,a){var o=a(0);t.name="asech",t.factory=function(r,n,e,t){t.find(e(a(91)),["Complex"]);var i=t("asech",{number:function(e){if(e<=1&&-1<=e||n.predictable){e=1/e;var t=Math.sqrt(e*e-1);return 0<e||n.predictable?Math.log(t+e):new r.Complex(Math.log(t-e),Math.PI)}return new r.Complex(e,0).asech()},Complex:function(e){return e.asech()},BigNumber:function(e){return new r.BigNumber(1).div(e).acosh()},"Array | Matrix":function(e){return o(e,i)}});return i.toTex={1:"\\mathrm{sech}^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="asec",t.factory=function(t,r,e,n){var i=n("asec",{number:function(e){return e<=-1||1<=e||r.predictable?Math.acos(1/e):new t.Complex(e,0).asec()},Complex:function(e){return e.asec()},BigNumber:function(e){return new t.BigNumber(1).div(e).acos()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\sec^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="acsch",t.factory=function(t,e,r,n){var i=n("acsch",{number:function(e){return e=1/e,Math.log(e+Math.sqrt(e*e+1))},Complex:function(e){return e.acsch()},BigNumber:function(e){return new t.BigNumber(1).div(e).asinh()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\mathrm{csch}^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="acsc",t.factory=function(t,r,e,n){var i=n("acsc",{number:function(e){return e<=-1||1<=e||r.predictable?Math.asin(1/e):new t.Complex(e,0).acsc()},Complex:function(e){return e.acsc()},BigNumber:function(e){return new t.BigNumber(1).div(e).asin()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\csc^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="acoth",t.factory=function(t,r,e,n){var i=n("acoth",{number:function(e){return 1<=e||e<=-1||r.predictable?isFinite(e)?(Math.log((e+1)/e)+Math.log(e/(e-1)))/2:0:new t.Complex(e,0).acoth()},Complex:function(e){return e.acoth()},BigNumber:function(e){return new t.BigNumber(1).div(e).atanh()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\coth^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="acot",t.factory=function(t,e,r,n){var i=n("acot",{number:function(e){return Math.atan(1/e)},Complex:function(e){return e.acot()},BigNumber:function(e){return new t.BigNumber(1).div(e).atan()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cot^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){var a=r(0);t.name="acos",t.factory=function(t,r,e,n){var i=n("acos",{number:function(e){return-1<=e&&e<=1||r.predictable?Math.acos(e):new t.Complex(e,0).acos()},Complex:function(e){return e.acos()},BigNumber:function(e){return e.acos()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\cos^{-1}\\left(${args[0]}\\right)"},i}},function(e,t,r){e.exports=[r(180),r(91),r(179),r(178),r(177),r(176),r(175),r(174),r(173),r(172),r(171),r(170),r(169),r(168),r(167),r(166),r(165),r(164),r(163),r(162),r(161),r(160),r(159),r(158),r(157)]},function(e,t,r){var s=r(9).isString,u=r(9).format;function a(e,a,o){return e.replace(/\$([\w\.]+)/g,function(e,t){for(var r=t.split("."),n=a[r.shift()];r.length&&void 0!==n;){var i=r.shift();n=i?n[i]:n+"."}return void 0!==n?s(n)?n:u(n,o):e})}t.name="print",t.factory=function(e,t,r,n){var i=n("print",{"string, Object | Array":a,"string, Object | Array, number | Object":a});return i.toTex=void 0,i}},function(e,t,r){e.exports=[r(140),r(182)]},function(e,t,u){t.name="std",t.factory=function(e,t,r,n){var i=r(u(36)),a=r(u(92)),o=n("std",{"Array | Matrix":s,"Array | Matrix, string":s,"...":function(e){return s(e)}});return o.toTex=void 0,o;function s(e,t){if(0==e.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");try{return i(a.apply(null,arguments))}catch(e){throw e instanceof TypeError&&-1!==e.message.indexOf(" var")?new TypeError(e.message.replace(" var"," std")):e}}}},function(e,t,n){var p=n(3).isInteger,x=n(3).isNumber,w=n(2).flatten,m=n(47);t.name="quantileSeq",t.factory=function(f,e,t,r){var h=t(n(13)),d=t(n(8)),g=t(n(74)),v=t(n(45));function l(e,t,r){var n=w(e),i=n.length;if(0===i)throw new Error("Cannot calculate quantile of an empty sequence");if(x(t)){var a;if(0==(l=(a=t*(i-1))%1)){var o=r?n[a]:g(n,a);return y(o),o}var s=Math.floor(a);if(r)c=n[s],f=n[s+1];else{f=g(n,s+1),c=n[s];for(var u=0;u<s;++u)0<v(n[u],c)&&(c=n[u])}return y(c),y(f),h(d(c,1-l),d(f,l))}if((a=t.times(i-1)).isInteger())return a=a.toNumber(),o=r?n[a]:g(n,a),y(o),o;s=a.floor();var c,f,l=a.minus(s),p=s.toNumber();if(r)c=n[p],f=n[p+1];else for(f=g(n,p+1),c=n[p],u=0;u<p;++u)0<v(n[u],c)&&(c=n[u]);y(c),y(f);var m=new l.constructor(1);return h(d(c,m.minus(l)),d(f,l))}var y=r({"number | BigNumber | Unit":function(e){return e}});return function(e,t,r){var n,i,a;if(arguments.length<2||3<arguments.length)throw new SyntaxError("Function quantileSeq requires two or three parameters");if(m(e)){if("boolean"==typeof(r=r||!1)){if(i=e.valueOf(),x(t)){if(t<0)throw new Error("N/prob must be non-negative");if(t<=1)return l(i,t,r);if(1<t){if(!p(t))throw new Error("N must be a positive integer");var o=t+1;n=new Array(t);for(var s=0;s<t;)n[s]=l(i,++s/o,r);return n}}if(f.isBigNumber(t)){if(t.isNegative())throw new Error("N/prob must be non-negative");if(a=new t.constructor(1),t.lte(a))return l(i,t,r);if(t.gt(a)){if(!t.isInteger())throw new Error("N must be a positive integer");var u=t.toNumber();if(4294967295<u)throw new Error("N must be less than or equal to 2^32-1, as that is the maximum length of an Array");for(o=new f.BigNumber(u+1),n=new Array(u),s=0;s<u;)n[s]=l(i,new f.BigNumber(++s).div(o),r);return n}}if(Array.isArray(t)){for(n=new Array(t.length),s=0;s<n.length;++s){var c=t[s];if(x(c)){if(c<0||1<c)throw new Error("Probability must be between 0 and 1, inclusive")}else{if(!f.isBigNumber(c))throw new TypeError("Unexpected type of argument in function quantileSeq");if(a=new c.constructor(1),c.isNegative()||c.gt(a))throw new Error("Probability must be between 0 and 1, inclusive")}n[s]=l(i,c,r)}return n}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}}},function(e,t,u){var c=u(37);t.name="prod",t.factory=function(e,t,r,n){var i=r(u(21)),a=r(u(31)),o=n("prod",{"Array | Matrix":s,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("prod(A, dim) is not yet supported")},"...":function(e){return s(e)}});return o.toTex=void 0,o;function s(e){var r=void 0;if(c(e,function(t){try{r=void 0===r?t:i(r,t)}catch(e){throw a(e,"prod",t)}}),void 0===r)throw new Error("Cannot calculate prod of an empty array");return r}}},function(e,t,r){var a=r(2).flatten;t.name="mode",t.factory=function(e,t,r,n){return n("mode",{"Array | Matrix":i,"...":function(e){return i(e)}});function i(e){if(0==(e=a(e.valueOf())).length)throw new Error("Cannot calculate mode of an empty array");var t={},r=[],n=0;for(var i in e)e[i]in t||(t[e[i]]=0),t[e[i]]++,t[e[i]]==n?r.push(e[i]):t[e[i]]>n&&(n=t[e[i]],r=[e[i]]);return r}}},function(e,t,l){var p=l(2).flatten;t.name="mad",t.factory=function(e,t,r,n){var i=r(l(23)),a=r(l(98)),o=r(l(93)),s=r(l(16)),u=r(l(31)),c=n("mad",{"Array | Matrix":f,"...":function(e){return f(e)}});return c.toTex=void 0,c;function f(e){if(0===(e=p(e.valueOf())).length)throw new Error("Cannot calculate median absolute deviation (mad) of an empty array");try{var t=o(e);return o(a(e,function(e){return i(s(e,t))}))}catch(e){throw e instanceof TypeError&&-1!==e.message.indexOf("median")?new TypeError(e.message.replace("median","mad")):u(e,"mad")}}}},function(e,t,r){e.exports=[r(188),r(84),r(122),r(93),r(120),r(187),r(186),r(185),r(184),r(97),r(92)]},function(e,t,r){var a=r(0),o=r(3).sign;var s=[[3.1611237438705655,113.86415415105016,377.485237685302,3209.3775891384694,.18577770618460315],[.5641884969886701,8.883149794388377,66.11919063714163,298.6351381974001,881.952221241769,1712.0476126340707,2051.0783778260716,1230.3393547979972,2.1531153547440383e-8],[.30532663496123236,.36034489994980445,.12578172611122926,.016083785148742275,.0006587491615298378,.016315387137302097]],u=[[23.601290952344122,244.02463793444417,1282.6165260773723,2844.236833439171],[15.744926110709835,117.6939508913125,537.1811018620099,1621.3895745666903,3290.7992357334597,4362.619090143247,3439.3676741437216,1230.3393548037495],[2.568520192289822,1.8729528499234604,.5279051029514285,.06051834131244132,.0023352049762686918]],c=Math.pow(2,53);t.name="erf",t.factory=function(t,e,r,n){var i=n("erf",{number:function(e){var t=Math.abs(e);return c<=t?o(e):t<=.46875?o(e)*function(e){var t,r=e*e,n=s[0][4]*r,i=r;for(t=0;t<3;t+=1)n=(n+s[0][t])*r,i=(i+u[0][t])*r;return e*(n+s[0][3])/(i+u[0][3])}(t):t<=4?o(e)*(1-function(e){var t,r=s[1][8]*e,n=e;for(t=0;t<7;t+=1)r=(r+s[1][t])*e,n=(n+u[1][t])*e;var i=(r+s[1][7])/(n+u[1][7]),a=parseInt(16*e)/16,o=(e-a)*(e+a);return Math.exp(-a*a)*Math.exp(-o)*i}(t)):o(e)*(1-function(e){var t,r=1/(e*e),n=s[2][5]*r,i=r;for(t=0;t<4;t+=1)n=(n+s[2][t])*r,i=(i+u[2][t])*r;var a=r*(n+s[2][4])/(i+u[2][4]);a=(.5641895835477563-a)/e,r=parseInt(16*e)/16;var o=(e-r)*(e+r);return Math.exp(-r*r)*Math.exp(-o)*a}(t))},BigNumber:function(e){return new t.BigNumber(i(e.toNumber()))},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"erf\\left(${args[0]}\\right)"},i}},function(e,t,r){e.exports=[r(190)]},function(e,t,f){var l=f(2).flatten;t.name="setUnion",t.factory=function(e,t,r,n){var i=r(f(27)),a=r(f(68)),o=r(f(24)),s=r(f(22)),u=r(f(95)),c=r(f(94));return n("setUnion",{"Array | Matrix, Array | Matrix":function(e,t){if(0===s(o(e),new i(0)))return l(t);if(0===s(o(t),new i(0)))return l(e);var r=l(e),n=l(t);return a(c(r,n),u(r,n))}})}},function(e,t,i){var o=i(2).flatten;t.name="setSize",t.factory=function(e,t,r,n){var a=r(i(26));return n("setSize",{"Array | Matrix":function(e){return Array.isArray(e)?o(e).length:o(e.toArray()).length},"Array | Matrix, boolean":function(e,t){if(!1===t||0===e.length)return Array.isArray(e)?o(e).length:o(e.toArray()).length;for(var r=o(Array.isArray(e)?e:e.toArray()).sort(a),n=1,i=1;i<r.length;i++)0!==a(r[i],r[i-1])&&n++;return n}})}},function(e,t,c){var f=c(2).flatten;t.name="setPowerset",t.factory=function(e,t,r,n){var i=r(c(27)),a=r(c(24)),o=r(c(22)),s=r(c(26));return n("setPowerset",{"Array | Matrix":function(e){if(0===o(a(e),new i(0)))return[];for(var t=f(Array.isArray(e)?e:e.toArray()).sort(s),r=[],n=0;n.toString(2).length<=t.length;)r.push(u(t,n.toString(2).split("").reverse())),n++;return function(e){for(var t=[],r=e.length-1;0<r;r--)for(var n=0;n<r;n++)e[n].length>e[n+1].length&&(t=e[n],e[n]=e[n+1],e[n+1]=t);return e}(r)}});function u(e,t){for(var r=[],n=0;n<t.length;n++)"1"===t[n]&&r.push(e[n]);return r}}},function(e,t,i){var c=i(2).flatten;t.name="setMultiplicity",t.factory=function(e,t,r,n){var a=r(i(26)),o=r(i(27)),s=r(i(24)),u=r(i(22));return n("setMultiplicity",{"number | BigNumber | Fraction | Complex, Array | Matrix":function(e,t){if(0===u(s(t),new o(0)))return 0;for(var r=c(Array.isArray(t)?t:t.toArray()),n=0,i=0;i<r.length;i++)0===a(r[i],e)&&n++;return n}})}},function(e,t,i){var l=i(2).flatten,p=i(2).identify;t.name="setIsSubset",t.factory=function(e,t,r,n){var s=r(i(27)),u=r(i(24)),c=r(i(22)),f=r(i(26));return n("setIsSubset",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new s(0)))return!0;if(0===c(u(t),new s(0)))return!1;for(var r,n=p(l(Array.isArray(e)?e:e.toArray()).sort(f)),i=p(l(Array.isArray(t)?t:t.toArray()).sort(f)),a=0;a<n.length;a++){r=!1;for(var o=0;o<i.length;o++)if(0===f(n[a].value,i[o].value)&&n[a].identifier===i[o].identifier){r=!0;break}if(!1===r)return!1}return!0}})}},function(e,t,c){var f=c(2).flatten;t.name="setDistinct",t.factory=function(e,t,r,n){var i=r(c(27)),a=r(c(52)),o=r(c(24)),s=r(c(22)),u=r(c(26));return n("setDistinct",{"Array | Matrix":function(e){if(0===s(o(e),new i(0)))var t=[];else{var r=f(Array.isArray(e)?e:e.toArray()).sort(u);(t=[]).push(r[0]);for(var n=1;n<r.length;n++)0!==u(r[n],r[n-1])&&t.push(r[n])}return Array.isArray(e)?t:new a(t)}})}},function(e,t,i){var p=i(2).flatten;t.name="setCartesian",t.factory=function(e,t,r,n){var s=r(i(27)),u=r(i(52)),c=r(i(24)),f=r(i(22)),l=r(i(26));return n("setCartesian",{"Array | Matrix, Array | Matrix":function(e,t){if(0===f(c(e),new s(0))||0===f(c(t),new s(0)))var r=[];else for(var n=p(Array.isArray(e)?e:e.toArray()).sort(l),i=p(Array.isArray(t)?t:t.toArray()).sort(l),a=(r=[],0);a<n.length;a++)for(var o=0;o<i.length;o++)r.push([n[a],i[o]]);return Array.isArray(e)&&Array.isArray(t)?r:new u(r)}})}},function(e,t,r){e.exports=[r(198),r(96),r(197),r(95),r(196),r(195),r(194),r(193),r(94),r(192)]},function(e,t,p){var m=p(3).nearlyEqual,h=p(44);t.name="smallerEq",t.factory=function(e,r,t,n){var i=t(p(1)),a=t(p(19)),o=t(p(28)),s=t(p(18)),u=t(p(7)),c=t(p(6)),f=p(4),l=n("smallerEq",{"boolean, boolean":function(e,t){return e<=t},"number, number":function(e,t){return e<=t||m(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.lte(t)||h(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return 1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return l(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,l)},"Array, Array":function(e,t){return l(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return l(i(e),t)},"Matrix, Array":function(e,t){return l(e,i(t))},"SparseMatrix, any":function(e,t){return s(e,t,l,!1)},"DenseMatrix, any":function(e,t){return c(e,t,l,!1)},"any, SparseMatrix":function(e,t){return s(t,e,l,!0)},"any, DenseMatrix":function(e,t){return c(t,e,l,!0)},"Array, any":function(e,t){return c(i(e),t,l,!1).valueOf()},"any, Array":function(e,t){return c(i(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+f.operators.smallerEq+"${args[1]}\\right)"},l}},function(e,t,o){t.name="deepEqual",t.factory=function(e,t,r,n){var a=r(o(50)),i=n("deepEqual",{"any, any":function(e,t){return function e(t,r){if(Array.isArray(t)){if(Array.isArray(r)){var n=t.length;if(n!==r.length)return!1;for(var i=0;i<n;i++)if(!e(t[i],r[i]))return!1;return!0}return!1}return!Array.isArray(r)&&a(t,r)}(e.valueOf(),t.valueOf())}});return i.toTex=void 0,i}},function(e,t,r){e.exports=[r(45),r(26),r(201),r(50),r(33),r(109),r(42),r(200),r(114)]},function(e,t,a){t.name="randomInt",t.factory=function(e,t,r,n){var i=r(a(73))("uniform").randomInt;return i.toTex=void 0,i}},function(e,t,a){t.name="random",t.factory=function(e,t,r,n){var i=r(a(73))("uniform").random;return i.toTex=void 0,i}},function(e,t){var r;r=function(){return this}();try{r=r||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(r=window)}e.exports=r},function(p,e,t){(function(e){var i=[],a=void 0===e?window:e,o=Math.pow(256,6),s=Math.pow(2,52),u=2*s,t=Math.random;function c(e){var t,r=e.length,o=this,n=0,i=o.i=o.j=0,a=o.S=[];for(r||(e=[r++]);n<256;)a[n]=n++;for(n=0;n<256;n++)a[n]=a[i=255&i+e[n%r]+(t=a[n])],a[i]=t;(o.g=function(e){for(var t,r=0,n=o.i,i=o.j,a=o.S;e--;)t=a[n=255&n+1],r=256*r+a[255&(a[n]=a[i=255&i+t])+(a[i]=t)];return o.i=n,o.j=i,r})(256)}function f(e,t){for(var r,n=e+"",i=0;i<n.length;)t[255&i]=255&(r^=19*t[255&i])+n.charCodeAt(i++);return l(t)}function l(e){return String.fromCharCode.apply(0,e)}p.exports=function(e,t){if(t&&!0===t.global)return t.global=!1,Math.random=p.exports(e,t),t.global=!0,Math.random;var r=[],n=(f(function e(t,r){var n,i=[],a=(typeof t)[0];if(r&&"o"==a)for(n in t)try{i.push(e(t[n],r-1))}catch(e){}return i.length?i:"s"==a?t:t+"\0"}(t&&t.entropy||!1?[e,l(i)]:0 in arguments?e:function(e){try{return a.crypto.getRandomValues(e=new Uint8Array(256)),l(e)}catch(e){return[+new Date,a,a.navigator&&a.navigator.plugins,a.screen,l(i)]}}(),3),r),new c(r));return f(l(n.S),i),function(){for(var e=n.g(6),t=o,r=0;e<s;)e=256*(e+r),t*=256,r=n.g(1);for(;u<=e;)e/=2,t/=2,r>>>=1;return(e+r)/t}},p.exports.resetGlobal=function(){Math.random=t},f(Math.random(),i)}).call(this,t(205))},function(e,t,r){var s=r(206),u=s();t.factory=function(e,t,r,n,i){var a;function o(e){a=null===e?u:s(String(e))}return o(t.randomSeed),i.on("config",function(e,t,r){void 0!==r.randomSeed&&o(e.randomSeed)}),function(){return a()}},t.math=!0},function(e,t,a){t.name="pickRandom",t.factory=function(e,t,r,n){var i=r(a(73))("uniform").pickRandom;return i.toTex=void 0,i}},function(e,t,a){var o=a(3).isInteger;function s(e){return e.isInteger()&&e.gte(0)}t.name="permutations",t.factory=function(i,e,t,r){var n=r("permutations",{"number | BigNumber":t(a(63)),"number, number":function(e,t){var r,n;if(!o(e)||e<0)throw new TypeError("Positive integer value expected in function permutations");if(!o(t)||t<0)throw new TypeError("Positive integer value expected in function permutations");if(e<t)throw new TypeError("second argument k must be less than or equal to first argument n");for(n=e-t+(r=1);n<=e;n++)r*=n;return r},"BigNumber, BigNumber":function(e,t){var r,n;if(!s(e)||!s(t))throw new TypeError("Positive integer value expected in function permutations");if(t.gt(e))throw new TypeError("second argument k must be less than or equal to first argument n");for(r=new i.BigNumber(1),n=e.minus(t).plus(1);n.lte(e);n=n.plus(1))r=r.times(n);return r}});return n.toTex=void 0,n}},function(e,t,f){var l=f(37);t.name="multinomial",t.factory=function(e,t,r,n){var i=r(f(13)),a=r(f(8)),o=r(f(30)),s=r(f(63)),u=r(f(46)),c=r(f(55));return n("multinomial",{"Array | Matrix":function(e){var t=0,r=1;return l(e,function(e){if(!u(e)||!c(e))throw new TypeError("Positive integer value expected in function multinomial");t=i(t,e),r=a(r,s(e))}),o(s(t),r)}})}},function(e,t,o){t.name="kldivergence",t.factory=function(e,t,r,n){var i=r(o(1)),s=r(o(30)),u=r(o(97)),c=r(o(8)),f=r(o(104)),l=r(o(78)),p=r(o(60));function a(e,t){var r=t.size().length,n=e.size().length;if(1<r)throw new Error("first object must be one dimensional");if(1<n)throw new Error("second object must be one dimensional");if(r!==n)throw new Error("Length of two vectors must be equal");if(0===u(e))throw new Error("Sum of elements in first object must be non zero");if(0===u(t))throw new Error("Sum of elements in second object must be non zero");var i=s(e,u(e)),a=s(t,u(t)),o=u(c(i,l(f(i,a))));return p(o)?o:Number.NaN}return n("kldivergence",{"Array, Array":function(e,t){return a(i(e),i(t))},"Matrix, Array":function(e,t){return a(e,i(t))},"Array, Matrix":function(e,t){return a(i(e),t)},"Matrix, Matrix":function(e,t){return a(e,t)}})}},function(e,t,r){e.exports=[r(62),r(63),r(100),r(211),r(210),r(209),r(208),r(204),r(203)]},function(e,t,o){var s=o(5),u=o(2);t.name="squeeze",t.factory=function(e,t,r,n){var i=r(o(1)),a=n("squeeze",{Array:function(e){return u.squeeze(s.clone(e))},Matrix:function(e){var t=u.squeeze(e.toArray());return Array.isArray(t)?i(t):t},any:function(e){return s.clone(e)}});return a.toTex=void 0,a}},function(e,t,g){var v=g(2),y=g(4),x=g(9);t.name="sqrtm",t.factory=function(r,e,t,n){t(g(1));var o=t(g(23)),s=t(g(13)),u=(t(g(30)),t(g(8))),i=t(g(36)),c=t(g(16)),f=t(g(66)),l=t(g(24)),p=t(g(84)),m=t(g(51)),a=n("sqrtm",{"Array | Matrix":function(e){var t=r.isMatrix(e)?e.size():v.size(e);switch(t.length){case 1:if(1==t[0])return i(e);throw new RangeError("Matrix must be square (size: "+x.format(t)+")");case 2:if(t[0]==t[1])return function(e){var t,r=0,n=e,i=m(l(e));do{var a=n;if(n=u(.5,s(a,f(i))),i=u(.5,s(i,f(a))),t=p(o(c(n,a))),d<t&&++r>h)throw new Error("computing square root of matrix: iterative method could not converge")}while(d<t);return n}(e);throw new RangeError("Matrix must be square (size: "+x.format(t)+")")}}}),h=1e3,d=1e-6;return a.toTex={1:"{${args[0]}}"+y.operators.pow+"{\\frac{1}{2}}"},a}},function(e,t){e.exports=function t(e,r){var n,i,a=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,o=/(^[ ]*|[ ]*$)/g,s=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,u=/^0x[0-9a-f]+$/i,c=/^0/,f=function(e){return t.insensitive&&(""+e).toLowerCase()||""+e},l=f(e).replace(o,"")||"",p=f(r).replace(o,"")||"",m=l.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),h=p.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),d=parseInt(l.match(u),16)||1!==m.length&&l.match(s)&&Date.parse(l),g=parseInt(p.match(u),16)||d&&p.match(s)&&Date.parse(p)||null;if(g){if(d<g)return-1;if(g<d)return 1}for(var v=0,y=Math.max(m.length,h.length);v<y;v++){if(n=!(m[v]||"").match(c)&&parseFloat(m[v])||m[v]||0,i=!(h[v]||"").match(c)&&parseFloat(h[v])||h[v]||0,isNaN(n)!==isNaN(i))return isNaN(n)?1:-1;if(typeof n!=typeof i&&(n+="",i+=""),n<i)return-1;if(i<n)return 1}return 0}},function(e,t,p){var m=p(2).size;t.name="sort",t.factory=function(e,t,r,n){var i=r(p(1)),a=r(p(45)),o=function(e,t){return-a(e,t)},s=r(p(26)),u=n("sort",{Array:function(e){return f(e),e.sort(a)},Matrix:function(e){return l(e),i(e.toArray().sort(a),e.storage())},"Array, function":function(e,t){return f(e),e.sort(t)},"Matrix, function":function(e,t){return l(e),i(e.toArray().sort(t),e.storage())},"Array, string":function(e,t){return f(e),e.sort(c(t))},"Matrix, string":function(e,t){return l(e),i(e.toArray().sort(c(t)),e.storage())}});function c(e){if("asc"===e)return a;if("desc"===e)return o;if("natural"===e)return s;throw new Error('String "asc", "desc", or "natural" expected')}function f(e){if(1!==m(e).length)throw new Error("One dimensional array expected")}function l(e){if(1!==e.size().length)throw new Error("One dimensional matrix expected")}return u.toTex=void 0,u}},function(e,t,n){var u=n(11),c=n(53),f=n(3).isInteger,l=n(9).format,p=n(5).clone,m=n(2);t.name="resize",t.factory=function(a,o,e,t){var s=e(n(1)),r=function(e,t,r){if(2!=arguments.length&&3!=arguments.length)throw new c("resize",arguments.length,2,3);if(a.isMatrix(t)&&(t=t.valueOf()),a.isBigNumber(t[0])&&(t=t.map(function(e){return a.isBigNumber(e)?e.toNumber():e})),a.isMatrix(e))return e.resize(t,r,!0);if("string"==typeof e)return function(e,t,r){if(void 0!==r){if("string"!=typeof r||1!==r.length)throw new TypeError("Single character expected as defaultValue")}else r=" ";if(1!==t.length)throw new u(t.length,1);var n=t[0];if("number"!=typeof n||!f(n))throw new TypeError("Invalid size, must contain positive integers (size: "+l(t)+")");if(e.length>n)return e.substring(0,n);if(e.length<n){for(var i=e,a=0,o=n-e.length;a<o;a++)i+=r;return i}return e}(e,t,r);var n=!Array.isArray(e)&&"Array"!==o.matrix;if(0==t.length){for(;Array.isArray(e);)e=e[0];return p(e)}Array.isArray(e)||(e=[e]),e=p(e);var i=m.resize(e,t,r);return n?s(i):i};return r.toTex=void 0,r}},function(e,t,o){o(11);var s=o(3).isInteger,u=o(2);t.name="reshape",t.factory=function(e,t,r,n){var i=r(o(1)),a=n("reshape",{"Matrix, Array":function(e,t){return e.reshape?e.reshape(t):i(u.reshape(e.valueOf(),t))},"Array, Array":function(e,t){return t.forEach(function(e){if(!s(e))throw new TypeError("Invalid size for dimension: "+e)}),u.reshape(e,t)}});return a.toTex=void 0,a}},function(e,t,a){var u=a(3).isInteger,c=a(2).resize;t.name="ones",t.factory=function(o,t,e,r){var s=e(a(1)),n=r("ones",{"":function(){return"Array"===t.matrix?i([]):i([],"default")},"...number | BigNumber | string":function(e){return"string"==typeof e[e.length-1]?i(e,e.pop()):"Array"===t.matrix?i(e):i(e,"default")},Array:i,Matrix:function(e){var t=e.storage();return i(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return i(e.valueOf(),t)}});return n.toTex=void 0,n;function i(e,t){var n,r=(n=!1,e.forEach(function(e,t,r){o.isBigNumber(e)&&(n=!0,r[t]=e.toNumber())}),n?new o.BigNumber(1):1);if(e.forEach(function(e){if("number"!=typeof e||!u(e)||e<0)throw new Error("Parameters in function ones must be positive integers")}),t){var i=s(t);return 0<e.length?i.resize(e,r):i}var a=[];return 0<e.length?c(a,e,r):a}}},function(e,t,s){var u=s(2).size;t.name="kron",t.factory=function(e,t,r,n){var i=r(s(1)),a=r(s(21));return n("kron",{"Matrix, Matrix":function(e,t){return i(o(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return i(o(e.toArray(),t))},"Array, Matrix":function(e,t){return i(o(e,t.toArray()))},"Array, Array":o});function o(e,r){if(1===u(e).length&&(e=[e]),1===u(r).length&&(r=[r]),2<u(e).length||2<u(r).length)throw new RangeError("Vectors with dimensions greater then 2 are not supported expected (Size x = "+JSON.stringify(e.length)+", y = "+JSON.stringify(r.length)+")");var n=[],i=[];return e.map(function(t){return r.map(function(e){return t.map(function(t){return e.map(function(e){return i.push(a(t,e))})},n.push(i=[]))})},n=[])&&n}}},function(e,t,r){var o=r(35).maxArgumentCount,s=r(2).forEach;function a(t,n){var i=o(n),a=function(e,r){Array.isArray(e)?s(e,function(e,t){a(e,r.concat(t))}):1===i?n(e):2===i?n(e,r):n(e,r,t)};a(t,[])}t.name="forEach",t.factory=function(e,t,r,n){var i=n("forEach",{"Array, function":a,"Matrix, function":function(e,t){return e.forEach(t)}});return i.toTex=void 0,i}},function(e,t,o){var s=o(5).clone,u=o(2).flatten;t.name="flatten",t.factory=function(e,t,r,n){var i=r(o(1)),a=n("flatten",{Array:function(e){return u(s(e))},Matrix:function(e){var t=u(s(e.toArray()));return i(t)}});return a.toTex=void 0,a}},function(e,t,o){var r=o(2).filter,s=o(2).filterRegExp,a=o(35).maxArgumentCount;function u(e,n){var i=a(n);return r(e,function(e,t,r){return 1===i?n(e):2===i?n(e,[t]):n(e,[t],r)})}t.name="filter",t.factory=function(e,t,r,n){var i=r(o(1)),a=n("filter",{"Array, function":u,"Matrix, function":function(e,t){return i(u(e.toArray(),t))},"Array, RegExp":s,"Matrix, RegExp":function(e,t){return i(s(e.toArray(),t))}});return a.toTex=void 0,a}},function(e,t,i){var N=i(9).format;t.name="expm",t.factory=function(h,e,t,r){var d=t(i(23)),g=t(i(13)),v=t(i(51)),y=t(i(66)),x=t(i(8)),w=h.SparseMatrix,n=r("expm",{Matrix:function(e){var t=e.size();if(2!==t.length||t[0]!==t[1])throw new RangeError("Matrix must be square (size: "+N(t)+")");for(var r=t[0],n=function(e,t){for(var r=0;r<30;r++)for(var n=0;n<=r;n++){var i=r-n;if(b(e,n,i)<t)return{q:n,j:i}}throw new Error("Could not find acceptable parameters to compute the matrix exponential (try increasing maxSearchSize in expm.js)")}(function(e){for(var t=e.size()[0],r=0,n=0;n<t;n++){for(var i=0,a=0;a<t;a++)i+=d(e.get([n,a]));r=Math.max(i,r)}return r}(e),1e-15),i=n.q,a=n.j,o=x(e,Math.pow(2,-a)),s=v(r),u=v(r),c=1,f=o,l=-1,p=1;p<=i;p++)1<p&&(f=x(f,o),l=-l),s=g(s,x(c=c*(i-p+1)/((2*i-p+1)*p),f)),u=g(u,x(c*l,f));var m=x(y(u),s);for(p=0;p<a;p++)m=x(m,m);return h.isSparseMatrix(e)?new w(m):m}});function b(e,t,r){for(var n=1,i=2;i<=t;i++)n*=i;var a=n;for(i=t+1;i<=2*t;i++)a*=i;var o=a*(2*t+1);return 8*Math.pow(e/Math.pow(2,r),2*t)*n*n/(a*o)}return n.toTex={1:"\\exp\\left(${args[0]}\\right)"},n}},function(e,t,o){var c=o(2).size;t.name="dot",t.factory=function(e,t,r,n){var s=r(o(13)),u=r(o(8)),i=n("dot",{"Matrix, Matrix":function(e,t){return a(e.toArray(),t.toArray())},"Matrix, Array":function(e,t){return a(e.toArray(),t)},"Array, Matrix":function(e,t){return a(e,t.toArray())},"Array, Array":a});return i.toTex={2:"\\left(${args[0]}\\cdot${args[1]}\\right)"},i;function a(e,t){var r=c(e),n=c(t),i=r[0];if(1!==r.length||1!==n.length)throw new RangeError("Vector expected");if(r[0]!=n[0])throw new RangeError("Vectors must have equal length ("+r[0]+" != "+n[0]+")");if(0==i)throw new RangeError("Cannot calculate the dot product of empty vectors");for(var a=0,o=0;o<i;o++)a=s(a,u(e[o],t[o]));return a}}},function(e,t,a){var o=a(2),h=(a(5).clone,a(3).isInteger);t.name="diag",t.factory=function(p,e,t,r){var m=t(a(1)),n=r("diag",{Array:function(e){return i(e,0,o.size(e),null)},"Array, number":function(e,t){return i(e,t,o.size(e),null)},"Array, BigNumber":function(e,t){return i(e,t.toNumber(),o.size(e),null)},"Array, string":function(e,t){return i(e,0,o.size(e),t)},"Array, number, string":function(e,t,r){return i(e,t,o.size(e),r)},"Array, BigNumber, string":function(e,t,r){return i(e,t.toNumber(),o.size(e),r)},Matrix:function(e){return i(e,0,e.size(),e.storage())},"Matrix, number":function(e,t){return i(e,t,e.size(),e.storage())},"Matrix, BigNumber":function(e,t){return i(e,t.toNumber(),e.size(),e.storage())},"Matrix, string":function(e,t){return i(e,0,e.size(),t)},"Matrix, number, string":function(e,t,r){return i(e,t,e.size(),r)},"Matrix, BigNumber, string":function(e,t,r){return i(e,t.toNumber(),e.size(),r)}});return n.toTex=void 0,n;function i(e,t,r,n){if(!h(t))throw new TypeError("Second parameter in function diag must be an integer");var i,a,o,s,u,c,f=0<t?t:0,l=t<0?-t:0;switch(r.length){case 1:return i=e,a=t,o=n,s=r[0],u=[s+l,s+f],c=p.Matrix.storage(o||"dense").diagonal(u,i,a),null!==o?c:c.valueOf();case 2:return function(e,t,r,n,i,a){if(p.isMatrix(e)){var o=e.diagonal(t);return null!==r?r!==o.storage()?m(o,r):o:o.valueOf()}for(var s=Math.min(n[0]-i,n[1]-a),u=[],c=0;c<s;c++)u[c]=e[c+i][c+a];return null!==r?m(u):u}(e,t,n,r,l,f)}throw new RangeError("Matrix for function diag must be 2 dimensional")}}},function(e,t,c){var f=c(2);t.name="cross",t.factory=function(e,t,r,n){var i=r(c(1)),o=r(c(16)),s=r(c(8)),a=n("cross",{"Matrix, Matrix":function(e,t){return i(u(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return i(u(e.toArray(),t))},"Array, Matrix":function(e,t){return i(u(e,t.toArray()))},"Array, Array":u});return a.toTex={2:"\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)"},a;function u(e,t){var r=Math.max(f.size(e).length,f.size(t).length);e=f.squeeze(e),t=f.squeeze(t);var n=f.size(e),i=f.size(t);if(1!=n.length||1!=i.length||3!=n[0]||3!=i[0])throw new RangeError("Vectors with length 3 expected (Size A = ["+n.join(", ")+"], B = ["+i.join(", ")+"])");var a=[o(s(e[1],t[2]),s(e[2],t[1])),o(s(e[2],t[0]),s(e[0],t[2])),o(s(e[0],t[1]),s(e[1],t[0]))];return 1<r?[a]:a}}},function(e,t,r){e.exports=[r(68),r(227),r(121),r(226),r(225),r(51),r(224),r(223),r(222),r(221),r(66),r(220),r(98),r(219),r(74),r(119),r(218),r(217),r(24),r(216),r(214),r(213),r(22),r(102),r(65),r(40)]},function(e,t,p){t.name="xor",t.factory=function(e,t,r,n){var i=p(4),a=r(p(1)),o=r(p(19)),s=r(p(28)),u=r(p(18)),c=r(p(7)),f=r(p(6)),l=n("xor",{"number, number":function(e,t){return!!e!=!!t},"Complex, Complex":function(e,t){return(0!==e.re||0!==e.im)!=(0!==t.re||0!==t.im)},"BigNumber, BigNumber":function(e,t){return(!e.isZero()&&!e.isNaN())!=(!t.isZero()&&!t.isNaN())},"Unit, Unit":function(e,t){return l(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return l(a(e),t)},"Matrix, Array":function(e,t){return l(e,a(t))},"SparseMatrix, any":function(e,t){return u(e,t,l,!1)},"DenseMatrix, any":function(e,t){return f(e,t,l,!1)},"any, SparseMatrix":function(e,t){return u(t,e,l,!0)},"any, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, any":function(e,t){return f(a(e),t,l,!1).valueOf()},"any, Array":function(e,t){return f(a(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+i.operators.xor+"${args[1]}\\right)"},l}},function(e,t,p){t.name="or",t.factory=function(e,t,r,n){var i=p(4),a=r(p(1)),o=r(p(19)),s=r(p(71)),u=r(p(18)),c=r(p(7)),f=r(p(6)),l=n("or",{"number, number":function(e,t){return!(!e&&!t)},"Complex, Complex":function(e,t){return 0!==e.re||0!==e.im||0!==t.re||0!==t.im},"BigNumber, BigNumber":function(e,t){return!e.isZero()&&!e.isNaN()||!t.isZero()&&!t.isNaN()},"Unit, Unit":function(e,t){return l(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return l(a(e),t)},"Matrix, Array":function(e,t){return l(e,a(t))},"SparseMatrix, any":function(e,t){return u(e,t,l,!1)},"DenseMatrix, any":function(e,t){return f(e,t,l,!1)},"any, SparseMatrix":function(e,t){return u(t,e,l,!0)},"any, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, any":function(e,t){return f(a(e),t,l,!1).valueOf()},"any, Array":function(e,t){return f(a(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+i.operators.or+"${args[1]}\\right)"},l}},function(e,t,h){t.name="and",t.factory=function(e,t,r,n){var i=h(4),a=r(h(1)),o=r(h(40)),s=r(h(99)),u=(r(h(56)),r(h(25))),c=r(h(64)),f=r(h(17)),l=r(h(7)),p=r(h(6)),m=n("and",{"number, number":function(e,t){return!(!e||!t)},"Complex, Complex":function(e,t){return!(0===e.re&&0===e.im||0===t.re&&0===t.im)},"BigNumber, BigNumber":function(e,t){return!(e.isZero()||t.isZero()||e.isNaN()||t.isNaN())},"Unit, Unit":function(e,t){return m(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return c(e,t,m,!1)},"SparseMatrix, DenseMatrix":function(e,t){return u(t,e,m,!0)},"DenseMatrix, SparseMatrix":function(e,t){return u(e,t,m,!1)},"DenseMatrix, DenseMatrix":function(e,t){return l(e,t,m)},"Array, Array":function(e,t){return m(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return m(a(e),t)},"Matrix, Array":function(e,t){return m(e,a(t))},"SparseMatrix, any":function(e,t){return s(t)?o(e.size(),e.storage()):f(e,t,m,!1)},"DenseMatrix, any":function(e,t){return s(t)?o(e.size(),e.storage()):p(e,t,m,!1)},"any, SparseMatrix":function(e,t){return s(e)?o(e.size(),e.storage()):f(t,e,m,!0)},"any, DenseMatrix":function(e,t){return s(e)?o(e.size(),e.storage()):p(t,e,m,!0)},"Array, any":function(e,t){return m(a(e),t).valueOf()},"any, Array":function(e,t){return m(e,a(t)).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+i.operators.and+"${args[1]}\\right)"},m}},function(e,t,r){e.exports=[r(231),r(99),r(230),r(229)]},function(e,t,w){t.name="distance",t.factory=function(t,e,r,n){r(w(1));var l=r(w(20)),p=r(w(16)),m=r(w(21)),h=r(w(12)),s=r(w(32)),d=r(w(36)),u=r(w(23));function i(e){return"number"==typeof e||t.isBigNumber(e)}function c(e){return e.constructor!==Array&&(e=f(e)),i(e[0])&&i(e[1])}function a(e){return e.constructor!==Array&&(e=f(e)),i(e[0])&&i(e[1])&&i(e[2])}function o(e){return e.constructor!==Array&&(e=f(e)),i(e[0])&&i(e[1])&&i(e[2])&&i(e[3])&&i(e[4])&&i(e[5])}function f(e){for(var t=Object.keys(e),r=[],n=0;n<t.length;n++)r.push(e[t[n]]);return r}function g(e,t,r,n,i){var a=u(l(l(m(r,e),m(n,t)),i)),o=d(l(m(r,r),m(n,n)));return h(a,o)}function v(e,t,r,n,i,a,o,s,u){var c=[p(m(p(i,t),u),m(p(a,r),s)),p(m(p(a,r),o),m(p(n,e),u)),p(m(p(n,e),s),m(p(i,t),o))];c=d(l(l(m(c[0],c[0]),m(c[1],c[1])),m(c[2],c[2])));var f=d(l(l(m(o,o),m(s,s)),m(u,u)));return h(c,f)}function y(e,t,r,n){var i=p(n,t),a=p(r,e),o=l(m(i,i),m(a,a));return d(o)}function x(e,t,r,n,i,a){var o=p(a,r),s=p(i,t),u=p(n,e),c=l(l(m(o,o),m(s,s)),m(u,u));return d(c)}return n("distance",{"Array, Array, Array":function(e,t,r){if(2==e.length&&2==t.length&&2==r.length){if(!c(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!c(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!c(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");var n=h(p(r[1],r[0]),p(t[1],t[0])),i=m(m(n,n),t[0]),a=s(m(n,t[0])),o=e[1];return g(e[0],e[1],i,a,o)}throw new TypeError("Invalid Arguments: Try again")},"Object, Object, Object":function(e,t,r){if(2==Object.keys(e).length&&2==Object.keys(t).length&&2==Object.keys(r).length){if(!c(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!c(t))throw new TypeError("Values of lineOnePtX and lineOnePtY should be numbers or BigNumbers");if(!c(r))throw new TypeError("Values of lineTwoPtX and lineTwoPtY should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("lineOnePtX")&&t.hasOwnProperty("lineOnePtY")&&r.hasOwnProperty("lineTwoPtX")&&r.hasOwnProperty("lineTwoPtY")){var n=h(p(r.lineTwoPtY,r.lineTwoPtX),p(t.lineOnePtY,t.lineOnePtX)),i=m(m(n,n),t.lineOnePtX),a=s(m(n,t.lineOnePtX)),o=e.pointX;return g(e.pointX,e.pointY,i,a,o)}throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},"Array, Array":function(e,t){if(2==e.length&&3==t.length){if(!c(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!a(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");return g(e[0],e[1],t[0],t[1],t[2])}if(3==e.length&&6==t.length){if(!a(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!o(t))throw new TypeError("Array with 6 numbers or BigNumbers expected for second argument");return v(e[0],e[1],e[2],t[0],t[1],t[2],t[3],t[4],t[5])}if(2==e.length&&2==t.length){if(!c(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!c(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");return y(e[0],e[1],t[0],t[1])}if(3==e.length&&3==t.length){if(!a(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!a(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");return x(e[0],e[1],e[2],t[0],t[1],t[2])}throw new TypeError("Invalid Arguments: Try again")},"Object, Object":function(e,t){if(2==Object.keys(e).length&&3==Object.keys(t).length){if(!c(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!a(t))throw new TypeError("Values of xCoeffLine, yCoeffLine and constant should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("xCoeffLine")&&t.hasOwnProperty("yCoeffLine")&&t.hasOwnProperty("constant"))return g(e.pointX,e.pointY,t.xCoeffLine,t.yCoeffLine,t.constant);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&6==Object.keys(t).length){if(!a(e))throw new TypeError("Values of pointX, pointY and pointZ should be numbers or BigNumbers");if(!o(t))throw new TypeError("Values of x0, y0, z0, a, b and c should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("x0")&&t.hasOwnProperty("y0")&&t.hasOwnProperty("z0")&&t.hasOwnProperty("a")&&t.hasOwnProperty("b")&&t.hasOwnProperty("c"))return v(e.pointX,e.pointY,e.pointZ,t.x0,t.y0,t.z0,t.a,t.b,t.c);throw new TypeError("Key names do not match")}if(2==Object.keys(e).length&&2==Object.keys(t).length){if(!c(e))throw new TypeError("Values of pointOneX and pointOneY should be numbers or BigNumbers");if(!c(t))throw new TypeError("Values of pointTwoX and pointTwoY should be numbers or BigNumbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY"))return y(e.pointOneX,e.pointOneY,t.pointTwoX,t.pointTwoY);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&3==Object.keys(t).length){if(!a(e))throw new TypeError("Values of pointOneX, pointOneY and pointOneZ should be numbers or BigNumbers");if(!a(t))throw new TypeError("Values of pointTwoX, pointTwoY and pointTwoZ should be numbers or BigNumbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&e.hasOwnProperty("pointOneZ")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY")&&t.hasOwnProperty("pointTwoZ"))return x(e.pointOneX,e.pointOneY,e.pointOneZ,t.pointTwoX,t.pointTwoY,t.pointTwoZ);throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},Array:function(e){if(!function(e){if(2==e[0].length&&i(e[0][0])&&i(e[0][1])){for(var t in e)if(2!=e[t].length||!i(e[t][0])||!i(e[t][1]))return!1}else{if(!(3==e[0].length&&i(e[0][0])&&i(e[0][1])&&i(e[0][2])))return!1;for(var t in e)if(3!=e[t].length||!i(e[t][0])||!i(e[t][1])||!i(e[t][2]))return!1}return!0}(e))throw new TypeError("Incorrect array format entered for pairwise distance calculation");return function(e){for(var t=[],r=0;r<e.length-1;r++)for(var n=r+1;n<e.length;n++)2==e[0].length?t.push(y(e[r][0],e[r][1],e[n][0],e[n][1])):3==e[0].length&&t.push(x(e[r][0],e[r][1],e[r][2],e[n][0],e[n][1],e[n][2]));return t}(e)}})}},function(e,t,n){t.name="intersect",t.factory=function(t,T,e,r){var C=e(n(23)),z=e(n(13)),B=e(n(20)),i=e(n(1)),I=e(n(8)),P=e(n(21)),R=e(n(12)),U=e(n(16)),k=e(n(42)),q=e(n(10)),a=r("intersect",{"Array, Array, Array":function(e,t,r){if(!L(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!L(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!(4===(n=r).length&&E(n[0])&&E(n[1])&&E(n[2])&&E(n[3])))throw new TypeError("Array with 4 numbers expected as third argument");var n,i,a,o,s,u,c,f,l,p,m,h,d,g,v,y,x,w,b,N,M;return i=e[0],a=e[1],o=e[2],s=t[0],u=t[1],c=t[2],f=r[0],l=r[1],p=r[2],m=r[3],h=P(i,f),d=P(s,f),g=P(a,l),v=P(u,l),y=P(o,p),x=P(c,p),w=R(U(U(U(m,h),g),y),U(U(U(B(B(d,v),x),h),g),y)),b=B(i,P(w,U(s,i))),N=B(a,P(w,U(u,a))),M=B(o,P(w,U(c,o))),[b,N,M]},"Array, Array, Array, Array":function(e,t,r,n){if(2===e.length){if(!D(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!D(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!D(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");if(!D(n))throw new TypeError("Array with 2 numbers or BigNumbers expected for fourth argument");return function(e,t,r,n){var i=e,a=r,o=U(i,t),s=U(a,n),u=U(P(o[0],s[1]),P(s[0],o[1]));if(k(C(u),T.epsilon))return null;var c=P(s[0],i[1]),f=P(s[1],i[0]),l=P(s[0],a[1]),p=P(s[1],a[0]),m=R(B(U(U(c,f),l),p),u);return z(I(o,m),i)}(e,t,r,n)}if(3===e.length){if(!L(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!L(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!L(r))throw new TypeError("Array with 3 numbers or BigNumbers expected for third argument");if(!L(n))throw new TypeError("Array with 3 numbers or BigNumbers expected for fourth argument");return i=e[0],a=e[1],o=e[2],s=t[0],u=t[1],c=t[2],f=r[0],l=r[1],p=r[2],m=n[0],h=n[1],d=n[2],g=F(i,f,m,f,a,l,h,l,o,p,d,p),v=F(m,f,s,i,h,l,u,a,d,p,c,o),y=F(i,f,s,i,a,l,u,a,o,p,c,o),x=F(m,f,m,f,h,l,h,l,d,p,d,p),w=F(s,i,s,i,u,a,u,a,c,o,c,o),b=R(U(P(g,v),P(y,x)),U(P(w,x),P(v,v))),N=R(B(g,P(b,v)),x),M=B(i,P(b,U(s,i))),E=B(a,P(b,U(u,a))),A=B(o,P(b,U(c,o))),O=B(f,P(N,U(m,f))),S=B(l,P(N,U(h,l))),_=B(p,P(N,U(d,p))),q(M,O)&&q(E,S)&&q(A,_)?[M,E,A]:null}throw new TypeError("Arrays with two or thee dimensional points expected");var i,a,o,s,u,c,f,l,p,m,h,d,g,v,y,x,w,b,N,M,E,A,O,S,_},"Matrix, Matrix, Matrix":function(e,t,r){return i(a(e.valueOf(),t.valueOf(),r.valueOf()))},"Matrix, Matrix, Matrix, Matrix":function(e,t,r,n){return i(a(e.valueOf(),t.valueOf(),r.valueOf(),n.valueOf()))}});function E(e){return"number"==typeof e||t.isBigNumber(e)}function D(e){return 2===e.length&&E(e[0])&&E(e[1])}function L(e){return 3===e.length&&E(e[0])&&E(e[1])&&E(e[2])}function F(e,t,r,n,i,a,o,s,u,c,f,l){var p=P(U(e,t),U(r,n)),m=P(U(i,a),U(o,s)),h=P(U(u,c),U(f,l));return B(B(p,m),h)}return a}},function(e,t,r){e.exports=[r(234),r(233)]},function(e,t,r){var a=r(0);t.name="re",t.factory=function(e,t,r,n){var i=n("re",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.re},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\Re\\left\\lbrace${args[0]}\\right\\rbrace"},i}},function(e,t,r){var a=r(0);t.name="im",t.factory=function(t,e,r,n){var i=n("im",{number:function(e){return 0},BigNumber:function(e){return new t.BigNumber(0)},Complex:function(e){return e.im},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\Im\\left\\lbrace${args[0]}\\right\\rbrace"},i}},function(e,t,r){var a=r(0);t.name="arg",t.factory=function(t,e,r,n){var i=n("arg",{number:function(e){return Math.atan2(0,e)},BigNumber:function(e){return t.BigNumber.atan2(0,e)},Complex:function(e){return e.arg()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\arg\\left(${args[0]}\\right)"},i}},function(e,t,r){e.exports=[r(238),r(81),r(237),r(236)]},function(e,t,l){t.name="catalan",t.factory=function(e,t,r,n){var i=r(l(13)),a=r(l(30)),o=r(l(8)),s=r(l(62)),u=r(l(54)),c=r(l(46)),f=n("catalan",{"number | BigNumber":function(e){if(!c(e)||u(e))throw new TypeError("Non-negative integer value expected in function catalan");return a(s(o(e,2),e),i(e,1))}});return f.toTex={1:"\\mathrm{C}_{${args[0]}}"},f}},function(e,t,f){t.name="composition",t.factory=function(e,t,r,n){var i=r(f(62)),a=r(f(20)),o=r(f(55)),s=r(f(46)),u=r(f(33)),c=n("composition",{"number | BigNumber, number | BigNumber":function(e,t){if(!(s(e)&&o(e)&&s(t)&&o(t)))throw new TypeError("Positive integer value expected in function composition");if(u(t,e))throw new TypeError("k must be less than or equal to n in function composition");return i(a(e,-1),a(t,-1))}});return c.toTex=void 0,c}},function(e,t,c){t.name="bellNumbers",t.factory=function(e,t,r,n){var i=r(c(13)),a=r(c(101)),o=r(c(54)),s=r(c(46)),u=n("bellNumbers",{"number | BigNumber":function(e){if(!s(e)||o(e))throw new TypeError("Non-negative integer value expected in function bellNumbers");for(var t=0,r=0;r<=e;r++)t=i(t,a(e,r));return t}});return u.toTex={1:"\\mathrm{B}_{${args[0]}}"},u}},function(e,t,r){e.exports=[r(242),r(241),r(101),r(240)]},function(e,t,g){var v=g(3).isInteger;t.name="rightLogShift",t.factory=function(e,t,r,n){var i=g(4),a=r(g(1)),o=r(g(10)),s=r(g(40)),u=r(g(34)),c=r(g(25)),f=r(g(75)),l=r(g(43)),p=r(g(17)),m=r(g(7)),h=r(g(6)),d=n("rightLogShift",{"number, number":function(e,t){if(!v(e)||!v(t))throw new Error("Integers expected in function rightLogShift");return e>>>t},"SparseMatrix, SparseMatrix":function(e,t){return f(e,t,d,!1)},"SparseMatrix, DenseMatrix":function(e,t){return c(t,e,d,!0)},"DenseMatrix, SparseMatrix":function(e,t){return u(e,t,d,!1)},"DenseMatrix, DenseMatrix":function(e,t){return m(e,t,d)},"Array, Array":function(e,t){return d(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return d(a(e),t)},"Matrix, Array":function(e,t){return d(e,a(t))},"SparseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():p(e,t,d,!1)},"DenseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():h(e,t,d,!1)},"number | BigNumber, SparseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):l(t,e,d,!0)},"number | BigNumber, DenseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):h(t,e,d,!0)},"Array, number | BigNumber":function(e,t){return d(a(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return d(e,a(t)).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+i.operators.rightLogShift+"${args[1]}\\right)"},d}},function(e,t,r){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function rightArithShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:t.isFinite()?t.lt(55)?e.div(Math.pow(2,t.toNumber())+"").floor():e.div(new r(2).pow(t)).floor():e.isNegative()?new r(-1):e.isFinite()?new r(0):new r(NaN)}},function(e,t,g){var v=g(3).isInteger,y=g(245);t.name="rightArithShift",t.factory=function(e,t,r,n){var i=g(4),a=r(g(1)),o=r(g(10)),s=r(g(40)),u=r(g(34)),c=r(g(25)),f=r(g(75)),l=r(g(43)),p=r(g(17)),m=r(g(7)),h=r(g(6)),d=n("rightArithShift",{"number, number":function(e,t){if(!v(e)||!v(t))throw new Error("Integers expected in function rightArithShift");return e>>t},"BigNumber, BigNumber":y,"SparseMatrix, SparseMatrix":function(e,t){return f(e,t,d,!1)},"SparseMatrix, DenseMatrix":function(e,t){return c(t,e,d,!0)},"DenseMatrix, SparseMatrix":function(e,t){return u(e,t,d,!1)},"DenseMatrix, DenseMatrix":function(e,t){return m(e,t,d)},"Array, Array":function(e,t){return d(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return d(a(e),t)},"Matrix, Array":function(e,t){return d(e,a(t))},"SparseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():p(e,t,d,!1)},"DenseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():h(e,t,d,!1)},"number | BigNumber, SparseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):l(t,e,d,!0)},"number | BigNumber, DenseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):h(t,e,d,!0)},"Array, number | BigNumber":function(e,t){return d(a(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return d(e,a(t)).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+i.operators.rightArithShift+"${args[1]}\\right)"},d}},function(e,t,r){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function leftShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:e.isFinite()||t.isFinite()?t.lt(55)?e.times(Math.pow(2,t.toNumber())+""):e.times(new r(2).pow(t)):new r(NaN)}},function(e,t,g){var v=g(3).isInteger,y=g(247);t.name="leftShift",t.factory=function(e,t,r,n){var i=g(4),a=r(g(1)),o=r(g(10)),s=r(g(40)),u=r(g(34)),c=r(g(25)),f=r(g(75)),l=r(g(43)),p=r(g(17)),m=r(g(7)),h=r(g(6)),d=n("leftShift",{"number, number":function(e,t){if(!v(e)||!v(t))throw new Error("Integers expected in function leftShift");return e<<t},"BigNumber, BigNumber":y,"SparseMatrix, SparseMatrix":function(e,t){return f(e,t,d,!1)},"SparseMatrix, DenseMatrix":function(e,t){return c(t,e,d,!0)},"DenseMatrix, SparseMatrix":function(e,t){return u(e,t,d,!1)},"DenseMatrix, DenseMatrix":function(e,t){return m(e,t,d)},"Array, Array":function(e,t){return d(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return d(a(e),t)},"Matrix, Array":function(e,t){return d(e,a(t))},"SparseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():p(e,t,d,!1)},"DenseMatrix, number | BigNumber":function(e,t){return o(t,0)?e.clone():h(e,t,d,!1)},"number | BigNumber, SparseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):l(t,e,d,!0)},"number | BigNumber, DenseMatrix":function(e,t){return o(e,0)?s(t.size(),t.storage()):h(t,e,d,!0)},"Array, number | BigNumber":function(e,t){return d(a(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return d(e,a(t)).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+i.operators.leftShift+"${args[1]}\\right)"},d}},function(e,t,r){var i=r(77),a=r(76);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitXor");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero())return t;if(t.isZero())return e;if(e.eq(t))return new r(0);var n=new r(-1);return e.eq(n)?a(t):t.eq(n)?a(e):e.isFinite()&&t.isFinite()?i(e,t,function(e,t){return e^t}):e.isFinite()||t.isFinite()?new r(e.isNegative()==t.isNegative()?1/0:-1/0):n}},function(e,t,p){var m=p(3).isInteger,h=p(249);t.name="bitXor",t.factory=function(e,t,r,n){var i=p(4),a=r(p(1)),o=r(p(19)),s=r(p(28)),u=r(p(18)),c=r(p(7)),f=r(p(6)),l=n("bitXor",{"number, number":function(e,t){if(!m(e)||!m(t))throw new Error("Integers expected in function bitXor");return e^t},"BigNumber, BigNumber":h,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return l(a(e),t)},"Matrix, Array":function(e,t){return l(e,a(t))},"SparseMatrix, any":function(e,t){return u(e,t,l,!1)},"DenseMatrix, any":function(e,t){return f(e,t,l,!1)},"any, SparseMatrix":function(e,t){return u(t,e,l,!0)},"any, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, any":function(e,t){return f(a(e),t,l,!1).valueOf()},"any, Array":function(e,t){return f(a(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+i.operators.bitXor+"${args[1]}\\right)"},l}},function(e,t,r){var i=r(77);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitOr");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);var n=new r(-1);return e.isZero()||t.eq(n)||e.eq(t)?t:t.isZero()||e.eq(n)?e:e.isFinite()&&t.isFinite()?i(e,t,function(e,t){return e|t}):!e.isFinite()&&!e.isNegative()&&t.isNegative()||e.isNegative()&&!t.isNegative()&&!t.isFinite()?n:e.isNegative()&&t.isNegative()?e.isFinite()?e:t:e.isFinite()?t:e}},function(e,t,p){var m=p(3).isInteger,h=p(251);t.name="bitOr",t.factory=function(e,t,r,n){var i=p(4),a=r(p(1)),o=r(p(34)),s=r(p(88)),u=r(p(43)),c=r(p(7)),f=r(p(6)),l=n("bitOr",{"number, number":function(e,t){if(!m(e)||!m(t))throw new Error("Integers expected in function bitOr");return e|t},"BigNumber, BigNumber":h,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,l)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return l(a(e),t)},"Matrix, Array":function(e,t){return l(e,a(t))},"SparseMatrix, any":function(e,t){return u(e,t,l,!1)},"DenseMatrix, any":function(e,t){return f(e,t,l,!1)},"any, SparseMatrix":function(e,t){return u(t,e,l,!0)},"any, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, any":function(e,t){return f(a(e),t,l,!1).valueOf()},"any, Array":function(e,t){return f(a(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+i.operators.bitOr+"${args[1]}\\right)"},l}},function(e,t,o){var s=o(0),u=o(76),c=o(3).isInteger;t.name="bitNot",t.factory=function(e,t,r,n){var i=o(4),a=n("bitNot",{number:function(e){if(!c(e))throw new Error("Integer expected in function bitNot");return~e},BigNumber:u,"Array | Matrix":function(e){return s(e,a)}});return a.toTex={1:i.operators.bitNot+"\\left(${args[0]}\\right)"},a}},function(e,t,r){var n=r(77);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitAnd");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero()||t.eq(-1)||e.eq(t))return e;if(t.isZero()||e.eq(-1))return t;if(!e.isFinite()||!t.isFinite()){if(!e.isFinite()&&!t.isFinite())return e.isNegative()==t.isNegative()?e:new r(0);if(!e.isFinite())return t.isNegative()?e:e.isNegative()?new r(0):t;if(!t.isFinite())return e.isNegative()?t:t.isNegative()?new r(0):e}return n(e,t,function(e,t){return e&t})}},function(e,t,p){var m=p(3).isInteger,h=p(254);t.name="bitAnd",t.factory=function(e,t,r,n){var i=p(4),a=r(p(1)),o=r(p(25)),s=r(p(64)),u=r(p(17)),c=r(p(7)),f=r(p(6)),l=n("bitAnd",{"number, number":function(e,t){if(!m(e)||!m(t))throw new Error("Integers expected in function bitAnd");return e&t},"BigNumber, BigNumber":h,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,l,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,l,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return l(a(e),t)},"Matrix, Array":function(e,t){return l(e,a(t))},"SparseMatrix, any":function(e,t){return u(e,t,l,!1)},"DenseMatrix, any":function(e,t){return f(e,t,l,!1)},"any, SparseMatrix":function(e,t){return u(t,e,l,!0)},"any, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, any":function(e,t){return f(a(e),t,l,!1).valueOf()},"any, Array":function(e,t){return f(a(t),e,l,!0).valueOf()}});return l.toTex={2:"\\left(${args[0]}"+i.operators.bitAnd+"${args[1]}\\right)"},l}},function(e,t,r){e.exports=[r(255),r(253),r(252),r(250),r(248),r(246),r(244)]},function(e,t,n){var f=n(3).isInteger;t.name="xgcd",t.factory=function(p,m,e,t){var h=e(n(1)),r=t("xgcd",{"number, number":function(e,t){var r,n,i,a,o=0,s=1,u=1,c=0;if(!f(e)||!f(t))throw new Error("Parameters in function xgcd must be integer numbers");for(;t;)n=Math.floor(e/t),i=e-n*t,o=s-n*(r=o),s=r,u=c-n*(r=u),c=r,e=t,t=i;return a=e<0?[-e,-s,-c]:[e,e?s:0,c],"Array"===m.matrix?a:h(a)},"BigNumber, BigNumber":function(e,t){var r,n,i,a,o=new p.BigNumber(0),s=new p.BigNumber(1),u=o,c=s,f=s,l=o;if(!e.isInt()||!t.isInt())throw new Error("Parameters in function xgcd must be integer numbers");for(;!t.isZero();)n=e.div(t).floor(),i=e.mod(t),r=u,u=c.minus(n.times(u)),c=r,r=f,f=l.minus(n.times(f)),l=r,e=t,t=i;return a=e.lt(o)?[e.neg(),c.neg(),l.neg()]:[e,e.isZero()?0:c,l],"Array"===m.matrix?a:h(a)}});return r.toTex=void 0,r}},function(e,t,o){var s=o(0);t.name="unaryPlus",t.factory=function(t,r,e,n){var i=o(4),a=n("unaryPlus",{number:function(e){return e},Complex:function(e){return e},BigNumber:function(e){return e},Fraction:function(e){return e},Unit:function(e){return e.clone()},"Array | Matrix":function(e){return s(e,a,!0)},"boolean | string":function(e){return"BigNumber"==r.number?new t.BigNumber(+e):+e}});return a.toTex={1:i.operators.unaryPlus+"\\left(${args[0]}\\right)"},a}},function(e,t,r){var a=r(0);t.name="square",t.factory=function(e,t,r,n){var i=n("square",{number:function(e){return e*e},Complex:function(e){return e.mul(e)},BigNumber:function(e){return e.times(e)},Fraction:function(e){return e.mul(e)},"Array | Matrix":function(e){return a(e,i,!0)},Unit:function(e){return e.pow(2)}});return i.toTex={1:"\\left(${args[0]}\\right)^2"},i}},function(e,t,m){function h(e,t){var r=t<0;if(r&&(t=-t),0===t)throw new Error("Root must be non-zero");if(e<0&&Math.abs(t)%2!=1)throw new Error("Root must be odd when a is negative.");if(0==e)return r?1/0:0;if(!isFinite(e))return r?0:e;var n=Math.pow(Math.abs(e),1/t);return n=e<0?-n:n,r?1/n:n}function d(e,t){if(t<0)throw new Error("Root must be greater than zero");if(0===t)throw new Error("Root must be non-zero");if(t%1!=0)throw new Error("Root must be an integer");for(var r=e.arg(),n=e.abs(),i=[],a=Math.pow(n,1/t),o=0;o<t;o++)i.push({r:a,phi:(r+2*Math.PI*o)/t});return i}t.name="nthRoot",t.factory=function(u,e,t,r){var n=t(m(1)),i=t(m(34)),a=t(m(25)),o=t(m(64)),s=t(m(17)),c=t(m(7)),f=t(m(6)),l=r("nthRoot",{number:function(e){return h(e,2)},"number, number":h,BigNumber:function(e){return p(e,new u.BigNumber(2))},Complex:function(e){return d(e,2)},"Complex, number":d,"BigNumber, BigNumber":p,"Array | Matrix":function(e){return l(e,2)},"SparseMatrix, SparseMatrix":function(e,t){if(1===t.density())return o(e,t,l);throw new Error("Root must be non-zero")},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,l,!0)},"DenseMatrix, SparseMatrix":function(e,t){if(1===t.density())return i(e,t,l,!1);throw new Error("Root must be non-zero")},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,l)},"Array, Array":function(e,t){return l(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return l(n(e),t)},"Matrix, Array":function(e,t){return l(e,n(t))},"SparseMatrix, number | BigNumber":function(e,t){return s(e,t,l,!1)},"DenseMatrix, number | BigNumber":function(e,t){return f(e,t,l,!1)},"number | BigNumber, SparseMatrix":function(e,t){if(1===t.density())return s(t,e,l,!0);throw new Error("Root must be non-zero")},"number | BigNumber, DenseMatrix":function(e,t){return f(t,e,l,!0)},"Array, number | BigNumber":function(e,t){return l(n(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return l(e,n(t)).valueOf()}});return l.toTex={2:"\\sqrt[${args[1]}]{${args[0]}}"},l;function p(e,t){var r=u.BigNumber.precision,n=u.BigNumber.clone({precision:r+2}),i=new u.BigNumber(0),a=new n(1),o=t.isNegative();if(o&&(t=t.neg()),t.isZero())throw new Error("Root must be non-zero");if(e.isNegative()&&!t.abs().mod(2).equals(1))throw new Error("Root must be odd when a is negative.");if(e.isZero())return o?new n(1/0):0;if(!e.isFinite())return o?i:e;var s=e.abs().pow(a.div(t));return s=e.isNeg()?s.neg():s,new u.BigNumber((o?a.div(s):s).toPrecision(r))}}},function(e,t,o){t.name="norm",t.factory=function(e,t,r,n){var l=r(o(23)),p=r(o(13)),m=r(o(41)),h=r(o(81)),d=r(o(36)),g=r(o(8)),v=r(o(10)),y=r(o(33)),x=r(o(42)),i=r(o(1)),a=(r(o(102)),r(o(65)),n("norm",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},boolean:function(e){return Math.abs(e)},Array:function(e){return w(i(e),2)},Matrix:function(e){return w(e,2)},"number | Complex | BigNumber | boolean, number | BigNumber | string":function(e){return a(e)},"Array, number | BigNumber | string":function(e,t){return w(i(e),t)},"Matrix, number | BigNumber | string":function(e,t){return w(e,t)}}));function w(e,t){var r=e.size();if(1==r.length){if(t===Number.POSITIVE_INFINITY||"inf"===t){var n=0;return e.forEach(function(e){var t=l(e);y(t,n)&&(n=t)},!0),n}var i;if(t===Number.NEGATIVE_INFINITY||"-inf"===t)return e.forEach(function(e){var t=l(e);i&&!x(t,i)||(i=t)},!0),i||0;if("fro"===t)return w(e,2);if("number"==typeof t&&!isNaN(t)){if(!v(t,0)){var a=0;return e.forEach(function(e){a=p(m(l(e),t),a)},!0),m(a,1/t)}return Number.POSITIVE_INFINITY}throw new Error("Unsupported parameter value")}if(2==r.length){if(1===t){var o=[],s=0;return e.forEach(function(e,t){var r=t[1],n=p(o[r]||0,l(e));y(n,s)&&(s=n),o[r]=n},!0),s}if(t===Number.POSITIVE_INFINITY||"inf"===t){var u=[],c=0;return e.forEach(function(e,t){var r=t[0],n=p(u[r]||0,l(e));y(n,c)&&(c=n),u[r]=n},!0),c}if("fro"===t){var f=0;return e.forEach(function(e,t){f=p(f,g(e,h(e)))}),d(f)}if(2===t)throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");throw new Error("Unsupported parameter value")}}return a.toTex={1:"\\left\\|${args[0]}\\right\\|",2:void 0},a}},function(e,t,h){t.name="mod",t.factory=function(e,t,r,n){var i=r(h(1)),a=h(4),o=r(h(25)),s=r(h(19)),u=r(h(71)),c=r(h(17)),f=r(h(18)),l=r(h(7)),p=r(h(6)),m=n("mod",{"number, number":function(e,t){if(0<t)return e-t*Math.floor(e/t);if(0===t)return e;throw new Error("Cannot calculate mod for a negative divisor")},"BigNumber, BigNumber":function(e,t){return t.isZero()?e:e.mod(t)},"Fraction, Fraction":function(e,t){return e.mod(t)},"SparseMatrix, SparseMatrix":function(e,t){return u(e,t,m,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,m,!0)},"DenseMatrix, SparseMatrix":function(e,t){return s(e,t,m,!1)},"DenseMatrix, DenseMatrix":function(e,t){return l(e,t,m)},"Array, Array":function(e,t){return m(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return m(i(e),t)},"Matrix, Array":function(e,t){return m(e,i(t))},"SparseMatrix, any":function(e,t){return c(e,t,m,!1)},"DenseMatrix, any":function(e,t){return p(e,t,m,!1)},"any, SparseMatrix":function(e,t){return f(t,e,m,!0)},"any, DenseMatrix":function(e,t){return p(t,e,m,!0)},"Array, any":function(e,t){return p(i(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(i(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+a.operators.mod+"${args[1]}\\right)"},m}},function(e,t,r){var o=r(0);t.name="log2",t.factory=function(r,t,e,n){var i=n("log2",{number:function(e){return 0<=e||t.predictable?Math.log2?Math.log2(e):Math.log(e)/Math.LN2:a(new r.Complex(e,0))},Complex:a,BigNumber:function(e){return!e.isNegative()||t.predictable?e.log(2):a(new r.Complex(e.toNumber(),0))},"Array | Matrix":function(e){return o(e,i)}});function a(e){var t=Math.sqrt(e.re*e.re+e.im*e.im);return new r.Complex(Math.log2?Math.log2(t):Math.log(t)/Math.LN2,Math.atan2(e.im,e.re)/Math.LN2)}return i.toTex="\\log_{2}\\left(${args[0]}\\right)",i}},function(e,t,u){var c=u(0);t.name="log1p",t.factory=function(r,n,e,t){var i=e(u(12)),a=e(u(78)),o=t("log1p",{number:function(e){return-1<=e||n.predictable?Math.log1p?Math.log1p(e):Math.log(e+1):s(new r.Complex(e,0))},Complex:s,BigNumber:function(e){var t=e.plus(1);return!t.isNegative()||n.predictable?t.ln():s(new r.Complex(e.toNumber(),0))},"Array | Matrix":function(e){return c(e,o)},"any, any":function(e,t){return i(o(e),a(t))}});function s(e){var t=e.re+1;return new r.Complex(Math.log(Math.sqrt(t*t+e.im*e.im)),Math.atan2(e.im,t))}return o.toTex={1:"\\ln\\left(${args[0]}+1\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}+1\\right)"},o}},function(e,t,r){var a=r(0);var o=Math.log10||function(e){return Math.log(e)/Math.LN10};t.name="log10",t.factory=function(t,r,e,n){var i=n("log10",{number:function(e){return 0<=e||r.predictable?o(e):new t.Complex(e,0).log().div(Math.LN10)},Complex:function(e){return new t.Complex(e).log().div(Math.LN10)},BigNumber:function(e){return!e.isNegative()||r.predictable?e.log():new t.Complex(e.toNumber(),0).log().div(Math.LN10)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\log_{10}\\left(${args[0]}\\right)"},i}},function(e,t,r){e.exports=function(e,t,r,n,i,a,o,s,u,c,f){var l,p,m,h,d=e._values,g=e._index,v=e._ptr,y=o._index;if(n)for(p=v[t],m=v[t+1],l=p;l<m;l++)r[h=g[l]]!==a?(r[h]=a,y.push(h),c?(n[h]=u?s(d[l],f):s(f,d[l]),i[h]=a):n[h]=d[l]):(n[h]=u?s(d[l],n[h]):s(n[h],d[l]),i[h]=a);else for(p=v[t],m=v[t+1],l=p;l<m;l++)r[h=g[l]]!==a?(r[h]=a,y.push(h)):i[h]=a}},function(e,t,l){var i=l(3).isInteger;function p(e,t){if(!i(e)||!i(t))throw new Error("Parameters in function lcm must be integer numbers");if(0==e||0==t)return 0;for(var r,n=e*t;0!=t;)t=e%(r=t),e=r;return Math.abs(n/e)}t.name="lcm",t.factory=function(i,e,t,r){var n=t(l(1)),a=t(l(25)),o=t(l(64)),s=t(l(17)),u=t(l(7)),c=t(l(6)),f=r("lcm",{"number, number":p,"BigNumber, BigNumber":function(e,t){if(!e.isInt()||!t.isInt())throw new Error("Parameters in function lcm must be integer numbers");if(e.isZero()||t.isZero())return new i.BigNumber(0);for(var r=e.times(t);!t.isZero();){var n=t;t=e.mod(n),e=n}return r.div(e).abs()},"Fraction, Fraction":function(e,t){return e.lcm(t)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,f)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,f,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,f,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,f)},"Array, Array":function(e,t){return f(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return f(n(e),t)},"Matrix, Array":function(e,t){return f(e,n(t))},"SparseMatrix, number | BigNumber":function(e,t){return s(e,t,f,!1)},"DenseMatrix, number | BigNumber":function(e,t){return c(e,t,f,!1)},"number | BigNumber, SparseMatrix":function(e,t){return s(t,e,f,!0)},"number | BigNumber, DenseMatrix":function(e,t){return c(t,e,f,!0)},"Array, number | BigNumber":function(e,t){return c(n(e),t,f,!1).valueOf()},"number | BigNumber, Array":function(e,t){return c(n(t),e,f,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=f(e,t),i=0;i<r.length;i++)n=f(n,r[i]);return n}});return f.toTex=void 0,f}},function(e,t,p){var m=p(2).flatten;t.name="hypot",t.factory=function(e,t,r,n){var a=r(p(23)),o=r(p(20)),s=r(p(12)),u=r(p(21)),c=r(p(36)),f=r(p(42)),l=r(p(55)),i=n("hypot",{"... number | BigNumber":function(e){for(var t=0,r=0,n=0;n<e.length;n++){var i=a(e[n]);f(r,i)?(t=u(t,u(s(r,i),s(r,i))),t=o(t,1),r=i):t=o(t,l(i)?u(s(i,r),s(i,r)):i)}return u(r,c(t))},Array:function(e){return i.apply(i,m(e))},Matrix:function(e){return i.apply(i,m(e.toArray()))}});return i.toTex="\\hypot\\left(${args}\\right)",i}},function(e,t,l){var n=l(3).isInteger;function p(e,t){if(!n(e)||!n(t))throw new Error("Parameters in function gcd must be integer numbers");for(var r;0!=t;)r=e%t,e=t,t=r;return e<0?-e:e}t.name="gcd",t.factory=function(i,e,t,r){var n=t(l(1)),a=t(l(34)),o=t(l(88)),s=t(l(43)),u=t(l(7)),c=t(l(6)),f=r("gcd",{"number, number":p,"BigNumber, BigNumber":function(e,t){if(!e.isInt()||!t.isInt())throw new Error("Parameters in function gcd must be integer numbers");for(var r=new i.BigNumber(0);!t.isZero();){var n=e.mod(t);e=t,t=n}return e.lt(r)?e.neg():e},"Fraction, Fraction":function(e,t){return e.gcd(t)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,f)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,f,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,f,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,f)},"Array, Array":function(e,t){return f(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return f(n(e),t)},"Matrix, Array":function(e,t){return f(e,n(t))},"SparseMatrix, number | BigNumber":function(e,t){return s(e,t,f,!1)},"DenseMatrix, number | BigNumber":function(e,t){return c(e,t,f,!1)},"number | BigNumber, SparseMatrix":function(e,t){return s(t,e,f,!0)},"number | BigNumber, DenseMatrix":function(e,t){return c(t,e,f,!0)},"Array, number | BigNumber":function(e,t){return c(n(e),t,f,!1).valueOf()},"number | BigNumber, Array":function(e,t){return c(n(t),e,f,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=f(e,t),i=0;i<r.length;i++)n=f(n,r[i]);return n}});return f.toTex="\\gcd\\left(${args}\\right)",f}},function(e,t,r){var a=r(0);t.name="floor",t.factory=function(e,t,r,n){var i=n("floor",{number:Math.floor,Complex:function(e){return e.floor()},BigNumber:function(e){return e.floor()},Fraction:function(e){return e.floor()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\left\\lfloor${args[0]}\\right\\rfloor"},i}},function(e,t,o){var s=o(0);t.name="expm1",t.factory=function(r,e,t,n){var i=o(4),a=n("expm1",{number:Math.expm1||function(e){return 2e-4<=e||e<=-2e-4?Math.exp(e)-1:e+e*e/2+e*e*e/6},Complex:function(e){var t=Math.exp(e.re);return new r.Complex(t*Math.cos(e.im)-1,t*Math.sin(e.im))},BigNumber:function(e){return e.exp().minus(1)},"Array | Matrix":function(e){return s(e,a)}});return a.toTex="\\left(e"+i.operators.pow+"{${args[0]}}-1\\right)",a}},function(e,t,r){var a=r(0);t.name="exp",t.factory=function(e,t,r,n){var i=n("exp",{number:Math.exp,Complex:function(e){return e.exp()},BigNumber:function(e){return e.exp()},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\exp\\left(${args[0]}\\right)"},i}},function(e,t,h){t.name="dotPow",t.factory=function(e,t,r,n){var i=r(h(1)),a=r(h(41)),o=h(4),s=r(h(19)),u=r(h(28)),c=r(h(17)),f=r(h(18)),l=r(h(7)),p=r(h(6)),m=n("dotPow",{"any, any":a,"SparseMatrix, SparseMatrix":function(e,t){return u(e,t,a,!1)},"SparseMatrix, DenseMatrix":function(e,t){return s(t,e,a,!0)},"DenseMatrix, SparseMatrix":function(e,t){return s(e,t,a,!1)},"DenseMatrix, DenseMatrix":function(e,t){return l(e,t,a)},"Array, Array":function(e,t){return m(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return m(i(e),t)},"Matrix, Array":function(e,t){return m(e,i(t))},"SparseMatrix, any":function(e,t){return c(e,t,m,!1)},"DenseMatrix, any":function(e,t){return p(e,t,m,!1)},"any, SparseMatrix":function(e,t){return f(t,e,m,!0)},"any, DenseMatrix":function(e,t){return p(t,e,m,!0)},"Array, any":function(e,t){return p(i(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(i(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+o.operators.dotPow+"${args[1]}\\right)"},m}},function(e,t,m){t.name="dotMultiply",t.factory=function(e,t,r,n){var i=r(m(1)),a=r(m(21)),o=m(4),s=r(m(25)),u=r(m(103)),c=r(m(17)),f=r(m(7)),l=r(m(6)),p=n("dotMultiply",{"any, any":a,"SparseMatrix, SparseMatrix":function(e,t){return u(e,t,a,!1)},"SparseMatrix, DenseMatrix":function(e,t){return s(t,e,a,!0)},"DenseMatrix, SparseMatrix":function(e,t){return s(e,t,a,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,a)},"Array, Array":function(e,t){return p(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return p(i(e),t)},"Matrix, Array":function(e,t){return p(e,i(t))},"SparseMatrix, any":function(e,t){return c(e,t,a,!1)},"DenseMatrix, any":function(e,t){return l(e,t,a,!1)},"any, SparseMatrix":function(e,t){return c(t,e,a,!0)},"any, DenseMatrix":function(e,t){return l(t,e,a,!0)},"Array, any":function(e,t){return l(i(e),t,a,!1).valueOf()},"any, Array":function(e,t){return l(i(t),e,a,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+o.operators.dotMultiply+"${args[1]}\\right)"},p}},function(e,t,r){var a=r(0);t.name="cube",t.factory=function(e,t,r,n){var i=n("cube",{number:function(e){return e*e*e},Complex:function(e){return e.mul(e).mul(e)},BigNumber:function(e){return e.times(e).times(e)},Fraction:function(e){return e.pow(3)},"Array | Matrix":function(e){return a(e,i,!0)},Unit:function(e){return e.pow(3)}});return i.toTex={1:"\\left(${args[0]}\\right)^3"},i}},function(e,t,r){var a=r(0);t.name="ceil",t.factory=function(e,t,r,n){var i=n("ceil",{number:Math.ceil,Complex:function(e){return e.ceil()},BigNumber:function(e){return e.ceil()},Fraction:function(e){return e.ceil()},"Array | Matrix":function(e){return a(e,i,!0)}});return i.toTex={1:"\\left\\lceil${args[0]}\\right\\rceil"},i}},function(e,t,n){var f=n(0);var l=Math.cbrt||function(e){if(0===e)return e;var t,r=e<0;return r&&(e=-e),t=isFinite(e)?(e/((t=Math.exp(Math.log(e)/3))*t)+2*t)/3:e,r?-t:t};t.name="cbrt",t.factory=function(o,s,e,t){var i=e(n(32)),a=e(n(54)),u=e(n(1)),r=t("cbrt",{number:l,Complex:c,"Complex, boolean":c,BigNumber:function(e){return e.cbrt()},Unit:function(e){if(e.value&&o.isComplex(e.value)){var t=e.clone();return t.value=1,(t=t.pow(1/3)).value=c(e.value),t}var r,n=a(e.value);n&&(e.value=i(e.value)),r=o.isBigNumber(e.value)?new o.BigNumber(1).div(3):o.isFraction(e.value)?new o.Fraction(1,3):1/3;var t=e.pow(r);return n&&(t.value=i(t.value)),t},"Array | Matrix":function(e){return f(e,r,!0)}});function c(e,t){var r=e.arg()/3,n=e.abs(),i=new o.Complex(l(n),0).mul(new o.Complex(0,r).exp());if(t){var a=[i,new o.Complex(l(n),0).mul(new o.Complex(0,r+2*Math.PI/3).exp()),new o.Complex(l(n),0).mul(new o.Complex(0,r-2*Math.PI/3).exp())];return"Array"===s.matrix?a:u(a)}return i}return r.toTex={1:"\\sqrt[3]{${args[0]}}"},r}},function(e,t,r){e.exports=[r(23),r(13),r(20),r(277),r(276),r(275),r(30),r(104),r(274),r(273),r(272),r(271),r(142),r(270),r(269),r(268),r(267),r(78),r(265),r(264),r(263),r(262),r(8),r(261),r(260),r(41),r(141),r(113),r(36),r(259),r(16),r(32),r(258),r(257)]},function(e,t,r){t.name="cs_ipvec",t.path="sparse",t.factory=function(){return function(e,t,r){r=t.length;var n,i=[];if(e)for(n=0;n<r;n++)i[e[n]]=t[n];else for(n=0;n<r;n++)i[n]=t[n];return i}}},function(e,t,h){var d=Array.isArray;t.name="lusolve",t.factory=function(t,e,r,n){var i=r(h(1)),a=r(h(112)),o=r(h(111)),s=r(h(279)),u=r(h(79)),c=r(h(105)),f=r(h(106)),l=n("lusolve",{"Array, Array | Matrix":function(e,t){e=i(e);var r=a(e);return m(r.L,r.U,r.p,null,t).valueOf()},"DenseMatrix, Array | Matrix":function(e,t){var r=a(e);return m(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix":function(e,t){var r=a(e);return m(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix, number, number":function(e,t,r,n){var i=o(e,r,n);return m(i.L,i.U,i.p,i.q,t)},"Object, Array | Matrix":function(e,t){return m(e.L,e.U,e.p,e.q,t)}}),p=function(e){if(t.isMatrix(e))return e;if(d(e))return i(e);throw new TypeError("Invalid Matrix LU decomposition")},m=function(e,t,r,n,i){e=p(e),t=p(t),i=u(e,i,!1),r&&(i._data=s(r,i._data));var a=f(e,i),o=c(t,a);return n&&(o._data=s(n,o._data)),o};return l}},function(e,t,i){t.name="cs_unflip",t.path="sparse",t.factory=function(e,t,r){var n=r(i(80));return function(e){return e<0?n(e):e}}},function(e,t,n){t.name="cs_dfs",t.path="sparse",t.factory=function(e,t,r){var h=r(n(108)),d=r(n(107)),g=r(n(281));return function(e,t,r,n,i){var a,o,s,u=t._index,c=t._ptr,f=t._size[1],l=0;for(n[0]=e;0<=l;){e=n[l];var p=i?i[e]:e;h(c,e)||(d(c,e),n[f+l]=p<0?0:g(c[p]));var m=1;for(o=n[f+l],s=p<0?0:g(c[p+1]);o<s;o++)if(a=u[o],!h(c,a)){n[f+l]=o,n[++l]=a,m=0;break}m&&(l--,n[--r]=e)}return r}}},function(e,t,n){t.name="cs_reach",t.path="sparse",t.factory=function(e,t,r){var d=r(n(282)),g=r(n(108)),v=r(n(107));return function(e,t,r,n,i){var a,o,s,u=e._ptr,c=e._size,f=t._index,l=t._ptr,p=c[1],m=p;for(o=l[r],s=l[r+1],a=o;a<s;a++){var h=f[a];g(u,h)||(m=d(h,e,m,n,i))}for(a=m;a<p;a++)v(u,n[a]);return m}}},function(e,t,n){t.name="cs_spsolve",t.path="sparse",t.factory=function(e,t,r){var M=r(n(12)),E=r(n(8)),A=r(n(16)),O=r(n(283));return function(e,t,r,n,i,a,o){var s,u,c,f,l=e._values,p=e._index,m=e._ptr,h=e._size[1],d=t._values,g=t._index,v=t._ptr,y=O(e,t,r,n,a);for(s=y;s<h;s++)i[n[s]]=0;for(u=v[r],c=v[r+1],s=u;s<c;s++)i[g[s]]=d[s];for(var x=y;x<h;x++){var w=n[x],b=a?a[w]:w;if(!(b<0))for(u=m[b],c=m[b+1],i[w]=M(i[w],l[o?u:c-1]),s=o?u+1:u,f=o?c:c-1;s<f;s++){var N=p[s];i[N]=A(i[N],E(l[s],i[w]))}}return y}}},function(e,t,n){t.name="cs_lu",t.path="sparse",t.factory=function(e,t,r){var S=r(n(23)),_=r(n(12)),T=r(n(8)),C=r(n(33)),z=r(n(109)),B=r(n(284)),I=e.SparseMatrix;return function(e,t,r){if(!e)return null;var n,i=e._size[1],a=100,o=100;t&&(n=t.q,a=t.lnz||a,o=t.unz||o);var s,u,c=[],f=[],l=[],p=new I({values:c,index:f,ptr:l,size:[i,i]}),m=[],h=[],d=[],g=new I({values:m,index:h,ptr:d,size:[i,i]}),v=[],y=[],x=[];for(s=0;s<i;s++)y[s]=0,v[s]=-1,l[s+1]=0;for(var w=o=a=0;w<i;w++){l[w]=a,d[w]=o;var b=n?n[w]:w,N=B(p,e,b,x,y,v,1),M=-1,E=-1;for(u=N;u<i;u++)if(v[s=x[u]]<0){var A=S(y[s]);C(A,E)&&(E=A,M=s)}else h[o]=v[s],m[o++]=y[s];if(-1==M||E<=0)return null;v[b]<0&&z(S(y[b]),T(E,r))&&(M=b);var O=y[M];for(h[o]=w,m[o++]=O,v[M]=w,f[a]=M,c[a++]=1,u=N;u<i;u++)v[s=x[u]]<0&&(f[a]=s,c[a++]=_(y[s],O)),y[s]=0}for(l[i]=a,d[i]=o,u=0;u<a;u++)f[u]=v[f[u]];return c.splice(a,c.length-a),f.splice(a,f.length-a),m.splice(o,m.length-o),h.splice(o,h.length-o),{L:p,U:g,pinv:v}}}},function(e,t,r){t.name="cs_leaf",t.path="sparse",t.factory=function(){return function(e,t,r,n,i,a,o){var s,u,c,f,l=0;if(e<=t||r[n+t]<=r[i+e])return-1;if(r[i+e]=r[n+t],c=r[a+e],r[a+e]=t,-1===c)l=1,f=e;else{for(l=2,f=c;f!=r[o+f];f=r[o+f]);for(s=c;s!=f;s=u)u=r[o+s],r[o+s]=f}return{jleaf:l,q:f}}}},function(e,t,n){t.name="cs_counts",t.path="sparse",t.factory=function(e,t,r){var O=r(n(65)),S=r(n(286));return function(e,t,r,n){if(!e||!t||!r)return null;var i,a,o,s,u,c,f,l=e._size,p=l[0],m=l[1],h=4*m+(n?m+p+1:0),d=[],g=m,v=2*m,y=3*m,x=4*m,w=5*m+1;for(o=0;o<h;o++)d[o]=-1;var b=[],N=O(e),M=N._index,E=N._ptr;for(o=0;o<m;o++)for(b[a=r[o]]=-1==d[y+a]?1:0;-1!=a&&-1==d[y+a];a=t[a])d[y+a]=o;if(n){for(o=0;o<m;o++)d[r[o]]=o;for(i=0;i<p;i++){for(o=m,c=E[i],f=E[i+1],u=c;u<f;u++)o=Math.min(o,d[M[u]]);d[w+i]=d[x+o],d[x+o]=i}}for(i=0;i<m;i++)d[0+i]=i;for(o=0;o<m;o++){for(-1!=t[a=r[o]]&&b[t[a]]--,s=n?d[x+o]:a;-1!=s;s=n?d[w+s]:-1)for(u=E[s];u<E[s+1];u++){i=M[u];var A=S(i,a,d,y,g,v,0);1<=A.jleaf&&b[a]++,2==A.jleaf&&b[A.q]--}-1!=t[a]&&(d[0+a]=t[a])}for(a=0;a<m;a++)-1!=t[a]&&(b[t[a]]+=b[a]);return b}}},function(e,t,n){t.name="cs_post",t.path="sparse",t.factory=function(e,t,r){var u=r(n(110));return function(e,t){if(!e)return null;var r,n=0,i=[],a=[],o=t,s=2*t;for(r=0;r<t;r++)a[0+r]=-1;for(r=t-1;0<=r;r--)-1!=e[r]&&(a[o+r]=a[0+e[r]],a[0+e[r]]=r);for(r=0;r<t;r++)-1==e[r]&&(n=u(r,n,a,0,o,i,s));return i}}},function(e,t,r){t.name="cs_etree",t.path="sparse",t.factory=function(){return function(e,t){if(!e)return null;var r,n,i=e._index,a=e._ptr,o=e._size,s=o[0],u=o[1],c=[],f=[],l=u;if(t)for(r=0;r<s;r++)f[l+r]=-1;for(var p=0;p<u;p++){c[p]=-1,f[0+p]=-1;for(var m=a[p],h=a[p+1],d=m;d<h;d++){var g=i[d];for(r=t?f[l+g]:g;-1!=r&&r<p;r=n)n=f[0+r],f[0+r]=p,-1==n&&(c[r]=p);t&&(f[l+g]=p)}}return c}}},function(e,t,r){t.name="cs_permute",t.path="sparse",t.factory=function(e){var b=e.SparseMatrix;return function(e,t,r,n){for(var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype,c=s[0],f=s[1],l=n&&e._values?[]:null,p=[],m=[],h=0,d=0;d<f;d++){m[d]=h;for(var g=r?r[d]:d,v=o[g],y=o[g+1],x=v;x<y;x++){var w=t?t[a[x]]:a[x];p[h]=w,l&&(l[h]=i[x]),h++}}return m[f]=h,new b({values:l,index:p,ptr:m,size:[c,f],datatype:u})}}},function(e,t,r){t.name="cs_fkeep",t.path="sparse",t.factory=function(){return function(e,t,r){for(var n=e._values,i=e._index,a=e._ptr,o=e._size[1],s=0,u=0;u<o;u++){var c=a[u];for(a[u]=s;c<a[u+1];c++)t(i[c],u,n?n[c]:1,r)&&(i[s]=i[c],n&&(n[s]=n[c]),s++)}return a[o]=s,i.splice(s,i.length-s),n&&n.splice(s,n.length-s),s}}},function(e,t,n){t.name="cs_amd",t.path="sparse",t.factory=function(e,t,r){var K=r(n(80)),ee=r(n(291)),te=r(n(110)),p=r(n(13)),m=r(n(8)),h=r(n(65)),re=function(e,t,r,n,i){var a=h(t);if(1===e&&n===r)return p(t,a);if(2==e){for(var o=a._index,s=a._ptr,u=0,c=0;c<r;c++){var f=s[c];if(s[c]=u,!(s[c+1]-f>i))for(var l=s[c+1];f<l;f++)o[u++]=o[f]}return s[r]=u,t=h(a),m(a,t)}return m(a,t)},ne=function(e,t,r,n,i,a,o,s,u,c,f,l){for(var p=0;p<e;p++)r[n+p]=t[p+1]-t[p];for(var m=r[n+e]=0;m<=e;m++)r[i+m]=-1,a[m]=-1,r[o+m]=-1,r[s+m]=-1,r[u+m]=1,r[c+m]=1,r[f+m]=0,r[l+m]=r[n+m];var h=ae(0,0,r,c,e);return r[f+e]=-2,t[e]=-1,r[c+e]=0,h},ie=function(e,t,r,n,i,a,o,s,u,c,f){for(var l=0,p=0;p<e;p++){var m=r[n+p];if(0===m)r[i+p]=-2,l++,t[p]=-1,r[a+p]=0;else if(o<m)r[s+p]=0,r[i+p]=-1,l++,t[p]=K(e),r[s+e]++;else{var h=r[u+m];-1!=h&&(c[h]=p),r[f+p]=r[u+m],r[u+m]=p}}return l},ae=function(e,t,r,n,i){if(e<2||e+t<0){for(var a=0;a<i;a++)0!==r[n+a]&&(r[n+a]=1);e=2}return e},oe=function(e,t){return e!=t};return function(e,t){if(!t||e<=0||3<e)return null;var r=t._size,n=r[0],i=r[1],a=0,o=Math.max(16,10*Math.sqrt(i));o=Math.min(i-2,o);var s=re(e,t,n,i,o);ee(s,oe,null);for(var u,c,f,l,p,m,h,d,g,v,y,x,w,b,N,M,E=s._index,A=s._ptr,O=A[i],S=[],_=[],T=i+1,C=2*(i+1),z=3*(i+1),B=4*(i+1),I=5*(i+1),P=6*(i+1),R=7*(i+1),U=S,k=ne(i,A,_,0,z,U,C,R,T,P,B,I),q=ie(i,A,_,I,B,P,o,T,z,U,C),D=0;q<i;){for(f=-1;D<i&&-1==(f=_[z+D]);D++);-1!=_[C+f]&&(U[_[C+f]]=-1),_[z+D]=_[C+f];var L=_[B+f],F=_[T+f];q+=F;var j=0;_[T+f]=-F;var $=A[f],H=0===L?$:O,G=H;for(l=1;l<=L+1;l++){for(L<l?(h=$,d=_[0+(m=f)]-L):(h=A[m=E[$++]],d=_[0+m]),p=1;p<=d;p++)(g=_[T+(u=E[h++])])<=0||(j+=g,_[T+u]=-g,-1!=_[C+(E[G++]=u)]&&(U[_[C+u]]=U[u]),-1!=U[u]?_[C+U[u]]=_[C+u]:_[z+_[I+u]]=_[C+u]);m!=f&&(A[m]=K(f),_[P+m]=0)}for(0!==L&&(O=G),_[I+f]=j,A[f]=H,_[0+f]=G-H,_[B+f]=-2,k=ae(k,a,_,P,i),v=H;v<G;v++)if(!((y=_[B+(u=E[v])])<=0)){var Z=k-(g=-_[T+u]);for($=A[u],x=A[u]+y-1;$<=x;$++)_[P+(m=E[$])]>=k?_[P+m]-=g:0!==_[P+m]&&(_[P+m]=_[I+m]+Z)}for(v=H;v<G;v++){for(w=(x=A[u=E[v]])+_[B+u]-1,M=N=0,$=b=x;$<=w;$++)if(0!==_[P+(m=E[$])]){var V=_[P+m]-k;0<V?(M+=V,N+=E[b++]=m):(A[m]=K(f),_[P+m]=0)}_[B+u]=b-x+1;var W=b,J=x+_[0+u];for($=w+1;$<J;$++){var Y=_[T+(c=E[$])];Y<=0||(M+=Y,N+=E[b++]=c)}0===M?(A[u]=K(f),j-=g=-_[T+u],F+=g,q+=g,_[T+u]=0,_[B+u]=-1):(_[I+u]=Math.min(_[I+u],M),E[b]=E[W],E[W]=E[x],E[x]=f,_[0+u]=b-x+1,N=(N<0?-N:N)%i,_[C+u]=_[R+N],U[_[R+N]=u]=N)}for(_[I+f]=j,a=Math.max(a,j),k=ae(k+a,a,_,P,i),v=H;v<G;v++)if(!(0<=_[T+(u=E[v])]))for(u=_[R+(N=U[u])],_[R+N]=-1;-1!=u&&-1!=_[C+u];u=_[C+u],k++){for(d=_[0+u],y=_[B+u],$=A[u]+1;$<=A[u]+d-1;$++)_[P+E[$]]=k;var X=u;for(c=_[C+u];-1!=c;){var Q=_[0+c]===d&&_[B+c]===y;for($=A[c]+1;Q&&$<=A[c]+d-1;$++)_[P+E[$]]!=k&&(Q=0);Q?(A[c]=K(u),_[T+u]+=_[T+c],_[T+c]=0,_[B+c]=-1,c=_[C+c],_[C+X]=c):c=_[C+(X=c)]}}for(v=$=H;v<G;v++)(g=-_[T+(u=E[v])])<=0||(_[T+u]=g,M=_[I+u]+j-g,-1!=_[z+(M=Math.min(M,i-q-g))]&&(U[_[z+M]]=u),_[C+u]=_[z+M],U[u]=-1,_[z+M]=u,D=Math.min(D,M),_[I+u]=M,E[$++]=u);_[T+f]=F,0==(_[0+f]=$-H)&&(A[f]=-1,_[P+f]=0),0!==L&&(O=$)}for(u=0;u<i;u++)A[u]=K(A[u]);for(c=0;c<=i;c++)_[z+c]=-1;for(c=i;0<=c;c--)0<_[T+c]||(_[C+c]=_[z+A[c]],_[z+A[c]]=c);for(m=i;0<=m;m--)_[T+m]<=0||-1!=A[m]&&(_[C+m]=_[z+A[m]],_[z+A[m]]=m);for(u=f=0;u<=i;u++)-1==A[u]&&(f=te(u,f,_,z,C,S,P));return S.splice(S.length-1,1),S}}},function(e,t,n){t.name="cs_sqr",t.path="sparse",t.factory=function(e,t,r){var c=r(n(292)),f=r(n(290)),l=r(n(289)),p=r(n(288)),m=r(n(287)),h=function(e,t){var r=e._ptr,n=e._index,i=e._size,a=i[0],o=i[1];t.pinv=[],t.leftmost=[];var s,u,c,f,l,p=t.parent,m=t.pinv,h=t.leftmost,d=[],g=a,v=a+o,y=a+2*o;for(u=0;u<o;u++)d[g+u]=-1,d[v+u]=-1,d[y+u]=0;for(s=0;s<a;s++)h[s]=-1;for(u=o-1;0<=u;u--)for(f=r[u],l=r[u+1],c=f;c<l;c++)h[n[c]]=u;for(s=a-1;0<=s;s--)(m[s]=-1)!=(u=h[s])&&(0==d[y+u]++&&(d[v+u]=s),d[0+s]=d[g+u],d[g+u]=s);for(t.lnz=0,t.m2=a,u=0;u<o;u++)if(s=d[g+u],t.lnz++,s<0&&(s=t.m2++),!(--y[m[s]=u]<=0)){t.lnz+=d[y+u];var x=p[u];-1!=x&&(0===d[y+x]&&(d[v+x]=d[v+u]),d[0+d[v+u]]=d[g+x],d[g+x]=d[0+s],d[y+x]+=d[y+u])}for(s=0;s<a;s++)m[s]<0&&(m[s]=u++);return!0};return function(e,t,r){var n,i=t._ptr,a=t._size[1],o={};if(o.q=c(e,t),e&&!o.q)return null;if(r){var s=e?f(t,null,o.q,0):t;o.parent=l(s,1);var u=p(o.parent,a);if(o.cp=m(s,o.parent,u,1),s&&o.parent&&o.cp&&h(s,o))for(n=o.unz=0;n<a;n++)o.unz+=o.cp[n]}else o.unz=4*i[a]+a,o.lnz=o.unz;return o}}},function(e,t,u){t.name="qr",t.factory=function(e,t,r,n){var i=r(u(1)),x=r(u(40)),w=r(u(51)),b=(r(u(115)),r(u(56))),N=(r(u(55)),r(u(114))),M=(r(u(23)),r(u(113))),E=r(u(36)),A=r(u(81)),O=r(u(32)),S=r(u(20)),_=r(u(12)),T=r(u(21)),C=r(u(16)),a=n("qr",{DenseMatrix:function(e){return o(e)},SparseMatrix:function(e){return s(e)},Array:function(e){var t=i(e),r=o(t);return{Q:r.Q.valueOf(),R:r.R.valueOf()}}}),o=function(e){var t,r,n,i=e._size[0],a=e._size[1],o=w([i],"dense"),s=o._data,u=e.clone(),c=u._data,f=x([i],"");for(n=0;n<Math.min(a,i);++n){var l=c[n][n],p=O(M(l)),m=A(p),h=0;for(t=n;t<i;t++)h=S(h,T(c[t][n],A(c[t][n])));var d=T(p,E(h));if(!b(d)){var g=C(l,d);for(t=n+(f[n]=1);t<i;t++)f[t]=_(c[t][n],g);var v,y=O(A(_(g,d)));for(r=n;r<a;r++){for(v=0,t=n;t<i;t++)v=S(v,T(A(f[t]),c[t][r]));for(v=T(v,y),t=n;t<i;t++)c[t][r]=T(C(c[t][r],T(f[t],v)),m)}for(t=0;t<i;t++){for(v=0,r=n;r<i;r++)v=S(v,T(s[t][r],f[r]));for(v=T(v,y),r=n;r<i;++r)s[t][r]=_(C(s[t][r],T(v,A(f[r]))),m)}}}for(t=0;t<i;++t)for(r=0;r<t&&r<a;++r){if(N(0,_(c[t][r],1e5)))throw new Error("math.qr(): unknown error - R is not lower triangular (element ("+t+", "+r+")  = "+c[t][r]+")");c[t][r]=T(c[t][r],0)}return{Q:o,R:u,toString:function(){return"Q: "+this.Q.toString()+"\nR: "+this.R.toString()}}},s=function(e){throw new Error("qr not implemented for sparse matrices yet")};return a}},function(e,t,o){t.name="rationalize",t.factory=function(e,t,r,n){var v=r(o(82)),y=r(o(116)),x=r(o(118)),w=o(53),i=r(o(125)),b=o(3),N=r(o(58)),M=r(o(57)),p=r(o(48)),a=n("rationalize",{string:function(e){return a(i(e),{},!1)},"string, boolean":function(e,t){return a(i(e),{},t)},"string, Object":function(e,t){return a(i(e),t,!1)},"string, Object, boolean":function(e,t,r){return a(i(e),t,r)},Node:function(e){return a(e,{},!1)},"Node, boolean":function(e,t){return a(e,{},t)},"Node, Object":function(e,t){return a(e,t,!1)},"Node, Object, boolean":function(e,t,r){var n,i,a,o,s=function(e,t,r){var o=[],n=v(e,t),s="+-*"+((r=!!r)?"/":"");!function e(t){var r=t.type;if("FunctionNode"===r)throw new w("There is an unsolved function call");if("OperatorNode"===r)if("^"===t.op&&t.isBinary()){if("ConstantNode"!==t.args[1].type||!b.isInteger(parseFloat(t.args[1].value)))throw new w("There is a non-integer exponent");e(t.args[0])}else{if(-1===s.indexOf(t.op))throw new w("Operator "+t.op+" invalid in polynomial expression");for(var n=0;n<t.args.length;n++)e(t.args[n])}else if("SymbolNode"===r){var i=t.name,a=o.indexOf(i);-1===a&&o.push(i)}else if("ParenthesisNode"===r)e(t.content);else if("ConstantNode"!==r)throw new w("type "+r+" is not allowed in polynomial expression")}(n);var i={};return i.expression=n,i.variables=o,i}(e,t,!0),u=s.variables.length;if(e=s.expression,1<=u){var c=((o={}).firstRules=(n=[y,{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},x,{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"1*n",r:"n"}]).concat(i=[{l:"(-n1)/(-n2)",r:"n1/n2"},{l:"(-n1)*(-n2)",r:"n1*n2"},{l:"n1--n2",r:"n1+n2"},{l:"n1-n2",r:"n1+(-n2)"},{l:"(n1+n2)*n3",r:"(n1*n3 + n2*n3)"},{l:"n1*(n2+n3)",r:"(n1*n2+n1*n3)"},{l:"c1*n + c2*n",r:"(c1+c2)*n"},{l:"-v*-c",r:"c*v"},{l:"-v*c",r:"-c*v"},{l:"v*-c",r:"-c*v"},{l:"v*c",r:"c*v"},{l:"-(-n1*n2)",r:"(n1*n2)"},{l:"-(n1*n2)",r:"(-n1*n2)"},{l:"-(-n1+n2)",r:"(n1-n2)"},{l:"-(n1+n2)",r:"(-n1-n2)"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"},{l:"-(-n1/n2)",r:"(n1/n2)"},{l:"-(n1/n2)",r:"(-n1/n2)"}],a=[{l:"(n1/(n2/n3))",r:"((n1*n3)/n2)"},{l:"(n1/n2/n3)",r:"(n1/(n2*n3))"}]),o.distrDivRules=[{l:"(n1/n2 + n3/n4)",r:"((n1*n4 + n3*n2)/(n2*n4))"},{l:"(n1/n2 + n3)",r:"((n1 + n3*n2)/n2)"},{l:"(n1 + n2/n3)",r:"((n1*n3 + n2)/n3)"}],o.sucDivRules=a,o.firstRulesAgain=n.concat(i),o.finalRules=[y,{l:"n*-n",r:"-n^2"},{l:"n*n",r:"n^2"},x,{l:"n*-n^n1",r:"-n^(n1+1)"},{l:"n*n^n1",r:"n^(n1+1)"},{l:"n^n1*-n^n2",r:"-n^(n1+n2)"},{l:"n^n1*n^n2",r:"n^(n1+n2)"},{l:"n^n1*-n",r:"-n^(n1+1)"},{l:"n^n1*n",r:"n^(n1+1)"},{l:"n^n1/-n",r:"-n^(n1-1)"},{l:"n^n1/n",r:"n^(n1-1)"},{l:"n/-n^n1",r:"-n^(1-n1)"},{l:"n/n^n1",r:"n^(1-n1)"},{l:"n^n1/-n^n2",r:"n^(n1-n2)"},{l:"n^n1/n^n2",r:"n^(n1-n2)"},{l:"n1+(-n2*n3)",r:"n1-n2*n3"},{l:"v*(-c)",r:"-c*v"},{l:"n1+-n2",r:"n1-n2"},{l:"v*c",r:"c*v"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"}],o);e=function e(t,r,n){var i=t.type,a=1<arguments.length;if("OperatorNode"===i&&t.isBinary()){var o=!1;if("^"===t.op&&("ParenthesisNode"===t.args[0].type||"OperatorNode"===t.args[0].type)&&"ConstantNode"===t.args[1].type){var s=parseFloat(t.args[1].value);o=2<=s&&b.isInteger(s)}if(o){if(2<s){var u=t.args[0],c=new M("^","pow",[t.args[0].cloneDeep(),new N(s-1)]);t=new M("*","multiply",[u,c])}else t=new M("*","multiply",[t.args[0],t.args[0].cloneDeep()]);a&&("content"===n?r.content=t:r.args[n]=t)}}if("ParenthesisNode"===i)e(t.content,t,"content");else if("ConstantNode"!==i&&"SymbolNode"!==i)for(var f=0;f<t.args.length;f++)e(t.args[f],t,f);if(!a)return t}(e);var f,l,p=!0,m="",h=!0;for(m=(e=v(e,c.firstRules)).toString();l=h?c.distrDivRules:c.sucDivRules,h=!h,(m=(e=v(e,l)).toString())!==f;)p=!0,f=m;p&&(e=v(e,c.firstRulesAgain)),e=v(e,c.finalRules)}var d=[],g={};return"OperatorNode"===e.type&&e.isBinary()&&"/"===e.op?(1==u&&(e.args[0]=E(e.args[0],d),e.args[1]=E(e.args[1])),r&&(g.numerator=e.args[0],g.denominator=e.args[1])):(1==u&&(e=E(e,d)),r&&(g.numerator=e,g.denominator=null)),r?(g.coefficients=d,g.variables=s.variables,g.expression=e,g):e}});function E(e,s){var t;void 0===s&&(s=[]);var r={cte:1,oper:"+",fire:""},u=s[0]=0,c="";!function e(t,r,n){var i=t.type;if("FunctionNode"===i)throw new w("There is an unsolved function call");if("OperatorNode"===i){if(-1==="+-*^".indexOf(t.op))throw new w("Operator "+t.op+" invalid");if(null!==r){if(("unaryMinus"===t.fn||"pow"===t.fn)&&"add"!==r.fn&&"subtract"!==r.fn&&"multiply"!==r.fn)throw new w("Invalid "+t.op+" placing");if(("subtract"===t.fn||"add"===t.fn||"multiply"===t.fn)&&"add"!==r.fn&&"subtract"!==r.fn)throw new w("Invalid "+t.op+" placing");if(("subtract"===t.fn||"add"===t.fn||"unaryMinus"===t.fn)&&0!==n.noFil)throw new w("Invalid "+t.op+" placing")}"^"!==t.op&&"*"!==t.op||(n.fire=t.op);for(var a=0;a<t.args.length;a++)"unaryMinus"===t.fn&&(n.oper="-"),"+"!==t.op&&"subtract"!==t.fn||(n.fire="",n.cte=1,n.oper=0===a?"+":t.op),n.noFil=a,e(t.args[a],t,n)}else if("SymbolNode"===i){if(t.name!==c&&""!==c)throw new w("There is more than one variable");if(c=t.name,null===r)return void(s[1]=1);if("^"===r.op&&0!==n.noFil)throw new w("In power the variable should be the first parameter");if("*"===r.op&&1!==n.noFil)throw new w("In multiply the variable should be the second parameter");""!==n.fire&&"*"!==n.fire||(u<1&&(s[1]=0),s[1]+=n.cte*("+"===n.oper?1:-1),u=Math.max(1,u))}else{if("ConstantNode"!==i)throw new w("Type "+i+" is not allowed");var o=parseFloat(t.value);if(null===r)return void(s[0]=o);if("^"===r.op){if(1!==n.noFil)throw new w("Constant cannot be powered");if(!b.isInteger(o)||o<=0)throw new w("Non-integer exponent is not allowed");for(var a=u+1;a<o;a++)s[a]=0;return u<o&&(s[o]=0),s[o]+=n.cte*("+"===n.oper?1:-1),void(u=Math.max(o,u))}n.cte=o,""===n.fire&&(s[0]+=n.cte*("+"===n.oper?1:-1))}}(e,null,r);var n=!0;for(t=u=s.length-1;0<=t;t--)if(0!==s[t]){var i,a=new N(n?s[t]:Math.abs(s[t])),o=s[t]<0?"-":"+";if(0<t){var f=new p(c);if(1<t){var l=new N(t);f=new M("^","pow",[f,l])}a=-1===s[t]&&n?new M("-","unaryMinus",[f]):1===Math.abs(s[t])?f:new M("*","multiply",[a,f])}i=n?a:"+"===o?new M("+","add",[i,a]):new M("-","subtract",[i,a]),n=!1}return n?new N(0):i}return a}},function(e,t,r){t.math=!0,t.name="resolve",t.path="algebra.simplify",t.factory=function(a,e,t,r,o){var s=o.expression.node.Node,u=o.expression.node.OperatorNode,c=o.expression.node.FunctionNode,f=o.expression.node.ParenthesisNode;return function t(e,r){if(!r)return e;if(a.isSymbolNode(e)){var n=r[e.name];if(n instanceof s)return t(n,r);if("number"==typeof n)return o.parse(String(n))}else{if(a.isOperatorNode(e)){var i=e.args.map(function(e){return t(e,r)});return new u(e.op,e.fn,i)}if(a.isParenthesisNode(e))return new f(t(e.content,r));if(a.isFunctionNode(e))return i=e.args.map(function(e){return t(e,r)}),new c(e.name,i)}return e}}},function(e,t,x){t.name="derivative",t.factory=function(c,r,e,t){var n=e(x(39)),a=e(x(82)),f=e(x(50)),l=e(x(56)),i=e(x(136)),o=e(x(58)),p=e(x(69)),m=e(x(57)),s=e(x(70)),h=e(x(48)),u=t("derivative",{"Node, SymbolNode, Object":function(e,t,r){var n={};g(n,e,t.name);var i=v(e,n);return r.simplify?a(i):i},"Node, SymbolNode":function(e,t){return u(e,t,{simplify:!0})},"string, SymbolNode":function(e,t){return u(n(e),t)},"string, SymbolNode, Object":function(e,t,r){return u(n(e),t,r)},"string, string":function(e,t){return u(n(e),n(t))},"string, string, Object":function(e,t,r){return u(n(e),n(t),r)},"Node, string":function(e,t){return u(e,n(t))},"Node, string, Object":function(e,t,r){return u(e,n(t),r)}});u._simplify=!0,u.toTex=function(e){return d.apply(null,e.args)};var d=t("_derivTex",{"Node, SymbolNode":function(e,t){return d(e.toString(),t.toString(),1)},"Node, SymbolNode, ConstantNode":function(e,t,r){return d(e.toString(),t.name,r.value)},"string, string, number":function(e,t,r){return(1===r?"{d\\over d"+t+"}":"{d^{"+r+"}\\over d"+t+"^{"+r+"}}")+"\\left["+e+"\\right]"}}),g=t("constTag",{"Object, ConstantNode, string":function(e,t){return e[t]=!0},"Object, SymbolNode, string":function(e,t,r){return t.name!==r&&(e[t]=!0)},"Object, ParenthesisNode, string":function(e,t,r){return g(e,t.content,r)},"Object, FunctionAssignmentNode, string":function(e,t,r){return-1===t.params.indexOf(r)?e[t]=!0:g(e,t.expr,r)},"Object, FunctionNode | OperatorNode, string":function(e,t,r){if(0<t.args.length){for(var n=g(e,t.args[0],r),i=1;i<t.args.length;++i)n=g(e,t.args[i],r)&&n;if(n)return e[t]=!0}return!1}}),v=t("_derivative",{"ConstantNode, Object":function(e){return y(0)},"SymbolNode, Object":function(e,t){return void 0!==t[e]?y(0):y(1)},"ParenthesisNode, Object":function(e,t){return new s(v(e.content,t))},"FunctionAssignmentNode, Object":function(e,t){return void 0!==t[e]?y(0):v(e.expr,t)},"FunctionNode, Object":function(e,t){if(1!==e.args.length&&function(e){if("log"!==e.name&&"nthRoot"!==e.name||2!==e.args.length){for(var t=0;t<e.args.length;++t)e.args[t]=y(0);throw e.compile().eval(),new Error("Expected TypeError, but none found")}}(e),void 0!==t[e])return y(0);var r,n,i,a,o=e.args[0],s=!1,u=!1;switch(e.name){case"cbrt":s=!0,n=new m("*","multiply",[y(3),new m("^","pow",[o,new m("/","divide",[y(2),y(3)])])]);break;case"sqrt":case"nthRoot":if(1===e.args.length)s=!0,n=new m("*","multiply",[y(2),new p("sqrt",[o])]);else if(2===e.args.length)return t[r=new m("/","divide",[y(1),e.args[1]])]=t[e.args[1]],v(new m("^","pow",[o,r]),t);break;case"log10":r=y(10);case"log":if(r||1!==e.args.length){if(1===e.args.length&&r||2===e.args.length&&void 0!==t[e.args[1]])n=new m("*","multiply",[o.clone(),new p("log",[r||e.args[1]])]),s=!0;else if(2===e.args.length)return v(new m("/","divide",[new p("log",[o]),new p("log",[e.args[1]])]),t)}else n=o.clone(),s=!0;break;case"exp":n=new p("exp",[o.clone()]);break;case"sin":n=new p("cos",[o.clone()]);break;case"cos":n=new m("-","unaryMinus",[new p("sin",[o.clone()])]);break;case"tan":n=new m("^","pow",[new p("sec",[o.clone()]),y(2)]);break;case"sec":n=new m("*","multiply",[e,new p("tan",[o.clone()])]);break;case"csc":u=!0,n=new m("*","multiply",[e,new p("cot",[o.clone()])]);break;case"cot":u=!0,n=new m("^","pow",[new p("csc",[o.clone()]),y(2)]);break;case"asin":s=!0,n=new p("sqrt",[new m("-","subtract",[y(1),new m("^","pow",[o.clone(),y(2)])])]);break;case"acos":u=s=!0,n=new p("sqrt",[new m("-","subtract",[y(1),new m("^","pow",[o.clone(),y(2)])])]);break;case"atan":s=!0,n=new m("+","add",[new m("^","pow",[o.clone(),y(2)]),y(1)]);break;case"asec":s=!0,n=new m("*","multiply",[new p("abs",[o.clone()]),new p("sqrt",[new m("-","subtract",[new m("^","pow",[o.clone(),y(2)]),y(1)])])]);break;case"acsc":u=s=!0,n=new m("*","multiply",[new p("abs",[o.clone()]),new p("sqrt",[new m("-","subtract",[new m("^","pow",[o.clone(),y(2)]),y(1)])])]);break;case"acot":u=s=!0,n=new m("+","add",[new m("^","pow",[o.clone(),y(2)]),y(1)]);break;case"sinh":n=new p("cosh",[o.clone()]);break;case"cosh":n=new p("sinh",[o.clone()]);break;case"tanh":n=new m("^","pow",[new p("sech",[o.clone()]),y(2)]);break;case"sech":u=!0,n=new m("*","multiply",[e,new p("tanh",[o.clone()])]);break;case"csch":u=!0,n=new m("*","multiply",[e,new p("coth",[o.clone()])]);break;case"coth":u=!0,n=new m("^","pow",[new p("csch",[o.clone()]),y(2)]);break;case"asinh":s=!0,n=new p("sqrt",[new m("+","add",[new m("^","pow",[o.clone(),y(2)]),y(1)])]);break;case"acosh":s=!0,n=new p("sqrt",[new m("-","subtract",[new m("^","pow",[o.clone(),y(2)]),y(1)])]);break;case"atanh":s=!0,n=new m("-","subtract",[y(1),new m("^","pow",[o.clone(),y(2)])]);break;case"asech":u=s=!0,n=new m("*","multiply",[o.clone(),new p("sqrt",[new m("-","subtract",[y(1),new m("^","pow",[o.clone(),y(2)])])])]);break;case"acsch":u=s=!0,n=new m("*","multiply",[new p("abs",[o.clone()]),new p("sqrt",[new m("+","add",[new m("^","pow",[o.clone(),y(2)]),y(1)])])]);break;case"acoth":u=s=!0,n=new m("-","subtract",[y(1),new m("^","pow",[o.clone(),y(2)])]);break;case"abs":n=new m("/","divide",[new p(new h("abs"),[o.clone()]),o.clone()]);break;case"gamma":default:throw new Error('Function "'+e.name+'" is not supported by derivative, or a wrong number of arguments is passed')}s?(i="/",a="divide"):(i="*",a="multiply");var c=v(o,t);return u&&(c=new m("-","unaryMinus",[c])),new m(i,a,[c,n])},"OperatorNode, Object":function(e,r){if(void 0!==r[e])return y(0);if("+"===e.op)return new m(e.op,e.fn,e.args.map(function(e){return v(e,r)}));if("-"===e.op){if(e.isUnary())return new m(e.op,e.fn,[v(e.args[0],r)]);if(e.isBinary())return new m(e.op,e.fn,[v(e.args[0],r),v(e.args[1],r)])}if("*"===e.op){var t=e.args.filter(function(e){return void 0!==r[e]});if(0<t.length){var n=e.args.filter(function(e){return void 0===r[e]}),i=1===n.length?n[0]:new m("*","multiply",n),a=t.concat(v(i,r));return new m("*","multiply",a)}return new m("+","add",e.args.map(function(t){return new m("*","multiply",e.args.map(function(e){return e===t?v(e,r):e.clone()}))}))}if("/"===e.op&&e.isBinary()){var o=e.args[0],s=e.args[1];return void 0!==r[s]?new m("/","divide",[v(o,r),s]):void 0!==r[o]?new m("*","multiply",[new m("-","unaryMinus",[o]),new m("/","divide",[v(s,r),new m("^","pow",[s.clone(),y(2)])])]):new m("/","divide",[new m("-","subtract",[new m("*","multiply",[v(o,r),s.clone()]),new m("*","multiply",[o.clone(),v(s,r)])]),new m("^","pow",[s.clone(),y(2)])])}if("^"===e.op&&e.isBinary()){if(o=e.args[0],s=e.args[1],void 0!==r[o])return c.isConstantNode(o)&&(l(o.value)||f(o.value,1))?y(0):new m("*","multiply",[e,new m("*","multiply",[new p("log",[o.clone()]),v(s.clone(),r)])]);if(void 0!==r[s]){if(c.isConstantNode(s)){if(l(s.value))return y(0);if(f(s.value,1))return v(o,r)}var u=new m("^","pow",[o.clone(),new m("-","subtract",[s,y(1)])]);return new m("*","multiply",[s.clone(),new m("*","multiply",[v(o,r),u])])}return new m("*","multiply",[new m("^","pow",[o.clone(),s.clone()]),new m("+","add",[new m("*","multiply",[v(o,r),new m("/","divide",[s.clone(),o.clone()])]),new m("*","multiply",[v(s,r),new p("log",[o.clone()])])])])}throw new Error('Operator "'+e.op+'" is not supported by derivative, or a wrong number of arguments is passed')}});function y(e,t){return new o(i(e,t||r.number))}return u}},function(e,t,r){e.exports=[r(297),r(82),r(295),r(294),r(112),r(111),r(106),r(280),r(105)]},function(e,t,r){e.exports=[r(298),r(278),r(256),r(243),r(239),r(235),r(232),r(228),r(212),r(202),r(199),r(191),r(189),r(183),r(181),r(156),r(154)]},function(e,t,i){var s=i(5),u=i(9);t.name="Help",t.path="type",t.factory=function(a,e,t,r){var o=t(i(124))();function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!e)throw new Error('Argument "doc" missing');this.doc=e}return n.prototype.type="Help",n.prototype.isHelp=!0,n.prototype.toString=function(){var e=this.doc||{},t="\n";if(e.name&&(t+="Name: "+e.name+"\n\n"),e.category&&(t+="Category: "+e.category+"\n\n"),e.description&&(t+="Description:\n    "+e.description+"\n\n"),e.syntax&&(t+="Syntax:\n    "+e.syntax.join("\n    ")+"\n\n"),e.examples){t+="Examples:\n";for(var r=0;r<e.examples.length;r++){var n,i=e.examples[r];t+="    "+i+"\n";try{n=o.eval(i)}catch(e){n=e}void 0===n||a.isHelp(n)||(t+="        "+u.format(n,{precision:14})+"\n")}t+="\n"}return e.seealso&&e.seealso.length&&(t+="See also: "+e.seealso.join(", ")+"\n"),t},n.prototype.toJSON=function(){var e=s.clone(this.doc);return e.mathjs="Help",e},n.fromJSON=function(e){var t={};for(var r in e)"mathjs"!==r&&(t[r]=e[r]);return new n(t)},n.prototype.valueOf=n.prototype.toString,n}},function(e,t,a){var o=a(38).transform;t.name="subset",t.path="expression.transform",t.factory=function(e,t,r,n){var i=r(a(22));return n("subset",{"...any":function(e){try{return i.apply(null,e)}catch(e){throw o(e)}}})}},function(e,t,a){t.name="range",t.path="expression.transform",t.factory=function(e,t,r,n){var i=r(a(119));return n("range",{"...any":function(e){return"boolean"!=typeof e[e.length-1]&&e.push(!0),i.apply(null,e)}})}},function(e,t,a){var o=a(38).transform,s=a(47);t.name="min",t.path="expression.transform",t.factory=function(r,e,t,n){var i=t(a(120));return n("min",{"...any":function(e){if(2==e.length&&s(e[0])){var t=e[1];r.isNumber(t)?e[1]=t-1:r.isBigNumber(t)&&(e[1]=t.minus(1))}try{return i.apply(null,e)}catch(e){throw o(e)}}})}},function(e,t,a){var o=a(38).transform,s=a(47);t.name="mean",t.path="expression.transform",t.factory=function(r,e,t,n){var i=t(a(122));return n("mean",{"...any":function(e){if(2==e.length&&s(e[0])){var t=e[1];r.isNumber(t)?e[1]=t-1:r.isBigNumber(t)&&(e[1]=t.minus(1))}try{return i.apply(null,e)}catch(e){throw o(e)}}})}},function(e,t,a){var o=a(38).transform,s=a(47);t.name="max",t.path="expression.transform",t.factory=function(r,e,t,n){var i=t(a(84));return n("max",{"...any":function(e){if(2==e.length&&s(e[0])){var t=e[1];r.isNumber(t)?e[1]=t-1:r.isBigNumber(t)&&(e[1]=t.minus(1))}try{return i.apply(null,e)}catch(e){throw o(e)}}})}},function(e,t,u){var r=u(35).maxArgumentCount,o=u(2).map;function c(e,t,i){var a=r(t);return function r(e,n){return Array.isArray(e)?o(e,function(e,t){return r(e,n.concat(t+1))}):1===a?t(e):2===a?t(e,n):t(e,n,i)}(e,[])}t.name="map",t.path="expression.transform",t.factory=function(a,e,t,r){var o=t(u(85)),n=t(u(1));function i(e,t,r){var n,i;return e[0]&&(n=e[0].compile().eval(r)),e[1]&&(i=a.isSymbolNode(e[1])||a.isFunctionAssignmentNode(e[1])?e[1].compile().eval(r):o(e[1],t,r)),s(n,i)}i.rawArgs=!0;var s=r("map",{"Array, function":function(e,t){return c(e,t,e)},"Matrix, function":function(e,t){return n(c(e.valueOf(),t,e))}});return i}},function(e,t,r){t.name="index",t.path="expression.transform",t.factory=function(a,e,t){return function(){for(var e=[],t=0,r=arguments.length;t<r;t++){var n=arguments[t];if(a.isRange(n))n.start--,n.end-=0<n.step?0:2;else if(n&&!0===n.isSet)n=n.map(function(e){return e-1});else if(a.isArray(n)||a.isMatrix(n))n=n.map(function(e){return e-1});else if(a.isNumber(n))n--;else if(a.isBigNumber(n))n=n.toNumber()-1;else if("string"!=typeof n)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");e[t]=n}var i=new a.Index;return a.Index.apply(i,e),i}}},function(e,t,i){var u=i(35).maxArgumentCount,c=i(2).forEach;t.name="forEach",t.path="expression.transform",t.factory=function(a,e,t,r){var o=t(i(85));function n(e,t,r){var n,i;return e[0]&&(n=e[0].compile().eval(r)),e[1]&&(i=a.isSymbolNode(e[1])||a.isFunctionAssignmentNode(e[1])?e[1].compile().eval(r):o(e[1],t,r)),s(n,i)}n.rawArgs=!0;var s=r("forEach",{"Array | Matrix, function":function(t,n){var i=u(n),a=function(e,r){Array.isArray(e)?c(e,function(e,t){a(e,r.concat(t+1))}):1===i?n(e):2===i?n(e,r):n(e,r,t)};a(t.valueOf(),[])}});return n}},function(e,t,u){var r=u(2).filter,c=u(2).filterRegExp,a=u(35).maxArgumentCount;function f(e,n){var i=a(n);return r(e,function(e,t,r){return 1===i?n(e):2===i?n(e,[t+1]):n(e,[t+1],r)})}t.name="filter",t.path="expression.transform",t.factory=function(a,e,t,r){var o=t(u(85)),n=t(u(1));function i(e,t,r){var n,i;return e[0]&&(n=e[0].compile().eval(r)),e[1]&&(i=a.isSymbolNode(e[1])||a.isFunctionAssignmentNode(e[1])?e[1].compile().eval(r):o(e[1],t,r)),s(n,i)}i.rawArgs=!0;var s=r("filter",{"Array, function":f,"Matrix, function":function(e,t){return n(f(e.toArray(),t))},"Array, RegExp":c,"Matrix, RegExp":function(e,t){return n(c(e.toArray(),t))}});return s.toTex=void 0,i}},function(e,t,a){var o=a(38).transform;t.name="concat",t.path="expression.transform",t.factory=function(n,e,t,r){var i=t(a(68));return r("concat",{"...any":function(e){var t=e.length-1,r=e[t];n.isNumber(r)?e[t]=r-1:n.isBigNumber(r)&&(e[t]=r.minus(1));try{return i.apply(null,e)}catch(e){throw o(e)}}})}},function(e,t,r){e.exports=[r(310),r(309),r(308),r(307),r(306),r(305),r(304),r(303),r(302),r(301)]},function(e,t,r){t.name="UpdateNode",t.path="expression.node",t.factory=function(e,t,r,n){return function(){throw new Error("UpdateNode is deprecated. Use AssignmentNode instead.")}}},function(e,t,r){e.exports=[r(135),r(132),r(131),r(130),r(129),r(58),r(86),r(128),r(69),r(14),r(127),r(57),r(70),r(126),r(48),r(312)]},function(e,t,n){var s=n(15).getSafeProperty;t.math=!0,t.name="help",t.factory=function(i,e,t,r,a){var o=t(n(139));return r("help",{any:function(e){var t,r=e;if("string"!=typeof e)for(t in a)if(a.hasOwnProperty(t)&&e===a[t]){r=t;break}var n=s(o,r);if(!n)throw new Error('No documentation found on "'+r+'"');return new i.Help(n)}})}},function(e,t,a){var o=a(0);t.name="eval",t.factory=function(e,t,r,n){var i=r(a(39));return n("compile",{string:function(e){return i(e).compile().eval({})},"string, Object":function(e,t){return i(e).compile().eval(t)},"Array | Matrix":function(e){var t={};return o(e,function(e){return i(e).compile().eval(t)})},"Array | Matrix, Object":function(e,t){return o(e,function(e){return i(e).compile().eval(t)})}})}},function(e,t,o){var s=o(38).transform,u=o(15).setSafeProperty;t.factory=function(e,t,r,n){var i=r(o(22)),a=r(o(1));return function(e,t,r){try{if(Array.isArray(e))return a(e).subset(t,r).valueOf();if(e&&"function"==typeof e.subset)return e.subset(t,r);if("string"==typeof e)return i(e,t,r);if("object"==typeof e){if(!t.isObjectProperty())throw TypeError("Cannot apply a numeric index as object property");return u(e,t.getObjectProperty(),r),e}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw s(e)}}}},function(e,t,a){var o=a(0);t.name="compile",t.factory=function(e,t,r,n){var i=r(a(39));return n("compile",{string:function(e){return i(e).compile()},"Array | Matrix":function(e){return o(e,function(e){return i(e).compile()})}})}},function(e,t,r){e.exports=[r(317),r(315),r(314),r(125),r(124)]},function(e,t){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(e,t){e.exports={name:"isZero",category:"Utils",syntax:["isZero(x)"],description:"Test whether a value is zero.",examples:["isZero(2)","isZero(0)","isZero(-4)","isZero([3, 0, -2, 0])"],seealso:["isInteger","isNumeric","isNegative","isPositive"]}},function(e,t){e.exports={name:"isPrime",category:"Utils",syntax:["isPrime(x)"],description:"Test whether a value is prime: has no divisors other than itself and one.",examples:["isPrime(3)","isPrime(-2)","isPrime([2, 17, 100])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isPositive",category:"Utils",syntax:["isPositive(x)"],description:"Test whether a value is positive: larger than zero.",examples:["isPositive(2)","isPositive(0)","isPositive(-4)","isPositive([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isNumeric",category:"Utils",syntax:["isNumeric(x)"],description:"Test whether a value is a numeric value. Returns true when the input is a number, BigNumber, Fraction, or boolean.",examples:["isNumeric(2)","isNumeric(0)","isNumeric(bignumber(500))","isNumeric(fraction(0.125))",'isNumeric("3")',"isNumeric(2 + 3i)",'isNumeric([2.3, "foo", false])'],seealso:["isInteger","isZero","isNegative","isPositive","isNaN"]}},function(e,t){e.exports={name:"isNegative",category:"Utils",syntax:["isNegative(x)"],description:"Test whether a value is negative: smaller than zero.",examples:["isNegative(2)","isNegative(0)","isNegative(-4)","isNegative([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isInteger",category:"Utils",syntax:["isInteger(x)"],description:"Test whether a value is an integer number.",examples:["isInteger(2)","isInteger(3.5)","isInteger([3, 0.5, -2])"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isNaN",category:"Utils",syntax:["isNaN(x)"],description:"Test whether a value is NaN (not a number)",examples:["isNaN(2)","isNaN(0 / 0)","isNaN(NaN)","isNaN(Infinity)"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e,t){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e,t){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]}},function(e,t){e.exports={name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]}},function(e,t){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e,t){e.exports={name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]}},function(e,t){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e,t){e.exports={name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]}},function(e,t){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e,t){e.exports={name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]}},function(e,t){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e,t){e.exports={name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]}},function(e,t){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e,t){e.exports={name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]}},function(e,t){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e,t){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e,t){e.exports={name:"atanh",category:"Trigonometry",syntax:["atanh(x)"],description:"Calculate the hyperbolic arctangent of a value, defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.",examples:["atanh(0.5)"],seealso:["acosh","asinh"]}},function(e,t){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(0.5))"],seealso:["tan","acos","asin"]}},function(e,t){e.exports={name:"asinh",category:"Trigonometry",syntax:["asinh(x)"],description:"Calculate the hyperbolic arcsine of a value, defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.",examples:["asinh(0.5)"],seealso:["acosh","atanh"]}},function(e,t){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(0.5))"],seealso:["sin","acos","atan"]}},function(e,t){e.exports={name:"asech",category:"Trigonometry",syntax:["asech(x)"],description:"Calculate the inverse secant of a value.",examples:["asech(0.5)"],seealso:["acsch","acoth"]}},function(e,t){e.exports={name:"asec",category:"Trigonometry",syntax:["asec(x)"],description:"Calculate the inverse secant of a value.",examples:["asec(0.5)","asec(sec(0.5))","asec(2)"],seealso:["acos","acot","acsc"]}},function(e,t){e.exports={name:"acsch",category:"Trigonometry",syntax:["acsch(x)"],description:"Calculate the hyperbolic arccosecant of a value, defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.",examples:["acsch(0.5)"],seealso:["asech","acoth"]}},function(e,t){e.exports={name:"acsc",category:"Trigonometry",syntax:["acsc(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acsc(2)","acsc(csc(0.5))","acsc(0.5)"],seealso:["csc","asin","asec"]}},function(e,t){e.exports={name:"acoth",category:"Trigonometry",syntax:["acoth(x)"],description:"Calculate the hyperbolic arccotangent of a value, defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.",examples:["acoth(2)","acoth(0.5)"],seealso:["acsch","asech"]}},function(e,t){e.exports={name:"acot",category:"Trigonometry",syntax:["acot(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acot(0.5)","acot(cot(0.5))","acot(2)"],seealso:["cot","atan"]}},function(e,t){e.exports={name:"acosh",category:"Trigonometry",syntax:["acosh(x)"],description:"Calculate the hyperbolic arccos of a value, defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.",examples:["acosh(1.5)"],seealso:["cosh","asinh","atanh"]}},function(e,t){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]}},function(e,t){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e,t){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e,t){e.exports={name:"quantileSeq",category:"Statistics",syntax:["quantileSeq(A, prob[, sorted])","quantileSeq(A, [prob1, prob2, ...][, sorted])","quantileSeq(A, N[, sorted])"],description:"Compute the prob order quantile of a matrix or a list with values. The sequence is sorted and the middle value is returned. Supported types of sequence values are: Number, BigNumber, Unit Supported types of probablity are: Number, BigNumber. \n\nIn case of a (multi dimensional) array or matrix, the prob order quantile of all elements will be calculated.",examples:["quantileSeq([3, -1, 5, 7], 0.5)","quantileSeq([3, -1, 5, 7], [1/3, 2/3])","quantileSeq([3, -1, 5, 7], 2)","quantileSeq([-1, 3, 5, 7], 0.5, true)"],seealso:["mean","median","min","max","prod","std","sum","var"]}},function(e,t){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e,t){e.exports={name:"mode",category:"Statistics",syntax:["mode(a, b, c, ...)","mode(A)","mode(A, a, b, B, c, ...)"],description:"Computes the mode of all values as an array. In case mode being more than one, multiple values are returned in an array.",examples:["mode(2, 1, 4, 3, 1)","mode([1, 2.7, 3.2, 4, 2.7])","mode(1, 4, 6, 1, 6)"],seealso:["max","mean","min","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3])","min([2, 5; 4, 3], 1)","min([2, 5; 4, 3], 2)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var","quantileSeq"]}},function(e,t){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3])","mean([2, 5; 4, 3], 1)","mean([2, 5; 4, 3], 2)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3])","max([2, 5; 4, 3], 1)","max([2, 5; 4, 3], 2)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"mad",category:"Statistics",syntax:["mad(a, b, c, ...)","mad(A)"],description:"Compute the median absolute deviation of a matrix or a list with values. The median absolute deviation is defined as the median of the absolute deviations from the median.",examples:["mad(10, 20, 30)","mad([1, 2, 3])"],seealso:["mean","median","std","abs"]}},function(e,t){e.exports={name:"erf",category:"Special",syntax:["erf(x)"],description:"Compute the erf function of a value using a rational Chebyshev approximations for different intervals of x",examples:["erf(0.2)","erf(-0.5)","erf(4)"],seealso:[]}},function(e,t){e.exports={name:"setUnion",category:"Set",syntax:["setUnion(set1, set2)"],description:"Create the union of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setUnion([1, 2, 3, 4], [3, 4, 5, 6])","setUnion([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setIntersect","setDifference"]}},function(e,t){e.exports={name:"setSymDifference",category:"Set",syntax:["setSymDifference(set1, set2)"],description:"Create the symmetric difference of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setSymDifference([1, 2, 3, 4], [3, 4, 5, 6])","setSymDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setSize",category:"Set",syntax:["setSize(set)","setSize(set, unique)"],description:'Count the number of elements of a (multi)set. When the second parameter "unique" is true, count only the unique values. A multi-dimension array will be converted to a single-dimension array before the operation.',examples:["setSize([1, 2, 2, 4])","setSize([1, 2, 2, 4], true)"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setPowerset",category:"Set",syntax:["setPowerset(set)"],description:"Create the powerset of a (multi)set: the powerset contains very possible subsets of a (multi)set. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setPowerset([1, 2, 3])"],seealso:["setCartesian"]}},function(e,t){e.exports={name:"setMultiplicity",category:"Set",syntax:["setMultiplicity(element, set)"],description:"Count the multiplicity of an element in a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setMultiplicity(1, [1, 2, 2, 4])","setMultiplicity(2, [1, 2, 2, 4])"],seealso:["setDistinct","setSize"]}},function(e,t){e.exports={name:"setIsSubset",category:"Set",syntax:["setIsSubset(set1, set2)"],description:"Check whether a (multi)set is a subset of another (multi)set: every element of set1 is the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIsSubset([1, 2], [3, 4, 5, 6])","setIsSubset([3, 4], [3, 4, 5, 6])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setIntersect",category:"Set",syntax:["setIntersect(set1, set2)"],description:"Create the intersection of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIntersect([1, 2, 3, 4], [3, 4, 5, 6])","setIntersect([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setDifference"]}},function(e,t){e.exports={name:"setDistinct",category:"Set",syntax:["setDistinct(set)"],description:"Collect the distinct elements of a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setDistinct([1, 1, 1, 2, 2, 3])"],seealso:["setMultiplicity"]}},function(e,t){e.exports={name:"setDifference",category:"Set",syntax:["setDifference(set1, set2)"],description:"Create the difference of two (multi)sets: every element of set1, that is not the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setDifference([1, 2, 3, 4], [3, 4, 5, 6])","setDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setSymDifference"]}},function(e,t){e.exports={name:"setCartesian",category:"Set",syntax:["setCartesian(set1, set2)"],description:"Create the cartesian product of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setCartesian([1, 2], [3, 4])"],seealso:["setUnion","setIntersect","setDifference","setPowerset"]}},function(e,t){e.exports={name:"unequal",category:"Relational",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"smallerEq",category:"Relational",syntax:["x <= y","smallerEq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 <= 1+1","2 < 1+1","a = 3.2","b = 6-2.8","(a <= b)"],seealso:["equal","unequal","larger","smaller","largerEq","compare"]}},function(e,t){e.exports={name:"smaller",category:"Relational",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"largerEq",category:"Relational",syntax:["x >= y","largerEq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 >= 1+1","2 > 1+1","a = 3.2","b = 6-2.8","(a >= b)"],seealso:["equal","unequal","smallerEq","smaller","compare"]}},function(e,t){e.exports={name:"larger",category:"Relational",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"equal",category:"Relational",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"deepEqual",category:"Relational",syntax:["deepEqual(x, y)"],description:"Check equality of two matrices element wise. Returns true if the size of both matrices is equal and when and each of the elements are equal.",examples:["deepEqual([1,3,4], [1,3,4])","deepEqual([1,3,4], [1,3])"],seealso:["equal","unequal","smaller","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"compareNatural",category:"Relational",syntax:["compareNatural(x, y)"],description:"Compare two values of any type in a deterministic, natural way.",examples:["compareNatural(2, 3)","compareNatural(3, 2)","compareNatural(2, 2)","compareNatural(5cm, 40mm)",'compareNatural("2", "10")',"compareNatural(2 + 3i, 2 + 4i)","compareNatural([1, 2, 4], [1, 2, 3])","compareNatural([1, 5], [1, 2, 3])","compareNatural([1, 2], [1, 2])","compareNatural({a: 2}, {a: 4})"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"compare",category:"Relational",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compareNatural"]}},function(e,t){e.exports={name:"randomInt",category:"Probability",syntax:["randomInt(max)","randomInt(min, max)","randomInt(size)","randomInt(size, max)","randomInt(size, min, max)"],description:"Return a random integer number",examples:["randomInt(10, 20)","randomInt([2, 3], 10)"],seealso:["pickRandom","random"]}},function(e,t){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["pickRandom","randomInt"]}},function(e,t){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)","pickRandom(array, number)","pickRandom(array, weights)","pickRandom(array, number, weights)","pickRandom(array, weights, number)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])","pickRandom([1, 3, 1, 6], 2)","pickRandom([1, 3, 1, 6], [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], 2, [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], [2, 3, 2, 1], 2)"],seealso:["random","randomInt"]}},function(e,t){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"multinomial",category:"Probability",syntax:["multinomial(A)"],description:"Multinomial Coefficients compute the number of ways of picking a1, a2, ..., ai unordered outcomes from `n` possibilities. multinomial takes one array of integers as an argument. The following condition must be enforced: every ai > 0.",examples:["multinomial([1, 2, 1])"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"kldivergence",category:"Probability",syntax:["kldivergence(x, y)"],description:"Calculate the Kullback-Leibler (KL) divergence  between two distributions.",examples:["kldivergence([0.7,0.5,0.4], [0.2,0.9,0.5])"],seealso:[]}},function(e,t){e.exports={name:"gamma",category:"Probability",syntax:["gamma(n)"],description:"Compute the gamma function. For small values, the Lanczos approximation is used, and for large values the extended Stirling approximation.",examples:["gamma(4)","3!","gamma(1/2)","sqrt(pi)"],seealso:["factorial"]}},function(e,t){e.exports={name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5 * 4 * 3 * 2 * 1","3!"],seealso:["combinations","permutations","gamma"]}},function(e,t){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e,t){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose"]}},function(e,t){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","zeros"]}},function(e,t){e.exports={name:"trace",category:"Matrix",syntax:["trace(A)"],description:"Calculate the trace of a matrix: the sum of the elements on the main diagonal of a square matrix.",examples:["A = [1, 2, 3; -1, 2, 3; 2, 0, 3]","trace(A)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e,t){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","trace","transpose","zeros"]}},function(e,t){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove inner and outer singleton dimensions from a matrix.",examples:["a = zeros(3,2,1)","size(squeeze(a))","b = zeros(1,1,3)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"sort",category:"Matrix",syntax:["sort(x)","sort(x, compare)"],description:'Sort the items in a matrix. Compare can be a string "asc", "desc", "natural", or a custom sort function.',examples:["sort([5, 10, 1])",'sort(["C", "B", "A", "D"])',"sortByLength(a, b) = size(a)[1] - size(b)[1]",'sort(["Langdon", "Tom", "Sara"], sortByLength)','sort(["10", "1", "2"], "natural")'],seealso:["map","filter","forEach"]}},function(e,t){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"reshape",category:"Matrix",syntax:["reshape(x, sizes)"],description:"Reshape a multi dimensional array to fit the specified dimensions.",examples:["reshape([1, 2, 3, 4, 5, 6], [2, 3])","reshape([[1, 2], [3, 4]], [1, 4])","reshape([[1, 2], [3, 4]], [4])"],seealso:["size","squeeze","resize"]}},function(e,t){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5])","resize([1,2,3], [5], -1)","resize(2, [2, 3])",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze","reshape"]}},function(e,t){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"partitionSelect",category:"Matrix",syntax:["partitionSelect(x, k)","partitionSelect(x, k, compare)"],description:"Partition-based selection of an array or 1D matrix. Will find the kth smallest value, and mutates the input array. Uses Quickselect.",examples:["partitionSelect([5, 10, 1], 2)",'partitionSelect(["C", "B", "A", "D"], 1)'],seealso:["sort"]}},function(e,t){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"map",category:"Matrix",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], square)"],seealso:["filter","forEach"]}},function(e,t){e.exports={name:"kron",category:"Matrix",syntax:["kron(x, y)"],description:"Calculates the kronecker product of 2 matrices or vectors.",examples:["kron([[1, 0], [0, 1]], [[1, 2], [3, 4]])","kron([1,1], [2,3,4])"],seealso:["multiply","dot","cross"]}},function(e,t){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"forEach",category:"Matrix",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["map","sort","filter"]}},function(e,t){e.exports={name:"flatten",category:"Matrix",syntax:["flatten(x)"],description:"Flatten a multi dimensional matrix into a single dimensional matrix.",examples:["a = [1, 2, 3; 4, 5, 6]","size(a)","b = flatten(a)","size(b)"],seealso:["concat","resize","size","squeeze"]}},function(e,t){e.exports={name:"filter",category:"Matrix",syntax:["filter(x, test)"],description:"Filter items in a matrix.",examples:["isPositive(x) = x > 0","filter([6, -2, -1, 4, 3], isPositive)","filter([6, -2, 0, 1, 0], x != 0)"],seealso:["sort","map","forEach"]}},function(e,t){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"dot",category:"Matrix",syntax:["dot(A, B)","A * B"],description:"Calculate the dot product of two vectors. The dot product of A = [a1, a2, a3, ..., an] and B = [b1, b2, b3, ..., bn] is defined as dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn",examples:["dot([2, 4, 1], [2, 2, 3])","[2, 4, 1] * [2, 2, 3]"],seealso:["multiply","cross"]}},function(e,t){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"cross",category:"Matrix",syntax:["cross(A, B)"],description:"Calculate the cross product for two vectors in three dimensional space.",examples:["cross([1, 1, 0],  [0, 1, 1])","cross([3, -3, 1], [4, 9, 2])","cross([2, 3, 4],  [5, 6, 7])"],seealso:["multiply","dot"]}},function(e,t){e.exports={name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the last dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","concat(A, B, 1)","concat(A, B, 2)"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"xor",category:"Logical",syntax:["x xor y","xor(x, y)"],description:"Logical exclusive or, xor. Test whether one and only one value is defined with a nonzero/nonempty value.",examples:["true xor false","false xor false","true xor true","0 xor 4"],seealso:["not","and","or"]}},function(e,t){e.exports={name:"or",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical or. Test if at least one value is defined with a nonzero/nonempty value.",examples:["true or false","false or false","0 or 4"],seealso:["not","and","xor"]}},function(e,t){e.exports={name:"not",category:"Logical",syntax:["not x","not(x)"],description:"Logical not. Flips the boolean value of given argument.",examples:["not true","not false","not 2","not 0"],seealso:["and","or","xor"]}},function(e,t){e.exports={name:"and",category:"Logical",syntax:["x and y","and(x, y)"],description:"Logical and. Test whether two values are both defined with a nonzero/nonempty value.",examples:["true and false","true and true","2 and 4"],seealso:["not","or","xor"]}},function(e,t){e.exports={name:"intersect",category:"Geometry",syntax:["intersect(expr1, expr2, expr3, expr4)","intersect(expr1, expr2, expr3)"],description:"Computes the intersection point of lines and/or planes.",examples:["intersect([0, 0], [10, 10], [10, 0], [0, 10])","intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6])"],seealso:[]}},function(e,t){e.exports={name:"distance",category:"Geometry",syntax:["distance([x1, y1], [x2, y2])","distance([[x1, y1], [x2, y2])"],description:"Calculates the Euclidean distance between two points.",examples:["distance([0,0], [4,4])","distance([[0,0], [4,4]])"],seealso:[]}},function(e,t){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e,t){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e,t){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e,t){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e,t){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e,t){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]}},function(e,t){e.exports={name:"typed",category:"Core",syntax:["typed(signatures)","typed(name, signatures)"],description:"Create a typed function.",examples:['double = typed({ "number, number": f(x)=x+x })',"double(2)",'double("hello")'],seealso:[]}},function(e,t){e.exports={name:"import",category:"Core",syntax:["import(functions)","import(functions, options)"],description:"Import functions or constants from an object.",examples:["import({myFn: f(x)=x^2, myConstant: 32 })","myFn(2)","myConstant"],seealso:[]}},function(e,t){e.exports={name:"config",category:"Core",syntax:["config()","config(options)"],description:"Get configuration or change configuration.",examples:["config()","1/3 + 1/4",'config({number: "Fraction"})',"1/3 + 1/4"],seealso:[]}},function(e,t){e.exports={name:"stirlingS2",category:"Combinatorics",syntax:["stirlingS2(n, k)"],description:"he Stirling numbers of the second kind, counts the number of ways to partition a set of n labelled objects into k nonempty unlabelled subsets. `stirlingS2` only takes integer arguments. The following condition must be enforced: k <= n. If n = k or k = 1, then s(n,k) = 1.",examples:["stirlingS2(5, 3)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"composition",category:"Combinatorics",syntax:["composition(n, k)"],description:"The composition counts of n into k parts. composition only takes integer arguments. The following condition must be enforced: k <= n.",examples:["composition(5, 3)"],seealso:["combinations"]}},function(e,t){e.exports={name:"catalan",category:"Combinatorics",syntax:["catalan(n)"],description:"The Catalan Numbers enumerate combinatorial structures of many different types. catalan only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["catalan(3)","catalan(8)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"bellNumbers",category:"Combinatorics",syntax:["bellNumbers(n)"],description:"The Bell Numbers count the number of partitions of a set. A partition is a pairwise disjoint subset of S whose union is S. `bellNumbers` only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["bellNumbers(3)","bellNumbers(8)"],seealso:["stirlingS2"]}},function(e,t){e.exports={name:"rightLogShift",category:"Bitwise",syntax:["x >>> y","rightLogShift(x, y)"],description:"Bitwise right logical shift of a value x by y number of bits.",examples:["8 >>> 1","4 << 1","-12 >>> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightArithShift"]}},function(e,t){e.exports={name:"rightArithShift",category:"Bitwise",syntax:["x >> y","rightArithShift(x, y)"],description:"Bitwise right arithmetic shift of a value x by y number of bits.",examples:["8 >> 1","4 << 1","-12 >> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightLogShift"]}},function(e,t){e.exports={name:"leftShift",category:"Bitwise",syntax:["x << y","leftShift(x, y)"],description:"Bitwise left logical shift of a value x by y number of bits.",examples:["4 << 1","8 >> 1"],seealso:["bitAnd","bitNot","bitOr","bitXor","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitXor",category:"Bitwise",syntax:["bitXor(x, y)"],description:"Bitwise XOR operation, exclusive OR. Performs the logical exclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if only the first bit is 1 or only the second bit is 1, but will be 0 if both are 0 or both are 1.",examples:["bitOr(1, 2)","bitXor([2, 3, 4], 4)"],seealso:["bitAnd","bitNot","bitOr","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitOr",category:"Bitwise",syntax:["x | y","bitOr(x, y)"],description:"Bitwise OR operation. Performs the logical inclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if the first bit is 1 or the second bit is 1 or both bits are 1, otherwise, the result is 0.",examples:["5 | 3","bitOr([1, 2, 3], 4)"],seealso:["bitAnd","bitNot","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitNot",category:"Bitwise",syntax:["~x","bitNot(x)"],description:"Bitwise NOT operation. Performs a logical negation on each bit of the given value. Bits that are 0 become 1, and those that are 1 become 0.",examples:["~1","~2","bitNot([2, -3, 4])"],seealso:["bitAnd","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitAnd",category:"Bitwise",syntax:["x & y","bitAnd(x, y)"],description:"Bitwise AND operation. Performs the logical AND operation on each pair of the corresponding bits of the two given values by multiplying them. If both bits in the compared position are 1, the bit in the resulting binary representation is 1, otherwise, the result is 0",examples:["5 & 3","bitAnd(53, 131)","[1, 12, 31] & 42"],seealso:["bitNot","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values. The result is an array [d, x, y] with 3 entries, where d is the greatest common divisor, and d = x * a + y * b.",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e,t){e.exports={name:"unaryPlus",category:"Operators",syntax:["+x","unaryPlus(x)"],description:"Converts booleans and strings to numbers.",examples:["+true",'+"2"'],seealso:["add","subtract","unaryMinus"]}},function(e,t){e.exports={name:"unaryMinus",category:"Operators",syntax:["-x","unaryMinus(x)"],description:"Inverse the sign of a value. Converts booleans and strings to numbers.",examples:["-4.5","-(-5.6)",'-"22"'],seealso:["add","subtract","unaryPlus"]}},function(e,t){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["a = 5.3 - 2","a + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e,t){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e,t){e.exports={name:"sqrtm",category:"Arithmetic",syntax:["sqrtm(x)"],description:"Calculate the principal square root of a square matrix. The principal square root matrix `X` of another matrix `A` is such that `X * X = A`.",examples:["sqrtm([[1, 2], [3, 4]])"],seealso:["sqrt","abs","square","multiply"]}},function(e,t){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","sqrtm","multiply"]}},function(e,t){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e,t){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e,t){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply"]}},function(e,t){e.exports={name:"nthRoot",category:"Arithmetic",syntax:["nthRoot(a)","nthRoot(a, root)"],description:'Calculate the nth root of a value. The principal nth root of a positive real number A, is the positive real solution of the equation "x^root = A".',examples:["4 ^ 3","nthRoot(64, 3)","nthRoot(9, 2)","sqrt(9)"],seealso:["sqrt","pow"]}},function(e,t){e.exports={name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i)","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)",'norm([[1, 2], [3, 4]], "inf")','norm([[1, 2], [3, 4]], "fro")']}},function(e,t){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["a = 2.1 * 3.4","a / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e,t){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]}},function(e,t){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]}},function(e,t){e.exports={name:"log1p",category:"Arithmetic",syntax:["log1p(x)","log1p(x, base)"],description:"Calculate the logarithm of a `value+1`",examples:["log1p(2.5)","exp(log1p(1.4))","pow(10, 4)","log1p(9999, 10)","log1p(9999) / log(10)"],seealso:["exp","log","log2","log10"]}},function(e,t){e.exports={name:"log2",category:"Arithmetic",syntax:["log2(x)"],description:"Calculate the 2-base of a value. This is the same as calculating `log(x, 2)`.",examples:["log2(0.03125)","log2(16)","log2(16) / log2(2)","pow(2, 4)"],seealso:["exp","log1p","log","log10"]}},function(e,t){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log1p","log2","log10"]}},function(e,t){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e,t){e.exports={name:"hypot",category:"Arithmetic",syntax:["hypot(a, b, c, ...)","hypot([a, b, c, ...])"],description:"Calculate the hypotenusa of a list with values. ",examples:["hypot(3, 4)","sqrt(3^2 + 4^2)","hypot(-2)","hypot([3, 4, 5])"],seealso:["abs","norm"]}},function(e,t){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e,t){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e,t){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e,t){e.exports={name:"expm1",category:"Arithmetic",syntax:["expm1(x)"],description:"Calculate the value of subtracting 1 from the exponential value.",examples:["expm1(2)","pow(e, 2) - 1","log(expm1(2) + 1)"],seealso:["exp","pow","log"]}},function(e,t){e.exports={name:"expm",category:"Arithmetic",syntax:["exp(x)"],description:"Compute the matrix exponential, expm(A) = e^A. The matrix must be square. Not to be confused with exp(a), which performs element-wise exponentiation.",examples:["expm([[0,2],[0,0]])"],seealso:["exp"]}},function(e,t){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["expm","expm1","pow","log"]}},function(e,t){e.exports={name:"dotpow",category:"Operators",syntax:["x .^ y","dotpow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e,t){e.exports={name:"dotMultiply",category:"Operators",syntax:["x .* y","dotMultiply(x, y)"],description:"Multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","dotDivide"]}},function(e,t){e.exports={name:"dotDivide",category:"Operators",syntax:["x ./ y","dotDivide(x, y)"],description:"Divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","dotMultiply","divide"]}},function(e,t){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["a = 2 / 3","a * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e,t){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e,t){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e,t){e.exports={name:"cbrt",category:"Arithmetic",syntax:["cbrt(x)","cbrt(x, allRoots)"],description:"Compute the cubic root value. If x = y * y * y, then y is the cubic root of x. When `x` is a number or complex number, an optional second argument `allRoots` can be provided to return all three cubic roots. If not provided, the principal root is returned",examples:["cbrt(64)","cube(4)","cbrt(-8)","cbrt(2 + 3i)","cbrt(8i)","cbrt(8i, true)","cbrt(27 m^3)"],seealso:["square","sqrt","cube","multiply"]}},function(e,t){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["a = 2.1 + 3.6","a - 3.6","3 + 2i","3 cm + 2 inch",'"2.3" + "4"'],seealso:["subtract"]}},function(e,t){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e,t){e.exports={name:"qr",category:"Algebra",syntax:["qr(A)"],description:"Calculates the Matrix QR decomposition. Matrix `A` is decomposed in two matrices (`Q`, `R`) where `Q` is an orthogonal matrix and `R` is an upper triangular matrix.",examples:["qr([[1, -1,  4], [1,  4, -2], [1,  4,  2], [1,  -1, 0]])"],seealso:["lup","slu","matrix"]}},function(e,t){e.exports={name:"usolve",category:"Algebra",syntax:["x=usolve(U, b)"],description:"Solves the linear system U * x = b where U is an [n x n] upper triangular matrix and b is a [n] column vector.",examples:["x=usolve(sparse([1, 1, 1, 1; 0, 1, 1, 1; 0, 0, 1, 1; 0, 0, 0, 1]), [1; 2; 3; 4])"],seealso:["lup","lusolve","lsolve","matrix","sparse"]}},function(e,t){e.exports={name:"slu",category:"Algebra",syntax:["slu(A, order, threshold)"],description:"Calculate the Matrix LU decomposition with full pivoting. Matrix A is decomposed in two matrices (L, U) and two permutation vectors (pinv, q) where P * A * Q = L * U",examples:["slu(sparse([4.5, 0, 3.2, 0; 3.1, 2.9, 0, 0.9; 0, 1.7, 3, 0; 3.5, 0.4, 0, 1]), 1, 0.001)"],seealso:["lusolve","lsolve","usolve","matrix","sparse","lup","qr"]}},function(e,t){e.exports={name:"rationalize",category:"Algebra",syntax:["rationalize(expr)","rationalize(expr, scope)","rationalize(expr, scope, detailed)"],description:"Transform a rationalizable expression in a rational fraction. If rational fraction is one variable polynomial then converts the numerator and denominator in canonical form, with decreasing exponents, returning the coefficients of numerator.",examples:['rationalize("2x/y - y/(x+1)")','rationalize("2x/y - y/(x+1)", true)'],seealso:["simplify"]}},function(e,t){e.exports={name:"simplify",category:"Algebra",syntax:["simplify(expr)","simplify(expr, rules)"],description:"Simplify an expression tree.",examples:['simplify("3 + 2 / 4")','simplify("2x + x")','f = parse("x * (x + 2 + x)")',"simplified = simplify(f)","simplified.eval({x: 2})"],seealso:["derivative","parse","eval"]}},function(e,t){e.exports={name:"lusolve",category:"Algebra",syntax:["x=lusolve(A, b)","x=lusolve(lu, b)"],description:"Solves the linear system A * x = b where A is an [n x n] matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lusolve(a, b)"],seealso:["lup","slu","lsolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"lup",category:"Algebra",syntax:["lup(m)"],description:"Calculate the Matrix LU decomposition with partial pivoting. Matrix A is decomposed in three matrices (L, U, P) where P * A = L * U",examples:["lup([[2, 1], [1, 4]])","lup(matrix([[2, 1], [1, 4]]))","lup(sparse([[2, 1], [1, 4]]))"],seealso:["lusolve","lsolve","usolve","matrix","sparse","slu","qr"]}},function(e,t){e.exports={name:"lsolve",category:"Algebra",syntax:["x=lsolve(L, b)"],description:"Solves the linear system L * x = b where L is an [n x n] lower triangular matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lsolve(a, b)"],seealso:["lup","lusolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"derivative",category:"Algebra",syntax:["derivative(expr, variable)","derivative(expr, variable, {simplify: boolean})"],description:"Takes the derivative of an expression expressed in parser Nodes. The derivative will be taken over the supplied variable in the second parameter. If there are multiple variables in the expression, it will return a partial derivative.",examples:['derivative("2x^3", "x")','derivative("2x^3", "x", {simplify: false})','derivative("2x^2 + 3x + 4", "x")','derivative("sin(2x)", "x")','f = parse("x^2 + x")','x = parse("x")',"df = derivative(f, x)","df.eval({x: 3})"],seealso:["simplify","parse","eval"]}},function(e,t){e.exports={name:"version",category:"Constants",syntax:["version"],description:"A string with the version number of math.js",examples:["version"],seealso:[]}},function(e,t){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e,t){e.exports={name:"tau",category:"Constants",syntax:["tau"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e,t){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e,t){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},function(e,t){e.exports={name:"phi",category:"Constants",syntax:["phi"],description:"Phi is the golden ratio. Two quantities are in the golden ratio if their ratio is the same as the ratio of their sum to the larger of the two quantities. Phi is defined as `(1 + sqrt(5)) / 2` and is approximately 1.618034...",examples:["phi"],seealso:[]}},function(e,t){e.exports={name:"null",category:"Constants",syntax:["null"],description:"Value null",examples:["null"],seealso:["true","false"]}},function(e,t){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e,t){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e,t){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e,t){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e,t){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e,t){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e,t){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e,t){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e,t){e.exports={name:"unit",category:"Construction",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e,t){e.exports={name:"string",category:"Construction",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e,t){e.exports={name:"splitUnit",category:"Construction",syntax:["splitUnit(unit: Unit, parts: Unit[])"],description:"Split a unit in an array of units whose sum is equal to the original unit.",examples:['splitUnit(1 m, ["feet", "inch"])'],seealso:["unit","createUnit"]}},function(e,t){e.exports={name:"sparse",category:"Construction",syntax:["sparse()","sparse([a1, b1, ...; a1, b2, ...])",'sparse([a1, b1, ...; a1, b2, ...], "number")'],description:"Create a sparse matrix.",examples:["sparse()","sparse([3, 4; 5, 6])",'sparse([3, 0; 5, 0], "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","matrix"]}},function(e,t){e.exports={name:"number",category:"Construction",syntax:["x","number(x)","number(unit, valuelessUnit)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])",'number(unit("52cm"), "m")'],seealso:["bignumber","boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t){e.exports={name:"matrix",category:"Construction",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()",'matrix("dense")',"matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])",'matrix([3, 4; 5, 6], "sparse")','matrix([3, 4; 5, 6], "sparse", "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","sparse"]}},function(e,t){e.exports={name:"index",category:"Construction",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e,t){e.exports={name:"fraction",category:"Construction",syntax:["fraction(num)","fraction(num,den)"],description:"Create a fraction from a number or from a numerator and denominator.",examples:["fraction(0.125)","fraction(1, 3) + fraction(2, 5)"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e,t){e.exports={name:"createUnit",category:"Construction",syntax:["createUnit(definitions)","createUnit(name, definition)"],description:"Create a user-defined unit and register it with the Unit type.",examples:['createUnit("foo")','createUnit("knot", {definition: "0.514444444 m/s", aliases: ["knots", "kt", "kts"]})','createUnit("mph", "1 mile/hour")'],seealso:["unit","splitUnit"]}},function(e,t){e.exports={name:"complex",category:"Construction",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"boolean",category:"Construction",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"bignumber",category:"Construction",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t,r){e.exports=[r(139),r(318),r(313),r(311),r(300),r(39),r(123)]},function(e,t){e.exports="4.3.0"},function(e,t,u){var n=u(5),c=u(143);function f(e,t,r){e[t]=r,e.expression.mathWithTransform[t]=r}function l(e,t,r){n.lazy(e,t,r),n.lazy(e.expression.mathWithTransform,t,r)}t.factory=function r(n,i,a,o,s){s.on("config",function(e,t){e.number!==t.number&&r(n,i,a,o,s)}),f(s,"true",!0),f(s,"false",!1),f(s,"null",null),f(s,"uninitialized","Error: Constant uninitialized is removed since v4.0.0. Use null instead"),"BigNumber"===i.number?(f(s,"Infinity",new n.BigNumber(1/0)),f(s,"NaN",new n.BigNumber(NaN)),l(s,"pi",function(){return c.pi(n.BigNumber)}),l(s,"tau",function(){return c.tau(n.BigNumber)}),l(s,"e",function(){return c.e(n.BigNumber)}),l(s,"phi",function(){return c.phi(n.BigNumber)}),l(s,"E",function(){return s.e}),l(s,"LN2",function(){return new n.BigNumber(2).ln()}),l(s,"LN10",function(){return new n.BigNumber(10).ln()}),l(s,"LOG2E",function(){return new n.BigNumber(1).div(new n.BigNumber(2).ln())}),l(s,"LOG10E",function(){return new n.BigNumber(1).div(new n.BigNumber(10).ln())}),l(s,"PI",function(){return s.pi}),l(s,"SQRT1_2",function(){return new n.BigNumber("0.5").sqrt()}),l(s,"SQRT2",function(){return new n.BigNumber(2).sqrt()})):(f(s,"Infinity",1/0),f(s,"NaN",NaN),f(s,"pi",Math.PI),f(s,"tau",2*Math.PI),f(s,"e",Math.E),f(s,"phi",1.618033988749895),f(s,"E",s.e),f(s,"LN2",Math.LN2),f(s,"LN10",Math.LN10),f(s,"LOG2E",Math.LOG2E),f(s,"LOG10E",Math.LOG10E),f(s,"PI",s.pi),f(s,"SQRT1_2",Math.SQRT1_2),f(s,"SQRT2",Math.SQRT2)),f(s,"i",n.Complex.I),f(s,"version",u(517))},t.lazy=!1,t.math=!0},function(e,t,r){var n=r(5).lazy;function o(e,t,r){n(e,t,r),n(e.expression.mathWithTransform,t,r)}t.factory=function(r,e,t,n,i){function a(e){var t=r.Unit.parse(e);return t.fixPrefix=!0,t}o(i,"speedOfLight",function(){return a("299792458 m s^-1")}),o(i,"gravitationConstant",function(){return a("6.6738480e-11 m^3 kg^-1 s^-2")}),o(i,"planckConstant",function(){return a("6.626069311e-34 J s")}),o(i,"reducedPlanckConstant",function(){return a("1.05457172647e-34 J s")}),o(i,"magneticConstant",function(){return a("1.2566370614e-6 N A^-2")}),o(i,"electricConstant",function(){return a("8.854187817e-12 F m^-1")}),o(i,"vacuumImpedance",function(){return a("376.730313461 ohm")}),o(i,"coulomb",function(){return a("8.9875517873681764e9 N m^2 C^-2")}),o(i,"elementaryCharge",function(){return a("1.60217656535e-19 C")}),o(i,"bohrMagneton",function(){return a("9.2740096820e-24 J T^-1")}),o(i,"conductanceQuantum",function(){return a("7.748091734625e-5 S")}),o(i,"inverseConductanceQuantum",function(){return a("12906.403721742 ohm")}),o(i,"magneticFluxQuantum",function(){return a("2.06783375846e-15 Wb")}),o(i,"nuclearMagneton",function(){return a("5.0507835311e-27 J T^-1")}),o(i,"klitzing",function(){return a("25812.807443484 ohm")}),o(i,"bohrRadius",function(){return a("5.291772109217e-11 m")}),o(i,"classicalElectronRadius",function(){return a("2.817940326727e-15 m")}),o(i,"electronMass",function(){return a("9.1093829140e-31 kg")}),o(i,"fermiCoupling",function(){return a("1.1663645e-5 GeV^-2")}),o(i,"fineStructure",function(){return.007297352569824}),o(i,"hartreeEnergy",function(){return a("4.3597443419e-18 J")}),o(i,"protonMass",function(){return a("1.67262177774e-27 kg")}),o(i,"deuteronMass",function(){return a("3.3435830926e-27 kg")}),o(i,"neutronMass",function(){return a("1.6749271613e-27 kg")}),o(i,"quantumOfCirculation",function(){return a("3.636947552024e-4 m^2 s^-1")}),o(i,"rydberg",function(){return a("10973731.56853955 m^-1")}),o(i,"thomsonCrossSection",function(){return a("6.65245873413e-29 m^2")}),o(i,"weakMixingAngle",function(){return.222321}),o(i,"efimovFactor",function(){return 22.7}),o(i,"atomicMass",function(){return a("1.66053892173e-27 kg")}),o(i,"avogadro",function(){return a("6.0221412927e23 mol^-1")}),o(i,"boltzmann",function(){return a("1.380648813e-23 J K^-1")}),o(i,"faraday",function(){return a("96485.336521 C mol^-1")}),o(i,"firstRadiation",function(){return a("3.7417715317e-16 W m^2")}),o(i,"loschmidt",function(){return a("2.686780524e25 m^-3")}),o(i,"gasConstant",function(){return a("8.314462175 J K^-1 mol^-1")}),o(i,"molarPlanckConstant",function(){return a("3.990312717628e-10 J s mol^-1")}),o(i,"molarVolume",function(){return a("2.241396820e-10 m^3 mol^-1")}),o(i,"sackurTetrode",function(){return-1.164870823}),o(i,"secondRadiation",function(){return a("1.438777013e-2 m K")}),o(i,"stefanBoltzmann",function(){return a("5.67037321e-8 W m^-2 K^-4")}),o(i,"wienDisplacement",function(){return a("2.897772126e-3 m K")}),o(i,"molarMass",function(){return a("1e-3 kg mol^-1")}),o(i,"molarMassC12",function(){return a("1.2e-2 kg mol^-1")}),o(i,"gravity",function(){return a("9.80665 m s^-2")}),o(i,"planckLength",function(){return a("1.61619997e-35 m")}),o(i,"planckMass",function(){return a("2.1765113e-8 kg")}),o(i,"planckTime",function(){return a("5.3910632e-44 s")}),o(i,"planckCharge",function(){return a("1.87554595641e-18 C")}),o(i,"planckTemperature",function(){return a("1.41683385e+32 K")})},t.lazy=!1,t.math=!0},function(e,t,r){r(0);t.name="splitUnit",t.factory=function(e,t,r,n){return n("splitUnit",{"Unit, Array":function(e,t){return e.splitUnit(t)}})}},function(e,t,r){r(0);t.name="createUnit",t.factory=function(i,e,t,r){return r("createUnit",{"Object, Object":function(e,t){return i.Unit.createUnit(e,t)},Object:function(e){return i.Unit.createUnit(e,{})},"string, Unit | string | Object, Object":function(e,t,r){var n={};return n[e]=t,i.Unit.createUnit(n,r)},"string, Unit | string | Object":function(e,t){var r={};return r[e]=t,i.Unit.createUnit(r,{})},string:function(e){var t={};return t[e]={},i.Unit.createUnit(t,{})}})}},function(e,t,r){var a=r(0);t.name="unit",t.factory=function(r,e,t,n){var i=n("unit",{Unit:function(e){return e.clone()},string:function(e){return r.Unit.isValuelessUnit(e)?new r.Unit(null,e):r.Unit.parse(e)},"number | BigNumber | Fraction | Complex, string":function(e,t){return new r.Unit(e,t)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},i}},function(e,t,G){var Z=G(9).endsWith,V=G(5).clone,W=G(143);t.name="Unit",t.path="type",t.factory=function(g,v,e,t,r){var y,x,w,u=e(G(20)),c=e(G(16)),f=e(G(21)),l=e(G(12)),p=e(G(41)),m=e(G(23)),h=e(G(142)),d=e(G(141)),b=e(G(50)),i=e(G(60)),o=e(G(140)),N=e(G(49)),n=e(G(87)),a=e(G(147));function M(e,t){if(!(this instanceof M))throw new Error("Constructor must be called with the new operator");if(null!=e&&!i(e)&&!g.isComplex(e))throw new TypeError("First parameter in Unit constructor must be number, BigNumber, Fraction, Complex, or undefined");if(null!=t&&("string"!=typeof t||""===t))throw new TypeError("Second parameter in Unit constructor must be a string");if(null!=t){var r=M.parse(t);this.units=r.units,this.dimensions=r.dimensions}else{this.units=[{unit:U,prefix:B.NONE,power:0}],this.dimensions=[];for(var n=0;n<P.length;n++)this.dimensions[n]=0}this.value=null!=e?this._normalize(e):null,this.fixPrefix=!1,this.isUnitListSimplified=!0}function E(){for(;" "==w||"\t"==w;)A()}function s(e){return"0"<=e&&e<="9"}function A(){x++,w=y.charAt(x)}function O(e){x=e,w=y.charAt(x)}function S(){var e,t,r="";if(e=x,"+"==w?A():"-"==w&&(r+=w,A()),!("0"<=(t=w)&&t<="9"||"."==t))return O(e),null;if("."==w){if(r+=w,A(),!s(w))return O(e),null}else{for(;s(w);)r+=w,A();"."==w&&(r+=w,A())}for(;s(w);)r+=w,A();if("E"==w||"e"==w){var n="",i=x;if(n+=w,A(),"+"!=w&&"-"!=w||(n+=w,A()),!s(w))return O(i),r;for(r+=n;s(w);)r+=w,A()}return r}function _(){for(var e="",t=y.charCodeAt(x);48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122;)e+=w,A(),t=y.charCodeAt(x);return(65<=(t=e.charCodeAt(0))&&t<=90||97<=t&&t<=122)&&e||null}function T(e){return w===e?(A(),e):null}function C(e){if(k.hasOwnProperty(e))return{unit:n=k[e],prefix:r=n.prefixes[""]};for(var t in k)if(k.hasOwnProperty(t)&&Z(e,t)){var r,n=k[t],i=e.length-t.length,a=e.substring(0,i);if(void 0!==(r=n.prefixes.hasOwnProperty(a)?n.prefixes[a]:void 0))return{unit:n,prefix:r}}return null}M.prototype.type="Unit",M.prototype.isUnit=!0,M.parse=function(e,t){if(t=t||{},x=-1,w="","string"!=typeof(y=e))throw new TypeError("Invalid argument in Unit.parse, string expected");var r=new M,n=1,i=!(r.units=[]);A(),E();var a=S(),o=null;a&&(o="BigNumber"===v.number?new g.BigNumber(a):"Fraction"===v.number?new g.Fraction(a):parseFloat(a),E(),T("*")?(n=1,i=!0):T("/")&&(n=-1,i=!0));for(var s=[],u=1;;){for(E();"("===w;)s.push(n),u*=n,n=1,A(),E();if(!w)break;var c=w,f=_();if(null==f)throw new SyntaxError('Unexpected "'+c+'" in "'+y+'" at index '+x.toString());var l=C(f);if(null==l)throw new SyntaxError('Unit "'+f+'" not found.');var p=n*u;if(E(),T("^")){E();var m=S();if(null==m)throw new SyntaxError('In "'+e+'", "^" must be followed by a floating-point number');p*=m}r.units.push({unit:l.unit,prefix:l.prefix,power:p});for(var h=0;h<P.length;h++)r.dimensions[h]+=(l.unit.dimensions[h]||0)*p;for(E();")"===w;){if(0===s.length)throw new SyntaxError('Unmatched ")" in "'+y+'" at index '+x.toString());u/=s.pop(),A(),E()}if(i=!1,T("*")?(n=1,i=!0):T("/")?(n=-1,i=!0):n=1,l.unit.base){var d=l.unit.base.key;L.auto[d]={unit:l.unit,prefix:l.prefix}}}if(E(),w)throw new SyntaxError('Could not parse: "'+e+'"');if(i)throw new SyntaxError('Trailing characters: "'+e+'"');if(0!==s.length)throw new SyntaxError('Unmatched "(" in "'+y+'"');if(0==r.units.length&&!t.allowNoUnits)throw new SyntaxError('"'+e+'" contains no units');return r.value=null!=o?r._normalize(o):null,r},M.prototype.clone=function(){var e=new M;e.fixPrefix=this.fixPrefix,e.isUnitListSimplified=this.isUnitListSimplified,e.value=V(this.value),e.dimensions=this.dimensions.slice(0),e.units=[];for(var t=0;t<this.units.length;t++)for(var r in e.units[t]={},this.units[t])this.units[t].hasOwnProperty(r)&&(e.units[t][r]=this.units[t][r]);return e},M.prototype._isDerived=function(){return 0!==this.units.length&&(1<this.units.length||1e-15<Math.abs(this.units[0].power-1))},M.prototype._normalize=function(e){var t,r,n,i,a;if(null==e||0===this.units.length)return e;if(this._isDerived()){var o=e;a=M._getNumberConverter(N(e));for(var s=0;s<this.units.length;s++)t=a(this.units[s].unit.value),i=a(this.units[s].prefix.value),n=a(this.units[s].power),o=f(o,p(f(t,i),n));return o}return t=(a=M._getNumberConverter(N(e)))(this.units[0].unit.value),r=a(this.units[0].unit.offset),i=a(this.units[0].prefix.value),f(u(e,r),f(t,i))},M.prototype._denormalize=function(e,t){var r,n,i,a,o;if(null==e||0===this.units.length)return e;if(this._isDerived()){var s=e;o=M._getNumberConverter(N(e));for(var u=0;u<this.units.length;u++)r=o(this.units[u].unit.value),a=o(this.units[u].prefix.value),i=o(this.units[u].power),s=l(s,p(f(r,a),i));return s}return r=(o=M._getNumberConverter(N(e)))(this.units[0].unit.value),a=o(this.units[0].prefix.value),n=o(this.units[0].unit.offset),c(l(l(e,r),null==t?a:t),n)},M.isValuelessUnit=function(e){return null!=C(e)},M.prototype.hasBase=function(e){if("string"==typeof e&&(e=R[e]),!e)return!1;for(var t=0;t<P.length;t++)if(1e-12<Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0)))return!1;return!0},M.prototype.equalBase=function(e){for(var t=0;t<P.length;t++)if(1e-12<Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0)))return!1;return!0},M.prototype.equals=function(e){return this.equalBase(e)&&b(this.value,e.value)},M.prototype.multiply=function(e){for(var t=this.clone(),r=0;r<P.length;r++)t.dimensions[r]=(this.dimensions[r]||0)+(e.dimensions[r]||0);for(r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=f(a,o)}else t.value=null;return t.isUnitListSimplified=!1,z(t)},M.prototype.divide=function(e){for(var t=this.clone(),r=0;r<P.length;r++)t.dimensions[r]=(this.dimensions[r]||0)-(e.dimensions[r]||0);for(r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];n.power=-n.power,t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=l(a,o)}else t.value=null;return t.isUnitListSimplified=!1,z(t)},M.prototype.pow=function(e){for(var t=this.clone(),r=0;r<P.length;r++)t.dimensions[r]=(this.dimensions[r]||0)*e;for(r=0;r<t.units.length;r++)t.units[r].power*=e;return null!=t.value?t.value=p(t.value,e):t.value=null,t.isUnitListSimplified=!1,z(t)};var z=function(e){return e.equalBase(R.NONE)&&null!==e.value&&!v.predictable?e.value:e};M.prototype.abs=function(){var e=this.clone();for(var t in e.value=null!==e.value?m(e.value):null,e.units)"VA"!==e.units[t].unit.name&&"VAR"!==e.units[t].unit.name||(e.units[t].unit=k.W);return e},M.prototype.to=function(e){var t,r=null==this.value?this._normalize(1):this.value;if("string"==typeof e){if(t=M.parse(e),!this.equalBase(t))throw new Error("Units do not match");if(null!==t.value)throw new Error("Cannot convert to a unit with a value");return t.value=V(r),t.fixPrefix=!0,t.isUnitListSimplified=!0,t}if(g.isUnit(e)){if(!this.equalBase(e))throw new Error("Units do not match");if(null!==e.value)throw new Error("Cannot convert to a unit with a value");return(t=e.clone()).value=V(r),t.fixPrefix=!0,t.isUnitListSimplified=!0,t}throw new Error("String or Unit expected as parameter")},M.prototype.toNumber=function(e){return n(this.toNumeric(e))},M.prototype.toNumeric=function(e){var t=this;return e&&(t=this.to(e)),t.simplifyUnitListLazy(),t._isDerived()?t._denormalize(t.value):t._denormalize(t.value,t.units[0].prefix.value)},M.prototype.toString=function(){return this.format()},M.prototype.toJSON=function(){return{mathjs:"Unit",value:this._denormalize(this.value),unit:this.formatUnits(),fixPrefix:this.fixPrefix}},M.fromJSON=function(e){var t=new M(e.value,e.unit);return t.fixPrefix=e.fixPrefix||!1,t},M.prototype.valueOf=M.prototype.toString,M.prototype.simplifyUnitListLazy=function(){if(!this.isUnitListSimplified&&null!=this.value){var e,t,r=[];for(var n in F)if(this.hasBase(R[n])){e=n;break}if("NONE"===e)this.units=[];else if(e&&F.hasOwnProperty(e)&&(t=F[e]),t)this.units=[{unit:t.unit,prefix:t.prefix,power:1}];else{for(var i=!1,a=0;a<P.length;a++){var o=P[a];1e-12<Math.abs(this.dimensions[a]||0)&&(F.hasOwnProperty(o)?r.push({unit:F[o].unit,prefix:F[o].prefix,power:this.dimensions[a]||0}):i=!0)}r.length<this.units.length&&!i&&(this.units=r)}this.isUnitListSimplified=!0}},M.prototype.toSI=function(){for(var e=this.clone(),t=[],r=0;r<P.length;r++){var n=P[r];if(1e-12<Math.abs(e.dimensions[r]||0)){if(!L.si.hasOwnProperty(n))throw new Error("Cannot express custom unit "+n+" in SI units");t.push({unit:L.si[n].unit,prefix:L.si[n].prefix,power:e.dimensions[r]||0})}}return e.units=t,e.isUnitListSimplified=!0,e},M.prototype.formatUnits=function(){this.simplifyUnitListLazy();for(var e="",t="",r=0,n=0,i=0;i<this.units.length;i++)0<this.units[i].power?(r++,e+=" "+this.units[i].prefix.name+this.units[i].unit.name,1e-15<Math.abs(this.units[i].power-1)&&(e+="^"+this.units[i].power)):this.units[i].power<0&&n++;if(0<n)for(i=0;i<this.units.length;i++)this.units[i].power<0&&(0<r?(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,1e-15<Math.abs(this.units[i].power+1)&&(t+="^"+-this.units[i].power)):(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,t+="^"+this.units[i].power));e=e.substr(1),t=t.substr(1),1<r&&0<n&&(e="("+e+")"),1<n&&0<r&&(t="("+t+")");var a=e;return 0<r&&0<n&&(a+=" / "),a+=t},M.prototype.format=function(e){this.simplifyUnitListLazy();var t=!1;for(var r in void 0!==this.value&&null!==this.value&&g.isComplex(this.value)&&(t=Math.abs(this.value.re)<1e-14,Math.abs(this.value.im)),this.units)this.units[r].unit&&("VA"===this.units[r].unit.name&&t?this.units[r].unit=k.VAR:"VAR"!==this.units[r].unit.name||t||(this.units[r].unit=k.VA));1!==this.units.length||this.fixPrefix||Math.abs(this.units[0].power-Math.round(this.units[0].power))<1e-14&&(this.units[0].prefix=this._bestPrefix());var n=this._denormalize(this.value),i=null!==this.value?o(n,e||{}):"",a=this.formatUnits();return this.value&&g.isComplex(this.value)&&(i="("+i+")"),0<a.length&&0<i.length&&(i+=" "),i+=a},M.prototype._bestPrefix=function(){if(1!==this.units.length)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");if(1e-14<=Math.abs(this.units[0].power-Math.round(this.units[0].power)))throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");var e=null!==this.value?m(this.value):0,t=m(this.units[0].unit.value),r=this.units[0].prefix;if(0===e)return r;var n=this.units[0].power,i=Math.log(e/Math.pow(r.value*t,n))/Math.LN10-1.2;if(-2.200001<i&&i<1.800001)return r;i=Math.abs(i);var a=this.units[0].unit.prefixes;for(var o in a)if(a.hasOwnProperty(o)){var s=a[o];if(s.scientific){var u=Math.abs(Math.log(e/Math.pow(s.value*t,n))/Math.LN10-1.2);(u<i||u===i&&s.name.length<r.name.length)&&(r=s,i=u)}}return r};var B={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:(M.prototype.splitUnit=function(e){for(var t=this.clone(),r=[],n=0;n<e.length&&(t=t.to(e[n]),n!=e.length-1);n++){var i=t.toNumeric(),a=d(i),o=new M(b(a,i)?a:h(t.toNumeric()),e[n].toString());r.push(o),t=c(t,o)}var s=0;for(n=0;n<r.length;n++)s=u(s,r[n].value);return b(s,this.value)&&(t.value=0),r.push(t),r},!1)},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-48,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}},BTU:{"":{name:"",value:1,scientific:!0},MM:{name:"MM",value:1e6,scientific:!0}},SHORTLONG:{}};for(var I in B.SHORT)B.SHORT.hasOwnProperty(I)&&(B.SHORTLONG[I]=B.SHORT[I]);for(var I in B.LONG)B.LONG.hasOwnProperty(I)&&(B.SHORTLONG[I]=B.LONG[I]);var P=["MASS","LENGTH","TIME","CURRENT","TEMPERATURE","LUMINOUS_INTENSITY","AMOUNT_OF_SUBSTANCE","ANGLE","BIT"],R={NONE:{dimensions:[0,0,0,0,0,0,0,0,0]},MASS:{dimensions:[1,0,0,0,0,0,0,0,0]},LENGTH:{dimensions:[0,1,0,0,0,0,0,0,0]},TIME:{dimensions:[0,0,1,0,0,0,0,0,0]},CURRENT:{dimensions:[0,0,0,1,0,0,0,0,0]},TEMPERATURE:{dimensions:[0,0,0,0,1,0,0,0,0]},LUMINOUS_INTENSITY:{dimensions:[0,0,0,0,0,1,0,0,0]},AMOUNT_OF_SUBSTANCE:{dimensions:[0,0,0,0,0,0,1,0,0]},FORCE:{dimensions:[1,1,-2,0,0,0,0,0,0]},SURFACE:{dimensions:[0,2,0,0,0,0,0,0,0]},VOLUME:{dimensions:[0,3,0,0,0,0,0,0,0]},ENERGY:{dimensions:[1,2,-2,0,0,0,0,0,0]},POWER:{dimensions:[1,2,-3,0,0,0,0,0,0]},PRESSURE:{dimensions:[1,-1,-2,0,0,0,0,0,0]},ELECTRIC_CHARGE:{dimensions:[0,0,1,1,0,0,0,0,0]},ELECTRIC_CAPACITANCE:{dimensions:[-1,-2,4,2,0,0,0,0,0]},ELECTRIC_POTENTIAL:{dimensions:[1,2,-3,-1,0,0,0,0,0]},ELECTRIC_RESISTANCE:{dimensions:[1,2,-3,-2,0,0,0,0,0]},ELECTRIC_INDUCTANCE:{dimensions:[1,2,-2,-2,0,0,0,0,0]},ELECTRIC_CONDUCTANCE:{dimensions:[-1,-2,3,2,0,0,0,0,0]},MAGNETIC_FLUX:{dimensions:[1,2,-2,-1,0,0,0,0,0]},MAGNETIC_FLUX_DENSITY:{dimensions:[1,0,-2,-1,0,0,0,0,0]},FREQUENCY:{dimensions:[0,0,-1,0,0,0,0,0,0]},ANGLE:{dimensions:[0,0,0,0,0,0,0,1,0]},BIT:{dimensions:[0,0,0,0,0,0,0,0,1]}};for(var I in R)R[I].key=I;var U={name:"",base:{},value:1,offset:0,dimensions:[0,0,0,0,0,0,0,0,0]},k={meter:{name:"meter",base:R.LENGTH,prefixes:B.LONG,value:1,offset:0},inch:{name:"inch",base:R.LENGTH,prefixes:B.NONE,value:.0254,offset:0},foot:{name:"foot",base:R.LENGTH,prefixes:B.NONE,value:.3048,offset:0},yard:{name:"yard",base:R.LENGTH,prefixes:B.NONE,value:.9144,offset:0},mile:{name:"mile",base:R.LENGTH,prefixes:B.NONE,value:1609.344,offset:0},link:{name:"link",base:R.LENGTH,prefixes:B.NONE,value:.201168,offset:0},rod:{name:"rod",base:R.LENGTH,prefixes:B.NONE,value:5.02921,offset:0},chain:{name:"chain",base:R.LENGTH,prefixes:B.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:R.LENGTH,prefixes:B.NONE,value:1e-10,offset:0},m:{name:"m",base:R.LENGTH,prefixes:B.SHORT,value:1,offset:0},in:{name:"in",base:R.LENGTH,prefixes:B.NONE,value:.0254,offset:0},ft:{name:"ft",base:R.LENGTH,prefixes:B.NONE,value:.3048,offset:0},yd:{name:"yd",base:R.LENGTH,prefixes:B.NONE,value:.9144,offset:0},mi:{name:"mi",base:R.LENGTH,prefixes:B.NONE,value:1609.344,offset:0},li:{name:"li",base:R.LENGTH,prefixes:B.NONE,value:.201168,offset:0},rd:{name:"rd",base:R.LENGTH,prefixes:B.NONE,value:5.02921,offset:0},ch:{name:"ch",base:R.LENGTH,prefixes:B.NONE,value:20.1168,offset:0},mil:{name:"mil",base:R.LENGTH,prefixes:B.NONE,value:254e-7,offset:0},m2:{name:"m2",base:R.SURFACE,prefixes:B.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:R.SURFACE,prefixes:B.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:R.SURFACE,prefixes:B.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:R.SURFACE,prefixes:B.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:R.SURFACE,prefixes:B.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:R.SURFACE,prefixes:B.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:R.SURFACE,prefixes:B.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:R.SURFACE,prefixes:B.NONE,value:6.4516e-10,offset:0},acre:{name:"acre",base:R.SURFACE,prefixes:B.NONE,value:4046.86,offset:0},hectare:{name:"hectare",base:R.SURFACE,prefixes:B.NONE,value:1e4,offset:0},m3:{name:"m3",base:R.VOLUME,prefixes:B.CUBIC,value:1,offset:0},L:{name:"L",base:R.VOLUME,prefixes:B.SHORT,value:.001,offset:0},l:{name:"l",base:R.VOLUME,prefixes:B.SHORT,value:.001,offset:0},litre:{name:"litre",base:R.VOLUME,prefixes:B.LONG,value:.001,offset:0},cuin:{name:"cuin",base:R.VOLUME,prefixes:B.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:R.VOLUME,prefixes:B.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:R.VOLUME,prefixes:B.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:R.VOLUME,prefixes:B.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:R.VOLUME,prefixes:B.NONE,value:15e-6,offset:0},drop:{name:"drop",base:R.VOLUME,prefixes:B.NONE,value:5e-8,offset:0},gtt:{name:"gtt",base:R.VOLUME,prefixes:B.NONE,value:5e-8,offset:0},minim:{name:"minim",base:R.VOLUME,prefixes:B.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:R.VOLUME,prefixes:B.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:R.VOLUME,prefixes:B.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:R.VOLUME,prefixes:B.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:R.VOLUME,prefixes:B.NONE,value:1e-6,offset:0},cup:{name:"cup",base:R.VOLUME,prefixes:B.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:R.VOLUME,prefixes:B.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:R.VOLUME,prefixes:B.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:R.VOLUME,prefixes:B.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:R.VOLUME,prefixes:B.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:R.VOLUME,prefixes:B.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:R.VOLUME,prefixes:B.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:R.VOLUME,prefixes:B.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:R.VOLUME,prefixes:B.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:R.VOLUME,prefixes:B.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:R.VOLUME,prefixes:B.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:R.VOLUME,prefixes:B.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:R.VOLUME,prefixes:B.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:R.VOLUME,prefixes:B.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:R.VOLUME,prefixes:B.NONE,value:.1173478,offset:0},obl:{name:"obl",base:R.VOLUME,prefixes:B.NONE,value:.1589873,offset:0},g:{name:"g",base:R.MASS,prefixes:B.SHORT,value:.001,offset:0},gram:{name:"gram",base:R.MASS,prefixes:B.LONG,value:.001,offset:0},ton:{name:"ton",base:R.MASS,prefixes:B.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:R.MASS,prefixes:B.SHORT,value:1e3,offset:0},grain:{name:"grain",base:R.MASS,prefixes:B.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:R.MASS,prefixes:B.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:R.MASS,prefixes:B.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:R.MASS,prefixes:B.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:R.MASS,prefixes:B.NONE,value:45.359237,offset:0},stick:{name:"stick",base:R.MASS,prefixes:B.NONE,value:.115,offset:0},stone:{name:"stone",base:R.MASS,prefixes:B.NONE,value:6.35029318,offset:0},gr:{name:"gr",base:R.MASS,prefixes:B.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:R.MASS,prefixes:B.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:R.MASS,prefixes:B.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:R.MASS,prefixes:B.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:R.MASS,prefixes:B.NONE,value:45.359237,offset:0},s:{name:"s",base:R.TIME,prefixes:B.SHORT,value:1,offset:0},min:{name:"min",base:R.TIME,prefixes:B.NONE,value:60,offset:0},h:{name:"h",base:R.TIME,prefixes:B.NONE,value:3600,offset:0},second:{name:"second",base:R.TIME,prefixes:B.LONG,value:1,offset:0},sec:{name:"sec",base:R.TIME,prefixes:B.LONG,value:1,offset:0},minute:{name:"minute",base:R.TIME,prefixes:B.NONE,value:60,offset:0},hour:{name:"hour",base:R.TIME,prefixes:B.NONE,value:3600,offset:0},day:{name:"day",base:R.TIME,prefixes:B.NONE,value:86400,offset:0},week:{name:"week",base:R.TIME,prefixes:B.NONE,value:604800,offset:0},month:{name:"month",base:R.TIME,prefixes:B.NONE,value:2629800,offset:0},year:{name:"year",base:R.TIME,prefixes:B.NONE,value:31557600,offset:0},decade:{name:"decade",base:R.TIME,prefixes:B.NONE,value:315576e3,offset:0},century:{name:"century",base:R.TIME,prefixes:B.NONE,value:315576e4,offset:0},millennium:{name:"millennium",base:R.TIME,prefixes:B.NONE,value:315576e5,offset:0},hertz:{name:"Hertz",base:R.FREQUENCY,prefixes:B.LONG,value:1,offset:0,reciprocal:!0},Hz:{name:"Hz",base:R.FREQUENCY,prefixes:B.SHORT,value:1,offset:0,reciprocal:!0},rad:{name:"rad",base:R.ANGLE,prefixes:B.SHORT,value:1,offset:0},radian:{name:"radian",base:R.ANGLE,prefixes:B.LONG,value:1,offset:0},deg:{name:"deg",base:R.ANGLE,prefixes:B.SHORT,value:null,offset:0},degree:{name:"degree",base:R.ANGLE,prefixes:B.LONG,value:null,offset:0},grad:{name:"grad",base:R.ANGLE,prefixes:B.SHORT,value:null,offset:0},gradian:{name:"gradian",base:R.ANGLE,prefixes:B.LONG,value:null,offset:0},cycle:{name:"cycle",base:R.ANGLE,prefixes:B.NONE,value:null,offset:0},arcsec:{name:"arcsec",base:R.ANGLE,prefixes:B.NONE,value:null,offset:0},arcmin:{name:"arcmin",base:R.ANGLE,prefixes:B.NONE,value:null,offset:0},A:{name:"A",base:R.CURRENT,prefixes:B.SHORT,value:1,offset:0},ampere:{name:"ampere",base:R.CURRENT,prefixes:B.LONG,value:1,offset:0},K:{name:"K",base:R.TEMPERATURE,prefixes:B.NONE,value:1,offset:0},degC:{name:"degC",base:R.TEMPERATURE,prefixes:B.NONE,value:1,offset:273.15},degF:{name:"degF",base:R.TEMPERATURE,prefixes:B.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:R.TEMPERATURE,prefixes:B.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:R.TEMPERATURE,prefixes:B.NONE,value:1,offset:0},celsius:{name:"celsius",base:R.TEMPERATURE,prefixes:B.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:R.TEMPERATURE,prefixes:B.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:R.TEMPERATURE,prefixes:B.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:R.AMOUNT_OF_SUBSTANCE,prefixes:B.SHORT,value:1,offset:0},mole:{name:"mole",base:R.AMOUNT_OF_SUBSTANCE,prefixes:B.LONG,value:1,offset:0},cd:{name:"cd",base:R.LUMINOUS_INTENSITY,prefixes:B.NONE,value:1,offset:0},candela:{name:"candela",base:R.LUMINOUS_INTENSITY,prefixes:B.NONE,value:1,offset:0},N:{name:"N",base:R.FORCE,prefixes:B.SHORT,value:1,offset:0},newton:{name:"newton",base:R.FORCE,prefixes:B.LONG,value:1,offset:0},dyn:{name:"dyn",base:R.FORCE,prefixes:B.SHORT,value:1e-5,offset:0},dyne:{name:"dyne",base:R.FORCE,prefixes:B.LONG,value:1e-5,offset:0},lbf:{name:"lbf",base:R.FORCE,prefixes:B.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:R.FORCE,prefixes:B.NONE,value:4.4482216152605,offset:0},kip:{name:"kip",base:R.FORCE,prefixes:B.LONG,value:4448.2216,offset:0},J:{name:"J",base:R.ENERGY,prefixes:B.SHORT,value:1,offset:0},joule:{name:"joule",base:R.ENERGY,prefixes:B.SHORT,value:1,offset:0},erg:{name:"erg",base:R.ENERGY,prefixes:B.NONE,value:1e-7,offset:0},Wh:{name:"Wh",base:R.ENERGY,prefixes:B.SHORT,value:3600,offset:0},BTU:{name:"BTU",base:R.ENERGY,prefixes:B.BTU,value:1055.05585262,offset:0},eV:{name:"eV",base:R.ENERGY,prefixes:B.SHORT,value:1602176565e-28,offset:0},electronvolt:{name:"electronvolt",base:R.ENERGY,prefixes:B.LONG,value:1602176565e-28,offset:0},W:{name:"W",base:R.POWER,prefixes:B.SHORT,value:1,offset:0},watt:{name:"watt",base:R.POWER,prefixes:B.LONG,value:1,offset:0},hp:{name:"hp",base:R.POWER,prefixes:B.NONE,value:745.6998715386,offset:0},VAR:{name:"VAR",base:R.POWER,prefixes:B.SHORT,value:a.I,offset:0},VA:{name:"VA",base:R.POWER,prefixes:B.SHORT,value:1,offset:0},Pa:{name:"Pa",base:R.PRESSURE,prefixes:B.SHORT,value:1,offset:0},psi:{name:"psi",base:R.PRESSURE,prefixes:B.NONE,value:6894.75729276459,offset:0},atm:{name:"atm",base:R.PRESSURE,prefixes:B.NONE,value:101325,offset:0},bar:{name:"bar",base:R.PRESSURE,prefixes:B.SHORTLONG,value:1e5,offset:0},torr:{name:"torr",base:R.PRESSURE,prefixes:B.NONE,value:133.322,offset:0},mmHg:{name:"mmHg",base:R.PRESSURE,prefixes:B.NONE,value:133.322,offset:0},mmH2O:{name:"mmH2O",base:R.PRESSURE,prefixes:B.NONE,value:9.80665,offset:0},cmH2O:{name:"cmH2O",base:R.PRESSURE,prefixes:B.NONE,value:98.0665,offset:0},coulomb:{name:"coulomb",base:R.ELECTRIC_CHARGE,prefixes:B.LONG,value:1,offset:0},C:{name:"C",base:R.ELECTRIC_CHARGE,prefixes:B.SHORT,value:1,offset:0},farad:{name:"farad",base:R.ELECTRIC_CAPACITANCE,prefixes:B.LONG,value:1,offset:0},F:{name:"F",base:R.ELECTRIC_CAPACITANCE,prefixes:B.SHORT,value:1,offset:0},volt:{name:"volt",base:R.ELECTRIC_POTENTIAL,prefixes:B.LONG,value:1,offset:0},V:{name:"V",base:R.ELECTRIC_POTENTIAL,prefixes:B.SHORT,value:1,offset:0},ohm:{name:"ohm",base:R.ELECTRIC_RESISTANCE,prefixes:B.SHORTLONG,value:1,offset:0},henry:{name:"henry",base:R.ELECTRIC_INDUCTANCE,prefixes:B.LONG,value:1,offset:0},H:{name:"H",base:R.ELECTRIC_INDUCTANCE,prefixes:B.SHORT,value:1,offset:0},siemens:{name:"siemens",base:R.ELECTRIC_CONDUCTANCE,prefixes:B.LONG,value:1,offset:0},S:{name:"S",base:R.ELECTRIC_CONDUCTANCE,prefixes:B.SHORT,value:1,offset:0},weber:{name:"weber",base:R.MAGNETIC_FLUX,prefixes:B.LONG,value:1,offset:0},Wb:{name:"Wb",base:R.MAGNETIC_FLUX,prefixes:B.SHORT,value:1,offset:0},tesla:{name:"tesla",base:R.MAGNETIC_FLUX_DENSITY,prefixes:B.LONG,value:1,offset:0},T:{name:"T",base:R.MAGNETIC_FLUX_DENSITY,prefixes:B.SHORT,value:1,offset:0},b:{name:"b",base:R.BIT,prefixes:B.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:R.BIT,prefixes:B.BINARY_LONG,value:1,offset:0},B:{name:"B",base:R.BIT,prefixes:B.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:R.BIT,prefixes:B.BINARY_LONG,value:8,offset:0}},q={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",lt:"l",litres:"litre",liter:"litre",liters:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",gtts:"gtt",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",lb:"lbm",lbs:"lbm",kips:"kip",acres:"acre",hectares:"hectare",sqfeet:"sqft",sqyard:"sqyd",sqmile:"sqmi",sqmiles:"sqmi",mmhg:"mmHg",mmh2o:"mmH2O",cmh2o:"cmH2O",seconds:"second",secs:"second",minutes:"minute",mins:"minute",hours:"hour",hr:"hour",hrs:"hour",days:"day",weeks:"week",months:"month",years:"year",decades:"decade",centuries:"century",millennia:"millennium",hertz:"hertz",radians:"radian",degrees:"degree",gradians:"gradian",cycles:"cycle",arcsecond:"arcsec",arcseconds:"arcsec",arcminute:"arcmin",arcminutes:"arcmin",BTUs:"BTU",watts:"watt",joules:"joule",amperes:"ampere",coulombs:"coulomb",volts:"volt",ohms:"ohm",farads:"farad",webers:"weber",teslas:"tesla",electronvolts:"electronvolt",moles:"mole"};function D(e){if("BigNumber"===e.number){var t=W.pi(g.BigNumber);k.rad.value=new g.BigNumber(1),k.deg.value=t.div(180),k.grad.value=t.div(200),k.cycle.value=t.times(2),k.arcsec.value=t.div(648e3),k.arcmin.value=t.div(10800)}else k.rad.value=1,k.deg.value=Math.PI/180,k.grad.value=Math.PI/200,k.cycle.value=2*Math.PI,k.arcsec.value=Math.PI/648e3,k.arcmin.value=Math.PI/10800;k.radian.value=k.rad.value,k.degree.value=k.deg.value,k.gradian.value=k.grad.value}D(v),r.on("config",function(e,t){e.number!==t.number&&D(e)});var L={si:{NONE:{unit:U,prefix:B.NONE[""]},LENGTH:{unit:k.m,prefix:B.SHORT[""]},MASS:{unit:k.g,prefix:B.SHORT.k},TIME:{unit:k.s,prefix:B.SHORT[""]},CURRENT:{unit:k.A,prefix:B.SHORT[""]},TEMPERATURE:{unit:k.K,prefix:B.SHORT[""]},LUMINOUS_INTENSITY:{unit:k.cd,prefix:B.SHORT[""]},AMOUNT_OF_SUBSTANCE:{unit:k.mol,prefix:B.SHORT[""]},ANGLE:{unit:k.rad,prefix:B.SHORT[""]},BIT:{unit:k.bit,prefix:B.SHORT[""]},FORCE:{unit:k.N,prefix:B.SHORT[""]},ENERGY:{unit:k.J,prefix:B.SHORT[""]},POWER:{unit:k.W,prefix:B.SHORT[""]},PRESSURE:{unit:k.Pa,prefix:B.SHORT[""]},ELECTRIC_CHARGE:{unit:k.C,prefix:B.SHORT[""]},ELECTRIC_CAPACITANCE:{unit:k.F,prefix:B.SHORT[""]},ELECTRIC_POTENTIAL:{unit:k.V,prefix:B.SHORT[""]},ELECTRIC_RESISTANCE:{unit:k.ohm,prefix:B.SHORT[""]},ELECTRIC_INDUCTANCE:{unit:k.H,prefix:B.SHORT[""]},ELECTRIC_CONDUCTANCE:{unit:k.S,prefix:B.SHORT[""]},MAGNETIC_FLUX:{unit:k.Wb,prefix:B.SHORT[""]},MAGNETIC_FLUX_DENSITY:{unit:k.T,prefix:B.SHORT[""]},FREQUENCY:{unit:k.Hz,prefix:B.SHORT[""]}}};L.cgs=JSON.parse(JSON.stringify(L.si)),L.cgs.LENGTH={unit:k.m,prefix:B.SHORT.c},L.cgs.MASS={unit:k.g,prefix:B.SHORT[""]},L.cgs.FORCE={unit:k.dyn,prefix:B.SHORT[""]},L.cgs.ENERGY={unit:k.erg,prefix:B.NONE[""]},L.us=JSON.parse(JSON.stringify(L.si)),L.us.LENGTH={unit:k.ft,prefix:B.NONE[""]},L.us.MASS={unit:k.lbm,prefix:B.NONE[""]},L.us.TEMPERATURE={unit:k.degF,prefix:B.NONE[""]},L.us.FORCE={unit:k.lbf,prefix:B.NONE[""]},L.us.ENERGY={unit:k.BTU,prefix:B.BTU[""]},L.us.POWER={unit:k.hp,prefix:B.NONE[""]},L.us.PRESSURE={unit:k.psi,prefix:B.NONE[""]},L.auto=JSON.parse(JSON.stringify(L.si));var F=L.auto;for(var I in M.setUnitSystem=function(e){if(!L.hasOwnProperty(e))throw new Error("Unit system "+e+" does not exist. Choices are: "+Object.keys(L).join(", "));F=L[e]},M.getUnitSystem=function(){for(var e in L)if(L[e]===F)return e},M.typeConverters={BigNumber:function(e){return new g.BigNumber(e+"")},Fraction:function(e){return new g.Fraction(e)},Complex:function(e){return e},number:function(e){return e}},M._getNumberConverter=function(e){if(!M.typeConverters[e])throw new TypeError('Unsupported type "'+e+'"');return M.typeConverters[e]},k)($=k[I]).dimensions=$.base.dimensions;for(var j in q)if(q.hasOwnProperty(j)){var $=k[q[j]],H={};for(var I in $)$.hasOwnProperty(I)&&(H[I]=$[I]);H.name=j,k[j]=H}return M.createUnit=function(e,t){if("object"!=typeof e)throw new TypeError("createUnit expects first parameter to be of type 'Object'");if(t&&t.override)for(var r in e)if(e.hasOwnProperty(r)&&M.deleteUnit(r),e[r].aliases)for(var n=0;n<e[r].aliases.length;n++)M.deleteUnit(e[r].aliases[n]);var i;for(var r in e)e.hasOwnProperty(r)&&(i=M.createUnitSingle(r,e[r]));return i},M.createUnitSingle=function(t,e,r){if(null==e&&(e={}),"string"!=typeof t)throw new TypeError("createUnitSingle expects first parameter to be of type 'string'");if(k.hasOwnProperty(t))throw new Error('Cannot create unit "'+t+'": a unit with that name already exists');!function(e){for(var t=0;t<e.length;t++){var r=e.charAt(t),n=function(e){return/^[a-zA-Z]$/.test(e)};if(0===t&&!n(r))throw new Error('Invalid unit name (must begin with alpha character): "'+e+'"');if(0<t&&!(n(r)||"0"<=(i=r)&&i<="9"))throw new Error('Invalid unit name (only alphanumeric characters are allowed): "'+e+'"')}var i}(t);var n,i,a=null,o=[],s=0;if(e&&"Unit"===e.type)a=e.clone();else if("string"==typeof e)""!==e&&(n=e);else{if("object"!=typeof e)throw new TypeError('Cannot create unit "'+t+'" from "'+e.toString()+'": expecting "string" or "Unit" or "Object"');n=e.definition,i=e.prefixes,s=e.offset,e.aliases&&(o=e.aliases.valueOf())}if(o)for(var u=0;u<o.length;u++)if(k.hasOwnProperty(o[u]))throw new Error('Cannot create alias "'+o[u]+'": a unit with that name already exists');if(n&&"string"==typeof n&&!a)try{a=M.parse(n,{allowNoUnits:!0})}catch(e){throw e.message='Could not create unit "'+t+'" from "'+n+'": '+e.message,e}else n&&"Unit"===n.type&&(a=n.clone());o=o||[],s=s||0,i=i&&i.toUpperCase&&B[i.toUpperCase()]||B.NONE;var c={};if(a){var f=!(c={name:t,value:a.value,dimensions:a.dimensions.slice(0),prefixes:i,offset:s});for(var u in R)if(R.hasOwnProperty(u)){for(var l=!0,p=0;p<P.length;p++)if(1e-12<Math.abs((c.dimensions[p]||0)-(R[u].dimensions[p]||0))){l=!1;break}if(l){f=!0;break}}f||(m=t+"_STUFF",(d={dimensions:a.dimensions.slice(0)}).key=m,R[m]=d,F[m]={unit:c,prefix:B.NONE[""]},c.base=m)}else{var m=t+"_STUFF";if(0<=P.indexOf(m))throw new Error('Cannot create new base unit "'+t+'": a base unit with that name already exists (and cannot be overridden)');for(var h in P.push(m),R)R.hasOwnProperty(h)&&(R[h].dimensions[P.length-1]=0);var d={dimensions:[]};for(u=0;u<P.length;u++)d.dimensions[u]=0;d.dimensions[P.length-1]=1,d.key=m,R[m]=d,c={name:t,value:1,dimensions:R[m].dimensions.slice(0),prefixes:i,offset:s,base:m},F[m]={unit:c,prefix:B.NONE[""]}}for(M.UNITS[t]=c,u=0;u<o.length;u++){var g=o[u],v={};for(var y in c)c.hasOwnProperty(y)&&(v[y]=c[y]);v.name=g,M.UNITS[g]=v}return new M(null,t)},M.deleteUnit=function(e){delete M.UNITS[e]},M.PREFIXES=B,M.BASE_DIMENSIONS=P,M.BASE_UNITS=R,M.UNIT_SYSTEMS=L,M.UNITS=k,M},t.math=!0},function(e,t,r){e.exports=[r(523),r(522),r(521),r(520),r(519)]},function(e,t,r){var a=r(0),o=r(3);t.name="string",t.factory=function(e,t,r,n){var i=n("string",{"":function(){return""},number:o.format,null:function(e){return"null"},boolean:function(e){return e+""},string:function(e){return e},"Array | Matrix":function(e){return a(e,i)},any:function(e){return String(e)}});return i.toTex={0:'\\mathtt{""}',1:"\\mathrm{string}\\left(${args[0]}\\right)"},i}},function(e,t,r){e.exports=[r(144)]},function(e,t,r){t.name="sparse",t.factory=function(e,t,r,n){var i=e.SparseMatrix,a=n("sparse",{"":function(){return new i([])},string:function(e){return new i([],e)},"Array | Matrix":function(e){return new i(e)},"Array | Matrix, string":function(e,t){return new i(e,t)}});return a.toTex={0:"\\begin{bsparse}\\end{bsparse}",1:"\\left(${args[0]}\\right)"},a}},function(e,t,r){t.name="index",t.factory=function(n,e,t,r){return r("index",{"...number | string | BigNumber | Range | Array | Matrix":function(e){var t=e.map(function(e){return n.isBigNumber(e)?e.toNumber():Array.isArray(e)||n.isMatrix(e)?e.map(function(e){return n.isBigNumber(e)?e.toNumber():e}):e}),r=new n.Index;return n.Index.apply(r,t),r}})}},function(e,t,o){var s=o(29),r=s.string,u=s.object,c=Array.isArray,f=r.isString;t.name="ImmutableDenseMatrix",t.path="type",t.factory=function(n,e,t){var i=t(o(52)),r=t(o(42));function a(e,t){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!f(t))throw new Error("Invalid datatype: "+t);if(n.isMatrix(e)||c(e)){var r=new i(e,t);this._data=r._data,this._size=r._size,this._datatype=r._datatype,this._min=null,this._max=null}else if(e&&c(e.data)&&c(e.size))this._data=e.data,this._size=e.size,this._datatype=e.datatype,this._min=void 0!==e.min?e.min:null,this._max=void 0!==e.max?e.max:null;else{if(e)throw new TypeError("Unsupported type of data ("+s.types.type(e)+")");this._data=[],this._size=[0],this._datatype=t,this._min=null,this._max=null}}return(a.prototype=new i).type="ImmutableDenseMatrix",a.prototype.isImmutableDenseMatrix=!0,a.prototype.subset=function(e){switch(arguments.length){case 1:var t=i.prototype.subset.call(this,e);return n.isMatrix(t)?new a({data:t._data,size:t._size,datatype:t._datatype}):t;case 2:case 3:throw new Error("Cannot invoke set subset on an Immutable Matrix instance");default:throw new SyntaxError("Wrong number of arguments")}},a.prototype.set=function(){throw new Error("Cannot invoke set on an Immutable Matrix instance")},a.prototype.resize=function(){throw new Error("Cannot invoke resize on an Immutable Matrix instance")},a.prototype.reshape=function(){throw new Error("Cannot invoke reshape on an Immutable Matrix instance")},a.prototype.clone=function(){return new a({data:u.clone(this._data),size:u.clone(this._size),datatype:this._datatype})},a.prototype.toJSON=function(){return{mathjs:"ImmutableDenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},a.fromJSON=function(e){return new a(e)},a.prototype.swapRows=function(){throw new Error("Cannot invoke swapRows on an Immutable Matrix instance")},a.prototype.min=function(){if(null===this._min){var t=null;this.forEach(function(e){(null===t||r(e,t))&&(t=e)}),this._min=null!==t?t:void 0}return this._min},a.prototype.max=function(){if(null===this._max){var t=null;this.forEach(function(e){(null===t||r(t,e))&&(t=e)}),this._max=null!==t?t:void 0}return this._max},a}},function(e,t,c){t.name="FibonacciHeap",t.path="type",t.factory=function(e,t,r,n){var m=r(c(42)),h=r(c(33)),d=1/Math.log((1+Math.sqrt(5))/2);function i(){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this._minimum=null,this._size=0}i.prototype.type="FibonacciHeap",i.prototype.isFibonacciHeap=!0,i.prototype.insert=function(e,t){var r={key:e,value:t,degree:0};if(this._minimum){var n=this._minimum;r.left=n,r.right=n.right,(n.right=r).right.left=r,m(e,n.key)&&(this._minimum=r)}else(r.left=r).right=r,this._minimum=r;return this._size++,r},i.prototype.size=function(){return this._size},i.prototype.clear=function(){this._minimum=null,this._size=0},i.prototype.isEmpty=function(){return 0===this._size},i.prototype.extractMinimum=function(){var e=this._minimum;if(null===e)return e;for(var t=this._minimum,r=e.degree,n=e.child;0<r;){var i=n.right;n.left.right=n.right,n.right.left=n.left,n.left=t,n.right=t.right,((t.right=n).right.left=n).parent=null,n=i,r--}return e.left.right=e.right,e.right.left=e.left,e==e.right?t=null:(t=e.right,t=u(t,this._size)),this._size--,this._minimum=t,e},i.prototype.remove=function(e){this._minimum=a(this._minimum,e,-1),this.extractMinimum()};var a=function(e,t,r){t.key=r;var n=t.parent;return n&&m(t.key,n.key)&&(o(e,t,n),s(e,n)),m(t.key,e.key)&&(e=t),e},o=function(e,t,r){t.left.right=t.right,t.right.left=t.left,r.degree--,r.child==t&&(r.child=t.right),0===r.degree&&(r.child=null),t.left=e,t.right=e.right,((e.right=t).right.left=t).parent=null,t.mark=!1},s=function(e,t){var r=t.parent;r&&(t.mark?(o(e,t,r),s(r)):t.mark=!0)},u=function(e,t){var r,n,i,a=Math.floor(Math.log(t)*d)+1,o=new Array(a),s=0,u=e;if(u)for(s++,u=u.right;u!==e;)s++,u=u.right;for(;0<s;){for(var c=u.degree,f=u.right;r=o[c];){if(h(u.key,r.key)){var l=r;r=u,u=l}i=u,(n=r).left.right=n.right,n.right.left=n.left,(n.parent=i).child?(n.left=i.child,n.right=i.child.right,(i.child.right=n).right.left=n):((i.child=n).right=n).left=n,i.degree++,n.mark=!1,o[c]=null,c++}o[c]=u,u=f,s--}e=null;for(var p=0;p<a;p++)(r=o[p])&&(e?(r.left.right=r.right,r.right.left=r.left,r.left=e,r.right=e.right,(e.right=r).right.left=r,m(r.key,e.key)&&(e=r)):e=r);return e};return i}},function(e,t,a){t.name="Spa",t.path="type",t.factory=function(e,t,r){var n=r(a(13)),c=r(a(10));function i(){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this._values=[],this._heap=new e.FibonacciHeap}return i.prototype.type="Spa",i.prototype.isSpa=!0,i.prototype.set=function(e,t){if(this._values[e])this._values[e].value=t;else{var r=this._heap.insert(e,t);this._values[e]=r}},i.prototype.get=function(e){var t=this._values[e];return t?t.value:0},i.prototype.accumulate=function(e,t){var r=this._values[e];r?r.value=n(r.value,t):(r=this._heap.insert(e,t),this._values[e]=r)},i.prototype.forEach=function(e,t,r){var n=this._heap,i=this._values,a=[],o=n.extractMinimum();for(o&&a.push(o);o&&o.key<=t;)o.key>=e&&(c(o.value,0)||r(o.key,o.value,this)),(o=n.extractMinimum())&&a.push(o);for(var s=0;s<a.length;s++){var u=a[s];i[(o=n.insert(u.key,u.value)).key]=o}},i.prototype.swap=function(e,t){var r=this._values[e],n=this._values[t];if(!r&&n)r=this._heap.insert(e,n.value),this._heap.remove(n),this._values[e]=r,this._values[t]=void 0;else if(r&&!n)n=this._heap.insert(t,r.value),this._heap.remove(r),this._values[t]=n,this._values[e]=void 0;else if(r&&n){var i=r.value;r.value=n.value,n.value=i}},i}},function(e,t,c){var p=c(29),x=c(11),g=p.array,v=p.object,y=p.string,E=p.number,A=Array.isArray,O=E.isNumber,S=E.isInteger,_=y.isString,T=g.validateIndex;t.name="SparseMatrix",t.path="type",t.factory=function(w,e,t,b){var r=t(c(89)),N=t(c(10));function M(e,t){if(!(this instanceof M))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!_(t))throw new Error("Invalid datatype: "+t);if(w.isMatrix(e))n(this,e,t);else if(e&&A(e.index)&&A(e.ptr)&&A(e.size))this._values=e.values,this._index=e.index,this._ptr=e.ptr,this._size=e.size,this._datatype=t||e.datatype;else if(A(e))i(this,e,t);else{if(e)throw new TypeError("Unsupported type of data ("+p.types.type(e)+")");this._values=[],this._index=[],this._ptr=[0],this._size=[0,0],this._datatype=t}}var n=function(e,t,r){"SparseMatrix"===t.type?(e._values=t._values?v.clone(t._values):void 0,e._index=v.clone(t._index),e._ptr=v.clone(t._ptr),e._size=v.clone(t._size),e._datatype=r||t._datatype):i(e,t.valueOf(),r||t._datatype)},i=function(e,t,r){e._values=[],e._index=[],e._ptr=[],e._datatype=r;var n=t.length,i=0,a=N,o=0;if(_(r)&&(a=b.find(N,[r,r])||N,o=b.convert(0,r)),0<n){var s=0;do{e._ptr.push(e._index.length);for(var u=0;u<n;u++){var c=t[u];if(A(c)){if(0===s&&i<c.length&&(i=c.length),s<c.length){var f=c[s];a(f,o)||(e._values.push(f),e._index.push(u))}}else 0===s&&i<1&&(i=1),a(c,o)||(e._values.push(c),e._index.push(u))}s++}while(s<i)}e._ptr.push(e._index.length),e._size=[n,i]};(M.prototype=new r).type="SparseMatrix",M.prototype.isSparseMatrix=!0,M.prototype.storage=function(){return"sparse"},M.prototype.datatype=function(){return this._datatype},M.prototype.create=function(e,t){return new M(e,t)},M.prototype.density=function(){var e=this._size[0],t=this._size[1];return 0!==e&&0!==t?this._index.length/(e*t):0},M.prototype.subset=function(e,t,r){if(!this._values)throw new Error("Cannot invoke subset on a Pattern only matrix");switch(arguments.length){case 1:return a(this,e);case 2:case 3:return o(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}};var a=function(e,t){if(!w.isIndex(t))throw new TypeError("Invalid index");if(t.isScalar())return e.get(t.min());var r,n,i,a,o=t.size();if(o.length!=e._size.length)throw new x(o.length,e._size.length);var s=t.min(),u=t.max();for(r=0,n=e._size.length;r<n;r++)T(s[r],e._size[r]),T(u[r],e._size[r]);var c=e._values,f=e._index,l=e._ptr,p=t.dimension(0),m=t.dimension(1),h=[],d=[];p.forEach(function(e,t){d[e]=t[0],h[e]=!0});var g=c?[]:void 0,v=[],y=[];return m.forEach(function(e){for(y.push(v.length),i=l[e],a=l[e+1];i<a;i++)r=f[i],!0===h[r]&&(v.push(d[r]),g&&g.push(c[i]))}),y.push(v.length),new M({values:g,index:v,ptr:y,size:o,datatype:e._datatype})},o=function(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Invalid index");var i,a=t.size(),o=t.isScalar();if(w.isMatrix(r)?(i=r.size(),r=r.toArray()):i=g.size(r),o){if(0!==i.length)throw new TypeError("Scalar expected");e.set(t.min(),r,n)}else{if(1!==a.length&&2!==a.length)throw new x(a.length,e._size.length,"<");if(i.length<a.length){for(var s=0,u=0;1===a[s]&&1===i[s];)s++;for(;1===a[s];)u++,s++;r=g.unsqueeze(r,a.length,u,i)}if(!v.deepEqual(a,i))throw new x(a,i,">");for(var c=t.min()[0],f=t.min()[1],l=i[0],p=i[1],m=0;m<l;m++)for(var h=0;h<p;h++){var d=r[m][h];e.set([m+c,h+f],d,n)}}return e};M.prototype.get=function(e){if(!A(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new x(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke get on a Pattern only matrix");var t=e[0],r=e[1];T(t,this._size[0]),T(r,this._size[1]);var n=h(t,this._ptr[r],this._ptr[r+1],this._index);return n<this._ptr[r+1]&&this._index[n]===t?this._values[n]:0},M.prototype.set=function(e,t,r){if(!A(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new x(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke set on a Pattern only matrix");var n=e[0],i=e[1],a=this._size[0],o=this._size[1],s=N,u=0;_(this._datatype)&&(s=b.find(N,[this._datatype,this._datatype])||N,u=b.convert(0,this._datatype)),(a-1<n||o-1<i)&&(l(this,Math.max(n+1,a),Math.max(i+1,o),r),a=this._size[0],o=this._size[1]),T(n,a),T(i,o);var c=h(n,this._ptr[i],this._ptr[i+1],this._index);return c<this._ptr[i+1]&&this._index[c]===n?s(t,u)?f(c,i,this._values,this._index,this._ptr):this._values[c]=t:d(c,n,i,t,this._values,this._index,this._ptr),this};var h=function(e,t,r,n){if(r-t==0)return r;for(var i=t;i<r;i++)if(n[i]===e)return i;return t},f=function(e,t,r,n,i){r.splice(e,1),n.splice(e,1);for(var a=t+1;a<i.length;a++)i[a]--},d=function(e,t,r,n,i,a,o){i.splice(e,0,n),a.splice(e,0,t);for(var s=r+1;s<o.length;s++)o[s]++};M.prototype.resize=function(t,e,r){if(!A(t))throw new TypeError("Array expected");if(2!==t.length)throw new Error("Only two dimensions matrix are supported");t.forEach(function(e){if(!E.isNumber(e)||!E.isInteger(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+y.format(t)+")")});var n=r?this.clone():this;return l(n,t[0],t[1],e)};var l=function(e,t,r,n){var i=n||0,a=N,o=0;_(e._datatype)&&(a=b.find(N,[e._datatype,e._datatype])||N,o=b.convert(0,e._datatype),i=b.convert(i,e._datatype));var s,u,c,f=!a(i,o),l=e._size[0],p=e._size[1];if(p<r){for(u=p;u<r;u++)if(e._ptr[u]=e._values.length,f)for(s=0;s<l;s++)e._values.push(i),e._index.push(s);e._ptr[r]=e._values.length}else r<p&&(e._ptr.splice(r+1,p-r),e._values.splice(e._ptr[r],e._values.length),e._index.splice(e._ptr[r],e._index.length));if(p=r,l<t){if(f){var m=0;for(u=0;u<p;u++){e._ptr[u]=e._ptr[u]+m,c=e._ptr[u+1]+m;var h=0;for(s=l;s<t;s++,h++)e._values.splice(c+h,0,i),e._index.splice(c+h,0,s),m++}e._ptr[p]=e._values.length}}else if(t<l){var d=0;for(u=0;u<p;u++){e._ptr[u]=e._ptr[u]-d;var g=e._ptr[u],v=e._ptr[u+1]-d;for(c=g;c<v;c++)t-1<(s=e._index[c])&&(e._values.splice(c,1),e._index.splice(c,1),d++)}e._ptr[u]=e._values.length}return e._size[0]=t,e._size[1]=r,e};M.prototype.reshape=function(t,e){if(!A(t))throw new TypeError("Array expected");if(2!==t.length)throw new Error("Sparse matrices can only be reshaped in two dimensions");if(t.forEach(function(e){if(!E.isNumber(e)||!E.isInteger(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+y.format(t)+")")}),this._size[0]*this._size[1]!=t[0]*t[1])throw new Error("Reshaping sparse matrix will result in the wrong number of elements");var r=e?this.clone():this;if(this._size[0]===t[0]&&this._size[1]===t[1])return r;for(var n=[],i=0;i<r._ptr.length;i++)for(var a=0;a<r._ptr[i+1]-r._ptr[i];a++)n.push(i);var o=r._values.slice(),s=r._index.slice();for(i=0;i<r._index.length;i++){var u=s[i],c=n[i],f=u*r._size[1]+c;n[i]=f%t[1],s[i]=Math.floor(f/t[1])}for(r._values.length=0,r._index.length=0,r._ptr.length=t[1]+1,r._size=t.slice(),i=0;i<r._ptr.length;i++)r._ptr[i]=0;for(var l=0;l<o.length;l++){i=s[l],a=n[l];var p=o[l],m=h(i,r._ptr[a],r._ptr[a+1],r._index);d(m,i,a,p,r._values,r._index,r._ptr)}return r},M.prototype.clone=function(){return new M({values:this._values?v.clone(this._values):void 0,index:v.clone(this._index),ptr:v.clone(this._ptr),size:v.clone(this._size),datatype:this._datatype})},M.prototype.size=function(){return this._size.slice(0)},M.prototype.map=function(n,e){if(!this._values)throw new Error("Cannot invoke map on a Pattern only matrix");var i=this,t=this._size[0],r=this._size[1];return s(this,0,t-1,0,r-1,function(e,t,r){return n(e,[t,r],i)},e)};var s=function(e,t,r,n,i,a,o){var s=[],u=[],c=[],f=N,l=0;_(e._datatype)&&(f=b.find(N,[e._datatype,e._datatype])||N,l=b.convert(0,e._datatype));for(var p=function(e,t,r){e=a(e,t,r),f(e,l)||(s.push(e),u.push(t))},m=n;m<=i;m++){c.push(s.length);for(var h=e._ptr[m],d=e._ptr[m+1],g=t,v=h;v<d;v++){var y=e._index[v];if(t<=y&&y<=r){if(!o)for(var x=g;x<y;x++)p(0,x-t,m-n);p(e._values[v],y-t,m-n)}g=y+1}if(!o)for(var w=g;w<=r;w++)p(0,w-t,m-n)}return c.push(s.length),new M({values:s,index:u,ptr:c,size:[r-t+1,i-n+1]})};M.prototype.forEach=function(e,t){if(!this._values)throw new Error("Cannot invoke forEach on a Pattern only matrix");for(var r=this._size[0],n=this._size[1],i=0;i<n;i++){for(var a=this._ptr[i],o=this._ptr[i+1],s=0,u=a;u<o;u++){var c=this._index[u];if(!t)for(var f=s;f<c;f++)e(0,[f,i],this);e(this._values[u],[c,i],this),s=c+1}if(!t)for(var l=s;l<r;l++)e(0,[l,i],this)}},M.prototype.toArray=function(){return u(this._values,this._index,this._ptr,this._size,!0)},M.prototype.valueOf=function(){return u(this._values,this._index,this._ptr,this._size,!1)};var u=function(e,t,r,n,i){var a,o,s=n[0],u=n[1],c=[];for(a=0;a<s;a++)for(c[a]=[],o=0;o<u;o++)c[a][o]=0;for(o=0;o<u;o++)for(var f=r[o],l=r[o+1],p=f;p<l;p++)c[a=t[p]][o]=e?i?v.clone(e[p]):e[p]:1;return c};return M.prototype.format=function(e){for(var t=this._size[0],r=this._size[1],n=this.density(),i="Sparse Matrix ["+y.format(t,e)+" x "+y.format(r,e)+"] density: "+y.format(n,e)+"\n",a=0;a<r;a++)for(var o=this._ptr[a],s=this._ptr[a+1],u=o;u<s;u++){var c=this._index[u];i+="\n    ("+y.format(c,e)+", "+y.format(a,e)+") ==> "+(this._values?y.format(this._values[u],e):"X")}return i},M.prototype.toString=function(){return y.format(this.toArray())},M.prototype.toJSON=function(){return{mathjs:"SparseMatrix",values:this._values,index:this._index,ptr:this._ptr,size:this._size,datatype:this._datatype}},M.prototype.diagonal=function(e){if(e){if(w.isBigNumber(e)&&(e=e.toNumber()),!O(e)||!S(e))throw new TypeError("The parameter k must be an integer number")}else e=0;var t=0<e?e:0,r=e<0?-e:0,n=this._size[0],i=this._size[1],a=Math.min(n-r,i-t),o=[],s=[],u=[];u[0]=0;for(var c=t;c<i&&o.length<a;c++)for(var f=this._ptr[c],l=this._ptr[c+1],p=f;p<l;p++){var m=this._index[p];if(m===c-t+r){o.push(this._values[p]),s[o.length-1]=m-r;break}}return u.push(o.length),new M({values:o,index:s,ptr:u,size:[a,1]})},M.fromJSON=function(e){return new M(e)},M.diagonal=function(e,t,r,n,i){if(!A(e))throw new TypeError("Array expected, size parameter");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");if(e=e.map(function(e){if(w.isBigNumber(e)&&(e=e.toNumber()),!O(e)||!S(e)||e<1)throw new Error("Size values must be positive integers");return e}),r){if(w.isBigNumber(r)&&(r=r.toNumber()),!O(r)||!S(r))throw new TypeError("The parameter k must be an integer number")}else r=0;var a=N,o=0;_(i)&&(a=b.find(N,[i,i])||N,o=b.convert(0,i));var s,u=0<r?r:0,c=r<0?-r:0,f=e[0],l=e[1],p=Math.min(f-c,l-u);if(A(t)){if(t.length!==p)throw new Error("Invalid value array length");s=function(e){return t[e]}}else if(w.isMatrix(t)){var m=t.size();if(1!==m.length||m[0]!==p)throw new Error("Invalid matrix length");s=function(e){return t.get([e])}}else s=function(){return t};for(var h=[],d=[],g=[],v=0;v<l;v++){g.push(h.length);var y=v-u;if(0<=y&&y<p){var x=s(y);a(x,o)||(d.push(y+c),h.push(x))}}return g.push(h.length),new M({values:h,index:d,ptr:g,size:[f,l]})},M.prototype.swapRows=function(e,t){if(!(O(e)&&S(e)&&O(t)&&S(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return T(e,this._size[0]),T(t,this._size[0]),M._swapRows(e,t,this._size[1],this._values,this._index,this._ptr),this},M._forEachRow=function(e,t,r,n,i){for(var a=n[e],o=n[e+1],s=a;s<o;s++)i(r[s],t[s])},M._swapRows=function(e,t,r,n,i,a){for(var o=0;o<r;o++){var s=a[o],u=a[o+1],c=h(e,s,u,i),f=h(t,s,u,i);if(c<u&&f<u&&i[c]===e&&i[f]===t){if(n){var l=n[c];n[c]=n[f],n[f]=l}}else if(c<u&&i[c]===e&&(u<=f||i[f]!==t)){var p=n?n[c]:void 0;i.splice(f,0,t),n&&n.splice(f,0,p),i.splice(f<=c?c+1:c,1),n&&n.splice(f<=c?c+1:c,1)}else if(f<u&&i[f]===t&&(u<=c||i[c]!==e)){var m=n?n[f]:void 0;i.splice(c,0,e),n&&n.splice(c,0,m),i.splice(c<=f?f+1:f,1),n&&n.splice(c<=f?f+1:f,1)}}},w.Matrix._storage.sparse=M},t.lazy=!1},function(e,t,r){t.isBoolean=function(e){return"boolean"==typeof e}},function(e,t,r){e.exports=[r(89),r(52),r(532),r(531),r(530),r(529),r(27),r(145),r(528),r(1),r(527)]},function(i,a,e){var o;
/**
 * @license Fraction.js v4.0.8 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
/**
 * @license Fraction.js v4.0.8 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(e){var d={s:1,n:0,d:1};function t(t){function e(){var e=Error.apply(this,arguments);e.name=this.name=t,this.stack=e.stack,this.message=e.message}function r(){}return r.prototype=Error.prototype,e.prototype=new r,e}var g=u.DivisionByZero=t("DivisionByZero"),r=u.InvalidParameter=t("InvalidParameter");function v(e,t){return isNaN(e=parseInt(e,10))&&y(),e*t}function y(){throw new r}var n=function(e,t){var r,n=0,i=1,a=1,o=0,s=0,u=0,c=1,f=1,l=0,p=1,m=1,h=1;if(null==e);else if(void 0!==t)a=(n=e)*(i=t);else switch(typeof e){case"object":"d"in e&&"n"in e?(n=e.n,i=e.d,"s"in e&&(n*=e.s)):0 in e?(n=e[0],1 in e&&(i=e[1])):y(),a=n*i;break;case"number":if(e<0&&(e=-(a=e)),e%1==0)n=e;else if(0<e){for(1<=e&&(e/=f=Math.pow(10,Math.floor(1+Math.log(e)/Math.LN10)));p<=1e7&&h<=1e7;){if(e===(r=(l+m)/(p+h))){p+h<=1e7?(n=l+m,i=p+h):p<h?(n=m,i=h):(n=l,i=p);break}r<e?(l+=m,p+=h):(m+=l,h+=p),1e7<p?(n=m,i=h):(n=l,i=p)}n*=f}else(isNaN(e)||isNaN(t))&&(i=n=NaN);break;case"string":if(null===(p=e.match(/\d+|./g))&&y(),"-"===p[l]?(a=-1,l++):"+"===p[l]&&l++,p.length===l+1?s=v(p[l++],a):"."===p[l+1]||"."===p[l]?("."!==p[l]&&(o=v(p[l++],a)),(++l+1===p.length||"("===p[l+1]&&")"===p[l+3]||"'"===p[l+1]&&"'"===p[l+3])&&(s=v(p[l],a),c=Math.pow(10,p[l].length),l++),("("===p[l]&&")"===p[l+2]||"'"===p[l]&&"'"===p[l+2])&&(u=v(p[l+1],a),f=Math.pow(10,p[l+1].length)-1,l+=3)):"/"===p[l+1]||":"===p[l+1]?(s=v(p[l],a),c=v(p[l+2],1),l+=3):"/"===p[l+3]&&" "===p[l+1]&&(o=v(p[l],a),s=v(p[l+2],a),c=v(p[l+4],1),l+=5),p.length<=l){a=n=u+(i=c*f)*o+f*s;break}default:y()}if(0===i)throw new g;d.s=a<0?-1:1,d.n=Math.abs(n),d.d=Math.abs(i)};function s(e,t){if(!e)return t;if(!t)return e;for(;;){if(!(e%=t))return t;if(!(t%=e))return e}}function u(e,t){if(!(this instanceof u))return new u(e,t);n(e,t),e=u.REDUCE?s(d.d,d.n):1,this.s=d.s,this.n=d.n/e,this.d=d.d/e}u.REDUCE=1,u.prototype={s:1,n:0,d:1,abs:function(){return new u(this.n,this.d)},neg:function(){return new u(-this.s*this.n,this.d)},add:function(e,t){return n(e,t),new u(this.s*this.n*d.d+d.s*this.d*d.n,this.d*d.d)},sub:function(e,t){return n(e,t),new u(this.s*this.n*d.d-d.s*this.d*d.n,this.d*d.d)},mul:function(e,t){return n(e,t),new u(this.s*d.s*this.n*d.n,this.d*d.d)},div:function(e,t){return n(e,t),new u(this.s*d.s*this.n*d.d,this.d*d.n)},clone:function(){return new u(this)},mod:function(e,t){return isNaN(this.n)||isNaN(this.d)?new u(NaN):void 0===e?new u(this.s*this.n%this.d,1):(n(e,t),0===d.n&&0===this.d&&u(0,0),new u(this.s*(d.d*this.n)%(d.n*this.d),d.d*this.d))},gcd:function(e,t){return n(e,t),new u(s(d.n,this.n)*s(d.d,this.d),d.d*this.d)},lcm:function(e,t){return n(e,t),0===d.n&&0===this.n?new u:new u(d.n*this.n,s(d.n,this.n)*s(d.d,this.d))},ceil:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.ceil(e*this.s*this.n/this.d),e)},floor:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.floor(e*this.s*this.n/this.d),e)},round:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.round(e*this.s*this.n/this.d),e)},inverse:function(){return new u(this.s*this.d,this.n)},pow:function(e){return e<0?new u(Math.pow(this.s*this.d,-e),Math.pow(this.n,-e)):new u(Math.pow(this.s*this.n,e),Math.pow(this.d,e))},equals:function(e,t){return n(e,t),this.s*this.n*d.d==d.s*d.n*this.d},compare:function(e,t){n(e,t);var r=this.s*this.n*d.d-d.s*d.n*this.d;return(0<r)-(r<0)},simplify:function(e){if(isNaN(this.n)||isNaN(this.d))return this;var t=this.abs().toContinued();function r(e){return 1===e.length?new u(e[0]):r(e.slice(1)).inverse().add(e[0])}e=e||.001;for(var n=0;n<t.length;n++){var i=r(t.slice(0,n+1));if(i.sub(this.abs()).abs().valueOf()<e)return i.mul(this.s)}return this},divisible:function(e,t){return n(e,t),!(!(d.n*this.d)||this.n*d.d%(d.n*this.d))},valueOf:function(){return this.s*this.n/this.d},toFraction:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&0<(t=Math.floor(n/i))&&(r+=t,r+=" ",n%=i),r+=n,r+="/",r+=i),r},toLatex:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&0<(t=Math.floor(n/i))&&(r+=t,n%=i),r+="\\frac{",r+=n,r+="}{",r+=i,r+="}"),r},toContinued:function(){var e,t=this.n,r=this.d,n=[];if(isNaN(this.n)||isNaN(this.d))return n;for(;n.push(Math.floor(t/r)),e=t%r,t=r,r=e,1!==t;);return n},toString:function(){var e,t=this.n,r=this.d;if(isNaN(t)||isNaN(r))return"NaN";u.REDUCE||(t/=e=s(t,r),r/=e);var n=function(e,t){for(;t%2==0;t/=2);for(;t%5==0;t/=5);if(1===t)return 0;for(var r=10%t,n=1;1!==r;n++)if(r=10*r%t,2e3<n)return 0;return n}(0,r),i=function(e,t,r){for(var n=1,i=function(e,t,r){for(var n=1;0<t;e=e*e%r,t>>=1)1&t&&(n=n*e%r);return n}(10,r,t),a=0;a<300;a++){if(n===i)return a;n=10*n%t,i=10*i%t}return 0}(0,r,n),a=-1===this.s?"-":"";if(a+=t/r|0,t%=r,(t*=10)&&(a+="."),n){for(var o=i;o--;)a+=t/r|0,t%=r,t*=10;a+="(";for(o=n;o--;)a+=t/r|0,t%=r,t*=10;a+=")"}else for(o=15;t&&o--;)a+=t/r|0,t%=r,t*=10;return a}},void 0===(o=function(){return u}.apply(a,[]))||(i.exports=o)}()},function(e,t,r){var i=r(535);i.prototype.type="Fraction",i.prototype.isFraction=!0,i.prototype.toJSON=function(){return{mathjs:"Fraction",n:this.s*this.n,d:this.d}},i.fromJSON=function(e){return new i(e)},t.name="Fraction",t.path="type",t.factory=function(e,t,r,n){return i}},function(e,t,r){e.exports=[r(536),r(146)]},function(e,t,r){var l={"{":"\\{","}":"\\}","\\":"\\textbackslash{}","#":"\\#",$:"\\$","%":"\\%","&":"\\&","^":"\\textasciicircum{}",_:"\\_","~":"\\textasciitilde{}"},p={"–":"\\--","—":"\\---"," ":"~","\t":"\\qquad{}","\r\n":"\\\\newline{}","\n":"\\\\newline{}"},m=function(e,t){return Object.assign({},e,t)};e.exports=function(e){for(var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.preserveFormatting,n=void 0!==r&&r,i=t.escapeMapFn,a=void 0===i?m:i,o=String(e),s="",u=a(Object.assign({},l),n?Object.assign({},p):{}),c=Object.keys(u),f=function(){var r=!1;c.forEach(function(e,t){r||o.startsWith(e)&&(s+=u[c[t]],o=o.slice(e.length,o.length),r=!0)}),r||(s+=o.slice(0,1),o=o.slice(1,o.length))};o;)f();return s}},function(e,t,o){var s=o(0);t.name="complex",t.factory=function(r,e,t,n){var i=o(4),a=n("complex",{"":function(){return r.Complex.ZERO},number:function(e){return new r.Complex(e,0)},"number, number":function(e,t){return new r.Complex(e,t)},"BigNumber, BigNumber":function(e,t){return new r.Complex(e.toNumber(),t.toNumber())},Complex:function(e){return e.clone()},string:function(e){return r.Complex(e)},null:function(e){return r.Complex(0)},Object:function(e){if("re"in e&&"im"in e)return new r.Complex(e.re,e.im);if("r"in e&&"phi"in e)return new r.Complex(e);throw new Error("Expected object with either properties re and im, or properties r and phi.")},"Array | Matrix":function(e){return s(e,a)}});return a.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)+"+i.symbols.i+"\\cdot\\left(${args[1]}\\right)\\right)"},a}},function(t,r,e){var o;
/**
 * @license Complex.js v2.0.10 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
/**
 * @license Complex.js v2.0.10 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(e){var n=function(e){return.5*(Math.exp(e)+Math.exp(-e))},i=function(e){return.5*(Math.exp(e)-Math.exp(-e))},u=function(){throw SyntaxError("Invalid Param")};function c(e,t){var r=Math.abs(e),n=Math.abs(t);return 0===e?Math.log(n):0===t?Math.log(r):r<3e3&&n<3e3?.5*Math.log(e*e+t*t):Math.log(e/Math.cos(Math.atan2(t,e)))}var a=function(e,t){var r={re:0,im:0};if(null==e)r.re=r.im=0;else if(void 0!==t)r.re=e,r.im=t;else switch(typeof e){case"object":if("im"in e&&"re"in e)r.re=e.re,r.im=e.im;else if("abs"in e&&"arg"in e){if(!Number.isFinite(e.abs)&&Number.isFinite(e.arg))return f.INFINITY;r.re=e.abs*Math.cos(e.arg),r.im=e.abs*Math.sin(e.arg)}else if("r"in e&&"phi"in e){if(!Number.isFinite(e.r)&&Number.isFinite(e.phi))return f.INFINITY;r.re=e.r*Math.cos(e.phi),r.im=e.r*Math.sin(e.phi)}else 2===e.length?(r.re=e[0],r.im=e[1]):u();break;case"string":r.im=r.re=0;var n=e.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g),i=1,a=0;null===n&&u();for(var o=0;o<n.length;o++){var s=n[o];" "===s||"\t"===s||"\n"===s||("+"===s?i++:"-"===s?a++:("i"===s||"I"===s?(i+a===0&&u()," "===n[o+1]||isNaN(n[o+1])?r.im+=parseFloat((a%2?"-":"")+"1"):(r.im+=parseFloat((a%2?"-":"")+n[o+1]),o++)):((i+a===0||isNaN(s))&&u(),"i"===n[o+1]||"I"===n[o+1]?(r.im+=parseFloat((a%2?"-":"")+s),o++):r.re+=parseFloat((a%2?"-":"")+s)),i=a=0))}0<i+a&&u();break;case"number":r.im=0,r.re=e;break;default:u()}return isNaN(r.re)||isNaN(r.im),r};function f(e,t){if(!(this instanceof f))return new f(e,t);var r=a(e,t);this.re=r.re,this.im=r.im}f.prototype={re:0,im:0,sign:function(){var e=this.abs();return new f(this.re/e,this.im/e)},add:function(e,t){var r=new f(e,t);return this.isInfinite()&&r.isInfinite()?f.NAN:this.isInfinite()||r.isInfinite()?f.INFINITY:new f(this.re+r.re,this.im+r.im)},sub:function(e,t){var r=new f(e,t);return this.isInfinite()&&r.isInfinite()?f.NAN:this.isInfinite()||r.isInfinite()?f.INFINITY:new f(this.re-r.re,this.im-r.im)},mul:function(e,t){var r=new f(e,t);return this.isInfinite()&&r.isZero()||this.isZero()&&r.isInfinite()?f.NAN:this.isInfinite()||r.isInfinite()?f.INFINITY:0===r.im&&0===this.im?new f(this.re*r.re,0):new f(this.re*r.re-this.im*r.im,this.re*r.im+this.im*r.re)},div:function(e,t){var r=new f(e,t);if(this.isZero()&&r.isZero()||this.isInfinite()&&r.isInfinite())return f.NAN;if(this.isInfinite()||r.isZero())return f.INFINITY;if(this.isZero()||r.isInfinite())return f.ZERO;e=this.re,t=this.im;var n,i,a=r.re,o=r.im;return 0===o?new f(e/a,t/a):Math.abs(a)<Math.abs(o)?new f((e*(i=a/o)+t)/(n=a*i+o),(t*i-e)/n):new f((e+t*(i=o/a))/(n=o*i+a),(t-e*i)/n)},pow:function(e,t){var r=new f(e,t);if(e=this.re,t=this.im,r.isZero())return f.ONE;if(0===r.im){if(0===t&&0<=e)return new f(Math.pow(e,r.re),0);if(0===e)switch((r.re%4+4)%4){case 0:return new f(Math.pow(t,r.re),0);case 1:return new f(0,Math.pow(t,r.re));case 2:return new f(-Math.pow(t,r.re),0);case 3:return new f(0,-Math.pow(t,r.re))}}if(0===e&&0===t&&0<r.re&&0<=r.im)return f.ZERO;var n=Math.atan2(t,e),i=c(e,t);return e=Math.exp(r.re*i-r.im*n),t=r.im*i+r.re*n,new f(e*Math.cos(t),e*Math.sin(t))},sqrt:function(){var e,t,r=this.re,n=this.im,i=this.abs();if(0<=r){if(0===n)return new f(Math.sqrt(r),0);e=.5*Math.sqrt(2*(i+r))}else e=Math.abs(n)/Math.sqrt(2*(i-r));return t=r<=0?.5*Math.sqrt(2*(i-r)):Math.abs(n)/Math.sqrt(2*(i+r)),new f(e,n<0?-t:t)},exp:function(){var e=Math.exp(this.re);return this.im,new f(e*Math.cos(this.im),e*Math.sin(this.im))},expm1:function(){var e=this.re,t=this.im;return new f(Math.expm1(e)*Math.cos(t)+function(e){var t=Math.PI/4;if(e<-t||t<e)return Math.cos(e)-1;var r=e*e;return r*(r*(1/24+r*(-1/720+r*(1/40320+r*(-1/3628800+r*(1/4790014600+r*(-1/87178291200+r*(1/20922789888e3)))))))-.5)}(t),Math.exp(e)*Math.sin(t))},log:function(){var e=this.re,t=this.im;return new f(c(e,t),Math.atan2(t,e))},abs:function(){return e=this.re,t=this.im,r=Math.abs(e),n=Math.abs(t),r<3e3&&n<3e3?Math.sqrt(r*r+n*n):(r<n?(r=n,n=e/t):n=t/e,r*Math.sqrt(1+n*n));var e,t,r,n},arg:function(){return Math.atan2(this.im,this.re)},sin:function(){var e=this.re,t=this.im;return new f(Math.sin(e)*n(t),Math.cos(e)*i(t))},cos:function(){var e=this.re,t=this.im;return new f(Math.cos(e)*n(t),-Math.sin(e)*i(t))},tan:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)+n(t);return new f(Math.sin(e)/r,i(t)/r)},cot:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)-n(t);return new f(-Math.sin(e)/r,i(t)/r)},sec:function(){var e=this.re,t=this.im,r=.5*n(2*t)+.5*Math.cos(2*e);return new f(Math.cos(e)*n(t)/r,Math.sin(e)*i(t)/r)},csc:function(){var e=this.re,t=this.im,r=.5*n(2*t)-.5*Math.cos(2*e);return new f(Math.sin(e)*n(t)/r,-Math.cos(e)*i(t)/r)},asin:function(){var e=this.re,t=this.im,r=new f(t*t-e*e+1,-2*e*t).sqrt(),n=new f(r.re-t,r.im+e).log();return new f(n.im,-n.re)},acos:function(){var e=this.re,t=this.im,r=new f(t*t-e*e+1,-2*e*t).sqrt(),n=new f(r.re-t,r.im+e).log();return new f(Math.PI/2-n.im,n.re)},atan:function(){var e=this.re,t=this.im;if(0===e){if(1===t)return new f(0,1/0);if(-1===t)return new f(0,-1/0)}var r=e*e+(1-t)*(1-t),n=new f((1-t*t-e*e)/r,-2*e/r).log();return new f(-.5*n.im,.5*n.re)},acot:function(){var e=this.re,t=this.im;if(0===t)return new f(Math.atan2(1,e),0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).atan():new f(0!==e?e/0:0,0!==t?-t/0:0).atan()},asec:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(0,1/0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).acos():new f(0!==e?e/0:0,0!==t?-t/0:0).acos()},acsc:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(Math.PI/2,1/0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).asin():new f(0!==e?e/0:0,0!==t?-t/0:0).asin()},sinh:function(){var e=this.re,t=this.im;return new f(i(e)*Math.cos(t),n(e)*Math.sin(t))},cosh:function(){var e=this.re,t=this.im;return new f(n(e)*Math.cos(t),i(e)*Math.sin(t))},tanh:function(){var e=2*this.re,t=2*this.im,r=n(e)+Math.cos(t);return new f(i(e)/r,Math.sin(t)/r)},coth:function(){var e=2*this.re,t=2*this.im,r=n(e)-Math.cos(t);return new f(i(e)/r,-Math.sin(t)/r)},csch:function(){var e=this.re,t=this.im,r=Math.cos(2*t)-n(2*e);return new f(-2*i(e)*Math.cos(t)/r,2*n(e)*Math.sin(t)/r)},sech:function(){var e=this.re,t=this.im,r=Math.cos(2*t)+n(2*e);return new f(2*n(e)*Math.cos(t)/r,-2*i(e)*Math.sin(t)/r)},asinh:function(){var e=this.im;this.im=-this.re,this.re=e;var t=this.asin();return this.re=-this.im,this.im=e,e=t.re,t.re=-t.im,t.im=e,t},acosh:function(){var e=this.acos();if(e.im<=0){var t=e.re;e.re=-e.im,e.im=t}else{t=e.im;e.im=-e.re,e.re=t}return e},atanh:function(){var e=this.re,t=this.im,r=1<e&&0===t,n=1-e,i=1+e,a=n*n+t*t,o=0!==a?new f((i*n-t*t)/a,(t*n+i*t)/a):new f(-1!==e?e/0:0,0!==t?t/0:0),s=o.re;return o.re=c(o.re,o.im)/2,o.im=Math.atan2(o.im,s)/2,r&&(o.im=-o.im),o},acoth:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(0,Math.PI/2);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).atanh():new f(0!==e?e/0:0,0!==t?-t/0:0).atanh()},acsch:function(){var e=this.re,t=this.im;if(0===t)return new f(0!==e?Math.log(e+Math.sqrt(e*e+1)):1/0,0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).asinh():new f(0!==e?e/0:0,0!==t?-t/0:0).asinh()},asech:function(){var e=this.re,t=this.im;if(this.isZero())return f.INFINITY;var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).acosh():new f(0!==e?e/0:0,0!==t?-t/0:0).acosh()},inverse:function(){if(this.isZero())return f.INFINITY;if(this.isInfinite())return f.ZERO;var e=this.re,t=this.im,r=e*e+t*t;return new f(e/r,-t/r)},conjugate:function(){return new f(this.re,-this.im)},neg:function(){return new f(-this.re,-this.im)},ceil:function(e){return e=Math.pow(10,e||0),new f(Math.ceil(this.re*e)/e,Math.ceil(this.im*e)/e)},floor:function(e){return e=Math.pow(10,e||0),new f(Math.floor(this.re*e)/e,Math.floor(this.im*e)/e)},round:function(e){return e=Math.pow(10,e||0),new f(Math.round(this.re*e)/e,Math.round(this.im*e)/e)},equals:function(e,t){var r=new f(e,t);return Math.abs(r.re-this.re)<=f.EPSILON&&Math.abs(r.im-this.im)<=f.EPSILON},clone:function(){return new f(this.re,this.im)},toString:function(){var e=this.re,t=this.im,r="";return this.isNaN()?"NaN":this.isZero()?"0":this.isInfinite()?"Infinity":(0!==e&&(r+=e),0!==t&&(0!==e?r+=t<0?" - ":" + ":t<0&&(r+="-"),1!==(t=Math.abs(t))&&(r+=t),r+="i"),r||"0")},toVector:function(){return[this.re,this.im]},valueOf:function(){return 0===this.im?this.re:null},isNaN:function(){return isNaN(this.re)||isNaN(this.im)},isZero:function(){return!(0!==this.re&&-0!==this.re||0!==this.im&&-0!==this.im)},isFinite:function(){return isFinite(this.re)&&isFinite(this.im)},isInfinite:function(){return!(this.isNaN()||this.isFinite())}},f.ZERO=new f(0,0),f.ONE=new f(1,0),f.I=new f(0,1),f.PI=new f(Math.PI,0),f.E=new f(Math.E,0),f.INFINITY=new f(1/0,1/0),f.NAN=new f(NaN,NaN),f.EPSILON=1e-16,void 0===(o=function(){return f}.apply(r,[]))||(t.exports=o)}()},function(e,t,r){e.exports=[r(147),r(539)]},function(e,t,r){t.name="chain",t.factory=function(t,e,r,n){return n("chain",{"":function(){return new t.Chain},any:function(e){return new t.Chain(e)}})}},function(e,u,t){u.format=function(e,t){if("function"==typeof t)return t(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var r="auto",n=void 0;switch(void 0!==t&&(t.notation&&(r=t.notation),"number"==typeof t?n=t:t.precision&&(n=t.precision)),r){case"fixed":return u.toFixed(e,n);case"exponential":return u.toExponential(e,n);case"auto":if(t&&t.exponential&&(void 0!==t.exponential.lower||void 0!==t.exponential.upper)){var i=Object.assign({},t);return(i.exponential=void 0)!==t.exponential.lower&&(i.lowerExp=Math.round(Math.log(t.exponential.lower)/Math.LN10)),void 0!==t.exponential.upper&&(i.upperExp=Math.round(Math.log(t.exponential.upper)/Math.LN10)),console.warn("Deprecation warning: Formatting options exponential.lower and exponential.upper (minimum and maximum value) are replaced with exponential.lowerExp and exponential.upperExp (minimum and maximum exponent) since version 4.0.0. Replace "+JSON.stringify(t)+" with "+JSON.stringify(i)),u.format(e,i)}var a=t&&void 0!==t.lowerExp?t.lowerExp:-3,o=t&&void 0!==t.upperExp?t.upperExp:5;if(e.isZero())return"0";var s=e.logarithm();return(s.gte(a)&&s.lt(o)?e.toSignificantDigits(n).toFixed():u.toExponential(e,n)).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+r+'". Choose "auto", "exponential", or "fixed".')}},u.toExponential=function(e,t){return void 0!==t?e.toExponential(t-1):e.toExponential()},u.toFixed=function(e,t){return e.toFixed(t)}},function(e,t,r){var u=r(9).format,c=r(5).lazy;t.name="Chain",t.path="type",t.factory=function(t,e,r,n,i){function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");t.isChain(e)?this.value=e.value:this.value=e}function o(e,t){"function"==typeof t&&(a.prototype[e]=s(t))}function s(r){return function(){for(var e=[this.value],t=0;t<arguments.length;t++)e[t+1]=arguments[t];return new a(r.apply(r,e))}}return a.prototype.type="Chain",a.prototype.isChain=!0,a.prototype.done=function(){return this.value},a.prototype.valueOf=function(){return this.value},a.prototype.toString=function(){return u(this.value)},a.prototype.toJSON=function(){return{mathjs:"Chain",value:this.value}},a.fromJSON=function(e){return new a(e.value)},a.createProxy=function(e,t){if("string"==typeof e)o(e,t);else for(var r in e)e.hasOwnProperty(r)&&o(r,e[r])},a.createProxy(i),i.on("import",function(e,t,r){var n;void 0===r&&(n=t,c(a.prototype,e,function(){var e=n();if("function"==typeof e)return s(e)}))}),a},t.math=!0,t.lazy=!1},function(e,t,r){e.exports=[r(544),r(542)]},function(e,t,r){var a=r(0);t.name="boolean",t.factory=function(e,t,r,n){var i=n("bool",{"":function(){return!1},boolean:function(e){return e},number:function(e){return!!e},null:function(e){return!1},BigNumber:function(e){return!e.isZero()},string:function(e){var t=e.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;var r=Number(e);if(""!=e&&!isNaN(r))return!!r;throw new Error('Cannot convert "'+e+'" to a boolean')},"Array | Matrix":function(e){return a(e,i)}});return i}},function(e,t,r){var a=r(0);t.name="bignumber",t.factory=function(t,e,r,n){var i=n("bignumber",{"":function(){return new t.BigNumber(0)},number:function(e){return new t.BigNumber(e+"")},string:function(e){return new t.BigNumber(e)},BigNumber:function(e){return e},Fraction:function(e){return new t.BigNumber(e.n).div(e.d)},null:function(e){return new t.BigNumber(0)},"Array | Matrix":function(e){return a(e,i)}});return i.toTex={0:"0",1:"\\left(${args[0]}\\right)"},i}},function(Ie,Pe,Re){var Ue;!function(e){var l,I,o,s=9e15,d=1e9,g="0123456789abcdef",n="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058",i="3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789",u={precision:20,rounding:4,modulo:1,toExpNeg:-7,toExpPos:21,minE:-s,maxE:s,crypto:!1},x=!0,c="[DecimalError] ",v=c+"Invalid argument: ",a=c+"Precision limit exceeded",f=c+"crypto unavailable",P=Math.floor,y=Math.pow,p=/^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,m=/^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,h=/^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,w=/^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,R=1e7,U=7,b=n.length-1,N=i.length-1,M={name:"[object Decimal]"};function E(e){var t,r,n,i=e.length-1,a="",o=e[0];if(0<i){for(a+=o,t=1;t<i;t++)n=e[t]+"",(r=U-n.length)&&(a+=D(r)),a+=n;o=e[t],(r=U-(n=o+"").length)&&(a+=D(r))}else if(0===o)return"0";for(;o%10==0;)o/=10;return a+o}function A(e,t,r){if(e!==~~e||e<t||r<e)throw Error(v+e)}function O(e,t,r,n){var i,a,o,s;for(a=e[0];10<=a;a/=10)--t;return--t<0?(t+=U,i=0):(i=Math.ceil((t+1)/U),t%=U),a=y(10,U-t),s=e[i]%a|0,null==n?t<3?(0==t?s=s/100|0:1==t&&(s=s/10|0),o=r<4&&99999==s||3<r&&49999==s||5e4==s||0==s):o=(r<4&&s+1==a||3<r&&s+1==a/2)&&(e[i+1]/a/100|0)==y(10,t-2)-1||(s==a/2||0==s)&&0==(e[i+1]/a/100|0):t<4?(0==t?s=s/1e3|0:1==t?s=s/100|0:2==t&&(s=s/10|0),o=(n||r<4)&&9999==s||!n&&3<r&&4999==s):o=((n||r<4)&&s+1==a||!n&&3<r&&s+1==a/2)&&(e[i+1]/a/1e3|0)==y(10,t-3)-1,o}function S(e,t,r){for(var n,i,a=[0],o=0,s=e.length;o<s;){for(i=a.length;i--;)a[i]*=t;for(a[0]+=g.indexOf(e.charAt(o++)),n=0;n<a.length;n++)a[n]>r-1&&(void 0===a[n+1]&&(a[n+1]=0),a[n+1]+=a[n]/r|0,a[n]%=r)}return a.reverse()}M.absoluteValue=M.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),k(e)},M.ceil=function(){return k(new this.constructor(this),this.e+1,2)},M.comparedTo=M.cmp=function(e){var t,r,n,i,a=this.d,o=(e=new this.constructor(e)).d,s=this.s,u=e.s;if(!a||!o)return s&&u?s!==u?s:a===o?0:!a^s<0?1:-1:NaN;if(!a[0]||!o[0])return a[0]?s:o[0]?-u:0;if(s!==u)return s;if(this.e!==e.e)return this.e>e.e^s<0?1:-1;for(t=0,r=(n=a.length)<(i=o.length)?n:i;t<r;++t)if(a[t]!==o[t])return a[t]>o[t]^s<0?1:-1;return n===i?0:i<n^s<0?1:-1},M.cosine=M.cos=function(){var e,t,r=this,n=r.constructor;return r.d?r.d[0]?(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+U,n.rounding=1,r=function(e,t){var r,n,i=t.d.length;i<32?(r=Math.ceil(i/3),n=Math.pow(4,-r).toString()):(r=16,n="2.3283064365386962890625e-10");e.precision+=r,t=Z(e,1,t.times(n),new e(1));for(var a=r;a--;){var o=t.times(t);t=o.times(o).minus(o).times(8).plus(1)}return e.precision-=r,t}(n,V(n,r)),n.precision=e,n.rounding=t,k(2==o||3==o?r.neg():r,e,t,!0)):new n(1):new n(NaN)},M.cubeRoot=M.cbrt=function(){var e,t,r,n,i,a,o,s,u,c,f=this,l=f.constructor;if(!f.isFinite()||f.isZero())return new l(f);for(x=!1,(a=f.s*Math.pow(f.s*f,1/3))&&Math.abs(a)!=1/0?n=new l(a.toString()):(r=E(f.d),(a=((e=f.e)-r.length+1)%3)&&(r+=1==a||-2==a?"0":"00"),a=Math.pow(r,1/3),e=P((e+1)/3)-(e%3==(e<0?-1:2)),(n=new l(r=a==1/0?"5e"+e:(r=a.toExponential()).slice(0,r.indexOf("e")+1)+e)).s=f.s),o=(e=l.precision)+3;;)if(c=(u=(s=n).times(s).times(s)).plus(f),n=_(c.plus(f).times(s),c.plus(u),o+2,1),E(s.d).slice(0,o)===(r=E(n.d)).slice(0,o)){if("9999"!=(r=r.slice(o-3,o+1))&&(i||"4999"!=r)){+r&&(+r.slice(1)||"5"!=r.charAt(0))||(k(n,e+1,1),t=!n.times(n).times(n).eq(f));break}if(!i&&(k(s,e+1,0),s.times(s).times(s).eq(f))){n=s;break}o+=4,i=1}return x=!0,k(n,e,l.rounding,t)},M.decimalPlaces=M.dp=function(){var e,t=this.d,r=NaN;if(t){if(r=((e=t.length-1)-P(this.e/U))*U,e=t[e])for(;e%10==0;e/=10)r--;r<0&&(r=0)}return r},M.dividedBy=M.div=function(e){return _(this,new this.constructor(e))},M.dividedToIntegerBy=M.divToInt=function(e){var t=this.constructor;return k(_(this,new t(e),0,1,1),t.precision,t.rounding)},M.equals=M.eq=function(e){return 0===this.cmp(e)},M.floor=function(){return k(new this.constructor(this),this.e+1,3)},M.greaterThan=M.gt=function(e){return 0<this.cmp(e)},M.greaterThanOrEqualTo=M.gte=function(e){var t=this.cmp(e);return 1==t||0===t},M.hyperbolicCosine=M.cosh=function(){var e,t,r,n,i,a=this,o=a.constructor,s=new o(1);if(!a.isFinite())return new o(a.s?1/0:NaN);if(a.isZero())return s;r=o.precision,n=o.rounding,o.precision=r+Math.max(a.e,a.sd())+4,o.rounding=1,(i=a.d.length)<32?(e=Math.ceil(i/3),t=Math.pow(4,-e).toString()):(e=16,t="2.3283064365386962890625e-10"),a=Z(o,1,a.times(t),new o(1),!0);for(var u,c=e,f=new o(8);c--;)u=a.times(a),a=s.minus(u.times(f.minus(u.times(f))));return k(a,o.precision=r,o.rounding=n,!0)},M.hyperbolicSine=M.sinh=function(){var e,t,r,n,i=this,a=i.constructor;if(!i.isFinite()||i.isZero())return new a(i);if(t=a.precision,r=a.rounding,a.precision=t+Math.max(i.e,i.sd())+4,a.rounding=1,(n=i.d.length)<3)i=Z(a,2,i,i,!0);else{e=16<(e=1.4*Math.sqrt(n))?16:0|e,i=Z(a,2,i=i.times(Math.pow(5,-e)),i,!0);for(var o,s=new a(5),u=new a(16),c=new a(20);e--;)o=i.times(i),i=i.times(s.plus(o.times(u.times(o).plus(c))))}return k(i,a.precision=t,a.rounding=r,!0)},M.hyperbolicTangent=M.tanh=function(){var e,t,r=this.constructor;return this.isFinite()?this.isZero()?new r(this):(e=r.precision,t=r.rounding,r.precision=e+7,r.rounding=1,_(this.sinh(),this.cosh(),r.precision=e,r.rounding=t)):new r(this.s)},M.inverseCosine=M.acos=function(){var e,t=this,r=t.constructor,n=t.abs().cmp(1),i=r.precision,a=r.rounding;return-1!==n?0===n?t.isNeg()?B(r,i,a):new r(0):new r(NaN):t.isZero()?B(r,i+4,a).times(.5):(r.precision=i+6,r.rounding=1,t=t.asin(),e=B(r,i+4,a).times(.5),r.precision=i,r.rounding=a,e.minus(t))},M.inverseHyperbolicCosine=M.acosh=function(){var e,t,r=this,n=r.constructor;return r.lte(1)?new n(r.eq(1)?0:NaN):r.isFinite()?(e=n.precision,t=n.rounding,n.precision=e+Math.max(Math.abs(r.e),r.sd())+4,n.rounding=1,x=!1,r=r.times(r).minus(1).sqrt().plus(r),x=!0,n.precision=e,n.rounding=t,r.ln()):new n(r)},M.inverseHyperbolicSine=M.asinh=function(){var e,t,r=this,n=r.constructor;return!r.isFinite()||r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+2*Math.max(Math.abs(r.e),r.sd())+6,n.rounding=1,x=!1,r=r.times(r).plus(1).sqrt().plus(r),x=!0,n.precision=e,n.rounding=t,r.ln())},M.inverseHyperbolicTangent=M.atanh=function(){var e,t,r,n,i=this,a=i.constructor;return i.isFinite()?0<=i.e?new a(i.abs().eq(1)?i.s/0:i.isZero()?i:NaN):(e=a.precision,t=a.rounding,n=i.sd(),Math.max(n,e)<2*-i.e-1?k(new a(i),e,t,!0):(a.precision=r=n-i.e,i=_(i.plus(1),new a(1).minus(i),r+e,1),a.precision=e+4,a.rounding=1,i=i.ln(),a.precision=e,a.rounding=t,i.times(.5))):new a(NaN)},M.inverseSine=M.asin=function(){var e,t,r,n,i=this,a=i.constructor;return i.isZero()?new a(i):(t=i.abs().cmp(1),r=a.precision,n=a.rounding,-1!==t?0===t?((e=B(a,r+4,n).times(.5)).s=i.s,e):new a(NaN):(a.precision=r+6,a.rounding=1,i=i.div(new a(1).minus(i.times(i)).sqrt().plus(1)).atan(),a.precision=r,a.rounding=n,i.times(2)))},M.inverseTangent=M.atan=function(){var e,t,r,n,i,a,o,s,u,c=this,f=c.constructor,l=f.precision,p=f.rounding;if(c.isFinite()){if(c.isZero())return new f(c);if(c.abs().eq(1)&&l+4<=N)return(o=B(f,l+4,p).times(.25)).s=c.s,o}else{if(!c.s)return new f(NaN);if(l+4<=N)return(o=B(f,l+4,p).times(.5)).s=c.s,o}for(f.precision=s=l+10,f.rounding=1,e=r=Math.min(28,s/U+2|0);e;--e)c=c.div(c.times(c).plus(1).sqrt().plus(1));for(x=!1,t=Math.ceil(s/U),n=1,u=c.times(c),o=new f(c),i=c;-1!==e;)if(i=i.times(u),a=o.minus(i.div(n+=2)),i=i.times(u),void 0!==(o=a.plus(i.div(n+=2))).d[t])for(e=t;o.d[e]===a.d[e]&&e--;);return r&&(o=o.times(2<<r-1)),x=!0,k(o,f.precision=l,f.rounding=p,!0)},M.isFinite=function(){return!!this.d},M.isInteger=M.isInt=function(){return!!this.d&&P(this.e/U)>this.d.length-2},M.isNaN=function(){return!this.s},M.isNegative=M.isNeg=function(){return this.s<0},M.isPositive=M.isPos=function(){return 0<this.s},M.isZero=function(){return!!this.d&&0===this.d[0]},M.lessThan=M.lt=function(e){return this.cmp(e)<0},M.lessThanOrEqualTo=M.lte=function(e){return this.cmp(e)<1},M.logarithm=M.log=function(e){var t,r,n,i,a,o,s,u,c=this.constructor,f=c.precision,l=c.rounding;if(null==e)e=new c(10),t=!0;else{if(r=(e=new c(e)).d,e.s<0||!r||!r[0]||e.eq(1))return new c(NaN);t=e.eq(10)}if(r=this.d,this.s<0||!r||!r[0]||this.eq(1))return new c(r&&!r[0]?-1/0:1!=this.s?NaN:r?0:1/0);if(t)if(1<r.length)a=!0;else{for(i=r[0];i%10==0;)i/=10;a=1!==i}if(x=!1,o=$(this,s=f+5),n=t?z(c,s+10):$(e,s),O((u=_(o,n,s,1)).d,i=f,l))do{if(o=$(this,s+=10),n=t?z(c,s+10):$(e,s),u=_(o,n,s,1),!a){+E(u.d).slice(i+1,i+15)+1==1e14&&(u=k(u,f+1,0));break}}while(O(u.d,i+=10,l));return x=!0,k(u,f,l)},M.minus=M.sub=function(e){var t,r,n,i,a,o,s,u,c,f,l,p,m=this,h=m.constructor;if(e=new h(e),!m.d||!e.d)return m.s&&e.s?m.d?e.s=-e.s:e=new h(e.d||m.s!==e.s?m:NaN):e=new h(NaN),e;if(m.s!=e.s)return e.s=-e.s,m.plus(e);if(c=m.d,p=e.d,s=h.precision,u=h.rounding,!c[0]||!p[0]){if(p[0])e.s=-e.s;else{if(!c[0])return new h(3===u?-0:0);e=new h(m)}return x?k(e,s,u):e}if(r=P(e.e/U),f=P(m.e/U),c=c.slice(),a=f-r){for((l=a<0)?(t=c,a=-a,o=p.length):(t=p,r=f,o=c.length),(n=Math.max(Math.ceil(s/U),o)+2)<a&&(a=n,t.length=1),t.reverse(),n=a;n--;)t.push(0);t.reverse()}else{for((l=(n=c.length)<(o=p.length))&&(o=n),n=0;n<o;n++)if(c[n]!=p[n]){l=c[n]<p[n];break}a=0}for(l&&(t=c,c=p,p=t,e.s=-e.s),o=c.length,n=p.length-o;0<n;--n)c[o++]=0;for(n=p.length;a<n;){if(c[--n]<p[n]){for(i=n;i&&0===c[--i];)c[i]=R-1;--c[i],c[n]+=R}c[n]-=p[n]}for(;0===c[--o];)c.pop();for(;0===c[0];c.shift())--r;return c[0]?(e.d=c,e.e=C(c,r),x?k(e,s,u):e):new h(3===u?-0:0)},M.modulo=M.mod=function(e){var t,r=this.constructor;return e=new r(e),!this.d||!e.s||e.d&&!e.d[0]?new r(NaN):!e.d||this.d&&!this.d[0]?k(new r(this),r.precision,r.rounding):(x=!1,9==r.modulo?(t=_(this,e.abs(),0,3,1)).s*=e.s:t=_(this,e,0,r.modulo,1),t=t.times(e),x=!0,this.minus(t))},M.naturalExponential=M.exp=function(){return j(this)},M.naturalLogarithm=M.ln=function(){return $(this)},M.negated=M.neg=function(){var e=new this.constructor(this);return e.s=-e.s,k(e)},M.plus=M.add=function(e){var t,r,n,i,a,o,s,u,c,f,l=this,p=l.constructor;if(e=new p(e),!l.d||!e.d)return l.s&&e.s?l.d||(e=new p(e.d||l.s===e.s?l:NaN)):e=new p(NaN),e;if(l.s!=e.s)return e.s=-e.s,l.minus(e);if(c=l.d,f=e.d,s=p.precision,u=p.rounding,!c[0]||!f[0])return f[0]||(e=new p(l)),x?k(e,s,u):e;if(a=P(l.e/U),n=P(e.e/U),c=c.slice(),i=a-n){for(i<0?(r=c,i=-i,o=f.length):(r=f,n=a,o=c.length),(o=o<(a=Math.ceil(s/U))?a+1:o+1)<i&&(i=o,r.length=1),r.reverse();i--;)r.push(0);r.reverse()}for((o=c.length)-(i=f.length)<0&&(i=o,r=f,f=c,c=r),t=0;i;)t=(c[--i]=c[i]+f[i]+t)/R|0,c[i]%=R;for(t&&(c.unshift(t),++n),o=c.length;0==c[--o];)c.pop();return e.d=c,e.e=C(c,n),x?k(e,s,u):e},M.precision=M.sd=function(e){var t;if(void 0!==e&&e!==!!e&&1!==e&&0!==e)throw Error(v+e);return this.d?(t=q(this.d),e&&this.e+1>t&&(t=this.e+1)):t=NaN,t},M.round=function(){var e=this.constructor;return k(new e(this),this.e+1,e.rounding)},M.sine=M.sin=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+U,n.rounding=1,r=function(e,t){var r,n=t.d.length;if(n<3)return Z(e,2,t,t);r=16<(r=1.4*Math.sqrt(n))?16:0|r,t=t.times(Math.pow(5,-r)),t=Z(e,2,t,t);for(var i,a=new e(5),o=new e(16),s=new e(20);r--;)i=t.times(t),t=t.times(a.plus(i.times(o.times(i).minus(s))));return t}(n,V(n,r)),n.precision=e,n.rounding=t,k(2<o?r.neg():r,e,t,!0)):new n(NaN)},M.squareRoot=M.sqrt=function(){var e,t,r,n,i,a,o=this.d,s=this.e,u=this.s,c=this.constructor;if(1!==u||!o||!o[0])return new c(!u||u<0&&(!o||o[0])?NaN:o?this:1/0);for(x=!1,0==(u=Math.sqrt(+this))||u==1/0?(((t=E(o)).length+s)%2==0&&(t+="0"),u=Math.sqrt(t),s=P((s+1)/2)-(s<0||s%2),n=new c(t=u==1/0?"1e"+s:(t=u.toExponential()).slice(0,t.indexOf("e")+1)+s)):n=new c(u.toString()),r=(s=c.precision)+3;;)if(n=(a=n).plus(_(this,a,r+2,1)).times(.5),E(a.d).slice(0,r)===(t=E(n.d)).slice(0,r)){if("9999"!=(t=t.slice(r-3,r+1))&&(i||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(k(n,s+1,1),e=!n.times(n).eq(this));break}if(!i&&(k(a,s+1,0),a.times(a).eq(this))){n=a;break}r+=4,i=1}return x=!0,k(n,s,c.rounding,e)},M.tangent=M.tan=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+10,n.rounding=1,(r=r.sin()).s=1,r=_(r,new n(1).minus(r.times(r)).sqrt(),e+10,0),n.precision=e,n.rounding=t,k(2==o||4==o?r.neg():r,e,t,!0)):new n(NaN)},M.times=M.mul=function(e){var t,r,n,i,a,o,s,u,c,f=this.constructor,l=this.d,p=(e=new f(e)).d;if(e.s*=this.s,!(l&&l[0]&&p&&p[0]))return new f(!e.s||l&&!l[0]&&!p||p&&!p[0]&&!l?NaN:l&&p?0*e.s:e.s/0);for(r=P(this.e/U)+P(e.e/U),(u=l.length)<(c=p.length)&&(a=l,l=p,p=a,o=u,u=c,c=o),a=[],n=o=u+c;n--;)a.push(0);for(n=c;0<=--n;){for(t=0,i=u+n;n<i;)s=a[i]+p[n]*l[i-n-1]+t,a[i--]=s%R|0,t=s/R|0;a[i]=(a[i]+t)%R|0}for(;!a[--o];)a.pop();return t?++r:a.shift(),e.d=a,e.e=C(a,r),x?k(e,f.precision,f.rounding):e},M.toBinary=function(e,t){return r(this,2,e,t)},M.toDecimalPlaces=M.toDP=function(e,t){var r=this,n=r.constructor;return r=new n(r),void 0===e?r:(A(e,0,d),void 0===t?t=n.rounding:A(t,0,8),k(r,e+r.e+1,t))},M.toExponential=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=T(n,!0):(A(e,0,d),void 0===t?t=i.rounding:A(t,0,8),r=T(n=k(new i(n),e+1,t),!0,e+1)),n.isNeg()&&!n.isZero()?"-"+r:r},M.toFixed=function(e,t){var r,n,i=this.constructor;return void 0===e?r=T(this):(A(e,0,d),void 0===t?t=i.rounding:A(t,0,8),r=T(n=k(new i(this),e+this.e+1,t),!1,e+n.e+1)),this.isNeg()&&!this.isZero()?"-"+r:r},M.toFraction=function(e){var t,r,n,i,a,o,s,u,c,f,l,p,m=this.d,h=this.constructor;if(!m)return new h(this);if(c=r=new h(1),o=(a=(t=new h(n=u=new h(0))).e=q(m)-this.e-1)%U,t.d[0]=y(10,o<0?U+o:o),null==e)e=0<a?t:c;else{if(!(s=new h(e)).isInt()||s.lt(c))throw Error(v+s);e=s.gt(t)?0<a?t:c:s}for(x=!1,s=new h(E(m)),f=h.precision,h.precision=a=m.length*U*2;l=_(s,t,0,1,1),1!=(i=r.plus(l.times(n))).cmp(e);)r=n,n=i,i=c,c=u.plus(l.times(i)),u=i,i=t,t=s.minus(l.times(i)),s=i;return i=_(e.minus(r),n,0,1,1),u=u.plus(i.times(c)),r=r.plus(i.times(n)),u.s=c.s=this.s,p=_(c,n,a,1).minus(this).abs().cmp(_(u,r,a,1).minus(this).abs())<1?[c,n]:[u,r],h.precision=f,x=!0,p},M.toHexadecimal=M.toHex=function(e,t){return r(this,16,e,t)},M.toNearest=function(e,t){var r=this,n=r.constructor;if(r=new n(r),null==e){if(!r.d)return r;e=new n(1),t=n.rounding}else{if(e=new n(e),void 0!==t&&A(t,0,8),!r.d)return e.s?r:e;if(!e.d)return e.s&&(e.s=r.s),e}return e.d[0]?(x=!1,t<4&&(t=[4,5,7,8][t]),r=_(r,e,0,t,1).times(e),x=!0,k(r)):(e.s=r.s,r=e),r},M.toNumber=function(){return+this},M.toOctal=function(e,t){return r(this,8,e,t)},M.toPower=M.pow=function(e){var t,r,n,i,a,o,s=this,u=s.constructor,c=+(e=new u(e));if(!(s.d&&e.d&&s.d[0]&&e.d[0]))return new u(y(+s,c));if((s=new u(s)).eq(1))return s;if(n=u.precision,a=u.rounding,e.eq(1))return k(s,n,a);if((t=P(e.e/U))>=e.d.length-1&&(r=c<0?-c:c)<=9007199254740991)return i=L(u,s,r,n),e.s<0?new u(1).div(i):k(i,n,a);if((o=s.s)<0){if(t<e.d.length-1)return new u(NaN);if(0==(1&e.d[t])&&(o=1),0==s.e&&1==s.d[0]&&1==s.d.length)return s.s=o,s}return(t=0!=(r=y(+s,c))&&isFinite(r)?new u(r+"").e:P(c*(Math.log("0."+E(s.d))/Math.LN10+s.e+1)))>u.maxE+1||t<u.minE-1?new u(0<t?o/0:0):(x=!1,u.rounding=s.s=1,r=Math.min(12,(t+"").length),(i=j(e.times($(s,n+r)),n)).d&&O((i=k(i,n+5,1)).d,n,a)&&(t=n+10,+E((i=k(j(e.times($(s,t+r)),t),t+5,1)).d).slice(n+1,n+15)+1==1e14&&(i=k(i,n+1,0))),i.s=o,x=!0,k(i,n,u.rounding=a))},M.toPrecision=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=T(n,n.e<=i.toExpNeg||n.e>=i.toExpPos):(A(e,1,d),void 0===t?t=i.rounding:A(t,0,8),r=T(n=k(new i(n),e,t),e<=n.e||n.e<=i.toExpNeg,e)),n.isNeg()&&!n.isZero()?"-"+r:r},M.toSignificantDigits=M.toSD=function(e,t){var r=this.constructor;return void 0===e?(e=r.precision,t=r.rounding):(A(e,1,d),void 0===t?t=r.rounding:A(t,0,8)),k(new r(this),e,t)},M.toString=function(){var e=this.constructor,t=T(this,this.e<=e.toExpNeg||this.e>=e.toExpPos);return this.isNeg()&&!this.isZero()?"-"+t:t},M.truncated=M.trunc=function(){return k(new this.constructor(this),this.e+1,1)},M.valueOf=M.toJSON=function(){var e=this.constructor,t=T(this,this.e<=e.toExpNeg||this.e>=e.toExpPos);return this.isNeg()?"-"+t:t};var _=function(){function C(e,t,r){var n,i=0,a=e.length;for(e=e.slice();a--;)n=e[a]*t+i,e[a]=n%r|0,i=n/r|0;return i&&e.unshift(i),e}function z(e,t,r,n){var i,a;if(r!=n)a=n<r?1:-1;else for(i=a=0;i<r;i++)if(e[i]!=t[i]){a=e[i]>t[i]?1:-1;break}return a}function B(e,t,r,n){for(var i=0;r--;)e[r]-=i,i=e[r]<t[r]?1:0,e[r]=i*n+e[r]-t[r];for(;!e[0]&&1<e.length;)e.shift()}return function(e,t,r,n,i,a){var o,s,u,c,f,l,p,m,h,d,g,v,y,x,w,b,N,M,E,A,O=e.constructor,S=e.s==t.s?1:-1,_=e.d,T=t.d;if(!(_&&_[0]&&T&&T[0]))return new O(e.s&&t.s&&(_?!T||_[0]!=T[0]:T)?_&&0==_[0]||!T?0*S:S/0:NaN);for(a?(f=1,s=e.e-t.e):(a=R,f=U,s=P(e.e/f)-P(t.e/f)),E=T.length,N=_.length,d=(h=new O(S)).d=[],u=0;T[u]==(_[u]||0);u++);if(T[u]>(_[u]||0)&&s--,null==r?(x=r=O.precision,n=O.rounding):x=i?r+(e.e-t.e)+1:r,x<0)d.push(1),l=!0;else{if(x=x/f+2|0,u=0,1==E){for(T=T[c=0],x++;(u<N||c)&&x--;u++)w=c*a+(_[u]||0),d[u]=w/T|0,c=w%T|0;l=c||u<N}else{for(1<(c=a/(T[0]+1)|0)&&(T=C(T,c,a),_=C(_,c,a),E=T.length,N=_.length),b=E,v=(g=_.slice(0,E)).length;v<E;)g[v++]=0;for((A=T.slice()).unshift(0),M=T[0],T[1]>=a/2&&++M;c=0,(o=z(T,g,E,v))<0?(y=g[0],E!=v&&(y=y*a+(g[1]||0)),1<(c=y/M|0)?(a<=c&&(c=a-1),1==(o=z(p=C(T,c,a),g,m=p.length,v=g.length))&&(c--,B(p,E<m?A:T,m,a))):(0==c&&(o=c=1),p=T.slice()),(m=p.length)<v&&p.unshift(0),B(g,p,v,a),-1==o&&(o=z(T,g,E,v=g.length))<1&&(c++,B(g,E<v?A:T,v,a)),v=g.length):0===o&&(c++,g=[0]),d[u++]=c,o&&g[0]?g[v++]=_[b]||0:(g=[_[b]],v=1),(b++<N||void 0!==g[0])&&x--;);l=void 0!==g[0]}d[0]||d.shift()}if(1==f)h.e=s,I=l;else{for(u=1,c=d[0];10<=c;c/=10)u++;h.e=u+s*f-1,k(h,i?r+h.e+1:r,n,l)}return h}}();function k(e,t,r,n){var i,a,o,s,u,c,f,l,p,m=e.constructor;e:if(null!=t){if(!(l=e.d))return e;for(i=1,s=l[0];10<=s;s/=10)i++;if((a=t-i)<0)a+=U,o=t,u=(f=l[p=0])/y(10,i-o-1)%10|0;else if(p=Math.ceil((a+1)/U),(s=l.length)<=p){if(!n)break e;for(;s++<=p;)l.push(0);f=u=0,o=(a%=U)-U+(i=1)}else{for(f=s=l[p],i=1;10<=s;s/=10)i++;u=(o=(a%=U)-U+i)<0?0:f/y(10,i-o-1)%10|0}if(n=n||t<0||void 0!==l[p+1]||(o<0?f:f%y(10,i-o-1)),c=r<4?(u||n)&&(0==r||r==(e.s<0?3:2)):5<u||5==u&&(4==r||n||6==r&&(0<a?0<o?f/y(10,i-o):0:l[p-1])%10&1||r==(e.s<0?8:7)),t<1||!l[0])return l.length=0,c?(t-=e.e+1,l[0]=y(10,(U-t%U)%U),e.e=-t||0):l[0]=e.e=0,e;if(0==a?(l.length=p,s=1,p--):(l.length=p+1,s=y(10,U-a),l[p]=0<o?(f/y(10,i-o)%y(10,o)|0)*s:0),c)for(;;){if(0==p){for(a=1,o=l[0];10<=o;o/=10)a++;for(o=l[0]+=s,s=1;10<=o;o/=10)s++;a!=s&&(e.e++,l[0]==R&&(l[0]=1));break}if(l[p]+=s,l[p]!=R)break;l[p--]=0,s=1}for(a=l.length;0===l[--a];)l.pop()}return x&&(e.e>m.maxE?(e.d=null,e.e=NaN):e.e<m.minE&&(e.e=0,e.d=[0])),e}function T(e,t,r){if(!e.isFinite())return H(e);var n,i=e.e,a=E(e.d),o=a.length;return t?(r&&0<(n=r-o)?a=a.charAt(0)+"."+a.slice(1)+D(n):1<o&&(a=a.charAt(0)+"."+a.slice(1)),a=a+(e.e<0?"e":"e+")+e.e):i<0?(a="0."+D(-i-1)+a,r&&0<(n=r-o)&&(a+=D(n))):o<=i?(a+=D(i+1-o),r&&0<(n=r-i-1)&&(a=a+"."+D(n))):((n=i+1)<o&&(a=a.slice(0,n)+"."+a.slice(n)),r&&0<(n=r-o)&&(i+1===o&&(a+="."),a+=D(n))),a}function C(e,t){var r=e[0];for(t*=U;10<=r;r/=10)t++;return t}function z(e,t,r){if(b<t)throw x=!0,r&&(e.precision=r),Error(a);return k(new e(n),t,1,!0)}function B(e,t,r){if(N<t)throw Error(a);return k(new e(i),t,r,!0)}function q(e){var t=e.length-1,r=t*U+1;if(t=e[t]){for(;t%10==0;t/=10)r--;for(t=e[0];10<=t;t/=10)r++}return r}function D(e){for(var t="";e--;)t+="0";return t}function L(e,t,r,n){var i,a=new e(1),o=Math.ceil(n/U+4);for(x=!1;;){if(r%2&&W((a=a.times(t)).d,o)&&(i=!0),0===(r=P(r/2))){r=a.d.length-1,i&&0===a.d[r]&&++a.d[r];break}W((t=t.times(t)).d,o)}return x=!0,a}function F(e){return 1&e.d[e.d.length-1]}function t(e,t,r){for(var n,i=new e(t[0]),a=0;++a<t.length;){if(!(n=new e(t[a])).s){i=n;break}i[r](n)&&(i=n)}return i}function j(e,t){var r,n,i,a,o,s,u,c=0,f=0,l=0,p=e.constructor,m=p.rounding,h=p.precision;if(!e.d||!e.d[0]||17<e.e)return new p(e.d?e.d[0]?e.s<0?0:1/0:1:e.s?e.s<0?0:e:NaN);for(null==t?(x=!1,u=h):u=t,s=new p(.03125);-2<e.e;)e=e.times(s),l+=5;for(u+=n=Math.log(y(2,l))/Math.LN10*2+5|0,r=a=o=new p(1),p.precision=u;;){if(a=k(a.times(e),u,1),r=r.times(++f),E((s=o.plus(_(a,r,u,1))).d).slice(0,u)===E(o.d).slice(0,u)){for(i=l;i--;)o=k(o.times(o),u,1);if(null!=t)return p.precision=h,o;if(!(c<3&&O(o.d,u-n,m,c)))return k(o,p.precision=h,m,x=!0);p.precision=u+=10,r=a=s=new p(1),f=0,c++}o=s}}function $(e,t){var r,n,i,a,o,s,u,c,f,l,p,m=1,h=e,d=h.d,g=h.constructor,v=g.rounding,y=g.precision;if(h.s<0||!d||!d[0]||!h.e&&1==d[0]&&1==d.length)return new g(d&&!d[0]?-1/0:1!=h.s?NaN:d?0:h);if(null==t?(x=!1,f=y):f=t,g.precision=f+=10,n=(r=E(d)).charAt(0),!(Math.abs(a=h.e)<15e14))return c=z(g,f+2,y).times(a+""),h=$(new g(n+"."+r.slice(1)),f-10).plus(c),g.precision=y,null==t?k(h,y,v,x=!0):h;for(;n<7&&1!=n||1==n&&3<r.charAt(1);)n=(r=E((h=h.times(e)).d)).charAt(0),m++;for(a=h.e,1<n?(h=new g("0."+r),a++):h=new g(n+"."+r.slice(1)),u=o=h=_((l=h).minus(1),h.plus(1),f,1),p=k(h.times(h),f,1),i=3;;){if(o=k(o.times(p),f,1),E((c=u.plus(_(o,new g(i),f,1))).d).slice(0,f)===E(u.d).slice(0,f)){if(u=u.times(2),0!==a&&(u=u.plus(z(g,f+2,y).times(a+""))),u=_(u,new g(m),f,1),null!=t)return g.precision=y,u;if(!O(u.d,f-10,v,s))return k(u,g.precision=y,v,x=!0);g.precision=f+=10,c=o=h=_(l.minus(1),l.plus(1),f,1),p=k(h.times(h),f,1),i=s=1}u=c,i+=2}}function H(e){return String(e.s*e.s/0)}function G(e,t){var r,n,i;for(-1<(r=t.indexOf("."))&&(t=t.replace(".","")),0<(n=t.search(/e/i))?(r<0&&(r=n),r+=+t.slice(n+1),t=t.substring(0,n)):r<0&&(r=t.length),n=0;48===t.charCodeAt(n);n++);for(i=t.length;48===t.charCodeAt(i-1);--i);if(t=t.slice(n,i)){if(i-=n,e.e=r=r-n-1,e.d=[],n=(r+1)%U,r<0&&(n+=U),n<i){for(n&&e.d.push(+t.slice(0,n)),i-=U;n<i;)e.d.push(+t.slice(n,n+=U));t=t.slice(n),n=U-t.length}else n-=i;for(;n--;)t+="0";e.d.push(+t),x&&(e.e>e.constructor.maxE?(e.d=null,e.e=NaN):e.e<e.constructor.minE&&(e.e=0,e.d=[0]))}else e.e=0,e.d=[0];return e}function Z(e,t,r,n,i){var a,o,s,u,c=e.precision,f=Math.ceil(c/U);for(x=!1,u=r.times(r),s=new e(n);;){if(o=_(s.times(u),new e(t++*t++),c,1),s=i?n.plus(o):n.minus(o),n=_(o.times(u),new e(t++*t++),c,1),void 0!==(o=s.plus(n)).d[f]){for(a=f;o.d[a]===s.d[a]&&a--;);if(-1==a)break}a=s,s=n,n=o,o=a,0}return x=!0,o.d.length=f+1,o}function V(e,t){var r,n=t.s<0,i=B(e,e.precision,1),a=i.times(.5);if((t=t.abs()).lte(a))return o=n?4:1,t;if((r=t.divToInt(i)).isZero())o=n?3:2;else{if((t=t.minus(r.times(i))).lte(a))return o=F(r)?n?2:3:n?4:1,t;o=F(r)?n?1:4:n?3:2}return t.minus(i).abs()}function r(e,t,r,n){var i,a,o,s,u,c,f,l,p,m=e.constructor,h=void 0!==r;if(h?(A(r,1,d),void 0===n?n=m.rounding:A(n,0,8)):(r=m.precision,n=m.rounding),e.isFinite()){for(h?(i=2,16==t?r=4*r-3:8==t&&(r=3*r-2)):i=t,0<=(o=(f=T(e)).indexOf("."))&&(f=f.replace(".",""),(p=new m(1)).e=f.length-o,p.d=S(T(p),10,i),p.e=p.d.length),a=u=(l=S(f,10,i)).length;0==l[--u];)l.pop();if(l[0]){if(o<0?a--:((e=new m(e)).d=l,e.e=a,l=(e=_(e,p,r,n,0,i)).d,a=e.e,c=I),o=l[r],s=i/2,c=c||void 0!==l[r+1],c=n<4?(void 0!==o||c)&&(0===n||n===(e.s<0?3:2)):s<o||o===s&&(4===n||c||6===n&&1&l[r-1]||n===(e.s<0?8:7)),l.length=r,c)for(;++l[--r]>i-1;)l[r]=0,r||(++a,l.unshift(1));for(u=l.length;!l[u-1];--u);for(o=0,f="";o<u;o++)f+=g.charAt(l[o]);if(h){if(1<u)if(16==t||8==t){for(o=16==t?4:3,--u;u%o;u++)f+="0";for(u=(l=S(f,i,t)).length;!l[u-1];--u);for(o=1,f="1.";o<u;o++)f+=g.charAt(l[o])}else f=f.charAt(0)+"."+f.slice(1);f=f+(a<0?"p":"p+")+a}else if(a<0){for(;++a;)f="0"+f;f="0."+f}else if(++a>u)for(a-=u;a--;)f+="0";else a<u&&(f=f.slice(0,a)+"."+f.slice(a))}else f=h?"0p+0":"0";f=(16==t?"0x":2==t?"0b":8==t?"0o":"")+f}else f=H(e);return e.s<0?"-"+f:f}function W(e,t){if(e.length>t)return e.length=t,!0}function J(e){return new this(e).abs()}function Y(e){return new this(e).acos()}function X(e){return new this(e).acosh()}function Q(e,t){return new this(e).plus(t)}function K(e){return new this(e).asin()}function ee(e){return new this(e).asinh()}function te(e){return new this(e).atan()}function re(e){return new this(e).atanh()}function ne(e,t){e=new this(e),t=new this(t);var r,n=this.precision,i=this.rounding,a=n+4;return e.s&&t.s?e.d||t.d?!t.d||e.isZero()?(r=t.s<0?B(this,n,i):new this(0)).s=e.s:!e.d||t.isZero()?(r=B(this,a,1).times(.5)).s=e.s:t.s<0?(this.precision=a,this.rounding=1,r=this.atan(_(e,t,a,1)),t=B(this,a,1),this.precision=n,this.rounding=i,r=e.s<0?r.minus(t):r.plus(t)):r=this.atan(_(e,t,a,1)):(r=B(this,a,1).times(0<t.s?.25:.75)).s=e.s:r=new this(NaN),r}function ie(e){return new this(e).cbrt()}function ae(e){return k(e=new this(e),e.e+1,2)}function oe(e){if(!e||"object"!=typeof e)throw Error(c+"Object expected");var t,r,n,i=!0===e.defaults,a=["precision",1,d,"rounding",0,8,"toExpNeg",-s,0,"toExpPos",0,s,"maxE",0,s,"minE",-s,0,"modulo",0,9];for(t=0;t<a.length;t+=3)if(r=a[t],i&&(this[r]=u[r]),void 0!==(n=e[r])){if(!(P(n)===n&&a[t+1]<=n&&n<=a[t+2]))throw Error(v+r+": "+n);this[r]=n}if(r="crypto",i&&(this[r]=u[r]),void 0!==(n=e[r])){if(!0!==n&&!1!==n&&0!==n&&1!==n)throw Error(v+r+": "+n);if(n){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw Error(f);this[r]=!0}else this[r]=!1}return this}function se(e){return new this(e).cos()}function ue(e){return new this(e).cosh()}function ce(e,t){return new this(e).div(t)}function fe(e){return new this(e).exp()}function le(e){return k(e=new this(e),e.e+1,3)}function pe(){var e,t,r=new this(0);for(x=!1,e=0;e<arguments.length;)if((t=new this(arguments[e++])).d)r.d&&(r=r.plus(t.times(t)));else{if(t.s)return x=!0,new this(1/0);r=t}return x=!0,r.sqrt()}function me(e){return e instanceof l||e&&"[object Decimal]"===e.name||!1}function he(e){return new this(e).ln()}function de(e,t){return new this(e).log(t)}function ge(e){return new this(e).log(2)}function ve(e){return new this(e).log(10)}function ye(){return t(this,arguments,"lt")}function xe(){return t(this,arguments,"gt")}function we(e,t){return new this(e).mod(t)}function be(e,t){return new this(e).mul(t)}function Ne(e,t){return new this(e).pow(t)}function Me(e){var t,r,n,i,a=0,o=new this(1),s=[];if(void 0===e?e=this.precision:A(e,1,d),n=Math.ceil(e/U),this.crypto)if(crypto.getRandomValues)for(t=crypto.getRandomValues(new Uint32Array(n));a<n;)429e7<=(i=t[a])?t[a]=crypto.getRandomValues(new Uint32Array(1))[0]:s[a++]=i%1e7;else{if(!crypto.randomBytes)throw Error(f);for(t=crypto.randomBytes(n*=4);a<n;)214e7<=(i=t[a]+(t[a+1]<<8)+(t[a+2]<<16)+((127&t[a+3])<<24))?crypto.randomBytes(4).copy(t,a):(s.push(i%1e7),a+=4);a=n/4}else for(;a<n;)s[a++]=1e7*Math.random()|0;for(n=s[--a],e%=U,n&&e&&(i=y(10,U-e),s[a]=(n/i|0)*i);0===s[a];a--)s.pop();if(a<0)s=[r=0];else{for(r=-1;0===s[0];r-=U)s.shift();for(n=1,i=s[0];10<=i;i/=10)n++;n<U&&(r-=U-n)}return o.e=r,o.d=s,o}function Ee(e){return k(e=new this(e),e.e+1,this.rounding)}function Ae(e){return(e=new this(e)).d?e.d[0]?e.s:0*e.s:e.s||NaN}function Oe(e){return new this(e).sin()}function Se(e){return new this(e).sinh()}function _e(e){return new this(e).sqrt()}function Te(e,t){return new this(e).sub(t)}function Ce(e){return new this(e).tan()}function ze(e){return new this(e).tanh()}function Be(e){return k(e=new this(e),e.e+1,1)}(l=function e(t){var r,n,i;function a(e){var t,r,n,i=this;if(!(i instanceof a))return new a(e);if(e instanceof(i.constructor=a))return i.s=e.s,i.e=e.e,void(i.d=(e=e.d)?e.slice():e);if("number"==(n=typeof e)){if(0===e)return i.s=1/e<0?-1:1,i.e=0,void(i.d=[0]);if(e<0?(e=-e,i.s=-1):i.s=1,e===~~e&&e<1e7){for(t=0,r=e;10<=r;r/=10)t++;return i.e=t,void(i.d=[e])}return 0*e!=0?(e||(i.s=NaN),i.e=NaN,void(i.d=null)):G(i,e.toString())}if("string"!==n)throw Error(v+e);return 45===e.charCodeAt(0)?(e=e.slice(1),i.s=-1):i.s=1,w.test(e)?G(i,e):function(e,t){var r,n,i,a,o,s,u,c,f;if("Infinity"===t||"NaN"===t)return+t||(e.s=NaN),e.e=NaN,e.d=null,e;if(m.test(t))r=16,t=t.toLowerCase();else if(p.test(t))r=2;else{if(!h.test(t))throw Error(v+t);r=8}for(0<(a=t.search(/p/i))?(u=+t.slice(a+1),t=t.substring(2,a)):t=t.slice(2),o=0<=(a=t.indexOf(".")),n=e.constructor,o&&(a=(s=(t=t.replace(".","")).length)-a,i=L(n,new n(r),a,2*a)),a=f=(c=S(t,r,R)).length-1;0===c[a];--a)c.pop();return a<0?new n(0*e.s):(e.e=C(c,f),e.d=c,x=!1,o&&(e=_(e,i,4*s)),u&&(e=e.times(Math.abs(u)<54?Math.pow(2,u):l.pow(2,u))),x=!0,e)}(i,e)}if(a.prototype=M,a.ROUND_UP=0,a.ROUND_DOWN=1,a.ROUND_CEIL=2,a.ROUND_FLOOR=3,a.ROUND_HALF_UP=4,a.ROUND_HALF_DOWN=5,a.ROUND_HALF_EVEN=6,a.ROUND_HALF_CEIL=7,a.ROUND_HALF_FLOOR=8,a.EUCLID=9,a.config=a.set=oe,a.clone=e,a.isDecimal=me,a.abs=J,a.acos=Y,a.acosh=X,a.add=Q,a.asin=K,a.asinh=ee,a.atan=te,a.atanh=re,a.atan2=ne,a.cbrt=ie,a.ceil=ae,a.cos=se,a.cosh=ue,a.div=ce,a.exp=fe,a.floor=le,a.hypot=pe,a.ln=he,a.log=de,a.log10=ve,a.log2=ge,a.max=ye,a.min=xe,a.mod=we,a.mul=be,a.pow=Ne,a.random=Me,a.round=Ee,a.sign=Ae,a.sin=Oe,a.sinh=Se,a.sqrt=_e,a.sub=Te,a.tan=Ce,a.tanh=ze,a.trunc=Be,void 0===t&&(t={}),t&&!0!==t.defaults)for(i=["precision","rounding","toExpNeg","toExpPos","maxE","minE","modulo","crypto"],r=0;r<i.length;)t.hasOwnProperty(n=i[r++])||(t[n]=this[n]);return a.config(t),a}(u)).default=l.Decimal=l,n=new l(n),i=new l(i),void 0===(Ue=function(){return l}.call(Pe,Re,Pe,Ie))||(Ie.exports=Ue)}()},function(e,t,r){var o=r(548);t.name="BigNumber",t.path="type",t.factory=function(e,t,r,n,i){var a=o.clone({precision:t.precision});return a.prototype.type="BigNumber",a.prototype.isBigNumber=!0,a.prototype.toJSON=function(){return{mathjs:"BigNumber",value:this.toString()}},a.fromJSON=function(e){return new a(e.value)},i.on("config",function(e,t){e.precision!==t.precision&&a.config({precision:e.precision})}),a},t.math=!0},function(e,t,r){e.exports=[r(549),r(547)]},function(e,t,r){e.exports=[r(550),r(546),r(545),r(541),r(537),r(534),r(87),r(526),r(525),r(524)]},function(e,t,r){e.exports=[r(551),r(518),r(516),r(299),r(151),r(149)]},function(e,t,r){var u=r(5);function c(e,t,r){if(void 0!==e[t]&&(o=r,s=e[t],-1===o.indexOf(s))){var n=(i=r,a=e[t],i.map(function(e){return e.toLowerCase()}).indexOf(a.toLowerCase()));-1!==n?(console.warn('Warning: Wrong casing for configuration option "'+t+'", should be "'+r[n]+'" instead of "'+e[t]+'".'),e[t]=r[n]):console.warn('Warning: Unknown value "'+e[t]+'" for configuration option "'+t+'". Available options: '+r.map(JSON.stringify).join(", ")+".")}var i,a,o,s}t.name="config",t.math=!0,t.factory=function(e,i,t,r,a){var o=["Matrix","Array"],s=["number","BigNumber","Fraction"];function n(e){if(e){var t=u.map(i,u.clone);c(e,"matrix",o),c(e,"number",s),u.deepExtend(i,e);var r=u.map(i,u.clone),n=u.map(e,u.clone);return a.emit("config",r,t,n),r}return u.map(i,u.clone)}return n.MATRIX=o,n.NUMBER=s,n}},function(e,t,r){var d=r(5).lazy,g=r(5).isFactory,v=r(5).traverse,y=r(53);t.math=!0,t.name="import",t.factory=function(s,e,u,c,f){function l(e,t,r){if(r.wrap&&"function"==typeof t&&(n=function(){for(var e=[],t=0,r=arguments.length;t<r;t++){var n=arguments[t];e[t]=n&&n.valueOf()}return i.apply(f,e)},(i=t).transform&&(n.transform=i.transform),t=n),m(f[e])&&m(t))return t=r.override?c(e,t.signatures):c(f[e],t),a(e,f[e]=t),void f.emit("import",e,function(){return t});var i,n;if(void 0===f[e]||r.override)return a(e,f[e]=t),void f.emit("import",e,function(){return t});if(!r.silent)throw new Error('Cannot import "'+e+'": already exists')}function a(e,t){t&&"function"==typeof t.transform?(f.expression.transform[e]=t.transform,r(e)&&(f.expression.mathWithTransform[e]=t.transform)):(delete f.expression.transform[e],r(e)&&(f.expression.mathWithTransform[e]=t))}function p(t,r){if("string"==typeof t.name){var n=t.name,e=n in f.expression.transform,i=t.path?v(f,t.path):f,a=i.hasOwnProperty(n)?i[n]:void 0,o=function(){var e=u(t);if(e&&"function"==typeof e.transform)throw new Error('Transforms cannot be attached to factory functions. Please create a separate function for it with exports.path="expression.transform"');if(m(a)&&m(e))return r.override||(e=c(a,e)),e;if(void 0===a||r.override)return e;if(!r.silent)throw new Error('Cannot import "'+n+'": already exists')};!1!==t.lazy?(d(i,n,o),e||("expression.transform"===t.path||h(t))&&d(f.expression.mathWithTransform,n,o)):(i[n]=o(),e||("expression.transform"===t.path||h(t))&&(f.expression.mathWithTransform[n]=o())),f.emit("import",n,o,t.path)}else u(t)}function m(e){return"function"==typeof e&&"object"==typeof e.signatures}function r(e){return!t.hasOwnProperty(e)}function h(e){return void 0===e.path&&!t.hasOwnProperty(e.name)}var t={expression:!0,type:!0,docs:!0,error:!0,json:!0,chain:!0};return function t(e,r){var n,i=arguments.length;if(1!==i&&2!==i)throw new y("import",i,1,2);if(r||(r={}),g(e))p(e,r);else if(Array.isArray(e))e.forEach(function(e){t(e,r)});else if("object"==typeof e){for(var a in e)if(e.hasOwnProperty(a)){var o=e[a];"function"==typeof(n=o)||"number"==typeof n||"string"==typeof n||"boolean"==typeof n||null===n||n&&s.isUnit(n)||n&&s.isComplex(n)||n&&s.isBigNumber(n)||n&&s.isFraction(n)||n&&s.isMatrix(n)||n&&Array.isArray(n)?l(a,o,r):g(e)?p(e,r):t(o,r)}}else if(!r.silent)throw new TypeError("Factory, Object, or Array expected")}},t.lazy=!0},function(e,t){function r(){}r.prototype={on:function(e,t,r){var n=this.e||(this.e={});return(n[e]||(n[e]=[])).push({fn:t,ctx:r}),this},once:function(e,t,r){var n=this;function i(){n.off(e,i),t.apply(r,arguments)}return i._=t,this.on(e,i,r)},emit:function(e){for(var t=[].slice.call(arguments,1),r=((this.e||(this.e={}))[e]||[]).slice(),n=0,i=r.length;n<i;n++)r[n].fn.apply(r[n].ctx,t);return this},off:function(e,t){var r=this.e||(this.e={}),n=r[e],i=[];if(n&&t)for(var a=0,o=n.length;a<o;a++)n[a].fn!==t&&n[a].fn._!==t&&i.push(n[a]);return i.length?r[e]=i:delete r[e],this}},e.exports=r},function(e,t,r){var n,i,a;i=[],void 0===(a="function"==typeof(n=function(){function v(){return!0}function ce(){return!1}function fe(){}return function e(){var t=[{name:"number",test:function(e){return"number"==typeof e}},{name:"string",test:function(e){return"string"==typeof e}},{name:"boolean",test:function(e){return"boolean"==typeof e}},{name:"Function",test:function(e){return"function"==typeof e}},{name:"Array",test:Array.isArray},{name:"Date",test:function(e){return e instanceof Date}},{name:"RegExp",test:function(e){return e instanceof RegExp}},{name:"Object",test:function(e){return"object"==typeof e&&e.constructor===Object}},{name:"null",test:function(e){return null===e}},{name:"undefined",test:function(e){return void 0===e}}],n={name:"any",test:v},r=[],i=[],j={types:t,conversions:i,ignore:r};function f(t){var e=se(j.types,function(e){return e.name===t});if(e)return e;if("any"===t)return n;var r=se(j.types,function(e){return e.name.toLowerCase()===t.toLowerCase()});throw new TypeError('Unknown type "'+t+'"'+(r?'. Did you mean "'+r.name+'"?':""))}function l(e){return e===n?999:j.types.indexOf(e)}function $(t){var e=se(j.types,function(e){return e.test(t)});if(e)return e.name;throw new TypeError("Value has unknown type. Value: "+t)}function H(e){return e.map(function(e){var t=e.types.map(a);return(e.restParam?"...":"")+t.join("|")}).join(",")}function G(e,r){var t,n,i=0===e.indexOf("..."),a=i?3<e.length?e.slice(3):"any":e,o=a.split("|").map(re).filter(h).filter(m),s=(t=o,n={},r.forEach(function(e){-1!==t.indexOf(e.from)||-1===t.indexOf(e.to)||n[e.from]||(n[e.from]=e)}),Object.keys(n).map(function(e){return n[e]})),u=o.map(function(e){var t=f(e);return{name:e,typeIndex:l(t),test:t.test,conversion:null,conversionIndex:-1}}),c=s.map(function(e){var t=f(e.from);return{name:e.from,typeIndex:l(t),test:t.test,conversion:e,conversionIndex:r.indexOf(e)}});return{types:u.concat(c),restParam:i}}function Z(e){var t=d(e);return!!t&&t.restParam}function V(e){return e.types.some(function(e){return null!=e.conversion})}function W(e){if(e&&0!==e.types.length){if(1===e.types.length)return f(e.types[0].name).test;if(2===e.types.length){var t=f(e.types[0].name).test,r=f(e.types[1].name).test;return function(e){return t(e)||r(e)}}var n=e.types.map(function(e){return f(e.name).test});return function(e){for(var t=0;t<n.length;t++)if(n[t](e))return!0;return!1}}return v}function J(e){var r,t,n,i;if(Z(e)){var a=(r=(i=e,i.slice(0,i.length-1)).map(W)).length,o=W(d(e));return function(e){for(var t=0;t<r.length;t++)if(!r[t](e[t]))return!1;return function(e){for(var t=a;t<e.length;t++)if(!o(e[t]))return!1;return!0}(e)&&e.length>=a+1}}return 0===e.length?function(e){return 0===e.length}:1===e.length?(t=W(e[0]),function(e){return t(e[0])&&1===e.length}):2===e.length?(t=W(e[0]),n=W(e[1]),function(e){return t(e[0])&&n(e[1])&&2===e.length}):(r=e.map(W),function(e){for(var t=0;t<r.length;t++)if(!r[t](e[t]))return!1;return e.length===r.length})}function Y(e,t){return t<e.params.length?e.params[t]:Z(e.params)?d(e.params):null}function X(e,t,r){var n=Y(e,t),i=n?r?n.types.filter(p):n.types:[];return i.map(a)}function a(e){return e.name}function p(e){return null===e.conversion||void 0===e.conversion}function Q(e,t){var r=function(e){for(var t={},r=0;r<e.length;r++)t[e[r]]=!0;return Object.keys(t)}(ue(e,function(e){return X(e,t,!1)}));return-1!==r.indexOf("any")?["any"]:r}function o(e){for(var t=999,r=0;r<e.types.length;r++)p(e.types[r])&&(t=Math.min(t,e.types[r].typeIndex));return t}function s(e){for(var t=999,r=0;r<e.types.length;r++)p(e.types[r])||(t=Math.min(t,e.types[r].conversionIndex));return t}function u(e,t){var r;return 0!=(r=e.restParam-t.restParam)?r:0!=(r=V(e)-V(t))?r:0!=(r=o(e)-o(t))?r:s(e)-s(t)}function K(e,t){var r,n,i=Math.min(e.params.length,t.params.length);if(0!=(n=e.params.some(V)-t.params.some(V)))return n;for(r=0;r<i;r++)if(0!=(n=V(e.params[r])-V(t.params[r])))return n;for(r=0;r<i;r++)if(0!==(n=u(e.params[r],t.params[r])))return n;return e.params.length-t.params.length}function ee(e){var t,r,n,i,a=[],o=[];switch(e.types.forEach(function(e){e.conversion&&(a.push(f(e.conversion.from).test),o.push(e.conversion.convert))}),o.length){case 0:return function(e){return e};case 1:return t=a[0],n=o[0],function(e){return t(e)?n(e):e};case 2:return t=a[0],r=a[1],n=o[0],i=o[1],function(e){return t(e)?n(e):r(e)?i(e):e};default:return function(e){for(var t=0;t<o.length;t++)if(a[t](e))return o[t](e);return e}}}function te(e,c){return function t(r,n,i){if(n<r.length){var e,a=r[n],o=c?a.types.filter(p):a.types;if(a.restParam){var s=o.filter(p);e=s.length<o.length?[s,o]:[o]}else e=o.map(function(e){return[e]});return ue(e,function(e){return t(r,n+1,i.concat([e]))})}var u=i.map(function(e,t){return{types:e,restParam:t===r.length-1&&Z(r)}});return[u]}(e,0,[])}function c(t,a){if(0===Object.keys(a).length)throw new SyntaxError("No signatures provided");var r=[];Object.keys(a).map(function(e){return r=a[t=e],i=j.conversions,n=[],""!==t.trim()&&(n=t.split(",").map(re).map(function(e,t,r){var n=G(e,i);if(n.restParam&&t!==r.length-1)throw new SyntaxError('Unexpected rest parameter "'+e+'": only allowed for the last parameter');return n})),n.some(ie)?null:{params:n,fn:r};var t,r,i,n}).filter(ne).forEach(function(t){var e=se(r,function(e){return function(e,t){for(var r=Math.max(e.params.length,t.params.length),n=0;n<r;n++){var i=X(e,n,!0),a=X(t,n,!0);if(!oe(i,a))return!1}var o=e.params.length,s=t.params.length,u=Z(e.params),c=Z(t.params);return u?c?o===s:o<=s:c?s<=o:o===s}(e,t)});if(e)throw new TypeError('Conflicting signatures "'+H(e.params)+'" and "'+H(t.params)+'".');r.push(t)});var n=ue(r,function(t){var e=t?te(t.params,!1):[];return e.map(function(e){return{params:e,fn:t.fn}})}).filter(ne);n.sort(K);var i,e=n[0]&&n[0].params.length<=2&&!Z(n[0].params),o=n[1]&&n[1].params.length<=2&&!Z(n[1].params),s=n[2]&&n[2].params.length<=2&&!Z(n[2].params),u=n[3]&&n[3].params.length<=2&&!Z(n[3].params),c=n[4]&&n[4].params.length<=2&&!Z(n[4].params),f=n[5]&&n[5].params.length<=2&&!Z(n[5].params),l=e&&o&&s&&u&&c&&f,p=n.map(function(e){return J(e.params)}),m=e?W(n[0].params[0]):ce,h=o?W(n[1].params[0]):ce,d=s?W(n[2].params[0]):ce,g=u?W(n[3].params[0]):ce,v=c?W(n[4].params[0]):ce,y=f?W(n[5].params[0]):ce,x=e?W(n[0].params[1]):ce,w=o?W(n[1].params[1]):ce,b=s?W(n[2].params[1]):ce,N=u?W(n[3].params[1]):ce,M=c?W(n[4].params[1]):ce,E=f?W(n[5].params[1]):ce,A=n.map(function(e){return function(e,n){var t=n;if(e.some(V)){var i=Z(e),a=e.map(ee);t=function(){for(var e=[],t=i?arguments.length-1:arguments.length,r=0;r<t;r++)e[r]=a[r](arguments[r]);return i&&(e[t]=arguments[t].map(a[t])),n.apply(null,e)}}var r=t;if(Z(e)){var o=e.length-1;r=function(){return t.apply(null,ae(arguments,0,o).concat([ae(arguments,o)]))}}return r}(e.params,e.fn)}),O=e?A[0]:fe,S=o?A[1]:fe,_=s?A[2]:fe,T=u?A[3]:fe,C=c?A[4]:fe,z=f?A[5]:fe,B=e?n[0].params.length:-1,I=o?n[1].params.length:-1,P=s?n[2].params.length:-1,R=u?n[3].params.length:-1,U=c?n[4].params.length:-1,k=f?n[5].params.length:-1,q=l?6:0,D=n.length,L=function(){for(var e=q;e<D;e++)if(p[e](arguments))return A[e].apply(null,arguments);throw function(e,r,t){var n,i,a,o=e||"unnamed",s=t;for(a=0;a<r.length;a++){var u=s.filter(function(e){var t=W(Y(e,a));return(a<e.params.length||Z(e.params))&&t(r[a])});if(0===u.length){if(0<(i=Q(s,a)).length){var c=$(r[a]);return(n=new TypeError("Unexpected type of argument in function "+o+" (expected: "+i.join(" or ")+", actual: "+c+", index: "+a+")")).data={category:"wrongType",fn:o,index:a,actual:c,expected:i},n}}else s=u}var f=s.map(function(e){return Z(e.params)?1/0:e.params.length});if(r.length<Math.min.apply(null,f))return i=Q(s,a),(n=new TypeError("Too few arguments in function "+o+" (expected: "+i.join(" or ")+", index: "+r.length+")")).data={category:"tooFewArgs",fn:o,index:r.length,expected:i},n;var l=Math.max.apply(null,f);return r.length>l?(n=new TypeError("Too many arguments in function "+o+" (expected: "+l+", actual: "+r.length+")")).data={category:"tooManyArgs",fn:o,index:r.length,expectedLength:l}:(n=new TypeError('Arguments of type "'+r.join(", ")+'" do not match any of the defined signatures of function '+o+".")).data={category:"mismatch",actual:r.map($)},n}(t,arguments,n)},F=function(e,t){return arguments.length===B&&m(e)&&x(t)?O.apply(null,arguments):arguments.length===I&&h(e)&&w(t)?S.apply(null,arguments):arguments.length===P&&d(e)&&b(t)?_.apply(null,arguments):arguments.length===R&&g(e)&&N(t)?T.apply(null,arguments):arguments.length===U&&v(e)&&M(t)?C.apply(null,arguments):arguments.length===k&&y(e)&&E(t)?z.apply(null,arguments):L.apply(null,arguments)};try{Object.defineProperty(F,"name",{value:t})}catch(e){}return F.signatures=(i={},n.forEach(function(t){t.params.some(V)||te(t.params,!0).forEach(function(e){i[H(e)]=t.fn})}),i),F}function m(e){return-1===j.ignore.indexOf(e)}function re(e){return e.trim()}function h(e){return!!e}function ne(e){return null!==e}function ie(e){return 0===e.types.length}function d(e){return e[e.length-1]}function ae(e,t,r){return Array.prototype.slice.call(e,t,r)}function oe(e,t){for(var r=0;r<e.length;r++)if(n=t,i=e[r],-1!==n.indexOf(i))return!0;var n,i;return!1}function se(e,t){for(var r=0;r<e.length;r++)if(t(e[r]))return e[r]}function ue(e,t){return Array.prototype.concat.apply([],e.map(t))}function g(e){for(var t="",r=0;r<e.length;r++){var n=e[r];if(n.signatures&&""!==n.name)if(""===t)t=n.name;else if(t!==n.name){var i=new Error("Function names do not match (expected: "+t+", actual: "+n.name+")");throw i.data={actual:n.name,expected:t},i}}return t}return(j=c("typed",{"string, Object":c,Object:function(e){var t=[];for(var r in e)e.hasOwnProperty(r)&&t.push(e[r]);var n=g(t);return c(n,e)},"...Function":function(e){for(var t,r=g(e),n={},i=0;i<e.length;i++){var a=e[i];if("object"!=typeof a.signatures)throw(t=new TypeError("Function is no typed-function (index: "+i+")")).data={index:i},t;for(var o in a.signatures)if(a.signatures.hasOwnProperty(o))if(n.hasOwnProperty(o)){if(a.signatures[o]!==n[o])throw(t=new Error('Signature "'+o+'" is defined twice')).data={signature:o},t}else n[o]=a.signatures[o]}return c(r,n)}})).create=e,j.types=t,j.conversions=i,j.ignore=r,j.convert=function(e,t){var r=$(e);if(t===r)return e;for(var n=0;n<j.conversions.length;n++){var i=j.conversions[n];if(i.from===r&&i.to===t)return i.convert(e)}throw new Error("Cannot convert from "+r+" to "+t)},j.find=function(e,t){if(!e.signatures)throw new TypeError("Function is no typed-function");var r;if("string"==typeof t){r=t.split(",");for(var n=0;n<r.length;n++)r[n]=r[n].trim()}else{if(!Array.isArray(t))throw new TypeError("String array or a comma separated string expected");r=t}var i=r.join(","),a=e.signatures[i];if(a)return a;throw new TypeError("Signature not found (signature: "+(e.name||"unnamed")+"("+r.join(", ")+"))")},j.addType=function(e){if(!e||"string"!=typeof e.name||"function"!=typeof e.test)throw new TypeError("Object with properties {name: string, test: function} expected");j.types.push(e)},j.addConversion=function(e){if(!e||"string"!=typeof e.from||"string"!=typeof e.to||"function"!=typeof e.convert)throw new TypeError("Object with properties {from: string, to: string, convert: function} expected");j.conversions.push(e)},j}()})?n.apply(t,i):n)||(e.exports=a)},function(e,t,r){var n=r(556),i=r(3).digits,a=r(90),o=r(72),s=function(){return s=n.create,n};t.create=function(r){r.isNumber=function(e){return"number"==typeof e},r.isComplex=function(e){return r.Complex&&e instanceof r.Complex||!1},r.isBigNumber=a,r.isFraction=function(e){return r.Fraction&&e instanceof r.Fraction||!1},r.isUnit=function(e){return e&&e.constructor.prototype.isUnit||!1},r.isString=function(e){return"string"==typeof e},r.isArray=Array.isArray,r.isMatrix=o,r.isDenseMatrix=function(e){return e&&e.isDenseMatrix&&e.constructor.prototype.isMatrix||!1},r.isSparseMatrix=function(e){return e&&e.isSparseMatrix&&e.constructor.prototype.isMatrix||!1},r.isRange=function(e){return e&&e.constructor.prototype.isRange||!1},r.isIndex=function(e){return e&&e.constructor.prototype.isIndex||!1},r.isBoolean=function(e){return"boolean"==typeof e},r.isResultSet=function(e){return e&&e.constructor.prototype.isResultSet||!1},r.isHelp=function(e){return e&&e.constructor.prototype.isHelp||!1},r.isFunction=function(e){return"function"==typeof e},r.isDate=function(e){return e instanceof Date},r.isRegExp=function(e){return e instanceof RegExp},r.isObject=function(e){return"object"==typeof e&&e.constructor===Object&&!r.isComplex(e)&&!r.isFraction(e)},r.isNull=function(e){return null===e},r.isUndefined=function(e){return void 0===e},r.isAccessorNode=function(e){return e&&e.isAccessorNode&&e.constructor.prototype.isNode||!1},r.isArrayNode=function(e){return e&&e.isArrayNode&&e.constructor.prototype.isNode||!1},r.isAssignmentNode=function(e){return e&&e.isAssignmentNode&&e.constructor.prototype.isNode||!1},r.isBlockNode=function(e){return e&&e.isBlockNode&&e.constructor.prototype.isNode||!1},r.isConditionalNode=function(e){return e&&e.isConditionalNode&&e.constructor.prototype.isNode||!1},r.isConstantNode=function(e){return e&&e.isConstantNode&&e.constructor.prototype.isNode||!1},r.isFunctionAssignmentNode=function(e){return e&&e.isFunctionAssignmentNode&&e.constructor.prototype.isNode||!1},r.isFunctionNode=function(e){return e&&e.isFunctionNode&&e.constructor.prototype.isNode||!1},r.isIndexNode=function(e){return e&&e.isIndexNode&&e.constructor.prototype.isNode||!1},r.isNode=function(e){return e&&e.isNode&&e.constructor.prototype.isNode||!1},r.isObjectNode=function(e){return e&&e.isObjectNode&&e.constructor.prototype.isNode||!1},r.isOperatorNode=function(e){return e&&e.isOperatorNode&&e.constructor.prototype.isNode||!1},r.isParenthesisNode=function(e){return e&&e.isParenthesisNode&&e.constructor.prototype.isNode||!1},r.isRangeNode=function(e){return e&&e.isRangeNode&&e.constructor.prototype.isNode||!1},r.isSymbolNode=function(e){return e&&e.isSymbolNode&&e.constructor.prototype.isNode||!1},r.isChain=function(e){return e&&e.constructor.prototype.isChain||!1};var e=s();return e.types=[{name:"number",test:r.isNumber},{name:"Complex",test:r.isComplex},{name:"BigNumber",test:r.isBigNumber},{name:"Fraction",test:r.isFraction},{name:"Unit",test:r.isUnit},{name:"string",test:r.isString},{name:"Array",test:r.isArray},{name:"Matrix",test:r.isMatrix},{name:"DenseMatrix",test:r.isDenseMatrix},{name:"SparseMatrix",test:r.isSparseMatrix},{name:"Range",test:r.isRange},{name:"Index",test:r.isIndex},{name:"boolean",test:r.isBoolean},{name:"ResultSet",test:r.isResultSet},{name:"Help",test:r.isHelp},{name:"function",test:r.isFunction},{name:"Date",test:r.isDate},{name:"RegExp",test:r.isRegExp},{name:"null",test:r.isNull},{name:"undefined",test:r.isUndefined},{name:"OperatorNode",test:r.isOperatorNode},{name:"ConstantNode",test:r.isConstantNode},{name:"SymbolNode",test:r.isSymbolNode},{name:"ParenthesisNode",test:r.isParenthesisNode},{name:"FunctionNode",test:r.isFunctionNode},{name:"FunctionAssignmentNode",test:r.isFunctionAssignmentNode},{name:"ArrayNode",test:r.isArrayNode},{name:"AssignmentNode",test:r.isAssignmentNode},{name:"BlockNode",test:r.isBlockNode},{name:"ConditionalNode",test:r.isConditionalNode},{name:"IndexNode",test:r.isIndexNode},{name:"RangeNode",test:r.isRangeNode},{name:"Node",test:r.isNode},{name:"Object",test:r.isObject}],e.conversions=[{from:"number",to:"BigNumber",convert:function(e){if(15<i(e))throw new TypeError("Cannot implicitly convert a number with >15 significant digits to BigNumber (value: "+e+"). Use function bignumber(x) to convert to BigNumber.");return new r.BigNumber(e)}},{from:"number",to:"Complex",convert:function(e){return new r.Complex(e,0)}},{from:"number",to:"string",convert:function(e){return e+""}},{from:"BigNumber",to:"Complex",convert:function(e){return new r.Complex(e.toNumber(),0)}},{from:"Fraction",to:"BigNumber",convert:function(e){throw new TypeError("Cannot implicitly convert a Fraction to BigNumber or vice versa. Use function bignumber(x) to convert to BigNumber or fraction(x) to convert to Fraction.")}},{from:"Fraction",to:"Complex",convert:function(e){return new r.Complex(e.valueOf(),0)}},{from:"number",to:"Fraction",convert:function(e){if(new r.Fraction(e).valueOf()!==e)throw new TypeError("Cannot implicitly convert a number to a Fraction when there will be a loss of precision (value: "+e+"). Use function fraction(x) to convert to Fraction.");return new r.Fraction(e)}},{from:"string",to:"number",convert:function(e){var t=Number(e);if(isNaN(t))throw new Error('Cannot convert "'+e+'" to a number');return t}},{from:"string",to:"BigNumber",convert:function(t){try{return new r.BigNumber(t)}catch(e){throw new Error('Cannot convert "'+t+'" to BigNumber')}}},{from:"string",to:"Fraction",convert:function(t){try{return new r.Fraction(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Fraction')}}},{from:"string",to:"Complex",convert:function(t){try{return new r.Complex(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Complex')}}},{from:"boolean",to:"number",convert:function(e){return+e}},{from:"boolean",to:"BigNumber",convert:function(e){return new r.BigNumber(+e)}},{from:"boolean",to:"Fraction",convert:function(e){return new r.Fraction(+e)}},{from:"boolean",to:"string",convert:function(e){return+e}},{from:"Array",to:"Matrix",convert:function(e){return new r.DenseMatrix(e)}},{from:"Matrix",to:"Array",convert:function(e){return e.valueOf()}}],e}},function(e,t,r){var u=r(5).isFactory,c=r(557),f=r(148),l=r(554),p=r(553);t.create=function(e){if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var n=[],i=[],a=f.mixin({});a.type={},a.expression={transform:{},mathWithTransform:{}},a.typed=c.create(a.type);var o={epsilon:1e-12,matrix:"Matrix",number:"number",precision:64,predictable:!1,randomSeed:null};function s(e){if(!u(e))throw new Error("Factory object with properties `type`, `name`, and `factory` expected");var t,r=n.indexOf(e);return-1===r?(t=!0===e.math?e.factory(a.type,o,s,a.typed,a):e.factory(a.type,o,s,a.typed),n.push(e),i.push(t)):t=i[r],t}return a.import=s(l),a.config=s(p),a.expression.mathWithTransform.config=a.config,e&&a.config(e),a}},function(e,t,r){e.exports=r(558)},function(e,t,n){var i=n(559);e.exports=function e(t){var r=i.create(t);return r.create=e,r.import(n(552)),r}()}])});
//# sourceMappingURL=math.min.map