
/* File:        org.molgenis.omx/model/MolgenisPermission.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisRole;
import org.molgenis.omx.core.MolgenisEntity;
import org.molgenis.omx.auth.MolgenisPermission;


/**
 * Reads MolgenisPermission from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MolgenisPermissionEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MolgenisPermissionEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'role_' (maps molgenisRole.Name -> molgenisRole.id)			
	final Map<String,Integer> role_Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'entity' (maps molgenisEntity.className -> molgenisEntity.id)			
	final Map<String,Integer> entityKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports MolgenisPermission from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MolgenisPermission> molgenisPermissionsMissingRefs = new ArrayList<MolgenisPermission>();
	
		//cache for objects to be imported from file (in batch)
		final List<MolgenisPermission> molgenisPermissionList = new ArrayList<MolgenisPermission>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			MolgenisPermission object = new MolgenisPermission();
			object.set(tuple, false);				
			molgenisPermissionList.add(object);		
			
			//add to db when batch size is reached
			if(molgenisPermissionList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				molgenisPermissionsMissingRefs.addAll(resolveForeignKeys(db, molgenisPermissionList));
				molgenisPermissionList.removeAll(molgenisPermissionsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(molgenisPermissionList,dbAction, "Identifier");
				
				//clear for next batch						
				molgenisPermissionList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!molgenisPermissionList.isEmpty())
		{
			total.set(total.get() + molgenisPermissionList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			molgenisPermissionsMissingRefs.addAll(resolveForeignKeys(db, molgenisPermissionList));
			molgenisPermissionList.removeAll(molgenisPermissionsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(molgenisPermissionList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MolgenisPermission> molgenisPermissions = new ArrayList<MolgenisPermission>(molgenisPermissionsMissingRefs);

		int iterationCount = 0;

		do
		{
			molgenisPermissionsMissingRefs = resolveForeignKeys(db, molgenisPermissionsMissingRefs);
			
			LinkedHashSet<MolgenisPermission> differenceSet = new LinkedHashSet<MolgenisPermission>();
			Sets.symmetricDifference(new LinkedHashSet<MolgenisPermission>(molgenisPermissions), new LinkedHashSet<MolgenisPermission>(molgenisPermissionsMissingRefs)).copyInto(differenceSet);
			List<MolgenisPermission> resolvablemolgenisPermissions = new ArrayList<MolgenisPermission>(differenceSet);
			
			molgenisPermissions.removeAll(resolvablemolgenisPermissions);
			
			db.update(resolvablemolgenisPermissions,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MolgenisPermission blaat : molgenisPermissionsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'molgenisPermission' entity failed:"
								+ "This is probably caused by a(n) 'molgenisPermission' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (molgenisPermissionsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " molgenisPermission from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param molgenisPermissionList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MolgenisPermission> resolveForeignKeys(Database db, List<MolgenisPermission> molgenisPermissionList) throws Exception
	{
		//keep a list of MolgenisPermission instances that miss a reference which might be resolvable later
		List<MolgenisPermission> molgenisPermissionsMissingRefs = new ArrayList<MolgenisPermission>();
	
		//resolve xref 'role_' from molgenisRole.Name -> molgenisRole.id
		for(MolgenisPermission o: molgenisPermissionList) 
		{
			if(o.getRole_Name() != null) 
				role_Keymap.put(o.getRole_Name(), null);
		}
		
		if(role_Keymap.size() > 0) 
		{
			List<MolgenisRole> role_List = db.query(MolgenisRole.class).in("Name",new ArrayList<Object>(role_Keymap.keySet())).find();
			for(MolgenisRole xref :  role_List)
			{
				role_Keymap.put(xref.getName(), xref.getId());
			}
		}
		//resolve xref 'entity' from molgenisEntity.className -> molgenisEntity.id
		for(MolgenisPermission o: molgenisPermissionList) 
		{
			if(o.getEntity_ClassName() != null) 
				entityKeymap.put(o.getEntity_ClassName(), null);
		}
		
		if(entityKeymap.size() > 0) 
		{
			List<MolgenisEntity> entityList = db.query(MolgenisEntity.class).in("className",new ArrayList<Object>(entityKeymap.keySet())).find();
			for(MolgenisEntity xref :  entityList)
			{
				entityKeymap.put(xref.getClassName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(MolgenisPermission o:  molgenisPermissionList)
		{
			while(true){
				//update xref role_
				if(o.getRole_Name() != null) 
				{
					String key = o.getRole_Name();
					if(role_Keymap.get(key) == null)
					{
						throw new Exception("Import of 'MolgenisPermission' objects failed: cannot find MolgenisRole for role__Name='"+o.getRole_Name()+"'");
					}
					o.setRole_Id(role_Keymap.get(key));
				}
				//update xref entity
				if(o.getEntity_ClassName() != null) 
				{
					String key = o.getEntity_ClassName();
					if(entityKeymap.get(key) == null)
					{
						throw new Exception("Import of 'MolgenisPermission' objects failed: cannot find MolgenisEntity for entity_className='"+o.getEntity_ClassName()+"'");
					}
					o.setEntity_Id(entityKeymap.get(key));
				}
				break;
			}
		}
		
		role_Keymap.clear();
		entityKeymap.clear();
		
		return molgenisPermissionsMissingRefs;
	}
}

