package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.PanelSource;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PanelSourceService
{
	private static final Logger logger = Logger.getLogger(PanelSourceService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public PanelSource create(PanelSource panelSource) throws DatabaseException
	{
		logger.debug("creating PanelSource");
		db.add(panelSource);
		return panelSource;
	}

	public PanelSource read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving PanelSource");
		return db.findById(PanelSource.class, id);
	}

	public void update(PanelSource panelSource) throws DatabaseException
	{
		logger.debug("updating PanelSource");
		db.update(panelSource);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting PanelSource");
		PanelSource panelSource = db.findById(PanelSource.class, id);
		return db.remove(panelSource) == 1;
	}
	
	public Iterable<PanelSource> readAll() throws DatabaseException
	{
		logger.debug("retrieving all PanelSource instances");
		return db.find(PanelSource.class);
	}
	
	public EntityPager<PanelSource> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all PanelSource instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(PanelSource.class, queryRules.toArray(new QueryRule[0]));
		List<PanelSource> panelSourceCollection = db.find(PanelSource.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<PanelSource>(start, num, count, panelSourceCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("PanelSource");
	}
}