package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.XrefValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class XrefValueService
{
	private static final Logger logger = Logger.getLogger(XrefValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public XrefValue create(XrefValue xrefValue) throws DatabaseException
	{
		logger.debug("creating XrefValue");
		db.add(xrefValue);
		return xrefValue;
	}

	public XrefValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving XrefValue");
		return db.findById(XrefValue.class, id);
	}

	public void update(XrefValue xrefValue) throws DatabaseException
	{
		logger.debug("updating XrefValue");
		db.update(xrefValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting XrefValue");
		XrefValue xrefValue = db.findById(XrefValue.class, id);
		return db.remove(xrefValue) == 1;
	}
	
	public Iterable<XrefValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all XrefValue instances");
		return db.find(XrefValue.class);
	}
	
	public EntityPager<XrefValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all XrefValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(XrefValue.class, queryRules.toArray(new QueryRule[0]));
		List<XrefValue> xrefValueCollection = db.find(XrefValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<XrefValue>(start, num, count, xrefValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("XrefValue");
	}
}