/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.config;

import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.elasticsearch.ElasticsearchService;
import org.molgenis.data.meta.model.TagFactory;
import org.molgenis.data.meta.model.TagMetadata;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.ontology.core.ic.TermFrequencyService;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.semanticsearch.explain.service.ElasticSearchExplainServiceImpl;
import org.molgenis.semanticsearch.explain.service.ExplainServiceHelper;
import org.molgenis.semanticsearch.repository.TagRepository;
import org.molgenis.semanticsearch.service.OntologyTagService;
import org.molgenis.semanticsearch.service.SemanticSearchService;
import org.molgenis.semanticsearch.service.TagService;
import org.molgenis.semanticsearch.service.impl.OntologyTagServiceImpl;
import org.molgenis.semanticsearch.service.impl.SemanticSearchServiceHelper;
import org.molgenis.semanticsearch.service.impl.SemanticSearchServiceImpl;
import org.molgenis.semanticsearch.service.impl.UntypedTagService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SemanticSearchConfig {
    private final DataService dataService;
    private final OntologyService ontologyService;
    private final IdGenerator idGenerator;
    private final TermFrequencyService termFrequencyService;
    private final TagMetadata tagMetadata;
    private final TagFactory tagFactory;
    private final ElasticsearchService elasticsearchService;

    public SemanticSearchConfig(DataService dataService, OntologyService ontologyService, IdGenerator idGenerator, TermFrequencyService termFrequencyService, TagMetadata tagMetadata, TagFactory tagFactory, ElasticsearchService elasticsearchService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.termFrequencyService = Objects.requireNonNull(termFrequencyService);
        this.tagMetadata = Objects.requireNonNull(tagMetadata);
        this.tagFactory = Objects.requireNonNull(tagFactory);
        this.elasticsearchService = Objects.requireNonNull(elasticsearchService);
    }

    @Bean
    public SemanticSearchServiceHelper semanticSearchServiceHelper() {
        return new SemanticSearchServiceHelper(this.dataService, this.ontologyService, this.termFrequencyService);
    }

    @Bean
    public OntologyTagService ontologyTagService() {
        return new OntologyTagServiceImpl(this.dataService, this.ontologyService, this.tagRepository(), this.idGenerator, this.tagMetadata);
    }

    @Bean
    public SemanticSearchService semanticSearchService() {
        return new SemanticSearchServiceImpl(this.dataService, this.ontologyService, this.semanticSearchServiceHelper(), this.elasticSearchExplainService(), this.ontologyTagService());
    }

    @Bean
    public TagService<LabeledResource, LabeledResource> tagService() {
        return new UntypedTagService(this.dataService, this.tagRepository());
    }

    @Bean
    public ExplainServiceHelper explainServiceHelper() {
        return new ExplainServiceHelper();
    }

    @Bean
    TagRepository tagRepository() {
        return new TagRepository(this.dataService, this.idGenerator, this.tagFactory);
    }

    @Bean
    ElasticSearchExplainService elasticSearchExplainService() {
        return new ElasticSearchExplainServiceImpl(this.elasticsearchService, this.explainServiceHelper());
    }
}

