/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.explain.bean;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.semanticsearch.explain.bean.AutoValue_ExplainedAttribute;
import org.molgenis.semanticsearch.explain.bean.AutoValue_ExplainedAttributeDto;
import org.molgenis.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.util.AutoGson;

@AutoGson(autoValueClass=AutoValue_ExplainedAttribute.class)
public abstract class ExplainedAttributeDto {
    public static ExplainedAttributeDto create(Attribute attribute) {
        return new AutoValue_ExplainedAttributeDto(ExplainedAttributeDto.attributeToMap(attribute), Collections.emptySet(), false);
    }

    public static ExplainedAttributeDto create(Attribute attribute, Iterable<ExplainedQueryString> explainedQueryStrings, boolean highQuality) {
        return new AutoValue_ExplainedAttributeDto(ExplainedAttributeDto.attributeToMap(attribute), Sets.newHashSet(explainedQueryStrings), highQuality);
    }

    public abstract Map<String, Object> getAttribute();

    public abstract Set<ExplainedQueryString> getExplainedQueryStrings();

    public abstract boolean isHighQuality();

    private static Map<String, Object> attributeToMap(Attribute attribute) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", attribute.getName());
        map.put("label", attribute.getLabel());
        map.put("description", attribute.getDescription());
        map.put("type", attribute.getDataType().toString());
        map.put("isNullable", attribute.isNillable());
        map.put("isUnique", attribute.isUnique());
        if (attribute.getRefEntity() != null) {
            map.put("refEntityType", attribute.getRefEntity().getId());
        }
        return map;
    }
}

