/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.explain.service;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.elasticsearch.ElasticsearchService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.semanticsearch.explain.service.ExplainServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchExplainServiceImpl
implements ElasticSearchExplainService {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchExplainServiceImpl.class);
    private final ElasticsearchService elasticsearchService;
    private final ExplainServiceHelper explainServiceHelper;

    public ElasticSearchExplainServiceImpl(ElasticsearchService elasticsearchService, ExplainServiceHelper explainServiceHelper) {
        this.elasticsearchService = Objects.requireNonNull(elasticsearchService);
        this.explainServiceHelper = Objects.requireNonNull(explainServiceHelper);
    }

    @Override
    public Explanation explain(Query<Entity> q, EntityType entityType, Object entityId) {
        Explanation explanation = this.elasticsearchService.explain(entityType, entityId, q);
        if (explanation != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(explanation.toString());
            }
            return explanation;
        }
        return null;
    }

    @Override
    public Set<ExplainedQueryString> findQueriesFromExplanation(Map<String, String> originalQueryInMap, Explanation explanation) {
        LinkedHashSet<ExplainedQueryString> matchedQueryStrings = new LinkedHashSet<ExplainedQueryString>();
        Set<String> matchedQueryTerms = this.explainServiceHelper.findMatchedWords(explanation);
        for (String matchedQueryTerm : matchedQueryTerms) {
            Map<String, Double> matchedQueryRule = this.explainServiceHelper.findMatchQueries(matchedQueryTerm, originalQueryInMap);
            if (matchedQueryRule.size() <= 0) continue;
            Map.Entry entry = matchedQueryRule.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get();
            matchedQueryStrings.add(ExplainedQueryString.create(matchedQueryTerm, (String)entry.getKey(), originalQueryInMap.get(entry.getKey()), (Double)entry.getValue()));
        }
        return matchedQueryStrings;
    }
}

