/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.repository;

import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.data.meta.model.TagFactory;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.semantic.Relation;

public class TagRepository {
    private final DataService dataService;
    private final IdGenerator idGenerator;
    private final TagFactory tagFactory;

    public TagRepository(DataService dataService, IdGenerator idGenerator, TagFactory tagFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.tagFactory = Objects.requireNonNull(tagFactory);
    }

    public Tag getTagEntity(String objectIRI, String label, Relation relation, String codeSystemIRI) {
        Tag tag = (Tag)this.dataService.query("sys_md_Tag", Tag.class).eq("objectIRI", (Object)objectIRI).and().eq("relationIRI", (Object)relation.getIRI()).and().eq("codeSystem", (Object)codeSystemIRI).findOne();
        if (tag == null) {
            tag = (Tag)this.tagFactory.create();
            tag.setId(this.idGenerator.generateId());
            tag.setObjectIri(objectIRI);
            tag.setLabel(label);
            tag.setRelationIri(relation.getIRI());
            tag.setRelationLabel(relation.getLabel());
            tag.setCodeSystem(codeSystemIRI);
            this.dataService.add("sys_md_Tag", (Entity)tag);
        }
        return tag;
    }
}

