/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.service.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.data.meta.model.TagMetadata;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.SemanticTag;
import org.molgenis.ontology.core.model.Ontology;
import org.molgenis.ontology.core.model.OntologyTerm;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.semanticsearch.repository.TagRepository;
import org.molgenis.semanticsearch.semantic.OntologyTag;
import org.molgenis.semanticsearch.service.OntologyTagService;
import org.springframework.transaction.annotation.Transactional;

public class OntologyTagServiceImpl
implements OntologyTagService {
    private final DataService dataService;
    private final TagRepository tagRepository;
    private final OntologyService ontologyService;
    private final IdGenerator idGenerator;
    private final TagMetadata tagMetadata;

    public OntologyTagServiceImpl(DataService dataService, OntologyService ontologyService, TagRepository tagRepository, IdGenerator idGenerator, TagMetadata tagMetadata) {
        this.dataService = Objects.requireNonNull(dataService);
        this.tagRepository = Objects.requireNonNull(tagRepository);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.tagMetadata = Objects.requireNonNull(tagMetadata);
    }

    @Override
    public void removeAttributeTag(String entity, String attribute, String relationIRI, String ontologyTermIRI) {
        Entity attributeEntity = this.findAttributeEntity(entity, attribute);
        Iterable tags = attributeEntity.getEntities("tags");
        Iterable newTags = StreamSupport.stream(tags.spliterator(), false).filter(e -> !this.isSameTag(relationIRI, ontologyTermIRI, (Entity)e)).collect(Collectors.toList());
        attributeEntity.set("tags", (Object)newTags);
        this.dataService.update("sys_md_Attribute", attributeEntity);
        this.updateEntityTypeEntityWithNewAttributeEntity(entity, attribute, attributeEntity);
    }

    @Override
    public void removeAttributeTag(EntityType entityType, SemanticTag<Attribute, OntologyTerm, Ontology> removeTag) {
        Attribute attribute = (Attribute)removeTag.getSubject();
        Entity attributeEntity = this.findAttributeEntity(entityType.getId(), attribute.getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : attributeEntity.getEntities("tags")) {
            SemanticTag<Attribute, OntologyTerm, Ontology> tag = this.asTag(attribute, tagEntity);
            if (removeTag.equals(tag)) continue;
            tags.add(tagEntity);
        }
        attributeEntity.set("tags", tags);
        this.dataService.update("sys_md_Attribute", attributeEntity);
    }

    @Override
    @RunAsSystem
    public Multimap<Relation, OntologyTerm> getTagsForAttribute(EntityType entityType, Attribute attribute) {
        LinkedHashMultimap tags = LinkedHashMultimap.create();
        for (Tag tagEntity : attribute.getTags()) {
            SemanticTag<Attribute, OntologyTerm, Ontology> tag = this.asTag(attribute, (Entity)tagEntity);
            if (tag == null) continue;
            tags.put((Object)tag.getRelation(), tag.getObject());
        }
        return tags;
    }

    @Override
    public Iterable<SemanticTag<Package, OntologyTerm, Ontology>> getTagsForPackage(Package aPackage) {
        Entity packageEntity = this.dataService.findOneById("sys_md_Package", (Object)aPackage.getId());
        if (packageEntity == null) {
            throw new UnknownEntityException("sys_md_Package", (Object)aPackage.getId());
        }
        ArrayList tags = Lists.newArrayList();
        for (Entity tagEntity : packageEntity.getEntities("tags")) {
            tags.add(this.asTag(aPackage, tagEntity));
        }
        return tags;
    }

    @Override
    public void addAttributeTag(EntityType entityType, SemanticTag<Attribute, OntologyTerm, Ontology> tag) {
        Entity entity = this.findAttributeEntity(entityType.getId(), ((Attribute)tag.getSubject()).getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add(tagEntity);
        }
        tags.add(this.getTagEntity(tag));
        entity.set("tags", tags);
        this.dataService.update("sys_md_Attribute", entity);
    }

    @Override
    public OntologyTag addAttributeTag(String entity, String attribute, String relationIRI, List<String> ontologyTermIRIs) {
        boolean added = false;
        Entity attributeEntity = this.findAttributeEntity(entity, attribute);
        Tag tag = new Tag((EntityType)this.tagMetadata);
        Stream<OntologyTerm> terms = ontologyTermIRIs.stream().map(arg_0 -> ((OntologyService)this.ontologyService).getOntologyTerm(arg_0));
        OntologyTerm combinedOntologyTerm = OntologyTerm.and((OntologyTerm[])((OntologyTerm[])terms.toArray(OntologyTerm[]::new)));
        Relation relation = Relation.forIRI((String)relationIRI);
        tag.setId(this.idGenerator.generateId());
        tag.setCodeSystem(null);
        tag.setRelationIri(relation.getIRI());
        tag.setRelationLabel(relation.getLabel());
        tag.setLabel(combinedOntologyTerm.getLabel());
        tag.setObjectIri(combinedOntologyTerm.getIRI());
        this.dataService.add("sys_md_Tag", (Entity)tag);
        HashMap tags = Maps.newHashMap();
        for (Entity attrTag : attributeEntity.getEntities("tags")) {
            tags.put(attrTag.get("objectIRI").toString(), attrTag);
        }
        if (!tags.containsKey(tag.get("objectIRI").toString())) {
            tags.put(tag.get("objectIRI").toString(), tag);
            added = true;
        }
        attributeEntity.set("tags", tags.values());
        this.dataService.update("sys_md_Attribute", attributeEntity);
        this.updateEntityTypeEntityWithNewAttributeEntity(entity, attribute, attributeEntity);
        return added ? OntologyTag.create(combinedOntologyTerm, relation) : null;
    }

    public Entity getTagEntity(SemanticTag<?, OntologyTerm, Ontology> tag) {
        return this.tagRepository.getTagEntity(((OntologyTerm)tag.getObject()).getIRI(), ((OntologyTerm)tag.getObject()).getLabel(), tag.getRelation(), ((Ontology)tag.getCodeSystem()).getIRI());
    }

    @Override
    @Transactional
    public void removeAllTagsFromEntity(String entityTypeId) {
        EntityType entityTypedata = this.dataService.getEntityType(entityTypeId);
        Iterable attributes = entityTypedata.getAtomicAttributes();
        for (Attribute attribute : attributes) {
            Entity attributeEntity = this.findAttributeEntity(entityTypeId, attribute.getName());
            attributeEntity.set("tags", Collections.emptyList());
            this.dataService.update("sys_md_Attribute", attributeEntity);
            this.updateEntityTypeEntityWithNewAttributeEntity(entityTypeId, attribute.getName(), attributeEntity);
        }
    }

    @Override
    @Transactional
    public Map<String, OntologyTag> tagAttributesInEntity(String entity, Map<Attribute, OntologyTerm> tags) {
        LinkedHashMap<String, OntologyTag> result = new LinkedHashMap<String, OntologyTag>();
        for (Map.Entry<Attribute, OntologyTerm> tag : tags.entrySet()) {
            OntologyTerm ontologyTerm = tag.getValue();
            OntologyTag ontologyTag = this.addAttributeTag(entity, tag.getKey().getName(), Relation.isAssociatedWith.getIRI(), Collections.singletonList(ontologyTerm.getIRI()));
            result.put(tag.getKey().getName(), ontologyTag);
        }
        return result;
    }

    @Override
    public void addEntityTag(SemanticTag<EntityType, OntologyTerm, Ontology> tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEntityTag(SemanticTag<EntityType, OntologyTerm, Ontology> tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<SemanticTag<EntityType, LabeledResource, LabeledResource>> getTagsForEntity(EntityType entityType) {
        throw new UnsupportedOperationException();
    }

    private void updateEntityTypeEntityWithNewAttributeEntity(String entity, String attribute, Entity attributeEntity) {
        EntityType entityEntity = this.dataService.getEntityType(entity);
        Iterable attributes = entityEntity.getOwnAllAttributes();
        entityEntity.set("attributes", StreamSupport.stream(attributes.spliterator(), false).map(att -> att.getName().equals(attribute) ? attributeEntity : att).collect(Collectors.toList()));
        this.dataService.update("sys_md_EntityType", (Entity)entityEntity);
    }

    private boolean isSameTag(String relationIRI, String ontologyTermIRI, Entity e) {
        return ontologyTermIRI.equals(e.getString("objectIRI")) && relationIRI.equals(e.getString("relationIRI"));
    }

    @RunAsSystem
    @NotNull
    private Entity findAttributeEntity(String entityTypeId, String attributeName) {
        EntityType entityTypeEntity = this.dataService.getEntityType(entityTypeId);
        Attribute attributeEntity = entityTypeEntity.getAttribute(attributeName);
        if (attributeEntity == null) {
            throw new UnknownAttributeException(entityTypeEntity, attributeName);
        }
        return attributeEntity;
    }

    private <SubjectType> SemanticTag<SubjectType, OntologyTerm, Ontology> asTag(SubjectType subjectType, Entity tagEntity) {
        String identifier = tagEntity.getString("id");
        Relation relation = OntologyTagServiceImpl.asRelation(tagEntity);
        Ontology ontology = this.asOntology(tagEntity);
        OntologyTerm ontologyTerm = this.asOntologyTerm(tagEntity);
        if (relation == null || ontologyTerm == null) {
            return null;
        }
        return new SemanticTag(identifier, subjectType, relation, (Object)ontologyTerm, (Object)ontology);
    }

    private static Relation asRelation(Entity tagEntity) {
        String relationIRI = tagEntity.getString("relationIRI");
        if (relationIRI == null) {
            return null;
        }
        return Relation.forIRI((String)relationIRI);
    }

    private OntologyTerm asOntologyTerm(Entity tagEntity) {
        String objectIRI = tagEntity.getString("objectIRI");
        if (objectIRI == null) {
            return null;
        }
        return this.ontologyService.getOntologyTerm(objectIRI);
    }

    private Ontology asOntology(Entity tagEntity) {
        String codeSystemIRI = tagEntity.getString("codeSystem");
        if (codeSystemIRI == null) {
            return null;
        }
        return this.ontologyService.getOntology(codeSystemIRI);
    }
}

