/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Explanation;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.core.model.Ontology;
import org.molgenis.ontology.core.model.OntologyTerm;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.semanticsearch.explain.bean.AttributeSearchResults;
import org.molgenis.semanticsearch.explain.bean.EntityTypeSearchResults;
import org.molgenis.semanticsearch.explain.bean.ExplainedAttribute;
import org.molgenis.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.semanticsearch.semantic.Hit;
import org.molgenis.semanticsearch.semantic.Hits;
import org.molgenis.semanticsearch.service.OntologyTagService;
import org.molgenis.semanticsearch.service.SemanticSearchService;
import org.molgenis.semanticsearch.service.impl.SemanticSearchServiceHelper;
import org.molgenis.semanticsearch.string.NGramDistanceAlgorithm;
import org.molgenis.semanticsearch.string.Stemmer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSearchServiceImpl
implements SemanticSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticSearchServiceImpl.class);
    private final DataService dataService;
    private final OntologyService ontologyService;
    private final SemanticSearchServiceHelper semanticSearchServiceHelper;
    private final ElasticSearchExplainService elasticSearchExplainService;
    private final OntologyTagService ontologyTagService;
    private static final int MAX_NUM_TAGS = 100;
    private static final float CUTOFF = 0.4f;
    private Splitter termSplitter = Splitter.onPattern((String)"[^\\p{IsAlphabetic}]+");
    private Joiner termJoiner = Joiner.on((char)' ');
    private static final String UNIT_ONTOLOGY_IRI = "http://purl.obolibrary.org/obo/uo.owl";
    private static final int MAX_NUMBER_EXPLAINED_ATTRIBUTES = 10;

    public SemanticSearchServiceImpl(DataService dataService, OntologyService ontologyService, SemanticSearchServiceHelper semanticSearchServiceHelper, ElasticSearchExplainService elasticSearchExplainService, OntologyTagService ontologyTagService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.semanticSearchServiceHelper = Objects.requireNonNull(semanticSearchServiceHelper);
        this.elasticSearchExplainService = Objects.requireNonNull(elasticSearchExplainService);
        this.ontologyTagService = Objects.requireNonNull(ontologyTagService);
    }

    public Hits<ExplainedAttribute> findAttributes(EntityType sourceEntityType, Set<String> queryTerms, Collection<OntologyTerm> ontologyTerms) {
        List<String> attributeIdentifiers = this.semanticSearchServiceHelper.getAttributeIdentifiers(sourceEntityType);
        QueryRule disMaxQueryRule = this.semanticSearchServiceHelper.createDisMaxQueryRuleForAttribute(queryTerms, ontologyTerms);
        ArrayList finalQueryRules = Lists.newArrayList((Object[])new QueryRule[]{new QueryRule("id", QueryRule.Operator.IN, attributeIdentifiers)});
        if (disMaxQueryRule.getNestedRules().size() > 0) {
            finalQueryRules.addAll(Arrays.asList(new QueryRule(QueryRule.Operator.AND), disMaxQueryRule));
        }
        Stream attributeEntities = this.dataService.findAll("sys_md_Attribute", (Query)new QueryImpl((List)finalQueryRules));
        Map<String, String> collectExpanedQueryMap = this.semanticSearchServiceHelper.collectExpandedQueryMap(queryTerms, ontologyTerms);
        ArrayList attributeSearchHits = new ArrayList();
        AtomicInteger count = new AtomicInteger(0);
        attributeEntities.forEach(attributeEntity -> {
            boolean isHighQuality;
            Set<ExplainedQueryString> explainedQueryStrings;
            Attribute attribute = sourceEntityType.getAttribute(attributeEntity.getString("name"));
            if (count.get() < 10) {
                explainedQueryStrings = this.convertAttributeToExplainedAttribute(attribute, collectExpanedQueryMap, (Query<Entity>)new QueryImpl(finalQueryRules));
                isHighQuality = this.isSingleMatchHighQuality(queryTerms, Sets.newHashSet(collectExpanedQueryMap.values()), explainedQueryStrings);
            } else {
                explainedQueryStrings = Collections.emptySet();
                isHighQuality = false;
            }
            attributeSearchHits.add(ExplainedAttribute.create(attribute, explainedQueryStrings, isHighQuality));
            count.incrementAndGet();
        });
        return Hits.create(attributeSearchHits.stream().map(explainedAttribute -> Hit.create(explainedAttribute, 1.0f)).collect(Collectors.toList()));
    }

    boolean isSingleMatchHighQuality(Collection<String> queryTerms, Collection<String> ontologyTermQueries, Iterable<ExplainedQueryString> explanations) {
        HashMap<String, Double> matchedTags = new HashMap<String, Double>();
        for (ExplainedQueryString explanation : explanations) {
            matchedTags.put(explanation.getTagName().toLowerCase(), explanation.getScore());
        }
        ontologyTermQueries.removeAll(queryTerms);
        if (!queryTerms.isEmpty() && queryTerms.stream().anyMatch(token -> this.isGoodMatch((Map<String, Double>)matchedTags, (String)token))) {
            return true;
        }
        return !ontologyTermQueries.isEmpty() && ontologyTermQueries.stream().allMatch(token -> this.isGoodMatch((Map<String, Double>)matchedTags, (String)token));
    }

    boolean isGoodMatch(Map<String, Double> matchedTags, String label) {
        return matchedTags.containsKey(label = label.toLowerCase()) && matchedTags.get(label).intValue() == 100 || Sets.newHashSet((Object[])label.split(" ")).stream().allMatch(word -> matchedTags.containsKey(word) && ((Double)matchedTags.get(word)).intValue() == 100);
    }

    @Override
    public EntityTypeSearchResults findAttributes(EntityType sourceEntityType, EntityType targetEntityType, Set<String> searchTerms) {
        List<AttributeSearchResults> attributeSearchResults = StreamSupport.stream(targetEntityType.getAtomicAttributes().spliterator(), false).filter(targetAttribute -> targetAttribute.getExpression() == null).map(targetAttribute -> this.findAttributes(sourceEntityType, targetEntityType, (Attribute)targetAttribute, searchTerms)).collect(Collectors.toList());
        return EntityTypeSearchResults.create(targetEntityType, attributeSearchResults);
    }

    @Override
    public AttributeSearchResults findAttributes(EntityType sourceEntityType, EntityType targetEntityType, Attribute targetAttribute, Set<String> searchTerms) {
        Multimap tagsForAttribute = this.ontologyTagService.getTagsForAttribute(targetEntityType, targetAttribute);
        List ontologyTermsFromTags = tagsForAttribute.values();
        Set<String> queryTerms = this.createLexicalSearchQueryTerms(targetAttribute, searchTerms);
        List ontologyTerms = ontologyTermsFromTags;
        if (null != searchTerms && !searchTerms.isEmpty()) {
            Set escapedSearchTerms = searchTerms.stream().filter(StringUtils::isNotBlank).map(QueryParserBase::escape).collect(Collectors.toSet());
            ontologyTerms = this.ontologyService.findExcatOntologyTerms(this.ontologyService.getAllOntologiesIds(), escapedSearchTerms, 100);
        } else if (null == ontologyTerms || ontologyTerms.isEmpty()) {
            Hit<OntologyTerm> ontologyTermHit;
            List allOntologiesIds = this.ontologyService.getAllOntologiesIds();
            Ontology unitOntology = this.ontologyService.getOntology(UNIT_ONTOLOGY_IRI);
            if (unitOntology != null) {
                allOntologiesIds.remove(unitOntology.getId());
            }
            ontologyTerms = (ontologyTermHit = this.findTags(targetAttribute, allOntologiesIds)) != null ? Arrays.asList(ontologyTermHit.getResult()) : Collections.emptyList();
        }
        Hits<ExplainedAttribute> hits = this.findAttributes(sourceEntityType, queryTerms, ontologyTerms);
        return AttributeSearchResults.create(targetAttribute, hits);
    }

    public Set<String> createLexicalSearchQueryTerms(Attribute targetAttribute, Set<String> searchTerms) {
        HashSet<String> queryTerms = new HashSet<String>();
        if (searchTerms != null && !searchTerms.isEmpty()) {
            queryTerms.addAll(searchTerms);
        }
        if (queryTerms.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)targetAttribute.getLabel())) {
                queryTerms.add(targetAttribute.getLabel());
            }
            if (StringUtils.isNotBlank((CharSequence)targetAttribute.getDescription())) {
                queryTerms.add(targetAttribute.getDescription());
            }
        }
        return queryTerms;
    }

    public Set<ExplainedQueryString> convertAttributeToExplainedAttribute(Attribute attribute, Map<String, String> collectExpandedQueryMap, Query<Entity> query) {
        EntityType attributeMetaData = this.dataService.getEntityType("sys_md_Attribute");
        String attributeID = attribute.getIdentifier();
        Explanation explanation = this.elasticSearchExplainService.explain(query, attributeMetaData, attributeID);
        return this.elasticSearchExplainService.findQueriesFromExplanation(collectExpandedQueryMap, explanation);
    }

    @Override
    public Hits<OntologyTerm> findOntologyTerms(Attribute attribute, Collection<Ontology> ontologies) {
        List<String> ontologyIds = ontologies.stream().map(Ontology::getId).collect(Collectors.toList());
        Hit<OntologyTerm> ontologyTermHit = this.findTags(attribute, ontologyIds);
        return ontologyTermHit != null ? Hits.create(ontologyTermHit) : Hits.create(new Hit[0]);
    }

    Hit<OntologyTerm> findTags(Attribute attribute, List<String> ontologyIds) {
        String description = attribute.getDescription() == null ? attribute.getLabel() : attribute.getDescription();
        Set<String> searchTerms = this.splitIntoTerms(description);
        if (LOG.isDebugEnabled()) {
            LOG.debug("findAttributeOntologyTerms({},{},{})", new Object[]{ontologyIds, searchTerms, 100});
        }
        List candidates = this.ontologyService.findOntologyTerms(ontologyIds, searchTerms, 100);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Candidates: {}", (Object)candidates);
        }
        List hits = candidates.stream().filter(ontologyTerm -> this.filterOntologyTerm(this.splitIntoTerms(Stemmer.stemAndJoin(searchTerms)), (OntologyTerm)ontologyTerm)).map(ontolgoyTerm -> Hit.create(ontolgoyTerm, this.bestMatchingSynonym((OntologyTerm)ontolgoyTerm, searchTerms).getScore())).sorted((Comparator<Hit>)Ordering.natural().reverse()).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hits: {}", hits);
        }
        Hit<OntologyTerm> result = null;
        String bestMatchingSynonym = null;
        for (Hit hit : hits) {
            String bestMatchingSynonymForHit = this.bestMatchingSynonym((OntologyTerm)hit.getResult(), searchTerms).getResult();
            if (result == null) {
                result = hit;
                bestMatchingSynonym = bestMatchingSynonymForHit;
            } else {
                Sets.SetView jointTerms = Sets.union(this.splitIntoTerms(bestMatchingSynonym), this.splitIntoTerms(bestMatchingSynonymForHit));
                String joinedSynonyms = this.termJoiner.join((Iterable)jointTerms);
                Hit<OntologyTerm> joinedHit = Hit.create(OntologyTerm.and((OntologyTerm[])new OntologyTerm[]{(OntologyTerm)result.getResult(), (OntologyTerm)hit.getResult()}), this.distanceFrom(joinedSynonyms, searchTerms));
                if (joinedHit.compareTo(result) > 0) {
                    result = joinedHit;
                    bestMatchingSynonym = bestMatchingSynonym + " " + bestMatchingSynonymForHit;
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("result: {}", (Object)result);
        }
        if (result != null && result.getScore() >= 0.4f) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tag {} with {}", (Object)attribute, (Object)result);
            }
            return result;
        }
        return null;
    }

    private boolean filterOntologyTerm(Set<String> keywordsFromAttribute, OntologyTerm ontologyTerm) {
        Set<String> ontologyTermSynonyms = this.semanticSearchServiceHelper.getOtLabelAndSynonyms(ontologyTerm);
        for (String synonym : ontologyTermSynonyms) {
            Set<String> splitIntoTerms = this.splitIntoTerms(Stemmer.stemAndJoin(this.splitIntoTerms(synonym)));
            if (splitIntoTerms.isEmpty() || !keywordsFromAttribute.containsAll(splitIntoTerms)) continue;
            return true;
        }
        return false;
    }

    public Hit<String> bestMatchingSynonym(OntologyTerm ontologyTerm, Set<String> searchTerms) {
        Optional<Hit> bestSynonym = ontologyTerm.getSynonyms().stream().map(synonym -> Hit.create(synonym, this.distanceFrom((String)synonym, searchTerms))).max(Comparator.naturalOrder());
        return bestSynonym.get();
    }

    float distanceFrom(String synonym, Set<String> searchTerms) {
        String s1 = Stemmer.stemAndJoin(this.splitIntoTerms(synonym));
        String s2 = Stemmer.stemAndJoin(searchTerms);
        float distance = (float)NGramDistanceAlgorithm.stringMatching(s1, s2) / 100.0f;
        LOG.debug("Similarity between: {} and {} is {}", new Object[]{s1, s2, Float.valueOf(distance)});
        return distance;
    }

    private Set<String> splitIntoTerms(String description) {
        return FluentIterable.from((Iterable)this.termSplitter.split((CharSequence)description)).transform(String::toLowerCase).filter(w -> !NGramDistanceAlgorithm.STOPWORDSLIST.contains(w)).filter(StringUtils::isNotEmpty).toSet();
    }
}

