/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.service.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.SemanticTag;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.semanticsearch.repository.TagRepository;
import org.molgenis.semanticsearch.service.TagService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UntypedTagService
implements TagService<LabeledResource, LabeledResource> {
    private static final Logger LOG = LoggerFactory.getLogger(UntypedTagService.class);
    private final DataService dataService;
    private final TagRepository tagRepository;

    public UntypedTagService(DataService dataService, TagRepository tagRepository) {
        this.dataService = Objects.requireNonNull(dataService);
        this.tagRepository = Objects.requireNonNull(tagRepository);
    }

    private Entity findAttributeEntity(EntityType entityType, String attributeName) {
        Entity entityTypeEntity = this.dataService.findOneById("sys_md_EntityType", (Object)entityType.getId());
        Optional<Entity> result = StreamSupport.stream(entityTypeEntity.getEntities("attributes").spliterator(), false).filter(att -> attributeName.equals(att.getString("name"))).findFirst();
        return result.orElse(null);
    }

    private Entity findEntity(EntityType emd) {
        return this.dataService.findOneById("sys_md_EntityType", (Object)emd.getId());
    }

    @Override
    public void removeAttributeTag(EntityType entityType, SemanticTag<Attribute, LabeledResource, LabeledResource> removeTag) {
        Attribute attribute = (Attribute)removeTag.getSubject();
        Entity attributeEntity = this.findAttributeEntity(entityType, attribute.getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : attributeEntity.getEntities("tags")) {
            SemanticTag tag = SemanticTag.asTag((Object)attribute, (Entity)tagEntity);
            if (removeTag.equals((Object)tag)) continue;
            tags.add(tagEntity);
        }
        attributeEntity.set("tags", tags);
        this.dataService.update("sys_md_Attribute", attributeEntity);
    }

    @Override
    @RunAsSystem
    public Multimap<Relation, LabeledResource> getTagsForAttribute(EntityType entityType, Attribute attribute) {
        Entity entity = this.findAttributeEntity(entityType, attribute.getName());
        if (entity == null) {
            return ArrayListMultimap.create();
        }
        ArrayListMultimap tags = ArrayListMultimap.create();
        for (Entity tagEntity : entity.getEntities("tags")) {
            SemanticTag tag = SemanticTag.asTag((Object)attribute, (Entity)tagEntity);
            tags.put((Object)tag.getRelation(), tag.getObject());
        }
        return tags;
    }

    @Override
    @RunAsSystem
    public Iterable<SemanticTag<EntityType, LabeledResource, LabeledResource>> getTagsForEntity(EntityType entityType) {
        ArrayList<SemanticTag<EntityType, LabeledResource, LabeledResource>> result = new ArrayList<SemanticTag<EntityType, LabeledResource, LabeledResource>>();
        Entity entity = this.findEntity(entityType);
        if (entity == null) {
            LOG.warn("No known entity with name {}.", (Object)entityType.getId());
        } else {
            for (Entity tagEntity : entity.getEntities("tags")) {
                result.add((SemanticTag<EntityType, LabeledResource, LabeledResource>)SemanticTag.asTag((Object)entityType, (Entity)tagEntity));
            }
        }
        return result;
    }

    @Override
    public void addAttributeTag(EntityType entityType, SemanticTag<Attribute, LabeledResource, LabeledResource> tag) {
        Entity entity = this.findAttributeEntity(entityType, ((Attribute)tag.getSubject()).getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add(tagEntity);
        }
        tags.add(this.getTagEntity(tag));
        entity.set("tags", tags);
        this.dataService.update("sys_md_Attribute", entity);
    }

    @Override
    public void addEntityTag(SemanticTag<EntityType, LabeledResource, LabeledResource> tag) {
        Entity entity = this.findEntity((EntityType)tag.getSubject());
        if (entity == null) {
            throw new UnknownEntityTypeException(((EntityType)tag.getSubject()).getId());
        }
        ImmutableList existingTags = ImmutableList.copyOf(this.getTagsForEntity((EntityType)tag.getSubject()));
        if (existingTags.contains(tag)) {
            LOG.debug("Tag already present");
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(entity.getEntities("tags"));
        builder.add((Object)this.getTagEntity(tag));
        entity.set("tags", (Object)builder.build());
        this.dataService.update("sys_md_EntityType", entity);
    }

    public Entity getTagEntity(SemanticTag<?, LabeledResource, LabeledResource> tag) {
        return this.tagRepository.getTagEntity(((LabeledResource)tag.getObject()).getIri(), ((LabeledResource)tag.getObject()).getLabel(), tag.getRelation(), ((LabeledResource)tag.getCodeSystem()).getIri());
    }

    @Override
    @RunAsSystem
    public Iterable<SemanticTag<Package, LabeledResource, LabeledResource>> getTagsForPackage(Package p) {
        Entity packageEntity = this.dataService.findOne("sys_md_Package", new QueryImpl().eq("id", (Object)p.getId()));
        if (packageEntity == null) {
            throw new UnknownEntityException("sys_md_Package", (Object)p.getId());
        }
        ArrayList tags = Lists.newArrayList();
        for (Entity tagEntity : packageEntity.getEntities("tags")) {
            tags.add(SemanticTag.asTag((Object)p, (Entity)tagEntity));
        }
        return tags;
    }

    @Override
    public void removeEntityTag(SemanticTag<EntityType, LabeledResource, LabeledResource> tag) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void removeAllTagsFromEntity(String entityTypeId) {
        throw new UnsupportedOperationException();
    }
}

