/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.semanticsearch.string;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.semanticsearch.string.Stemmer;

public class NGramDistanceAlgorithm {
    private static int N_GRAMS = 2;
    public static final Set<String> STOPWORDSLIST = ImmutableSet.of((Object)"a", (Object)"you", (Object)"about", (Object)"above", (Object)"after", (Object)"again", (Object[])new String[]{"against", "all", "am", "an", "and", "any", "are", "aren't", "as", "at", "be", "because", "been", "before", "being", "below", "between", "both", "but", "by", "can't", "cannot", "could", "couldn't", "did", "didn't", "do", "does", "doesn't", "doing", "don't", "down", "during", "each", "few", "for", "from", "further", "had", "hadn't", "has", "hasn't", "have", "haven't", "having", "he", "he'd", "he'll", "he's", "her", "here", "here's", "hers", "herself", "him", "himself", "his", "how", "how's", "i", "i'd", "i'll", "i'm", "i've", "if", "in", "into", "is", "isn't", "it", "it's", "its", "itself", "let's", "me", "more", "most", "mustn't", "my", "myself", "no", "nor", "not", "of", "off", "on", "once", "only", "or", "other", "ought", "our", "ours", "ourselves", "out", "over", "own", "same", "shan't", "she", "she'd", "she'll", "she's", "should", "shouldn't", "so", "some", "such", "than", "that", "that's", "the", "their", "theirs", "them", "themselves", "then", "there", "there's", "these", "they", "they'd", "they'll", "they're", "they've", "this", "those", "through", "to", "too", "under", "until", "up", "very", "was", "wasn't", "we", "we'd", "we'll", "we're", "we've", "were", "weren't", "what", "what's", "when", "when's", "where", "where's", "which", "while", "who", "who's", "whom", "why", "why's", "with", "won't", "would", "wouldn't", "you", "you'd", "you'll", "you're", "you've", "your", "yours", "yourself", "yourselves", "many", ")", "("});

    private NGramDistanceAlgorithm() {
    }

    public static double stringMatching(String queryOne, String queryTwo) {
        double similarityScore = NGramDistanceAlgorithm.calculateScore(NGramDistanceAlgorithm.createNGrams(queryOne.toLowerCase().trim(), true), NGramDistanceAlgorithm.createNGrams(queryTwo.toLowerCase().trim(), true));
        return similarityScore;
    }

    public static double stringMatching(String queryOne, String queryTwo, boolean removeStopWords) {
        double similarityScore = NGramDistanceAlgorithm.calculateScore(NGramDistanceAlgorithm.createNGrams(queryOne.toLowerCase().trim(), removeStopWords), NGramDistanceAlgorithm.createNGrams(queryTwo.toLowerCase().trim(), removeStopWords));
        return similarityScore;
    }

    public static Map<String, Integer> createNGrams(String inputQuery, boolean removeStopWords) {
        ArrayList wordsInString = Lists.newArrayList((Object[])Stemmer.replaceIllegalCharacter(inputQuery).split(" "));
        if (removeStopWords) {
            wordsInString.removeAll(STOPWORDSLIST);
        }
        List stemmedWordsInString = wordsInString.stream().map(Stemmer::stem).collect(Collectors.toList());
        HashMap<String, Integer> tokens = new HashMap<String, Integer>();
        for (String singleWord : stemmedWordsInString) {
            if (StringUtils.isEmpty((CharSequence)singleWord)) continue;
            StringBuilder singleString = new StringBuilder(singleWord.length() + 2);
            singleString.append('^').append(singleWord.toLowerCase()).append('$');
            int length = singleString.length();
            for (int i = 0; i < length - 1; ++i) {
                String token = null;
                token = i + N_GRAMS < length ? singleString.substring(i, i + N_GRAMS) : singleString.substring(length - 2);
                if (!tokens.containsKey(token)) {
                    tokens.put(token, 1);
                    continue;
                }
                tokens.put(token, (Integer)tokens.get(token) + 1);
            }
        }
        return tokens;
    }

    private static double calculateScore(Map<String, Integer> inputStringTokens, Map<String, Integer> ontologyTermTokens) {
        if (inputStringTokens.size() == 0 || ontologyTermTokens.size() == 0) {
            return 0.0;
        }
        int totalToken = NGramDistanceAlgorithm.getTotalNumTokens(inputStringTokens) + NGramDistanceAlgorithm.getTotalNumTokens(ontologyTermTokens);
        int numMatchedToken = 0;
        for (String token : inputStringTokens.keySet()) {
            if (!ontologyTermTokens.containsKey(token)) continue;
            numMatchedToken += Math.min(inputStringTokens.get(token), ontologyTermTokens.get(token));
        }
        if (totalToken == 0) {
            return 0.0;
        }
        return 2.0 * (double)numMatchedToken / (double)totalToken * 100.0;
    }

    private static int getTotalNumTokens(Map<String, Integer> inputStringTokens) {
        int totalNum = 0;
        for (Integer frequency : inputStringTokens.values()) {
            totalNum += frequency.intValue();
        }
        return totalNum;
    }
}

