package org.mollyware
package dependencies

import sbt._
import Keys._

object Versions {
  val spray     = "1.3.1"
  val json      = "1.2.5"
  val akka      = "2.3.4"
  val scalatest = "2.2.1"
  val codec     = "1.9"  
  val bcastle   = "1.51"
  val time      = "1.2.0"
}

object Dependencies {
  import Versions._

  val sprayRouting = "io.spray"          % "spray-routing"         % spray
  val sprayCan     = "io.spray"          % "spray-can"             % spray
  val sprayHttp    = "io.spray"          % "spray-http"            % spray
  val sprayClient  = "io.spray"          % "spray-client"          % spray
  val sprayTestkit = "io.spray"          % "spray-testkit"         % spray     % "test"
  val sprayJson    = "io.spray"          %% "spray-json"           % json
  val akkaActor    = "com.typesafe.akka" %% "akka-actor"           % akka
  val akkaRemote   = "com.typesafe.akka" %% "akka-remote"          % akka
  val akkaTestkit  = "com.typesafe.akka" %% "akka-testkit"         % akka      % "test"
  val scalaTest    = "org.scalatest"     % "scalatest_2.10"        % scalatest % "test"
  val commonsCodec = "commons-codec"     % "commons-codec"         % codec
  val bcprov       = "org.bouncycastle"  % "bcprov-jdk15on"        % bcastle
  val bcpkix       = "org.bouncycastle"  % "bcpkix-jdk15on"        % bcastle
  val scalaTime    = "com.github.nscala-time" %% "nscala-time"     % time
}

object DependencySet {
  import Dependencies._

  val timeCodec   = Seq( scalaTime, commonsCodec )
  val spray       = Seq( sprayRouting, sprayCan, sprayHttp, sprayClient, sprayTestkit, sprayJson, scalaTest )
  val akka        = Seq( akkaActor, akkaRemote, akkaTestkit, scalaTest )
  val cryptos     = Seq( bcprov, bcpkix, scalaTime, commonsCodec )
}
