package org.mollyware
package projects

import sbt._
import Keys._

object Templates {
  import dependencies.DependencySet._
  import dependencies.Dependencies
  import settings.Settings._
  import com.typesafe.sbt.web.SbtWeb

  def WebFrontendProject( name: String ) = 
    Project( name, file(name) ).
      settings( defaultSettings:_* ).
      settings( webUiSettings:_* ).
      enablePlugins(SbtWeb)  

  def WebRestProject( name: String ) = 
    Project( name, file( name ) ).
      settings( defaultSettings:_* ).
      settings( microServiceSettings:_* ).
      settings( libraryDependencies ++= spray ++ akka )

  def LibraryProject( name: String ) = 
    Project( name, file( name ) ).
      settings( defaultSettings:_* ).
      settings( libraryDependencies += Dependencies.sprayJson)

  def InternalServiceProject( name: String ) = 
    Project( name, file( name ) ).
      settings( defaultSettings:_* ).
      settings( microServiceSettings:_* ).
      settings( libraryDependencies ++= akka )
}
