/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.casbah.util.bson.decoding;

import com.mongodb.casbah.util.Logger;
import com.mongodb.casbah.util.Logging;
import com.mongodb.casbah.util.Logging$class;
import com.mongodb.casbah.util.bson.decoding.OptimizedLazyBSONCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.io.Bits;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001f\tAr\n\u001d;j[&TX\r\u001a'buf\u00145k\u0014(EK\u000e|G-\u001a:\u000b\u0005\r!\u0011\u0001\u00033fG>$\u0017N\\4\u000b\u0005\u00151\u0011\u0001\u00022t_:T!a\u0002\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0013)\taaY1tE\u0006D'BA\u0006\r\u0003\u001diwN\\4pI\nT\u0011!D\u0001\u0004G>l7\u0001A\n\u0006\u0001AArd\t\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011$H\u0007\u00025)\u0011Qa\u0007\u0006\u00029\u0005\u0019qN]4\n\u0005yQ\"a\u0003\"T\u001f:#UmY8eKJ\u0004\"\u0001I\u0011\u000e\u0003\u0019I!A\t\u0004\u0003\u000f1{wmZ5oOB\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\tY1kY1mC>\u0013'.Z2u\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\t!\u0001C\u00030\u0001\u0011\u0005\u0001'\u0001\u0006sK\u0006$wJ\u00196fGR$\"!\r\u001b\u0011\u0005e\u0011\u0014BA\u001a\u001b\u0005)\u00115k\u0014(PE*,7\r\u001e\u0005\u0006k9\u0002\rAN\u0001\u0002EB\u0019AeN\u001d\n\u0005a*#!B!se\u0006L\bC\u0001\u0013;\u0013\tYTE\u0001\u0003CsR,\u0007\"B\u0018\u0001\t\u0003iDCA\u0019?\u0011\u0015yD\b1\u0001A\u0003\tIg\u000e\u0005\u0002B\t6\t!I\u0003\u0002D)\u0005\u0011\u0011n\\\u0005\u0003\u000b\n\u00131\"\u00138qkR\u001cFO]3b[\")q\t\u0001C\u0001\u0011\u00061A-Z2pI\u0016$2!\u0013'N!\t!#*\u0003\u0002LK\t\u0019\u0011J\u001c;\t\u000bU2\u0005\u0019\u0001\u001c\t\u000b93\u0005\u0019A(\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\"!\u0007)\n\u0005ES\"\u0001\u0004\"T\u001f:\u001b\u0015\r\u001c7cC\u000e\\\u0007\"B$\u0001\t\u0003\u0019FcA%U+\")qH\u0015a\u0001\u0001\")aJ\u0015a\u0001\u001f\u0002")
public class OptimizedLazyBSONDecoder
implements BSONDecoder,
Logging,
ScalaObject {
    private volatile transient Logger log;

    public BSONObject readObject(byte[] b) {
        BSONObject exceptionResult1 = null;
        try {
            exceptionResult1 = this.readObject(new ByteArrayInputStream(b));
            return exceptionResult1;
        }
        catch (IOException iOException) {
            throw new BSONException("Failed to deserialize BSON Object from byte array.", (Throwable)iOException);
        }
    }

    public BSONObject readObject(InputStream in) {
        OptimizedLazyBSONCallback cb = new OptimizedLazyBSONCallback();
        this.decode(in, (BSONCallback)cb);
        return (BSONObject)cb.apply();
    }

    public int decode(byte[] b, BSONCallback callback) {
        int exceptionResult2 = 0;
        try {
            callback.gotBinary(null, (byte)0, b);
            exceptionResult2 = b.length;
            return exceptionResult2;
        }
        catch (IOException iOException) {
            throw new BSONException("Failed to deserialize BSON from byte array.", (Throwable)iOException);
        }
    }

    public int decode(InputStream in, BSONCallback callback) {
        byte[] head = (byte[])Array$.MODULE$.ofDim(4, (ClassManifest)Manifest$.MODULE$.Byte());
        in.read(head);
        int objSize = Bits.readInt((byte[])head) - 4;
        byte[] data = (byte[])Array$.MODULE$.ofDim(objSize, (ClassManifest)Manifest$.MODULE$.Byte());
        in.read(data);
        callback.gotBinary(null, (byte)0, (byte[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{head, data}), (ClassManifest)Manifest$.MODULE$.Byte()));
        return objSize;
    }

    public OptimizedLazyBSONDecoder() {
        Logging$class.$init$(this);
    }
}

