/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.hadoop.MongoOutputFormat;
import com.mongodb.hadoop.output.MongoRecordWriter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

public class MongoStorage
extends StoreFunc
implements StoreMetadata {
    private static final Log log = LogFactory.getLog(MongoStorage.class);
    static final String PIG_OUTPUT_SCHEMA = "mongo.pig.output.schema";
    static final String PIG_OUTPUT_SCHEMA_UDF_CONTEXT = "mongo.pig.output.schema.udf_context";
    protected ResourceSchema schema = null;
    String _udfContextSignature = null;
    MongoRecordWriter _recordWriter = null;

    public void checkSchema(ResourceSchema resourceSchema) throws IOException {
        Properties properties = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this._udfContextSignature});
        properties.setProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT, resourceSchema.toString());
    }

    public void storeSchema(ResourceSchema resourceSchema, String string, Job job) {
    }

    public void storeStatistics(ResourceStatistics resourceStatistics, String string, Job job) {
    }

    public void putNext(Tuple tuple) throws IOException {
        Configuration configuration = this._recordWriter.getContext().getConfiguration();
        List<String> list = Arrays.asList(configuration.get(PIG_OUTPUT_SCHEMA).split(","));
        BasicDBObjectBuilder basicDBObjectBuilder = BasicDBObjectBuilder.start();
        ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = this.schema.getFields();
        for (int i = 0; i < resourceFieldSchemaArray.length; ++i) {
            this.writeField(basicDBObjectBuilder, resourceFieldSchemaArray[i], tuple.get(i));
        }
        this._recordWriter.write(null, (Object)basicDBObjectBuilder.get());
    }

    private void writeField(BasicDBObjectBuilder basicDBObjectBuilder, ResourceSchema.ResourceFieldSchema resourceFieldSchema, Object object) throws IOException {
        if (object == null) {
            basicDBObjectBuilder.add(resourceFieldSchema.getName(), object);
            return;
        }
        ResourceSchema resourceSchema = resourceFieldSchema.getSchema();
        switch (resourceFieldSchema.getType()) {
            case 10: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)((Integer)object));
                return;
            }
            case 15: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)((Long)object));
                return;
            }
            case 20: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)((Float)object));
                return;
            }
            case 25: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)((Double)object));
                return;
            }
            case 50: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)object.toString());
                return;
            }
            case 55: {
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), (Object)((String)object));
                return;
            }
            case 110: {
                if (resourceSchema == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + resourceFieldSchema.getName());
                }
                ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = resourceSchema.getFields();
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                for (int i = 0; i < resourceFieldSchemaArray.length; ++i) {
                    linkedHashMap.put(resourceFieldSchemaArray[i].getName(), ((Tuple)object).get(i));
                }
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), linkedHashMap);
                return;
            }
            case 120: {
                if (resourceSchema == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + resourceFieldSchema.getName());
                }
                ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = resourceSchema.getFields();
                if (resourceFieldSchemaArray.length != 1 || resourceFieldSchemaArray[0].getType() != 110) {
                    throw new IOException("Found a bag without a tuple inside!");
                }
                resourceSchema = resourceFieldSchemaArray[0].getSchema();
                if (resourceSchema == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + resourceFieldSchema.getName());
                }
                resourceFieldSchemaArray = resourceSchema.getFields();
                ArrayList arrayList = new ArrayList();
                for (Tuple tuple : (DataBag)object) {
                    LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < resourceFieldSchemaArray.length; ++i) {
                        linkedHashMap.put(resourceFieldSchemaArray[i].getName(), tuple.get(i));
                    }
                    arrayList.add(linkedHashMap);
                }
                basicDBObjectBuilder.add(resourceFieldSchema.getName(), arrayList);
                return;
            }
        }
    }

    public void prepareToWrite(RecordWriter recordWriter) throws IOException {
        this._recordWriter = (MongoRecordWriter)recordWriter;
        log.info((Object)("Preparing to write to " + this._recordWriter));
        if (this._recordWriter == null) {
            throw new IOException("Invalid Record Writer");
        }
        UDFContext uDFContext = UDFContext.getUDFContext();
        Properties properties = uDFContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this._udfContextSignature});
        String string = properties.getProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT);
        if (string == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        MongoOutputFormat mongoOutputFormat = new MongoOutputFormat();
        log.info((Object)("OutputFormat... " + mongoOutputFormat));
        return mongoOutputFormat;
    }

    public String relToAbsPathForStoreLocation(String string, Path path) throws IOException {
        log.info((Object)("Converting path: " + string + "(curDir: " + path + ")"));
        return string;
    }

    public void setStoreLocation(String string, Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        log.info((Object)("Store Location Config: " + configuration + " For URI: " + string));
        if (!string.startsWith("mongodb://")) {
            throw new IllegalArgumentException("Invalid URI Format.  URIs must begin with a mongodb:// protocol string.");
        }
        MongoConfigUtil.setOutputURI((Configuration)configuration, (String)string);
        Properties properties = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this._udfContextSignature});
        configuration.set(PIG_OUTPUT_SCHEMA, properties.getProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT));
    }

    public void setStoreFuncUDFContextSignature(String string) {
        this._udfContextSignature = string;
    }
}

