/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.MongoConfigurationException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Server;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.embedded.client.EmbeddedServer;
import com.mongodb.embedded.client.MongoClientSettings;
import com.mongodb.selector.ServerSelector;
import java.util.Collections;
import java.util.List;
import org.bson.BsonTimestamp;

final class EmbeddedCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger((String)"cluster");
    private final ClusterSettings clusterSettings;
    private final ClusterDescription clusterDescription;
    private final EmbeddedServer server;
    private volatile boolean isClosed;

    EmbeddedCluster(MongoClientSettings mongoClientSettings) {
        this.server = new EmbeddedServer(mongoClientSettings);
        this.clusterSettings = ClusterSettings.builder().hosts(Collections.singletonList(new ServerAddress())).build();
        this.clusterDescription = new ClusterDescription(ClusterConnectionMode.SINGLE, ClusterType.STANDALONE, Collections.singletonList(this.server.getDescription()));
    }

    public ClusterSettings getSettings() {
        return this.clusterSettings;
    }

    public ClusterDescription getDescription() {
        return this.clusterDescription;
    }

    public ClusterDescription getCurrentDescription() {
        return this.clusterDescription;
    }

    public BsonTimestamp getClusterTime() {
        return null;
    }

    public Server selectServer(ServerSelector serverSelector) {
        Assertions.isTrue((String)"open", (!this.isClosed() ? 1 : 0) != 0);
        List servers = serverSelector.select(this.clusterDescription);
        if (!servers.isEmpty()) {
            return this.server;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("No server chosen by %s from cluster description %s.", serverSelector, this.clusterDescription));
        }
        throw new MongoConfigurationException(String.format("No server that matches %s. Client view of cluster state is %s", serverSelector, this.clusterDescription.getShortDescription()));
    }

    public void selectServerAsync(ServerSelector serverSelector, SingleResultCallback<Server> callback) {
        throw new UnsupportedOperationException("Async not supported");
    }

    public void close() {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.server.close();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

