/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.embedded.client.MongoDBCAPIHelper;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.InternalStreamConnection;
import com.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.session.SessionContext;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.codecs.Decoder;

class EmbeddedInternalConnection
implements InternalConnection {
    private final InternalConnection wrapped;
    private volatile Pointer clientStatusPointer = MongoDBCAPIHelper.createStatusPointer();
    private volatile Pointer clientPointer;

    EmbeddedInternalConnection(Pointer instancePointer, CommandListener commandListener, BsonDocument clientMetadataDocument) {
        this.clientPointer = MongoDBCAPIHelper.create_client(instancePointer, this.clientStatusPointer);
        this.wrapped = new InternalStreamConnection(new ServerId(new ClusterId(), new ServerAddress()), new StreamFactory(){

            public Stream create(ServerAddress serverAddress) {
                return new EmbeddedInternalStream();
            }
        }, Collections.emptyList(), commandListener, (InternalConnectionInitializer)new InternalStreamConnectionInitializer(Collections.emptyList(), clientMetadataDocument, Collections.emptyList()));
    }

    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    public void open() {
        this.wrapped.open();
    }

    public void openAsync(SingleResultCallback<Void> callback) {
        this.wrapped.openAsync(callback);
    }

    public void close() {
        if (!this.wrapped.isClosed()) {
            this.wrapped.close();
            MongoDBCAPIHelper.client_destroy(this.clientPointer, this.clientStatusPointer);
            this.clientPointer = null;
            MongoDBCAPIHelper.destroyStatusPointer(this.clientStatusPointer);
            this.clientStatusPointer = null;
        }
    }

    public boolean opened() {
        return this.wrapped.opened();
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext) {
        return (T)this.wrapped.sendAndReceive(message, decoder, sessionContext);
    }

    public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, SingleResultCallback<T> callback) {
        this.wrapped.sendAndReceiveAsync(message, decoder, sessionContext, callback);
    }

    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
        this.wrapped.sendMessage(byteBuffers, lastRequestId);
    }

    public ResponseBuffers receiveMessage(int responseTo) {
        return this.wrapped.receiveMessage(responseTo);
    }

    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, SingleResultCallback<Void> callback) {
        this.wrapped.sendMessageAsync(byteBuffers, lastRequestId, callback);
    }

    public void receiveMessageAsync(int responseTo, SingleResultCallback<ResponseBuffers> callback) {
        this.wrapped.receiveMessageAsync(responseTo, callback);
    }

    public ByteBuf getBuffer(int size) {
        return this.wrapped.getBuffer(size);
    }

    class EmbeddedInternalStream
    implements Stream {
        private volatile boolean isClosed;
        private volatile ByteBuffer curResponse;

        EmbeddedInternalStream() {
        }

        public void open() {
        }

        public void openAsync(AsyncCompletionHandler<Void> handler) {
            handler.completed(null);
        }

        public void write(List<ByteBuf> buffers) {
            byte[] message = this.createCompleteMessage(buffers);
            PointerByReference outputBufferReference = new PointerByReference();
            IntByReference outputSize = new IntByReference();
            MongoDBCAPIHelper.client_invoke(EmbeddedInternalConnection.this.clientPointer, message, outputBufferReference, outputSize, EmbeddedInternalConnection.this.clientStatusPointer);
            this.curResponse = outputBufferReference.getValue().getByteBuffer(0L, (long)outputSize.getValue());
        }

        public ByteBuf read(int numBytes) {
            ByteBuffer slice = this.curResponse.slice();
            ((Buffer)slice).limit(numBytes);
            ((Buffer)this.curResponse).position(this.curResponse.position() + numBytes);
            return new ByteBufNIO(slice);
        }

        public void writeAsync(List<ByteBuf> buffers, AsyncCompletionHandler<Void> handler) {
            throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
        }

        public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
            throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
        }

        public ServerAddress getAddress() {
            return EmbeddedInternalConnection.this.wrapped.getDescription().getServerAddress();
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public ByteBuf getBuffer(int size) {
            return new ByteBufNIO(ByteBuffer.wrap(new byte[size]));
        }

        private byte[] createCompleteMessage(List<ByteBuf> byteBufList) {
            List<ByteBuffer> buffers = this.asByteBufferList(byteBufList);
            int totalLength = 0;
            for (ByteBuffer cur : buffers) {
                totalLength += cur.remaining();
            }
            byte[] completeMessage = new byte[totalLength];
            int offset = 0;
            for (ByteBuffer cur : buffers) {
                int remaining = cur.remaining();
                cur.get(completeMessage, offset, cur.remaining());
                offset += remaining;
            }
            return completeMessage;
        }

        private List<ByteBuffer> asByteBufferList(List<ByteBuf> byteBufList) {
            ArrayList<ByteBuffer> retVal = new ArrayList<ByteBuffer>(byteBufList.size());
            for (ByteBuf cur : byteBufList) {
                retVal.add(cur.asNIO());
            }
            return retVal;
        }
    }
}

