/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.embedded.client.EmbeddedInternalConnection;
import com.mongodb.embedded.client.EmbeddedInternalConnectionFactory;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.ConcurrentPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.session.SessionContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.ByteBuf;
import org.bson.codecs.Decoder;

class EmbeddedInternalConnectionPool {
    private final ConcurrentPool<EmbeddedInternalConnection> pool;
    private volatile boolean closed;

    EmbeddedInternalConnectionPool(EmbeddedInternalConnectionFactory internalConnectionFactory) {
        this.pool = new ConcurrentPool(Integer.MAX_VALUE, (ConcurrentPool.ItemFactory)new EmbeddedConnectionItemFactory(internalConnectionFactory));
    }

    InternalConnection get() {
        Assertions.isTrue((String)"Embedded connection pool is open", (!this.closed ? 1 : 0) != 0);
        return this.getPooledConnection();
    }

    void close() {
        if (!this.closed) {
            this.pool.close();
            this.closed = true;
        }
    }

    private InternalConnection getPooledConnection() {
        PooledConnection connection = new PooledConnection((EmbeddedInternalConnection)this.pool.get());
        if (!connection.opened()) {
            connection.open();
        }
        return connection;
    }

    private class PooledConnection
    implements InternalConnection {
        private final EmbeddedInternalConnection wrapped;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        PooledConnection(EmbeddedInternalConnection wrapped) {
            this.wrapped = wrapped;
        }

        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        public void open() {
            this.wrapped.open();
        }

        public void openAsync(SingleResultCallback<Void> callback) {
            this.wrapped.openAsync(callback);
        }

        public void close() {
            if (!this.isClosed.getAndSet(true)) {
                EmbeddedInternalConnectionPool.this.pool.release((Object)this.wrapped, this.wrapped.isClosed());
            }
        }

        public boolean opened() {
            return this.wrapped.opened();
        }

        public boolean isClosed() {
            return this.wrapped.isClosed();
        }

        public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext) {
            return this.wrapped.sendAndReceive(message, decoder, sessionContext);
        }

        public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, SingleResultCallback<T> callback) {
            this.wrapped.sendAndReceiveAsync(message, decoder, sessionContext, callback);
        }

        public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
            this.wrapped.sendMessage(byteBuffers, lastRequestId);
        }

        public ResponseBuffers receiveMessage(int responseTo) {
            return this.wrapped.receiveMessage(responseTo);
        }

        public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, SingleResultCallback<Void> callback) {
            this.wrapped.sendMessageAsync(byteBuffers, lastRequestId, callback);
        }

        public void receiveMessageAsync(int responseTo, SingleResultCallback<ResponseBuffers> callback) {
            this.wrapped.receiveMessageAsync(responseTo, callback);
        }

        public ByteBuf getBuffer(int size) {
            return this.wrapped.getBuffer(size);
        }
    }

    private static class EmbeddedConnectionItemFactory
    implements ConcurrentPool.ItemFactory<EmbeddedInternalConnection> {
        private final EmbeddedInternalConnectionFactory internalConnectionFactory;

        EmbeddedConnectionItemFactory(EmbeddedInternalConnectionFactory internalConnectionFactory) {
            this.internalConnectionFactory = internalConnectionFactory;
        }

        public EmbeddedInternalConnection create(boolean initialize) {
            return this.internalConnectionFactory.create();
        }

        public void close(EmbeddedInternalConnection embeddedInternalConnection) {
            embeddedInternalConnection.close();
        }

        public ConcurrentPool.Prune shouldPrune(EmbeddedInternalConnection embeddedInternalConnection) {
            return ConcurrentPool.Prune.NO;
        }
    }
}

