/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.Connection;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerVersion;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.embedded.client.EmbeddedInternalConnection;
import com.mongodb.embedded.client.EmbeddedInternalConnectionFactory;
import com.mongodb.embedded.client.EmbeddedInternalConnectionPool;
import com.mongodb.embedded.client.MongoClientSettings;
import com.mongodb.embedded.client.MongoDBCAPIHelper;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.connection.ClientMetadataHelper;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.DefaultServerConnection;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.LegacyProtocol;
import com.mongodb.internal.connection.ProtocolExecutor;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.session.SessionContext;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.File;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

class EmbeddedServer
implements Server,
Closeable {
    private static final Logger LOGGER = Loggers.getLogger((String)"embedded.client");
    private static final MongoDriverInformation MONGO_DRIVER_INFORMATION = MongoDriverInformation.builder().driverName("embedded").build();
    private final ClusterClock clusterClock;
    private final CommandListener commandListener;
    private final ServerAddress serverAddress;
    private final ServerDescription serverDescription;
    private final EmbeddedInternalConnectionPool connectionPool;
    private volatile boolean isClosed;
    private volatile Pointer instanceStatusPointer = MongoDBCAPIHelper.createStatusPointer();
    private volatile Pointer instancePointer;

    EmbeddedServer(final MongoClientSettings mongoClientSettings) {
        this.instancePointer = this.createInstancePointer(mongoClientSettings);
        this.clusterClock = new ClusterClock();
        this.commandListener = EventListenerHelper.getCommandListener(mongoClientSettings.getCommandListeners());
        this.serverAddress = new ServerAddress();
        this.connectionPool = new EmbeddedInternalConnectionPool(new EmbeddedInternalConnectionFactory(){

            @Override
            public EmbeddedInternalConnection create() {
                return new EmbeddedInternalConnection(EmbeddedServer.this.instancePointer, EmbeddedServer.this.commandListener, ClientMetadataHelper.createClientMetadataDocument((String)mongoClientSettings.getApplicationName(), (MongoDriverInformation)MONGO_DRIVER_INFORMATION));
            }
        });
        this.serverDescription = this.createServerDescription();
    }

    public ServerDescription getDescription() {
        Assertions.isTrue((String)"open", (!this.isClosed ? 1 : 0) != 0);
        return this.serverDescription;
    }

    public Connection getConnection() {
        Assertions.isTrue((String)"open", (!this.isClosed ? 1 : 0) != 0);
        return new DefaultServerConnection(this.connectionPool.get(), (ProtocolExecutor)new DefaultServerProtocolExecutor(), ClusterConnectionMode.SINGLE);
    }

    public void getConnectionAsync(SingleResultCallback<AsyncConnection> callback) {
        throw new UnsupportedOperationException("Async not supported");
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.connectionPool.close();
            this.destroyInstancePointer();
        }
    }

    private Pointer createInstancePointer(MongoClientSettings mongoClientSettings) {
        File directory = new File(mongoClientSettings.getDbPath());
        try {
            if (directory.mkdirs() && LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Created dbpath directory: %s", mongoClientSettings.getDbPath()));
            }
        }
        catch (SecurityException e) {
            throw new MongoException(String.format("Could not validate / create the dbpath: %s", mongoClientSettings.getDbPath()));
        }
        String yamlConfig = this.createYamlConfig(mongoClientSettings);
        return MongoDBCAPIHelper.instance_create(yamlConfig, this.instanceStatusPointer);
    }

    private void destroyInstancePointer() {
        MongoDBCAPIHelper.instance_destroy(this.instancePointer, this.instanceStatusPointer);
        this.instancePointer = null;
        MongoDBCAPIHelper.destroyStatusPointer(this.instanceStatusPointer);
        this.instanceStatusPointer = null;
    }

    private String createYamlConfig(MongoClientSettings mongoClientSettings) {
        return String.format("{ storage: { dbPath: %s } }", mongoClientSettings.getDbPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerDescription createServerDescription() {
        InternalConnection connection = this.connectionPool.get();
        try {
            long start = System.nanoTime();
            BsonDocument isMasterResult = CommandHelper.executeCommand((String)"admin", (BsonDocument)new BsonDocument("ismaster", (BsonValue)new BsonInt32(1)), (ClusterClock)this.clusterClock, (InternalConnection)connection);
            ServerDescription serverDescription = DescriptionHelper.createServerDescription((ServerAddress)this.serverAddress, (BsonDocument)isMasterResult, (ServerVersion)connection.getDescription().getServerVersion(), (long)(System.nanoTime() - start));
            return serverDescription;
        }
        finally {
            connection.close();
        }
    }

    private class DefaultServerProtocolExecutor
    implements ProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        public <T> T execute(LegacyProtocol<T> protocol, InternalConnection connection) {
            protocol.setCommandListener(EmbeddedServer.this.commandListener);
            return (T)protocol.execute(connection);
        }

        public <T> void executeAsync(LegacyProtocol<T> protocol, InternalConnection connection, SingleResultCallback<T> callback) {
            protocol.setCommandListener(EmbeddedServer.this.commandListener);
            protocol.executeAsync(connection, callback);
        }

        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            protocol.sessionContext((SessionContext)new ClusterClockAdvancingSessionContext(sessionContext, EmbeddedServer.this.clusterClock));
            return (T)protocol.execute(connection);
        }

        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.sessionContext((SessionContext)new ClusterClockAdvancingSessionContext(sessionContext, EmbeddedServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
        }
    }
}

