/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.embedded.client.MongoClientEmbeddedException;
import com.mongodb.event.CommandListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public final class MongoClientSettings {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = com.mongodb.MongoClientSettings.getDefaultCodecRegistry();
    private final com.mongodb.MongoClientSettings wrappedMongoClientSettings;
    private final String dbPath;

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    public String getApplicationName() {
        return this.wrappedMongoClientSettings.getApplicationName();
    }

    public CodecRegistry getCodecRegistry() {
        return this.wrappedMongoClientSettings.getCodecRegistry();
    }

    public List<CommandListener> getCommandListeners() {
        return this.wrappedMongoClientSettings.getCommandListeners();
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public com.mongodb.MongoClientSettings getWrappedMongoClientSettings() {
        return this.wrappedMongoClientSettings;
    }

    private MongoClientSettings(Builder builder) {
        Assertions.isTrue((String)"dbPath is set", (builder.dbPath != null && !builder.dbPath.isEmpty() ? 1 : 0) != 0);
        this.dbPath = builder.dbPath;
        this.wrappedMongoClientSettings = builder.wrappedBuilder.build();
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings.Builder wrappedBuilder;
        private String dbPath;

        private Builder() {
            this.wrappedBuilder = com.mongodb.MongoClientSettings.builder();
        }

        private Builder(MongoClientSettings settings) {
            Assertions.notNull((String)"settings", (Object)settings);
            this.wrappedBuilder = com.mongodb.MongoClientSettings.builder((com.mongodb.MongoClientSettings)settings.wrappedMongoClientSettings);
            this.dbPath = settings.dbPath;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            this.wrappedBuilder.applyConnectionString(connectionString);
            if (connectionString.getHosts().size() == 1) {
                try {
                    this.dbPath = URLDecoder.decode((String)connectionString.getHosts().get(0), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new MongoClientException(String.format("Connection String contains an invalid host: %s", connectionString.getHosts().get(0)));
                }
            } else {
                throw new MongoClientEmbeddedException(String.format("Connection String contains invalid hosts: %s", connectionString.getHosts()));
            }
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.wrappedBuilder.codecRegistry(codecRegistry);
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            this.wrappedBuilder.addCommandListener(commandListener);
            return this;
        }

        public Builder commandListenerList(List<CommandListener> commandListeners) {
            this.wrappedBuilder.commandListenerList(commandListeners);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.wrappedBuilder.applicationName(applicationName);
            return this;
        }

        public Builder dbPath(String dbPath) {
            this.dbPath = (String)Assertions.notNull((String)"dbPath", (Object)dbPath);
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }
    }
}

