/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.embedded.client.MongoClientEmbeddedException;
import com.mongodb.embedded.client.MongoDBCAPI;
import com.mongodb.embedded.client.MongoEmbeddedSettings;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;

final class MongoDBCAPIHelper {
    private static final Logger LOGGER = Loggers.getLogger((String)"embedded.server");
    private static final String NATIVE_LIBRARY_NAME = "mongo_embedded_capi";
    private static final LogCallback LOG_CALLBACK = new LogCallback();
    private static volatile MongoDBCAPI mongoDBCAPI;
    private static volatile Pointer libraryStatusPointer;
    private static volatile Pointer libraryPointer;

    static synchronized void checkHasBeenInitialized() {
        MongoDBCAPIHelper.checkInitialized();
    }

    static synchronized void init(MongoEmbeddedSettings mongoEmbeddedSettings) {
        if (mongoDBCAPI != null) {
            throw new MongoClientEmbeddedException("MongoDBCAPI has been initialized but not closed");
        }
        if (mongoEmbeddedSettings.getLibraryPath() != null) {
            NativeLibrary.addSearchPath((String)NATIVE_LIBRARY_NAME, (String)mongoEmbeddedSettings.getLibraryPath());
        }
        try {
            mongoDBCAPI = (MongoDBCAPI)Native.loadLibrary((String)NATIVE_LIBRARY_NAME, MongoDBCAPI.class);
        }
        catch (UnsatisfiedLinkError e) {
            throw new MongoClientEmbeddedException(String.format("Failed to load the mongodb library: '%s'.%n %s %n%n Please set the library location by either:%n - Adding it to the classpath.%n - Setting 'jna.library.path' system property%n - Configuring it in the 'MongoEmbeddedSettings.builder().libraryPath' method.%n", NATIVE_LIBRARY_NAME, e.getMessage()), e);
        }
        libraryStatusPointer = MongoDBCAPIHelper.createStatusPointer();
        libraryPointer = mongoDBCAPI.mongo_embedded_v1_lib_init(new MongoDBCAPIInitParams(mongoEmbeddedSettings), libraryStatusPointer);
        if (libraryPointer == null) {
            MongoDBCAPIHelper.createErrorFromStatus(libraryStatusPointer);
        }
    }

    static synchronized void fini() {
        MongoDBCAPIHelper.checkInitialized();
        try {
            MongoDBCAPIHelper.validateErrorCode(libraryStatusPointer, mongoDBCAPI.mongo_embedded_v1_lib_fini(libraryPointer, libraryStatusPointer));
            libraryPointer = null;
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("fini", t);
        }
        MongoDBCAPIHelper.destroyStatusPointer(libraryStatusPointer);
        libraryStatusPointer = null;
        mongoDBCAPI = null;
    }

    static Pointer instance_create(String yamlConfig, Pointer instanceStatusPointer) {
        MongoDBCAPIHelper.checkInitialized();
        try {
            return MongoDBCAPIHelper.validatePointerCreated(instanceStatusPointer, mongoDBCAPI.mongo_embedded_v1_instance_create(libraryPointer, yamlConfig, instanceStatusPointer));
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("instance_create", t);
        }
    }

    static void instance_destroy(Pointer instance, Pointer instanceStatusPointer) {
        MongoDBCAPIHelper.checkInitialized();
        try {
            MongoDBCAPIHelper.validateErrorCode(instanceStatusPointer, mongoDBCAPI.mongo_embedded_v1_instance_destroy(instance, instanceStatusPointer));
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("instance_destroy", t);
        }
    }

    static Pointer create_client(Pointer instance, Pointer clientStatusPointer) {
        MongoDBCAPIHelper.checkInitialized();
        try {
            return MongoDBCAPIHelper.validatePointerCreated(clientStatusPointer, mongoDBCAPI.mongo_embedded_v1_client_create(instance, clientStatusPointer));
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("client_create", t);
        }
    }

    static void client_destroy(Pointer client, Pointer clientStatusPointer) {
        MongoDBCAPIHelper.checkInitialized();
        try {
            MongoDBCAPIHelper.validateErrorCode(clientStatusPointer, mongoDBCAPI.mongo_embedded_v1_client_destroy(client, clientStatusPointer));
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("client_destroy", t);
        }
    }

    static void client_invoke(Pointer client, byte[] input, PointerByReference output, IntByReference outputSize, Pointer clientStatusPointer) {
        MongoDBCAPIHelper.checkInitialized();
        try {
            MongoDBCAPIHelper.validateErrorCode(clientStatusPointer, mongoDBCAPI.mongo_embedded_v1_client_invoke(client, input, input.length, output, outputSize, clientStatusPointer));
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("client_invoke", t);
        }
    }

    static Pointer createStatusPointer() {
        try {
            return mongoDBCAPI.mongo_embedded_v1_status_create();
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("status_create", t);
        }
    }

    static void destroyStatusPointer(Pointer statusPointer) {
        try {
            mongoDBCAPI.mongo_embedded_v1_status_destroy(statusPointer);
        }
        catch (Throwable t) {
            throw MongoDBCAPIHelper.createError("status_destroy", t);
        }
    }

    private static MongoClientEmbeddedException createError(String methodName, Throwable t) {
        if (t instanceof MongoClientEmbeddedException) {
            return (MongoClientEmbeddedException)((Object)t);
        }
        return new MongoClientEmbeddedException(String.format("Error from embedded server when calling '%s': %s", methodName, t.getMessage()), t);
    }

    private static void createErrorFromStatus(Pointer statusPointer) {
        MongoDBCAPIHelper.createErrorFromStatus(statusPointer, mongoDBCAPI.mongo_embedded_v1_status_get_error(statusPointer));
    }

    private static void createErrorFromStatus(Pointer statusPointer, int errorCode) {
        throw new MongoClientEmbeddedException(errorCode, mongoDBCAPI.mongo_embedded_v1_status_get_code(statusPointer), mongoDBCAPI.mongo_embedded_v1_status_get_explanation(statusPointer));
    }

    private static Pointer validatePointerCreated(Pointer statusPointer, Pointer pointer) {
        if (pointer == null) {
            MongoDBCAPIHelper.createErrorFromStatus(statusPointer);
        }
        return pointer;
    }

    private static void validateErrorCode(Pointer statusPointer, int errorCode) {
        if (errorCode != 0) {
            MongoDBCAPIHelper.createErrorFromStatus(statusPointer, errorCode);
        }
    }

    private static void checkInitialized() {
        if (mongoDBCAPI == null || libraryPointer == null || libraryStatusPointer == null) {
            throw new MongoClientEmbeddedException("MongoDBCAPI has not been initialized");
        }
    }

    private MongoDBCAPIHelper() {
    }

    static class LogCallback
    implements Callback {
        LogCallback() {
        }

        public void apply(String userData, String message, String component, String context, int severity) {
            String logMessage = String.format("%-9s [%s] %s", component.toUpperCase(), context, message).trim();
            if (severity < -2) {
                LOGGER.error(logMessage);
            } else if (severity == -2) {
                LOGGER.warn(logMessage);
            } else if (severity < 1) {
                LOGGER.info(logMessage);
            } else {
                LOGGER.debug(logMessage);
            }
        }
    }

    public static class MongoDBCAPIInitParams
    extends Structure {
        public String yamlConfig;
        public long logFlags;
        public Callback logCallback;
        public String userData;

        MongoDBCAPIInitParams(MongoEmbeddedSettings settings) {
            this.yamlConfig = settings.getYamlConfig();
            this.logFlags = settings.getLogLevel().getLevel();
            this.logCallback = settings.getLogLevel() == MongoEmbeddedSettings.LogLevel.LOGGER ? LOG_CALLBACK : null;
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("yamlConfig", "logFlags", "logCallback", "userData");
        }
    }
}

