/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.embedded.client;

import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;

@Immutable
public final class MongoEmbeddedSettings {
    private final String libraryPath;
    private final String yamlConfig;
    private final LogLevel logLevel;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoEmbeddedSettings settings) {
        return new Builder(settings);
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public String getYamlConfig() {
        return this.yamlConfig;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    private MongoEmbeddedSettings(Builder builder) {
        this.libraryPath = builder.libraryPath;
        this.yamlConfig = builder.yamlConfig;
        this.logLevel = builder.logLevel;
    }

    @NotThreadSafe
    public static final class Builder {
        private String libraryPath;
        private String yamlConfig;
        private LogLevel logLevel = LogLevel.LOGGER;

        private Builder() {
        }

        private Builder(MongoEmbeddedSettings settings) {
            Assertions.notNull((String)"settings", (Object)settings);
            this.libraryPath = settings.libraryPath;
            this.yamlConfig = settings.yamlConfig;
            this.logLevel = settings.logLevel;
        }

        public Builder libraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder yamlConfig(String yamlConfig) {
            this.yamlConfig = yamlConfig;
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public MongoEmbeddedSettings build() {
            return new MongoEmbeddedSettings(this);
        }
    }

    public static enum LogLevel {
        NONE(0),
        STDOUT(1),
        STDERR(2),
        LOGGER(4);

        private final int level;

        public int getLevel() {
            return this.level;
        }

        private LogLevel(int level) {
            this.level = level;
        }
    }
}

