/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderAdapter;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.DBObjectCollationHelper;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.Function;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCreateViewOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.connection.BufferProvider;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CreateCollectionOperation;
import com.mongodb.internal.operation.CreateViewOperation;
import com.mongodb.internal.operation.DropDatabaseOperation;
import com.mongodb.internal.operation.ListCollectionsOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.Encoder;

@ThreadSafe
public class DB {
    private final MongoClient mongo;
    private final String name;
    private final OperationExecutor executor;
    private final ConcurrentHashMap<String, DBCollection> collectionCache;
    private final Codec<DBObject> commandCodec;
    private volatile ReadPreference readPreference;
    private volatile WriteConcern writeConcern;
    private volatile ReadConcern readConcern;
    private static final Set<String> OBEDIENT_COMMANDS = new HashSet<String>();

    DB(MongoClient mongo, String name, OperationExecutor executor) {
        MongoNamespace.checkDatabaseNameValidity((String)name);
        this.mongo = mongo;
        this.name = name;
        this.executor = executor;
        this.collectionCache = new ConcurrentHashMap();
        this.commandCodec = new DBObjectCodec(MongoClientSettings.getDefaultCodecRegistry());
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference != null ? this.readPreference : this.mongo.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern != null ? this.writeConcern : this.mongo.getWriteConcern();
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern != null ? this.readConcern : this.mongo.getReadConcern();
    }

    public DBCollection getCollection(String name) {
        DBCollection old;
        DBCollection collection = this.collectionCache.get(name);
        if (collection != null) {
            return collection;
        }
        collection = new DBCollection(name, this, this.executor);
        if (this.mongo.getMongoClientOptions().getDbDecoderFactory() != DefaultDBDecoder.FACTORY) {
            collection.setDBDecoderFactory(this.mongo.getMongoClientOptions().getDbDecoderFactory());
        }
        if (this.mongo.getMongoClientOptions().getDbEncoderFactory() != DefaultDBEncoder.FACTORY) {
            collection.setDBEncoderFactory(this.mongo.getMongoClientOptions().getDbEncoderFactory());
        }
        return (old = this.collectionCache.putIfAbsent(name, collection)) != null ? old : collection;
    }

    public void dropDatabase() {
        try {
            this.getExecutor().execute((WriteOperation)new DropDatabaseOperation(this.getName(), this.getWriteConcern()), this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getCollectionNames() {
        List collectionNames = (List)new MongoIterableImpl<DBObject>(null, this.executor, ReadConcern.DEFAULT, ReadPreference.primary(), this.mongo.getMongoClientOptions().getRetryReads()){

            public ReadOperation<BatchCursor<DBObject>> asReadOperation() {
                return new ListCollectionsOperation(DB.this.name, (Decoder)DB.this.commandCodec).nameOnly(true);
            }
        }.map((Function)new Function<DBObject, String>(){

            public String apply(DBObject result) {
                return (String)result.get("name");
            }
        }).into(new ArrayList());
        Collections.sort(collectionNames);
        return new LinkedHashSet<String>(collectionNames);
    }

    public DBCollection createCollection(String collectionName, @Nullable DBObject options) {
        if (options != null) {
            try {
                this.executor.execute((WriteOperation)this.getCreateCollectionOperation(collectionName, options), this.getReadConcern());
            }
            catch (MongoWriteConcernException e) {
                throw DBCollection.createWriteConcernException(e);
            }
        }
        return this.getCollection(collectionName);
    }

    public DBCollection createView(String viewName, String viewOn, List<? extends DBObject> pipeline) {
        return this.createView(viewName, viewOn, pipeline, new DBCreateViewOptions());
    }

    public DBCollection createView(String viewName, String viewOn, List<? extends DBObject> pipeline, DBCreateViewOptions options) {
        try {
            Assertions.notNull((String)"options", (Object)options);
            DBCollection view = this.getCollection(viewName);
            this.executor.execute((WriteOperation)new CreateViewOperation(this.name, viewName, viewOn, view.preparePipeline(pipeline), this.writeConcern).collation(options.getCollation()), this.getReadConcern());
            return view;
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    private CreateCollectionOperation getCreateCollectionOperation(String collectionName, DBObject options) {
        if (options.get("size") != null && !(options.get("size") instanceof Number)) {
            throw new IllegalArgumentException("'size' should be Number");
        }
        if (options.get("max") != null && !(options.get("max") instanceof Number)) {
            throw new IllegalArgumentException("'max' should be Number");
        }
        if (options.get("capped") != null && !(options.get("capped") instanceof Boolean)) {
            throw new IllegalArgumentException("'capped' should be Boolean");
        }
        if (options.get("autoIndexId") != null && !(options.get("autoIndexId") instanceof Boolean)) {
            throw new IllegalArgumentException("'autoIndexId' should be Boolean");
        }
        if (options.get("storageEngine") != null && !(options.get("storageEngine") instanceof DBObject)) {
            throw new IllegalArgumentException("'storageEngine' should be DBObject");
        }
        if (options.get("indexOptionDefaults") != null && !(options.get("indexOptionDefaults") instanceof DBObject)) {
            throw new IllegalArgumentException("'indexOptionDefaults' should be DBObject");
        }
        if (options.get("validator") != null && !(options.get("validator") instanceof DBObject)) {
            throw new IllegalArgumentException("'validator' should be DBObject");
        }
        if (options.get("validationLevel") != null && !(options.get("validationLevel") instanceof String)) {
            throw new IllegalArgumentException("'validationLevel' should be String");
        }
        if (options.get("validationAction") != null && !(options.get("validationAction") instanceof String)) {
            throw new IllegalArgumentException("'validationAction' should be String");
        }
        boolean capped = false;
        boolean autoIndex = true;
        long sizeInBytes = 0L;
        long maxDocuments = 0L;
        BsonDocument storageEngineOptions = null;
        BsonDocument indexOptionDefaults = null;
        BsonDocument validator = null;
        ValidationLevel validationLevel = null;
        ValidationAction validationAction = null;
        if (options.get("capped") != null) {
            capped = (Boolean)options.get("capped");
        }
        if (options.get("size") != null) {
            sizeInBytes = ((Number)options.get("size")).longValue();
        }
        if (options.get("autoIndexId") != null) {
            autoIndex = (Boolean)options.get("autoIndexId");
        }
        if (options.get("max") != null) {
            maxDocuments = ((Number)options.get("max")).longValue();
        }
        if (options.get("storageEngine") != null) {
            storageEngineOptions = this.wrap((DBObject)options.get("storageEngine"));
        }
        if (options.get("indexOptionDefaults") != null) {
            indexOptionDefaults = this.wrap((DBObject)options.get("indexOptionDefaults"));
        }
        if (options.get("validator") != null) {
            validator = this.wrap((DBObject)options.get("validator"));
        }
        if (options.get("validationLevel") != null) {
            validationLevel = ValidationLevel.fromString((String)((String)options.get("validationLevel")));
        }
        if (options.get("validationAction") != null) {
            validationAction = ValidationAction.fromString((String)((String)options.get("validationAction")));
        }
        Collation collation = DBObjectCollationHelper.createCollationFromOptions(options);
        return new CreateCollectionOperation(this.getName(), collectionName, this.getWriteConcern()).capped(capped).collation(collation).sizeInBytes(sizeInBytes).autoIndex(autoIndex).maxDocuments(maxDocuments).storageEngineOptions(storageEngineOptions).indexOptionDefaults(indexOptionDefaults).validator(validator).validationLevel(validationLevel).validationAction(validationAction);
    }

    public CommandResult command(String command) {
        return this.command((DBObject)new BasicDBObject(command, (Object)Boolean.TRUE), this.getReadPreference());
    }

    public CommandResult command(DBObject command) {
        return this.command(command, this.getReadPreference());
    }

    public CommandResult command(DBObject command, DBEncoder encoder) {
        return this.command(command, this.getReadPreference(), encoder);
    }

    public CommandResult command(DBObject command, ReadPreference readPreference, @Nullable DBEncoder encoder) {
        try {
            return this.executeCommand(this.wrap(command, encoder), this.getCommandReadPreference(command, readPreference));
        }
        catch (MongoCommandException ex) {
            return new CommandResult(ex.getResponse(), ex.getServerAddress());
        }
    }

    public CommandResult command(DBObject command, ReadPreference readPreference) {
        return this.command(command, readPreference, null);
    }

    public CommandResult command(String command, ReadPreference readPreference) {
        return this.command((DBObject)new BasicDBObject(command, (Object)true), readPreference);
    }

    public DB getSisterDB(String name) {
        return this.mongo.getDB(name);
    }

    public boolean collectionExists(String collectionName) {
        Set<String> collectionNames = this.getCollectionNames();
        for (String name : collectionNames) {
            if (!name.equalsIgnoreCase(collectionName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "DB{name='" + this.name + '\'' + '}';
    }

    CommandResult executeCommand(BsonDocument commandDocument, ReadPreference readPreference) {
        return new CommandResult((BsonDocument)this.executor.execute((ReadOperation)new CommandReadOperation(this.getName(), commandDocument, (Decoder)new BsonDocumentCodec()), readPreference, this.getReadConcern()));
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    BufferProvider getBufferPool() {
        return this.getMongoClient().getBufferProvider();
    }

    private BsonDocument wrap(DBObject document) {
        return new BsonDocumentWrapper((Object)document, this.commandCodec);
    }

    private BsonDocument wrap(DBObject document, @Nullable DBEncoder encoder) {
        if (encoder == null) {
            return this.wrap(document);
        }
        return new BsonDocumentWrapper((Object)document, (Encoder)new DBEncoderAdapter(encoder));
    }

    ReadPreference getCommandReadPreference(DBObject command, @Nullable ReadPreference requestedPreference) {
        boolean primaryRequired;
        String comString = ((String)command.keySet().iterator().next()).toLowerCase();
        boolean bl = primaryRequired = !OBEDIENT_COMMANDS.contains(comString);
        if (primaryRequired) {
            return ReadPreference.primary();
        }
        if (requestedPreference == null) {
            return ReadPreference.primary();
        }
        return requestedPreference;
    }

    static {
        OBEDIENT_COMMANDS.add("aggregate");
        OBEDIENT_COMMANDS.add("collstats");
        OBEDIENT_COMMANDS.add("count");
        OBEDIENT_COMMANDS.add("dbstats");
        OBEDIENT_COMMANDS.add("distinct");
        OBEDIENT_COMMANDS.add("geonear");
        OBEDIENT_COMMANDS.add("geosearch");
        OBEDIENT_COMMANDS.add("geowalk");
        OBEDIENT_COMMANDS.add("group");
        OBEDIENT_COMMANDS.add("listcollections");
        OBEDIENT_COMMANDS.add("listindexes");
        OBEDIENT_COMMANDS.add("parallelcollectionscan");
        OBEDIENT_COMMANDS.add("text");
    }
}

