/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.jdbc.MongoDatabaseMetaData;
import com.mongodb.jdbc.MongoPreparedStatement;
import com.mongodb.jdbc.MongoStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.Document;

public class MongoConnection
implements Connection {
    private MongoClient mongoClient;
    private String currentDB;
    private String url;
    private String user;
    private boolean isClosed;
    private boolean relaxed;

    public MongoConnection(ConnectionString cs, String database, String conversionMode) {
        Preconditions.checkNotNull(cs);
        this.url = cs.getConnectionString();
        this.user = cs.getUsername();
        this.currentDB = database;
        this.mongoClient = MongoClients.create(cs);
        this.relaxed = conversionMode == null || !conversionMode.equals("strict");
        this.isClosed = false;
    }

    private void checkConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
    }

    String getURL() {
        return this.url;
    }

    String getUser() {
        return this.user;
    }

    String getServerVersion() throws SQLException {
        this.checkConnection();
        BsonDocument command = new BsonDocument();
        command.put("buildInfo", new BsonInt32(1));
        try {
            Document result = this.mongoClient.getDatabase("admin").runCommand(command);
            return (String)result.get("version");
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkConnection();
        try {
            return new MongoStatement(this, this.currentDB, this.relaxed);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    protected MongoDatabase getDatabase(String DBName) {
        return this.mongoClient.getDatabase(DBName);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkConnection();
        try {
            return new MongoPreparedStatement(sql, this, this.currentDB, this.relaxed);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void commit() throws SQLException {
        this.checkConnection();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkConnection();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.mongoClient.close();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MongoDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkConnection();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkConnection();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkConnection();
        this.currentDB = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return this.currentDB;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkConnection();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkConnection();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkConnection();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return this.createStatement();
        }
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace().toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkConnection();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return this.createStatement();
        }
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    private void validateConn() throws SQLException {
        Statement statement = this.createStatement();
        boolean resultExists = statement.execute("SELECT 1 from DUAL");
        if (!resultExists) {
            throw new SQLException("Connection error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Input is invalid.");
        }
        if (this.isClosed()) {
            return false;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<Object> future = executor.submit(new ConnValidation());
        try {
            if (timeout > 0) {
                future.get(timeout, TimeUnit.SECONDS);
            } else {
                future.get();
            }
        }
        catch (TimeoutException ex) {
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            future.cancel(true);
            executor.shutdown();
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException(null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException(null);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void beginRequest() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void endRequest() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    class ConnValidation
    implements Callable<Object> {
        ConnValidation() {
        }

        @Override
        public Object call() throws SQLException {
            Statement statement = MongoConnection.this.createStatement();
            boolean resultExists = statement.execute("SELECT 1 from DUAL");
            if (!resultExists) {
                throw new SQLException("Connection error");
            }
            return null;
        }
    }
}

