/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.ConnectionString;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoDriver
implements Driver {
    static final String JDBC = "jdbc:";
    static final String MONGODB_URL_PREFIX = "jdbc:mongodb:";
    static final String MONGODB_SRV_URL_PREFIX = "jdbc:mongodb+srv:";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String CONVERSION_MODE = "conversionMode";
    static final String DATABASE = "database";
    static final String VERSION;
    static final int MAJOR_VERSION;
    static final int MINOR_VERSION;
    static CodecRegistry registry;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Pair<ConnectionString, DriverPropertyInfo[]> p;
        DriverPropertyInfo[] driverPropertyInfo;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        if ((driverPropertyInfo = (p = this.getConnectionString(url, info)).right()).length != 0) {
            if (driverPropertyInfo[0].name.equals(USER)) {
                throw new SQLException("password specified without user");
            }
            if (driverPropertyInfo[0].name.equals(PASSWORD)) {
                throw new SQLException("user specified without password");
            }
            CharSequence[] propertyNames = new String[driverPropertyInfo.length];
            for (int i = 0; i < propertyNames.length; ++i) {
                propertyNames[i] = driverPropertyInfo[i].name;
            }
            throw new SQLException("unexpected driver property info prompt returned: " + String.join((CharSequence)", ", propertyNames));
        }
        return new MongoConnection(p.left(), info.getProperty(DATABASE), info.getProperty(CONVERSION_MODE));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(MONGODB_URL_PREFIX) || url.startsWith(MONGODB_SRV_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Pair<ConnectionString, DriverPropertyInfo[]> p = this.getConnectionString(url, info);
        return p.right();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private static String removePrefix(String prefix, String s2) {
        if (s2 != null && prefix != null && s2.startsWith(prefix)) {
            return s2.substring(prefix.length());
        }
        return s2;
    }

    private Pair<ConnectionString, DriverPropertyInfo[]> getConnectionString(String url, Properties info) throws SQLException {
        ConnectionString originalConnectionString;
        if (info == null) {
            info = new Properties();
        }
        String actualURL = MongoDriver.removePrefix(JDBC, url);
        try {
            originalConnectionString = new ConnectionString(actualURL);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        String authDatabase = originalConnectionString.getDatabase();
        ParseResult result = MongoDriver.normalizeConnectionOptions(originalConnectionString, info);
        String user = result.user;
        char[] password = result.password;
        if (user == null && password == null) {
            ConnectionString c = new ConnectionString(MongoDriver.buildNewURI(originalConnectionString.getHosts(), null, null, authDatabase, result.normalizedOptions));
            Pair<ConnectionString, DriverPropertyInfo[]> pair = new Pair<ConnectionString, DriverPropertyInfo[]>(c, new DriverPropertyInfo[0]);
            return pair;
        }
        if (user == null) {
            return new Pair<Object, DriverPropertyInfo[]>(null, new DriverPropertyInfo[]{new DriverPropertyInfo(USER, null)});
        }
        if (password == null) {
            return new Pair<Object, DriverPropertyInfo[]>(null, new DriverPropertyInfo[]{new DriverPropertyInfo(PASSWORD, null)});
        }
        ConnectionString c = new ConnectionString(MongoDriver.buildNewURI(originalConnectionString.getHosts(), user, password, authDatabase, result.normalizedOptions));
        return new Pair<ConnectionString, DriverPropertyInfo[]>(c, new DriverPropertyInfo[0]);
    }

    private static ParseResult normalizeConnectionOptions(ConnectionString clientURI, Properties info) throws SQLException {
        char[] propertyPWD;
        if (info == null) {
            info = new Properties();
        }
        NullCoalesce<String> s2 = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        NullCoalesce<char[]> c = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        String uriUser = clientURI.getUsername();
        char[] uriPWD = clientURI.getPassword();
        String propertyUser = info.getProperty(USER);
        String propertyPWDStr = info.getProperty(PASSWORD);
        char[] cArray = propertyPWD = propertyPWDStr != null ? propertyPWDStr.toCharArray() : null;
        if (uriUser != null && propertyUser != null && !uriUser.equals(propertyUser)) {
            throw new SQLException("uri and properties disagree on user: '" + uriUser + ", and " + propertyUser + " respectively");
        }
        String user = s2.coalesce(uriUser, propertyUser);
        if (user != null) {
            info.setProperty(USER, user);
        }
        if (uriPWD != null && propertyPWD != null && !Arrays.equals(uriPWD, propertyPWD)) {
            throw new SQLException("uri and properties disagree on password");
        }
        char[] password = c.coalesce(uriPWD, propertyPWD);
        String optionString = null;
        String[] optionSplit = clientURI.getConnectionString().split("[?]");
        if (optionSplit.length > 1) {
            optionString = optionSplit[1];
        }
        Properties options = new Properties();
        if (optionString != null) {
            String[] optionStrs;
            for (String optionStr : optionStrs = optionString.split("&")) {
                String[] kv = optionStr.split("=");
                if (kv.length != 2) {
                    throw new SQLException("Option String is not valid");
                }
                String normalizedKey = kv[0].toLowerCase();
                if (normalizedKey.equals(USER) || normalizedKey.equals(PASSWORD)) continue;
                options.put(normalizedKey, kv[1]);
            }
        }
        for (String key : info.stringPropertyNames()) {
            String normalizedKey = key.toLowerCase();
            if (normalizedKey.equals(USER) || normalizedKey.equals(PASSWORD)) continue;
            String val = info.getProperty(key);
            if (options.containsKey(normalizedKey)) {
                if (options.getProperty(normalizedKey).equals(val)) continue;
                throw new SQLException("uri and properties disagree on %s", key);
            }
            options.setProperty(normalizedKey, val);
        }
        return new ParseResult(user, password, options);
    }

    private static String sqlURLEncode(String item) throws SQLException {
        try {
            return URLEncoder.encode(item, "utf-8");
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static String buildNewURI(List<String> hosts, String user, char[] password, String authDatabase, Properties options) throws SQLException {
        String ret = "mongodb://";
        if (user != null) {
            ret = ret + MongoDriver.sqlURLEncode(user) + ":" + MongoDriver.sqlURLEncode(String.valueOf(password)) + "@";
        }
        ret = ret + String.join((CharSequence)",", hosts);
        ret = authDatabase != null ? ret + "/" + MongoDriver.sqlURLEncode(authDatabase) : ret + "/";
        StringBuilder buff = new StringBuilder();
        if (options != null) {
            for (String key : options.stringPropertyNames()) {
                if (key.equals(USER) || key.equals(PASSWORD) || key.equals(CONVERSION_MODE) || key.equals(DATABASE)) continue;
                if (buff.length() > 0) {
                    buff.append("&");
                }
                try {
                    buff.append(key).append("=").append(URLEncoder.encode(options.getProperty(key), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e);
                }
            }
        }
        if (buff.length() > 0) {
            ret = ret + "?" + buff.toString();
        }
        return ret;
    }

    static {
        registry = CodecRegistries.fromProviders(new BsonValueCodecProvider(), new ValueCodecProvider(), PojoCodecProvider.builder().automatic(true).build());
        MongoDriver unit = new MongoDriver();
        try {
            DriverManager.registerDriver(unit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        VERSION = unit.getClass().getPackage().getImplementationVersion();
        if (VERSION != null) {
            String[] verSp = VERSION.split("[.]");
            if (verSp.length < 2) {
                throw new RuntimeException(new SQLException("version was not specified correctly, must contain at least major and minor parts"));
            }
            MAJOR_VERSION = Integer.parseInt(verSp[0]);
            MINOR_VERSION = Integer.parseInt(verSp[1]);
        } else {
            MAJOR_VERSION = 0;
            MINOR_VERSION = 0;
        }
    }

    private static interface NullCoalesce<T> {
        public T coalesce(T var1, T var2);
    }

    private static class ParseResult {
        String user;
        char[] password;
        Properties normalizedOptions;

        ParseResult(String u, char[] p, Properties options) {
            this.user = u;
            this.password = p;
            this.normalizedOptions = options;
        }
    }
}

