/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import com.mongodb.jdbc.Column;
import com.mongodb.jdbc.MongoResultDoc;
import com.mongodb.jdbc.MongoResultSetMetaData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

public class MongoResultSet
implements ResultSet {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final String ARRAY = "array";
    private final String BINARY = "binary";
    private final String BOOLEAN = "boolean";
    private final String DATE = "date";
    private final String DB_POINTER = "db_pointer";
    private final String DECIMAL128 = "decimal128";
    private final String DOCUMENT = "document";
    private final String DOUBLE = "double";
    private final String END_OF_DOCUMENT = "end_of_document";
    private final String INT32 = "int32";
    private final String INT64 = "int64";
    private final String JAVASCRIPT = "javascript";
    private final String JAVASCRIPT_WITH_CODE = "javascript_with_code";
    private final String MAX_KEY = "max_key";
    private final String MIN_KEY = "min_key";
    private final String OBJECT_ID = "objectId";
    private final String REGEX = "regex";
    private final String STRING = "string";
    private final String SYMBOL = "symbol";
    private final String TIMESTAMP = "timestamp";
    private int rowNum = 0;
    private boolean closed = false;
    private Statement statement;
    private MongoCursor<MongoResultDoc> cursor;
    private MongoResultDoc current;
    private HashMap<String, Integer> columnPositionCache;
    private boolean wasNull = false;
    private boolean relaxed = true;
    private MongoResultDoc firstDoc;
    private ResultSetMetaData rsMetaData;

    public MongoResultSet(Statement statement, MongoCursor<MongoResultDoc> cursor, boolean relaxed) {
        Preconditions.checkNotNull(cursor);
        this.statement = statement;
        this.cursor = cursor;
        this.relaxed = relaxed;
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        this.dateFormat.setTimeZone(UTC);
    }

    MongoResultDoc getCurrent() {
        return this.current;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("MongoResultSet is closed.");
        }
    }

    private void checkAndCacheFirstDocAndMetaData() {
        if (this.firstDoc != null) {
            return;
        }
        this.firstDoc = this.cursor.next();
        this.rsMetaData = new MongoResultSetMetaData(this.firstDoc);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.checkAndCacheFirstDocAndMetaData();
        if (this.rowNum == 0) {
            if (!this.firstDoc.isEmpty()) {
                ++this.rowNum;
                this.current = this.firstDoc;
                return true;
            }
            return false;
        }
        boolean result = this.cursor.hasNext();
        if (result) {
            this.current = this.cursor.next();
            ++this.rowNum;
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.cursor.close();
        this.closed = true;
        if (this.statement != null && this.statement.isCloseOnCompletion()) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    private void checkBounds(int i) throws SQLException {
        this.checkClosed();
        if (this.current == null) {
            throw new SQLException("No current row in the result set. Make sure to call next().");
        }
        if (i > this.current.columnCount()) {
            throw new SQLException("Index out of bounds: '" + i + "'.");
        }
    }

    private void checkKey(String key) throws SQLException {
        this.checkClosed();
        if (this.columnPositionCache == null) {
            this.buildColumnPositionCache();
        }
        if (!this.columnPositionCache.containsKey(key)) {
            throw new SQLException("No such column: '" + key + "'.");
        }
    }

    private void buildColumnPositionCache() throws SQLException {
        if (this.current == null) {
            throw new SQLException("No current row in the result set. Make sure to call next().");
        }
        if (this.current.values.size() == 0) {
            this.columnPositionCache = new HashMap();
            return;
        }
        this.columnPositionCache = new HashMap(this.current.columnCount());
        int i = 0;
        for (Column c : this.current.getValues()) {
            this.columnPositionCache.put(c.columnAlias, i++);
        }
    }

    private boolean checkNull(BsonValue o) {
        this.wasNull = false;
        if (o == null) {
            this.wasNull = true;
            return true;
        }
        BsonType ty = o.getBsonType();
        if (!this.relaxed) {
            switch (ty) {
                case NULL: 
                case UNDEFINED: {
                    this.wasNull = true;
                    return true;
                }
            }
            return false;
        }
        switch (ty) {
            case NULL: 
            case UNDEFINED: 
            case ARRAY: 
            case DB_POINTER: 
            case DOCUMENT: 
            case END_OF_DOCUMENT: 
            case JAVASCRIPT: 
            case JAVASCRIPT_WITH_SCOPE: 
            case MAX_KEY: 
            case MIN_KEY: 
            case REGULAR_EXPRESSION: 
            case SYMBOL: 
            case TIMESTAMP: {
                this.wasNull = true;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkBounds(columnIndex);
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    private byte[] handleBytesConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return null;
        }
        throw new SQLException("The " + from + " type cannot be converted to blob.");
    }

    private byte[] getBytes(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return null;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleBytesConversionFailure("array");
            }
            case BINARY: {
                return o.asBinary().getData();
            }
            case BOOLEAN: {
                return this.handleBytesConversionFailure("boolean");
            }
            case DATE_TIME: {
                return this.handleBytesConversionFailure("date");
            }
            case DB_POINTER: {
                return this.handleBytesConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return this.handleBytesConversionFailure("decimal128");
            }
            case DOCUMENT: {
                return this.handleBytesConversionFailure("document");
            }
            case DOUBLE: {
                return this.handleBytesConversionFailure("double");
            }
            case END_OF_DOCUMENT: {
                return this.handleBytesConversionFailure("end_of_document");
            }
            case INT32: {
                return this.handleBytesConversionFailure("int32");
            }
            case INT64: {
                return this.handleBytesConversionFailure("int64");
            }
            case JAVASCRIPT: {
                return this.handleBytesConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleBytesConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleBytesConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleBytesConversionFailure("min_key");
            }
            case NULL: {
                return null;
            }
            case OBJECT_ID: {
                return this.handleBytesConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleBytesConversionFailure("regex");
            }
            case STRING: {
                return this.handleBytesConversionFailure("string");
            }
            case SYMBOL: {
                return this.handleBytesConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleBytesConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getBytes(out);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getBytes(out);
    }

    private static ByteArrayInputStream getNewByteArrayInputStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        String encoding = "ASCII";
        try {
            return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("The JVM claims not to support the encoding: ASCII.");
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        String encoding = "ASCII";
        try {
            return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("The JVM claims not to support the encoding: ASCII.");
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        String encoding = "UTF-8";
        try {
            return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        String encoding = "UTF-8";
        try {
            return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnLabel));
    }

    private String handleStringConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return null;
        }
        throw new SQLException("The " + from + " type cannot be converted to string.");
    }

    private String getString(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return null;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleStringConversionFailure("array");
            }
            case BINARY: {
                return this.handleStringConversionFailure("binary");
            }
            case BOOLEAN: {
                return o.asBoolean().getValue() ? "true" : "false";
            }
            case DATE_TIME: {
                Date d = new Date(o.asDateTime().getValue());
                return this.dateFormat.format(d);
            }
            case DB_POINTER: {
                return this.handleStringConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return o.asDecimal128().getValue().toString();
            }
            case DOCUMENT: {
                return this.handleStringConversionFailure("document");
            }
            case DOUBLE: {
                return Double.toString(o.asDouble().getValue());
            }
            case END_OF_DOCUMENT: {
                return this.handleStringConversionFailure("end_of_document");
            }
            case INT32: {
                return Integer.toString(o.asInt32().getValue());
            }
            case INT64: {
                return Long.toString(o.asInt64().getValue());
            }
            case JAVASCRIPT: {
                return this.handleStringConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleStringConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleStringConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleStringConversionFailure("min_key");
            }
            case NULL: {
                return null;
            }
            case OBJECT_ID: {
                return o.asObjectId().getValue().toString();
            }
            case REGULAR_EXPRESSION: {
                return this.handleStringConversionFailure("regex");
            }
            case STRING: {
                return o.asString().getValue();
            }
            case SYMBOL: {
                return this.handleStringConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleStringConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getString(out);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getString(out);
    }

    private boolean handleBooleanConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return false;
        }
        throw new SQLException("The " + from + " type cannot be converted to boolean.");
    }

    private boolean getBoolean(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return false;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleBooleanConversionFailure("array");
            }
            case BINARY: {
                return this.handleBooleanConversionFailure("binary");
            }
            case BOOLEAN: {
                return o.asBoolean().getValue();
            }
            case DATE_TIME: {
                return this.handleBooleanConversionFailure("date");
            }
            case DB_POINTER: {
                return this.handleBooleanConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                Decimal128 v = o.asDecimal128().getValue();
                return v != Decimal128.POSITIVE_ZERO && v != Decimal128.NEGATIVE_ZERO;
            }
            case DOCUMENT: {
                return this.handleBooleanConversionFailure("document");
            }
            case DOUBLE: {
                return o.asDouble().getValue() != 0.0;
            }
            case END_OF_DOCUMENT: {
                return this.handleBooleanConversionFailure("end_of_document");
            }
            case INT32: {
                return o.asInt32().getValue() != 0;
            }
            case INT64: {
                return o.asInt64().getValue() != 0L;
            }
            case JAVASCRIPT: {
                return this.handleBooleanConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleBooleanConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleBooleanConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleBooleanConversionFailure("min_key");
            }
            case NULL: {
                return false;
            }
            case OBJECT_ID: {
                return this.handleBooleanConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleBooleanConversionFailure("regex");
            }
            case STRING: {
                return true;
            }
            case SYMBOL: {
                return this.handleBooleanConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleBooleanConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return false;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getBoolean(out);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getBoolean(out);
    }

    private byte getByte(BsonValue o) throws SQLException {
        return (byte)this.getLong(o);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getByte(out);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getByte(out);
    }

    private short getShort(BsonValue o) throws SQLException {
        return (short)this.getLong(o);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getShort(out);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getShort(out);
    }

    private int getInt(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return 0;
        }
        return (int)this.getLong(o);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getInt(out);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getInt(out);
    }

    private long handleLongConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return 0L;
        }
        throw new SQLException("The " + from + " type cannot be converted to integral type.");
    }

    private long getLong(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return 0L;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleLongConversionFailure("array");
            }
            case BINARY: {
                return this.handleLongConversionFailure("binary");
            }
            case BOOLEAN: {
                return o.asBoolean().getValue() ? 1L : 0L;
            }
            case DATE_TIME: {
                return o.asDateTime().getValue();
            }
            case DB_POINTER: {
                return this.handleLongConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return o.asDecimal128().longValue();
            }
            case DOCUMENT: {
                return this.handleLongConversionFailure("document");
            }
            case DOUBLE: {
                return (long)o.asDouble().getValue();
            }
            case END_OF_DOCUMENT: {
                return this.handleLongConversionFailure("end_of_document");
            }
            case INT32: {
                return o.asInt32().getValue();
            }
            case INT64: {
                return o.asInt64().getValue();
            }
            case JAVASCRIPT: {
                return this.handleLongConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleLongConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleLongConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleLongConversionFailure("min_key");
            }
            case NULL: {
                return 0L;
            }
            case OBJECT_ID: {
                return this.handleLongConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleLongConversionFailure("regex");
            }
            case STRING: {
                try {
                    return Long.parseLong(o.asString().getValue());
                }
                catch (NumberFormatException e) {
                    if (this.relaxed) {
                        return 0L;
                    }
                    throw new SQLException(e);
                }
            }
            case SYMBOL: {
                return this.handleLongConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleLongConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return 0L;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getLong(out);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getLong(out);
    }

    private float getFloat(BsonValue o) throws SQLException {
        return (float)this.getDouble(o);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getFloat(out);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getFloat(out);
    }

    private double handleDoubleConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return 0.0;
        }
        throw new SQLException("The " + from + " type cannot be converted to double.");
    }

    private double getDouble(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return 0.0;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleDoubleConversionFailure("array");
            }
            case BINARY: {
                return this.handleDoubleConversionFailure("binary");
            }
            case BOOLEAN: {
                return o.asBoolean().getValue() ? 1.0 : 0.0;
            }
            case DATE_TIME: {
                return o.asDateTime().getValue();
            }
            case DB_POINTER: {
                return this.handleDoubleConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return o.asDecimal128().doubleValue();
            }
            case DOCUMENT: {
                return this.handleDoubleConversionFailure("document");
            }
            case DOUBLE: {
                return o.asDouble().getValue();
            }
            case END_OF_DOCUMENT: {
                return this.handleDoubleConversionFailure("end_of_document");
            }
            case INT32: {
                return o.asInt32().getValue();
            }
            case INT64: {
                return o.asInt64().getValue();
            }
            case JAVASCRIPT: {
                return this.handleDoubleConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleDoubleConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleDoubleConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleDoubleConversionFailure("min_key");
            }
            case NULL: {
                return 0.0;
            }
            case OBJECT_ID: {
                return this.handleDoubleConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleDoubleConversionFailure("regex");
            }
            case STRING: {
                try {
                    return Double.parseDouble(o.asString().getValue());
                }
                catch (NumberFormatException e) {
                    if (this.relaxed) {
                        return 0.0;
                    }
                    throw new SQLException(e);
                }
            }
            case SYMBOL: {
                return this.handleDoubleConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleDoubleConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return 0.0;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getDouble(out);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getDouble(out);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkKey(columnLabel);
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        this.checkAndCacheFirstDocAndMetaData();
        if (this.current != null) {
            this.rsMetaData = new MongoResultSetMetaData(this.current);
        }
        return this.rsMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        return this.columnPositionCache.get(columnLabel) + 1;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    private BigDecimal handleBigDecimalConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return BigDecimal.ZERO;
        }
        throw new SQLException("The " + from + " type cannot be converted to BigDecimal.");
    }

    private BigDecimal getBigDecimal(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return BigDecimal.ZERO;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleBigDecimalConversionFailure("array");
            }
            case BINARY: {
                return this.handleBigDecimalConversionFailure("binary");
            }
            case BOOLEAN: {
                return o.asBoolean().getValue() ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case DATE_TIME: {
                return new BigDecimal(o.asDateTime().getValue());
            }
            case DB_POINTER: {
                return this.handleBigDecimalConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return o.asDecimal128().decimal128Value().bigDecimalValue();
            }
            case DOCUMENT: {
                return this.handleBigDecimalConversionFailure("document");
            }
            case DOUBLE: {
                return new BigDecimal(o.asDouble().getValue());
            }
            case END_OF_DOCUMENT: {
                return this.handleBigDecimalConversionFailure("end_of_document");
            }
            case INT32: {
                return new BigDecimal(o.asInt32().getValue());
            }
            case INT64: {
                return new BigDecimal(o.asInt64().getValue());
            }
            case JAVASCRIPT: {
                return this.handleBigDecimalConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleBigDecimalConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleBigDecimalConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleBigDecimalConversionFailure("min_key");
            }
            case NULL: {
                return BigDecimal.ZERO;
            }
            case OBJECT_ID: {
                return this.handleBigDecimalConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleBigDecimalConversionFailure("regex");
            }
            case STRING: {
                try {
                    return new BigDecimal(o.asString().getValue());
                }
                catch (ArithmeticException | NumberFormatException e) {
                    if (this.relaxed) {
                        return BigDecimal.ZERO;
                    }
                    throw new SQLException(e);
                }
            }
            case SYMBOL: {
                return this.handleBigDecimalConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleBigDecimalConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return BigDecimal.ZERO;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getBigDecimal(out);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getBigDecimal(out);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.rowNum == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        this.checkAndCacheFirstDocAndMetaData();
        if (this.rowNum == 0) {
            return this.firstDoc.isEmpty();
        }
        return !this.cursor.hasNext();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.rowNum;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    private Blob getNewBlob(byte[] bytes) throws SQLException {
        if (bytes == null) {
            return null;
        }
        try {
            return new SerialBlob(bytes);
        }
        catch (SerialException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getNewBlob(this.getBytes(out));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getNewBlob(this.getBytes(out));
    }

    private Clob getClob(BsonValue o) throws SQLException {
        return new SerialClob(this.getString(o).toCharArray());
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getClob(out);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getClob(out);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    private java.util.Date handleUtilDateConversionFailure(String from) throws SQLException {
        if (this.relaxed) {
            return null;
        }
        throw new SQLException("The " + from + " type cannot be converted to java.util.Date");
    }

    private java.util.Date getUtilDate(BsonValue o) throws SQLException {
        if (this.checkNull(o)) {
            return null;
        }
        switch (o.getBsonType()) {
            case ARRAY: {
                return this.handleUtilDateConversionFailure("array");
            }
            case BINARY: {
                return this.handleUtilDateConversionFailure("binary");
            }
            case BOOLEAN: {
                return this.handleUtilDateConversionFailure("boolean");
            }
            case DATE_TIME: {
                return new java.util.Date(o.asDateTime().getValue());
            }
            case DB_POINTER: {
                return this.handleUtilDateConversionFailure("db_pointer");
            }
            case DECIMAL128: {
                return new Date(o.asDecimal128().longValue());
            }
            case DOCUMENT: {
                return this.handleUtilDateConversionFailure("document");
            }
            case DOUBLE: {
                return new Date((long)o.asDouble().getValue());
            }
            case END_OF_DOCUMENT: {
                return this.handleUtilDateConversionFailure("end_of_document");
            }
            case INT32: {
                return new Date(o.asInt32().getValue());
            }
            case INT64: {
                return new Date(o.asInt64().getValue());
            }
            case JAVASCRIPT: {
                return this.handleUtilDateConversionFailure("javascript");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.handleUtilDateConversionFailure("javascript_with_code");
            }
            case MAX_KEY: {
                return this.handleUtilDateConversionFailure("max_key");
            }
            case MIN_KEY: {
                return this.handleUtilDateConversionFailure("min_key");
            }
            case NULL: {
                return null;
            }
            case OBJECT_ID: {
                return this.handleUtilDateConversionFailure("objectId");
            }
            case REGULAR_EXPRESSION: {
                return this.handleUtilDateConversionFailure("regex");
            }
            case STRING: {
                try {
                    return this.dateFormat.parse(o.asString().getValue());
                }
                catch (ParseException e) {
                    if (this.relaxed) {
                        return null;
                    }
                    throw new SQLException(e);
                }
            }
            case SYMBOL: {
                return this.handleUtilDateConversionFailure("symbol");
            }
            case TIMESTAMP: {
                return this.handleUtilDateConversionFailure("timestamp");
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
    }

    private Date getDate(BsonValue o) throws SQLException {
        java.util.Date utilDate = this.getUtilDate(o);
        return utilDate == null ? null : new Date(utilDate.getTime());
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getDate(out);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getDate(out);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(columnIndex);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        Date d = this.getDate(columnLabel);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    private Time getTime(BsonValue o) throws SQLException {
        java.util.Date utilDate = this.getUtilDate(o);
        return utilDate == null ? null : new Time(utilDate.getTime());
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getTime(out);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getTime(out);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time d = this.getTime(columnIndex);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Time(cal.getTime().getTime());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Time d = this.getTime(columnLabel);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Time(cal.getTime().getTime());
    }

    private Timestamp getTimestamp(BsonValue o) throws SQLException {
        java.util.Date utilDate = this.getUtilDate(o);
        return utilDate == null ? null : new Timestamp(utilDate.getTime());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkKey(columnLabel);
        BsonValue out = this.current.getValues().get((int)this.columnPositionCache.get((Object)columnLabel).intValue()).value;
        return this.getTimestamp(out);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkBounds(columnIndex);
        BsonValue out = this.current.getValues().get((int)(columnIndex - 1)).value;
        return this.getTimestamp(out);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp d = this.getTimestamp(columnIndex);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Timestamp(cal.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Timestamp d = this.getTimestamp(columnLabel);
        if (d == null) {
            return null;
        }
        cal.setTime(d);
        return new Timestamp(cal.getTime().getTime());
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.getString(columnIndex));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return new StringReader(this.getString(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }
}

