/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.MongoResultDoc;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.bson.BsonType;
import org.bson.BsonValue;

public class MongoResultSetMetaData
implements ResultSetMetaData {
    private MongoResultDoc mongoResultDoc;
    private final int unknownLength = 0;

    public MongoResultSetMetaData(MongoResultDoc mongoResultDoc) {
        this.mongoResultDoc = mongoResultDoc;
    }

    private void checkBounds(int i) throws SQLException {
        if (i > this.mongoResultDoc.columnCount()) {
            throw new SQLException("Index out of bounds: '" + i + "'.");
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.mongoResultDoc.columnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkBounds(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: 
            case BINARY: 
            case BOOLEAN: 
            case DATE_TIME: 
            case DB_POINTER: 
            case DECIMAL128: 
            case DOCUMENT: 
            case DOUBLE: 
            case INT32: 
            case INT64: 
            case MAX_KEY: 
            case MIN_KEY: 
            case NULL: 
            case OBJECT_ID: 
            case TIMESTAMP: 
            case UNDEFINED: {
                return false;
            }
            case JAVASCRIPT: 
            case JAVASCRIPT_WITH_SCOPE: 
            case REGULAR_EXPRESSION: 
            case STRING: 
            case SYMBOL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkBounds(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkBounds(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkBounds(column);
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case DECIMAL128: 
            case DOUBLE: 
            case INT32: 
            case INT64: {
                return true;
            }
            case ARRAY: 
            case BINARY: 
            case BOOLEAN: 
            case DATE_TIME: 
            case DB_POINTER: 
            case DOCUMENT: 
            case MAX_KEY: 
            case MIN_KEY: 
            case NULL: 
            case OBJECT_ID: 
            case TIMESTAMP: 
            case UNDEFINED: 
            case JAVASCRIPT: 
            case JAVASCRIPT_WITH_SCOPE: 
            case REGULAR_EXPRESSION: 
            case STRING: 
            case SYMBOL: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: {
                return 0;
            }
            case BINARY: {
                return 0;
            }
            case BOOLEAN: {
                return 1;
            }
            case DATE_TIME: {
                return 24;
            }
            case DB_POINTER: {
                return 0;
            }
            case DECIMAL128: {
                return 34;
            }
            case DOCUMENT: {
                return 0;
            }
            case DOUBLE: {
                return 15;
            }
            case INT32: {
                return 10;
            }
            case INT64: {
                return 19;
            }
            case JAVASCRIPT: {
                return 0;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return 0;
            }
            case MAX_KEY: {
                return 0;
            }
            case MIN_KEY: {
                return 0;
            }
            case NULL: {
                return 0;
            }
            case OBJECT_ID: {
                return 24;
            }
            case REGULAR_EXPRESSION: {
                return 0;
            }
            case STRING: {
                return 0;
            }
            case SYMBOL: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
            case UNDEFINED: {
                return 0;
            }
        }
        throw new SQLException("unknown bson type: " + (Object)((Object)t));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkBounds(column);
        return this.mongoResultDoc.values.get((int)(column - 1)).columnAlias;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkBounds(column);
        return this.mongoResultDoc.values.get((int)(column - 1)).column;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkBounds(column);
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: {
                return 0;
            }
            case BINARY: {
                return 0;
            }
            case BOOLEAN: {
                return 1;
            }
            case DATE_TIME: {
                return 24;
            }
            case DB_POINTER: {
                return 0;
            }
            case DECIMAL128: {
                return 34;
            }
            case DOCUMENT: {
                return 0;
            }
            case DOUBLE: {
                return 15;
            }
            case INT32: {
                return 10;
            }
            case INT64: {
                return 19;
            }
            case JAVASCRIPT: {
                return 0;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return 0;
            }
            case MAX_KEY: {
                return 0;
            }
            case MIN_KEY: {
                return 0;
            }
            case NULL: {
                return 0;
            }
            case OBJECT_ID: {
                return 24;
            }
            case REGULAR_EXPRESSION: {
                return 0;
            }
            case STRING: {
                return 0;
            }
            case SYMBOL: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
            case UNDEFINED: {
                return 0;
            }
        }
        throw new SQLException("unknown bson type: " + (Object)((Object)t));
    }

    @Override
    public int getScale(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: 
            case BINARY: 
            case BOOLEAN: 
            case DATE_TIME: 
            case DB_POINTER: 
            case DOCUMENT: 
            case INT32: 
            case INT64: 
            case MAX_KEY: 
            case MIN_KEY: 
            case NULL: 
            case OBJECT_ID: 
            case TIMESTAMP: 
            case UNDEFINED: 
            case JAVASCRIPT: 
            case JAVASCRIPT_WITH_SCOPE: 
            case REGULAR_EXPRESSION: 
            case STRING: 
            case SYMBOL: {
                return 0;
            }
            case DECIMAL128: {
                return 34;
            }
            case DOUBLE: {
                return 15;
            }
        }
        throw new SQLException("unknown bson type: " + (Object)((Object)t));
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkBounds(column);
        return this.mongoResultDoc.values.get((int)column).tableAlias;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkBounds(column);
        return this.mongoResultDoc.values.get((int)(column - 1)).database;
    }

    public BsonType getBsonType(int column) throws SQLException {
        this.checkBounds(column);
        String typeName = this.mongoResultDoc.values.get((int)(column - 1)).bsonType;
        return MongoResultSetMetaData.getBsonTypeHelper(typeName);
    }

    static BsonType getBsonTypeHelper(String typeName) throws SQLException {
        switch (typeName.charAt(0)) {
            case 'a': {
                return BsonType.ARRAY;
            }
            case 'b': {
                switch (typeName.length()) {
                    case 4: {
                        return BsonType.BOOLEAN;
                    }
                    case 7: {
                        return BsonType.BINARY;
                    }
                }
                break;
            }
            case 'd': {
                switch (typeName.length()) {
                    case 4: {
                        return BsonType.DATE_TIME;
                    }
                    case 6: {
                        return BsonType.DOUBLE;
                    }
                    case 7: {
                        return BsonType.DECIMAL128;
                    }
                    case 9: {
                        return BsonType.DB_POINTER;
                    }
                }
                break;
            }
            case 'i': {
                return BsonType.INT32;
            }
            case 'j': {
                switch (typeName.length()) {
                    case 10: {
                        return BsonType.JAVASCRIPT;
                    }
                    case 19: {
                        return BsonType.JAVASCRIPT_WITH_SCOPE;
                    }
                }
                break;
            }
            case 'l': {
                return BsonType.INT64;
            }
            case 'm': {
                switch (typeName.charAt(1)) {
                    case 'a': {
                        return BsonType.MAX_KEY;
                    }
                    case 'i': {
                        return BsonType.MIN_KEY;
                    }
                }
                break;
            }
            case 'n': {
                return BsonType.NULL;
            }
            case 'o': {
                switch (typeName.length()) {
                    case 6: {
                        return BsonType.DOCUMENT;
                    }
                    case 8: {
                        return BsonType.OBJECT_ID;
                    }
                }
                break;
            }
            case 'r': {
                return BsonType.REGULAR_EXPRESSION;
            }
            case 's': {
                switch (typeName.charAt(1)) {
                    case 't': {
                        return BsonType.STRING;
                    }
                    case 'y': {
                        return BsonType.SYMBOL;
                    }
                }
                break;
            }
            case 't': {
                return BsonType.TIMESTAMP;
            }
            case 'u': {
                return BsonType.UNDEFINED;
            }
        }
        throw new SQLException("Unknown bson type name: \"" + typeName + "\"");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: {
                return 2003;
            }
            case BINARY: {
                return 2004;
            }
            case BOOLEAN: {
                return -7;
            }
            case DATE_TIME: {
                return 93;
            }
            case DB_POINTER: {
                return 0;
            }
            case DECIMAL128: {
                return 3;
            }
            case DOCUMENT: {
                return 0;
            }
            case DOUBLE: {
                return 8;
            }
            case INT32: {
                return 4;
            }
            case INT64: {
                return 4;
            }
            case JAVASCRIPT: {
                return 0;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return 0;
            }
            case MAX_KEY: {
                return 0;
            }
            case MIN_KEY: {
                return 0;
            }
            case NULL: {
                return 0;
            }
            case OBJECT_ID: {
                return -1;
            }
            case REGULAR_EXPRESSION: {
                return 0;
            }
            case STRING: {
                return -1;
            }
            case SYMBOL: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
            case UNDEFINED: {
                return 0;
            }
        }
        throw new SQLException("unknown bson type: " + (Object)((Object)t));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        BsonType t = this.getBsonType(column);
        switch (t) {
            case ARRAY: {
                return "array";
            }
            case BINARY: {
                return "binData";
            }
            case BOOLEAN: {
                return "bool";
            }
            case DATE_TIME: {
                return "date";
            }
            case DB_POINTER: {
                return "null";
            }
            case DECIMAL128: {
                return "decimal";
            }
            case DOCUMENT: {
                return "null";
            }
            case DOUBLE: {
                return "double";
            }
            case END_OF_DOCUMENT: {
                return "null";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "long";
            }
            case JAVASCRIPT: {
                return "null";
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return "null";
            }
            case MAX_KEY: {
                return "null";
            }
            case MIN_KEY: {
                return "null";
            }
            case NULL: {
                return "null";
            }
            case OBJECT_ID: {
                return "string";
            }
            case REGULAR_EXPRESSION: {
                return "null";
            }
            case STRING: {
                return "string";
            }
            case SYMBOL: {
                return "null";
            }
            case TIMESTAMP: {
                return "null";
            }
            case UNDEFINED: {
                return "null";
            }
        }
        throw new SQLException("unknown bson type: " + (Object)((Object)t));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkBounds(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkBounds(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkBounds(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkBounds(column);
        BsonValue o = this.mongoResultDoc.values.get((int)(column - 1)).value;
        return o.getClass().getName();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }
}

