/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.jdbc.BsonExplicitCursor;
import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoFunctions;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoJsonSchemaResult;
import com.mongodb.jdbc.MongoListTablesResult;
import com.mongodb.jdbc.MongoResultSet;
import com.mongodb.jdbc.MongoRunCmdListTablesResult;
import com.mongodb.jdbc.Pair;
import com.mongodb.jdbc.SortableBsonDocument;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoDatabaseMetaData
implements DatabaseMetaData,
LoggingAspect$ajcMightHaveAspect {
    private static final BsonInt32 BSON_ZERO_INT_VALUE;
    private static final BsonInt32 BSON_TYPE_SEARCHABLE_INT_VALUE;
    private static final BsonInt32 BSON_OTHER_INT_VALUE;
    private static final BsonInt32 BSON_COLUMN_NULLABLE_INT_VALUE;
    private static final BsonString BSON_EMPTY_STR_VALUE;
    private static final BsonString BSON_YES_STR_VALUE;
    private static final BsonString BSON_NO_STR_VALUE;
    private static final String BOT_NAME = "";
    private static final String INDEX_KEY_KEY = "key";
    private static final String INDEX_NAME_KEY = "name";
    private static final List<String> UNIQUE_KEY_PATH;
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private static final String REMARKS = "REMARKS";
    private static final String SPECIFIC_NAME = "SPECIFIC_NAME";
    private static final String FUNCTION_CAT = "FUNCTION_CAT";
    private static final String FUNCTION_SCHEM = "FUNCTION_SCHEM";
    private static final String FUNCTION_NAME = "FUNCTION_NAME";
    private static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    private static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String CREATE_PARAMS = "CREATE_PARAMS";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    private static final String FIX_PREC_SCALE = "FIX_PREC_SCALE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String LENGTH = "LENGTH";
    private static final String LITERAL_PREFIX = "LITERAL_PREFIX";
    private static final String LITERAL_SUFFIX = "LITERAL_SUFFIX";
    private static final String LOCAL_TYPE_NAME = "LOCAL_TYPE_NAME";
    private static final String MAXIMUM_SCALE = "MAXIMUM_SCALE";
    private static final String MAX_LEN = "MAX_LEN";
    private static final String MINIMUM_SCALE = "MINIMUM_SCALE";
    private static final String NAME = "NAME";
    private static final String NULLABLE = "NULLABLE";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String PRECISION = "PRECISION";
    private static final String RADIX = "RADIX";
    private static final String SCALE = "SCALE";
    private static final String SEARCHABLE = "SEARCHABLE";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String UNSIGNED_ATTRIBUTE = "UNSIGNED_ATTRIBUTE";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_CATALOG = "TABLE_CATALOG";
    private static final String SCOPE = "SCOPE";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String PKTABLE_CAT = "PKTABLE_CAT";
    private static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String FKTABLE_CAT = "FKTABLE_CAT";
    private static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String UPDATE_RULE = "UPDATE_RULE";
    private static final String DELETE_RULE = "DELETE_RULE";
    private static final String FK_NAME = "FK_NAME";
    private static final String PK_NAME = "PK_NAME";
    private static final String DEFERRABILITY = "DEFERRABILITY";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String ATTR_NAME = "ATTR_NAME";
    private static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String ATTR_SIZE = "ATTR_SIZE";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String ATTR_DEF = "ATTR_DEF";
    private static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String COLUMN_USAGE = "COLUMN_USAGE";
    private static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    private static final String IS_GENERATEDCOLUMN = "IS_GENERATEDCOLUMN";
    private static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    private static final String REF_GENERATION = "REF_GENERATION";
    private static final String GRANTOR = "GRANTOR";
    private static final String GRANTEE = "GRANTEE";
    private static final String PRIVILEGE = "PRIVILEGE";
    private static final String IS_GRANTABLE = "IS_GRANTABLE";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String TYPE = "TYPE";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String PAGES = "PAGES";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final int APPROXIMATE_DOC_SIZE = 0xFFFF28;
    private static final String FUNC_DEFAULT_CATALOG = "def";
    private static final String YES = "YES";
    private static final List<SortableBsonDocument.SortSpec> GET_TABLES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_TABLE_PRIVILEGES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_COLUMNS_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_COLUMN_PRIVILEGES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_PRIMARY_KEYS_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_INDEX_INFO_SORT_SPECS;
    private static final MongoFunctions MongoFunctions;
    private final MongoConnection conn;
    private String serverVersion;
    private MongoLogger logger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_105;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_106;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_107;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_108;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_109;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_110;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_111;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_112;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_113;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_114;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_115;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_116;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_117;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_118;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_119;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_120;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_121;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_122;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_123;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_124;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_125;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_126;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_127;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_128;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_129;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_130;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_131;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_132;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_133;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_134;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_135;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_136;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_137;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_138;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_139;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_140;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_141;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_142;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_143;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_144;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_145;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_146;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_147;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_148;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_149;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_150;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_151;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_152;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_153;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_154;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_155;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_156;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_157;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_158;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_159;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_160;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_161;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_162;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_163;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_164;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_165;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_166;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_167;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_168;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_169;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_170;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_171;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_172;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_173;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_174;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_175;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_176;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_177;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_178;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_179;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_180;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_181;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_182;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_183;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_184;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_185;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_186;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_187;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_188;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_189;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_190;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_191;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_192;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_193;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_194;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_195;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_196;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_197;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_198;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_199;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_200;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_201;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_202;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_203;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_204;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_205;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_206;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_207;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_208;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_209;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_210;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_211;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_212;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_213;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_214;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_215;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_216;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_217;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_218;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_219;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_220;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_221;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_222;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_223;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoDatabaseMetaData.ajc$preClinit();
        BSON_ZERO_INT_VALUE = new BsonInt32(0);
        BSON_TYPE_SEARCHABLE_INT_VALUE = new BsonInt32(3);
        BSON_OTHER_INT_VALUE = new BsonInt32(1111);
        BSON_COLUMN_NULLABLE_INT_VALUE = new BsonInt32(1);
        BSON_EMPTY_STR_VALUE = new BsonString(BOT_NAME);
        BSON_YES_STR_VALUE = new BsonString(YES);
        BSON_NO_STR_VALUE = new BsonString("NO");
        UNIQUE_KEY_PATH = Arrays.asList("options", "unique");
        GET_TABLES_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec(TABLE_TYPE, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(TABLE_CAT, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(TABLE_NAME, SortableBsonDocument.ValueType.String));
        GET_TABLE_PRIVILEGES_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec(TABLE_CAT, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(TABLE_NAME, SortableBsonDocument.ValueType.String));
        GET_COLUMNS_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec(TABLE_CAT, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(TABLE_NAME, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(ORDINAL_POSITION, SortableBsonDocument.ValueType.Int));
        GET_COLUMN_PRIVILEGES_SORT_SPECS = Collections.singletonList(new SortableBsonDocument.SortSpec(COLUMN_NAME, SortableBsonDocument.ValueType.String));
        GET_PRIMARY_KEYS_SORT_SPECS = Collections.singletonList(new SortableBsonDocument.SortSpec(COLUMN_NAME, SortableBsonDocument.ValueType.String));
        GET_INDEX_INFO_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec(NON_UNIQUE, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(INDEX_NAME, SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec(ORDINAL_POSITION, SortableBsonDocument.ValueType.Int));
        MongoFunctions = com.mongodb.jdbc.MongoFunctions.getInstance();
    }

    public MongoDatabaseMetaData(MongoConnection conn) {
        LoggingAspect.ajc$perObjectBind(this);
        this.conn = conn;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), conn.getLogger());
        MongoDatabaseMetaData mongoDatabaseMetaData = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoDatabaseMetaData.logger_aroundBody1$advice(this, mongoDatabaseMetaData, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoDatabaseMetaData.logger = mongoLogger;
        }
    }

    private BsonDocument createBottomBson(BsonElement ... elements) {
        try {
            BsonDocument bot = new BsonDocument(Arrays.asList(elements));
            return new BsonDocument(BOT_NAME, bot);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private SortableBsonDocument createSortableBottomBson(List<SortableBsonDocument.SortSpec> sortSpecs, BsonElement ... elements) {
        try {
            BsonDocument bot = new BsonDocument(Arrays.asList(elements));
            return new SortableBsonDocument(sortSpecs, BOT_NAME, bot);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private final MongoJsonSchema createBottomSchema(MongoJsonSchema.ScalarProperties ... resultSchemaFields) {
        try {
            MongoJsonSchema resultSchema = MongoJsonSchema.createEmptyObjectSchema();
            resultSchema.addScalarKeys(resultSchemaFields);
            MongoJsonSchema bot = MongoJsonSchema.createEmptyObjectSchema();
            bot.required.add(BOT_NAME);
            bot.properties.put(BOT_NAME, resultSchema);
            return bot;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private BsonValue asBsonIntOrNull(Integer i) {
        try {
            return this.asBsonIntOrDefault(i, null);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    private BsonValue asBsonIntOrDefault(Integer i, Integer defaultVal) {
        try {
            if (i == null) {
                return defaultVal == null ? new BsonNull() : new BsonInt32(defaultVal);
            }
            return new BsonInt32(i);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_5, this, this));
            }
            return "AGGREGATE,ASC,BINDATA,BIT,BOOL,BSON_DATE,BSON_TIMESTAMP,DBPOINTER,DESC,DOCUMENT,ERROR,EXTRACT,FIRST,JAVASCRIPT,JAVASCRIPTWITHSCOPE,LIMIT,LONG,MAXKEY,MINKEY,MISSING,NEXT,NUMBER,OBJECTID,OFFSET,POSITION,REGEX,SUBSTRING,SYMBOL,TRIM,UNDEFINED";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, this, this));
            }
            return MongoDatabaseMetaData.MongoFunctions.numericFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, this, this));
            }
            return MongoDatabaseMetaData.MongoFunctions.stringFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, this, this));
            }
            return MongoDatabaseMetaData.MongoFunctions.systemFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, this, this));
            }
            return MongoDatabaseMetaData.MongoFunctions.dateFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = procedureNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(PROCEDURE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PROCEDURE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PROCEDURE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PROCEDURE_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SPECIFIC_NAME, BsonTypeInfo.BSON_STRING));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = procedureNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(PROCEDURE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PROCEDURE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PROCEDURE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PRECISION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SCALE, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(RADIX, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(NULLABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_DEF, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SQL_DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SQL_DATETIME_SUB, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(CHAR_OCTET_LENGTH, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(ORDINAL_POSITION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(IS_NULLABLE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SPECIFIC_NAME, BsonTypeInfo.BSON_STRING));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_12, this, this));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties(TABLE_TYPE, BsonTypeInfo.BSON_STRING));
            docs.add(this.createBottomBson(new BsonElement(TABLE_TYPE, new BsonString("TABLE"))));
            docs.add(this.createBottomBson(new BsonElement(TABLE_TYPE, new BsonString("VIEW"))));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoResultSet(this.conn.getLogger(), new BsonExplicitCursor(docs), botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    static boolean filterEmptiesAndAdmin(String dbName) {
        return !dbName.isEmpty() && !dbName.equals("admin");
    }

    private Stream<String> getDatabaseNames() {
        try {
            return this.conn.mongoClient.listDatabaseNames().into(new ArrayList()).stream().filter(dbName -> MongoDatabaseMetaData.filterEmptiesAndAdmin(dbName));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    private ArrayList<MongoListTablesResult> getCollectionsFromRunCommand(MongoDatabase db) {
        try {
            MongoRunCmdListTablesResult mongoRunCmdListTablesResult = db.runCommand((Bson)new Document("listCollections", 1).append("authorizedCollections", true).append("nameOnly", true), MongoRunCmdListTablesResult.class);
            return mongoRunCmdListTablesResult.getCursor().getFirstBatch();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    private Stream<MongoListTablesResult> getTableDataFromDB(String dbName, Function<MongoListTablesResult, Boolean> filter) {
        try {
            MongoDatabase db = this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry);
            return this.getCollectionsFromRunCommand(db).stream().filter(filter::apply);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    private BsonDocument toGetTablesDoc(String dbName, MongoListTablesResult res) {
        try {
            return this.createSortableBottomBson(GET_TABLES_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString(dbName)), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString(res.name)), new BsonElement(TABLE_TYPE, new BsonString(res.type)), new BsonElement(REMARKS, BsonNull.VALUE), new BsonElement(TYPE_CAT, BsonNull.VALUE), new BsonElement(TYPE_SCHEM, BsonNull.VALUE), new BsonElement(TYPE_NAME, BsonNull.VALUE), new BsonElement(SELF_REFERENCING_COL_NAME, BsonNull.VALUE), new BsonElement(REF_GENERATION, BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    private BsonDocument toGetTablePrivilegesDoc(String dbName, MongoListTablesResult res) {
        try {
            return this.createSortableBottomBson(GET_TABLE_PRIVILEGES_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString(dbName)), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString(res.name)), new BsonElement(GRANTOR, BsonNull.VALUE), new BsonElement(GRANTEE, BSON_EMPTY_STR_VALUE), new BsonElement(PRIVILEGE, new BsonString("SELECT")), new BsonElement(IS_GRANTABLE, BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getTableDataFromDB(String dbName, Pattern tableNamePatternRE, List<String> types, BiFunction<String, MongoListTablesResult, BsonDocument> bsonSerializer) {
        try {
            return this.getTableDataFromDB(dbName, res -> !(tableNamePatternRE != null && !tableNamePatternRE.matcher(res.name).matches() || types != null && !types.contains(res.type.toLowerCase()))).map(res -> (BsonDocument)bsonSerializer.apply(dbName, (MongoListTablesResult)res));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    private List<String> toTableTypeList(String[] types) {
        try {
            List<String> l = null;
            if (types != null) {
                l = Arrays.asList(types);
                l.replaceAll(String::toLowerCase);
            }
            return l;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    public static Pattern toJavaPattern(String sqlPattern) {
        return sqlPattern == null ? null : Pattern.compile(sqlPattern.replaceAll("([.^$*+?(){}|\\[\\]\\\\])", "\\\\$1").replaceAll("(?<!\\\\)%", ".*").replaceAll("(?<!\\\\)_", "."));
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_20, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_21, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_22, this, this));
            }
            return this.conn.getURL();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_23, this, this));
            }
            return this.conn.getUser();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_24, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_25, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_26, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_27, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_28, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_29, this, this));
            }
            return "MongoDB Atlas";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_30, this, this));
            }
            if (this.serverVersion != null) {
                return this.serverVersion;
            }
            this.serverVersion = this.conn.getServerVersion();
            return this.serverVersion;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_31, this, this));
            }
            return "MongoDB Atlas SQL interface JDBC Driver";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_32, this, this));
            }
            return MongoDriver.VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_33, this, this));
            }
            return MongoDriver.MAJOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_34, this, this));
            }
            return MongoDriver.MINOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_35, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_36, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_37, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_38, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_39, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_40, this, this));
            }
            return this.supportsMixedCaseIdentifiers();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_41, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_42, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_43, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_44, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_45, this, this));
            }
            return "`";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_46, this, this));
            }
            return "\\";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_47, this, this));
            }
            return BOT_NAME;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_48, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_49, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_50, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_51, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_52, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        int n = fromType;
        int n2 = toType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_53, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            switch (toType) {
                case 2003: {
                    return false;
                }
                case -7: 
                case -2: 
                case -1: 
                case 0: 
                case 3: 
                case 4: 
                case 8: 
                case 93: 
                case 2004: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_54, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_55, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_56, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_57, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_58, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_59, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_60, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_61, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_62, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_63, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_64, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_65, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_66, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_67, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_68, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_69, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_70, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_71, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_72, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_73, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_74, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
            }
            throw exception;
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_75, this, this));
            }
            return "schema";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_75);
            }
            throw exception;
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_76, this, this));
            }
            return "procedure";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_76);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_77, this, this));
            }
            return "database";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_77);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_78, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_78);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_79, this, this));
            }
            return ".";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_79);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_80, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_80);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_81, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_81);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_82, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_82);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_83, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_83);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_84, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_84);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_85, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_85);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_86, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_86);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_87, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_87);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_88, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_88);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_89, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_89);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_90, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_90);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_91, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_91);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_92, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_92);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_93, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_93);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_94, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_94);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_95, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_95);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_96, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_96);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_97, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_97);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_98, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_98);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_99, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_99);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_100, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_100);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_101, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_101);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_102, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_102);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_103, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_103);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_104, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_104);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_105, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_105);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_106, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_106);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_107, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_107);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_108, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_108);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_109, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_109);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_110, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_110);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_111, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_111);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_112, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_112);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_113, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_113);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_114, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_114);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_115, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_115);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_116, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_116);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_117, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_117);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_118, this, this));
            }
            return 255;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_118);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_119, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_119);
            }
            throw exception;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_120, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_120);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_121, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_121);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_122, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_122);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_123, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_123);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_124, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_124);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_125, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_125);
            }
            throw exception;
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_126, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_126);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_127, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_127);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        int n = level;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_128, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return level == 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_128);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_129, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_129);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_130, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_130);
            }
            throw exception;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_131, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_131);
            }
            throw exception;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_132, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_132);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_133, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return type == 1003;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_133);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        int n = type;
        int n2 = concurrency;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_134, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            return type == 1003 && concurrency == 1007;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_134);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_135, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_135);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_136, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_136);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_137, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_137);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_138, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_138);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_139, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_139);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_140, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_140);
            }
            throw exception;
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_141, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_141);
            }
            throw exception;
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_142, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_142);
            }
            throw exception;
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_143, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_143);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_144, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_144);
            }
            throw exception;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_145, this, this));
            }
            return this.conn;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_145);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_146, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_146);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_147, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_147);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_148, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_148);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_149, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_149);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        int n = holdability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_150, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_150);
            }
            throw exception;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_151, this, this));
            }
            return 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_151);
            }
            throw exception;
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_152, this, this));
            }
            return MongoDriver.MAJOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_152);
            }
            throw exception;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_153, this, this));
            }
            return MongoDriver.MINOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_153);
            }
            throw exception;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_154, this, this));
            }
            return 4;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_154);
            }
            throw exception;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_155, this, this));
            }
            return 2;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_155);
            }
            throw exception;
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_156, this, this));
            }
            return 2;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_156);
            }
            throw exception;
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_157, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_157);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_158, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_158);
            }
            throw exception;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_159, this, this));
            }
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_159);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_160, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_160);
            }
            throw exception;
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_161, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_161);
            }
            throw exception;
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_162, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_162);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_163, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_163);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_164, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_164);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String[] stringArray = types;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, stringArray};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_165, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(TABLE_TYPE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(TYPE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SELF_REFERENCING_COL_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(REF_GENERATION, BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoDatabaseMetaData.toJavaPattern(tableNamePattern);
            List<String> typesList = this.toTableTypeList(types);
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, tableNamePatternRE, typesList, this::toGetTablesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_205);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getTableDataFromDB(catalog, tableNamePatternRE, typesList, this::toGetTablesDoc));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_165);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_166, this, this));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(TABLE_CATALOG, BsonTypeInfo.BSON_STRING, false));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_166);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_167, this, this));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING));
            BsonExplicitCursor c = new BsonExplicitCursor(this.getDatabaseNames().sorted().map(dbName -> {
                try {
                    return this.createBottomBson(new BsonElement(TABLE_CAT, new BsonString((String)dbName)));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_206);
                    }
                    throw exception;
                }
            }).collect(Collectors.toList()));
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_167);
            }
            throw exception;
        }
    }

    private static <T> T liftSQLException(Supplier<T> f) throws SQLException {
        try {
            return f.get();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    private BsonDocument toGetColumnsDoc(GetColumnsDocInfo i) {
        try {
            BsonString isNullable = i.nullability == 0 ? BSON_NO_STR_VALUE : (i.nullability == 1 ? BSON_YES_STR_VALUE : BSON_EMPTY_STR_VALUE);
            return this.createSortableBottomBson(GET_COLUMNS_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString(i.dbName)), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString(i.tableName)), new BsonElement(COLUMN_NAME, new BsonString(i.columnName)), new BsonElement(DATA_TYPE, new BsonInt32(i.columnBsonTypeInfo.getJdbcType())), new BsonElement(TYPE_NAME, new BsonString(i.columnBsonTypeInfo.getBsonName())), new BsonElement(COLUMN_SIZE, BsonNull.VALUE), new BsonElement(BUFFER_LENGTH, BSON_ZERO_INT_VALUE), new BsonElement(DECIMAL_DIGITS, this.asBsonIntOrNull(i.columnBsonTypeInfo.getDecimalDigits())), new BsonElement(NUM_PREC_RADIX, new BsonInt32(i.columnBsonTypeInfo.getNumPrecRadix())), new BsonElement(NULLABLE, new BsonInt32(i.nullability)), new BsonElement(REMARKS, BSON_EMPTY_STR_VALUE), new BsonElement(COLUMN_DEF, BsonNull.VALUE), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(CHAR_OCTET_LENGTH, this.asBsonIntOrNull(i.columnBsonTypeInfo.getCharOctetLength())), new BsonElement(ORDINAL_POSITION, new BsonInt32(i.idx)), new BsonElement(IS_NULLABLE, isNullable), new BsonElement(SCOPE_CATALOG, BsonNull.VALUE), new BsonElement(SCOPE_SCHEMA, BsonNull.VALUE), new BsonElement(SCOPE_TABLE, BsonNull.VALUE), new BsonElement(SOURCE_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(IS_AUTOINCREMENT, BSON_NO_STR_VALUE), new BsonElement(IS_GENERATEDCOLUMN, BSON_EMPTY_STR_VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_168);
            }
            throw exception;
        }
    }

    private BsonDocument toGetColumnPrivilegesDoc(GetColumnsDocInfo i) {
        try {
            return this.createSortableBottomBson(GET_COLUMN_PRIVILEGES_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString(i.dbName)), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString(i.tableName)), new BsonElement(COLUMN_NAME, new BsonString(i.columnName)), new BsonElement(GRANTOR, BsonNull.VALUE), new BsonElement(GRANTEE, BSON_EMPTY_STR_VALUE), new BsonElement(PRIVILEGE, new BsonString("SELECT")), new BsonElement(IS_GRANTABLE, BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_169);
            }
            throw exception;
        }
    }

    private boolean isValidSchema(MongoJsonSchemaResult res) {
        try {
            return res.ok == 1 && res.schema.mongoJsonSchema != null && res.schema.mongoJsonSchema.isObject();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_170);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getColumnsFromDB(String dbName, Pattern tableNamePatternRE, Pattern columnNamePatternRE, Function<GetColumnsDocInfo, BsonDocument> bsonSerializer) {
        try {
            MongoDatabase db = this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry);
            return this.getCollectionsFromRunCommand(db).stream().map(collection -> collection.name).collect(Collectors.toList()).stream().filter(tableName -> tableNamePatternRE == null || tableNamePatternRE.matcher((CharSequence)tableName).matches()).map(tableName -> new Pair<Pair<String, String>, MongoJsonSchemaResult>(new Pair<String, String>(dbName, (String)tableName), db.runCommand((Bson)new BsonDocument("sqlGetSchema", new BsonString((String)tableName)), MongoJsonSchemaResult.class))).filter(p -> {
                try {
                    return this.isValidSchema((MongoJsonSchemaResult)p.right());
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_207);
                    }
                    throw exception;
                }
            }).flatMap(p -> {
                Pair ns = (Pair)p.left();
                MongoJsonSchemaResult res = (MongoJsonSchemaResult)p.right();
                AtomicInteger idx = new AtomicInteger();
                return res.schema.mongoJsonSchema.properties.entrySet().stream().filter(entry -> columnNamePatternRE == null || columnNamePatternRE.matcher((CharSequence)entry.getKey()).matches()).sorted(Map.Entry.comparingByKey()).map(entry -> (BsonDocument)bsonSerializer.apply(new GetColumnsDocInfo((String)ns.left(), (String)ns.right(), (String)entry.getKey(), mongoJsonSchemaResult.schema.mongoJsonSchema, (MongoJsonSchema)entry.getValue(), idx.getAndIncrement())));
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_171);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_172, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_SIZE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(BUFFER_LENGTH, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(DECIMAL_DIGITS, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(NUM_PREC_RADIX, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(NULLABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(COLUMN_DEF, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SQL_DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SQL_DATETIME_SUB, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(CHAR_OCTET_LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(ORDINAL_POSITION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(IS_NULLABLE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SCOPE_CATALOG, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SCOPE_SCHEMA, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SCOPE_TABLE, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SOURCE_DATA_TYPE, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(IS_AUTOINCREMENT, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(IS_GENERATEDCOLUMN, BsonTypeInfo.BSON_STRING));
            Pattern tableNamePatternRE = MongoDatabaseMetaData.toJavaPattern(tableNamePattern);
            Pattern columnNamePatternRE = MongoDatabaseMetaData.toJavaPattern(columnNamePattern);
            Stream docs = catalog == null ? MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getDatabaseNames().flatMap(dbName -> {
                        try {
                            return this.getColumnsFromDB((String)dbName, tableNamePatternRE, columnNamePatternRE, this::toGetColumnsDoc);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_220);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_208);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getColumnsFromDB(catalog, tableNamePatternRE, columnNamePatternRE, this::toGetColumnsDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_209);
                    }
                    throw exception;
                }
            }));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_172);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_173, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(GRANTOR, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(GRANTEE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PRIVILEGE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(IS_GRANTABLE, BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoDatabaseMetaData.toJavaPattern(tableNamePattern);
            Pattern columnNamePatternRE = MongoDatabaseMetaData.toJavaPattern(columnNamePattern);
            Stream docs = catalog == null ? MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getDatabaseNames().flatMap(dbName -> {
                        try {
                            return this.getColumnsFromDB((String)dbName, tableNamePatternRE, columnNamePatternRE, this::toGetColumnPrivilegesDoc);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_221);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_210);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getColumnsFromDB(catalog, tableNamePatternRE, columnNamePatternRE, this::toGetColumnPrivilegesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_211);
                    }
                    throw exception;
                }
            }));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_173);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_174, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(GRANTOR, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(GRANTEE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PRIVILEGE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(IS_GRANTABLE, BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoDatabaseMetaData.toJavaPattern(tableNamePattern);
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, tableNamePatternRE, null, this::toGetTablePrivilegesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_212);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getTableDataFromDB(catalog, tableNamePatternRE, null, this::toGetTablePrivilegesDoc));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_174);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getFirstUniqueIndexDocsForTable(String dbName, String tableName, BiFunction<Pair<String, String>, Document, List<BsonDocument>> serializer) {
        try {
            MongoDatabase db = this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry);
            ListIndexesIterable<Document> i = db.getCollection(tableName).listIndexes();
            ArrayList docs = new ArrayList();
            for (Document d : i) {
                Boolean isUnique = (Boolean)((Object)d.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
                if (isUnique == null || !isUnique.booleanValue()) continue;
                docs.addAll(serializer.apply(new Pair<String, String>(dbName, tableName), d));
                break;
            }
            return docs.stream();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_175);
            }
            throw exception;
        }
    }

    private ResultSet getFirstUniqueIndexResultSet(String catalog, String table, MongoJsonSchema botSchema, BiFunction<Pair<String, String>, Document, List<BsonDocument>> serializer) {
        try {
            try {
                Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                    try {
                        return this.getTableDataFromDB((String)dbName, res -> res.name.equals(table)).flatMap(r -> {
                            try {
                                return this.getFirstUniqueIndexDocsForTable((String)dbName, r.name, serializer);
                            }
                            catch (Exception exception) {
                                if (LoggingAspect.hasAspect(this)) {
                                    LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_222);
                                }
                                throw exception;
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (LoggingAspect.hasAspect(this)) {
                            LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_213);
                        }
                        throw exception;
                    }
                }) : (catalog.isEmpty() ? Stream.empty() : this.getFirstUniqueIndexDocsForTable(catalog, table, serializer));
                List<BsonDocument> docsList = docs.collect(Collectors.toList());
                BsonExplicitCursor c = new BsonExplicitCursor(docsList);
                return new MongoResultSet(this.conn.getLogger(), c, botSchema);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_176);
            }
            throw exception;
        }
    }

    private List<BsonDocument> toGetBestRowIdentifierDocs(Pair<String, String> namespace, Document indexInfo) {
        try {
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchemaResult r = this.conn.getDatabase(namespace.left()).runCommand((Bson)new BsonDocument("sqlGetSchema", new BsonString(namespace.right())), MongoJsonSchemaResult.class);
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            try {
                for (String key : keys.keySet()) {
                    docs.add(this.toGetBestRowIdentifierDoc(key, r.schema.mongoJsonSchema.properties.get(key).getBsonTypeInfo()));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return docs;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_177);
            }
            throw exception;
        }
    }

    private BsonDocument toGetBestRowIdentifierDoc(String columnName, BsonTypeInfo columnBsonTypeInfo) {
        try {
            return this.createBottomBson(new BsonElement(SCOPE, BsonNull.VALUE), new BsonElement(COLUMN_NAME, new BsonString(columnName)), new BsonElement(DATA_TYPE, new BsonInt32(columnBsonTypeInfo.getJdbcType())), new BsonElement(TYPE_NAME, new BsonString(columnBsonTypeInfo.getBsonName())), new BsonElement(COLUMN_SIZE, this.asBsonIntOrNull(columnBsonTypeInfo.getPrecision())), new BsonElement(BUFFER_LENGTH, BsonNull.VALUE), new BsonElement(DECIMAL_DIGITS, this.asBsonIntOrNull(columnBsonTypeInfo.getDecimalDigits())), new BsonElement(PSEUDO_COLUMN, new BsonInt32(1)));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_178);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        int n = scope;
        boolean bl = nullable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, Conversions.intObject(n), Conversions.booleanObject(bl)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_179, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(SCOPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_SIZE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(BUFFER_LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DECIMAL_DIGITS, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(PSEUDO_COLUMN, BsonTypeInfo.BSON_INT));
            return MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getFirstUniqueIndexResultSet(catalog, table, botSchema, this::toGetBestRowIdentifierDocs);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_214);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_179);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_180, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(SCOPE, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_SIZE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(BUFFER_LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DECIMAL_DIGITS, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(PSEUDO_COLUMN, BsonTypeInfo.BSON_INT));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_180);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_181, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(PKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(KEY_SEQ, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(UPDATE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DELETE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(FK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(DEFERRABILITY, BsonTypeInfo.BSON_INT));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_181);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_182, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(PKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(KEY_SEQ, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(UPDATE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DELETE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(FK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(DEFERRABILITY, BsonTypeInfo.BSON_INT));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_182);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String string = parentCatalog;
        String string2 = parentSchema;
        String string3 = parentTable;
        String string4 = foreignCatalog;
        String string5 = foreignSchema;
        String string6 = foreignTable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_183, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(PKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKTABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FKTABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FKCOLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(KEY_SEQ, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(UPDATE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DELETE_RULE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(FK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(PK_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(DEFERRABILITY, BsonTypeInfo.BSON_INT));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_183);
            }
            throw exception;
        }
    }

    private List<BsonDocument> toGetPrimaryKeysDocs(Pair<String, String> namespace, Document indexInfo) {
        try {
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            String indexName = indexInfo.getString(INDEX_NAME_KEY);
            AtomicInteger pos = new AtomicInteger();
            return keys.keySet().stream().map(key -> {
                try {
                    return this.createSortableBottomBson(GET_PRIMARY_KEYS_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString((String)namespace.left())), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString((String)namespace.right())), new BsonElement(COLUMN_NAME, new BsonString((String)key)), new BsonElement(KEY_SEQ, new BsonInt32(pos.incrementAndGet())), new BsonElement(PK_NAME, new BsonString(indexName)));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_215);
                    }
                    throw exception;
                }
            }).sorted().collect(Collectors.toList());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_184);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_185, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(KEY_SEQ, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(PK_NAME, BsonTypeInfo.BSON_STRING, false));
            return MongoDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getFirstUniqueIndexResultSet(catalog, table, botSchema, this::toGetPrimaryKeysDocs);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_216);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_185);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getTypeInfoJsonSchema() {
        try {
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(PRECISION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(LITERAL_PREFIX, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(LITERAL_SUFFIX, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(CREATE_PARAMS, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(NULLABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(CASE_SENSITIVE, BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties(SEARCHABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(UNSIGNED_ATTRIBUTE, BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties(FIX_PREC_SCALE, BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties(AUTO_INCREMENT, BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties(LOCAL_TYPE_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(MINIMUM_SCALE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(MAXIMUM_SCALE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SQL_DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SQL_DATETIME_SUB, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(NUM_PREC_RADIX, BsonTypeInfo.BSON_INT));
            return schema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_186);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_187, this, this));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchema schema = this.getTypeInfoJsonSchema();
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_LONG.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(-5)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_LONG.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_LONG.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_LONG.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_LONG.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_LONG.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_BINDATA.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(-2)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_BINDATA.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_BINDATA.getCaseSensitivity())), new BsonElement(SEARCHABLE, new BsonInt32(0)), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BINDATA.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BINDATA.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_BINDATA.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_STRING.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(-1)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_STRING.getPrecision())), new BsonElement(LITERAL_PREFIX, new BsonString("'")), new BsonElement(LITERAL_SUFFIX, new BsonString("'")), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_STRING.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_STRING.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_STRING.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_STRING.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_NULL.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(BsonTypeInfo.BSON_NULL.getJdbcType())), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_NULL.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_NULL.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_NULL.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_NULL.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_NULL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_DECIMAL.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(3)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_DECIMAL.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_DECIMAL.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_INT.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(4)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_INT.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_INT.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_INT.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_INT.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_INT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_DOUBLE.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(8)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_DOUBLE.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_DOUBLE.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_BOOL.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(BsonTypeInfo.BSON_BOOL.getJdbcType())), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_BOOL.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_BOOL.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BOOL.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BOOL.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_BOOL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_DATE.getBsonName())), new BsonElement(DATA_TYPE, new BsonInt32(93)), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_DATE.getPrecision())), new BsonElement(LITERAL_PREFIX, new BsonString("'")), new BsonElement(LITERAL_SUFFIX, new BsonString("'")), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_DATE.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DATE.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DATE.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_DATE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_ARRAY.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_ARRAY.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_ARRAY.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_ARRAY.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_ARRAY.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_ARRAY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_BSON.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_BSON.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_BSON.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BSON.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_BSON.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_BSON.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_DBPOINTER.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_DBPOINTER.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_DBPOINTER.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_JAVASCRIPT.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_JAVASCRIPT.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_JAVASCRIPT.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_MAXKEY.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_MAXKEY.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_MAXKEY.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_MINKEY.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_MINKEY.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_MINKEY.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_MINKEY.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_MINKEY.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_MINKEY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_OBJECT.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_OBJECT.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_OBJECT.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_OBJECT.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_OBJECT.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_OBJECT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_OBJECTID.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_OBJECTID.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_OBJECTID.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_REGEX.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_REGEX.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_REGEX.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_REGEX.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_REGEX.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_REGEX.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_SYMBOL.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_SYMBOL.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_SYMBOL.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_TIMESTAMP.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_TIMESTAMP.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_TIMESTAMP.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement(TYPE_NAME, new BsonString(BsonTypeInfo.BSON_UNDEFINED.getBsonName())), new BsonElement(DATA_TYPE, BSON_OTHER_INT_VALUE), new BsonElement(PRECISION, this.asBsonIntOrNull(BsonTypeInfo.BSON_UNDEFINED.getPrecision())), new BsonElement(LITERAL_PREFIX, BsonNull.VALUE), new BsonElement(LITERAL_SUFFIX, BsonNull.VALUE), new BsonElement(CREATE_PARAMS, BsonNull.VALUE), new BsonElement(NULLABLE, BSON_COLUMN_NULLABLE_INT_VALUE), new BsonElement(CASE_SENSITIVE, new BsonBoolean(BsonTypeInfo.BSON_UNDEFINED.getCaseSensitivity())), new BsonElement(SEARCHABLE, BSON_TYPE_SEARCHABLE_INT_VALUE), new BsonElement(UNSIGNED_ATTRIBUTE, BsonBoolean.FALSE), new BsonElement(FIXED_PREC_SCALE, BsonBoolean.FALSE), new BsonElement(AUTO_INCREMENT, BsonBoolean.FALSE), new BsonElement(LOCAL_TYPE_NAME, BsonNull.VALUE), new BsonElement(MINIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getMinScale())), new BsonElement(MAXIMUM_SCALE, new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getMaxScale())), new BsonElement(SQL_DATA_TYPE, BSON_ZERO_INT_VALUE), new BsonElement(SQL_DATETIME_SUB, BSON_ZERO_INT_VALUE), new BsonElement(NUM_PREC_RADIX, new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getNumPrecRadix()))));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoResultSet(this.conn.getLogger(), new BsonExplicitCursor(docs), botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_187);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> toGetIndexInfoDocs(String dbName, String tableName, Document indexInfo) {
        try {
            Boolean isUnique = (Boolean)((Object)indexInfo.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
            BsonBoolean nonUnique = new BsonBoolean(isUnique == null || isUnique == false);
            BsonString indexName = new BsonString(indexInfo.getString(INDEX_NAME_KEY));
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            AtomicInteger pos = new AtomicInteger();
            return keys.keySet().stream().map(key -> {
                try {
                    BsonString ascOrDesc = new BsonString(keys.getInteger(key) > 0 ? "A" : "D");
                    return this.createSortableBottomBson(GET_INDEX_INFO_SORT_SPECS, new BsonElement(TABLE_CAT, new BsonString(dbName)), new BsonElement(TABLE_SCHEM, BsonNull.VALUE), new BsonElement(TABLE_NAME, new BsonString(tableName)), new BsonElement(NON_UNIQUE, nonUnique), new BsonElement(INDEX_QUALIFIER, BsonNull.VALUE), new BsonElement(INDEX_NAME, indexName), new BsonElement(TYPE, new BsonInt32(3)), new BsonElement(ORDINAL_POSITION, new BsonInt32(pos.incrementAndGet())), new BsonElement(COLUMN_NAME, new BsonString((String)key)), new BsonElement(ASC_OR_DESC, ascOrDesc), new BsonElement(CARDINALITY, BsonNull.VALUE), new BsonElement(PAGES, BsonNull.VALUE), new BsonElement(FILTER_CONDITION, BsonNull.VALUE));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_217);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_188);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getIndexesFromTable(String dbName, String tableName, boolean unique) {
        try {
            return this.conn.getDatabase(dbName).getCollection(tableName).listIndexes().into(new ArrayList()).stream().filter(d -> {
                Boolean isUnique = (Boolean)((Object)d.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
                return !unique || isUnique != null && isUnique != false;
            }).flatMap(d -> {
                try {
                    return this.toGetIndexInfoDocs(dbName, tableName, (Document)d);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_218);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_189);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        boolean bl = unique;
        boolean bl2 = approximate;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject(bl), Conversions.booleanObject(bl2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_190, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(NON_UNIQUE, BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties(INDEX_QUALIFIER, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(INDEX_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(ORDINAL_POSITION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(ASC_OR_DESC, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(CARDINALITY, BsonTypeInfo.BSON_LONG), new MongoJsonSchema.ScalarProperties(PAGES, BsonTypeInfo.BSON_LONG), new MongoJsonSchema.ScalarProperties(FILTER_CONDITION, BsonTypeInfo.BSON_LONG, false));
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, res -> res.name.equals(table)).flatMap(r -> {
                        try {
                            return this.getIndexesFromTable((String)dbName, r.name, unique);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_223);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_219);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getIndexesFromTable(catalog, table, unique));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoResultSet(this.conn.getLogger(), c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_190);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        int[] nArray = types;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, nArray};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_191, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TYPE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(CLASS_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(BASE_TYPE, BsonTypeInfo.BSON_INT, false));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_191);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_192, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TYPE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SUPERTYPE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SUPERTYPE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SUPERTYPE_NAME, BsonTypeInfo.BSON_STRING));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_192);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_193, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SUPERTABLE_NAME, BsonTypeInfo.BSON_STRING));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_193);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        String string4 = attributeNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_194, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TYPE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(ATTR_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(ATTR_TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(ATTR_SIZE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DECIMAL_DIGITS, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(NUM_PREC_RADIX, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(NULLABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(ATTR_DEF, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SQL_DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SQL_DATETIME_SUB, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(CHAR_OCTET_LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(ORDINAL_POSITION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(IS_NULLABLE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SCOPE_CATALOG, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SCOPE_SCHEMA, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SCOPE_TABLE, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(SOURCE_DATA_TYPE, BsonTypeInfo.BSON_INT, false));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_194);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_195, this, this, string, string2));
            }
            return this.getSchemas();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_195);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_196, this, this));
            }
            new ArrayList();
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties(NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(MAX_LEN, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DEFAULT_VALUE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DESCRIPTION, BsonTypeInfo.BSON_STRING));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_196);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getFunctionJsonSchema() {
        try {
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(FUNCTION_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FUNCTION_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FUNCTION_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(FUNCTION_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SPECIFIC_NAME, BsonTypeInfo.BSON_STRING));
            return botSchema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_197);
            }
            throw exception;
        }
    }

    private BsonDocument getFunctionValuesDoc(String functionName, String remarks) {
        try {
            BsonDocument root = new BsonDocument();
            BsonDocument bot = new BsonDocument();
            root.put(BOT_NAME, bot);
            bot.put(FUNCTION_CAT, new BsonString(FUNC_DEFAULT_CATALOG));
            bot.put(FUNCTION_SCHEM, BsonNull.VALUE);
            bot.put(FUNCTION_NAME, new BsonString(functionName));
            bot.put(REMARKS, new BsonString(remarks));
            bot.put(FUNCTION_TYPE, new BsonInt32(1));
            bot.put(SPECIFIC_NAME, new BsonString(functionName));
            return root;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_198);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = functionNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_199, (Object)this, (Object)this, objectArray));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>(MongoDatabaseMetaData.MongoFunctions.functions.length);
            MongoJsonSchema schema = this.getFunctionJsonSchema();
            Pattern functionPatternRE = null;
            if (functionNamePattern != null) {
                functionPatternRE = MongoDatabaseMetaData.toJavaPattern(functionNamePattern);
            }
            MongoFunctions.MongoFunction[] mongoFunctionArray = MongoDatabaseMetaData.MongoFunctions.functions;
            int n = MongoDatabaseMetaData.MongoFunctions.functions.length;
            int n2 = 0;
            while (n2 < n) {
                MongoFunctions.MongoFunction func = mongoFunctionArray[n2];
                if (functionPatternRE == null || functionPatternRE.matcher(func.name).matches()) {
                    BsonDocument doc = this.getFunctionValuesDoc(func.name, func.comment);
                    docs.add(doc);
                }
                ++n2;
            }
            return new MongoResultSet(this.conn.getLogger(), new BsonExplicitCursor(docs), schema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_199);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getFunctionColumnJsonSchema() {
        try {
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(FUNCTION_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FUNCTION_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(FUNCTION_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(TYPE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(PRECISION, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(SCALE, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(RADIX, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(NULLABLE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(CHAR_OCTET_LENGTH, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(ORDINAL_POSITION, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(IS_NULLABLE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(SPECIFIC_NAME, BsonTypeInfo.BSON_STRING));
            return botSchema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_200);
            }
            throw exception;
        }
    }

    private Map<String, BsonValue> getFunctionParameterValues(MongoFunctions.MongoFunction func, int i, String argName, String argType, boolean isReturnColumn) throws SQLException {
        try {
            LinkedHashMap<String, BsonValue> info = new LinkedHashMap<String, BsonValue>();
            BsonTypeInfo bsonTypeInfo = argType == null ? BsonTypeInfo.BSON_UNDEFINED : BsonTypeInfo.getBsonTypeInfoByName(argType);
            info.put(FUNCTION_CAT, new BsonString(FUNC_DEFAULT_CATALOG));
            info.put(FUNCTION_SCHEM, BsonNull.VALUE);
            info.put(FUNCTION_NAME, new BsonString(func.name));
            info.put(COLUMN_NAME, new BsonString(argName));
            info.put(COLUMN_TYPE, this.asBsonIntOrNull(isReturnColumn ? 4 : 1));
            info.put(DATA_TYPE, this.asBsonIntOrNull(bsonTypeInfo.getJdbcType()));
            info.put(TYPE_NAME, new BsonString(bsonTypeInfo == BsonTypeInfo.BSON_UNDEFINED ? BOT_NAME : bsonTypeInfo.getBsonName()));
            info.put(PRECISION, this.asBsonIntOrNull(bsonTypeInfo.getPrecision()));
            info.put(LENGTH, this.asBsonIntOrDefault(bsonTypeInfo.getFixedBytesLength(), 0));
            info.put(SCALE, this.asBsonIntOrNull(bsonTypeInfo.getDecimalDigits()));
            info.put(RADIX, new BsonInt32(bsonTypeInfo.getNumPrecRadix()));
            info.put(NULLABLE, new BsonInt32(1));
            info.put(REMARKS, new BsonString(func.comment));
            info.put(CHAR_OCTET_LENGTH, this.asBsonIntOrNull(bsonTypeInfo.getCharOctetLength()));
            info.put(ORDINAL_POSITION, new BsonInt32(i));
            info.put(IS_NULLABLE, new BsonString(YES));
            info.put(SPECIFIC_NAME, new BsonString(func.name));
            return info;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_201);
            }
            throw exception;
        }
    }

    private BsonDocument getFunctionColumnValuesDoc(MongoFunctions.MongoFunction func, int i, String argName, String argType, boolean isReturnColumn) throws SQLException {
        try {
            Map<String, BsonValue> info = this.getFunctionParameterValues(func, i, argName, argType, isReturnColumn);
            BsonDocument root = new BsonDocument();
            BsonDocument bot = new BsonDocument();
            root.put(BOT_NAME, bot);
            String cfr_ignored_0 = func.name;
            bot.putAll((Map<? extends String, ? extends BsonValue>)info);
            return root;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_202);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = functionNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_203, (Object)this, (Object)this, objectArray));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>(MongoDatabaseMetaData.MongoFunctions.functions.length);
            MongoJsonSchema schema = this.getFunctionColumnJsonSchema();
            Pattern functionNamePatternRE = null;
            Pattern columnNamePatternRE = null;
            if (functionNamePattern != null) {
                functionNamePatternRE = MongoDatabaseMetaData.toJavaPattern(functionNamePattern);
            }
            if (columnNamePattern != null) {
                columnNamePatternRE = MongoDatabaseMetaData.toJavaPattern(columnNamePattern);
            }
            MongoFunctions.MongoFunction[] mongoFunctionArray = MongoDatabaseMetaData.MongoFunctions.functions;
            int n = MongoDatabaseMetaData.MongoFunctions.functions.length;
            int n2 = 0;
            while (n2 < n) {
                MongoFunctions.MongoFunction func = mongoFunctionArray[n2];
                if (functionNamePatternRE == null || functionNamePatternRE.matcher(func.name).matches()) {
                    int i = 0;
                    String[] stringArray = func.argTypes;
                    int n3 = func.argTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String argType = stringArray[n4];
                        String columnName = "arg" + ++i;
                        if (columnNamePatternRE == null || columnNamePatternRE.matcher(columnName).matches()) {
                            BsonDocument doc = this.getFunctionColumnValuesDoc(func, i, columnName, argType, false);
                            docs.add(doc);
                        }
                        ++n4;
                    }
                    String columnName = "argReturn";
                    if (columnNamePatternRE == null || columnNamePatternRE.matcher(columnName).matches()) {
                        BsonDocument doc = this.getFunctionColumnValuesDoc(func, i, "argReturn", func.returnType, true);
                        docs.add(doc);
                    }
                }
                ++n2;
            }
            return new MongoResultSet(this.conn.getLogger(), new BsonExplicitCursor(docs), schema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_203);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_204, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties(TABLE_CAT, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_SCHEM, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(TABLE_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_NAME, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(DATA_TYPE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(COLUMN_SIZE, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(DECIMAL_DIGITS, BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties(NUM_PREC_RADIX, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(COLUMN_USAGE, BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties(REMARKS, BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties(CHAR_OCTET_LENGTH, BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties(IS_NULLABLE, BsonTypeInfo.BSON_STRING));
            return new MongoResultSet(this.conn.getLogger(), BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_204);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoDatabaseMetaData ajc$this, MongoDatabaseMetaData target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoDatabaseMetaData.java", MongoDatabaseMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "createBottomBson", "com.mongodb.jdbc.MongoDatabaseMetaData", "[Lorg.bson.BsonElement;", "elements", BOT_NAME, "org.bson.BsonDocument"), 249);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "createSortableBottomBson", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.List:[Lorg.bson.BsonElement;", "sortSpecs:elements", BOT_NAME, "com.mongodb.jdbc.SortableBsonDocument"), 256);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedures", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:procedureNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 343);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsUnionAll", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 956);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenCursorsAcrossCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 961);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenCursorsAcrossRollback", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 967);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenStatementsAcrossCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 973);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenStatementsAcrossRollback", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 979);
        ajc$tjp_105 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxBinaryLiteralLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 990);
        ajc$tjp_106 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCharLiteralLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 995);
        ajc$tjp_107 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1000);
        ajc$tjp_108 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInGroupBy", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1005);
        ajc$tjp_109 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInIndex", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1011);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedureColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:procedureNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 358);
        ajc$tjp_110 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInOrderBy", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1018);
        ajc$tjp_111 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1024);
        ajc$tjp_112 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInTable", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1030);
        ajc$tjp_113 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxConnections", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1035);
        ajc$tjp_114 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCursorNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1040);
        ajc$tjp_115 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxIndexLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1045);
        ajc$tjp_116 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxSchemaNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1050);
        ajc$tjp_117 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxProcedureNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1055);
        ajc$tjp_118 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCatalogNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1060);
        ajc$tjp_119 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxRowSize", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1065);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableTypes", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 391);
        ajc$tjp_120 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doesMaxRowSizeIncludeBlobs", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1070);
        ajc$tjp_121 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxStatementLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1075);
        ajc$tjp_122 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxStatements", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1080);
        ajc$tjp_123 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTableNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1085);
        ajc$tjp_124 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTablesInSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1090);
        ajc$tjp_125 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxUserNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1095);
        ajc$tjp_126 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultTransactionIsolation", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1102);
        ajc$tjp_127 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1107);
        ajc$tjp_128 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTransactionIsolationLevel", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "level", "java.sql.SQLException", "boolean"), 1112);
        ajc$tjp_129 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDataDefinitionAndDataManipulationTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1117);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDatabaseNames", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "java.util.stream.Stream"), 413);
        ajc$tjp_130 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDataManipulationTransactionsOnly", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1123);
        ajc$tjp_131 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dataDefinitionCausesTransactionCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1128);
        ajc$tjp_132 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dataDefinitionIgnoredInTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1133);
        ajc$tjp_133 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetType", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1139);
        ajc$tjp_134 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetConcurrency", "com.mongodb.jdbc.MongoDatabaseMetaData", "int:int", "type:concurrency", "java.sql.SQLException", "boolean"), 1144);
        ajc$tjp_135 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownUpdatesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1149);
        ajc$tjp_136 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownDeletesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1155);
        ajc$tjp_137 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownInsertsAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1161);
        ajc$tjp_138 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersUpdatesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1167);
        ajc$tjp_139 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersDeletesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1173);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCollectionsFromRunCommand", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.client.MongoDatabase", "db", BOT_NAME, "java.util.ArrayList"), 424);
        ajc$tjp_140 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersInsertsAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1179);
        ajc$tjp_141 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatesAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1185);
        ajc$tjp_142 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletesAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1191);
        ajc$tjp_143 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertsAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 1197);
        ajc$tjp_144 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsBatchUpdates", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1203);
        ajc$tjp_145 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.Connection"), 1209);
        ajc$tjp_146 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSavepoints", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1216);
        ajc$tjp_147 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsNamedParameters", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1221);
        ajc$tjp_148 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleOpenResults", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1226);
        ajc$tjp_149 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGetGeneratedKeys", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1231);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTableDataFromDB", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.function.Function", "dbName:filter", BOT_NAME, "java.util.stream.Stream"), 436);
        ajc$tjp_150 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetHoldability", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "holdability", "java.sql.SQLException", "boolean"), 1238);
        ajc$tjp_151 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetHoldability", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1243);
        ajc$tjp_152 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1248);
        ajc$tjp_153 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1253);
        ajc$tjp_154 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJDBCMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1258);
        ajc$tjp_155 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJDBCMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1263);
        ajc$tjp_156 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLStateType", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "int"), 1268);
        ajc$tjp_157 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locatorsUpdateCopy", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1274);
        ajc$tjp_158 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStatementPooling", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1281);
        ajc$tjp_159 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowIdLifetime", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.RowIdLifetime"), 1288);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetTablesDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.MongoListTablesResult", "dbName:res", BOT_NAME, "org.bson.BsonDocument"), 445);
        ajc$tjp_160 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStoredFunctionsUsingCallSyntax", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1293);
        ajc$tjp_161 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "autoCommitFailureClosesAllResultSets", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1299);
        ajc$tjp_162 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generatedKeyAlwaysReturned", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 1307);
        ajc$tjp_163 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 1314);
        ajc$tjp_164 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 1320);
        ajc$tjp_165 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTables", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:[Ljava.lang.String;", "catalog:schemaPattern:tableNamePattern:types", "java.sql.SQLException", "java.sql.ResultSet"), 1326);
        ajc$tjp_166 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemas", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 1377);
        ajc$tjp_167 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogs", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 1387);
        ajc$tjp_168 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetColumnsDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoDatabaseMetaData$GetColumnsDocInfo", "i", BOT_NAME, "org.bson.BsonDocument"), 1466);
        ajc$tjp_169 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetColumnPrivilegesDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoDatabaseMetaData$GetColumnsDocInfo", "i", BOT_NAME, "org.bson.BsonDocument"), 1511);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetTablePrivilegesDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.MongoListTablesResult", "dbName:res", BOT_NAME, "org.bson.BsonDocument"), 465);
        ajc$tjp_170 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isValidSchema", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoJsonSchemaResult", "res", BOT_NAME, "boolean"), 1528);
        ajc$tjp_171 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getColumnsFromDB", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern:java.util.function.Function", "dbName:tableNamePatternRE:columnNamePatternRE:bsonSerializer", BOT_NAME, "java.util.stream.Stream"), 1537);
        ajc$tjp_172 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1607);
        ajc$tjp_173 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnPrivileges", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1681);
        ajc$tjp_174 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTablePrivileges", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1739);
        ajc$tjp_175 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFirstUniqueIndexDocsForTable", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.util.function.BiFunction", "dbName:tableName:serializer", BOT_NAME, "java.util.stream.Stream"), 1785);
        ajc$tjp_176 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFirstUniqueIndexResultSet", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema:java.util.function.BiFunction", "catalog:table:botSchema:serializer", BOT_NAME, "java.sql.ResultSet"), 1815);
        ajc$tjp_177 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetBestRowIdentifierDocs", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.Pair:org.bson.Document", "namespace:indexInfo", BOT_NAME, "java.util.List"), 1861);
        ajc$tjp_178 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetBestRowIdentifierDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.BsonTypeInfo", "columnName:columnBsonTypeInfo", BOT_NAME, "org.bson.BsonDocument"), 1891);
        ajc$tjp_179 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBestRowIdentifier", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:int:boolean", "catalog:schema:table:scope:nullable", "java.sql.SQLException", "java.sql.ResultSet"), 1906);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTableDataFromDB", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.List:java.util.function.BiFunction", "dbName:tableNamePatternRE:types:bsonSerializer", BOT_NAME, "java.util.stream.Stream"), 482);
        ajc$tjp_180 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVersionColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 1929);
        ajc$tjp_181 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getImportedKeys", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 1946);
        ajc$tjp_182 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExportedKeys", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 1969);
        ajc$tjp_183 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCrossReference", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "parentCatalog:parentSchema:parentTable:foreignCatalog:foreignSchema:foreignTable", "java.sql.SQLException", "java.sql.ResultSet"), 1992);
        ajc$tjp_184 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetPrimaryKeysDocs", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.Pair:org.bson.Document", "namespace:indexInfo", BOT_NAME, "java.util.List"), 2024);
        ajc$tjp_185 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrimaryKeys", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 2051);
        ajc$tjp_186 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTypeInfoJsonSchema", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 2068);
        ajc$tjp_187 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeInfo", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 2094);
        ajc$tjp_188 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetIndexInfoDocs", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:org.bson.Document", "dbName:tableName:indexInfo", BOT_NAME, "java.util.stream.Stream"), 2631);
        ajc$tjp_189 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getIndexesFromTable", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:boolean", "dbName:tableName:unique", BOT_NAME, "java.util.stream.Stream"), 2670);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toTableTypeList", "com.mongodb.jdbc.MongoDatabaseMetaData", "[Ljava.lang.String;", "types", BOT_NAME, "java.util.List"), 498);
        ajc$tjp_190 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIndexInfo", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:boolean:boolean", "catalog:schema:table:unique:approximate", "java.sql.SQLException", "java.sql.ResultSet"), 2690);
        ajc$tjp_191 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUDTs", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:[I", "catalog:schemaPattern:typeNamePattern:types", "java.sql.SQLException", "java.sql.ResultSet"), 2740);
        ajc$tjp_192 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuperTypes", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:typeNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 2757);
        ajc$tjp_193 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuperTables", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 2772);
        ajc$tjp_194 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributes", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:typeNamePattern:attributeNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 2785);
        ajc$tjp_195 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemas", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String", "catalog:schemaPattern", "java.sql.SQLException", "java.sql.ResultSet"), 2821);
        ajc$tjp_196 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfoProperties", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 2826);
        ajc$tjp_197 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionJsonSchema", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 2842);
        ajc$tjp_198 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionValuesDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String", "functionName:remarks", BOT_NAME, "org.bson.BsonDocument"), 2855);
        ajc$tjp_199 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunctions", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:functionNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 2869);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("92", "createBottomSchema", "com.mongodb.jdbc.MongoDatabaseMetaData", "[Lcom.mongodb.jdbc.MongoJsonSchema$ScalarProperties;", "resultSchemaFields", BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 265);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "allProceduresAreCallable", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 520);
        ajc$tjp_200 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionColumnJsonSchema", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 2890);
        ajc$tjp_201 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionParameterValues", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoFunctions$MongoFunction:int:java.lang.String:java.lang.String:boolean", "func:i:argName:argType:isReturnColumn", "java.sql.SQLException", "java.util.Map"), 2923);
        ajc$tjp_202 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionColumnValuesDoc", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoFunctions$MongoFunction:int:java.lang.String:java.lang.String:boolean", "func:i:argName:argType:isReturnColumn", "java.sql.SQLException", "org.bson.BsonDocument"), 2966);
        ajc$tjp_203 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunctionColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:functionNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 2985);
        ajc$tjp_204 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPseudoColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 3034);
        ajc$tjp_205 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$5", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.util.List:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 1356);
        ajc$tjp_206 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$8", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String", "dbName", BOT_NAME, "org.bson.BsonDocument"), 1397);
        ajc$tjp_207 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$12", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.Pair", "p", BOT_NAME, "boolean"), 1566);
        ajc$tjp_208 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$16", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1", BOT_NAME, "java.util.stream.Stream"), 1649);
        ajc$tjp_209 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$19", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1:arg2", BOT_NAME, "java.util.stream.Stream"), 1666);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "allTablesAreSelectable", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 525);
        ajc$tjp_210 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$21", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1", BOT_NAME, "java.util.stream.Stream"), 1707);
        ajc$tjp_211 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$24", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1:arg2", BOT_NAME, "java.util.stream.Stream"), 1724);
        ajc$tjp_212 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$26", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.lang.String", "arg0:dbName", BOT_NAME, "java.util.stream.Stream"), 1763);
        ajc$tjp_213 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$29", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.function.BiFunction:java.lang.String:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 1829);
        ajc$tjp_214 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$32", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema", "arg0:arg1:arg2", BOT_NAME, "java.sql.ResultSet"), 1924);
        ajc$tjp_215 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$34", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.Pair:java.util.concurrent.atomic.AtomicInteger:java.lang.String:java.lang.String", "arg0:arg1:arg2:key", BOT_NAME, "com.mongodb.jdbc.SortableBsonDocument"), 2034);
        ajc$tjp_216 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$35", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema", "arg0:arg1:arg2", BOT_NAME, "java.sql.ResultSet"), 2064);
        ajc$tjp_217 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$37", "com.mongodb.jdbc.MongoDatabaseMetaData", "org.bson.Document:java.lang.String:java.lang.String:org.bson.BsonValue:org.bson.BsonValue:java.util.concurrent.atomic.AtomicInteger:java.lang.String", "arg0:arg1:arg2:arg3:arg4:arg5:key", BOT_NAME, "org.bson.BsonDocument"), 2645);
        ajc$tjp_218 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$39", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.lang.String:org.bson.Document", "arg0:arg1:d", BOT_NAME, "java.util.stream.Stream"), 2686);
        ajc$tjp_219 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$40", "com.mongodb.jdbc.MongoDatabaseMetaData", "boolean:java.lang.String:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 2717);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 530);
        ajc$tjp_220 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$17", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 1652);
        ajc$tjp_221 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$22", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 1710);
        ajc$tjp_222 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$31", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:java.util.function.BiFunction:com.mongodb.jdbc.MongoListTablesResult", "arg0:arg1:r", BOT_NAME, "java.util.stream.Stream"), 1834);
        ajc$tjp_223 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$42", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.String:boolean:com.mongodb.jdbc.MongoListTablesResult", "arg0:arg1:r", BOT_NAME, "java.util.stream.Stream"), 2721);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserName", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 535);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 540);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedHigh", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 545);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedLow", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 550);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedAtStart", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 555);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedAtEnd", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 560);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseProductName", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 565);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "asBsonIntOrNull", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Integer", "i", BOT_NAME, "org.bson.BsonValue"), 276);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseProductVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 570);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverName", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 579);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 584);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "int"), 589);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "int"), 594);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "usesLocalFiles", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 599);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "usesLocalFilePerTable", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 605);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMixedCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 611);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesUpperCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 616);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesLowerCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 621);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "asBsonIntOrDefault", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Integer:java.lang.Integer", "i:defaultVal", BOT_NAME, "org.bson.BsonValue"), 280);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesMixedCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 626);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMixedCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 631);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesUpperCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 636);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesLowerCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 641);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesMixedCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 646);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdentifierQuoteString", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 651);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSearchStringEscape", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 656);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExtraNameCharacters", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 661);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsAlterTableWithAddColumn", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 670);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsAlterTableWithDropColumn", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 675);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLKeywords", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 288);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsColumnAliasing", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 680);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullPlusNonNullIsNull", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 685);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsConvert", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 690);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsConvert", "com.mongodb.jdbc.MongoDatabaseMetaData", "int:int", "fromType:toType", "java.sql.SQLException", "boolean"), 695);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTableCorrelationNames", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 714);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDifferentTableCorrelationNames", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 719);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsExpressionsInOrderBy", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 724);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOrderByUnrelated", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 729);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupBy", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 734);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupByUnrelated", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 739);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumericFunctions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 323);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupByBeyondSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 744);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsLikeEscapeClause", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 749);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleResultSets", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 754);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 759);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsNonNullableColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 765);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMinimumSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 770);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCoreSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 776);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsExtendedSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 782);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92EntryLevelSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 787);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92IntermediateSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 793);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStringFunctions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 328);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92FullSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 799);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsIntegrityEnhancementFacility", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 804);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 809);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsFullOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 814);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsLimitedOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 819);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 824);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedureTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 830);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 836);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCatalogAtStart", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 841);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogSeparator", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 846);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSystemFunctions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 333);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInDataManipulation", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 851);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInProcedureCalls", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 856);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInTableDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 861);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInIndexDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 866);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInPrivilegeDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 871);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInDataManipulation", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 876);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInProcedureCalls", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 882);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInTableDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 888);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInIndexDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 894);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInPrivilegeDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 900);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeDateFunctions", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 338);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsPositionedDelete", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 906);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsPositionedUpdate", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 911);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSelectForUpdate", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 916);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStoredProcedures", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 921);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInComparisons", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 926);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInExists", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 931);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInIns", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 936);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInQuantifieds", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 941);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCorrelatedSubqueries", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 946);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsUnion", "com.mongodb.jdbc.MongoDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "boolean"), 951);
    }

    private static class GetColumnsDocInfo {
        String dbName;
        String tableName;
        String columnName;
        BsonTypeInfo columnBsonTypeInfo;
        int nullability;
        int idx;

        GetColumnsDocInfo(String dbName, String tableName, String columnName, MongoJsonSchema parentSchema, MongoJsonSchema columnSchema, int idx) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.columnName = columnName;
            this.idx = idx;
            try {
                this.columnBsonTypeInfo = columnSchema.getBsonTypeInfo();
                this.nullability = parentSchema.getColumnNullability(columnName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

