/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.Pair;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoDriver
implements Driver,
LoggingAspect$ajcMightHaveAspect {
    static final String JDBC = "jdbc:";
    static final String MONGODB_URL_PREFIX = "jdbc:mongodb:";
    static final String MONGODB_SRV_URL_PREFIX = "jdbc:mongodb+srv:";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    static final String MONGODB_PRODUCT_NAME = "MongoDB Atlas";
    static final String MONGO_DRIVER_NAME = "MongoDB Atlas SQL interface JDBC Driver";
    static final String NAME;
    static final String VERSION;
    static final int MAJOR_VERSION;
    static final int MINOR_VERSION;
    static final String LEVELS;
    static final String RELAXED = "RELAXED";
    static final String EXTENDED = "EXTENDED";
    public static final String LOG_TO_CONSOLE = "console";
    protected static final String CONNECTION_ERROR_SQLSTATE = "08000";
    static CodecRegistry registry;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoDriver.ajc$preClinit();
        LEVELS = Arrays.toString(new String[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.FINER.getName(), Level.INFO.getName(), Level.FINE.getName(), Level.WARNING.getName()});
        registry = CodecRegistries.fromProviders(new BsonValueCodecProvider(), new ValueCodecProvider(), MongoClientSettings.getDefaultCodecRegistry(), PojoCodecProvider.builder().automatic(true).build());
        MongoDriver unit = new MongoDriver();
        try {
            DriverManager.registerDriver(unit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        VERSION = unit.getClass().getPackage().getImplementationVersion();
        if (VERSION != null) {
            String[] verSp = VERSION.split("[.]");
            if (verSp.length < 2) {
                throw new RuntimeException(new SQLException("version was not specified correctly, must contain at least major and minor parts"));
            }
            MAJOR_VERSION = Integer.parseInt(verSp[0]);
            MINOR_VERSION = Integer.parseInt(verSp[1]);
        } else {
            MAJOR_VERSION = 0;
            MINOR_VERSION = 0;
        }
        String name = unit.getClass().getPackage().getImplementationTitle();
        NAME = name != null ? name : "mongodb-jdbc";
    }

    public MongoDriver() {
        LoggingAspect.ajc$perObjectBind(this);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            MongoConnection conn;
            Properties lowerCaseprops = new Properties();
            if (info != null) {
                Enumeration<?> keys = info.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    lowerCaseprops.put(key.toLowerCase(), info.getProperty(key));
                }
            }
            if ((conn = this.getUnvalidatedConnection(url, lowerCaseprops)) != null) {
                try {
                    conn.testConnection(conn.getDefaultConnectionValidationTimeoutSeconds());
                }
                catch (TimeoutException timeoutException) {
                    throw new SQLTimeoutException("Couldn't connect due to a timeout. Please check your hostname and port. If necessary, set a longer connection timeout in the MongoDB URI.");
                }
                catch (Exception e) {
                    throw new SQLException("Connection failed.", e);
                }
            }
            return conn;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    protected MongoConnection getUnvalidatedConnection(String url, Properties info) throws SQLException {
        try {
            Pair<ConnectionString, DriverPropertyInfo[]> p;
            if (!this.acceptsURL(url)) {
                return null;
            }
            if (info == null) {
                info = new Properties();
            }
            if ((p = MongoDriver.getConnectionSettings(url, info)).right().length != 0) {
                throw new SQLException(this.reportMissingProperties(p.right()), CONNECTION_ERROR_SQLSTATE);
            }
            return this.createConnection(p.left(), info);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private String reportMissingProperties(DriverPropertyInfo[] missingRequiredProperties) {
        try {
            ArrayList<String> propertyNames = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("There are issues with your connection settings : ");
            DriverPropertyInfo[] driverPropertyInfoArray = missingRequiredProperties;
            int n = missingRequiredProperties.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if (info.name.equals(USER)) {
                    sb.append("Password specified without user. Please provide '");
                    sb.append(USER);
                    sb.append("' property value.\n");
                } else if (info.name.equals(PASSWORD)) {
                    sb.append("User specified without password. Please provide '");
                    sb.append(PASSWORD);
                    sb.append("' property value.\n");
                } else if (info.name.equals(MongoJDBCProperty.DATABASE.getPropertyName())) {
                    sb.append("Mandatory property '");
                    sb.append(MongoJDBCProperty.DATABASE.getPropertyName());
                    sb.append("' is missing.\n");
                } else {
                    propertyNames.add(info.name);
                }
                ++n2;
            }
            if (!propertyNames.isEmpty()) {
                sb.append("Unexpected driver property info : ");
                sb.append(String.join((CharSequence)", ", propertyNames));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private MongoConnection createConnection(ConnectionString cs, Properties info) throws SQLException {
        try {
            File logDir;
            Level logLevel;
            String database = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
            String logLevelVal = info.getProperty(MongoJDBCProperty.LOG_LEVEL.getPropertyName(), Level.OFF.getName());
            try {
                logLevel = Level.parse(logLevelVal.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_LEVEL.getPropertyName() + " property value : " + logLevelVal + ". Valid values are : " + LEVELS + ".");
            }
            String logDirVal = info.getProperty(MongoJDBCProperty.LOG_DIR.getPropertyName());
            if (logDirVal != null && LOG_TO_CONSOLE.equalsIgnoreCase(logDirVal.trim())) {
                logDirVal = null;
            }
            File file = logDir = logDirVal == null ? null : new File(logDirVal);
            if (logDir != null && !logDir.isDirectory()) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_DIR.getPropertyName() + " property value : " + logDirVal + ". It must be a directory.");
            }
            String clientInfo = info.getProperty(MongoJDBCProperty.CLIENT_INFO.getPropertyName());
            if (clientInfo != null && clientInfo.split("\\+").length != 2) {
                throw new SQLException("Invalid " + MongoJDBCProperty.CLIENT_INFO.getPropertyName() + " property value : " + clientInfo + ". Expected format <name>+<version>.");
            }
            String extJsonModeVal = info.getProperty(MongoJDBCProperty.EXT_JSON_MODE.getPropertyName());
            boolean extJsonMode = false;
            if (extJsonModeVal != null) {
                if ((extJsonModeVal = extJsonModeVal.toUpperCase().trim()) == EXTENDED) {
                    extJsonMode = true;
                } else if (extJsonModeVal != RELAXED) {
                    throw new SQLException("Invalid JSON mode: " + extJsonModeVal);
                }
            }
            MongoConnectionProperties mongoConnectionProperties = new MongoConnectionProperties(cs, database, logLevel, logDir, clientInfo, extJsonMode);
            return new MongoConnection(mongoConnectionProperties);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        try {
            return url.startsWith(MONGODB_URL_PREFIX) || url.startsWith(MONGODB_SRV_URL_PREFIX);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            Pair<ConnectionString, DriverPropertyInfo[]> p = MongoDriver.getConnectionSettings(url, info);
            return p.right();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public int getMajorVersion() {
        try {
            return 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    private static String removePrefix(String prefix, String s2) {
        if (s2 != null && prefix != null && s2.startsWith(prefix)) {
            return s2.substring(prefix.length());
        }
        return s2;
    }

    public static Pair<ConnectionString, DriverPropertyInfo[]> getConnectionSettings(String url, Properties info) throws SQLException {
        ConnectionString originalConnectionString;
        if (info == null) {
            info = new Properties();
        }
        String actualURL = MongoDriver.removePrefix(JDBC, url);
        try {
            originalConnectionString = new ConnectionString(actualURL);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        ParseResult result = MongoDriver.normalizeConnectionOptions(originalConnectionString, info);
        String user = result.user;
        char[] password = result.password;
        ArrayList<DriverPropertyInfo> mandatoryConnectionProperties = new ArrayList<DriverPropertyInfo>();
        if ((!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) && originalConnectionString.getDatabase() != null) {
            info.setProperty(MongoJDBCProperty.DATABASE.getPropertyName(), originalConnectionString.getDatabase());
        }
        if (!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(MongoJDBCProperty.DATABASE.getPropertyName(), null));
        }
        String authDatabase = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
        if (user == null && password != null) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(USER, null));
        }
        if (password == null && user != null) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(PASSWORD, null));
        }
        if (mandatoryConnectionProperties.size() > 0) {
            return new Pair<Object, DriverPropertyInfo[]>(null, mandatoryConnectionProperties.toArray(new DriverPropertyInfo[mandatoryConnectionProperties.size()]));
        }
        ConnectionString c = new ConnectionString(MongoDriver.buildNewURI(originalConnectionString.getHosts(), user, password, authDatabase, result.normalizedOptions));
        return new Pair<ConnectionString, DriverPropertyInfo[]>(c, new DriverPropertyInfo[0]);
    }

    private static ParseResult normalizeConnectionOptions(ConnectionString clientURI, Properties info) throws SQLException {
        char[] propertyPWD;
        if (info == null) {
            info = new Properties();
        }
        NullCoalesce<String> s2 = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        NullCoalesce<char[]> c = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        String uriUser = clientURI.getUsername();
        char[] uriPWD = clientURI.getPassword();
        String propertyUser = info.getProperty(USER);
        String propertyPWDStr = info.getProperty(PASSWORD);
        char[] cArray = propertyPWD = propertyPWDStr != null ? propertyPWDStr.toCharArray() : null;
        if (uriUser != null && propertyUser != null && !uriUser.equals(propertyUser)) {
            throw new SQLException("uri and properties disagree on user: '" + uriUser + ", and " + propertyUser + " respectively");
        }
        String user = s2.coalesce(uriUser, propertyUser);
        if (user != null) {
            info.setProperty(USER, user);
        }
        if (uriPWD != null && propertyPWD != null && !Arrays.equals(uriPWD, propertyPWD)) {
            throw new SQLException("uri and properties disagree on password");
        }
        char[] password = c.coalesce(uriPWD, propertyPWD);
        String optionString = null;
        String[] optionSplit = clientURI.getConnectionString().split("[?]");
        if (optionSplit.length > 1) {
            optionString = optionSplit[1];
        }
        Properties options = new Properties();
        if (optionString != null) {
            String[] optionStrs;
            String[] stringArray = optionStrs = optionString.split("&");
            int n = optionStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String optionStr = stringArray[n2];
                String[] kv = optionStr.split("=");
                if (kv.length != 2) {
                    throw new SQLException("Option String is not valid");
                }
                String normalizedKey = kv[0].toLowerCase();
                if (!normalizedKey.equals(USER) && !normalizedKey.equals(PASSWORD)) {
                    options.put(normalizedKey, kv[1]);
                }
                ++n2;
            }
        }
        for (String key : info.stringPropertyNames()) {
            String normalizedKey = key.toLowerCase();
            if (normalizedKey.equals(USER) || normalizedKey.equals(PASSWORD)) continue;
            String val = info.getProperty(key);
            if (options.containsKey(normalizedKey)) {
                if (options.getProperty(normalizedKey).equals(val)) continue;
                throw new SQLException("uri and properties disagree on " + key);
            }
            options.setProperty(normalizedKey, val);
        }
        return new ParseResult(user, password, options);
    }

    private static String sqlURLEncode(String item) throws SQLException {
        try {
            return URLEncoder.encode(item, "utf-8");
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static boolean isMongoJDBCProperty(String key) {
        return Stream.of(MongoJDBCProperty.values()).anyMatch(v -> v.getPropertyName().equalsIgnoreCase(key));
    }

    private static String buildNewURI(List<String> hosts, String user, char[] password, String authDatabase, Properties options) throws SQLException {
        String ret = "mongodb://";
        if (user != null) {
            ret = String.valueOf(ret) + MongoDriver.sqlURLEncode(user) + ":" + MongoDriver.sqlURLEncode(String.valueOf(password)) + "@";
        }
        ret = String.valueOf(ret) + String.join((CharSequence)",", hosts);
        ret = authDatabase != null ? String.valueOf(ret) + "/" + MongoDriver.sqlURLEncode(authDatabase) : String.valueOf(ret) + "/";
        StringBuilder buff = new StringBuilder();
        if (options != null) {
            for (String key : options.stringPropertyNames()) {
                if (key.equals(USER) || key.equals(PASSWORD) || MongoDriver.isMongoJDBCProperty(key)) continue;
                if (buff.length() > 0) {
                    buff.append("&");
                }
                try {
                    buff.append(key).append("=").append(URLEncoder.encode(options.getProperty(key), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e);
                }
            }
        }
        if (buff.length() > 0) {
            ret = String.valueOf(ret) + "?" + buff.toString();
        }
        return ret;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoDriver.java", MongoDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "java.sql.Connection"), 142);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUnvalidatedConnection", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "com.mongodb.jdbc.MongoConnection"), 170);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reportMissingProperties", "com.mongodb.jdbc.MongoDriver", "[Ljava.sql.DriverPropertyInfo;", "missingRequiredProperties", "", "java.lang.String"), 199);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createConnection", "com.mongodb.jdbc.MongoDriver", "com.mongodb.ConnectionString:java.util.Properties", "cs:info", "java.sql.SQLException", "com.mongodb.jdbc.MongoConnection"), 229);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "acceptsURL", "com.mongodb.jdbc.MongoDriver", "java.lang.String", "url", "java.sql.SQLException", "boolean"), 293);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyInfo", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "[Ljava.sql.DriverPropertyInfo;"), 298);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMajorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 305);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 310);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jdbcCompliant", "com.mongodb.jdbc.MongoDriver", "", "", "", "boolean"), 315);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentLogger", "com.mongodb.jdbc.MongoDriver", "", "", "java.sql.SQLFeatureNotSupportedException", "java.util.logging.Logger"), 322);
    }

    public static final class MongoJDBCProperty
    extends Enum<MongoJDBCProperty> {
        public static final /* enum */ MongoJDBCProperty DATABASE;
        public static final /* enum */ MongoJDBCProperty CLIENT_INFO;
        public static final /* enum */ MongoJDBCProperty LOG_LEVEL;
        public static final /* enum */ MongoJDBCProperty LOG_DIR;
        public static final /* enum */ MongoJDBCProperty EXT_JSON_MODE;
        private final String propertyName;
        private static final /* synthetic */ MongoJDBCProperty[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        static {
            MongoJDBCProperty.ajc$preClinit();
            DATABASE = new MongoJDBCProperty("database");
            CLIENT_INFO = new MongoJDBCProperty("clientinfo");
            LOG_LEVEL = new MongoJDBCProperty("loglevel");
            LOG_DIR = new MongoJDBCProperty("logdir");
            EXT_JSON_MODE = new MongoJDBCProperty("extjsonmode");
            ENUM$VALUES = new MongoJDBCProperty[]{DATABASE, CLIENT_INFO, LOG_LEVEL, LOG_DIR, EXT_JSON_MODE};
        }

        private MongoJDBCProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            try {
                return this.propertyName;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect((Object)this)) {
                    LoggingAspect.aspectOf((Object)this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        public static MongoJDBCProperty[] values() {
            MongoJDBCProperty[] mongoJDBCPropertyArray = ENUM$VALUES;
            int n = mongoJDBCPropertyArray.length;
            MongoJDBCProperty[] mongoJDBCPropertyArray2 = new MongoJDBCProperty[n];
            System.arraycopy(ENUM$VALUES, 0, mongoJDBCPropertyArray2, 0, n);
            return mongoJDBCPropertyArray2;
        }

        public static MongoJDBCProperty valueOf(String arg0) {
            return Enum.valueOf(MongoJDBCProperty.class, arg0);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("MongoDriver.java", MongoJDBCProperty.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyName", "com.mongodb.jdbc.MongoDriver$MongoJDBCProperty", "", "", "", "java.lang.String"), 74);
        }
    }

    private static interface NullCoalesce<T> {
        public T coalesce(T var1, T var2);
    }

    private static class ParseResult {
        String user;
        char[] password;
        Properties normalizedOptions;

        ParseResult(String u, char[] p, Properties options) {
            this.user = u;
            this.password = p;
            this.normalizedOptions = options;
        }
    }
}

