/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.anotheria.util.maven.MavenVersion;
import net.anotheria.webutils.util.VersionUtil;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.history.StatusUpdateHistoryRepository;
import org.moskito.control.core.notification.StatusChangeMailNotifier;
import org.moskito.control.core.updater.ApplicationStatusUpdater;
import org.moskito.control.core.updater.ChartDataUpdater;
import org.moskito.control.core.updater.ThresholdsUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartListener
implements ServletContextListener {
    private static Logger log = LoggerFactory.getLogger(StartListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        log.info("Starting up MoSKito Control...");
        ApplicationRepository.getInstance();
        log.info("ApplicationRepository loaded.");
        StatusUpdateHistoryRepository.getInstance();
        log.info("StatusUpdateHistoryRepository loaded.");
        StatusChangeMailNotifier.getInstance();
        log.info("StatusChangeMailNotifier loaded.");
        ApplicationStatusUpdater.getInstance();
        log.info("Application StatusResource Updater loaded.");
        ChartDataUpdater.getInstance();
        log.info("ChartData Updater loaded.");
        ThresholdsUpdater.getInstance();
        log.info("Thresholds Updater loaded.");
        String versionString = "unknown";
        try {
            MavenVersion appVersion = VersionUtil.getWebappVersion((ServletContext)servletContextEvent.getServletContext());
            versionString = appVersion.getVersion();
        }
        catch (Exception e) {
            log.warn("couldn't read version.");
        }
        servletContextEvent.getServletContext().setAttribute("moskito.control.version", (Object)versionString);
        log.info("MoSKito Control " + versionString + " started.");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

