/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.config;

import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.control.config.ApplicationConfig;
import org.moskito.control.config.ConnectorConfig;
import org.moskito.control.config.MoskitoControlConfiguration;
import org.moskito.control.config.UpdaterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="moskitocontrol", allfields=true)
public class MoskitoControlConfiguration {
    private static Logger log = LoggerFactory.getLogger(MoskitoControlConfiguration.class);
    @Configure
    private ApplicationConfig[] applications;
    @Configure
    private ConnectorConfig[] connectors;
    @Configure
    private int historyItemsAmount = 100;
    @Configure
    private int notificationsMutingTime;
    @Configure
    private UpdaterConfig statusUpdater = new UpdaterConfig(10, 60, 10);
    @Configure
    private UpdaterConfig chartsUpdater = new UpdaterConfig(5, 60, 40);
    @Configure
    private UpdaterConfig thresholdsUpdater = new UpdaterConfig(10, 60, 10);
    @Configure
    private String defaultApplication;
    @Configure
    private String defaultMessageSender;

    public static final MoskitoControlConfiguration getConfiguration() {
        return MoskitoControlConfigurationHolder.instance;
    }

    public static final MoskitoControlConfiguration loadConfiguration() {
        MoskitoControlConfiguration config = new MoskitoControlConfiguration();
        try {
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return config;
    }

    public ApplicationConfig getApplication(String name) {
        for (ApplicationConfig a : this.applications) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        throw new IllegalArgumentException("App with name " + name + " not found");
    }

    public ApplicationConfig[] getApplications() {
        return this.applications;
    }

    public void setApplications(ApplicationConfig[] applications) {
        this.applications = applications;
    }

    public ConnectorConfig[] getConnectors() {
        return this.connectors;
    }

    public void setConnectors(ConnectorConfig[] connectors) {
        this.connectors = connectors;
    }

    public int getHistoryItemsAmount() {
        return this.historyItemsAmount;
    }

    public void setHistoryItemsAmount(int historyItemsAmount) {
        this.historyItemsAmount = historyItemsAmount;
    }

    public int getNotificationsMutingTime() {
        return this.notificationsMutingTime;
    }

    public void setNotificationsMutingTime(int notificationsMutingTime) {
        this.notificationsMutingTime = notificationsMutingTime;
    }

    public UpdaterConfig getStatusUpdater() {
        return this.statusUpdater;
    }

    public void setStatusUpdater(UpdaterConfig statusUpdater) {
        this.statusUpdater = statusUpdater;
    }

    public UpdaterConfig getChartsUpdater() {
        return this.chartsUpdater;
    }

    public void setChartsUpdater(UpdaterConfig chartsUpdater) {
        this.chartsUpdater = chartsUpdater;
    }

    public UpdaterConfig getThresholdsUpdater() {
        return this.thresholdsUpdater;
    }

    public void setThresholdsUpdater(UpdaterConfig thresholdsUpdater) {
        this.thresholdsUpdater = thresholdsUpdater;
    }

    public String getDefaultApplication() {
        return this.defaultApplication == null ? "" : this.defaultApplication;
    }

    public void setDefaultApplication(String defaultApplication) {
        this.defaultApplication = defaultApplication;
    }

    public String getDefaultMessageSender() {
        return this.defaultMessageSender;
    }

    public void setDefaultMessageSender(String defaultMessageSender) {
        this.defaultMessageSender = defaultMessageSender;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

