/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.connectors;

import org.moskito.control.config.ConnectorConfig;
import org.moskito.control.config.MoskitoControlConfiguration;
import org.moskito.control.connectors.Connector;
import org.moskito.control.connectors.ConnectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorFactory {
    private static Logger log = LoggerFactory.getLogger(ConnectorFactory.class);

    public static Connector createConnector(ConnectorType type) {
        ConnectorConfig[] connectors;
        for (ConnectorConfig c : connectors = MoskitoControlConfiguration.getConfiguration().getConnectors()) {
            if (c.getType() != type) continue;
            String className = c.getClassName();
            try {
                Connector connector = (Connector)Class.forName(className).newInstance();
                return connector;
            }
            catch (ClassNotFoundException e) {
                log.error("createConnector(" + type + ")", (Throwable)e);
                throw new IllegalArgumentException("Can't create connector of type " + type, e);
            }
            catch (InstantiationException e) {
                log.error("createConnector(" + type + ")", (Throwable)e);
                throw new IllegalArgumentException("Can't create connector of type " + type, e);
            }
            catch (IllegalAccessException e) {
                log.error("createConnector(" + type + ")", (Throwable)e);
                throw new IllegalArgumentException("Can't create connector of type " + type, e);
            }
        }
        throw new IllegalArgumentException(type + " doesn't seem to be supported");
    }
}

