/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.connectors;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.util.StringUtils;
import org.moskito.control.connectors.Connector;
import org.moskito.control.connectors.ConnectorException;
import org.moskito.control.connectors.httputils.HttpHelper;
import org.moskito.control.connectors.parsers.ConnectorResponseParser;
import org.moskito.control.connectors.parsers.ConnectorResponseParsers;
import org.moskito.control.connectors.response.ConnectorAccumulatorResponse;
import org.moskito.control.connectors.response.ConnectorStatusResponse;
import org.moskito.control.connectors.response.ConnectorThresholdsResponse;
import org.moskito.control.core.HealthColor;
import org.moskito.control.core.status.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector
implements Connector {
    public static final String FILTER_MAPPING = "/moskito-control-agent/";
    public static final String OP_STATUS = "status";
    public static final String OP_ACCUMULATOR = "accumulator";
    public static final String OP_THRESHOLDS = "thresholds";
    private String location;
    private static Logger log = LoggerFactory.getLogger(HttpConnector.class);

    public void configure(String location) {
        this.location = location;
    }

    private void debugSaveContentToFile(String name, String content) {
        if (content == null) {
            return;
        }
        name = StringUtils.replace((String)name, (char)':', (char)'_');
        name = StringUtils.replace((String)name, (char)'/', (char)'_');
        name = StringUtils.replace((String)name, (char)'?', (char)'_');
        name = StringUtils.replace((String)name, (char)'&', (char)'_');
        try {
            FileOutputStream fOut = new FileOutputStream(name);
            fOut.write(content.getBytes("UTF-8"));
            fOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> getTargetData(String operation) throws IOException {
        String targetUrl = this.location;
        targetUrl = targetUrl.endsWith("/") ? targetUrl + FILTER_MAPPING.substring(1) : targetUrl + FILTER_MAPPING;
        if (!(targetUrl = targetUrl + operation).startsWith("http")) {
            targetUrl = "http://" + targetUrl;
        }
        log.debug("URL to Call " + targetUrl);
        String content = HttpHelper.getURLContent((String)targetUrl);
        this.debugSaveContentToFile(targetUrl, content);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            HashMap parsed = (HashMap)gson.fromJson(content, HashMap.class);
            return parsed;
        }
        catch (JsonSyntaxException e) {
            log.error("Can't parse status reply: " + content);
            throw new ConnectorException("Can't parse reply", (Throwable)e);
        }
    }

    public ConnectorStatusResponse getNewStatus() {
        try {
            HashMap data = this.getTargetData(OP_STATUS);
            ConnectorResponseParser parser = ConnectorResponseParsers.getParser((Map)data);
            ConnectorStatusResponse myResponse = parser.parseStatusResponse((Map)data);
            return myResponse;
        }
        catch (IOException e) {
            return new ConnectorStatusResponse(new Status(HealthColor.PURPLE, "Connection Error: " + e.getMessage()));
        }
    }

    public ConnectorThresholdsResponse getThresholds() {
        try {
            HashMap data = this.getTargetData(OP_THRESHOLDS);
            if (data == null) {
                return null;
            }
            ConnectorResponseParser parser = ConnectorResponseParsers.getParser((Map)data);
            ConnectorThresholdsResponse response = parser.parseThresholdsResponse((Map)data);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("Not yet handled", e);
        }
    }

    public ConnectorAccumulatorResponse getAccumulators(List<String> accumulatorNames) {
        String operation = OP_ACCUMULATOR;
        for (String a : accumulatorNames) {
            try {
                operation = operation + "/" + URLEncoder.encode(a, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("UTF-8 is not supported encoding, the world must have been broken apart - " + e.getMessage()));
            }
        }
        try {
            HashMap data = this.getTargetData(operation);
            if (data == null) {
                return null;
            }
            ConnectorResponseParser parser = ConnectorResponseParsers.getParser((Map)data);
            ConnectorAccumulatorResponse response = parser.parseAccumulatorResponse((Map)data);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("Not yet handled", e);
        }
    }
}

