/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.connectors.httputils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpHelper {
    private static HttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLContent(String url) throws IOException {
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        if (response.getStatusLine().getStatusCode() != 200) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            String string = new String(out.toByteArray(), Charset.forName("UTF-8"));
            return string;
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception ignored) {}
        }
    }

    static {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
    }
}

