/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.connectors.parsers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import org.moskito.control.connectors.parsers.ConnectorResponseParser;
import org.moskito.control.connectors.response.ConnectorAccumulatorResponse;
import org.moskito.control.connectors.response.ConnectorStatusResponse;
import org.moskito.control.connectors.response.ConnectorThresholdsResponse;
import org.moskito.control.core.HealthColor;
import org.moskito.control.core.accumulator.AccumulatorDataItem;
import org.moskito.control.core.status.Status;
import org.moskito.control.core.threshold.ThresholdDataItem;

public class V1Parser
implements ConnectorResponseParser {
    public ConnectorStatusResponse parseStatusResponse(Map serverReply) {
        Map reply = (Map)serverReply.get("reply");
        Status status = new Status();
        status.setHealth(HealthColor.valueOf((String)((String)reply.get("status"))));
        List thresholds = (List)reply.get("thresholds");
        for (Object t : thresholds) {
            Map messageMap = (Map)t;
            String message = messageMap.get("threshold") + ": " + messageMap.get("value");
            status.addMessage(message);
        }
        return new ConnectorStatusResponse(status);
    }

    public ConnectorAccumulatorResponse parseAccumulatorResponse(Map serverReply) {
        ConnectorAccumulatorResponse ret = new ConnectorAccumulatorResponse();
        Map reply = (Map)serverReply.get("reply");
        Set keys = reply.keySet();
        for (String key : keys) {
            Map mapForKey = (Map)reply.get(key);
            String name = (String)mapForKey.get("name");
            List items = (List)mapForKey.get("items");
            ArrayList<AccumulatorDataItem> parsedItems = new ArrayList<AccumulatorDataItem>();
            for (Map m : items) {
                AccumulatorDataItem item = new AccumulatorDataItem(((Double)m.get("timestamp")).longValue(), (String)m.get("value"));
                parsedItems.add(item);
            }
            ret.addDataLine(name, parsedItems);
        }
        return ret;
    }

    public ConnectorThresholdsResponse parseThresholdsResponse(Map serverReply) {
        LinkedList<ThresholdDataItem> items = new LinkedList<ThresholdDataItem>();
        List thresholdsReply = (List)serverReply.get("reply");
        for (Map replyItem : thresholdsReply) {
            ThresholdDataItem item = new ThresholdDataItem();
            item.setName((String)replyItem.get("name"));
            item.setStatus(HealthColor.getHealthColor((ThresholdStatus)ThresholdStatus.valueOf((String)((String)replyItem.get("status")))));
            item.setLastValue((String)replyItem.get("lastValue"));
            item.setStatusChangeTimestamp(((Double)replyItem.get("statusChangeTimestamp")).longValue());
            items.add(item);
        }
        return new ConnectorThresholdsResponse(items);
    }
}

