/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core;

import java.util.LinkedList;
import java.util.List;
import org.moskito.control.core.Component;
import org.moskito.control.core.HealthColor;
import org.moskito.control.core.chart.Chart;

public class Application
implements Comparable<Application> {
    private String name;
    private List<Component> components = new LinkedList();
    private List<Chart> charts = new LinkedList();
    private long lastStatusUpdaterRun;
    private long lastChartUpdaterRun;
    private long lastThresholdsUpdaterRun;
    private long lastStatusUpdaterSuccess;
    private long lastChartUpdaterSuccess;
    private long lastThresholdsUpdaterSuccess;
    private long statusUpdaterRunCount;
    private long chartUpdaterRunCount;
    private long thresholdsUpdaterRunCount;
    private long statusUpdaterSuccessCount;
    private long chartUpdaterSuccessCount;
    private long thresholdsUpdaterSuccessCount;

    public Application() {
    }

    public Application(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastStatusUpdaterRun() {
        return this.lastStatusUpdaterRun;
    }

    public void setLastStatusUpdaterRun(long lastStatusUpdaterRun) {
        ++this.statusUpdaterRunCount;
        this.lastStatusUpdaterRun = lastStatusUpdaterRun;
    }

    public long getLastChartUpdaterRun() {
        return this.lastChartUpdaterRun;
    }

    public void setLastChartUpdaterRun(long lastChartUpdaterRun) {
        ++this.chartUpdaterRunCount;
        this.lastChartUpdaterRun = lastChartUpdaterRun;
    }

    public long getLastThresholdsUpdaterRun() {
        return this.lastThresholdsUpdaterRun;
    }

    public void setLastThresholdsUpdaterRun(long lastThresholdsUpdaterRun) {
        ++this.thresholdsUpdaterRunCount;
        this.lastThresholdsUpdaterRun = lastThresholdsUpdaterRun;
    }

    public long getLastStatusUpdaterSuccess() {
        return this.lastStatusUpdaterSuccess;
    }

    public void setLastStatusUpdaterSuccess(long lastStatusUpdaterSuccess) {
        ++this.statusUpdaterSuccessCount;
        this.lastStatusUpdaterSuccess = lastStatusUpdaterSuccess;
    }

    public long getLastChartUpdaterSuccess() {
        return this.lastChartUpdaterSuccess;
    }

    public void setLastChartUpdaterSuccess(long lastChartUpdaterSuccess) {
        ++this.chartUpdaterSuccessCount;
        this.lastChartUpdaterSuccess = lastChartUpdaterSuccess;
    }

    public long getLastThresholdsUpdaterSuccess() {
        return this.lastThresholdsUpdaterSuccess;
    }

    public void setLastThresholdsUpdaterSuccess(long lastThresholdsUpdaterSuccess) {
        ++this.thresholdsUpdaterSuccessCount;
        this.lastThresholdsUpdaterSuccess = lastThresholdsUpdaterSuccess;
    }

    public HealthColor getWorstHealthStatus() {
        HealthColor ret = HealthColor.GREEN;
        for (Component c : this.components) {
            if (!c.getHealthColor().isWorse(ret)) continue;
            ret = c.getHealthColor();
        }
        return ret;
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public Component getComponent(String name) {
        for (Component c : this.components) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        throw new IllegalArgumentException("Component " + name + " is not known");
    }

    public List<Chart> getCharts() {
        return this.charts;
    }

    public void setCharts(List<Chart> charts) {
        this.charts = charts;
    }

    public void addChart(Chart c) {
        this.charts.add(c);
    }

    public long getStatusUpdaterRunCount() {
        return this.statusUpdaterRunCount;
    }

    public long getChartUpdaterRunCount() {
        return this.chartUpdaterRunCount;
    }

    public long getThresholdsUpdaterRunCount() {
        return this.thresholdsUpdaterRunCount;
    }

    public long getStatusUpdaterSuccessCount() {
        return this.statusUpdaterSuccessCount;
    }

    public long getChartUpdaterSuccessCount() {
        return this.chartUpdaterSuccessCount;
    }

    public long getThresholdsUpdaterSuccessCount() {
        return this.thresholdsUpdaterSuccessCount;
    }

    @Override
    public int compareTo(Application o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return this.name;
    }
}

