/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceListener;
import org.configureme.sources.ConfigurationSourceRegistry;
import org.moskito.control.config.ApplicationConfig;
import org.moskito.control.config.ChartLineConfig;
import org.moskito.control.config.ComponentConfig;
import org.moskito.control.config.MoskitoControlConfiguration;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.Component;
import org.moskito.control.core.chart.Chart;
import org.moskito.control.core.status.StatusChangeEvent;
import org.moskito.control.core.status.StatusChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ApplicationRepository {
    private ConcurrentMap<String, Application> applications;
    private List<StatusChangeListener> statusChangeListeners = new CopyOnWriteArrayList();
    private static Logger log = LoggerFactory.getLogger(ApplicationRepository.class);

    public static final ApplicationRepository getInstance() {
        return ApplicationRepositoryInstanceHolder.access$000();
    }

    private ApplicationRepository() {
        this.applications = new ConcurrentHashMap();
        this.readConfig();
        ConfigurationSourceKey sourceKey = new ConfigurationSourceKey(ConfigurationSourceKey.Type.FILE, ConfigurationSourceKey.Format.JSON, "moskitocontrol");
        ConfigurationSourceRegistry.INSTANCE.addListener(sourceKey, (ConfigurationSourceListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void readConfig() {
        ApplicationConfig[] configuredApplications;
        this.applications.clear();
        for (ApplicationConfig ac : configuredApplications = MoskitoControlConfiguration.getConfiguration().getApplications()) {
            Application app = new Application(ac.getName());
            for (ComponentConfig componentConfig : ac.getComponents()) {
                Component comp = new Component(app);
                comp.setCategory(componentConfig.getCategory());
                comp.setName(componentConfig.getName());
                app.addComponent(comp);
            }
            if (ac.getCharts() != null && ac.getCharts().length > 0) {
                for (ComponentConfig componentConfig : ac.getCharts()) {
                    ChartLineConfig[] lines;
                    Chart chart = new Chart(app, componentConfig.getName(), componentConfig.getLimit());
                    for (ChartLineConfig line : lines = componentConfig.getLines()) {
                        chart.addLine(line.getComponent(), line.getAccumulator(), line.getCaption());
                    }
                    app.addChart(chart);
                }
            }
            this.addApplication(app);
        }
    }

    private void addApplication(Application app) {
        this.applications.put(app.getName(), app);
    }

    public List<Application> getApplications() {
        ArrayList<Application> ret = new ArrayList<Application>();
        ret.addAll(this.applications.values());
        return ret;
    }

    public Application getApplication(String applicationName) {
        return (Application)this.applications.get(applicationName);
    }

    public void addStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.statusChangeListeners.add(statusChangeListener);
    }

    public void removeStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.statusChangeListeners.remove(statusChangeListener);
    }

    public void addStatusChange(StatusChangeEvent event) {
        log.debug("addStatusChange(" + event + ")");
        for (StatusChangeListener listener : this.statusChangeListeners) {
            try {
                listener.notifyStatusChange(event);
            }
            catch (Exception e) {
                log.warn("Status change listener " + listener + " couldn't update status", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ void access$200(ApplicationRepository x0) {
        x0.readConfig();
    }
}

