/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.control.core;

import java.util.LinkedList;
import java.util.List;
import org.moskito.control.core.Application;
import org.moskito.control.core.ApplicationRepository;
import org.moskito.control.core.HealthColor;
import org.moskito.control.core.status.Status;
import org.moskito.control.core.status.StatusChangeEvent;
import org.moskito.control.core.threshold.ThresholdDataItem;

public class Component
implements Cloneable {
    private String name;
    private String category;
    private Status status;
    private List<ThresholdDataItem> thresholds = new LinkedList();
    private long lastUpdateTimestamp;
    private Application parent;

    public Component(Application aParent) {
        this.parent = aParent;
        this.status = new Status(HealthColor.NONE, "None yet");
    }

    public HealthColor getHealthColor() {
        return this.status.getHealth();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        Status oldStatus = this.status;
        this.status = status;
        if (oldStatus.getHealth() != status.getHealth()) {
            StatusChangeEvent event = new StatusChangeEvent(this.parent, this, oldStatus, status, this.lastUpdateTimestamp);
            ApplicationRepository.getInstance().addStatusChange(event);
        }
    }

    public List<ThresholdDataItem> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<ThresholdDataItem> thresholds) {
        this.thresholds = thresholds;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    protected Component clone() {
        try {
            return (Component)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"can't happen");
        }
    }

    public String toString() {
        return this.name;
    }
}

